<?php

namespace Database\Seeders;

use App\Models\Hamlet;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;

class HamletSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = Faker::create('id_ID');
        $tenant = DB::table('teams')->first();

        if (!$tenant) {
            $this->command->info('Tenant tidak ditemukan. Seeder hamlets dibatalkan.');
            return;
        }

        // Buat 3 Dusun dengan nama random
        for ($i = 1; $i <= 3; $i++) {
            Hamlet::updateOrCreate(
                [
                    'team_id' => $tenant->id,
                    'name'    => "Dusun " . $faker->lastName, // contoh: Dusun Wijaya, Dusun Saputra
                ],
                [
                    'head_id'    => null,
                    'description' => "Wilayah " . $faker->city,
                    'created_by' => null,
                    'updated_by' => null,
                ]
            );
        }

        $this->command->info('3 Dusun dengan nama acak berhasil dibuat untuk desa.');
    }
}
