<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BusinessTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $types = [
            ['name' => 'PERDAGANGAN', 'description' => 'Usaha jual beli barang kebutuhan masyarakat'],
            ['name' => 'JASA KEUANGAN', 'description' => 'Simpan pinjam, layanan keuangan mikro'],
            ['name' => 'PERTANIAN & PERKEBUNAN', 'description' => 'Pengelolaan hasil tani, perkebunan'],
            ['name' => 'PETERNAKAN & PERIKANAN', 'description' => 'Usaha hewan ternak dan perikanan'],
            ['name' => 'PARIWISATA', 'description' => 'Wisata desa, homestay, destinasi lokal'],
            ['name' => 'JASA TRANSPORTASI', 'description' => 'Angkutan desa, sewa kendaraan'],
            ['name' => 'INDUSTRI KREATIF', 'description' => 'Kerajinan, kuliner, produk kreatif'],
            ['name' => 'LAINNYA', 'description' => 'Bidang usaha lain sesuai potensi desa yang sah dan tidak bertentangan dengan peraturan perundang-undangan'],
        ];

        DB::table('business_types')->insert($types);
    }
}
