<?php

namespace Database\Seeders;

use App\Models\BusinessTransactionType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BusinessTransactionTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $types = [
            // INCOME
            ['team_id' => 1, 'type' => 'INCOME', 'name' => 'MODAL DARI DESA'],
            ['team_id' => 1, 'type' => 'INCOME', 'name' => 'MODAL DARI MASYARAKAT'],
            ['team_id' => 1, 'type' => 'INCOME', 'name' => 'HASIL PENJUALAN BARANG'],
            ['team_id' => 1, 'type' => 'INCOME', 'name' => 'HASIL PENJUALAN JASA'],
            ['team_id' => 1, 'type' => 'INCOME', 'name' => 'PENDAPATAN LAIN-LAIN'],

            // EXPENSE
            ['team_id' => 1, 'type' => 'EXPENSE', 'name' => 'GAJI/PENGURUS'],
            ['team_id' => 1, 'type' => 'EXPENSE', 'name' => 'BIAYA OPERASIONAL'],
            ['team_id' => 1, 'type' => 'EXPENSE', 'name' => 'PEMBELIAN BARANG DAGANG'],
            ['team_id' => 1, 'type' => 'EXPENSE', 'name' => 'BIAYA ADMINISTRASI'],
            ['team_id' => 1, 'type' => 'EXPENSE', 'name' => 'BAGI HASIL'],
            ['team_id' => 1, 'type' => 'EXPENSE', 'name' => 'PENGELUARAN LAIN-LAIN'],
        ];

        foreach ($types as $type) {
            BusinessTransactionType::create($type);
        }
    }
}
