<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BuildingTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $types = [
            'RUMAH',
            'KONTRAKAN / KOS',
            'TOKO / KIOS',
            'GUDANG',
            'MASJID',
            'SEKOLAH',
            'PUSKESMAS / KLINIK',
            'BALAI DESA / KANTOR',
            'BENGKEL',
            'LAINNYA',
        ];

        foreach ($types as $name) {
            DB::table('building_types')->insert([
                'team_id'  => 1,
                'name'       => strtoupper($name),
            ]);
        }
    }
}
