<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('complaints', function (Blueprint $table) {
            $table->id();
            $table->foreignId('team_id')->constrained('teams')->cascadeOnDelete();
            $table->string('code')->unique()->nullable(); // kode unik aduan
            $table->foreignId('resident_id')->constrained('residents'); // relasi ke warga
            $table->string('title');
            $table->text('description');
            $table->json('attachment')->nullable(); // file bukti/lampiran
            $table->tinyInteger('status')->default(0)
                ->comment('0=submitted,1=processed,2=completed,3=rejected');
            $table->timestamps();
            $table->softDeletes();
            // Blameable
            $table->foreignId('created_by')->nullable()->constrained('users');
            $table->foreignId('updated_by')->nullable()->constrained('users');
            $table->foreignId('deleted_by')->nullable()->constrained('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('complaints');
    }
};
