<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('outgoing_letters', function (Blueprint $table) {
            $table->id();
            $table->foreignId('team_id')->constrained('teams')->cascadeOnDelete();
            $table->string('letter_number')->nullable();
            $table->date('letter_date')->nullable();

            // Tujuan / penerima
            $table->string('recipient_name')->nullable();
            $table->text('recipient_address')->nullable();

            // Relasi opsional ke type / request (nanti bisa diisi)
            $table->foreignId('letter_type_id')->nullable()->constrained('letter_types')->cascadeOnDelete();
            $table->foreignId('letter_request_id')->nullable()->constrained('letter_requests')->cascadeOnDelete();

            // Konten & lampiran
            $table->string('subject')->nullable();
            $table->longText('content')->nullable(); // bisa richtext (html)
            $table->json('attachments')->nullable(); // simpan array file paths / meta

            // Status workflow
            $table->tinyInteger('status')->default(0);

            $table->timestamps();
            $table->softDeletes();

            // Blameable
            $table->foreignId('created_by')->nullable()->constrained('users');
            $table->foreignId('updated_by')->nullable()->constrained('users');
            $table->foreignId('deleted_by')->nullable()->constrained('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('outgoing_letters');
    }
};
