<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('incoming_letters', function (Blueprint $table) {
            $table->id();
            $table->foreignId('team_id')->constrained('teams')->cascadeOnDelete();
            $table->string('letter_number')->nullable(); // Nomor surat dari pengirim
            $table->date('letter_date')->nullable(); // Tanggal surat
            $table->date('received_date')->nullable(); // Tanggal diterima
            $table->string('origin')->nullable(); // Asal surat
            $table->string('subject')->nullable(); // Perihal
            $table->json('attachments')->nullable(); // Lampiran (scan/file)

            $table->timestamps();
            $table->softDeletes();

            // Blameable
            $table->foreignId('created_by')->nullable()->constrained('users');
            $table->foreignId('updated_by')->nullable()->constrained('users');
            $table->foreignId('deleted_by')->nullable()->constrained('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('incoming_letters');
    }
};
