<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Provinces
        Schema::create('provinces', function (Blueprint $table) {
            $table->char('id', 2)->primary(); // kode 2 digit
            $table->string('name');
            $table->timestamps();
        });

        // Regencies (Kabupaten/Kota)
        Schema::create('regencies', function (Blueprint $table) {
            $table->char('id', 4)->primary(); // kode 4 digit
            $table->char('province_id', 2);
            $table->string('name');
            $table->timestamps();

            $table->foreign('province_id')->references('id')->on('provinces')->cascadeOnDelete();
        });

        // Districts (Kecamatan)
        Schema::create('districts', function (Blueprint $table) {
            $table->char('id', 6)->primary(); // kode 6 digit
            $table->char('regency_id', 4);
            $table->string('name');
            $table->timestamps();

            $table->foreign('regency_id')->references('id')->on('regencies')->cascadeOnDelete();
        });

        // Villages (Kelurahan/Desa)
        Schema::create('villages', function (Blueprint $table) {
            $table->char('id', 10)->primary(); // kode 10-13 digit (maksimal)
            $table->char('district_id', 6);
            $table->string('name');
            $table->timestamps();

            $table->foreign('district_id')->references('id')->on('districts')->cascadeOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('villages');
        Schema::dropIfExists('districts');
        Schema::dropIfExists('regencies');
        Schema::dropIfExists('provinces');
    }
};
