<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Filament\Models\Contracts\HasName;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Team extends Model implements HasName
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'village_id',
        'address',
        'logo',
        'subdomain',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    // Relasi ke master village
    public function village()
    {
        return $this->belongsTo(Village::class);
    }

    public function users(): HasMany
    {
        return $this->hasMany(User::class);
    }

    public function getFilamentName(): string
    {
        return $this->village->name ?? 'Desa';
    }

    public function getCurrentTenantLabel(): string
    {
        return 'Desa aktif';
    }
}
