<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Hamlet extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'name',
        'description',
        'head_id',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    public $casts = [
        'team_id' => 'integer',
        'head_id' => 'integer',
    ];

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function head()
    {
        return $this->belongsTo(Resident::class, 'head_id');
    }

    public function communities()
    {
        return $this->hasMany(Community::class);
    }

    public function residents()
    {
        return $this->hasMany(Resident::class);
    }
}
