<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ComplaintHistory extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'complaint_id',
        'status',
        'note',
    ];

    public function complaint()
    {
        return $this->belongsTo(Complaint::class);
    }
}
