<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BuildingElement extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'building_id',
        'wall',
        'roof',
        'floor',
        'door',
        'window',
        'area',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    public function building()
    {
        return $this->belongsTo(Building::class);
    }
}
