<?php

namespace App\Filament\Widgets;

use App\Models\Resident;
use Filament\Widgets\ChartWidget;

class OccupationChart extends ChartWidget
{
    protected static ?int $sort = 6;
    protected ?string $maxHeight = '250px';

    protected function getData(): array
    {
        $data = Resident::selectRaw('occupation_id, COUNT(*) as total')
            ->with('occupation')
            ->groupBy('occupation_id')
            ->orderByDesc('total')
            ->take(10)
            ->get();

        $labels = $data->map(fn($item) => $item->occupation?->name ?? 'Unknown');
        $totals = $data->pluck('total');

        $backgroundColors = [
            '#60A5FA', // blue-400
            '#34D399', // green-400
            '#FBBF24', // amber-400
            '#F87171', // red-400
            '#A78BFA', // violet-400
            '#F472B6', // pink-400
            '#4ADE80', // lime-400
            '#38BDF8', // sky-400
            '#FB923C', // orange-400
            '#94A3B8', // slate-400
        ];

        $backgroundColors = array_slice($backgroundColors, 0, $labels->count());

        return [
            'datasets' => [
                [
                    'label' => 'Total Warga',
                    'data' => $totals,
                    'backgroundColor' => $backgroundColors,
                    'borderWidth' => 0,
                ],
            ],
            'labels' => $labels,
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }

    protected function getOptions(): array
    {
        return [
            'indexAxis' => 'y',
            'plugins' => [
                'legend' => [
                    'display' => false,
                ],
                'tooltip' => [
                    'enabled' => true,
                ],
            ],
            'scales' => [
                'x' => [
                    'beginAtZero' => true,
                    'ticks' => [
                        'precision' => 0,
                    ],
                ],
            ],
        ];
    }
}
