<?php

namespace App\Filament\Resources\Users\Schemas;

use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class UserForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->label('Name')
                    ->required()
                    ->maxLength(255),

                TextInput::make('email')
                    ->label('Email')
                    ->email()
                    ->required()
                    ->unique(ignoreRecord: true),

                TextInput::make('password')
                    ->label('Password')
                    ->placeholder('Enter your password')
                    ->password()
                    ->dehydrateStateUsing(fn($state) => filled($state) ? bcrypt($state) : null)
                    ->required(fn(string $context): bool => $context === 'create'),

                TextInput::make('password_confirmation')
                    ->label('Confirm Password')
                    ->placeholder('Re-enter your password')
                    ->password()
                    ->dehydrateStateUsing(fn($state, $set) => $set('password_confirmation', $state))
                    ->required(fn(string $context): bool => $context === 'create')
                    ->same('password'),
            ]);
    }
}
