<?php

namespace App\Filament\Resources\NeighborhoodTransactions\Widgets;

use App\Models\NeighborhoodTransaction;
use Filament\Widgets\StatsOverviewWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class NeighborhoodFinanceStats extends StatsOverviewWidget
{
    protected function getStats(): array
    {
        return [
            Stat::make('Total Income', 'Rp ' . number_format(NeighborhoodTransaction::totalIncome(), 0, ',', '.'))
                ->description('Total pemasukan')
                ->descriptionIcon('heroicon-m-arrow-trending-up')
                ->color('success'),

            Stat::make('Total Expense', 'Rp ' . number_format(NeighborhoodTransaction::totalExpense(), 0, ',', '.'))
                ->description('Total pengeluaran')
                ->descriptionIcon('heroicon-m-arrow-trending-down')
                ->color('danger'),

            Stat::make('Balance', 'Rp ' . number_format(NeighborhoodTransaction::balance(), 0, ',', '.'))
                ->description('Saldo saat ini')
                ->descriptionIcon('heroicon-m-banknotes')
                ->color(NeighborhoodTransaction::balance() >= 0 ? 'primary' : 'warning'),
        ];
    }
}
