<?php

namespace App\Filament\Resources\NeighborhoodTransactions\Pages;

use App\Filament\Resources\NeighborhoodTransactions\NeighborhoodTransactionResource;
use App\Filament\Resources\NeighborhoodTransactions\Widgets\NeighborhoodFinanceStats;
use Filament\Actions\CreateAction;
use Filament\Resources\Pages\ListRecords;

class ListNeighborhoodTransactions extends ListRecords
{
    protected static string $resource = NeighborhoodTransactionResource::class;

    protected function getHeaderActions(): array
    {
        return [
            CreateAction::make()
                ->label('Tambah Transaksi')
                ->modalWidth('md')
                ->icon('heroicon-o-plus')
                ->color('primary'),
        ];
    }

    protected function getHeaderWidgets(): array
    {
        return [
            NeighborhoodFinanceStats::class,
        ];
    }
}
