<?php

namespace App\Filament\Clusters\Regions\Resources\Hamlets\Schemas;

use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class HamletForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->label('Nama Dusun')
                    ->placeholder('Nama Dusun')
                    ->required()
                    ->columnSpan(1),
                Select::make('head_id')
                    ->label('Kepala Dusun')
                    ->relationship('head', 'name')
                    ->searchable()
                    ->preload()
                    ->nullable()
                    ->columnSpan(1),
                Textarea::make('description')
                    ->label('Deskripsi')
                    ->placeholder('Masukkan deskripsi dusun, misalnya luas wilayah, batas, atau keterangan lain')
                    ->nullable()
                    ->columnSpanFull(),
            ]);
    }
}
