<?php

namespace App\Filament\Clusters\Regions\Resources\Communities;

use App\Filament\Clusters\Regions\RegionsCluster;
use App\Filament\Clusters\Regions\Resources\Communities\Pages\CreateCommunity;
use App\Filament\Clusters\Regions\Resources\Communities\Pages\EditCommunity;
use App\Filament\Clusters\Regions\Resources\Communities\Pages\ListCommunities;
use App\Filament\Clusters\Regions\Resources\Communities\Pages\ViewCommunity;
use App\Filament\Clusters\Regions\Resources\Communities\Schemas\CommunityForm;
use App\Filament\Clusters\Regions\Resources\Communities\Schemas\CommunityInfolist;
use App\Filament\Clusters\Regions\Resources\Communities\Tables\CommunitiesTable;
use App\Models\Community;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class CommunityResource extends Resource
{
    protected static ?string $model = Community::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::Squares2x2;

    protected static ?string $cluster = RegionsCluster::class;

    protected static ?int $navigationSort = 2;
    protected static ?string $navigationLabel = 'Rukun Warga (RW)';
    protected static ?string $title = 'Rukun Warga (RW)';
    protected static ?string $breadcrumb = 'Rukun Warga (RW)';
    protected static ?string $pluralLabel = 'Rukun Warga (RW)';

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return CommunityForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return CommunityInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return CommunitiesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListCommunities::route('/'),
            // 'create' => CreateCommunity::route('/create'),
            // 'view' => ViewCommunity::route('/{record}'),
            // 'edit' => EditCommunity::route('/{record}/edit'),
        ];
    }
}
