<?php

namespace App\Filament\Clusters\Populations\Resources\Residents\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Text;
use Filament\Schemas\Schema;
use Filament\Support\Enums\FontWeight;
use Filament\Support\Enums\TextSize;

class ResidentForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                FileUpload::make('photo_path')
                    ->label('Foto Warga')
                    ->avatar()
                    ->directory('residents')
                    ->columnSpanFull()
                    ->nullable(),

                TextInput::make('nik')
                    ->label('NIK')
                    ->required()
                    ->maxLength(16)
                    ->minLength(16)
                    ->type('text')
                    ->rule('regex:/^\d{16}$/'),

                TextInput::make('name')
                    ->label('Nama Lengkap')
                    ->required()
                    ->maxLength(255),

                TextInput::make('birth_place')
                    ->label('Tempat Lahir')
                    ->required()
                    ->maxLength(255),

                DatePicker::make('birth_date')
                    ->label('Tanggal Lahir')
                    ->required()
                    ->maxDate(now()),

                Select::make('gender_id')
                    ->label('Jenis Kelamin')
                    ->relationship('gender', 'name')
                    ->required(),

                Select::make('religion_id')
                    ->label('Agama')
                    ->relationship('religion', 'name')
                    ->required(),

                Select::make('marital_status_id')
                    ->label('Status Perkawinan')
                    ->relationship('maritalStatus', 'name')
                    ->required(),

                Select::make('blood_type_id')
                    ->label('Golongan Darah')
                    ->relationship('bloodType', 'name')
                    ->required(),

                Text::make('Informasi Alamat')
                    ->size(TextSize::Large)
                    ->weight(FontWeight::Bold)
                    ->color('neutral')
                    ->columnSpanFull(),

                Textarea::make('address')
                    ->label('Alamat')
                    ->placeholder('Alamat lengkap rumah')
                    ->required()
                    ->columnSpanFull(),

                Select::make('neighborhood_id')
                    ->label('Nomor RT')
                    ->relationship('neighborhood', 'name')
                    ->required(),

                Text::make('Pendidikan & Pekerjaan')
                    ->size(TextSize::Large)
                    ->weight(FontWeight::Bold)
                    ->color('neutral')
                    ->columnSpanFull(),

                Select::make('education_id')
                    ->label('Pendidikan Terakhir')
                    ->relationship('education', 'name')
                    ->required(),

                Select::make('occupation_id')
                    ->label('Pekerjaan')
                    ->relationship('occupation', 'name')
                    ->required(),
            ]);
    }
}
