<?php

namespace App\Filament\Clusters\Populations\Resources\FamilyCards\Schemas;

use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class FamilyCardForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('number')
                    ->label('Nomor KK')
                    ->placeholder('Nomor Kartu Keluarga')
                    ->required()
                    ->maxLength(16)
                    ->minLength(16)
                    ->type('text')
                    ->rule('regex:/^\d{16}$/')
                    ->required(),
                Select::make('head_id')
                    ->relationship('head', 'name')
                    ->searchable()
                    ->preload()
                    ->nullable()
                    ->label('Kepala Keluarga'),
                Select::make('neighborhood_id')
                    ->relationship('neighborhood', 'name')
                    ->label('Nomor RT')
                    ->searchable()
                    ->preload()
                    ->required(),
                Textarea::make('address')
                    ->label('Alamat')
                    ->placeholder('Alamat lengkap rumah')
                    ->required()
                    ->columnSpanFull(),
            ]);
    }
}
