<?php

namespace App\Filament\Clusters\Letters\Resources\LetterRequests\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ForceDeleteBulkAction;
use Filament\Actions\RestoreBulkAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\TrashedFilter;
use Filament\Tables\Table;

class LetterRequestsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('type.name')
                    ->label('Jenis Surat')
                    ->searchable()
                    ->description(fn($record) => $record->request_number)
                    ->sortable(),

                TextColumn::make('resident.name')
                    ->label('Pemohon')
                    ->searchable()
                    ->description(fn($record) => $record->resident->nik)
                    ->sortable(),

                TextColumn::make('purpose')
                    ->label('Keperluan')
                    ->wrap()
                    ->searchable(),

                TextColumn::make('status')
                    ->label('Status')
                    ->badge()
                    ->formatStateUsing(fn($state) => match ($state) {
                        0 => 'Menunggu',
                        1 => 'Disetujui',
                        2 => 'Diproses',
                        3 => 'Selesai',
                        9 => 'Ditolak',
                        default => 'Tidak diketahui',
                    })
                    ->colors([
                        'warning' => 0, // Menunggu
                        'info' => 1, // Disetujui
                        'primary'    => 2, // Diproses
                        'success' => 3, // Selesai
                        'danger'  => 9, // Ditolak
                    ])
                    ->sortable(),

                TextColumn::make('created_at')
                    ->label('Dibuat')
                    ->dateTime('d M Y H:i'),
            ])
            ->filters([
                TrashedFilter::make(),
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                    ForceDeleteBulkAction::make(),
                    RestoreBulkAction::make(),
                ]),
            ]);
    }
}
