<?php

namespace App\Filament\Clusters\Letters\Resources\LetterRequests;

use App\Filament\Clusters\Letters\LettersCluster;
use App\Filament\Clusters\Letters\Resources\LetterRequests\Pages\CreateLetterRequest;
use App\Filament\Clusters\Letters\Resources\LetterRequests\Pages\EditLetterRequest;
use App\Filament\Clusters\Letters\Resources\LetterRequests\Pages\ListLetterRequests;
use App\Filament\Clusters\Letters\Resources\LetterRequests\Pages\ViewLetterRequest;
use App\Filament\Clusters\Letters\Resources\LetterRequests\Schemas\LetterRequestForm;
use App\Filament\Clusters\Letters\Resources\LetterRequests\Schemas\LetterRequestInfolist;
use App\Filament\Clusters\Letters\Resources\LetterRequests\Tables\LetterRequestsTable;
use App\Models\LetterRequest;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class LetterRequestResource extends Resource
{
    protected static ?string $model = LetterRequest::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedDocumentText;

    protected static ?string $cluster = LettersCluster::class;

    protected static ?int $navigationSort = 1;
    protected static ?string $navigationLabel = 'Permohonan Surat';
    protected static ?string $title = 'Permohonan Surat';
    protected static ?string $breadcrumb = 'Permohonan Surat';
    protected static ?string $pluralLabel = 'Permohonan Surat';

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return LetterRequestForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return LetterRequestInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return LetterRequestsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListLetterRequests::route('/'),
            // 'create' => CreateLetterRequest::route('/create'),
            // 'view' => ViewLetterRequest::route('/{record}'),
            // 'edit' => EditLetterRequest::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
