<?php

namespace App\Filament\Clusters\Letters\Resources\IncomingLetters\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class IncomingLetterForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('letter_number')
                    ->label('Nomor Surat')
                    ->placeholder('Nomor Surat')
                    ->required(),

                DatePicker::make('letter_date')
                    ->label('Tanggal Surat')
                    ->required(),

                DatePicker::make('received_date')
                    ->label('Tanggal Terima')
                    ->default(now())
                    ->required(),

                TextInput::make('origin')
                    ->label('Asal Surat')
                    ->placeholder('Asal Surat')
                    ->required(),

                TextInput::make('subject')
                    ->label('Perihal')
                    ->placeholder('Perihal Surat')
                    ->required(),

                FileUpload::make('attachments')
                    ->label('Lampiran')
                    ->multiple()
                    ->directory('incoming-letters')
                    ->downloadable()
                    ->openable()
                    ->required()
                    ->acceptedFileTypes(['application/pdf']),
            ]);
    }
}
