<?php

namespace App\Filament\Clusters\Business\Resources\BusinessTransactions\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class BusinessTransactionForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('business_unit_id')
                    ->relationship('unit', 'name')
                    ->label('Unit Usaha')
                    ->required(),

                Select::make('type')
                    ->label('Jenis Transaksi')
                    ->options([
                        'INCOME' => 'Pemasukan',
                        'EXPENSE' => 'Pengeluaran',
                    ])
                    ->required(),

                TextInput::make('description')
                    ->label('Deskripsi')
                    ->required()
                    ->maxLength(255),

                TextInput::make('amount')
                    ->label('Jumlah')
                    ->numeric()
                    ->required()
                    ->prefix('Rp'),

                DatePicker::make('transaction_date')
                    ->label('Tanggal')
                    ->required(),

                TextInput::make('reference_number')
                    ->label('Nomor Referensi')
                    ->maxLength(255),

                FileUpload::make('attachment')
                    ->label('Lampiran')
                    ->multiple()
                    ->openable()
                    ->downloadable()
                    ->previewable()
                    ->maxSize(10240)
                    ->directory('business-attachments')
                    ->columnSpanFull(),
            ]);
    }
}
