<?php

namespace App\Filament\Clusters\Business\Resources\BusinessTransactions;

use App\Filament\Clusters\Business\Business;
use App\Filament\Clusters\Business\Resources\BusinessTransactions\Pages\CreateBusinessTransaction;
use App\Filament\Clusters\Business\Resources\BusinessTransactions\Pages\EditBusinessTransaction;
use App\Filament\Clusters\Business\Resources\BusinessTransactions\Pages\ListBusinessTransactions;
use App\Filament\Clusters\Business\Resources\BusinessTransactions\Pages\ViewBusinessTransaction;
use App\Filament\Clusters\Business\Resources\BusinessTransactions\Schemas\BusinessTransactionForm;
use App\Filament\Clusters\Business\Resources\BusinessTransactions\Schemas\BusinessTransactionInfolist;
use App\Filament\Clusters\Business\Resources\BusinessTransactions\Tables\BusinessTransactionsTable;
use App\Models\BusinessTransaction;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class BusinessTransactionResource extends Resource
{
    protected static ?string $model = BusinessTransaction::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedCurrencyDollar;

    protected static ?string $cluster = Business::class;

    protected static ?int $navigationSort = 3;
    protected static ?string $navigationLabel = 'Keuangan';
    protected static ?string $title = 'Keuangan';
    protected static ?string $breadcrumb = 'Keuangan';
    protected static ?string $pluralLabel = 'Keuangan';

    protected static ?string $recordTitleAttribute = 'description';

    public static function form(Schema $schema): Schema
    {
        return BusinessTransactionForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return BusinessTransactionInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return BusinessTransactionsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListBusinessTransactions::route('/'),
            // 'create' => CreateBusinessTransaction::route('/create'),
            // 'view' => ViewBusinessTransaction::route('/{record}'),
            // 'edit' => EditBusinessTransaction::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
