<?php

namespace App\Filament\Clusters\Business\Pages;

use App\Filament\Clusters\Business\Business as BusinessCluster;
use App\Models\Business as BusinessModel;
use BackedEnum;
use Filament\Actions\Action;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Filament\Schemas\Components\Actions;
use Filament\Schemas\Components\Form;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;

class ManageBusinessProfile extends Page
{
    protected string $view = 'filament.clusters.business.pages.manage-business-profile';

    protected static ?string $cluster = BusinessCluster::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedBuildingStorefront;
    protected static ?string $title = 'Profile';
    protected static ?string $breadcrumb = 'Profile';
    protected static ?string $navigationLabel = 'Profile';
    protected static ?int $navigationSort = 1;

    /**
     * @var array<string, mixed> | null
     */
    public ?array $data = [];

    public function mount(): void
    {
        $this->form->fill($this->getRecord()?->attributesToArray());
    }

    public function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                Form::make([
                    TextInput::make('name')
                        ->label('Nama BUMDes')
                        ->required()
                        ->maxLength(255),

                    TextInput::make('decree_number')
                        ->label('Nomor SK')
                        ->maxLength(255),

                    DatePicker::make('decree_date')
                        ->label('Tanggal SK')
                        ->native(false)
                        ->displayFormat('d/m/Y'),

                    Select::make('legal_entity')
                        ->label('Badan Hukum')
                        ->options([
                            'PT' => 'PT',
                            'CV' => 'CV',
                            'COOPERATIVE' => 'Koperasi',
                            'FOUNDATION' => 'Yayasan',
                        ])
                        ->searchable(),

                    Textarea::make('address')
                        ->label('Alamat')
                        ->rows(3)
                        ->columnSpanFull(),

                    Toggle::make('is_active')
                        ->label('Aktif')
                        ->default(true),
                ])
                    ->livewireSubmitHandler('save')
                    ->footer([
                        Actions::make([
                            Action::make('save')
                                ->label('Simpan')
                                ->submit('save')
                                ->keyBindings(['mod+s']),
                        ]),
                    ]),
            ])
            ->record($this->getRecord())
            ->statePath('data');
    }

    public function save(): void
    {
        $data = $this->form->getState();

        $record = $this->getRecord() ?? new BusinessModel();
        $record->fill($data);
        $record->team_id = auth()->user()->team->id; // multi-tenant
        $record->save();

        if ($record->wasRecentlyCreated) {
            $this->form->record($record)->saveRelationships();
        }

        Notification::make()
            ->success()
            ->title('Profil BUMDes tersimpan')
            ->send();
    }

    public function getRecord(): ?BusinessModel
    {
        return BusinessModel::query()->first();
    }
}
