/*
BISMILLAAHIRRAHMAANIRRAHIIM - In the Name of Allah, Most Gracious, Most Merciful
================================================================================
filename : db/wilayah.sql
purpose  :
note     : Data Kode Wilayah sesuai Kepmendagri No 300.2.2-2138 Tahun 2025
create   : 2025-05-25 14:41:15
last edit: 2025-08-05 16:21:47
author   : cahya dsn
================================================================================
This program is free software; you can redistribute it and/or modify it under the
terms of the MIT License.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

See the MIT License for more details

copyright (c) 2025 by cahya dsn; cahyadsn@gmail.com
================================================================================*/
--
-- Table structure for table wilayah
--

DROP TABLE IF EXISTS wilayah;
CREATE TABLE IF NOT EXISTS wilayah (
    kode varchar(13) NOT NULL,
    nama varchar(100) NOT NULL,
    PRIMARY KEY (kode)
) ENGINE=MyISAM;
CREATE INDEX wilayah_name_idx ON wilayah (nama);

--
-- Dumping data for table wilayah
--

-- Provinsi ACEH
INSERT INTO wilayah (kode, nama)
VALUES
('11','Aceh'),
('11.01','Kabupaten Aceh Selatan'),
('11.01.01','Bakongan'),
('11.01.01.2001','Keude Bakongan'),
('11.01.01.2002','Ujong Mangki'),
('11.01.01.2003','Ujong Padang'),
('11.01.01.2004','Gampong Drien'),
('11.01.01.2015','Darul Ikhsan'),
('11.01.01.2016','Padang Beurahan'),
('11.01.01.2017','Gampong Baro'),
('11.01.02','Kluet Utara'),
('11.01.02.2001','Fajar Harapan'),
('11.01.02.2002','Krueng Batee'),
('11.01.02.2003','Pasi Kuala Asahan'),
('11.01.02.2004','Gunong Pulo'),
('11.01.02.2005','Pulo Ie I'),
('11.01.02.2006','Jambo Manyang'),
('11.01.02.2007','Simpang Empat'),
('11.01.02.2008','Limau Purut'),
('11.01.02.2009','Pulo Kambing'),
('11.01.02.2010','Kampung Paya'),
('11.01.02.2011','Krueng Batu'),
('11.01.02.2012','Krueng Kluet'),
('11.01.02.2013','Alur Mas'),
('11.01.02.2014','Kampung Tinggi'),
('11.01.02.2015','Ruak'),
('11.01.02.2016','Simpang Lhee'),
('11.01.02.2017','Suaq Geuringgeng'),
('11.01.02.2018','Pasi Kuala Ba''u'),
('11.01.02.2019','Kedai Padang'),
('11.01.02.2020','Kotafajar'),
('11.01.02.2021','Gunung Pudung'),
('11.01.03','Kluet Selatan'),
('11.01.03.2001','Suaq Bakung'),
('11.01.03.2002','Rantau Binuang'),
('11.01.03.2003','Barat Daya'),
('11.01.03.2004','Sialang'),
('11.01.03.2005','Kapeh'),
('11.01.03.2006','Pulo Ie'),
('11.01.03.2007','Kedai Runding'),
('11.01.03.2008','Kedai Kandang'),
('11.01.03.2009','Gampong Luar'),
('11.01.03.2010','Ujung'),
('11.01.03.2011','Jua'),
('11.01.03.2012','Pasi Meurapat'),
('11.01.03.2013','Ujung Pasir'),
('11.01.03.2014','Geulumbuk'),
('11.01.03.2015','Pasie Lembang'),
('11.01.03.2016','Ujung Padang'),
('11.01.03.2017','Indra Damai'),
('11.01.04','Labuhanhaji'),
('11.01.04.2001','Bakau Hulu'),
('11.01.04.2002','Padang Bakau'),
('11.01.04.2003','Manggis Harapan'),
('11.01.04.2004','Pasar Lama'),
('11.01.04.2005','Apha'),
('11.01.04.2006','Ujung Batu'),
('11.01.04.2007','Pawoh'),
('11.01.04.2008','Dalam'),
('11.01.04.2009','Kota Palak'),
('11.01.04.2010','Cacang'),
('11.01.04.2011','Tengah Pisang'),
('11.01.04.2012','Pisang'),
('11.01.04.2013','Hulu Pisang'),
('11.01.04.2014','Tengah Baru'),
('11.01.04.2015','Lembah Baru'),
('11.01.04.2016','Padang Baru'),
('11.01.05','Meukek'),
('11.01.05.2001','Kuta Buloh II'),
('11.01.05.2002','Kuta Buloh I'),
('11.01.05.2003','Ie Dingen'),
('11.01.05.2004','Drien Jalo'),
('11.01.05.2005','Jambo Papeun'),
('11.01.05.2006','Buket Meuh'),
('11.01.05.2007','Blang Kuala'),
('11.01.05.2008','Rot Teungoh'),
('11.01.05.2009','Alue Baro'),
('11.01.05.2010','Ladang Tuha'),
('11.01.05.2011','Lhok Mamplam'),
('11.01.05.2012','Arun Tunggai'),
('11.01.05.2013','Blang Teungoh'),
('11.01.05.2014','Blang Bladeh'),
('11.01.05.2015','Ie Buboh'),
('11.01.05.2016','Keude Meukek'),
('11.01.05.2017','Kuta Baro'),
('11.01.05.2018','Tanjung Harapan'),
('11.01.05.2019','Labuhan Tarok'),
('11.01.05.2020','Lhok Aman'),
('11.01.05.2021','Alue Meutuah'),
('11.01.05.2022','Ladang Baro'),
('11.01.05.2023','Labuhan Tarok II'),
('11.01.06','Samadua'),
('11.01.06.2001','Dalam'),
('11.01.06.2002','Subarang'),
('11.01.06.2003','Kuta Baru'),
('11.01.06.2004','Gunung Ketek'),
('11.01.06.2005','Ladang Panton Luas'),
('11.01.06.2006','Madat'),
('11.01.06.2007','Alur Seumerah'),
('11.01.06.2008','Tengah'),
('11.01.06.2009','Gunung Cut'),
('11.01.06.2010','Alur Pinang'),
('11.01.06.2011','Kuta Blang'),
('11.01.06.2012','Batee Tunggai'),
('11.01.06.2013','Ujung Tanah'),
('11.01.06.2014','Ujung Kampung'),
('11.01.06.2015','Jilatang'),
('11.01.06.2016','Luar'),
('11.01.06.2017','Lubuk Layu'),
('11.01.06.2018','Suaq Hulu'),
('11.01.06.2019','Tampang'),
('11.01.06.2020','Payonan Gadang'),
('11.01.06.2021','Gadang'),
('11.01.06.2022','Baru'),
('11.01.06.2023','Ladang Kasik Putih'),
('11.01.06.2024','Air Sialang Hilir'),
('11.01.06.2025','Air Sialang Hulu'),
('11.01.06.2026','Air Sialang Tengah'),
('11.01.06.2027','Balai'),
('11.01.06.2028','Arafah'),
('11.01.07','Sawang'),
('11.01.07.2001','Sikulat'),
('11.01.07.2002','Sawang I'),
('11.01.07.2003','Meuligo'),
('11.01.07.2004','Lhok Pawoh'),
('11.01.07.2005','Sawang II'),
('11.01.07.2006','Ujung Karang'),
('11.01.07.2007','Trieng Meuduro Baroh'),
('11.01.07.2008','Trieng Meuduro Tunong'),
('11.01.07.2009','Panton Luas'),
('11.01.07.2010','Simpang Tiga'),
('11.01.07.2011','Kuta Baro'),
('11.01.07.2012','Blang Geulinggang'),
('11.01.07.2013','Mutiara'),
('11.01.07.2014','Ujung Padang'),
('11.01.07.2015','Sawang Ba''u'),
('11.01.08','Tapaktuan'),
('11.01.08.2001','Lhok Keutapang'),
('11.01.08.2002','Hilir'),
('11.01.08.2003','Padang'),
('11.01.08.2004','Hulu'),
('11.01.08.2005','Jambo Apha'),
('11.01.08.2006','Tepi Air'),
('11.01.08.2007','Pasar'),
('11.01.08.2008','Lhok Bengkuang'),
('11.01.08.2009','Panton Luas'),
('11.01.08.2010','Gunung Kerambil'),
('11.01.08.2011','Air Berudang'),
('11.01.08.2012','Batu Itam'),
('11.01.08.2013','Panjupian'),
('11.01.08.2014','Lhok Rukam'),
('11.01.08.2015','Air Pinang'),
('11.01.08.2016','Lhok Bengkuang Timur'),
('11.01.09','Trumon'),
('11.01.09.2001','Keude Trumon'),
('11.01.09.2002','Ujong Tanoh'),
('11.01.09.2003','Sigleng'),
('11.01.09.2004','Ie Meudama'),
('11.01.09.2005','Teupin Tinggi'),
('11.01.09.2006','Kuta Baro'),
('11.01.09.2007','Panton Bilie'),
('11.01.09.2012','Kuta Padang'),
('11.01.09.2013','Raket'),
('11.01.09.2014','Gampong Teungoh'),
('11.01.09.2015','Seuneubok Jaya'),
('11.01.09.2016','Padang Harapan'),
('11.01.10','Pasie Raja'),
('11.01.10.2001','Ladang Teungoh'),
('11.01.10.2002','Pucok Krueng'),
('11.01.10.2003','Silolo'),
('11.01.10.2004','Kampung Baru'),
('11.01.10.2005','Panton Bili'),
('11.01.10.2006','Paya Ateuk'),
('11.01.10.2007','Ladang Tuha'),
('11.01.10.2008','Mata Ie'),
('11.01.10.2009','Ujong Batee'),
('11.01.10.2010','Lhok Sialang Cut'),
('11.01.10.2011','Seuneubok'),
('11.01.10.2012','Ie Mirah'),
('11.01.10.2013','Pasie Rasian'),
('11.01.10.2014','Ujung Padang Rasian'),
('11.01.10.2015','Krueng Kalee'),
('11.01.10.2016','Lhok Sialang Rayeuk'),
('11.01.10.2017','Gampong Baro'),
('11.01.10.2018','Teupin Gajah'),
('11.01.10.2019','Ujung Padang Asahan'),
('11.01.10.2020','Pulo Ie II'),
('11.01.10.2021','Pante Raja'),
('11.01.11','Labuhanhaji Timur'),
('11.01.11.2001','Tengah Peulumat'),
('11.01.11.2002','Paya Peulumat'),
('11.01.11.2003','Padang Peulumat'),
('11.01.11.2004','Aur Peulumat'),
('11.01.11.2005','Limau Saring'),
('11.01.11.2006','Beutong'),
('11.01.11.2007','Peuneulop'),
('11.01.11.2008','Gunung Rotan'),
('11.01.11.2009','Keumumu Hilir'),
('11.01.11.2010','Keumumu Hulu'),
('11.01.11.2011','Keumumu Seberang'),
('11.01.11.2012','Sawang Indah'),
('11.01.12','Labuhanhaji Barat'),
('11.01.12.2001','Tutong'),
('11.01.12.2002','Teungoh Iboh'),
('11.01.12.2003','Peulokan'),
('11.01.12.2004','Kuta Iboh'),
('11.01.12.2005','Ujung Padang'),
('11.01.12.2006','Blang Baru'),
('11.01.12.2007','Blang Poroh'),
('11.01.12.2008','Pulo Ie'),
('11.01.12.2009','Suak Lokan'),
('11.01.12.2010','Iku Lhueng'),
('11.01.12.2011','Kuta Trieng'),
('11.01.12.2012','Pante Geulima'),
('11.01.12.2013','Panton Pawoh'),
('11.01.12.2014','Batee Meucanang'),
('11.01.12.2015','Panton Rubek'),
('11.01.13','Kluet Tengah'),
('11.01.13.2001','Koto'),
('11.01.13.2002','Alur Keujrun'),
('11.01.13.2003','Jambo Papan'),
('11.01.13.2004','Malaka'),
('11.01.13.2005','Koto Indarung'),
('11.01.13.2006','Siurai-Urai'),
('11.01.13.2007','Kampung Sawah'),
('11.01.13.2008','Kampung Padang'),
('11.01.13.2009','Pulo Air'),
('11.01.13.2010','Lawe Melang'),
('11.01.13.2011','Mersak'),
('11.01.13.2012','Simpang Dua'),
('11.01.13.2013','Simpang Tiga'),
('11.01.14','Kluet Timur'),
('11.01.14.2001','Paya Dapur'),
('11.01.14.2002','Sapik'),
('11.01.14.2003','Alai'),
('11.01.14.2004','Durian Kawan'),
('11.01.14.2005','Lawe Sawah'),
('11.01.14.2006','Lawe Buluh Didi'),
('11.01.14.2007','Pucuk Lembang'),
('11.01.14.2008','Paya Laba'),
('11.01.14.2009','Lawe Cimanok'),
('11.01.15','Bakongan Timur'),
('11.01.15.2001','Pasie Seubadeh'),
('11.01.15.2002','Ladang Rimba'),
('11.01.15.2003','Ujong Pulo Rayeuk'),
('11.01.15.2004','Sawah Tingkeum'),
('11.01.15.2005','Simpang'),
('11.01.15.2006','Ujong Pulo Cut'),
('11.01.15.2008','Seuleukat'),
('11.01.16','Trumon Timur'),
('11.01.16.2005','Pinto Rimba'),
('11.01.16.2006','Krueng Luas'),
('11.01.16.2007','Jambo Dalem'),
('11.01.16.2008','Kapa Sesak'),
('11.01.16.2009','Seuneubok Punto'),
('11.01.16.2010','Seuneubok Pusaka'),
('11.01.16.2011','Alur Bujok'),
('11.01.16.2012','Titi Poben'),
('11.01.17','Kota Bahagia'),
('11.01.17.2001','Buket Gadeng'),
('11.01.17.2002','Rambong'),
('11.01.17.2003','Seuneubok Keuranji'),
('11.01.17.2004','Seuneubok Alur Buloh'),
('11.01.17.2005','Ujong Tanoh'),
('11.01.17.2006','Ujong Gunong Cut'),
('11.01.17.2007','Ujong Gunung Rayeuk'),
('11.01.17.2008','Beutong'),
('11.01.17.2009','Jambo Keupok'),
('11.01.17.2010','Alurduamas'),
('11.01.18','Trumon Tengah'),
('11.01.18.2001','Ladang Rimba'),
('11.01.18.2002','Gunong Kapho'),
('11.01.18.2003','Kampong Teungoh'),
('11.01.18.2004','Krueng Batee'),
('11.01.18.2005','Pulo Paya'),
('11.01.18.2006','Jambo Papeun'),
('11.01.18.2007','Cot Bayu'),
('11.01.18.2008','Naca'),
('11.01.18.2009','Ie Jeureuneh'),
('11.01.18.2010','Lhok Raya'),
('11.02','Kabupaten Aceh Tenggara'),
('11.02.01','Lawe Alas'),
('11.02.01.2001','Engkeran'),
('11.02.01.2002','Rumah Kampung'),
('11.02.01.2004','Pasir Bangun'),
('11.02.01.2006','Kubu'),
('11.02.01.2007','Lawe Kongker'),
('11.02.01.2008','Kuta Cingkam II'),
('11.02.01.2009','Muara Baru'),
('11.02.01.2011','Kuta Batu I'),
('11.02.01.2012','Kuta Cingkam I'),
('11.02.01.2013','Kuta Batu II'),
('11.02.01.2014','Lawe Sempilang'),
('11.02.01.2015','Prapat Batu Nunggul'),
('11.02.01.2016','Pulo Sepang'),
('11.02.01.2017','Rih Mbelang'),
('11.02.01.2018','Kute Batu Baru'),
('11.02.01.2019','Darul Amin'),
('11.02.01.2020','Lawe Lubang Indah'),
('11.02.01.2021','Batu Hamparan'),
('11.02.01.2022','Paye Munje'),
('11.02.01.2023','Pulo Ndadap'),
('11.02.01.2024','Pasir Nunggul'),
('11.02.01.2025','Cingkham Mekhanggun'),
('11.02.01.2026','Pintu Khimbe'),
('11.02.01.2027','Lawe Kongker Hilir'),
('11.02.01.2028','Pulo Gadung'),
('11.02.01.2029','Pasikh Pehkmate'),
('11.02.01.2030','Pasikh Nunang'),
('11.02.01.2031','Deleng Kukusen'),
('11.02.02','Lawe Sigala-Gala'),
('11.02.02.2001','Bukit Merdeka'),
('11.02.02.2002','Darul Aman'),
('11.02.02.2003','Lawe Kesumpat'),
('11.02.02.2004','Lawe Tua Gabungan'),
('11.02.02.2005','Lawe Sigala II'),
('11.02.02.2006','Lawe Sigala Timur'),
('11.02.02.2007','Lawe Sigala Barat'),
('11.02.02.2008','Suka Damai'),
('11.02.02.2009','Kute Tengah'),
('11.02.02.2010','Tanah Baru'),
('11.02.02.2011','Kedataran Gabungan'),
('11.02.02.2012','Gabungan Parsaroan'),
('11.02.02.2013','Lawe Loning Gabungan'),
('11.02.02.2014','Lawe Loning Aman'),
('11.02.02.2015','Suka Maju'),
('11.02.02.2016','Lawe Tua Makmur'),
('11.02.02.2017','Lawe Tua Persatuan'),
('11.02.02.2018','Lawe Serke'),
('11.02.02.2019','Lawe Rakat'),
('11.02.02.2020','Suka Jaya'),
('11.02.02.2021','Enmiya Batu Dua Ratus'),
('11.02.02.2022','Sebungke'),
('11.02.02.2023','Bukit Sepakat'),
('11.02.02.2024','Lawe Loning Sepakat'),
('11.02.02.2025','Lawe Loning I'),
('11.02.02.2026','Gaya Jaya'),
('11.02.02.2027','Gelah Musara'),
('11.02.02.2028','Mulie Dame'),
('11.02.02.2029','Lawe Loning Hakhapen'),
('11.02.02.2030','Karya Indah'),
('11.02.02.2031','Kayu Mbelin'),
('11.02.02.2032','Lawe Sigala Barat Jaya'),
('11.02.02.2033','Lawe Pekhidinen'),
('11.02.02.2034','Kertimbang'),
('11.02.02.2035','Ndauh Nitenggo'),
('11.02.03','Bambel'),
('11.02.03.2001','Bambel Gabungan'),
('11.02.03.2002','Kuta Buluh'),
('11.02.03.2005','Lawe Hijo'),
('11.02.03.2006','Pinding'),
('11.02.03.2009','Terutung Megara Asli'),
('11.02.03.2011','Biak Muli'),
('11.02.03.2012','Kute Lang-Lang'),
('11.02.03.2013','Pedesi'),
('11.02.03.2014','Terutung Payung Hulu'),
('11.02.03.2015','Terutung Payung Hilir'),
('11.02.03.2016','Tualang Sembilar'),
('11.02.03.2017','Kuning I'),
('11.02.03.2018','Kuning II'),
('11.02.03.2019','Cinta Damai'),
('11.02.03.2020','Likat'),
('11.02.03.2021','Rikit'),
('11.02.03.2023','Bambel'),
('11.02.03.2025','Lawe Kihing'),
('11.02.03.2026','Terutung Seperai'),
('11.02.03.2027','Kute Seri'),
('11.02.03.2028','Kuta Antara'),
('11.02.03.2029','Pulo Perengge'),
('11.02.03.2031','Pulo Kendondong'),
('11.02.03.2033','Pancakh Iman'),
('11.02.03.2034','Biak Muli Baru'),
('11.02.03.2035','Biak Muli Pantai Raja'),
('11.02.03.2036','Biak Muli Sejahtera'),
('11.02.03.2037','Lembah Haji'),
('11.02.03.2038','Terutung Payung Gabungan'),
('11.02.03.2039','Lawe Hijo Metuah'),
('11.02.03.2040','Ampera'),
('11.02.03.2041','Tembilakh Mbakhu'),
('11.02.03.2042','Kute Lang-Lang Bakhu'),
('11.02.04','Babussalam'),
('11.02.04.2001','Kota Kutacane'),
('11.02.04.2002','Perapat Hilir'),
('11.02.04.2003','Perapat Hulu'),
('11.02.04.2004','Muara Lawe Bulan'),
('11.02.04.2005','Mbarung'),
('11.02.04.2006','Batu Mbulan Asli'),
('11.02.04.2007','Batu Mbulan I'),
('11.02.04.2008','Batu Mbulan II'),
('11.02.04.2009','Kampung Raja'),
('11.02.04.2010','Pulonas'),
('11.02.04.2011','Kampung Melayu Gabungan'),
('11.02.04.2012','Terutung Pedi'),
('11.02.04.2013','Kute Rih'),
('11.02.04.2014','Gumpang Jaya'),
('11.02.04.2015','Pulo Latong'),
('11.02.04.2016','Kutacane Lama'),
('11.02.04.2017','Batu Mbulan Mbaru'),
('11.02.04.2018','Pulo Peding'),
('11.02.04.2019','Mendabe'),
('11.02.04.2020','Ujung Barat'),
('11.02.04.2021','Pekhapat Titi Panjang'),
('11.02.04.2022','Pekhapat Sepakat'),
('11.02.04.2023','Alas Marancar'),
('11.02.04.2024','Batu Mbulan Sepakat'),
('11.02.04.2025','Pulo Sanggakh'),
('11.02.04.2026','Melayu I'),
('11.02.04.2027','Mbarung Datuk Saudane'),
('11.02.05','Badar'),
('11.02.05.2005','Salang Alas'),
('11.02.05.2009','Kuta Pasir'),
('11.02.05.2011','Purwodadi'),
('11.02.05.2012','Kuta Tinggi'),
('11.02.05.2013','Kampung Baru'),
('11.02.05.2014','Peranginan'),
('11.02.05.2015','Natam'),
('11.02.05.2025','Kumbang Jaya'),
('11.02.05.2026','Kumbang Indah'),
('11.02.05.2027','Natam Baru'),
('11.02.05.2029','Deleng Megakhe'),
('11.02.05.2030','Lawe Bekung'),
('11.02.05.2031','Lawe Bekung Tampahan'),
('11.02.05.2032','Badar Indah'),
('11.02.05.2033','Batu Mbekhong'),
('11.02.05.2034','Tanah Merah'),
('11.02.05.2035','Tanoh Megakhe'),
('11.02.05.2036','Lawe Sekerah'),
('11.02.06','Babul Makmur'),
('11.02.06.2001','Pardomuan II'),
('11.02.06.2002','Lawe Desky I'),
('11.02.06.2003','Lawe Desky Sabas'),
('11.02.06.2004','Pardomuan I'),
('11.02.06.2005','Cinta Damai'),
('11.02.06.2006','Lawe Perbunga'),
('11.02.06.2007','Lawe Desky Tongah'),
('11.02.06.2008','Kute Bakti'),
('11.02.06.2010','Muara Situlen'),
('11.02.06.2011','Sejahtera'),
('11.02.06.2012','Kute Makmur'),
('11.02.06.2013','Pardamean'),
('11.02.06.2014','Lawe Mantik'),
('11.02.06.2015','Cinta Makmur'),
('11.02.06.2016','Muara Setia'),
('11.02.06.2017','Tanoh Alas'),
('11.02.06.2018','Sejahtera Baru'),
('11.02.06.2024','Lawe Tawakh'),
('11.02.06.2025','Sabilussalam'),
('11.02.06.2026','Lawe Desky Jaya'),
('11.02.06.2027','Pintu Alas'),
('11.02.07','Darul Hasanah'),
('11.02.07.2001','Gulo'),
('11.02.07.2002','Pulo Piku'),
('11.02.07.2003','Terutung Kute'),
('11.02.07.2004','Kute Ujung'),
('11.02.07.2005','Lawe Stul'),
('11.02.07.2006','Kite Merangun'),
('11.02.07.2007','Mamas'),
('11.02.07.2008','Tanjung Lama'),
('11.02.07.2009','Tanjung Muda'),
('11.02.07.2010','Rambung Teldak'),
('11.02.07.2011','Tanjung Aman'),
('11.02.07.2012','Sri Muda'),
('11.02.07.2013','Ujung Baru'),
('11.02.07.2014','Kute Rambe'),
('11.02.07.2015','Mamas Baru'),
('11.02.07.2016','Rambung Jaya'),
('11.02.07.2017','Makmur Jaya'),
('11.02.07.2018','Darul Makmur'),
('11.02.07.2019','Tanjung Bakhu'),
('11.02.07.2020','Pulo Gabung'),
('11.02.07.2021','Kokhtan Jaya'),
('11.02.07.2022','Istiqamah'),
('11.02.07.2023','Lawe Mamas Indah'),
('11.02.07.2024','Tanjung Leuser'),
('11.02.07.2025','Simpang IV Tanjung'),
('11.02.07.2026','Lawe Pinis'),
('11.02.07.2027','Buntul Kendawi'),
('11.02.07.2028','Kuning Abadi'),
('11.02.08','Lawe Bulan'),
('11.02.08.2001','Pasir Gala'),
('11.02.08.2002','Pasir Penjengakan'),
('11.02.08.2003','Kutambaru'),
('11.02.08.2004','Lawe Sagu Hulu'),
('11.02.08.2005','Lawe Sagu Hilir'),
('11.02.08.2006','Kute Bantil'),
('11.02.08.2011','Lawe Kolok'),
('11.02.08.2012','Lawe Rutung'),
('11.02.08.2013','Kampung Nangka'),
('11.02.08.2014','Tenembak Juhar'),
('11.02.08.2015','Simpang Empat'),
('11.02.08.2016','Kuta Buluh Botong'),
('11.02.08.2017','Katambaru Becawan'),
('11.02.08.2018','Lawe Kinge'),
('11.02.08.2019','Kandang Mbelang Mandiri'),
('11.02.08.2020','Mbacang Racun'),
('11.02.08.2021','Telaga Mekar'),
('11.02.08.2023','Pulonas Baru'),
('11.02.08.2025','Kuta Genting'),
('11.02.08.2026','Pangguh'),
('11.02.08.2027','Lawe Sagu'),
('11.02.08.2028','Pekhapet Timur'),
('11.02.08.2029','Bahagia'),
('11.02.08.2030','Kute Galuh Asli'),
('11.02.09','Bukit Tusam'),
('11.02.09.2001','Kute Lengat Pangan'),
('11.02.09.2002','Kute Lengat Selian'),
('11.02.09.2003','Tualang Baru'),
('11.02.09.2004','Alur Buluh'),
('11.02.09.2005','Maha Singkil'),
('11.02.09.2006','Tenembak Bintang'),
('11.02.09.2007','Kute Lingga'),
('11.02.09.2008','Rikit Bur'),
('11.02.09.2010','Kerukunan'),
('11.02.09.2011','Lawe Dua'),
('11.02.09.2012','Rema'),
('11.02.09.2013','Bambel Baru'),
('11.02.09.2014','Pejuang'),
('11.02.09.2015','Darussalam'),
('11.02.09.2016','Amaliah'),
('11.02.09.2017','Sebudi Jaya'),
('11.02.09.2018','Gumpang'),
('11.02.09.2019','Kute Gekhat'),
('11.02.09.2020','Paye Khambung'),
('11.02.09.2021','Mbak Sako'),
('11.02.09.2022','Darul Imami'),
('11.02.09.2023','Rikit Bur II'),
('11.02.09.2024','Kute Empat Lima'),
('11.02.10','Semadam'),
('11.02.10.2001','Simpang Semadam'),
('11.02.10.2002','Semadam Awal'),
('11.02.10.2003','Semadam Asal'),
('11.02.10.2004','Lawe Kinga Gabungan'),
('11.02.10.2005','Lawe Kinga Tebing Tinggi'),
('11.02.10.2006','Kebun Sere'),
('11.02.10.2007','Lawe Beringin Horas'),
('11.02.10.2008','Lawe. Berigin Gayo'),
('11.02.10.2009','Suka Makmur'),
('11.02.10.2010','Pasar Puntung'),
('11.02.10.2011','Titi Pasir'),
('11.02.10.2012','Lawe Petanduk I'),
('11.02.10.2013','Ngkeran Alur Buluh'),
('11.02.10.2014','Kampung Baru'),
('11.02.10.2015','Sepakat Segenap'),
('11.02.10.2016','Selamat Indah'),
('11.02.10.2017','Lawe Kinge Lapter'),
('11.02.10.2018','Lawe Mejile'),
('11.02.10.2019','Lawe Petanduk-II'),
('11.02.11','Babul Rahmah'),
('11.02.11.2004','Titi Mas'),
('11.02.11.2005','Meranti'),
('11.02.11.2006','Kute Lang-Lang'),
('11.02.11.2007','Lawe Sumur'),
('11.02.11.2008','Pardamaian'),
('11.02.11.2009','Salim Pipit'),
('11.02.11.2010','Penguhapan'),
('11.02.11.2011','Lumban Tua'),
('11.02.11.2012','Mutiara Damai'),
('11.02.11.2013','Dolok Nauli'),
('11.02.11.2014','Tuhi Jongkat'),
('11.02.11.2015','Uning Sigugur'),
('11.02.11.2016','Lumban Sitio-tio'),
('11.02.11.2017','Lawe Malum'),
('11.02.11.2018','Alur Baning'),
('11.02.11.2019','Lingga Alas'),
('11.02.11.2020','Khambung Tumbung'),
('11.02.11.2021','Tuah Mesade'),
('11.02.11.2022','Sumukh Alas'),
('11.02.11.2023','Alukh Bakhu'),
('11.02.11.2024','Sepekhinding'),
('11.02.11.2025','Tanoh Subukh'),
('11.02.11.2026','Pinggan Mbelang'),
('11.02.11.2027','Sigai Indah'),
('11.02.11.2028','Ukekh Deleng'),
('11.02.11.2029','Alas Mesikhat'),
('11.02.11.2030','Titi Hakhapen'),
('11.02.12','Ketambe'),
('11.02.12.2001','Aunan Sepakat'),
('11.02.12.2002','Lawe Penanggalan'),
('11.02.12.2003','Lawe Mengkudu'),
('11.02.12.2004','Jambur Lak-lak'),
('11.02.12.2005','Simpang Tiga Jongar'),
('11.02.12.2006','Jongar Asli'),
('11.02.12.2007','Ketambe'),
('11.02.12.2008','Rumah Bundar'),
('11.02.12.2009','Penyeberangan Cingkam'),
('11.02.12.2010','Deleng Damar'),
('11.02.12.2011','Bintang Bener'),
('11.02.12.2012','Suka Rimbun'),
('11.02.12.2013','Lawe Aunan'),
('11.02.12.2014','Bener Bepapah'),
('11.02.12.2015','Penungkunen'),
('11.02.12.2016','Datok Pining'),
('11.02.12.2017','Kati Maju'),
('11.02.12.2018','Leuser'),
('11.02.12.2019','Jati Sara'),
('11.02.12.2020','Bukit Mbakhu'),
('11.02.12.2021','Kayu Metangur'),
('11.02.12.2022','Lawe Sembekan'),
('11.02.12.2023','Lawe Beringin'),
('11.02.12.2024','Lawe Ger-Ger'),
('11.02.12.2025','Simpur Jaya'),
('11.02.13','Deleng Pokhkisen'),
('11.02.13.2001','Salang Baru'),
('11.02.13.2002','Ranto Dior'),
('11.02.13.2003','Lembah Alas'),
('11.02.13.2004','Tenembak Lang-Lang'),
('11.02.13.2005','Salang Sigotom'),
('11.02.13.2006','Tualang Lama'),
('11.02.13.2007','Gusung Batu'),
('11.02.13.2008','Kaya Pangur'),
('11.02.13.2009','Sepakat'),
('11.02.13.2010','Lawe Pangkat'),
('11.02.13.2011','Bunga Melur'),
('11.02.13.2012','Penampaan'),
('11.02.13.2013','Terutung Mbelang'),
('11.02.13.2014','Salang Muara'),
('11.02.13.2015','Lawe Hakhum'),
('11.02.13.2016','Tanoh Khukahen'),
('11.02.13.2017','Tading Ni Ulihi'),
('11.02.13.2018','Peseluk Pesimbe'),
('11.02.13.2019','Kane Lot'),
('11.02.13.2020','Muhajirin'),
('11.02.13.2021','Beriring Naru'),
('11.02.13.2022','Kati Jeroh'),
('11.02.14','Lawe Sumur'),
('11.02.14.2001','Terutung Megara Lawe Pasaran'),
('11.02.14.2002','Kisam Gabungan'),
('11.02.14.2003','Kisam Kute Pasir'),
('11.02.14.2004','Lawe Sumur'),
('11.02.14.2005','Lawe Sumur Baru'),
('11.02.14.2006','Kute Lesung'),
('11.02.14.2007','Berandang'),
('11.02.14.2008','Kute Bunin'),
('11.02.14.2009','Buah Pala'),
('11.02.14.2010','Panosan'),
('11.02.14.2011','Lawe Pasaran Tengku Mbelin'),
('11.02.14.2012','Terutung Megahke MBakhu'),
('11.02.14.2013','Kisam Lestari'),
('11.02.14.2014','Kisam Kute Rambe'),
('11.02.14.2015','Lawe Polak'),
('11.02.14.2016','Lawes Sumur Sepakat'),
('11.02.14.2017','Setia Baru'),
('11.02.14.2018','Teger Miko'),
('11.02.15','Tanoh Alas'),
('11.02.15.2001','Salim Pinim I'),
('11.02.15.2002','Jambur Damar'),
('11.02.15.2003','Alur Langsat'),
('11.02.15.2004','Rambah Sayang'),
('11.02.15.2006','Rumah Luar'),
('11.02.15.2007','Tenembak Alas'),
('11.02.15.2008','Lawe Tungkal'),
('11.02.15.2009','Salim Pinim II'),
('11.02.15.2010','Jambukh Pekhmate'),
('11.02.15.2011','Khutung Mbelang'),
('11.02.15.2012','Timang Rasa'),
('11.02.15.2013','Stambul Jaya'),
('11.02.15.2014','Alur Nangke'),
('11.02.15.2015','Kute Mejile'),
('11.02.16','Leuser'),
('11.02.16.2001','Bintang Alga Musara'),
('11.02.16.2002','Bintang Bukit Indah'),
('11.02.16.2003','Tanjung Sari'),
('11.02.16.2004','Bun-bun Alas'),
('11.02.16.2005','Naga Timbul'),
('11.02.16.2006','Gunung Pak-Pak'),
('11.02.16.2007','Bukit Meriah'),
('11.02.16.2008','Permata Musara'),
('11.02.16.2009','Laut Tawar'),
('11.02.16.2010','Kane Mende'),
('11.02.16.2011','Lawe Sekhakut'),
('11.02.16.2012','Bunbun Indah'),
('11.02.16.2013','Suka Damai'),
('11.02.16.2014','Tuah Kekhine'),
('11.02.16.2015','Punce Nali'),
('11.02.16.2016','Sade Ate'),
('11.02.16.2017','Akhih Majile'),
('11.02.16.2018','Ukhat Peseluk'),
('11.02.16.2019','Tunas Mude'),
('11.02.16.2020','Gaye Sendah'),
('11.02.16.2021','Kute Hakhapen'),
('11.02.16.2022','Kompas'),
('11.02.16.2023','Sepakat'),
('11.03','Kabupaten Aceh Timur'),
('11.03.01','Darul Aman'),
('11.03.01.2001','Alue Luddin Sa'),
('11.03.01.2002','Alue Luddin Dua'),
('11.03.01.2003','Alue Dalam'),
('11.03.01.2004','Dama Pulo Sa'),
('11.03.01.2005','Dama Pulo Dua'),
('11.03.01.2006','Buket Kulam'),
('11.03.01.2007','Seuneubok Teungoh'),
('11.03.01.2008','Jungka Gajah'),
('11.03.01.2009','Seuneubok Simpang'),
('11.03.01.2010','Matang Pineung'),
('11.03.01.2011','Lhok Geulumpang'),
('11.03.01.2012','Blang Buket'),
('11.03.01.2013','Meunasah Keutapang'),
('11.03.01.2014','Buket Rumia'),
('11.03.01.2015','Alue Gadeng'),
('11.03.01.2016','Kapai Baro'),
('11.03.01.2017','Seuneubok Tuha Sa'),
('11.03.01.2018','Seuneubok Tuha Dua'),
('11.03.01.2019','Seuneubok Buloh'),
('11.03.01.2020','Gaseh Sayang'),
('11.03.01.2021','Alue Lhok'),
('11.03.01.2022','Trieng Gadeng'),
('11.03.01.2023','Grong-Grong'),
('11.03.01.2024','Matang Geuto'),
('11.03.01.2025','Alue Merbo'),
('11.03.01.2026','Buket Raya'),
('11.03.01.2027','Gampong Keude'),
('11.03.01.2028','Peukan Idi Cut'),
('11.03.01.2029','Gampong Beunot'),
('11.03.01.2030','Seuneubok Baroh'),
('11.03.01.2031','Teupin Drum'),
('11.03.01.2032','Kuala Idi Cut'),
('11.03.01.2034','Seuneubok Aceh'),
('11.03.01.2035','Gampong Baro'),
('11.03.01.2036','Bagok Panah Sa'),
('11.03.01.2037','Bagok Panah Dua'),
('11.03.01.2038','Bagok Panah Lhee'),
('11.03.01.2039','Bagok Panah Peut'),
('11.03.01.2040','Buket Tualang'),
('11.03.01.2041','Keumuneng Sa'),
('11.03.01.2042','Keumuneng Dua'),
('11.03.01.2043','Keumuneng Lhee'),
('11.03.01.2044','Keumuneng Peut'),
('11.03.01.2045','Keumuneng Limong'),
('11.03.01.2046','Meunasah Blang'),
('11.03.02','Julok'),
('11.03.02.2001','Blang Keumahang'),
('11.03.02.2002','Blang Jambee'),
('11.03.02.2003','Keumuneng'),
('11.03.02.2004','Ladang Baro'),
('11.03.02.2005','Buket Panyang'),
('11.03.02.2006','Seuneubok Rambong'),
('11.03.02.2007','Seuneubok Baro'),
('11.03.02.2008','Blang Mideun'),
('11.03.02.2009','Paya Bakong'),
('11.03.02.2010','Teupin Raya'),
('11.03.02.2011','Lhok Rambong'),
('11.03.02.2012','Julok Tunong'),
('11.03.02.2013','Ulee Ateung'),
('11.03.02.2014','Ulee Blang'),
('11.03.02.2015','Labuhan'),
('11.03.02.2016','Naleung'),
('11.03.02.2017','Mane Rampak'),
('11.03.02.2018','Matang'),
('11.03.02.2019','Blang Uyok'),
('11.03.02.2020','Blang Pauh Sa'),
('11.03.02.2021','Blang Pauh Dua'),
('11.03.02.2022','Ulee Tanoh'),
('11.03.02.2023','Keude Kuta Binjei'),
('11.03.02.2024','Bukit Seroja'),
('11.03.02.2025','Kuala Geulumpang'),
('11.03.02.2026','Gampong Baro'),
('11.03.02.2027','Tumpok Teungoh'),
('11.03.02.2028','Seumatang'),
('11.03.02.2029','Ujong Tunong'),
('11.03.02.2030','Bukit Dindeng'),
('11.03.02.2031','Paya Pasi'),
('11.03.02.2032','Alue Cek Doi'),
('11.03.02.2033','Blang Gleum'),
('11.03.02.2034','Tanjong Tok Blang'),
('11.03.02.2035','Buket Makmu'),
('11.03.02.2036','Lhok Seuntang'),
('11.03.02.2037','Simpang Lhee'),
('11.03.03','Idi Rayeuk'),
('11.03.03.2001','Gampong Jawa'),
('11.03.03.2002','Keude Blang'),
('11.03.03.2003','Tanoh Anoe'),
('11.03.03.2004','Kuala Peudawa Puntong'),
('11.03.03.2005','Gampong Aceh'),
('11.03.03.2006','Kuta Blang'),
('11.03.03.2007','Gampong Tanjong'),
('11.03.03.2008','Blang Geulumpang'),
('11.03.03.2009','Meunasah Pu''uk'),
('11.03.03.2010','Bantayan Timu'),
('11.03.03.2011','Keutapang Mameh'),
('11.03.03.2012','Seuneubok Rambong'),
('11.03.03.2013','Kuala Idi'),
('11.03.03.2014','Keude Aceh'),
('11.03.03.2023','Seuneubok Bacee'),
('11.03.03.2029','Titi Baro'),
('11.03.03.2047','Tanjong Kapai'),
('11.03.03.2048','Alue Dua Muka O'),
('11.03.03.2049','Alue Dua Muka S'),
('11.03.03.2050','Ulee Blang'),
('11.03.03.2051','Buket Jok'),
('11.03.03.2052','Buket Meulinteung'),
('11.03.03.2053','Gampong Jalan'),
('11.03.03.2054','Teupin Batee'),
('11.03.03.2055','Buket Langa'),
('11.03.03.2056','Buket Pala'),
('11.03.03.2057','Buket Juara'),
('11.03.03.2058','Seuneubok Tutong'),
('11.03.03.2059','Seuneubok Tuha'),
('11.03.03.2060','Sampoimah'),
('11.03.03.2061','Dama pulo'),
('11.03.03.2062','Gureb Blang'),
('11.03.03.2064','Gampong Baro'),
('11.03.03.2065','SeuneubokTeungoh P.Puntong'),
('11.03.03.2067','Kuta Lawah'),
('11.03.04','Birem Bayeun'),
('11.03.04.2001','Jambo Labu'),
('11.03.04.2002','Alue Canang'),
('11.03.04.2003','Alue Drien'),
('11.03.04.2004','Buket Tiga'),
('11.03.04.2005','Benteng'),
('11.03.04.2006','Afeling II Bukit'),
('11.03.04.2007','Keumuneng Hulu'),
('11.03.04.2008','Peutow'),
('11.03.04.2009','Alue Buloh'),
('11.03.04.2010','Alue Teh'),
('11.03.04.2011','Paya Rambong'),
('11.03.04.2012','Alue Gadeng SA'),
('11.03.04.2013','Paya Tampah'),
('11.03.04.2014','Paya Bili Dua'),
('11.03.04.2015','Paya Bili Sa'),
('11.03.04.2016','Paya Peulawi'),
('11.03.04.2017','Keude Birem'),
('11.03.04.2018','Bayeun'),
('11.03.04.2019','Aramiyah'),
('11.03.04.2020','Blang Tualang'),
('11.03.04.2021','Buket Seuleumak'),
('11.03.04.2022','Birem Rayeuk'),
('11.03.04.2023','Alue Gadeng'),
('11.03.04.2024','Alue Gadeng Dua'),
('11.03.04.2025','Alue Sentang'),
('11.03.04.2026','Merbou Dua'),
('11.03.04.2027','Alue Nyamoek'),
('11.03.05','Serbajadi'),
('11.03.05.2001','Lokop'),
('11.03.05.2002','Terujak'),
('11.03.05.2003','Tualang'),
('11.03.05.2004','Leles'),
('11.03.05.2005','Ujung Karang'),
('11.03.05.2006','Nalon'),
('11.03.05.2007','Jering'),
('11.03.05.2008','Loot'),
('11.03.05.2009','Seku Alan'),
('11.03.05.2010','Sunti'),
('11.03.05.2011','Umah Taring'),
('11.03.05.2012','Bunin'),
('11.03.05.2013','Sembuang'),
('11.03.05.2014','Seuleumak'),
('11.03.05.2015','Mesir'),
('11.03.05.2016','Rampah'),
('11.03.05.2022','Arul Durin'),
('11.03.06','Nurussalam'),
('11.03.06.2001','Keude Bagok Sa'),
('11.03.06.2002','Keude Bagok Dua'),
('11.03.06.2003','Asan Tanjong'),
('11.03.06.2004','Bantayan'),
('11.03.06.2005','Matang Seuleumak'),
('11.03.06.2006','Teupin Pukat'),
('11.03.06.2007','Matang Neuheun'),
('11.03.06.2008','Kuala Bagok'),
('11.03.06.2009','Meunasah Teungoh'),
('11.03.06.2010','Medang Ara'),
('11.03.06.2011','Peulawi'),
('11.03.06.2012','Baroh Bugeng'),
('11.03.06.2013','Seumatang Aron'),
('11.03.06.2014','Blang Panjou'),
('11.03.06.2025','Pulo U'),
('11.03.06.2026','Cot Asan'),
('11.03.06.2027','Paya Enjee'),
('11.03.06.2028','Seuleumak Muda'),
('11.03.06.2029','Matang Panyang'),
('11.03.06.2030','Meunasah Hagu'),
('11.03.06.2031','Matang Kunyet'),
('11.03.06.2032','Buket Panjou'),
('11.03.06.2033','Buket Meurak'),
('11.03.06.2034','Buket Panyang'),
('11.03.06.2035','Seuneubok Dalam'),
('11.03.06.2036','Gampong Mesjid'),
('11.03.06.2037','Alue Siwah Serdang'),
('11.03.06.2038','Gampong Lhee'),
('11.03.06.2039','Beurandang'),
('11.03.06.2040','Gampong Jalan'),
('11.03.06.2041','Seuneubok Rambong'),
('11.03.07','Peureulak'),
('11.03.07.2001','Pasir Putih'),
('11.03.07.2002','Tualang'),
('11.03.07.2003','Keude Peureulak'),
('11.03.07.2004','Leuge'),
('11.03.07.2005','Uteun Dama'),
('11.03.07.2006','Punti'),
('11.03.07.2007','Alue Dua Paya Gajah'),
('11.03.07.2008','Blang Bitra'),
('11.03.07.2009','Kuala Bugak'),
('11.03.07.2010','Paya Lipah'),
('11.03.07.2011','Seumatang Muda Itam'),
('11.03.07.2012','Lhok Dalam'),
('11.03.07.2013','Beusa Meuranoe'),
('11.03.07.2014','Bangka Rimung'),
('11.03.07.2015','Tanoh Rata'),
('11.03.07.2016','Bandrong'),
('11.03.07.2017','Blang Balok'),
('11.03.07.2018','Cot Muda Itam'),
('11.03.07.2019','Keumuneng'),
('11.03.07.2020','Kuala Leuge'),
('11.03.07.2021','Balee Buya'),
('11.03.07.2022','Alue Nibong'),
('11.03.07.2023','Seuneubok Peusangan'),
('11.03.07.2024','Seuneubok Aceh'),
('11.03.07.2025','Seuneubok Pidie'),
('11.03.07.2026','Dama Tutong'),
('11.03.07.2027','Matang Gleum'),
('11.03.07.2028','Lubok Pempeng'),
('11.03.07.2029','Buket Pala'),
('11.03.07.2030','Paya Kalui'),
('11.03.07.2031','Cek Mbon'),
('11.03.07.2032','Paya Meuligou'),
('11.03.07.2033','Blang Simpo'),
('11.03.07.2034','Blang Batee'),
('11.03.07.2035','Matang Peulawi'),
('11.03.07.2036','Cot Geulumpang'),
('11.03.07.2037','Alue Rambong'),
('11.03.07.2038','Cot Keh'),
('11.03.08','Rantau Selamat'),
('11.03.08.2001','Bayeun'),
('11.03.08.2002','Rantau Panjang'),
('11.03.08.2003','Alue Raya'),
('11.03.08.2004','Alue Kumba'),
('11.03.08.2005','Seuneubok Dalam'),
('11.03.08.2006','Alue Seuleumak'),
('11.03.08.2007','Sarah Kayee'),
('11.03.08.2008','Damar Siput'),
('11.03.08.2009','Simpang Peut'),
('11.03.08.2010','Simpang Aneuh'),
('11.03.08.2011','Alue Punti'),
('11.03.08.2012','Alue Kaul'),
('11.03.08.2013','Sarah Teube'),
('11.03.08.2014','Alue Tuwi'),
('11.03.09','Simpang Ulim'),
('11.03.09.2001','Peulalu'),
('11.03.09.2002','Nicah Awe'),
('11.03.09.2003','Alue Buloh Sa'),
('11.03.09.2004','Alue Buloh Dua'),
('11.03.09.2005','Teupin Breuh'),
('11.03.09.2006','Matang Rayeuk'),
('11.03.09.2007','Matang Kumbang'),
('11.03.09.2008','Blang Nie'),
('11.03.09.2010','Bantayan'),
('11.03.09.2011','Matang Weng'),
('11.03.09.2012','Alue Mulieng'),
('11.03.09.2013','Pucok Alue Dua'),
('11.03.09.2014','Gampong Blang'),
('11.03.09.2015','Keude Tuha'),
('11.03.09.2016','Kuala Simpang Ulim'),
('11.03.09.2017','Lampoh Rayeuk'),
('11.03.09.2018','Teupin Mamplam'),
('11.03.09.2019','Titi Baroh'),
('11.03.09.2020','Pucok Alue Sa'),
('11.03.09.2021','Pucok Alue Barat'),
('11.03.09.2022','Arakundo'),
('11.03.09.2023','Gampong Baro'),
('11.03.09.2024','Matang Seupeng'),
('11.03.10','Ranto Peureulak'),
('11.03.10.2001','Paya Unou'),
('11.03.10.2002','Seuneubok Johan'),
('11.03.10.2003','Seuneubok Baro'),
('11.03.10.2004','Pulo Blang'),
('11.03.10.2005','Blang Barom'),
('11.03.10.2006','Seuneubok Dalam'),
('11.03.10.2007','Seuleumak Muda'),
('11.03.10.2008','Bhom Lama'),
('11.03.10.2009','Pasi Puteh'),
('11.03.10.2010','Alue Dua'),
('11.03.10.2011','Buket Pala'),
('11.03.10.2012','Mata Ie'),
('11.03.10.2013','Alue Udep'),
('11.03.10.2014','Seumali'),
('11.03.10.2015','Punti Payong'),
('11.03.10.2016','Paya Palas'),
('11.03.10.2017','Tampak'),
('11.03.10.2018','Kliet'),
('11.03.10.2019','Alue Geunteng'),
('11.03.10.2020','Pertamina'),
('11.03.10.2021','Alue Batee'),
('11.03.10.2022','Beurandang'),
('11.03.10.2024','Seumanah Jaya'),
('11.03.11','Pante Bidari'),
('11.03.11.2001','Blang Seunong'),
('11.03.11.2002','Suka Damai'),
('11.03.11.2003','Pante Labu'),
('11.03.11.2004','Pante Rambong'),
('11.03.11.2005','Alue Ie Mirah'),
('11.03.11.2006','Seuneubok Tuha'),
('11.03.11.2007','Seuneubok Saboh'),
('11.03.11.2008','Buket Kareung'),
('11.03.11.2009','Buket Bata'),
('11.03.11.2010','Meunasah Tunong'),
('11.03.11.2011','Meunasah Teungoh'),
('11.03.11.2012','Keude Baro'),
('11.03.11.2013','Matang Perlak'),
('11.03.11.2014','Grong-grong'),
('11.03.11.2015','Matang Kruet'),
('11.03.11.2016','Meunasah Leubok'),
('11.03.11.2017','Pante Panah'),
('11.03.11.2018','Paya Demam Sa'),
('11.03.11.2019','Paya Demam Dua'),
('11.03.11.2020','Paya Demam Lhee'),
('11.03.11.2021','Matang Pudeng'),
('11.03.11.2022','Putoh Sa'),
('11.03.11.2023','Putoh Dua'),
('11.03.11.2024','Sah Raja'),
('11.03.11.2025','Sijudo'),
('11.03.12','Madat'),
('11.03.12.2001','Madat'),
('11.03.12.2002','Matang Keupula Sa'),
('11.03.12.2003','Matang Keupula Dua'),
('11.03.12.2004','Matang Keupula Lhee'),
('11.03.12.2005','Ulee Ateung'),
('11.03.12.2006','Blang Ubit'),
('11.03.12.2007','Matang Guru'),
('11.03.12.2008','Pantee Bayam'),
('11.03.12.2009','Meunasah Asan'),
('11.03.12.2010','Meunasah Tingkeum'),
('11.03.12.2011','Lueng Dua'),
('11.03.12.2012','Lueng Peut'),
('11.03.12.2013','Paya Demam Peut'),
('11.03.12.2014','Abeuk Geulanteu'),
('11.03.12.2015','Rambong Lop'),
('11.03.12.2016','Tanjong Ara'),
('11.03.12.2017','Matang Jrok'),
('11.03.12.2018','Paya Naden'),
('11.03.12.2019','Tanjong Minjei'),
('11.03.12.2020','Pante Merbo'),
('11.03.12.2021','Blang Awe'),
('11.03.12.2022','Bintah'),
('11.03.12.2023','Seuneubok Pidie'),
('11.03.12.2024','Blang Andam'),
('11.03.12.2025','Matang Nibong'),
('11.03.12.2026','Lueng Sa'),
('11.03.13','Indra Makmu'),
('11.03.13.2001','Seuneubok Bayu'),
('11.03.13.2002','Alue Ie Itam'),
('11.03.13.2003','Blang Nisan'),
('11.03.13.2004','Bandar Baro'),
('11.03.13.2005','Alue Patong'),
('11.03.13.2006','Alue Ie Mirah'),
('11.03.13.2007','Suka Makmur'),
('11.03.13.2008','Jambo Balee'),
('11.03.13.2009','Jambo Lubok'),
('11.03.13.2010','Seuneubok Cina'),
('11.03.13.2011','Pelita Sagop Jaya'),
('11.03.13.2012','Perkebunan Julok Rayeuk Selatan'),
('11.03.13.2013','Perkebunan Julok Rayeuk Utara'),
('11.03.14','Idi Tunong'),
('11.03.14.2001','Seuneubok Buloh'),
('11.03.14.2002','Seuneubok Baro'),
('11.03.14.2003','Seuneubok Meureudu'),
('11.03.14.2004','Seuneubok Teupin Panah'),
('11.03.14.2005','Teupin Panah'),
('11.03.14.2006','Gampong Keumuneng'),
('11.03.14.2007','Keude Keumuneng'),
('11.03.14.2008','Keumuneng Lhok'),
('11.03.14.2009','Paya Awee'),
('11.03.14.2010','Paya Gaboh'),
('11.03.14.2011','Padang Kasah'),
('11.03.14.2012','Buket Teukuh'),
('11.03.14.2013','Buket Pu''uk'),
('11.03.14.2014','Blang Minjei'),
('11.03.14.2015','Alue Kumbang A'),
('11.03.14.2016','Alue Kumbang M'),
('11.03.14.2017','Alue Lhok'),
('11.03.14.2018','Seuneubok Buya'),
('11.03.14.2019','Seuneubok Drien'),
('11.03.14.2020','Bantayan Barat'),
('11.03.14.2021','Blang Guci'),
('11.03.14.2022','Buket Rumiya'),
('11.03.14.2023','Seuneubok Punti'),
('11.03.14.2024','Seuneubok Jalan'),
('11.03.14.2025','Seuneubok Dalam'),
('11.03.15','Banda Alam'),
('11.03.15.2001','Jalan Dua'),
('11.03.15.2002','Jambo Reuhat'),
('11.03.15.2003','Seuneubok Benteng'),
('11.03.15.2004','Seuneubok Pango'),
('11.03.15.2005','Seuneubok Simpang'),
('11.03.15.2006','Seuneubok Kandang'),
('11.03.15.2007','Ulee Jalan'),
('11.03.15.2008','Uram Jalan'),
('11.03.15.2009','Seuneubok Bayu'),
('11.03.15.2010','Blang Rambong'),
('11.03.15.2011','Buket Drien'),
('11.03.15.2012','Panton Rayeuk A'),
('11.03.15.2013','Panton Rayeuk B'),
('11.03.15.2014','Panton Rayeuk M'),
('11.03.15.2015','Panton Rayeuk T'),
('11.03.15.2016','Paya Laman'),
('11.03.16','Peudawa'),
('11.03.16.2001','Gampong Keude'),
('11.03.16.2002','Meunasah Krueng'),
('11.03.16.2003','Kuta Baro'),
('11.03.16.2004','Alue Batee'),
('11.03.16.2005','Matang Rayeuk'),
('11.03.16.2006','Paya Bili Dua'),
('11.03.16.2007','Alue Ie Itam'),
('11.03.16.2008','Asan Rampak'),
('11.03.16.2009','Gampong Kuala'),
('11.03.16.2010','Paya Dua'),
('11.03.16.2011','Seuneubok Teungoh'),
('11.03.16.2012','Buket Kuta'),
('11.03.16.2013','Sama Dua'),
('11.03.16.2014','Blang Kuta'),
('11.03.16.2015','Blang Buket'),
('11.03.16.2016','Seuneubok Peunteut'),
('11.03.16.2017','Paya Bili Sa'),
('11.03.17','Peureulak Timur'),
('11.03.17.2001','Babah Krueng'),
('11.03.17.2002','Kruet Lintang'),
('11.03.17.2003','Jengki'),
('11.03.17.2004','Buket Meriam'),
('11.03.17.2005','Alue Gureb'),
('11.03.17.2006','Seuneubok Teupin'),
('11.03.17.2007','Seuneubok Teungoh'),
('11.03.17.2008','Alue Bugeng'),
('11.03.17.2009','Seuneubok Punti'),
('11.03.17.2010','Seumatang Keude'),
('11.03.17.2011','Seuneubok Jalan'),
('11.03.17.2012','Seuneubok Paya'),
('11.03.17.2013','Alue Tho'),
('11.03.17.2014','Seuneubok Rawang'),
('11.03.17.2015','Alue Bu Alue Nireh'),
('11.03.17.2016','Seuneubok Dalam'),
('11.03.17.2017','Seuneubok Lapang'),
('11.03.17.2018','Gelanggang Meurak'),
('11.03.17.2019','Alue Bu Alue Lhok'),
('11.03.17.2020','Tualang Pateng'),
('11.03.18','Peureulak Barat'),
('11.03.18.2001','Beusa Seberang'),
('11.03.18.2002','Mon Geudong'),
('11.03.18.2003','Paya Seungat'),
('11.03.18.2004','Teumpeun'),
('11.03.18.2005','Alue Bu Tuha'),
('11.03.18.2006','Alue Bu Jalan'),
('11.03.18.2007','Tanjong Tualang'),
('11.03.18.2008','Beringen'),
('11.03.18.2009','Kebon Tempeun'),
('11.03.18.2010','Paya Gajah'),
('11.03.18.2011','Kabu'),
('11.03.18.2012','Paya Biek'),
('11.03.18.2013','Beusa Baroh'),
('11.03.18.2014','Alue Bu Jalan Baroh'),
('11.03.18.2015','Alue Bu Tunong'),
('11.03.19','Sungai Raya'),
('11.03.19.2001','Alue Rangan'),
('11.03.19.2002','Geulumpang Payong'),
('11.03.19.2003','Labuhan Keudee'),
('11.03.19.2004','Buket Seulamat'),
('11.03.19.2005','Buket Drien'),
('11.03.19.2006','Alue Itam'),
('11.03.19.2007','Paya Keutapang'),
('11.03.19.2008','Gajah Mentah'),
('11.03.19.2009','Seuneubok Pase'),
('11.03.19.2010','Seuneubok Aceh'),
('11.03.19.2011','Krueng Lingka'),
('11.03.19.2012','Sungai Simpang'),
('11.03.19.2013','Kuala Parek'),
('11.03.20','Simpang Jernih'),
('11.03.20.2001','Simpang Jernih'),
('11.03.20.2002','Batu Sumbang'),
('11.03.20.2003','Pante Kera'),
('11.03.20.2004','Rantau Panjang'),
('11.03.20.2005','Melidi'),
('11.03.20.2006','Tampur Paloh'),
('11.03.20.2007','Tampur Boor'),
('11.03.20.2008','HTI Rantau Naro'),
('11.03.21','Darul Ihsan'),
('11.03.21.2001','Meudang Ara'),
('11.03.21.2002','Gunong Putoh'),
('11.03.21.2003','Meunasah Aroen'),
('11.03.21.2004','Keude Dua'),
('11.03.21.2005','Seuneubok Lapang'),
('11.03.21.2006','Alue Jangat'),
('11.03.21.2007','Buket Peulawi'),
('11.03.21.2008','Lhok Panjoe'),
('11.03.21.2009','Seuneubok Aceh Baro'),
('11.03.21.2010','Pulo Blang'),
('11.03.21.2011','Lhok Dalam'),
('11.03.21.2012','Lhok Leumak'),
('11.03.21.2013','Seuneubok Kulam'),
('11.03.21.2014','Panton Meurebo'),
('11.03.21.2015','Seuneubok Teungoh'),
('11.03.21.2016','Lhok Meureu'),
('11.03.22','Darul Falah'),
('11.03.22.2001','Tunong Bugeng'),
('11.03.22.2002','Cempeudak'),
('11.03.22.2003','Buket Tufah'),
('11.03.22.2004','Tunong Ulee Gajah'),
('11.03.22.2005','Keudondong'),
('11.03.22.2006','Seuneubok Panton'),
('11.03.22.2007','Buket Teumpeun'),
('11.03.22.2008','Keude Blang'),
('11.03.22.2009','Paya Kruep'),
('11.03.22.2010','Tunong Paya Kruep'),
('11.03.22.2011','Alue Siwah'),
('11.03.23','Idi Timur'),
('11.03.23.2001','Keutapang Dua'),
('11.03.23.2002','Matang Rayeuk PP'),
('11.03.23.2003','Meunasah Jeumpa'),
('11.03.23.2004','Lhok Asahan'),
('11.03.23.2005','Tualang Dalam'),
('11.03.23.2006','Seuneubok Kuyun'),
('11.03.23.2007','Ulee Glee'),
('11.03.23.2008','Seuneubok Barat'),
('11.03.23.2009','Seuneubok Teungoh'),
('11.03.23.2010','Seuneubok Timu'),
('11.03.23.2011','Matang Bungong'),
('11.03.23.2012','Matang Rayeuk SMK'),
('11.03.23.2013','Seuneubok Dalam'),
('11.03.24','Peunaron'),
('11.03.24.2001','Arul Pinang'),
('11.03.24.2002','Peunaron Baru'),
('11.03.24.2003','Peunaron Lama'),
('11.03.24.2004','Bukit Tiga'),
('11.03.24.2006','Sri Mulya'),
('11.04','Kabupaten Aceh Tengah'),
('11.04.01','Linge'),
('11.04.01.2003','Delung Sekinel'),
('11.04.01.2005','Gelampang Gading'),
('11.04.01.2006','Gewat'),
('11.04.01.2008','Jamat'),
('11.04.01.2009','Kemerleng'),
('11.04.01.2010','Kute Baru'),
('11.04.01.2011','Kute Keramil'),
('11.04.01.2012','Kute Rayang'),
('11.04.01.2013','Kute Riyem'),
('11.04.01.2014','Kute Robel'),
('11.04.01.2015','Linge'),
('11.04.01.2016','Lumut'),
('11.04.01.2018','Mungkur'),
('11.04.01.2019','Owaq'),
('11.04.01.2020','Pantan Nangka'),
('11.04.01.2021','Penarun'),
('11.04.01.2022','Simpang Tige Uning'),
('11.04.01.2023','Umang'),
('11.04.01.2024','Despot Linge'),
('11.04.01.2025','Gemboyah'),
('11.04.01.2031','Arul Item'),
('11.04.01.2032','Ise-Ise'),
('11.04.01.2033','Kute Reje'),
('11.04.01.2034','Reje Payung'),
('11.04.01.2035','Pantan Reduk'),
('11.04.01.2036','Antara'),
('11.04.02','Silih Nara'),
('11.04.02.2001','Arul Gele'),
('11.04.02.2002','Arul Kumer'),
('11.04.02.2003','Burni Bius'),
('11.04.02.2004','Genting Gerbang'),
('11.04.02.2005','Gunung Singit'),
('11.04.02.2007','Pepayungen Angkup'),
('11.04.02.2008','Remesen'),
('11.04.02.2009','Rutih'),
('11.04.02.2010','Semelit Mutiara'),
('11.04.02.2012','Wih Porak'),
('11.04.02.2013','Wihni Bakong'),
('11.04.02.2014','Wihni Durin'),
('11.04.02.2016','Arul Putih'),
('11.04.02.2017','Arul Relem'),
('11.04.02.2018','Burni Bius Baru'),
('11.04.02.2019','Jerata'),
('11.04.02.2022','Paya Beke'),
('11.04.02.2023','Paya Pelu'),
('11.04.02.2026','Rebe Gedung'),
('11.04.02.2027','Reremal'),
('11.04.02.2029','Sanehen'),
('11.04.02.2030','Simpang Kemili'),
('11.04.02.2031','Tenebuk Kampung Baru'),
('11.04.02.2032','Terang Engon'),
('11.04.02.2033','Wih Pesam'),
('11.04.02.2034','Bius Utama'),
('11.04.02.2035','Mekar Indah'),
('11.04.02.2036','Mulie Jadi'),
('11.04.02.2037','Wih Bersih'),
('11.04.02.2038','Wih Sagi Indah'),
('11.04.02.2039','Arul Kumer Barat'),
('11.04.02.2040','Arul Kumer Timur'),
('11.04.02.2041','Arul Kumer Selatan'),
('11.04.03','Bebesen'),
('11.04.03.2001','Blang Kolak I'),
('11.04.03.2002','Bebesan'),
('11.04.03.2003','Mongal'),
('11.04.03.2004','Daling'),
('11.04.03.2005','Tensaran'),
('11.04.03.2006','Lelabu'),
('11.04.03.2007','Blang Gele'),
('11.04.03.2008','Kemili'),
('11.04.03.2009','Tan Saril'),
('11.04.03.2010','Blang Kolak II'),
('11.04.03.2011','Umang'),
('11.04.03.2012','Simpang IV'),
('11.04.03.2013','Bahgie'),
('11.04.03.2014','Keramat Mupakat'),
('11.04.03.2015','Atu Gajah Reje Guru'),
('11.04.03.2016','Atu Tulu'),
('11.04.03.2017','Burbiah'),
('11.04.03.2018','Empus Talu'),
('11.04.03.2019','Gele Lah'),
('11.04.03.2020','Kebet'),
('11.04.03.2021','Lemah Burbana'),
('11.04.03.2022','Mah Bengi'),
('11.04.03.2023','Nunang Antara'),
('11.04.03.2024','Pendere Saril'),
('11.04.03.2025','Sadong Juru Mudi'),
('11.04.03.2026','Ulu Nuwih'),
('11.04.03.2027','Colo Blang Gele'),
('11.04.03.2028','Kala Kemili'),
('11.04.07','Pegasing'),
('11.04.07.2001','Arul Badak'),
('11.04.07.2004','Berawang Baro'),
('11.04.07.2008','Gelelungi'),
('11.04.07.2009','Ie Relop'),
('11.04.07.2010','Kayu Kul'),
('11.04.07.2011','Kedelah'),
('11.04.07.2012','Kung'),
('11.04.07.2013','Kute Lintang'),
('11.04.07.2014','Lelumu'),
('11.04.07.2016','Paya Jeget'),
('11.04.07.2017','Pedekok'),
('11.04.07.2018','Pegasing'),
('11.04.07.2019','Pepalang'),
('11.04.07.2021','Simpang Kelaping'),
('11.04.07.2024','Tebuk'),
('11.04.07.2025','Terang Ulen'),
('11.04.07.2026','Ujung Gele'),
('11.04.07.2029','Wih Ilang'),
('11.04.07.2030','Wih Nareh'),
('11.04.07.2031','Wih Lah'),
('11.04.07.2032','Jejem'),
('11.04.07.2033','Jurusen'),
('11.04.07.2034','Kala Pegasing'),
('11.04.07.2035','Linung Ayu'),
('11.04.07.2036','Panangan Mata'),
('11.04.07.2037','Pantan Musara'),
('11.04.07.2038','Wih Terjun'),
('11.04.07.2039','Belang Bebangka'),
('11.04.07.2040','Uning'),
('11.04.07.2041','Uring'),
('11.04.07.2042','Suka Damai'),
('11.04.08','Bintang'),
('11.04.08.2001','Atu Payung'),
('11.04.08.2002','Bale Nosar'),
('11.04.08.2003','Bamil Nosar'),
('11.04.08.2004','Bewang'),
('11.04.08.2005','Dedamar'),
('11.04.08.2006','Genuren'),
('11.04.08.2007','Kala Bintang'),
('11.04.08.2008','Kala Segi'),
('11.04.08.2009','Kejurun Syiah Utama'),
('11.04.08.2010','Kelitu Sintep'),
('11.04.08.2011','Kuala I'),
('11.04.08.2012','Kuala II'),
('11.04.08.2013','Linung Bulen I'),
('11.04.08.2014','Linung Bulen II'),
('11.04.08.2015','Mengaya'),
('11.04.08.2016','Mude Nosar'),
('11.04.08.2017','Serule'),
('11.04.08.2018','Wakil Jalil'),
('11.04.08.2019','Wihlah Setie'),
('11.04.08.2020','Gegarang'),
('11.04.08.2021','Jamur Konyel'),
('11.04.08.2022','Merodot'),
('11.04.08.2023','Sintep'),
('11.04.08.2024','Gele Pulo'),
('11.04.10','Ketol'),
('11.04.10.2001','Bah'),
('11.04.10.2002','Blang Mancung'),
('11.04.10.2003','Bintang Pepara'),
('11.04.10.2004','Burlah'),
('11.04.10.2005','Buter'),
('11.04.10.2006','Cang Duri'),
('11.04.10.2007','Gelumpang Payung'),
('11.04.10.2008','Jaluk'),
('11.04.10.2009','Kala Ketol'),
('11.04.10.2010','Karang Ampar'),
('11.04.10.2011','Kekuyang'),
('11.04.10.2012','Kute Gelime'),
('11.04.10.2013','Pantan Penyo'),
('11.04.10.2014','Pantan Reduk'),
('11.04.10.2015','Pondok Balik'),
('11.04.10.2016','Rejewali'),
('11.04.10.2017','Serempah'),
('11.04.10.2018','Bergang'),
('11.04.10.2019','Blang Mancung Bawah'),
('11.04.10.2020','Buge Ara'),
('11.04.10.2021','Genting Bulen'),
('11.04.10.2022','Jalan Tengah'),
('11.04.10.2023','Jerata'),
('11.04.10.2024','Simpang Juli'),
('11.04.10.2025','Selon'),
('11.04.11','Kebayakan'),
('11.04.11.2001','Bukit Sama'),
('11.04.11.2002','Gunung Bukit'),
('11.04.11.2003','Jongok Meluem'),
('11.04.11.2004','Kelupak Mata'),
('11.04.11.2005','Lot Kala'),
('11.04.11.2006','Mendale'),
('11.04.11.2007','Paya Reje Tami Delem'),
('11.04.11.2008','Paya Tumpi'),
('11.04.11.2009','Pinangan'),
('11.04.11.2010','Bukit'),
('11.04.11.2011','Bukit Ewih Tami Delem'),
('11.04.11.2012','Gunung Bahgie'),
('11.04.11.2013','Gunung Balohen'),
('11.04.11.2014','Jongkok Bathin'),
('11.04.11.2015','Kala Lengkio'),
('11.04.11.2016','Kute Lot'),
('11.04.11.2017','Paya Tumpi Baru'),
('11.04.11.2018','Paya Tumpi I'),
('11.04.11.2019','Timangan Gading'),
('11.04.11.2020','Telege Atu'),
('11.04.12','Kute Panang'),
('11.04.12.2001','Atu Gogop'),
('11.04.12.2002','Balik'),
('11.04.12.2003','Buter Balik'),
('11.04.12.2004','Dedingin'),
('11.04.12.2005','Kute Panang'),
('11.04.12.2006','Lukub Sabun'),
('11.04.12.2007','Pantan Sile'),
('11.04.12.2008','Ratawali'),
('11.04.12.2009','Segene Balik'),
('11.04.12.2010','Tapak Moge'),
('11.04.12.2011','Tawar Miko'),
('11.04.12.2012','Tawardi'),
('11.04.12.2013','Timang Rasa'),
('11.04.12.2014','Wih Nongkal'),
('11.04.12.2015','Bukit Rata'),
('11.04.12.2016','Lukub Sabun Barat'),
('11.04.12.2017','Lukub Sabun Tengah'),
('11.04.12.2018','Lukub Sabun Timur'),
('11.04.12.2019','Wih Nongkal Toa'),
('11.04.12.2020','Tapak Moge Timur'),
('11.04.12.2021','Empu Balik'),
('11.04.12.2022','Blang Balik'),
('11.04.12.2023','Kala Nongkal'),
('11.04.12.2024','Pantan Jerik'),
('11.04.13','Celala'),
('11.04.13.2001','Arul Gading'),
('11.04.13.2002','Belang Kekumur'),
('11.04.13.2003','Berawang Gading'),
('11.04.13.2004','Celala'),
('11.04.13.2005','Cibro'),
('11.04.13.2006','Kuyun'),
('11.04.13.2007','Kuyun Toa'),
('11.04.13.2008','Kuyun Uken'),
('11.04.13.2009','Makmur'),
('11.04.13.2010','Melala'),
('11.04.13.2011','Paya Kolak'),
('11.04.13.2012','Ramung Ara'),
('11.04.13.2013','Sepakat'),
('11.04.13.2014','Tanoh Depet'),
('11.04.13.2015','Uning Berawang Ramung'),
('11.04.13.2016','Blang Delem'),
('11.04.13.2017','Depet Indah'),
('11.04.17','Laut Tawar'),
('11.04.17.2001','Takengon Timur'),
('11.04.17.2002','Asir Asir'),
('11.04.17.2003','Asir Asir Asia'),
('11.04.17.2004','Bale Atu'),
('11.04.17.2005','Bujang'),
('11.04.17.2006','Gunung Suku'),
('11.04.17.2007','Hakim Bale Bujang'),
('11.04.17.2008','Kenawat'),
('11.04.17.2009','Kuteni Reje'),
('11.04.17.2010','Pedemun One One'),
('11.04.17.2011','Rawe'),
('11.04.17.2012','Takengon Barat'),
('11.04.17.2013','Toweren Antara'),
('11.04.17.2014','Toweren Toa'),
('11.04.17.2015','Toweren Uken'),
('11.04.17.2016','Teluk One-One'),
('11.04.17.2017','Merah Mersa'),
('11.04.17.2018','Waq Toweren'),
('11.04.18','Atu Lintang'),
('11.04.18.2001','Atu Lintang'),
('11.04.18.2002','Merah Mege'),
('11.04.18.2003','Merah Pupuk'),
('11.04.18.2004','Merah Muyang'),
('11.04.18.2005','Gayo Murni'),
('11.04.18.2006','Kepala Akal'),
('11.04.18.2007','Tanoh Abu'),
('11.04.18.2008','Bintang Kekelip'),
('11.04.18.2009','Merah Jernang'),
('11.04.18.2010','Damar Mulyo'),
('11.04.18.2011','Pantan Damar'),
('11.04.19','Jagong Jeget'),
('11.04.19.2001','Merah Said'),
('11.04.19.2002','Berawang Dewal'),
('11.04.19.2003','Gegarang'),
('11.04.19.2004','Telege Sari'),
('11.04.19.2005','Jeget Ayu'),
('11.04.19.2006','Paya Tungel'),
('11.04.19.2007','Jagong Jeget'),
('11.04.19.2008','Bukit Sari'),
('11.04.19.2009','Bukit Kemuning'),
('11.04.19.2010','Paya Dedep'),
('11.04.20','Bies'),
('11.04.20.2001','Bies Penentanan'),
('11.04.20.2002','Bies Baru'),
('11.04.20.2003','Bies Mulie'),
('11.04.20.2004','Arul Latong'),
('11.04.20.2005','Simpang Lukup Badak'),
('11.04.20.2006','Atang Jungket'),
('11.04.20.2007','Tebes Lues'),
('11.04.20.2008','Pucuk Deku'),
('11.04.20.2009','Lenga'),
('11.04.20.2010','Uning Pegantungen'),
('11.04.20.2011','Simpang Uning Niken'),
('11.04.20.2012','Karang Bayur'),
('11.04.21','Rusip Antara'),
('11.04.21.2001','Pantan Tengah'),
('11.04.21.2002','Rusip'),
('11.04.21.2003','Pilar'),
('11.04.21.2004','Arul Pertik'),
('11.04.21.2005','Pilar Jaya'),
('11.04.21.2006','Tirmi Ara'),
('11.04.21.2007','Atu Singkih'),
('11.04.21.2008','Pantan Bener'),
('11.04.21.2009','Kerawang'),
('11.04.21.2010','Mekar Maju'),
('11.04.21.2011','Paya Tampu'),
('11.04.21.2012','Tanjung'),
('11.04.21.2013','Merandeh Paya'),
('11.04.21.2014','Kuala Rawa'),
('11.04.21.2015','Pilar Wih Kiri'),
('11.04.21.2016','Lut Jaya'),
('11.05','Kabupaten Aceh Barat'),
('11.05.01','Johan Pahlawan'),
('11.05.01.2001','Suak Indrapuri'),
('11.05.01.2002','Kampung Belakang'),
('11.05.01.2003','Ujong Kalak'),
('11.05.01.2004','Kuta Padang'),
('11.05.01.2005','Ujong Baroh'),
('11.05.01.2006','Rundeng'),
('11.05.01.2007','Drien Rampak'),
('11.05.01.2008','Pasir'),
('11.05.01.2009','Pasar Aceh'),
('11.05.01.2010','Padang Seurahet'),
('11.05.01.2011','Panggong'),
('11.05.01.2012','Seuneubok'),
('11.05.01.2013','Gampong Darat'),
('11.05.01.2014','Gampa'),
('11.05.01.2015','Lapang'),
('11.05.01.2016','Blang Beurandang'),
('11.05.01.2017','Suak Ribee'),
('11.05.01.2018','Suak Raya'),
('11.05.01.2019','Suak Nie'),
('11.05.01.2020','Leuhan'),
('11.05.01.2021','Suak Sigadeng'),
('11.05.02','Kaway XVI'),
('11.05.02.2001','Keude Aron'),
('11.05.02.2002','Kampong Mesjid'),
('11.05.02.2003','Padang Mancang'),
('11.05.02.2004','Meunasah Buloh'),
('11.05.02.2005','Alue Tampak'),
('11.05.02.2006','Beureugang'),
('11.05.02.2007','Marek'),
('11.05.02.2008','Pasi Jambu'),
('11.05.02.2009','Meunasah Ara'),
('11.05.02.2010','Meunasah Rayeuk'),
('11.05.02.2011','Simpang'),
('11.05.02.2012','Peunia'),
('11.05.02.2013','Tumpok Ladang'),
('11.05.02.2014','Pasi Teungoh'),
('11.05.02.2015','Putim'),
('11.05.02.2016','Meunasah Rambot'),
('11.05.02.2017','Pasi Jeumpa'),
('11.05.02.2018','Palimbungan'),
('11.05.02.2019','Muko'),
('11.05.02.2020','Meunasah Gantung'),
('11.05.02.2021','Blang Geunang'),
('11.05.02.2022','Puuk'),
('11.05.02.2023','Tanjong Bungong'),
('11.05.02.2024','Alue On'),
('11.05.02.2036','Tanjong Meulaboh'),
('11.05.02.2037','Keude Tanjong'),
('11.05.02.2038','Pungkie'),
('11.05.02.2039','Pucok Pungkie'),
('11.05.02.2040','Teladan'),
('11.05.02.2041','Pasi Ara'),
('11.05.02.2042','Meunuang Tanjong'),
('11.05.02.2043','Alue Lhee'),
('11.05.02.2044','Blang Dalam'),
('11.05.02.2045','Teupin Panah'),
('11.05.02.2046','Drien Caleue'),
('11.05.02.2047','Alue Peudeung'),
('11.05.02.2048','Pasi Meugat'),
('11.05.02.2049','Babah Meulaboh'),
('11.05.02.2050','Pasi Kumbang'),
('11.05.02.2051','Padang Sikabu'),
('11.05.02.2052','Sawang Teubei'),
('11.05.02.2053','Alue Lhok'),
('11.05.02.2062','Batu Jaya'),
('11.05.02.2063','Keuramat'),
('11.05.03','Sungai Mas'),
('11.05.03.2001','Tungkop'),
('11.05.03.2002','Sakuy'),
('11.05.03.2003','Kajeung'),
('11.05.03.2004','Geudong'),
('11.05.03.2005','Sarah Perlak'),
('11.05.03.2006','Tutut'),
('11.05.03.2007','Drien Sibak'),
('11.05.03.2008','Tuwi Saya'),
('11.05.03.2009','Lancong'),
('11.05.03.2010','Sipot'),
('11.05.03.2011','Pungkie'),
('11.05.03.2012','Gunong Buloh'),
('11.05.03.2013','Ramitie'),
('11.05.03.2014','Lubok Beutong'),
('11.05.03.2015','Gleng'),
('11.05.03.2016','Tanoh Mirah'),
('11.05.03.2017','Gaseu'),
('11.05.03.2018','Lueng Baro'),
('11.05.04','Woyla'),
('11.05.04.2001','Kuala Bhee'),
('11.05.04.2002','Pasi Lunak'),
('11.05.04.2003','Pasi Aceh'),
('11.05.04.2004','Aron Tunong'),
('11.05.04.2005','Aron Baroh'),
('11.05.04.2006','Pasi Pandan'),
('11.05.04.2007','Ranto Panyang'),
('11.05.04.2008','Geumpa Raya'),
('11.05.04.2009','Padang Jawa'),
('11.05.04.2010','Ie Itam Tunong'),
('11.05.04.2011','Ie Itam Baroh'),
('11.05.04.2012','Tingkeum Panyang'),
('11.05.04.2013','Lueng Teungku Yah'),
('11.05.04.2014','Lueng Tanoh Tho'),
('11.05.04.2015','Gunong Rambong'),
('11.05.04.2016','Drien Mangko'),
('11.05.04.2017','Gunong Hampa'),
('11.05.04.2018','Lueng Jawa'),
('11.05.04.2019','Blang Mee'),
('11.05.04.2020','Alue Blang'),
('11.05.04.2021','Paya Dua'),
('11.05.04.2022','Paya Luah'),
('11.05.04.2023','Pasi Ara'),
('11.05.04.2024','Alue Sikaya'),
('11.05.04.2025','Darul Huda'),
('11.05.04.2026','Keuleumbah'),
('11.05.04.2027','Jawa'),
('11.05.04.2028','Pulo Ie'),
('11.05.04.2029','Alue Panyang'),
('11.05.04.2030','Cot Keumude'),
('11.05.04.2031','Seumantok'),
('11.05.04.2032','Cot Situah'),
('11.05.04.2033','Jawi'),
('11.05.04.2034','Panton'),
('11.05.04.2035','Pasi Birah'),
('11.05.04.2036','Alue Sundak'),
('11.05.04.2037','Teumarom'),
('11.05.04.2038','Cot Murong'),
('11.05.04.2039','Glee Siblah'),
('11.05.04.2040','Suak Trieng'),
('11.05.04.2041','Cot Lagan Bubon'),
('11.05.04.2042','Bakat'),
('11.05.04.2043','Lueng Buloh'),
('11.05.05','Samatiga'),
('11.05.05.2001','Alue Raya'),
('11.05.05.2002','Cot Darat'),
('11.05.05.2003','Cot Pluh'),
('11.05.05.2004','Cot Seumeureung'),
('11.05.05.2005','Cot Mesjid'),
('11.05.05.2006','Cot Lampise'),
('11.05.05.2007','Cot Seulamat'),
('11.05.05.2008','Cot Amun'),
('11.05.05.2009','Deuah'),
('11.05.05.2010','Gampong Teungoh'),
('11.05.05.2011','Gampong Ladang'),
('11.05.05.2012','Gampong Cot'),
('11.05.05.2013','Keureuseng'),
('11.05.05.2014','Krueng Tinggai'),
('11.05.05.2015','Kuala Bubon'),
('11.05.05.2016','Leubok'),
('11.05.05.2017','Lhok Bubon'),
('11.05.05.2018','Leukeun'),
('11.05.05.2019','Mesjid baro'),
('11.05.05.2020','Paya Lumpat'),
('11.05.05.2021','Pinem'),
('11.05.05.2022','Pange'),
('11.05.05.2023','Pucok Lueng'),
('11.05.05.2024','Rangkileh'),
('11.05.05.2025','Reusak'),
('11.05.05.2026','Suak Pandan'),
('11.05.05.2027','Suak Seuke'),
('11.05.05.2028','Suak Pante Breuh'),
('11.05.05.2029','Suak Geudeubang'),
('11.05.05.2030','Suak Seumaseh'),
('11.05.05.2031','Suak Timah'),
('11.05.05.2032','Ujong Nga'),
('11.05.06','Bubon'),
('11.05.06.2001','Alue Lhok'),
('11.05.06.2002','Alue Bakong'),
('11.05.06.2003','Beurawang'),
('11.05.06.2004','Blang Sibeutong'),
('11.05.06.2005','Cot Keumuneng'),
('11.05.06.2006','Cot Lada'),
('11.05.06.2007','Gunong Panah'),
('11.05.06.2008','Kuta Padang'),
('11.05.06.2009','Kuala Pling'),
('11.05.06.2010','Layung'),
('11.05.06.2011','Liceh'),
('11.05.06.2012','Peulanteu SP'),
('11.05.06.2013','Rambong'),
('11.05.06.2014','Seumuleng'),
('11.05.06.2015','Suak Pangkat'),
('11.05.06.2016','Seuneubok Trap'),
('11.05.06.2017','Ulee Blang'),
('11.05.07','Arongan Lambalek'),
('11.05.07.2001','Arongan'),
('11.05.07.2002','Alue Bagok'),
('11.05.07.2003','Alue Sundak'),
('11.05.07.2004','Alue Batee'),
('11.05.07.2005','Cot Buloh'),
('11.05.07.2006','Cot Kumbang'),
('11.05.07.2007','Cot Juru Mudi'),
('11.05.07.2008','Drien Rampak'),
('11.05.07.2009','Kubu'),
('11.05.07.2010','Keub'),
('11.05.07.2011','Pante Mutia'),
('11.05.07.2012','Peuribu'),
('11.05.07.2013','Panton Makmu'),
('11.05.07.2014','Panton Bahagia'),
('11.05.07.2015','Peulanteu LB'),
('11.05.07.2016','Rimba Langgeh'),
('11.05.07.2017','Suak Keumudee'),
('11.05.07.2018','Seuneubok Lhong'),
('11.05.07.2019','Suak Ie Beuso'),
('11.05.07.2020','Suak Bidok'),
('11.05.07.2021','Simpang peut'),
('11.05.07.2022','Seuneubok Teungoh'),
('11.05.07.2023','Teupin Peraho'),
('11.05.07.2024','Ujong Beusa'),
('11.05.07.2025','Ujong Simpang'),
('11.05.07.2026','Gunong Pulo'),
('11.05.07.2027','Karang Hampa'),
('11.05.08','Pante Ceureumen'),
('11.05.08.2001','Seumara'),
('11.05.08.2002','Babah Lueng'),
('11.05.08.2003','Babah Iseung'),
('11.05.08.2004','Seumantok'),
('11.05.08.2005','Alue Keumang'),
('11.05.08.2006','Meunuang Kinco'),
('11.05.08.2007','Lango'),
('11.05.08.2008','Sikundo'),
('11.05.08.2009','Lawet'),
('11.05.08.2010','Canggai'),
('11.05.08.2011','Manjeng'),
('11.05.08.2012','Keutambang'),
('11.05.08.2013','Pante Ceuremen'),
('11.05.08.2014','Pulo Teungoh Manjeng'),
('11.05.08.2015','Jambak'),
('11.05.08.2016','Tegal Sari'),
('11.05.08.2017','Gunong Tarok'),
('11.05.08.2018','Suak Awe'),
('11.05.08.2019','Kreung Beukah'),
('11.05.08.2020','Lhok Sari'),
('11.05.08.2021','Babah Krueng Tep Lep'),
('11.05.08.2022','Berdikari'),
('11.05.08.2023','Lhok Guci'),
('11.05.08.2024','Keude Suak Awe'),
('11.05.08.2025','Sawang Rambot'),
('11.05.09','Meureubo'),
('11.05.09.2001','Ranto Panyang Barat'),
('11.05.09.2002','Ranto Panyang Timur'),
('11.05.09.2003','Mesjid Tuha'),
('11.05.09.2004','Ujong Tanoh Darat'),
('11.05.09.2005','Pasi Aceh Tunong'),
('11.05.09.2006','Pasi Aceh Baroh'),
('11.05.09.2007','Buloh'),
('11.05.09.2008','Pulo Teungoh'),
('11.05.09.2009','Paya Baro Ranto P'),
('11.05.09.2010','Ranub Dong'),
('11.05.09.2011','Pasi Pinang'),
('11.05.09.2012','Pasi Mesjid'),
('11.05.09.2013','Meureubo'),
('11.05.09.2014','Langung'),
('11.05.09.2015','Gunong Kleng'),
('11.05.09.2016','Ujong Drien'),
('11.05.09.2017','Peunaga Rayeuk'),
('11.05.09.2018','Peunaga Pasi'),
('11.05.09.2019','Peunaga Cut Ujong'),
('11.05.09.2020','Reudeup'),
('11.05.09.2021','Balee'),
('11.05.09.2022','Paya Peunaga'),
('11.05.09.2023','Ujong Tanjong'),
('11.05.09.2024','Pucok Reudeup'),
('11.05.09.2025','Sumber Batu'),
('11.05.09.2026','Bukit Jaya'),
('11.05.10','Woyla Barat'),
('11.05.10.2001','Blang Luah LM'),
('11.05.10.2002','Cot Rambong'),
('11.05.10.2003','Lhok Malee'),
('11.05.10.2004','Pasi Malee'),
('11.05.10.2005','Napai'),
('11.05.10.2006','Blang Cot Mameh'),
('11.05.10.2007','Blang Cot Rubek'),
('11.05.10.2008','Alue Leuhob'),
('11.05.10.2009','Leubok Pasi Ara'),
('11.05.10.2010','Ulee Pasi Ara'),
('11.05.10.2011','Cot Lagan LM'),
('11.05.10.2012','Lueng Baro'),
('11.05.10.2013','Kulam Kaju'),
('11.05.10.2014','Alue Perman'),
('11.05.10.2015','Peuleukueng'),
('11.05.10.2016','Pasi Jeut'),
('11.05.10.2017','Mon Pasong'),
('11.05.10.2018','Pasi Mali'),
('11.05.10.2019','Karak'),
('11.05.10.2020','Ie Sayang'),
('11.05.10.2021','Ulee Pulo'),
('11.05.10.2022','Pasi Panyang'),
('11.05.10.2023','Alue Keumuning'),
('11.05.10.2024','Simpang Teumarom'),
('11.05.11','Woyla Timur'),
('11.05.11.2001','Seuradeuk'),
('11.05.11.2002','Lubuk Panyang'),
('11.05.11.2003','Paya Baro'),
('11.05.11.2004','Kubu Capang'),
('11.05.11.2005','Pasi Ara WT'),
('11.05.11.2006','Gampong Baro WT'),
('11.05.11.2007','Rambong'),
('11.05.11.2008','Cot Punti'),
('11.05.11.2009','Alue Eumpeuk'),
('11.05.11.2010','Alue Bilie'),
('11.05.11.2011','Pasi Janeng'),
('11.05.11.2012','Tangkeh'),
('11.05.11.2013','Alue Kuyun'),
('11.05.11.2014','Bukit Meugajah'),
('11.05.11.2015','Blang Dalam'),
('11.05.11.2016','Teumiket Ranom'),
('11.05.11.2017','Blang Makmue'),
('11.05.11.2018','Gampong Baro KB'),
('11.05.11.2019','Alue Meuganda'),
('11.05.11.2020','Alue Seuralen'),
('11.05.11.2021','Rambong Pinto'),
('11.05.11.2022','Tuwi Eumpeuk'),
('11.05.11.2023','Blang Luah KB'),
('11.05.11.2024','Seuneubok Dalam'),
('11.05.11.2025','Paya Meugendrang'),
('11.05.11.2026','Gunong Panyang'),
('11.05.12','Panton Reu'),
('11.05.12.2001','Meutulang'),
('11.05.12.2002','Mugo Cut'),
('11.05.12.2003','Mugo Rayeuk'),
('11.05.12.2004','Baro Paya'),
('11.05.12.2005','Sibintang'),
('11.05.12.2006','Blang Teungoh'),
('11.05.12.2007','Antong'),
('11.05.12.2008','Ujong Raja'),
('11.05.12.2009','Paya Baro Meuko'),
('11.05.12.2010','Tuwi Buya'),
('11.05.12.2011','Kuala Manyeu'),
('11.05.12.2012','Manggie'),
('11.05.12.2013','Gampong Baro'),
('11.05.12.2014','Tamping'),
('11.05.12.2015','Cot Manggie'),
('11.05.12.2016','Blang Balee'),
('11.05.12.2017','Babah Krueng Manggie'),
('11.05.12.2018','Gunong Mata Ie'),
('11.05.12.2019','Lek-Lek'),
('11.06','Kabupaten Aceh Besar'),
('11.06.01','Lhoong'),
('11.06.01.2001','Meunasah Krueng Kala'),
('11.06.01.2002','Jantang'),
('11.06.01.2003','Baroh Krueng Kala'),
('11.06.01.2004','Tunong Krueng Kala'),
('11.06.01.2005','Sungko Mulat'),
('11.06.01.2006','Birek'),
('11.06.01.2007','Kareung'),
('11.06.01.2008','Paroy'),
('11.06.01.2009','Teungoh Blang Mee'),
('11.06.01.2010','Lamkuta Blang Mee'),
('11.06.01.2011','Baroh Blang Mee'),
('11.06.01.2012','Umong Seuribee'),
('11.06.01.2013','Teungoh Geunteut'),
('11.06.01.2014','Baroh Geunteut'),
('11.06.01.2015','Lam Juhang'),
('11.06.01.2016','Utamong'),
('11.06.01.2017','Gapuy'),
('11.06.01.2018','Lamsujen'),
('11.06.01.2019','Mon Mata'),
('11.06.01.2020','Lamgeuriheu'),
('11.06.01.2021','Keutapang'),
('11.06.01.2022','Saney'),
('11.06.01.2023','Cundien'),
('11.06.01.2024','Glee Bruek'),
('11.06.01.2025','Pasi'),
('11.06.01.2026','Pudeng'),
('11.06.01.2027','Meunasah Cot'),
('11.06.01.2028','Meunasah Lhok'),
('11.06.02','Lhoknga'),
('11.06.02.2001','Mon Ikeun'),
('11.06.02.2002','Nusa'),
('11.06.02.2003','Weu Raya'),
('11.06.02.2004','Lamkrut'),
('11.06.02.2005','Lamgaboh'),
('11.06.02.2006','Lambaro Kueh'),
('11.06.02.2007','Lam Ateuk'),
('11.06.02.2008','Kueh'),
('11.06.02.2009','Tanjong'),
('11.06.02.2010','Aneuk Paya'),
('11.06.02.2011','Seubun Keutapang'),
('11.06.02.2012','Seubun Ayon'),
('11.06.02.2013','Lambaro Seubun'),
('11.06.02.2014','Naga Umbang'),
('11.06.02.2015','Lampaya'),
('11.06.02.2016','Meunasah Mesjid Lamlhom'),
('11.06.02.2017','Meunasah Mon Cut'),
('11.06.02.2018','Meunasah Manyang'),
('11.06.02.2019','Meunasah Lam Girek'),
('11.06.02.2020','Meunasah Lambaro'),
('11.06.02.2021','Meunasah Baro Lamlhom'),
('11.06.02.2022','Meunasah Beutong'),
('11.06.02.2023','Mns. Mesjid Lampuuk'),
('11.06.02.2024','Meunasah Balee'),
('11.06.02.2025','Meunasah Karieng'),
('11.06.02.2026','Lamcok'),
('11.06.02.2027','Meunasah Cut'),
('11.06.02.2028','Meunasah Blang'),
('11.06.03','Indrapuri'),
('11.06.03.2001','Reukih Dayah'),
('11.06.03.2002','Indrapuri'),
('11.06.03.2003','Lam Leubok'),
('11.06.03.2004','Empee Ara'),
('11.06.03.2005','Limo Blang'),
('11.06.03.2006','Limo Mesjid'),
('11.06.03.2007','Limo Lamleuweung'),
('11.06.03.2008','Lheue'),
('11.06.03.2009','Meusale'),
('11.06.03.2010','Cureh'),
('11.06.03.2011','Cot Kareung'),
('11.06.03.2012','Lamlung'),
('11.06.03.2013','Meureu Ulee Titie'),
('11.06.03.2014','Meureu Bueng-U'),
('11.06.03.2015','Mureu Baro'),
('11.06.03.2016','Meureu Lamglumpang'),
('11.06.03.2017','Pasar Indrapuri'),
('11.06.03.2018','Manggra'),
('11.06.03.2019','Reukih Kupula'),
('11.06.03.2020','Lam Ilie Mesjid'),
('11.06.03.2021','Lam Ilie Tengoh'),
('11.06.03.2022','Lam Ilie Ganto'),
('11.06.03.2023','Meunara'),
('11.06.03.2024','Aneuk Glee'),
('11.06.03.2025','Krueng Lamkareung'),
('11.06.03.2026','Sinyeu'),
('11.06.03.2027','Seureumo'),
('11.06.03.2028','Ulee Kareung'),
('11.06.03.2029','Lambeutong'),
('11.06.03.2030','Lampupok Baro'),
('11.06.03.2031','Lampupok Raya'),
('11.06.03.2032','Seulangai'),
('11.06.03.2033','Riting'),
('11.06.03.2034','Sihom Lhok'),
('11.06.03.2035','Sihom Cot'),
('11.06.03.2036','Seuot Baroh'),
('11.06.03.2037','Seuot Tunong'),
('11.06.03.2038','Lampanah Ranjo'),
('11.06.03.2039','Lampanah Teungoh'),
('11.06.03.2040','Lampanah Dayah'),
('11.06.03.2041','Lampanah Baro'),
('11.06.03.2042','Lampanah Tunong'),
('11.06.03.2043','Groet Blang'),
('11.06.03.2044','Groet Manyang'),
('11.06.03.2045','Groet Baro'),
('11.06.03.2046','Jruek Bak Kreh'),
('11.06.03.2047','Jruek Balee'),
('11.06.03.2049','Mon Alue'),
('11.06.03.2050','Lambeunot'),
('11.06.03.2051','Ulee Ue'),
('11.06.03.2052','Lamsiot'),
('11.06.03.2053','Lingom'),
('11.06.04','Seulimeum'),
('11.06.04.2001','Peukan Seulimeum'),
('11.06.04.2002','Keunaloi'),
('11.06.04.2003','Lhieb'),
('11.06.04.2004','Alue Gintong'),
('11.06.04.2005','Gampong Seulimeum'),
('11.06.04.2006','Data Gaseu'),
('11.06.04.2007','Rabo'),
('11.06.04.2008','Gampong Raya'),
('11.06.04.2009','Lamjruen'),
('11.06.04.2010','Buga'),
('11.06.04.2011','Jawie'),
('11.06.04.2012','Alue Rindang'),
('11.06.04.2013','Iboh Tunong'),
('11.06.04.2014','Iboh Tanjong'),
('11.06.04.2015','Seuneubok'),
('11.06.04.2016','Meunasah Baro'),
('11.06.04.2017','Meunasah Tunong'),
('11.06.04.2018','Batee Lhee'),
('11.06.04.2019','Mangeu'),
('11.06.04.2020','Bayu'),
('11.06.04.2021','Ayon'),
('11.06.04.2022','Lamteuba Droe'),
('11.06.04.2023','Pulo'),
('11.06.04.2024','Lampantee'),
('11.06.04.2025','Lambada'),
('11.06.04.2026','Blang Tingkeum'),
('11.06.04.2027','Ateuk'),
('11.06.04.2028','Lam Apeng'),
('11.06.04.2029','Meurah'),
('11.06.04.2030','Lampanah'),
('11.06.04.2031','Ujong Mesjid Lampanah'),
('11.06.04.2032','Ujong Keupula'),
('11.06.04.2033','Leungah'),
('11.06.04.2034','Beureunut'),
('11.06.04.2035','Meunasah Jeumpa'),
('11.06.04.2036','Pinto Khop'),
('11.06.04.2037','Bak Seutui'),
('11.06.04.2038','Bak Aghu'),
('11.06.04.2039','Kayee Adang'),
('11.06.04.2040','Lamkuk'),
('11.06.04.2041','Ujong Mesjid Tanoh Abee'),
('11.06.04.2042','Lamcarak'),
('11.06.04.2043','Capeung Dayah'),
('11.06.04.2044','Capeung Baroh'),
('11.06.04.2045','Lampisang Dayah'),
('11.06.04.2046','Lampisang Tunong'),
('11.06.04.2047','Lampisang Teungoh'),
('11.06.05','Montasik'),
('11.06.05.2001','Mata Ie'),
('11.06.05.2002','Gampong Baroh'),
('11.06.05.2003','Lampaseh Lhok'),
('11.06.05.2004','Lampaseh Krueng'),
('11.06.05.2005','Lamnga'),
('11.06.05.2006','Dayah Daboh'),
('11.06.05.2007','Weu Lhok'),
('11.06.05.2008','Alue'),
('11.06.05.2009','Weu Krueng'),
('11.06.05.2010','Seubam Cot'),
('11.06.05.2011','Bak Dilip'),
('11.06.05.2012','Ulee Lhat'),
('11.06.05.2015','Lamraya'),
('11.06.05.2016','Lamme Garot'),
('11.06.05.2017','Weu Bada'),
('11.06.05.2018','Meunasah Tutong'),
('11.06.05.2019','Empee Tanong'),
('11.06.05.2020','Bak Cirih'),
('11.06.05.2021','Warabo'),
('11.06.05.2022','Teubang Phui Mesjid'),
('11.06.05.2023','Teubang Phui Baro'),
('11.06.05.2024','Bira Cot'),
('11.06.05.2025','Bira Lhok'),
('11.06.05.2026','Bung Tujoh'),
('11.06.05.2027','Peurumping'),
('11.06.05.2028','Atong'),
('11.06.05.2029','Reudeup'),
('11.06.05.2042','Seubam Lhok'),
('11.06.05.2043','Seumet'),
('11.06.05.2044','Cot Seunong'),
('11.06.05.2045','Mon Ara'),
('11.06.05.2046','Cot Lhok'),
('11.06.05.2047','Cot Lampoh Soh'),
('11.06.05.2048','Bueng Raya'),
('11.06.05.2049','Piyeung Lhang'),
('11.06.05.2050','Piyeung Manee'),
('11.06.05.2051','Bueng Daroh'),
('11.06.05.2052','Kuweu'),
('11.06.05.2053','Piyeung Datu'),
('11.06.06','Sukamakmur'),
('11.06.06.2001','Reuhat Tuha'),
('11.06.06.2002','Weusiteh'),
('11.06.06.2003','Dilib Lamteungoh'),
('11.06.06.2004','Baet Lampuot'),
('11.06.06.2005','Dilib Bukit'),
('11.06.06.2006','Seumeureung'),
('11.06.06.2007','Sibreh Keumudee'),
('11.06.06.2008','Baet Mesago'),
('11.06.06.2009','Baet Mesjid'),
('11.06.06.2010','Lambaro Sibreh'),
('11.06.06.2011','Lamgeu Baro'),
('11.06.06.2012','Lamgeu Tuha'),
('11.06.06.2013','Lampanah Ineu'),
('11.06.06.2014','Tampok Jeurat Raya'),
('11.06.06.2015','Tampok Blang'),
('11.06.06.2016','Lamteh Dayah'),
('11.06.06.2017','Lam Lheu'),
('11.06.06.2018','Lambarih Jurong Raya'),
('11.06.06.2019','Bukloh'),
('11.06.06.2020','Niron'),
('11.06.06.2021','Aneuk Galong Baro'),
('11.06.06.2022','Aneuk Galong Titi'),
('11.06.06.2023','Blang Cut'),
('11.06.06.2024','Klieng Mayang'),
('11.06.06.2025','Aneuk Batee'),
('11.06.06.2026','Meunasah Tuha'),
('11.06.06.2027','Lampisang'),
('11.06.06.2028','Meunasah Bakthu'),
('11.06.06.2029','Lambarih Bak Mee'),
('11.06.06.2030','Luthu Dayah Krueng'),
('11.06.06.2031','Luthu Lamweu'),
('11.06.06.2032','Panterawa'),
('11.06.06.2033','Lambirah'),
('11.06.06.2034','Kayee Adang'),
('11.06.06.2035','Lam Tanjong'),
('11.06.07','Darul Imarah'),
('11.06.07.2001','Lampeuneurut Ujong Blang'),
('11.06.07.2002','Lampeuneurut Gampong'),
('11.06.07.2003','Lamreung'),
('11.06.07.2004','Lamcot'),
('11.06.07.2005','Lam Blang Trieng'),
('11.06.07.2006','Lam Blang Mayang'),
('11.06.07.2007','Bayu'),
('11.06.07.2008','Lagang'),
('11.06.07.2009','Lamsiteh'),
('11.06.07.2010','Lamkawe'),
('11.06.07.2011','Lheu Blang'),
('11.06.07.2012','Payaroh'),
('11.06.07.2013','Lamsidaya'),
('11.06.07.2014','Kuta Karang'),
('11.06.07.2015','Leu Geu'),
('11.06.07.2016','Lampeuneun'),
('11.06.07.2017','Lamtheun'),
('11.06.07.2018','Deunong'),
('11.06.07.2019','Tingkuem'),
('11.06.07.2020','Kandang'),
('11.06.07.2021','Lam Bheu'),
('11.06.07.2022','Daroy Kameu'),
('11.06.07.2023','Geundrieng'),
('11.06.07.2024','Garot'),
('11.06.07.2025','Pasheu Beutong'),
('11.06.07.2026','Lampasi Engking'),
('11.06.07.2027','Jeumpet Ajun'),
('11.06.07.2028','Gue Gajah'),
('11.06.07.2029','Leu Ue'),
('11.06.07.2030','Ulee Lueng'),
('11.06.07.2031','Punie'),
('11.06.07.2032','Ulee Tuy'),
('11.06.08','Peukan Bada'),
('11.06.08.2001','Lambadeuk'),
('11.06.08.2002','Lamguron'),
('11.06.08.2003','Lambaro Nejid'),
('11.06.08.2004','Lampageu'),
('11.06.08.2005','Gampong Baro'),
('11.06.08.2006','Lam Manyang'),
('11.06.08.2007','Lamteh'),
('11.06.08.2008','Lam Lumpu'),
('11.06.08.2009','Lamteungoh'),
('11.06.08.2010','Lamtutui'),
('11.06.08.2011','Meunasah Tuha'),
('11.06.08.2012','Lam Awe'),
('11.06.08.2013','Pulo Bunta'),
('11.06.08.2014','Beuradeun'),
('11.06.08.2015','Lampisang'),
('11.06.08.2016','Keuneu Eu'),
('11.06.08.2017','Lam Isek'),
('11.06.08.2018','Lamkeumok'),
('11.06.08.2019','Lam Rukam'),
('11.06.08.2020','Gurah'),
('11.06.08.2021','Rima Jeuneu'),
('11.06.08.2022','Lam Geu Eu'),
('11.06.08.2023','Lam Hasan'),
('11.06.08.2024','Paya Tieng'),
('11.06.08.2025','Ajuen'),
('11.06.08.2026','Rima Keuneurom'),
('11.06.09','Mesjid Raya'),
('11.06.09.2001','Meunasah Kulam'),
('11.06.09.2002','Beurandeh'),
('11.06.09.2003','Ie Seum'),
('11.06.09.2004','Meunasah Keudee'),
('11.06.09.2005','Lamreh'),
('11.06.09.2006','Meunasah Mon'),
('11.06.09.2007','Paya Kameng'),
('11.06.09.2008','Ruyung'),
('11.06.09.2009','Ladong'),
('11.06.09.2010','Gampong Baro'),
('11.06.09.2011','Durung'),
('11.06.09.2012','Neuheun'),
('11.06.09.2013','Lamnga'),
('11.06.10','Ingin Jaya'),
('11.06.10.2001','Lambaro'),
('11.06.10.2002','Meunasah Manyang Lam Garot'),
('11.06.10.2003','Bakoy'),
('11.06.10.2004','Meunasah Baro'),
('11.06.10.2005','Meunasah Deyah'),
('11.06.10.2006','Meunasah Tutong'),
('11.06.10.2007','Siron'),
('11.06.10.2008','Pasie Lamgarot'),
('11.06.10.2009','Dham Ceukok'),
('11.06.10.2010','Dham Pulo'),
('11.06.10.2011','Lubok Sukon'),
('11.06.10.2012','Lubok Gapuy'),
('11.06.10.2013','Pasie Lubuk'),
('11.06.10.2014','Bung Ceukok'),
('11.06.10.2015','Teubang Phuy'),
('11.06.10.2016','Ateuk Anggok'),
('11.06.10.2017','Ajee Rayeuk'),
('11.06.10.2018','Ajee Cut'),
('11.06.10.2019','Gani'),
('11.06.10.2020','Ateuk Lueng Ie'),
('11.06.10.2021','Cot Alue'),
('11.06.10.2022','Cot Suruy'),
('11.06.10.2023','Cot Bada'),
('11.06.10.2024','Ajee Pagar Air'),
('11.06.10.2025','Meunasah Krueng'),
('11.06.10.2026','Jurong Peujera'),
('11.06.10.2027','Lubok Batee'),
('11.06.10.2028','Bineh Blang'),
('11.06.10.2029','Pantee'),
('11.06.10.2030','Kalut'),
('11.06.10.2031','Meunasah Manyang Pagar Air'),
('11.06.10.2032','Meunasah Manyet'),
('11.06.10.2033','Santan'),
('11.06.10.2034','Tanjong'),
('11.06.10.2035','Reuloh'),
('11.06.10.2041','Paleuh Blang'),
('11.06.10.2042','Cot Mentiwan'),
('11.06.10.2043','Lampreh Lam Jampok'),
('11.06.10.2044','Paleuh Pulo'),
('11.06.10.2045','Lamcot'),
('11.06.10.2046','Lamsinyeu'),
('11.06.10.2047','Lam Ue'),
('11.06.10.2048','Cot Gud'),
('11.06.10.2049','Lamdaya'),
('11.06.10.2050','Lambada'),
('11.06.10.2051','Ujong XII'),
('11.06.10.2052','Bada'),
('11.06.10.2053','Lamteungoh'),
('11.06.10.2054','Kayee Lee'),
('11.06.10.2056','Lampreh Lamteungoh'),
('11.06.11','Kuta Baro'),
('11.06.11.2001','Krueng Anoi'),
('11.06.11.2002','Lam Puuk'),
('11.06.11.2003','Cot Beut'),
('11.06.11.2004','Bueng Bakjok'),
('11.06.11.2005','Lam Neuheun'),
('11.06.11.2006','Seupeu'),
('11.06.11.2007','Cot Mancang'),
('11.06.11.2008','Lam Baet'),
('11.06.11.2009','Cot Masam'),
('11.06.11.2016','Gue'),
('11.06.11.2018','Lam Sabang'),
('11.06.11.2019','Lam Alue Raya'),
('11.06.11.2020','Lam Alue Cut'),
('11.06.11.2021','Leupung Mesjid'),
('11.06.11.2022','Cot Lamee'),
('11.06.11.2023','Leupung Ulee Alue'),
('11.06.11.2024','Lampoh Tarom'),
('11.06.11.2025','Lamteube Geupula'),
('11.06.11.2026','Lamteube Mon Ara'),
('11.06.11.2027','Aron'),
('11.06.11.2028','Bak Buloh'),
('11.06.11.2029','Lam Seunong'),
('11.06.11.2030','Lam Raya'),
('11.06.11.2031','Lam Roh'),
('11.06.11.2032','Lambunot Tanoh'),
('11.06.11.2033','Tumpok Lampoh'),
('11.06.11.2034','Puuk'),
('11.06.11.2035','Lambunot Paya'),
('11.06.11.2036','Lampoh Keude'),
('11.06.11.2037','Lam Asan'),
('11.06.11.2038','Lambro Deyah'),
('11.06.11.2039','Lambro Bileu'),
('11.06.11.2040','Cot Peutano'),
('11.06.11.2041','Cot Cut'),
('11.06.11.2042','Meunasah Baktrieng'),
('11.06.11.2043','Babah Jurong'),
('11.06.11.2044','Lam Glumpang'),
('11.06.11.2045','Rabeu'),
('11.06.11.2046','Cucum'),
('11.06.11.2047','Deyah'),
('11.06.11.2048','Lam Trieng'),
('11.06.11.2049','Beurangong'),
('11.06.11.2050','Cot Preh'),
('11.06.11.2051','Cot Raya'),
('11.06.11.2052','Cot Yang'),
('11.06.11.2053','Ujong Blang'),
('11.06.11.2054','Lamceu'),
('11.06.12','Darussalam'),
('11.06.12.2001','Angan'),
('11.06.12.2002','Lam Peudaya'),
('11.06.12.2003','Lambada Peukan'),
('11.06.12.2004','Lambiheu La'),
('11.06.12.2005','Lambaro Sukon'),
('11.06.12.2006','Miruek Taman'),
('11.06.12.2007','Suleue'),
('11.06.12.2008','Gampong Cot'),
('11.06.12.2009','Gampong Blang'),
('11.06.12.2010','Lampuja'),
('11.06.12.2011','Tanjung Deah'),
('11.06.12.2012','Limpok'),
('11.06.12.2013','Lampuuk'),
('11.06.12.2014','Lam Ujong'),
('11.06.12.2015','Lam Gawe'),
('11.06.12.2016','Berabung'),
('11.06.12.2017','Lamtimpeung'),
('11.06.12.2018','Tungkop'),
('11.06.12.2019','Tanjong Seulamat'),
('11.06.12.2020','Lamkeunung'),
('11.06.12.2021','Lam Duroy'),
('11.06.12.2022','Lam Klat'),
('11.06.12.2023','Lambiheu Siem'),
('11.06.12.2024','Lambitra'),
('11.06.12.2025','Lie Eue'),
('11.06.12.2026','Krueng Kalee'),
('11.06.12.2027','Lam Asan'),
('11.06.12.2028','Lam Reh'),
('11.06.12.2029','Siem'),
('11.06.13','Pulo Aceh'),
('11.06.13.2001','Rinon'),
('11.06.13.2002','Alue Raya'),
('11.06.13.2003','Melingge'),
('11.06.13.2004','Lapeng'),
('11.06.13.2005','Ulee Paya'),
('11.06.13.2006','Gugop'),
('11.06.13.2007','Seurapong'),
('11.06.13.2008','Blang Situngkoh'),
('11.06.13.2009','Paloh'),
('11.06.13.2010','Lampuyang'),
('11.06.13.2011','Lhok'),
('11.06.13.2012','Teunom'),
('11.06.13.2013','Lamteng'),
('11.06.13.2014','Pasi Janeng'),
('11.06.13.2015','Rabo'),
('11.06.13.2016','Alue Reuyeueng'),
('11.06.13.2017','Deudap'),
('11.06.14','Lembah Seulawah'),
('11.06.14.2001','Lamtamot'),
('11.06.14.2002','Lambaro Tunong'),
('11.06.14.2003','Lonbaroh'),
('11.06.14.2004','Lon Asan'),
('11.06.14.2005','Paya Keureuleh'),
('11.06.14.2006','Panca'),
('11.06.14.2007','Lam Kubu'),
('11.06.14.2008','Panca Kubu'),
('11.06.14.2009','Suka Damai'),
('11.06.14.2010','Suka Mulya'),
('11.06.14.2011','Saree Aceh'),
('11.06.14.2012','Teuladan'),
('11.06.15','Kota Jantho'),
('11.06.15.2001','Teureubeh'),
('11.06.15.2002','Barueh'),
('11.06.15.2003','Jantho'),
('11.06.15.2004','Awek'),
('11.06.15.2005','Data Cut'),
('11.06.15.2006','Bueng'),
('11.06.15.2007','Weu'),
('11.06.15.2008','Jalin'),
('11.06.15.2009','Suka Tani'),
('11.06.15.2010','Cucum'),
('11.06.15.2011','Jantho Baru'),
('11.06.15.2012','Jantho Makmur'),
('11.06.15.2013','Bukit Meusara'),
('11.06.16','Kuta Cot Glie'),
('11.06.16.2001','Lampakuk'),
('11.06.16.2002','Lampoh Raja'),
('11.06.16.2003','Lam Aling'),
('11.06.16.2004','Lamleupung'),
('11.06.16.2005','Lamkleng'),
('11.06.16.2006','Ie Alang Lamkreumeuh'),
('11.06.16.2007','Ie Alang Lamghui'),
('11.06.16.2008','Ie Alang Mesjid'),
('11.06.16.2009','Ie Alang Dayah'),
('11.06.16.2010','Lamtui'),
('11.06.16.2011','Barih Lhok'),
('11.06.16.2012','Bueng Simek'),
('11.06.16.2013','Banda Safa'),
('11.06.16.2014','Bithak'),
('11.06.16.2015','Lambeugak'),
('11.06.16.2016','Pakuk'),
('11.06.16.2017','Lamsie'),
('11.06.16.2018','Sigapang'),
('11.06.16.2019','Tutui'),
('11.06.16.2020','Pasar Lampaku'),
('11.06.16.2021','Maheng'),
('11.06.16.2022','Leupung Bruek'),
('11.06.16.2023','Keumireu'),
('11.06.16.2024','Lamleuot'),
('11.06.16.2025','Leupung Balue'),
('11.06.16.2026','Bak Sukon'),
('11.06.16.2027','Cot Bayu'),
('11.06.16.2028','Glee Jai'),
('11.06.16.2029','Keuruweung Blang'),
('11.06.16.2030','Keuruweung Krueng'),
('11.06.16.2031','Siron Blang'),
('11.06.16.2032','Siron Krueng'),
('11.06.17','Kuta Malaka'),
('11.06.17.2001','Lambaro Samahani'),
('11.06.17.2002','Lam Ara Cut'),
('11.06.17.2003','Lam Ara Engkit'),
('11.06.17.2004','Lam Ara Tunong'),
('11.06.17.2005','Leupung Riwat'),
('11.06.17.2006','Tumbo Baro'),
('11.06.17.2007','Leupung Cut'),
('11.06.17.2008','Lamsiteh Cot'),
('11.06.17.2009','Reuleung Karieng'),
('11.06.17.2010','Leubok Buni'),
('11.06.17.2011','Leubok Batee'),
('11.06.17.2012','Bunghu'),
('11.06.17.2013','Teu Dayah'),
('11.06.17.2014','Leupung Rayeuk'),
('11.06.17.2015','Reuleung Glumpang'),
('11.06.18','Simpang Tiga'),
('11.06.18.2001','Ateuk Lam Phang'),
('11.06.18.2002','Ateuk Lampuot'),
('11.06.18.2003','Ateuk Mon Panah'),
('11.06.18.2004','Ateuk Lam Ura'),
('11.06.18.2005','Ateuk Cut'),
('11.06.18.2006','Ateuk Blang Asan'),
('11.06.18.2007','Lamjamee Dayah'),
('11.06.18.2008','Lam Batee'),
('11.06.18.2009','Nya'),
('11.06.18.2010','Batee Linteung'),
('11.06.18.2011','Krueng Mak'),
('11.06.18.2012','Lambunot'),
('11.06.18.2013','Lamjamee Lamkrak'),
('11.06.18.2014','Blang Miro'),
('11.06.18.2015','Blang Preh'),
('11.06.18.2016','Bha Ulee Tutu'),
('11.06.18.2017','Lam Urit'),
('11.06.18.2018','Tantuha'),
('11.06.19','Darul Kamal'),
('11.06.19.2001','Lhang'),
('11.06.19.2002','Biluy'),
('11.06.19.2003','Lambatee'),
('11.06.19.2004','Lamkunyet'),
('11.06.19.2005','Lamtadok'),
('11.06.19.2006','Neusok'),
('11.06.19.2007','Turam'),
('11.06.19.2008','Tubaluy'),
('11.06.19.2009','Blang Kiree'),
('11.06.19.2010','Manee Dayah'),
('11.06.19.2011','Lamsod'),
('11.06.19.2012','Lambleut'),
('11.06.19.2013','Empee Trieng'),
('11.06.19.2014','Lambaro Biluy'),
('11.06.20','Baitussalam'),
('11.06.20.2001','Cadek'),
('11.06.20.2002','Kajhu'),
('11.06.20.2003','Baet'),
('11.06.20.2004','Blang Krueng'),
('11.06.20.2005','Klieng Muria'),
('11.06.20.2006','Lam Bada Lhok'),
('11.06.20.2007','Lampineung'),
('11.06.20.2008','Lam Asan'),
('11.06.20.2009','Labuy'),
('11.06.20.2010','Lam Ujong'),
('11.06.20.2011','Klieng Cot Aron'),
('11.06.20.2012','Cot Paya'),
('11.06.20.2013','Miruk Lam Reudep'),
('11.06.21','Krueng Barona Jaya'),
('11.06.21.2001','Meunasah Papeun'),
('11.06.21.2002','Meunasah Baktrieng'),
('11.06.21.2003','Leung Ie'),
('11.06.21.2004','Lampermai'),
('11.06.21.2005','Gle Deyah'),
('11.06.21.2006','Miruk'),
('11.06.21.2007','Lam Gapang'),
('11.06.21.2008','Meunasah Manyang'),
('11.06.21.2009','Meunasah Baet'),
('11.06.21.2010','Meunasah Intan'),
('11.06.21.2011','Rumpet'),
('11.06.21.2012','Gla Meunasah Baro'),
('11.06.22','Leupung'),
('11.06.22.2001','Layeun'),
('11.06.22.2002','Pulot'),
('11.06.22.2003','Lamseunia'),
('11.06.22.2004','Mns. Mesjid'),
('11.06.22.2005','Meunasah Bak U'),
('11.06.22.2006','Dayah Mamplam'),
('11.06.23','Blang Bintang'),
('11.06.23.2001','Cot Puklat'),
('11.06.23.2002','Lamme'),
('11.06.23.2003','Meulayo'),
('11.06.23.2004','Lam Siem'),
('11.06.23.2005','Cot Geundreut'),
('11.06.23.2006','Paya Ue'),
('11.06.23.2007','Cot Mon Raya'),
('11.06.23.2008','Cot Meulangeun'),
('11.06.23.2009','Cot Madhi'),
('11.06.23.2010','Bueng Sidom'),
('11.06.23.2011','Cot Karieng'),
('11.06.23.2012','Kampung Blang'),
('11.06.23.2013','Cot Malem'),
('11.06.23.2014','Cot Rumpun'),
('11.06.23.2015','Cot Hoho'),
('11.06.23.2016','Cot Jambo'),
('11.06.23.2017','Cot Nambak'),
('11.06.23.2018','Bueng Pageu'),
('11.06.23.2019','Cot Sayun'),
('11.06.23.2020','Teupin Batee'),
('11.06.23.2021','Cot Leuot'),
('11.06.23.2022','Cot Bagie'),
('11.06.23.2023','Kayee Kunyet'),
('11.06.23.2024','Cot Mancang'),
('11.06.23.2025','Empee Bata'),
('11.06.23.2026','Data Makmur'),
('11.07','Kabupaten Pidie'),
('11.07.03','Batee'),
('11.07.03.2001','Dayah Tuha'),
('11.07.03.2002','Dayah Baroh'),
('11.07.03.2003','Bintang Hu'),
('11.07.03.2004','Pulo Tukok'),
('11.07.03.2005','Pulo Bungong'),
('11.07.03.2006','Geunteng Barat'),
('11.07.03.2007','Geunteng Timur'),
('11.07.03.2008','Calong Cut'),
('11.07.03.2009','Glumpang Lhee'),
('11.07.03.2010','Aron'),
('11.07.03.2011','Tuha'),
('11.07.03.2012','Dayah'),
('11.07.03.2013','Mesjid'),
('11.07.03.2014','Meucat'),
('11.07.03.2015','Teupin Raya'),
('11.07.03.2016','Rungkom'),
('11.07.03.2017','Mee'),
('11.07.03.2018','Pulo Pande'),
('11.07.03.2019','Seulatan'),
('11.07.03.2020','Alue Lada'),
('11.07.03.2021','Teupin Jeue'),
('11.07.03.2022','Neuheun'),
('11.07.03.2023','Crueng'),
('11.07.03.2024','Kareung'),
('11.07.03.2025','Kulee'),
('11.07.03.2026','Kulam'),
('11.07.03.2027','Awe'),
('11.07.03.2028','Pasi Beurandeh'),
('11.07.04','Delima'),
('11.07.04.2001','Tunong'),
('11.07.04.2002','Raya'),
('11.07.04.2003','Daboh'),
('11.07.04.2004','Cut'),
('11.07.04.2005','Mesjid Reubee'),
('11.07.04.2006','Tanjong'),
('11.07.04.2007','Geudong'),
('11.07.04.2008','Reuntoh'),
('11.07.04.2009','Reuba'),
('11.07.04.2010','Krueng Reubee'),
('11.07.04.2011','Neulop'),
('11.07.04.2012','Glee'),
('11.07.04.2013','Kumbang'),
('11.07.04.2014','Buloh'),
('11.07.04.2015','Bungo'),
('11.07.04.2016','Dayah Reubee'),
('11.07.04.2017','Jambee'),
('11.07.04.2018','Dayah Baro'),
('11.07.04.2019','Puuk Aree'),
('11.07.04.2020','Lhee Meunasah'),
('11.07.04.2021','Ulee Tutue Raya'),
('11.07.04.2022','Mesjid Aree'),
('11.07.04.2023','Keutapang Aree'),
('11.07.04.2024','Pantee Aree'),
('11.07.04.2025','Pulo Tunong'),
('11.07.04.2026','Pulo Baroh Aree'),
('11.07.04.2027','Keurumbok'),
('11.07.04.2028','Ceurih Blang Mee'),
('11.07.04.2029','Ceurih Kupula'),
('11.07.04.2030','Ceurih Alue'),
('11.07.04.2031','Ceurih Cot'),
('11.07.04.2032','Seupeung'),
('11.07.04.2033','Sukon Lhong'),
('11.07.04.2034','Dayah Beuah'),
('11.07.04.2035','Krueng Cot'),
('11.07.04.2036','Mesjid Beuah'),
('11.07.04.2037','Lueng Dama'),
('11.07.04.2038','Mesjid Bambong'),
('11.07.04.2039','Ruseb'),
('11.07.04.2040','Sagoe'),
('11.07.04.2041','Seukeum'),
('11.07.04.2042','Pangoe'),
('11.07.04.2043','Keutapang Bambong'),
('11.07.04.2044','Metareum'),
('11.07.05','Geumpang'),
('11.07.05.2001','Bangkeh'),
('11.07.05.2002','Pucok'),
('11.07.05.2004','Leupu'),
('11.07.05.2005','Pulo Lhoih'),
('11.07.05.2006','Keune'),
('11.07.06','Glumpang Tiga'),
('11.07.06.2001','Simpang'),
('11.07.06.2002','Krueng Jangko'),
('11.07.06.2003','Krueng Nyong'),
('11.07.06.2004','Cot Baroh'),
('11.07.06.2005','Cot Tunong'),
('11.07.06.2006','Bili'),
('11.07.06.2007','Panjoe'),
('11.07.06.2008','Amud Mesjid'),
('11.07.06.2009','Reudeup Meulayu'),
('11.07.06.2010','Dayah Tanoh'),
('11.07.06.2011','Mamplam'),
('11.07.06.2012','Balee'),
('11.07.06.2013','Kupula'),
('11.07.06.2014','Pulo Lueng Teuga'),
('11.07.06.2015','Sukon Mesjid'),
('11.07.06.2016','Sukon Baroh'),
('11.07.06.2017','Kruet Teumpeun'),
('11.07.06.2018','Blang Drang'),
('11.07.06.2019','Ude Gampong'),
('11.07.06.2020','Kayee Jatoe'),
('11.07.06.2021','Kampong Jeumpa'),
('11.07.06.2022','Pulo Lon / Pulo Dayah'),
('11.07.06.2023','Jurong Pande'),
('11.07.06.2024','Pulo Gajah Mate'),
('11.07.06.2025','Tufah Jeulatang'),
('11.07.06.2026','Kumbang Keupula'),
('11.07.06.2027','Pulo Batee'),
('11.07.06.2028','Meunjee'),
('11.07.06.2029','Keutapang Mesjid'),
('11.07.06.2030','Dayah Kp. Pisang'),
('11.07.06.2031','Blang Tunong'),
('11.07.06.2032','Blang Pueb'),
('11.07.06.2033','Lambaro'),
('11.07.06.2034','Neurok'),
('11.07.07','Indrajaya'),
('11.07.07.2001','Tampieng Tunong'),
('11.07.07.2002','Tampieng Baroh'),
('11.07.07.2003','Dayah Caleue'),
('11.07.07.2004','Jurong'),
('11.07.07.2005','Keutapang'),
('11.07.07.2006','Dayah Keurako'),
('11.07.07.2007','Mesjid Lam Ujong'),
('11.07.07.2008','Baro Jruek'),
('11.07.07.2009','Yub Mee'),
('11.07.07.2010','Raya Lhok Kaju'),
('11.07.07.2011','Pulo Gampong U'),
('11.07.07.2012','Pante Lhok Kaju'),
('11.07.07.2014','Sukon Tungkop'),
('11.07.07.2015','Rawa Tungkop'),
('11.07.07.2016','Mesjid Tungkop'),
('11.07.07.2017','Dayah Muara Garot'),
('11.07.07.2018','Pante Garot'),
('11.07.07.2019','Garot Cut'),
('11.07.07.2020','Keubang'),
('11.07.07.2021','Blang Garot'),
('11.07.07.2022','Meulayu'),
('11.07.07.2023','Tungkop Cut'),
('11.07.07.2024','Guci'),
('11.07.07.2025','Teungoh Blang'),
('11.07.07.2026','Mesjid Dijiem'),
('11.07.07.2027','Sukon Ulee Gampong'),
('11.07.07.2028','Lamkabu'),
('11.07.07.2029','Ulee Birah'),
('11.07.07.2030','Mesjid Baro'),
('11.07.07.2031','Lamreuneung'),
('11.07.07.2032','Cot Seukee'),
('11.07.07.2033','Drien'),
('11.07.07.2034','Rumia'),
('11.07.07.2035','Wakheuh'),
('11.07.07.2036','Baro Bluek'),
('11.07.07.2037','Mesjid Ulee Gampong'),
('11.07.07.2038','Dayah Bie'),
('11.07.07.2039','Balee Baroh Bluek'),
('11.07.07.2040','Peutoe'),
('11.07.07.2041','Blang Rapai'),
('11.07.07.2042','Neulop II'),
('11.07.07.2043','Baro Gapui'),
('11.07.07.2044','Balee Baroh Gapui'),
('11.07.07.2045','Glee Gapui'),
('11.07.07.2046','Teungoh Suwiek'),
('11.07.07.2047','Mesjid Suwiek'),
('11.07.07.2048','Tuha Suwiek'),
('11.07.07.2049','Beureudep'),
('11.07.07.2050','Blang Lhok Kaju'),
('11.07.08','Kembang Tanjong'),
('11.07.08.2001','Jurong Balee'),
('11.07.08.2002','Aron Asan Kumbang'),
('11.07.08.2003','Cebrek'),
('11.07.08.2004','Jurong Mesjid'),
('11.07.08.2005','Meunasah Gantung'),
('11.07.08.2006','Babah Jurong'),
('11.07.08.2007','Keupula'),
('11.07.08.2008','Meunasah Jareng'),
('11.07.08.2009','Arusan'),
('11.07.08.2010','Tanjong Krueng'),
('11.07.08.2011','Lancang'),
('11.07.08.2012','Pasi Lhok'),
('11.07.08.2013','Jeumeurang'),
('11.07.08.2014','Pusong'),
('11.07.08.2015','Meuraksa'),
('11.07.08.2016','Kayee Panyang'),
('11.07.08.2017','Panjoe'),
('11.07.08.2018','Asan'),
('11.07.08.2019','Meunasah Mesjid'),
('11.07.08.2020','Meunasah Mee'),
('11.07.08.2021','Meunasah Teungoh'),
('11.07.08.2022','Pasi ie Leubeue'),
('11.07.08.2023','Keude ie Leubeue'),
('11.07.08.2024','Meunasah Sukon'),
('11.07.08.2025','Meunasah Ara'),
('11.07.08.2026','Meunasah Krueng'),
('11.07.08.2027','Krueng Dhoe'),
('11.07.08.2028','Meunasah Baro'),
('11.07.08.2029','Bentayan'),
('11.07.08.2030','Meunasah Kandang'),
('11.07.08.2031','Lamkawe'),
('11.07.08.2032','Puuk'),
('11.07.08.2033','Tanjong'),
('11.07.08.2034','Dayah Blang'),
('11.07.08.2035','Dayah Mon Ara'),
('11.07.08.2036','Keureumbok'),
('11.07.08.2037','Meunasah Manyang'),
('11.07.08.2038','Matang Kuli'),
('11.07.08.2039','Reung-Reung'),
('11.07.08.2040','Teumpeun'),
('11.07.08.2041','Blang Cut'),
('11.07.08.2042','Geuleumpang'),
('11.07.08.2043','Aron Kuta Baro'),
('11.07.08.2044','Barat'),
('11.07.08.2045','Araih'),
('11.07.09','Kota Sigli'),
('11.07.09.2001','Blang Paseh'),
('11.07.09.2002','Benteng'),
('11.07.09.2003','Blok Bengkel'),
('11.07.09.2004','Pante Teungoh'),
('11.07.09.2005','Kuala Pidie'),
('11.07.09.2006','Kramat Luar'),
('11.07.09.2007','Kramat Dalam'),
('11.07.09.2008','Blok Sawah'),
('11.07.09.2009','Blang Asan'),
('11.07.09.2010','Lampoh Krueng'),
('11.07.09.2011','Kampong Asan'),
('11.07.09.2012','Meunasah Peukan'),
('11.07.09.2013','Pasi Rawa'),
('11.07.09.2014','Pasi Peukan Baro'),
('11.07.09.2015','Tanjong Krueng'),
('11.07.11','Mila'),
('11.07.11.2001','Blang'),
('11.07.11.2002','Teumeucet'),
('11.07.11.2003','Blang Cut'),
('11.07.11.2004','Kumbang'),
('11.07.11.2005','Pulo Tanjong'),
('11.07.11.2006','Ara Bungkok'),
('11.07.11.2007','Lagang'),
('11.07.11.2008','Mesjid Ilot'),
('11.07.11.2009','Baroh Ilot'),
('11.07.11.2010','Tunong Ilot'),
('11.07.11.2011','Teungoh Ilot'),
('11.07.11.2012','Dayah Andeue'),
('11.07.11.2013','Dayah Sinthop'),
('11.07.11.2014','Kulu'),
('11.07.11.2015','Mesjid Andeue'),
('11.07.11.2016','Meuyub Lala'),
('11.07.11.2017','Tuha Lala'),
('11.07.11.2018','Lhok Lubu'),
('11.07.11.2019','Babah Jurong'),
('11.07.11.2020','Krueng Lala'),
('11.07.12','Muara Tiga'),
('11.07.12.2001','Cot'),
('11.07.12.2002','Tgk Dilaweueng'),
('11.07.12.2003','Mesjid'),
('11.07.12.2004','Keupula'),
('11.07.12.2005','Suka Jaya'),
('11.07.12.2006','Pawod'),
('11.07.12.2007','Deyah'),
('11.07.12.2008','Krueng'),
('11.07.12.2009','Gle Cut'),
('11.07.12.2010','IE Masen'),
('11.07.12.2011','Sagoe'),
('11.07.12.2012','Ujong Pie'),
('11.07.12.2013','Blang Raya'),
('11.07.12.2014','Batee'),
('11.07.12.2015','Ingin Jaya'),
('11.07.12.2016','Papeun'),
('11.07.12.2017','Tuha Biheue'),
('11.07.12.2018','Simpang Beutong'),
('11.07.13','Mutiara'),
('11.07.13.2001','Mesjid Yaman'),
('11.07.13.2002','Baro Yaman'),
('11.07.13.2003','Mee Teungoh'),
('11.07.13.2004','Sentosa'),
('11.07.13.2005','Baroh Barat Yaman'),
('11.07.13.2006','Tuha Gampong Gajah'),
('11.07.13.2007','Jadan'),
('11.07.13.2008','Bale Baro Keumangan'),
('11.07.13.2009','Blang Tidiek'),
('11.07.13.2010','Blang Lileue'),
('11.07.13.2011','Keumangan Cut'),
('11.07.13.2012','Mesjid Keumangan'),
('11.07.13.2013','Dayah Tidiek'),
('11.07.13.2014','Lueng Sagoe'),
('11.07.13.2015','Blang Beureueh'),
('11.07.13.2016','Dayah Beureueh'),
('11.07.13.2017','Pante Beureueh'),
('11.07.13.2018','Rapana'),
('11.07.13.2019','Paya Tiba'),
('11.07.13.2020','Paloh Kambuek'),
('11.07.13.2021','Lampoh Sirong'),
('11.07.13.2022','Mee Panyang'),
('11.07.13.2023','Reului'),
('11.07.13.2024','Dayah Syarif'),
('11.07.13.2025','Peureulak'),
('11.07.13.2026','Ribeun'),
('11.07.13.2027','Balee Busu'),
('11.07.13.2028','Lingkok'),
('11.07.13.2029','Kumbang'),
('11.07.14','Padang Tiji'),
('11.07.14.2001','Mesjid Kunyet'),
('11.07.14.2002','Piala Kunyet'),
('11.07.14.2003','Hagu Kunyet'),
('11.07.14.2004','Baro Kunyet'),
('11.07.14.2005','Dayah Tanoh Kunyet'),
('11.07.14.2006','Kambuek Nicah Kunyet'),
('11.07.14.2007','Kambuek Payapi Kunyet'),
('11.07.14.2008','Seunadeu Kunyet'),
('11.07.14.2009','Blang Gunci Kunyet'),
('11.07.14.2010','Dayah Baroh Kunyet'),
('11.07.14.2011','Blang Geuleudieng'),
('11.07.14.2012','Geulumpang Geuleudieng'),
('11.07.14.2013','Mesjid Geuleudieng'),
('11.07.14.2014','Sukon Peudaya'),
('11.07.14.2015','Mesjid Peudaya'),
('11.07.14.2016','Cut Peudaya'),
('11.07.14.2017','Buloh Peudaya'),
('11.07.14.2018','Perlak Peudaya'),
('11.07.14.2019','Dayah Peudaya'),
('11.07.14.2020','Teungoh Peudaya'),
('11.07.14.2021','Tuha Peudaya'),
('11.07.14.2022','Tunong Peudaya'),
('11.07.14.2023','Buni Reulieng Peudaya'),
('11.07.14.2024','Trieng Paloh'),
('11.07.14.2025','Leuhob Paloh'),
('11.07.14.2026','Jurong Gampong Cot Paloh'),
('11.07.14.2027','Suyo Paloh'),
('11.07.14.2028','Kreet Paloh'),
('11.07.14.2029','Capa Paloh'),
('11.07.14.2030','Jurong Anoe Paloh'),
('11.07.14.2031','Balee Paloh'),
('11.07.14.2032','Siron Paloh'),
('11.07.14.2033','Gampong Cut Paloh'),
('11.07.14.2034','Pante Cermen Paloh'),
('11.07.14.2035','Pasar Paloh'),
('11.07.14.2036','Cot Kunyet'),
('11.07.14.2037','Meuke Beurabo'),
('11.07.14.2038','Mesjid Beurabo'),
('11.07.14.2039','Seukeumbrok Beurabo'),
('11.07.14.2040','Baro Beurabo'),
('11.07.14.2041','Adang Beurabo'),
('11.07.14.2042','Paloh Jeurat Beurabo'),
('11.07.14.2043','Seuleunggieng Beurabo'),
('11.07.14.2044','Teungoh Drien Gogo'),
('11.07.14.2045','Kumbang Gogo'),
('11.07.14.2046','Mesjid Gogos'),
('11.07.14.2047','Tuha Gogo'),
('11.07.14.2048','Glee Gogo'),
('11.07.14.2049','Meuke Gogo'),
('11.07.14.2050','Raya Gogo'),
('11.07.14.2051','Grong-Grong Gogo'),
('11.07.14.2052','Aron Bunot Gogo'),
('11.07.14.2053','Buloh Gogo'),
('11.07.14.2054','Tunong Tanjong'),
('11.07.14.2055','Keupula Tanjong'),
('11.07.14.2056','Jok Tanjong'),
('11.07.14.2057','Leun Tanjong'),
('11.07.14.2058','Pante Crueng Tanjong'),
('11.07.14.2059','Cot Keutapang Tanjong'),
('11.07.14.2060','Siron Tanjong'),
('11.07.14.2061','Mesjid Tanjong'),
('11.07.14.2062','Khang Tanjong'),
('11.07.14.2063','Meuriya Tanjong'),
('11.07.14.2064','Pulo Hagu Tanjong'),
('11.07.15','Peukan Baro'),
('11.07.15.2001','Dua Paya'),
('11.07.15.2002','Cot Mulu'),
('11.07.15.2003','Dayah Bubue'),
('11.07.15.2004','Tanjong Hagu'),
('11.07.15.2005','Sumboe Buga'),
('11.07.15.2006','Rambayan Kupula'),
('11.07.15.2007','Rambayan Lueng'),
('11.07.15.2008','Cempala Kuneng'),
('11.07.15.2009','Peunayong'),
('11.07.15.2010','Leuhop'),
('11.07.15.2011','Kumbang waido'),
('11.07.15.2012','Gampong waido'),
('11.07.15.2013','Mee Krukon'),
('11.07.15.2014','Mee Lampoih Saka'),
('11.07.15.2015','Lueng Guci Rumpong'),
('11.07.15.2016','Dayah Seumideun'),
('11.07.15.2017','Mesjid Guci Rumpong'),
('11.07.15.2018','Reuba Waido'),
('11.07.15.2019','Dayah Teungku'),
('11.07.15.2020','Jurong Raya'),
('11.07.15.2021','Balee Rastong'),
('11.07.15.2022','Lueng Mesjid'),
('11.07.15.2023','Teungoh Baroh'),
('11.07.15.2024','Mee Hagu'),
('11.07.15.2025','Dayah Sukon'),
('11.07.15.2026','Blang Raya'),
('11.07.15.2027','Balee Pineung'),
('11.07.15.2028','Menjee Mesjid'),
('11.07.15.2029','Mee Tanoh'),
('11.07.15.2030','Sialet-Alet'),
('11.07.15.2031','Bluek Arab'),
('11.07.15.2032','Puuk'),
('11.07.15.2033','Dayah Muara'),
('11.07.15.2034','Sawiet'),
('11.07.15.2035','Ulee Tutue'),
('11.07.15.2036','Jim'),
('11.07.15.2037','Keutapang'),
('11.07.15.2038','Meuleuweuk'),
('11.07.15.2039','Jurong'),
('11.07.15.2040','Raya Krueng Seumideun'),
('11.07.15.2041','Sukon Krueng Seumideun'),
('11.07.15.2042','Mee Krueng Seumideun'),
('11.07.15.2043','Blang Krueng Seumideun'),
('11.07.15.2044','Keureumbok'),
('11.07.15.2045','Ulee Cot Seupeng'),
('11.07.15.2046','Kabat'),
('11.07.15.2049','Blang Seupeng'),
('11.07.15.2050','Gampong Krueng Seumideun'),
('11.07.16','Pidie'),
('11.07.16.2001','Tijue'),
('11.07.16.2002','Lampeudeu Tunong'),
('11.07.16.2003','Puuk'),
('11.07.16.2004','Lampeudue Baroh'),
('11.07.16.2005','Paya'),
('11.07.16.2006','Mesjid Runtoh'),
('11.07.16.2007','Dayah Teungoh'),
('11.07.16.2008','Baroh'),
('11.07.16.2009','Dayah Tanoh'),
('11.07.16.2010','Cot Geunduek'),
('11.07.16.2011','Tumpok Laweung'),
('11.07.16.2012','Ulee Ceue Keulibeut'),
('11.07.16.2013','Keudee'),
('11.07.16.2014','Ulee Tutue'),
('11.07.16.2015','Dayah Tutong'),
('11.07.16.2016','Lampoh Lada'),
('11.07.16.2017','Keuniree'),
('11.07.16.2018','Tumpok 40'),
('11.07.16.2019','Cot Teungoh'),
('11.07.16.2020','Cot Rheng'),
('11.07.16.2021','Labui'),
('11.07.16.2022','Gampong'),
('11.07.16.2023','Pulo Pisang'),
('11.07.16.2024','Lamkuta'),
('11.07.16.2025','Kampong Pukat'),
('11.07.16.2026','Kampong Barat'),
('11.07.16.2027','Paloh'),
('11.07.16.2028','Kampong Baro'),
('11.07.16.2029','Pulo Bubee'),
('11.07.16.2030','Tibang'),
('11.07.16.2031','Rawa'),
('11.07.16.2032','Peukan Baro'),
('11.07.16.2033','Mancang'),
('11.07.16.2034','Gajah Ayee'),
('11.07.16.2035','Lhok Keutapang'),
('11.07.16.2036','Dalueng'),
('11.07.16.2037','Ulee Ceue Teubeng'),
('11.07.16.2038','Meucat Teubeng'),
('11.07.16.2039','Dayah Teubeng'),
('11.07.16.2040','Tanjong Teubeng'),
('11.07.16.2041','Jawa Teubeng'),
('11.07.16.2042','Bayu Teubeng'),
('11.07.16.2043','Abo Teubeng'),
('11.07.16.2044','Keutapang Sanggeue'),
('11.07.16.2045','Krueng Dhoe'),
('11.07.16.2046','Sirong'),
('11.07.16.2047','Keutumbu'),
('11.07.16.2048','Jeumpa'),
('11.07.16.2049','Raya sanggeue'),
('11.07.16.2050','Jeuleupee'),
('11.07.16.2051','Ujong Langgo'),
('11.07.16.2052','Cot Glumpang'),
('11.07.16.2053','Seuriweuk'),
('11.07.16.2054','Mesjid Utue'),
('11.07.16.2055','Leubue'),
('11.07.16.2056','Batee'),
('11.07.16.2057','Raya Uteu'),
('11.07.16.2058','Seukeumbrok'),
('11.07.16.2059','Bie'),
('11.07.16.2060','Blang Kula'),
('11.07.16.2061','ALue'),
('11.07.16.2062','Seukee'),
('11.07.16.2063','Paya Linteung'),
('11.07.16.2064','Puli'),
('11.07.17','Sakti'),
('11.07.17.2001','Balue Tanoh'),
('11.07.17.2002','Balue Kulu'),
('11.07.17.2003','Lhok Empeh'),
('11.07.17.2004','Cot Sukon'),
('11.07.17.2005','Dayah Tuha'),
('11.07.17.2006','Kampong Cot'),
('11.07.17.2007','Paloh Jeureula'),
('11.07.17.2008','Barieh'),
('11.07.17.2009','Kandang'),
('11.07.17.2010','Riweuek'),
('11.07.17.2011','Mancang'),
('11.07.17.2012','Kampong Pisang Bucue'),
('11.07.17.2013','Bucue'),
('11.07.17.2014','Lhok Panah'),
('11.07.17.2015','Murong Cot'),
('11.07.17.2016','Cumbok Lie'),
('11.07.17.2017','Lam Ujong'),
('11.07.17.2018','Murong Lhok'),
('11.07.17.2019','Blang Cot'),
('11.07.17.2020','Cot Cantek'),
('11.07.17.2021','Blang Kumot Baroh'),
('11.07.17.2022','Blang Kumot Tunong'),
('11.07.17.2023','Cumbok Niwa'),
('11.07.17.2024','Leupeuem Mesjid'),
('11.07.17.2025','Pulo Jeumpa'),
('11.07.17.2026','Beutong Pocut'),
('11.07.17.2027','Beutong Perlak'),
('11.07.17.2028','Kampong Jeumpa'),
('11.07.17.2029','Pante Krueng'),
('11.07.17.2030','Jurong Pante'),
('11.07.17.2032','Mali Lamkuta'),
('11.07.17.2033','Mali Uke'),
('11.07.17.2034','Mali Mesjid'),
('11.07.17.2035','Mali Cot'),
('11.07.17.2036','Tangkueng'),
('11.07.17.2037','Lhok Mee'),
('11.07.17.2038','Lameue Mns. Raya'),
('11.07.17.2039','Lameue Mns. Baro'),
('11.07.17.2040','Lameue Mns. Lueng'),
('11.07.17.2041','Pulo Keureumbok'),
('11.07.17.2042','Dayah Kp Pisang'),
('11.07.17.2043','Mns Blang Sakti'),
('11.07.17.2044','Perlak Baroh'),
('11.07.17.2045','Lingkok'),
('11.07.17.2046','Pasar Kota Bakti'),
('11.07.17.2047','Mns Balee'),
('11.07.17.2048','Perlak Asan'),
('11.07.17.2049','Kampong Baro'),
('11.07.17.2050','Mali Guyui'),
('11.07.18','Simpang Tiga'),
('11.07.18.2001','Raya Paya'),
('11.07.18.2002','Mesjid Bungie'),
('11.07.18.2003','Liliep'),
('11.07.18.2004','Ujong Baroh'),
('11.07.18.2005','Peukan Sot'),
('11.07.18.2006','Sukon'),
('11.07.18.2007','Raya Paleue'),
('11.07.18.2008','Lambideng'),
('11.07.18.2009','Cot Paleue'),
('11.07.18.2010','Seukee'),
('11.07.18.2011','Cebrek'),
('11.07.18.2012','Linggong Sagoe'),
('11.07.18.2013','Kulam Baro'),
('11.07.18.2014','Empeh'),
('11.07.18.2015','Nien'),
('11.07.18.2016','Ceureucok Timur'),
('11.07.18.2017','Ceureukcok Barat'),
('11.07.18.2018','Jaja Baroh'),
('11.07.18.2019','Jaja Tunong'),
('11.07.18.2020','Mesjid Gigieng'),
('11.07.18.2021','Gong'),
('11.07.18.2022','Pulo Raya'),
('11.07.18.2023','Pulo Blang'),
('11.07.18.2024','Mamplam'),
('11.07.18.2025','Meunasah Lhee'),
('11.07.18.2026','Pante'),
('11.07.18.2027','Kupula'),
('11.07.18.2028','Mantak Raya'),
('11.07.18.2029','Peukan Tuha'),
('11.07.18.2030','Dayah Lampoh Awe'),
('11.07.18.2031','Meunasah Blang'),
('11.07.18.2032','Pulo Gajah Mate'),
('11.07.18.2033','Seuk Ceukok'),
('11.07.18.2034','Pulo Tu'),
('11.07.18.2035','Meunasah Jurong'),
('11.07.18.2036','Kampong Blang'),
('11.07.18.2037','Padang'),
('11.07.18.2038','Cot Ara'),
('11.07.18.2039','Dayah Blang Cut'),
('11.07.18.2040','Teungoh Mangki'),
('11.07.18.2041','Dayah Blang'),
('11.07.18.2042','Madika'),
('11.07.18.2043','Sagoe'),
('11.07.18.2044','Ceureucok Sagoe'),
('11.07.18.2045','Bunien'),
('11.07.18.2046','Paloh Tok Due'),
('11.07.18.2047','Mesjid Tungoe'),
('11.07.18.2048','Blang Leuen'),
('11.07.18.2049','Ujong Gampong'),
('11.07.18.2050','Cot Jaja'),
('11.07.18.2051','Lheue'),
('11.07.18.2052','Ulee Barat'),
('11.07.19','Tangse'),
('11.07.19.2001','Keude Tangse'),
('11.07.19.2002','Pulo Mesjid I'),
('11.07.19.2003','Pulo Mesjid II'),
('11.07.19.2004','Pulo Sejahtera'),
('11.07.19.2005','Pulo Kawa'),
('11.07.19.2006','Pulo Seunong'),
('11.07.19.2007','Nubok Badeuk'),
('11.07.19.2008','Blang Jeurat'),
('11.07.19.2009','Pulo Baro'),
('11.07.19.2010','Layan'),
('11.07.19.2011','Blang Dalam'),
('11.07.19.2012','Peunalom I'),
('11.07.19.2013','Peunalom II'),
('11.07.19.2014','Krueng Meuriam'),
('11.07.19.2015','Blang Teungoh'),
('11.07.19.2016','Blang Dhot'),
('11.07.19.2017','Blang Bungong'),
('11.07.19.2018','Ulee Gunong'),
('11.07.19.2019','Keubon Nilam'),
('11.07.19.2020','Paya Guci'),
('11.07.19.2021','Ranto Panyang'),
('11.07.19.2022','Blang Malo'),
('11.07.19.2023','Krueng Seukeuek'),
('11.07.19.2024','Beungga'),
('11.07.19.2025','Alue Calong'),
('11.07.19.2026','Pulo Ie'),
('11.07.19.2027','Lhok Keutapang'),
('11.07.19.2028','Blang Pandak'),
('11.07.21','Tiro/Truseb'),
('11.07.21.2001','Rabo'),
('11.07.21.2002','Pulo Siblah'),
('11.07.21.2003','Lhok Igeuh'),
('11.07.21.2004','Pulo Glumpang'),
('11.07.21.2005','Meunasah Mancang'),
('11.07.21.2006','Pulo Tambo'),
('11.07.21.2007','Pulo Keunari'),
('11.07.21.2008','Peunadok'),
('11.07.21.2009','Pulo Mesjid'),
('11.07.21.2010','Meunasah Panah'),
('11.07.21.2011','Trieng Cudo Baroh'),
('11.07.21.2012','Trieng Cudo Tunong'),
('11.07.21.2013','Mampree'),
('11.07.21.2014','Daya Baroh'),
('11.07.21.2015','Daya Teungoh'),
('11.07.21.2016','Daya Kampong Baro'),
('11.07.21.2017','Daya Cot'),
('11.07.21.2018','Blang Rikui'),
('11.07.21.2019','Panton Beunot'),
('11.07.22','Keumala'),
('11.07.22.2001','U Gadeng'),
('11.07.22.2002','Kumbang'),
('11.07.22.2003','Sagoe'),
('11.07.22.2004','Dayah Keumala'),
('11.07.22.2005','Jijiem'),
('11.07.22.2006','Rheng'),
('11.07.22.2007','Cot Nuran'),
('11.07.22.2008','Pulo Pante'),
('11.07.22.2009','Paloh Teungoh'),
('11.07.22.2010','Asan Nicah'),
('11.07.22.2011','Papeun Nicah'),
('11.07.22.2012','Pulo Seupeng'),
('11.07.22.2013','Mesjid Nicah'),
('11.07.22.2014','Tunong'),
('11.07.22.2015','Pako'),
('11.07.22.2016','Pulo Baro'),
('11.07.22.2017','Cot Kreh'),
('11.07.22.2031','Pulo Cahi'),
('11.07.24','Mutiara Timur'),
('11.07.24.2001','Baroh Ujong Rimba'),
('11.07.24.2002','Jojo'),
('11.07.24.2003','Gampong Cot Usi'),
('11.07.24.2004','Dayah Usi'),
('11.07.24.2005','Paloh lhok Usi'),
('11.07.24.2006','Campli Usi'),
('11.07.24.2007','Mee Tanjong Usi'),
('11.07.24.2008','Mesjid Usi'),
('11.07.24.2009','Paloh Raya'),
('11.07.24.2010','Nibong'),
('11.07.24.2011','Baro Ujong Rimba'),
('11.07.24.2012','Rinti'),
('11.07.24.2013','Didoh'),
('11.07.24.2014','Meugit'),
('11.07.24.2015','Empeh'),
('11.07.24.2016','Blang Riek'),
('11.07.24.2017','Balee Ujong Rimba'),
('11.07.24.2018','Mon Ara'),
('11.07.24.2019','Kulam Ara'),
('11.07.24.2020','Blangong Basah'),
('11.07.24.2021','Rambong'),
('11.07.24.2022','Gampong Lada'),
('11.07.24.2023','Dayah Kumba'),
('11.07.24.2024','Cot Kuthang'),
('11.07.24.2025','Dayah Tanoh'),
('11.07.24.2026','Ulee Tutue'),
('11.07.24.2027','Beureueh II'),
('11.07.24.2028','Mesjid Jeurat Manyang'),
('11.07.24.2029','Paloh Tinggi'),
('11.07.24.2030','Karieng'),
('11.07.24.2031','Sagoe Teumpeun'),
('11.07.24.2032','Tong Peria'),
('11.07.24.2033','Tong Weng'),
('11.07.24.2034','Pulo Drien'),
('11.07.24.2035','Mesjid Gumpueng'),
('11.07.24.2036','Ulee Gampong'),
('11.07.24.2037','Barieh'),
('11.07.24.2038','Jumphoih Adan'),
('11.07.24.2039','Mee Adan'),
('11.07.24.2040','Dayah Adan'),
('11.07.24.2041','Alue Adan'),
('11.07.24.2042','Rambot Adan'),
('11.07.24.2043','Meucat Adan'),
('11.07.24.2044','Tiba Mesjid'),
('11.07.24.2045','Tiba Raya'),
('11.07.24.2046','Reubat'),
('11.07.24.2047','Simbe'),
('11.07.24.2048','Jiem'),
('11.07.25','Grong-grong'),
('11.07.25.2001','Gintong'),
('11.07.25.2002','Mesjid Beureuleung'),
('11.07.25.2003','Beureuleung'),
('11.07.25.2004','Baroh'),
('11.07.25.2005','Mee'),
('11.07.25.2006','Paya'),
('11.07.25.2007','Teungoh'),
('11.07.25.2008','Pangge Pilok'),
('11.07.25.2009','Karieng'),
('11.07.25.2010','Grong-Grong'),
('11.07.25.2011','Nicah'),
('11.07.25.2012','Mesjid Memeuaneuk'),
('11.07.25.2013','Daka'),
('11.07.25.2014','Sentosa'),
('11.07.25.2015','Sukon'),
('11.07.27','Mane'),
('11.07.27.2001','Lutueng'),
('11.07.27.2002','Blang Dalam'),
('11.07.27.2003','Mane'),
('11.07.27.2004','Turue Cut'),
('11.07.29','Glumpang Baro'),
('11.07.29.2001','U. Bungkok'),
('11.07.29.2002','Mee Teumpeun'),
('11.07.29.2003','Kumbang Unoe'),
('11.07.29.2004','Sagoe'),
('11.07.29.2005','Geunteng'),
('11.07.29.2006','Jurong Baro'),
('11.07.29.2007','Sukon Paku'),
('11.07.29.2008','Pulo Iboih'),
('11.07.29.2009','Sangget'),
('11.07.29.2010','Blang Baroh'),
('11.07.29.2011','Manyang'),
('11.07.29.2012','Pulo Panjoe'),
('11.07.29.2013','Balee Gantung'),
('11.07.29.2014','Daboih'),
('11.07.29.2015','Seureukui Cebrek'),
('11.07.29.2016','Glumpang Bungkok'),
('11.07.29.2017','Ukee'),
('11.07.29.2018','Kumbang Trueng Campli'),
('11.07.29.2019','Palong'),
('11.07.29.2020','Seukee'),
('11.07.29.2021','Bungong'),
('11.07.31','Titeue'),
('11.07.31.2001','Lingkok'),
('11.07.31.2002','Pante Kulu'),
('11.07.31.2003','Uke'),
('11.07.31.2004','Pante Siren'),
('11.07.31.2005','Pulo Raya'),
('11.07.31.2006','Cut'),
('11.07.31.2007','Dayah Meunara'),
('11.07.31.2008','Paloh Naleueng'),
('11.07.31.2009','Pulo Lhoih'),
('11.07.31.2010','Mesjid Tongpudeng'),
('11.07.31.2011','Blang Tho'),
('11.07.31.2012','Asan Tongpudeng'),
('11.07.31.2013','Alue'),
('11.08','Kabupaten Aceh Utara'),
('11.08.01','Baktiya'),
('11.08.01.2001','Keude Alue Ie Puteh'),
('11.08.01.2002','Meunasah Alue Ie Puteh'),
('11.08.01.2003','Pucok Alue'),
('11.08.01.2004','Alue Anoe Timu'),
('11.08.01.2005','Alue Anoe Barat'),
('11.08.01.2006','Pulo Seukee'),
('11.08.01.2007','Alue Serdang'),
('11.08.01.2008','Cot Mane'),
('11.08.01.2009','Cot Kumbang'),
('11.08.01.2010','Matang Kumbang'),
('11.08.01.2011','Matang Kareung'),
('11.08.01.2012','Cot Ulaya'),
('11.08.01.2013','Alue Geudong'),
('11.08.01.2014','Tanjong Glumpang'),
('11.08.01.2015','Matang Raya Timu'),
('11.08.01.2016','Matang Raya Barat'),
('11.08.01.2017','Matang Kelayu'),
('11.08.01.2018','Alue Buya'),
('11.08.01.2019','Matang Cut'),
('11.08.01.2020','Keude Panteu Breuh'),
('11.08.01.2021','Meudang Ara'),
('11.08.01.2022','Meunasah Bujok'),
('11.08.01.2023','Alue Dama'),
('11.08.01.2024','Cot Ara'),
('11.08.01.2025','Rambong Dalam'),
('11.08.01.2026','Meunasah Geudong'),
('11.08.01.2027','Alue Keutapang'),
('11.08.01.2028','Krueng Lingka Barat'),
('11.08.01.2029','Krueng Lingka Timu'),
('11.08.01.2030','Alue Jamok'),
('11.08.01.2031','Alue Bili Geulumpang'),
('11.08.01.2032','Lhok Seutuy'),
('11.08.01.2033','Alue Bili Rayeuk'),
('11.08.01.2034','Keude Menjee IV'),
('11.08.01.2035','Glumpang Bungkok'),
('11.08.01.2036','Matang Rawa'),
('11.08.01.2037','Glumpang Samlakoe'),
('11.08.01.2038','Arongan Lise'),
('11.08.01.2039','Matang Reudeup'),
('11.08.01.2040','Matang Manyam'),
('11.08.01.2041','Matang Ulim'),
('11.08.01.2042','Matang Beuringen'),
('11.08.01.2043','Cot Manyang'),
('11.08.01.2044','Alue Ie Tarek'),
('11.08.01.2045','Alue Rambong'),
('11.08.01.2046','Matang Linya'),
('11.08.01.2047','Matang Lawang'),
('11.08.01.2048','Glumpang payong'),
('11.08.01.2049','Mon Sukon'),
('11.08.01.2050','Lueng Bata'),
('11.08.01.2051','Ceumpeudak'),
('11.08.01.2052','Buket Dara Baro'),
('11.08.01.2053','Matang Pineung'),
('11.08.01.2054','Matang Baro'),
('11.08.01.2055','Ujong Dama'),
('11.08.01.2056','Babussalam'),
('11.08.01.2057','Cinta Makmur'),
('11.08.02','Dewantara'),
('11.08.02.2001','Keude Krueng Geukueh'),
('11.08.02.2002','Tambon Baroh'),
('11.08.02.2003','Tambon Tunong'),
('11.08.02.2004','Paloh Gadeng'),
('11.08.02.2005','Paloh Lada'),
('11.08.02.2006','Uteun Geulinggang'),
('11.08.02.2007','Pulo Rungkom'),
('11.08.02.2008','Paloh Igeuh'),
('11.08.02.2009','Bangka Jaya'),
('11.08.02.2010','Ulee Pulo'),
('11.08.02.2011','Ulee Reuleung'),
('11.08.02.2012','Geulumpang Sulu Timu'),
('11.08.02.2013','Geulumpang Sulu Barat'),
('11.08.02.2014','Bluka Teubai'),
('11.08.02.2015','Lancang Barat'),
('11.08.03','Kuta Makmur'),
('11.08.03.2001','Meunasah Blang Ara'),
('11.08.03.2002','Meunasah Buket'),
('11.08.03.2003','Blang Talon'),
('11.08.03.2004','Cot Rheu'),
('11.08.03.2005','Krueng Manyang'),
('11.08.03.2006','Bayu'),
('11.08.03.2007','Blang Ado'),
('11.08.03.2008','Dayah Meunara'),
('11.08.03.2009','Meunasah Kumbang'),
('11.08.03.2010','Meunye Cut Bahagia'),
('11.08.03.2011','Lhok Jok'),
('11.08.03.2012','Alue Rambee'),
('11.08.03.2013','Blang Riek'),
('11.08.03.2014','Cempeudak'),
('11.08.03.2015','Seuneubok Drien'),
('11.08.03.2016','Cot Merbo'),
('11.08.03.2017','Keude Blang Ara'),
('11.08.03.2018','Keude Krueng'),
('11.08.03.2019','Krueng Seunong'),
('11.08.03.2020','Pulo Iboih'),
('11.08.03.2021','Blang Gurah'),
('11.08.03.2022','Guha Uleu'),
('11.08.03.2023','Ceumeucet'),
('11.08.03.2024','Pulo Barat'),
('11.08.03.2025','Pulo Rayeuk'),
('11.08.03.2026','Cot Seutui'),
('11.08.03.2027','Langkuta'),
('11.08.03.2028','Saweuk'),
('11.08.03.2029','Meuria'),
('11.08.03.2030','Meunasah Kulam'),
('11.08.03.2031','Cot Seumiyong'),
('11.08.03.2032','Keureusek'),
('11.08.03.2033','Krueng Seupeng'),
('11.08.03.2034','Muling Manyang'),
('11.08.03.2035','Muling Meucat'),
('11.08.03.2036','Babah Lueng'),
('11.08.03.2037','Panton Rayeuk I'),
('11.08.03.2038','Panton Rayeuk II'),
('11.08.03.2039','Sido Muliyo'),
('11.08.04','Lhoksukon'),
('11.08.04.2001','Kuta Lhoksukon'),
('11.08.04.2002','Cot U Sibak'),
('11.08.04.2003','Bintang Hu'),
('11.08.04.2004','Blang Aman'),
('11.08.04.2005','Cot Ara'),
('11.08.04.2006','Blang Rubek'),
('11.08.04.2007','Nga Matang Ubi'),
('11.08.04.2008','Meunasah Reudeup'),
('11.08.04.2009','Alue Buket'),
('11.08.04.2010','Meunye Matang Ubi'),
('11.08.04.2011','Trieng Matang Ubi'),
('11.08.04.2012','Ceubrek'),
('11.08.04.2013','Meunasah Blang'),
('11.08.04.2014','Buket Seuntang'),
('11.08.04.2015','Meunasah Arongan AB'),
('11.08.04.2016','Trieng Pantang'),
('11.08.04.2017','Meunasah Leubok AB'),
('11.08.04.2018','Cot Glumpang AB'),
('11.08.04.2019','Abeuk Leupon'),
('11.08.04.2020','Ara AB'),
('11.08.04.2021','Mancang'),
('11.08.04.2022','Matang Pupanji AB'),
('11.08.04.2023','Meunasah Asan AB'),
('11.08.04.2024','Matang Teungoh AB'),
('11.08.04.2025','Pante'),
('11.08.04.2026','Rambot'),
('11.08.04.2027','Meunasah Alue Drien LB'),
('11.08.04.2028','Alue Mudem'),
('11.08.04.2029','Meunasah Geulinggang'),
('11.08.04.2030','Meunasah Asan LB'),
('11.08.04.2031','Beringin LB'),
('11.08.04.2032','Meunasah Teungoh LB'),
('11.08.04.2033','Meunasah Rayeuk LB'),
('11.08.04.2034','Meunasah Ulee Barat'),
('11.08.04.2035','Meunasah Ranto'),
('11.08.04.2036','Meunasah Tutong'),
('11.08.04.2037','Meunasah Nga LB'),
('11.08.04.2038','Keutapang'),
('11.08.04.2039','Matang Munjee'),
('11.08.04.2040','Pulo Dulang'),
('11.08.04.2041','Dayah LB'),
('11.08.04.2042','Meunasah Geumata'),
('11.08.04.2043','Meunasah Meureubo'),
('11.08.04.2044','Meunasah Dayah LT'),
('11.08.04.2045','Arongan LT'),
('11.08.04.2046','Meunasah Tuha'),
('11.08.04.2047','Meunasah Krueng LT'),
('11.08.04.2048','Babah Geudeubang'),
('11.08.04.2049','Grong-grong'),
('11.08.04.2050','Alue Itam Reudeup'),
('11.08.04.2051','Teupin Keubeu'),
('11.08.04.2052','Meunasah Nga LT'),
('11.08.04.2053','Meunasah Meuria'),
('11.08.04.2054','Kumbang LT'),
('11.08.04.2055','Seuneubok Dalam'),
('11.08.04.2056','Alue Eumpok'),
('11.08.04.2057','Meunasah Jok'),
('11.08.04.2058','Manyang'),
('11.08.04.2059','Lhok Kareung'),
('11.08.04.2060','Cot Asan'),
('11.08.04.2061','Alue Abee'),
('11.08.04.2062','Buloh LT'),
('11.08.04.2063','Geulumpang'),
('11.08.04.2064','Meunasah Teungoh LT'),
('11.08.04.2065','Mata U'),
('11.08.04.2066','Meucat'),
('11.08.04.2067','Buket Mee LT'),
('11.08.04.2068','Ulee Tanoh'),
('11.08.04.2069','Buket Krueng'),
('11.08.04.2070','Ulee Gunong'),
('11.08.04.2071','Lhok Seuntang'),
('11.08.04.2072','Alue Itam Baroh'),
('11.08.04.2073','Mata Ie'),
('11.08.04.2074','Rawa'),
('11.08.04.2075','Buket Hagu'),
('11.08.05','Matangkuli'),
('11.08.05.2001','Keude Matangkuli'),
('11.08.05.2002','Ude'),
('11.08.05.2003','Blang Matangkuli'),
('11.08.05.2004','Rayeuk Matangkuli'),
('11.08.05.2005','Tumpok Perlak'),
('11.08.05.2006','Ujong Kulam'),
('11.08.05.2007','Tanjong Teungku Ali'),
('11.08.05.2008','Rayeuk Glang Glong'),
('11.08.05.2009','Punti Geulumpang VII'),
('11.08.05.2010','Geulumpang VII'),
('11.08.05.2011','Teungoh Glumpang VII'),
('11.08.05.2012','Aron Geulumpang VII'),
('11.08.05.2013','Matang Munye'),
('11.08.05.2014','Parang Sikureung'),
('11.08.05.2015','Baro'),
('11.08.05.2016','Mee'),
('11.08.05.2017','Tanjong Babah Krueng'),
('11.08.05.2018','Punti Matangkuli'),
('11.08.05.2019','Teupin Keubeu'),
('11.08.05.2020','Trieng Teupin Keubeu'),
('11.08.05.2021','Matang Mee'),
('11.08.05.2022','Jeumpa Geulumpang VII'),
('11.08.05.2034','Tumpok Barat'),
('11.08.05.2035','Meuria Matangkuli'),
('11.08.05.2036','Hagu'),
('11.08.05.2037','Alue Tho'),
('11.08.05.2039','Ceubrek Pirak'),
('11.08.05.2040','Rayeuk Pirak'),
('11.08.05.2041','Aron Pirak'),
('11.08.05.2042','Lawang'),
('11.08.05.2043','Tanjong Haji Muda'),
('11.08.05.2044','Siren'),
('11.08.05.2045','Meunye Pirak'),
('11.08.05.2046','Beuringen Pirak'),
('11.08.05.2047','Teungoh Pirak'),
('11.08.05.2048','Mesjid Pirak'),
('11.08.05.2049','Matang Peusangan'),
('11.08.05.2050','Pante Pirak'),
('11.08.05.2052','Leubok Pirak'),
('11.08.05.2053','Blang Kuta'),
('11.08.05.2054','Blang Supeng'),
('11.08.05.2055','Beurancan Pirak'),
('11.08.05.2066','Alue Entok'),
('11.08.05.2067','Tanjong Teungku Kari'),
('11.08.05.2068','Teungoh Seuleumak'),
('11.08.05.2069','Seuriweuk'),
('11.08.05.2070','Dayah Baro'),
('11.08.05.2071','Kunyet Mulee'),
('11.08.05.2072','Tutong'),
('11.08.06','Muara Batu'),
('11.08.06.2001','Keude Mane'),
('11.08.06.2002','Meunasah Drang'),
('11.08.06.2003','Meunasah Baro'),
('11.08.06.2004','Meunasah Lhok'),
('11.08.06.2005','Cot Seurani'),
('11.08.06.2006','Mane Tunong'),
('11.08.06.2007','Kuala Dua'),
('11.08.06.2008','Meunasah Pinto'),
('11.08.06.2009','Keude Bungkaih'),
('11.08.06.2010','Kambam'),
('11.08.06.2011','Meunasah Aron'),
('11.08.06.2012','Cot Trueng'),
('11.08.06.2013','Dakuta'),
('11.08.06.2014','Paloh Awe'),
('11.08.06.2015','Tanoh Anoe'),
('11.08.06.2016','Pante Gurah'),
('11.08.06.2017','Teupin Banja'),
('11.08.06.2018','Teumpok Beurandang'),
('11.08.06.2019','Paloh Raya'),
('11.08.06.2020','Panigah'),
('11.08.06.2021','Ulee Madon'),
('11.08.06.2022','Reuleut Timu'),
('11.08.06.2023','Reuleut Barat'),
('11.08.06.2024','Pinto Makmur'),
('11.08.07','Meurah Mulia'),
('11.08.07.2001','Dayah Bluek'),
('11.08.07.2002','Mesjid Bluek'),
('11.08.07.2003','Meuria Bluek'),
('11.08.07.2004','Rheng Bluek'),
('11.08.07.2005','Pulo Bluek'),
('11.08.07.2006','Rangkileh'),
('11.08.07.2007','Rayeuk Matang'),
('11.08.07.2008','Ulee Meuria'),
('11.08.07.2009','Tanjong'),
('11.08.07.2010','Keude Karieng'),
('11.08.07.2011','Manyang'),
('11.08.07.2012','Ulee Ceubrek'),
('11.08.07.2013','Teumpok Teungku'),
('11.08.07.2014','Geulumpang'),
('11.08.07.2015','Reudeup'),
('11.08.07.2016','Barat Paya Itek'),
('11.08.07.2017','Paya Kambuk'),
('11.08.07.2018','Paya Bili'),
('11.08.07.2019','Meunasah Mee'),
('11.08.07.2020','Meunasah Nga'),
('11.08.07.2021','Ubit Paya Itek'),
('11.08.07.2022','Rayeuk Paya Itek'),
('11.08.07.2023','Blang Cut'),
('11.08.07.2024','Keeh'),
('11.08.07.2025','Kumbang'),
('11.08.07.2026','Pri Keutapang'),
('11.08.07.2027','Mesjid'),
('11.08.07.2028','Teungoh Reuba'),
('11.08.07.2029','Blang Reuma'),
('11.08.07.2030','Drien Puntong'),
('11.08.07.2031','Pulo Kitou'),
('11.08.07.2032','Ceubrek'),
('11.08.07.2033','Meunye Peut'),
('11.08.07.2034','Beuringen'),
('11.08.07.2035','Nibong'),
('11.08.07.2036','Tualang'),
('11.08.07.2037','Pulo Drien Beukah'),
('11.08.07.2038','Teungoh Kuta Batee'),
('11.08.07.2039','Ujung Kuta Batee'),
('11.08.07.2040','Pulo Blang'),
('11.08.07.2041','Leubok Tuwe'),
('11.08.07.2042','Baroh Kuta Batee'),
('11.08.07.2043','Gampong Teungoh'),
('11.08.07.2044','Ranto'),
('11.08.07.2045','Meunye Payong'),
('11.08.07.2046','Ujong Reuba'),
('11.08.07.2047','Paya Sutra'),
('11.08.07.2048','Baree Blang'),
('11.08.07.2049','Keude Jungka Gajah'),
('11.08.07.2050','Saramaba'),
('11.08.08','Samudera'),
('11.08.08.2001','Pie'),
('11.08.08.2002','Asan'),
('11.08.08.2003','Murong'),
('11.08.08.2004','Blang Kabu'),
('11.08.08.2005','Mancang'),
('11.08.08.2006','Keude Geudong'),
('11.08.08.2007','Blang Peuria'),
('11.08.08.2008','Teupin Ara'),
('11.08.08.2009','Teupin Beulangan'),
('11.08.08.2010','Krueng Baro Langgahan'),
('11.08.08.2011','Pusong'),
('11.08.08.2012','Tanjong Kleng'),
('11.08.08.2013','Gampong Baro'),
('11.08.08.2014','Beuringen'),
('11.08.08.2015','Kuta Krueng'),
('11.08.08.2016','Kuta Glumpang'),
('11.08.08.2017','Meucat'),
('11.08.08.2018','Krueng Baro Blang Mee'),
('11.08.08.2019','Ujong'),
('11.08.08.2020','Mesjid'),
('11.08.08.2021','Teungoh'),
('11.08.08.2022','Keude Blang Mee Pulo Klat'),
('11.08.08.2023','Puuk'),
('11.08.08.2024','Lancang'),
('11.08.08.2025','Matang Ulim'),
('11.08.08.2026','Sawang'),
('11.08.08.2027','Laga Baro'),
('11.08.08.2028','Pulo'),
('11.08.08.2029','Matang Tunong'),
('11.08.08.2030','Matang Puntong'),
('11.08.08.2031','Blang Nibong'),
('11.08.08.2032','Tanjong Baroh'),
('11.08.08.2033','Tanjong Hagu'),
('11.08.08.2034','Tanjong Reungkam'),
('11.08.08.2035','Tanjong Mesjid'),
('11.08.08.2036','Paya Terbang'),
('11.08.08.2037','Madan'),
('11.08.08.2038','Tanjong Awe'),
('11.08.08.2039','Kitou'),
('11.08.08.2040','Krueng Matee'),
('11.08.09','Seunuddon'),
('11.08.09.2001','Tanjong Pineung'),
('11.08.09.2002','Meurubo Puntong'),
('11.08.09.2003','Mane Kawan'),
('11.08.09.2004','Alue Barueh'),
('11.08.09.2005','Keude Simpang Jalan'),
('11.08.09.2006','Blang Pha'),
('11.08.09.2007','Alue Kiran'),
('11.08.09.2008','Blang Tue'),
('11.08.09.2009','Cot Kafiraton'),
('11.08.09.2010','Tanjong Dama'),
('11.08.09.2011','Paya Dua Uram'),
('11.08.09.2012','Paya Dua Ujong'),
('11.08.09.2013','Alue Capli'),
('11.08.09.2014','Simpang Peut'),
('11.08.09.2015','Meunasah Sagoe'),
('11.08.09.2016','Matang Puntong'),
('11.08.09.2017','Matang Panyang'),
('11.08.09.2018','Cot Patisah'),
('11.08.09.2019','Cot Trueng'),
('11.08.09.2020','Darul Aman'),
('11.08.09.2021','Matang Jeulikat'),
('11.08.09.2022','Lhok Puuk'),
('11.08.09.2023','Ulee Rubek Barat'),
('11.08.09.2024','Ulee Rubek Timu'),
('11.08.09.2025','Bantayan'),
('11.08.09.2026','Teupin Kuyuen'),
('11.08.09.2027','Matang Lada'),
('11.08.09.2028','Ulee Matang'),
('11.08.09.2029','Matang Karieng'),
('11.08.09.2030','Lhok Rambideng'),
('11.08.09.2031','Matang Anoe'),
('11.08.09.2032','Lhok Geulituet'),
('11.08.09.2033','Ulee Titi'),
('11.08.10','Syamtalira Aron'),
('11.08.10.2001','Keude Aron'),
('11.08.10.2002','Dayah Aron'),
('11.08.10.2003','Moncrang'),
('11.08.10.2004','Kanot'),
('11.08.10.2005','Meuria Aron'),
('11.08.10.2006','Mee Aron'),
('11.08.10.2007','Glok'),
('11.08.10.2008','Cibrek Baroh'),
('11.08.10.2009','Cibrek Tunong'),
('11.08.10.2010','Matang Munye'),
('11.08.10.2011','Pante'),
('11.08.10.2012','Keutapang'),
('11.08.10.2013','Blang'),
('11.08.10.2014','Teungoh'),
('11.08.10.2015','Tanjong Krueng Pase'),
('11.08.10.2016','Mesjid'),
('11.08.10.2017','Keude Teupin Punti'),
('11.08.10.2018','Kumbang'),
('11.08.10.2019','Gampong U'),
('11.08.10.2020','Calong'),
('11.08.10.2021','Manyang Baroh'),
('11.08.10.2022','Peurupok'),
('11.08.10.2023','Alue Gunto'),
('11.08.10.2024','Pulo'),
('11.08.10.2025','Kulam'),
('11.08.10.2026','Ampeh'),
('11.08.10.2027','Dayah Meuria'),
('11.08.10.2028','Mampree'),
('11.08.10.2029','Meucat'),
('11.08.10.2030','Ara'),
('11.08.10.2031','Hagu'),
('11.08.10.2032','Awe'),
('11.08.10.2033','Tanjong Mulieng'),
('11.08.10.2034','Dayah Teungku'),
('11.08.11','Syamtalira Bayu'),
('11.08.11.2001','Bale'),
('11.08.11.2002','Bie'),
('11.08.11.2003','Beurandang'),
('11.08.11.2004','Baro Kulam Gajah'),
('11.08.11.2005','Glong'),
('11.08.11.2006','Nibong'),
('11.08.11.2007','Langa'),
('11.08.11.2008','Beunot'),
('11.08.11.2009','Keude Bayu'),
('11.08.11.2010','Blang Bayu'),
('11.08.11.2011','Dayah Tuha'),
('11.08.11.2012','Dayah Baro'),
('11.08.11.2013','Lancok'),
('11.08.11.2014','Punti'),
('11.08.11.2015','Bungong'),
('11.08.11.2016','Baroh Blang Rimueng'),
('11.08.11.2017','Ulee Meuria'),
('11.08.11.2018','Kayee Panyang'),
('11.08.11.2019','Rheng'),
('11.08.11.2020','Trieng Meudurou'),
('11.08.11.2021','Ulee Gampong'),
('11.08.11.2022','Garut'),
('11.08.11.2023','Blang Awe'),
('11.08.11.2024','Pulo Blang Mangat'),
('11.08.11.2025','Cibrek'),
('11.08.11.2026','Pulo Blang Trieng'),
('11.08.11.2027','Meudang Ara'),
('11.08.11.2028','Cot Neuheun'),
('11.08.11.2029','Tumpeun'),
('11.08.11.2030','Alen'),
('11.08.11.2031','Dayah Blang Seureukuy'),
('11.08.11.2032','Blang Patra'),
('11.08.11.2033','Blang Majron'),
('11.08.11.2034','Seuneubok Baro'),
('11.08.11.2035','Buket Glumpang'),
('11.08.11.2037','Alue Majron'),
('11.08.11.2038','Siren Tujoh'),
('11.08.11.2047','Blang Seureukuy'),
('11.08.12','Tanah Luas'),
('11.08.12.2001','Pulo Blang'),
('11.08.12.2002','Matang Ben'),
('11.08.12.2003','Matang Cibrek'),
('11.08.12.2004','Deng'),
('11.08.12.2005','Rawa'),
('11.08.12.2006','Punti Pulo Agam'),
('11.08.12.2007','Alue Pangkat'),
('11.08.12.2008','Teungoh Pulo Agam'),
('11.08.12.2009','Hueng'),
('11.08.12.2010','Pulo U'),
('11.08.12.2011','Alue Keujruen'),
('11.08.12.2012','Paya Beurandang'),
('11.08.12.2013','Manyang Tunong'),
('11.08.12.2014','Meunasah Tutong'),
('11.08.12.2015','Ampeh'),
('11.08.12.2016','Alue'),
('11.08.12.2017','Teungku Dibalee'),
('11.08.12.2018','Keude Blang Jruen'),
('11.08.12.2019','Blang Jruen'),
('11.08.12.2020','Ujong Baroh Berghang'),
('11.08.12.2021','Jeumpa Berghang'),
('11.08.12.2022','Teungoh Berghang'),
('11.08.12.2023','Pante Berghang'),
('11.08.12.2024','Serba Jaman'),
('11.08.12.2025','Rayeuk Naleung'),
('11.08.12.2026','Rangkaya'),
('11.08.12.2027','Paya'),
('11.08.12.2028','Blang Bidok'),
('11.08.12.2029','Rayeuk Kuta'),
('11.08.12.2030','Rayeuk Meunye'),
('11.08.12.2031','Ujong Baroh SB'),
('11.08.12.2032','Trieng'),
('11.08.12.2033','Manyang SB'),
('11.08.12.2034','Cibrek'),
('11.08.12.2035','Keutapang'),
('11.08.12.2036','Matang Mane'),
('11.08.12.2037','Alue Gampong'),
('11.08.12.2038','Bayi'),
('11.08.12.2039','Tumpok Aceh'),
('11.08.12.2040','Ulee Buket'),
('11.08.12.2041','Cot Dah'),
('11.08.12.2042','Leupon Siren'),
('11.08.12.2043','Blang Trieng'),
('11.08.12.2044','Alue Sijuek'),
('11.08.12.2045','Hagu'),
('11.08.12.2046','Teupin Mee'),
('11.08.12.2047','Plu Pakam'),
('11.08.12.2048','Blang Pie'),
('11.08.12.2049','Punti Seuleumak Barat'),
('11.08.12.2050','Serba Jaman Tunong'),
('11.08.12.2051','Leuhong'),
('11.08.12.2052','Blang'),
('11.08.12.2053','Tanjong Mesjid'),
('11.08.12.2054','Serba Jaman Baroh'),
('11.08.12.2055','Cot Barat'),
('11.08.12.2056','Matang Baloy'),
('11.08.12.2057','Buket Makarti'),
('11.08.13','Tanah Pasir'),
('11.08.13.2001','Alue'),
('11.08.13.2002','Mee Matang Panyang'),
('11.08.13.2003','Blang'),
('11.08.13.2004','Paloh'),
('11.08.13.2005','Keude Matang Payang'),
('11.08.13.2006','Gampong Pande'),
('11.08.13.2007','Matang Ranup Laseh'),
('11.08.13.2008','Cangguek'),
('11.08.13.2009','Kumbang'),
('11.08.13.2010','Prie'),
('11.08.13.2011','Keutapang'),
('11.08.13.2012','Keude Jrat Manyang'),
('11.08.13.2013','Teupin Gapeuh'),
('11.08.13.2014','Cibrek'),
('11.08.13.2015','Me Merbo'),
('11.08.13.2016','Ulee Tanoh'),
('11.08.13.2017','Matang Janeng'),
('11.08.13.2018','Kuala Keureutou Barat'),
('11.08.14','Tanah Jambo Aye'),
('11.08.14.2001','Teupin Gajah'),
('11.08.14.2002','Geulumpang Umpung Unou'),
('11.08.14.2003','Ranto Panyang'),
('11.08.14.2004','Seuneubok Doe'),
('11.08.14.2005','Meunasah Geudong'),
('11.08.14.2006','Meunasah Merbo'),
('11.08.14.2007','Tanjong Meunye'),
('11.08.14.2008','Matang Jurong'),
('11.08.14.2009','Tanjong Dalam Utara'),
('11.08.14.2010','Meunasah Dayah'),
('11.08.14.2011','Seuneubok Pidie'),
('11.08.14.2012','Tanjong Menuang'),
('11.08.14.2013','Matang Teungoh-Teungoh'),
('11.08.14.2014','Lhok Reudeup'),
('11.08.14.2015','Lhok Merbo'),
('11.08.14.2016','Tanjong Ara'),
('11.08.14.2017','Alue Ie Mirah'),
('11.08.14.2018','Tanjong Punti'),
('11.08.14.2019','Buket Alue Puteh'),
('11.08.14.2020','Buket Jrat Manyang'),
('11.08.14.2021','Matang Maneh'),
('11.08.14.2022','Pucok Alue'),
('11.08.14.2023','Matang Serdang'),
('11.08.14.2024','Matang Santot'),
('11.08.14.2025','Buket Padang'),
('11.08.14.2026','Matang Seuke Pulot'),
('11.08.14.2027','Lhok Beuringen'),
('11.08.14.2028','Lueng Tuha'),
('11.08.14.2029','Matang Raya'),
('11.08.14.2030','Tanjong Ceungai'),
('11.08.14.2031','Teupin Bayu'),
('11.08.14.2032','Meunasah Panton Labu'),
('11.08.14.2033','Kota Panton Labu'),
('11.08.14.2034','Rawang Itek'),
('11.08.14.2035','Samakurok'),
('11.08.14.2036','Biara Barat'),
('11.08.14.2037','Biara Timur'),
('11.08.14.2038','Matang Drien'),
('11.08.14.2039','Ceumpeudak'),
('11.08.14.2040','Alue Papeun'),
('11.08.14.2041','Lhok Bintang Hu'),
('11.08.14.2042','Biram Rayeuk'),
('11.08.14.2043','Cot Biek'),
('11.08.14.2044','Matang Arongan'),
('11.08.14.2045','Biram Cut'),
('11.08.14.2046','Buket Batee Badan'),
('11.08.14.2047','Ulee Glee'),
('11.08.15','Sawang'),
('11.08.15.2001','Lagang'),
('11.08.15.2002','Abeuk Reuling'),
('11.08.15.2003','Lhok Krek'),
('11.08.15.2004','Lhok Merbo'),
('11.08.15.2005','Gle Dagang'),
('11.08.15.2006','Kuta Meuligoe'),
('11.08.15.2007','Gampong Teungoh'),
('11.08.15.2008','Babah Buloh'),
('11.08.15.2009','Meunasah Pulo'),
('11.08.15.2010','Punteuet'),
('11.08.15.2011','Pante Jaloh'),
('11.08.15.2012','Lhok Kuyun'),
('11.08.15.2013','Blang Reuling'),
('11.08.15.2014','Lhok Gajah'),
('11.08.15.2015','Teupin Rusep'),
('11.08.15.2016','Ulee Geudong'),
('11.08.15.2017','Tanjong Keumala'),
('11.08.15.2018','Cot Kumuneng'),
('11.08.15.2019','Cot Lambideng'),
('11.08.15.2020','Paya Gaboh'),
('11.08.15.2021','Paya Rabo Lhok'),
('11.08.15.2022','Paya Rabo Timu'),
('11.08.15.2023','Lancok'),
('11.08.15.2024','Rambong Payong'),
('11.08.15.2025','Lhok Bayu'),
('11.08.15.2026','Krueng Baro'),
('11.08.15.2027','Babah Krueng'),
('11.08.15.2028','Jurong'),
('11.08.15.2029','Blang Manyak'),
('11.08.15.2030','Lhok Jok'),
('11.08.15.2031','Blang Teurakan'),
('11.08.15.2032','Sawang'),
('11.08.15.2033','Riseh Baroh'),
('11.08.15.2034','Riseh Teungoh'),
('11.08.15.2035','Riseh Tunong'),
('11.08.15.2036','Gunci'),
('11.08.15.2037','Kubu'),
('11.08.15.2038','Blang Cut'),
('11.08.15.2039','Lhok Cut'),
('11.08.16','Nisam'),
('11.08.16.2015','Paloh Mambu'),
('11.08.16.2017','Blang Karieng'),
('11.08.16.2018','Paloh Kayee Kunyet'),
('11.08.16.2019','Gampong Barat'),
('11.08.16.2020','Meunasah Beunot'),
('11.08.16.2021','Seuneubok'),
('11.08.16.2022','Cot Leupee'),
('11.08.16.2023','Gampong Teungoh'),
('11.08.16.2024','Meunasah Meucat'),
('11.08.16.2025','Meunasah Alue'),
('11.08.16.2026','Panton'),
('11.08.16.2027','Paloh Mampree'),
('11.08.16.2028','Peunayan'),
('11.08.16.2029','Tingkeum'),
('11.08.16.2030','Meunasah Rayeuk'),
('11.08.16.2031','Meunasah Cut'),
('11.08.16.2032','Jeulikat'),
('11.08.16.2033','Alue Bili'),
('11.08.16.2034','Cot Mambong'),
('11.08.16.2035','Blang Dalam Geunteng'),
('11.08.16.2036','Blang Dalam Tunong'),
('11.08.16.2037','Blang Dalam Baroh'),
('11.08.16.2038','Cot Mee'),
('11.08.16.2039','Cot Euntung'),
('11.08.16.2040','Blang Crok'),
('11.08.16.2041','Meunasah Krueng'),
('11.08.16.2042','Binjee'),
('11.08.16.2043','Keutapang'),
('11.08.16.2044','Ulee Blang'),
('11.08.17','Cot Girek'),
('11.08.17.2001','Cot Girek'),
('11.08.17.2002','Lhok Meurbo'),
('11.08.17.2003','Kp. Bantan'),
('11.08.17.2004','Alue Seumambu'),
('11.08.17.2005','Ulee Gampong'),
('11.08.17.2006','Batu XII'),
('11.08.17.2007','Kp. Tempel'),
('11.08.17.2008','Alue Leuhob'),
('11.08.17.2009','Seuneubok Baro'),
('11.08.17.2010','Alue Drien'),
('11.08.17.2011','Cempeudak'),
('11.08.17.2012','Matang Teungoh'),
('11.08.17.2013','Pucok Alue'),
('11.08.17.2014','U Baro'),
('11.08.17.2015','Trieng'),
('11.08.17.2016','Lhok Reuhat'),
('11.08.17.2017','Lueng Baro'),
('11.08.17.2018','Jeulikat'),
('11.08.17.2019','Gampong Ara'),
('11.08.17.2020','Beurandang Dayah'),
('11.08.17.2021','Beurandang Krueng'),
('11.08.17.2022','Seupeng'),
('11.08.17.2023','Beurandang Asan'),
('11.08.17.2024','Drien II'),
('11.08.18','Langkahan'),
('11.08.18.2001','Cot Bada'),
('11.08.18.2002','Alue Dua'),
('11.08.18.2003','Bantayan'),
('11.08.18.2004','Kampong Blang'),
('11.08.18.2005','Paya Tukai'),
('11.08.18.2006','Matang Keutapang'),
('11.08.18.2007','Krueng Lingka'),
('11.08.18.2008','Simpang Tiga'),
('11.08.18.2009','Matang Rubek'),
('11.08.18.2010','Leubok Mane'),
('11.08.18.2011','Matang Teungoh Selatan'),
('11.08.18.2012','Padang Meuria'),
('11.08.18.2013','Alue Krak Kayee'),
('11.08.18.2014','Tanjong Jawa'),
('11.08.18.2015','Meunasah Blang'),
('11.08.18.2016','Tanjong Dalam Selatan'),
('11.08.18.2017','Geudumbak'),
('11.08.18.2018','Langkahan'),
('11.08.18.2019','Rumoh Rayeuk'),
('11.08.18.2020','Buket Linteung'),
('11.08.18.2021','Lubok Pusaka'),
('11.08.18.2022','Seureuke'),
('11.08.18.2023','Pante Gaki Bale'),
('11.08.19','Baktiya Barat'),
('11.08.19.2001','Keude Sampoiniet'),
('11.08.19.2002','Lhok Iboh'),
('11.08.19.2003','Matang Bayu'),
('11.08.19.2004','Lang Nibong'),
('11.08.19.2005','Blang Seunong'),
('11.08.19.2006','Singgah Mata'),
('11.08.19.2007','Matang Panyang'),
('11.08.19.2008','Matang Ceubrek'),
('11.08.19.2009','Matang Teungoh'),
('11.08.19.2010','Cot Paya'),
('11.08.19.2011','Cot Kupok'),
('11.08.19.2012','Matang Raya Blang Sialet'),
('11.08.19.2013','Pucok Alue Buket'),
('11.08.19.2014','Matang Sijuek Timu'),
('11.08.19.2015','Matang Sijuek Teungoh'),
('11.08.19.2016','Matang Sijuek Barat'),
('11.08.19.2017','Cot Laba'),
('11.08.19.2018','Meunasah Pante'),
('11.08.19.2019','Meurandeh Paya'),
('11.08.19.2020','Cot Murong'),
('11.08.19.2021','Matang Paya'),
('11.08.19.2022','Lhok Euncien'),
('11.08.19.2023','Cot Usen'),
('11.08.19.2024','Meunasah Hagu'),
('11.08.19.2025','Blang Rheue'),
('11.08.19.2026','Paya Bateung'),
('11.08.20','Paya Bakong'),
('11.08.20.2001','Blang Ara'),
('11.08.20.2002','Tgk.Dibanda Pirak'),
('11.08.20.2003','Paya Meudru'),
('11.08.20.2004','Blang Sialet'),
('11.08.20.2005','Buket Guru'),
('11.08.20.2006','Geulumpang Pirak'),
('11.08.20.2007','Alue Lhok'),
('11.08.20.2008','Seuneubok Aceh'),
('11.08.20.2009','Buket Pidie'),
('11.08.20.2010','Kebon Pirak'),
('11.08.20.2011','Alue Leukot'),
('11.08.20.2012','Blang Mane'),
('11.08.20.2013','Peureupok'),
('11.08.20.2014','Alue Bieng'),
('11.08.20.2015','Pante Seuleumak'),
('11.08.20.2016','Meuria Seuleumak'),
('11.08.20.2017','Tunong Krueng'),
('11.08.20.2018','Geureughek'),
('11.08.20.2019','Meunye Seuleumak'),
('11.08.20.2020','Simpang'),
('11.08.20.2021','Tumpok Mesjid'),
('11.08.20.2022','Jok'),
('11.08.20.2023','Leuhong'),
('11.08.20.2024','Tanjong Burunyong'),
('11.08.20.2025','Keude Paya Bakong'),
('11.08.20.2026','Blang Gunci'),
('11.08.20.2027','Gampong Nga'),
('11.08.20.2028','Mampree'),
('11.08.20.2029','Matang Panyang'),
('11.08.20.2030','Tanjong Drieng'),
('11.08.20.2031','Asan Seuleumak'),
('11.08.20.2032','Tgk. Dibanda Tek-Tek'),
('11.08.20.2033','Cot Teufah'),
('11.08.20.2034','Pucok Alue Seuleumak'),
('11.08.20.2035','Lueng'),
('11.08.20.2036','Cempeudak'),
('11.08.20.2037','Blang Paku'),
('11.08.20.2038','Blang Dalam'),
('11.08.20.2039','Blang Pante'),
('11.08.21','Nibong'),
('11.08.21.2001','Nibong Baroh'),
('11.08.21.2002','Nibong Wakheuh'),
('11.08.21.2003','Keude Nibong'),
('11.08.21.2004','Keupok Nibong'),
('11.08.21.2005','Dayah Nibong'),
('11.08.21.2006','Sumbok Rayeuk'),
('11.08.21.2007','Paya Terbang'),
('11.08.21.2008','Teupin Jok'),
('11.08.21.2009','Mamplam'),
('11.08.21.2010','Keulilee'),
('11.08.21.2011','Meunye Lhee'),
('11.08.21.2012','Ranto'),
('11.08.21.2013','Seulunyok'),
('11.08.21.2014','Keh Nibong'),
('11.08.21.2015','Alue Ie Mirah'),
('11.08.21.2016','Maddi'),
('11.08.21.2017','Alue Ngom'),
('11.08.21.2018','Tanjong Putoh'),
('11.08.21.2019','Bumban'),
('11.08.21.2020','Alue Panah'),
('11.08.22','Simpang Keuramat'),
('11.08.22.2001','Keude Simpang Empat'),
('11.08.22.2002','Seunebok Punti'),
('11.08.22.2003','Paya Leupah'),
('11.08.22.2004','Paya Teungoh'),
('11.08.22.2005','Keubon Baro'),
('11.08.22.2006','Meunasah Teungoh'),
('11.08.22.2007','Meunasah Baroh'),
('11.08.22.2008','Mancang'),
('11.08.22.2009','Alue Bade'),
('11.08.22.2010','Meunasah Dayah SPK'),
('11.08.22.2011','Kilometer VI'),
('11.08.22.2012','Kilometer VIII'),
('11.08.22.2013','Ie Tarek I'),
('11.08.22.2014','Ie Tarek II'),
('11.08.22.2015','Pase Sentosa'),
('11.08.22.2016','Blang Raleue'),
('11.08.23','Lapang'),
('11.08.23.2001','Keureutou'),
('11.08.23.2002','Lueng Baro'),
('11.08.23.2003','Merbo Jurong'),
('11.08.23.2004','Merbo Lama'),
('11.08.23.2005','Tanjong Dama'),
('11.08.23.2006','Geulanggang Baro'),
('11.08.23.2007','Matang Tunong'),
('11.08.23.2008','Keude Lapang'),
('11.08.23.2009','Matang Baroh'),
('11.08.23.2010','Kuala Kereuto'),
('11.08.23.2011','Kuala Cangkoy'),
('11.08.24','Pirak Timu'),
('11.08.24.2001','Rayeuk Pange'),
('11.08.24.2002','Bungong'),
('11.08.24.2003','Geulumpang'),
('11.08.24.2004','Asan Krueng Kreh'),
('11.08.24.2005','Beuracan Rata'),
('11.08.24.2006','Reungkam'),
('11.08.24.2007','Trieng Krueng Kreh'),
('11.08.24.2008','Keutapang'),
('11.08.24.2009','Bili Baro'),
('11.08.24.2010','Paya Lueng Jalo'),
('11.08.24.2011','Alue Rimee'),
('11.08.24.2012','Serdang'),
('11.08.24.2013','Ara Ton-Ton Moncrang'),
('11.08.24.2014','Tanjong Seureukuy'),
('11.08.24.2015','Ulee Blang'),
('11.08.24.2016','Krueng Pirak'),
('11.08.24.2017','Matang Keh'),
('11.08.24.2018','Leupe'),
('11.08.24.2019','Ceumeucet'),
('11.08.24.2020','Teupin U'),
('11.08.24.2021','Alue Bungkoh'),
('11.08.24.2022','Pucok Alue'),
('11.08.24.2023','Meunye Tujoh'),
('11.08.25','Geureudong Pase'),
('11.08.25.2001','Lhok Asan'),
('11.08.25.2002','Darul Aman'),
('11.08.25.2003','Alue Awe'),
('11.08.25.2004','Darussalam'),
('11.08.25.2005','Rayeuk Jawa'),
('11.08.25.2006','Dayah Seupeng'),
('11.08.25.2007','Uram Jalan'),
('11.08.25.2008','Peudari'),
('11.08.25.2009','Krueng Mbang'),
('11.08.25.2010','Pulo Meuria'),
('11.08.25.2011','Suka Damai'),
('11.08.26','Banda Baro'),
('11.08.26.2001','Paya Dua'),
('11.08.26.2002','Cot Jabet'),
('11.08.26.2003','Ulee Nyeue'),
('11.08.26.2004','Paya Uleue'),
('11.08.26.2005','Jamuan'),
('11.08.26.2006','Alue Keurinyai'),
('11.08.26.2007','Sangkelan'),
('11.08.26.2008','Blang Pala'),
('11.08.26.2009','Paya Beunyot'),
('11.08.27','Nisam Antara'),
('11.08.27.2001','Alue Dua'),
('11.08.27.2002','Seumirah'),
('11.08.27.2003','Darussalam'),
('11.08.27.2004','Alue Papeun'),
('11.08.27.2005','Blang Jrat'),
('11.08.27.2006','Blang Pohroh'),
('11.09','Kabupaten Simeulue'),
('11.09.01','Simeulue Tengah'),
('11.09.01.2007','Wel Wel'),
('11.09.01.2008','Kampung Aie'),
('11.09.01.2009','Lauree'),
('11.09.01.2010','Lamayang'),
('11.09.01.2011','Lakubang'),
('11.09.01.2012','Lambaya'),
('11.09.01.2013','Dihit'),
('11.09.01.2016','Latitik'),
('11.09.01.2017','Wellangkum'),
('11.09.01.2018','Kuta Baru'),
('11.09.01.2019','Sebbe'),
('11.09.01.2020','Suak Baru'),
('11.09.01.2021','Luan Sorep'),
('11.09.01.2022','Putra Jaya'),
('11.09.01.2023','Lauke'),
('11.09.01.2024','Situfa Jaya'),
('11.09.02','Salang'),
('11.09.02.2001','Ujung Salang'),
('11.09.02.2002','Padang Unoi'),
('11.09.02.2003','Nasreuhe'),
('11.09.02.2004','Meunafa'),
('11.09.02.2005','Along'),
('11.09.02.2006','Panton Lawe'),
('11.09.02.2007','Mutiara'),
('11.09.02.2008','Tamon Jaya'),
('11.09.02.2009','Karya Bakti'),
('11.09.02.2010','Jaya Baru'),
('11.09.02.2011','Tameng'),
('11.09.02.2012','Lalla Bahagia'),
('11.09.02.2013','Suak Manang'),
('11.09.02.2014','Ganang Pusako'),
('11.09.02.2015','Kenangan Jaya'),
('11.09.02.2016','Bunga'),
('11.09.03','Teupah Barat'),
('11.09.03.2001','Silengas'),
('11.09.03.2002','Bunon'),
('11.09.03.2003','Angkeo'),
('11.09.03.2004','Awe Seubal'),
('11.09.03.2005','Laayon'),
('11.09.03.2006','Inor'),
('11.09.03.2007','Salur Lasengalu'),
('11.09.03.2008','Salur Latun'),
('11.09.03.2009','Salur'),
('11.09.03.2010','Pulau Teupah'),
('11.09.03.2011','Awe Kecil'),
('11.09.03.2012','Naibos'),
('11.09.03.2013','Lantik'),
('11.09.03.2014','Leubang Hulu'),
('11.09.03.2015','Leubang'),
('11.09.03.2016','Sital'),
('11.09.03.2017','Maudil'),
('11.09.03.2018','Nancala'),
('11.09.04','Simeulue Timur'),
('11.09.04.2009','Suak Buluh'),
('11.09.04.2012','Air Dingin'),
('11.09.04.2013','Ameria Bahagia'),
('11.09.04.2014','Suka Jaya'),
('11.09.04.2015','Suka Maju'),
('11.09.04.2016','Suka Karya'),
('11.09.04.2017','Sinabang'),
('11.09.04.2018','Amaiteng Mulia'),
('11.09.04.2019','Lugu'),
('11.09.04.2020','Sefoyan'),
('11.09.04.2021','Ganting'),
('11.09.04.2022','Kuala Makmur'),
('11.09.04.2023','Ujung Tinggi'),
('11.09.04.2024','Air Pinang'),
('11.09.04.2025','Pulau Siumat'),
('11.09.04.2026','Kota Batu'),
('11.09.04.2028','Linggi'),
('11.09.05','Teluk Dalam'),
('11.09.05.2001','Babussalam'),
('11.09.05.2002','Muara Aman'),
('11.09.05.2003','Gunung Putih'),
('11.09.05.2004','Lugu Sebahak'),
('11.09.05.2005','Kuala Bakti'),
('11.09.05.2006','Bulu Hadik'),
('11.09.05.2007','Sambay'),
('11.09.05.2008','Luan Balu'),
('11.09.05.2009','Tanjung Raya'),
('11.09.05.2010','Kuala Baru'),
('11.09.06','Simeulue Barat'),
('11.09.06.2001','Layabaung'),
('11.09.06.2002','Sembilan'),
('11.09.06.2003','Sigulai'),
('11.09.06.2004','Sinar Bahagia'),
('11.09.06.2005','Lamamek'),
('11.09.06.2006','Batu Ragi'),
('11.09.06.2007','Malasin'),
('11.09.06.2008','Babul Makmur'),
('11.09.06.2009','Amabaan'),
('11.09.06.2010','Miteum'),
('11.09.06.2011','Lhok Bikhau'),
('11.09.06.2012','Ujung Harapan'),
('11.09.06.2013','Sanggiran'),
('11.09.06.2014','Lhok Makmur'),
('11.09.07','Teupah Selatan'),
('11.09.07.2001','Seneubuk'),
('11.09.07.2002','Suak Lamatan'),
('11.09.07.2003','Alus Alus'),
('11.09.07.2004','Batu Ralang'),
('11.09.07.2005','Ulul Mayang'),
('11.09.07.2006','Kebun Baru'),
('11.09.07.2007','Badegong'),
('11.09.07.2008','Latiung'),
('11.09.07.2009','Pasir Tinggi'),
('11.09.07.2010','Labuhan Jaya'),
('11.09.07.2011','Labuhan Bajau'),
('11.09.07.2012','Blang Sebel'),
('11.09.07.2013','Ana Ao'),
('11.09.07.2014','Lataling'),
('11.09.07.2015','Pulau Bangkalak'),
('11.09.07.2016','Labuhan Bakti'),
('11.09.07.2017','Trans Jernge'),
('11.09.07.2018','Trans Meranti'),
('11.09.07.2019','Trans Baru'),
('11.09.08','Alafan'),
('11.09.08.2001','Lewak'),
('11.09.08.2002','Lamerem'),
('11.09.08.2003','Lhok Pauh'),
('11.09.08.2004','Serafon'),
('11.09.08.2005','Langi'),
('11.09.08.2006','Lubuk Baik'),
('11.09.08.2007','Lhok Dalam'),
('11.09.08.2008','Lafakha'),
('11.09.09','Teupah Tengah'),
('11.09.09.2001','Matanurung'),
('11.09.09.2002','Lasikin'),
('11.09.09.2003','Lanting'),
('11.09.09.2004','Busung Indah'),
('11.09.09.2005','Kahad'),
('11.09.09.2006','Simpang Abail'),
('11.09.09.2007','Abail'),
('11.09.09.2008','Nancawa'),
('11.09.09.2009','Labuah'),
('11.09.09.2010','Sua-Sua'),
('11.09.09.2011','Batu-Batu'),
('11.09.09.2012','Situbuk'),
('11.09.10','Simeulue Cut'),
('11.09.10.2001','Bubuhan'),
('11.09.10.2002','Amarabu'),
('11.09.10.2003','Kuta Inang'),
('11.09.10.2004','Kuta Padang'),
('11.09.10.2005','Sibuluh'),
('11.09.10.2006','Latak Ayah'),
('11.09.10.2007','Borengan'),
('11.09.10.2008','Ujung Padang'),
('11.10','Kabupaten Aceh Singkil'),
('11.10.01','Pulau Banyak'),
('11.10.01.2001','Pulau Balai'),
('11.10.01.2002','Pulau Baguk'),
('11.10.01.2004','Teluk Nibung'),
('11.10.02','Simpang Kanan'),
('11.10.02.2001','Lipat Kajang'),
('11.10.02.2002','Kain Golong'),
('11.10.02.2003','Kuta Kerangan'),
('11.10.02.2004','Siatas'),
('11.10.02.2005','Pangi'),
('11.10.02.2006','Sukarejo'),
('11.10.02.2007','Ujung Limus'),
('11.10.02.2008','Silatong'),
('11.10.02.2009','Pertabas'),
('11.10.02.2010','Lae Riman'),
('11.10.02.2011','Pakiraman'),
('11.10.02.2012','Kuta Batu'),
('11.10.02.2013','Lae Nipe'),
('11.10.02.2014','Kuta Tinggi'),
('11.10.02.2015','Tuhtuhan'),
('11.10.02.2016','Lae Gecih'),
('11.10.02.2017','Guha'),
('11.10.02.2018','Lae Gambir'),
('11.10.02.2019','Cibubukan'),
('11.10.02.2020','Serasah'),
('11.10.02.2021','Tugan'),
('11.10.02.2022','Tanjung Mas'),
('11.10.02.2023','Lipat Kajang Atas'),
('11.10.02.2024','Sidodadi'),
('11.10.02.2025','Pandan Sari'),
('11.10.04','Singkil'),
('11.10.04.2001','Pasar'),
('11.10.04.2002','Ujung'),
('11.10.04.2003','Pulo Sarok'),
('11.10.04.2004','Kilangan'),
('11.10.04.2005','Kuta Simboling'),
('11.10.04.2007','Teluk Ambun'),
('11.10.04.2008','Rantau Gedang'),
('11.10.04.2009','Teluk Rumbia'),
('11.10.04.2010','Pea Bumbung'),
('11.10.04.2011','Pemuka'),
('11.10.04.2012','Takal pasir'),
('11.10.04.2014','Selok Aceh'),
('11.10.04.2016','Suka Makmur'),
('11.10.04.2017','Ujung Bawang'),
('11.10.04.2019','Siti Ambia'),
('11.10.04.2020','Suka Damai'),
('11.10.06','Gunung Meriah'),
('11.10.06.2001','Tanjung Betik'),
('11.10.06.2002','Penjahitan'),
('11.10.06.2003','Bukit Harapan'),
('11.10.06.2004','Cingkam'),
('11.10.06.2005','Labuhan Kera'),
('11.10.06.2006','Tanah Bara'),
('11.10.06.2007','Rimo'),
('11.10.06.2008','Blok VI Baru'),
('11.10.06.2009','Blok 15'),
('11.10.06.2010','Blok 18'),
('11.10.06.2011','Blok 31'),
('11.10.06.2012','Sidorejo'),
('11.10.06.2013','Suka Makmur'),
('11.10.06.2014','Gunung Lagan'),
('11.10.06.2015','Perangusan'),
('11.10.06.2016','Seping Baru'),
('11.10.06.2017','Sebatang'),
('11.10.06.2018','Tanah Merah'),
('11.10.06.2019','Pertampakan'),
('11.10.06.2020','Pandan Sari'),
('11.10.06.2021','Sanggaberu Silulusan'),
('11.10.06.2022','Tulaan'),
('11.10.06.2023','Tunas Harapan'),
('11.10.06.2024','Lae Butar'),
('11.10.06.2025','Sianjo-Anjo Meriah'),
('11.10.09','Kota Baharu'),
('11.10.09.2001','Lentong'),
('11.10.09.2002','Lapahan Buaya'),
('11.10.09.2003','Butar'),
('11.10.09.2004','Samar Dua'),
('11.10.09.2005','Ladang Bisik'),
('11.10.09.2006','Muara Pea'),
('11.10.09.2008','Sumber Mukti'),
('11.10.09.2009','Mukti Lincer'),
('11.10.09.2010','Danau Bungara'),
('11.10.10','Singkil Utara'),
('11.10.10.2001','Gosong Telaga Utara'),
('11.10.10.2002','Gosong Telaga Selatan'),
('11.10.10.2003','Kampung Baru'),
('11.10.10.2004','Ketapang Indah'),
('11.10.10.2005','Gosong Telaga Timur'),
('11.10.10.2006','Gosong Telaga Barat'),
('11.10.10.2007','Telaga Bakti'),
('11.10.11','Danau Paris'),
('11.10.11.2001','Lae Balno'),
('11.10.11.2002','Napagaluh'),
('11.10.11.2003','Sikoran'),
('11.10.11.2004','Situbuh-tubuh'),
('11.10.11.2005','Biskang'),
('11.10.11.2006','Sintuban Makmur'),
('11.10.12','Suro Makmur'),
('11.10.12.2001','Suro Makmur'),
('11.10.12.2002','Pangkalan Sulampi'),
('11.10.12.2003','Bulu Sema'),
('11.10.12.2004','Lae Bangun'),
('11.10.12.2005','Alur Linci'),
('11.10.12.2006','Siompin'),
('11.10.12.2007','Ketangkuhan'),
('11.10.12.2008','Keras'),
('11.10.12.2009','Mandumpang'),
('11.10.12.2010','Sirimo Mungkur'),
('11.10.12.2011','Bulu Ara'),
('11.10.13','Singkohor'),
('11.10.13.2001','Singkohor'),
('11.10.13.2002','Lae Sipola'),
('11.10.13.2003','Lae Pinang'),
('11.10.13.2004','Mukti Jaya'),
('11.10.13.2006','Sri Kayu'),
('11.10.13.2007','Pea Jambu'),
('11.10.14','Kuala Baru'),
('11.10.14.2001','Kuala Baru Laut'),
('11.10.14.2002','Kuala Baru Sungai'),
('11.10.14.2003','Suka Jaya'),
('11.10.14.2004','Kayu Menang'),
('11.10.16','Pulau Banyak Barat'),
('11.10.16.2001','Haloban'),
('11.10.16.2002','Asantola'),
('11.10.16.2003','Ujung Sialit'),
('11.10.16.2004','Suka Makmur'),
('11.11','Kabupaten Bireuen'),
('11.11.01','Samalanga'),
('11.11.01.2001','Keude Aceh'),
('11.11.01.2002','Sangso'),
('11.11.01.2003','Pante Rheng'),
('11.11.01.2004','Meuliek'),
('11.11.01.2005','Namploh Baro'),
('11.11.01.2006','Namploh Manyang'),
('11.11.01.2007','Namploh Blanggarang'),
('11.11.01.2008','Namploh Krueng'),
('11.11.01.2009','Namploh Papeun'),
('11.11.01.2010','Meunasah Lueng'),
('11.11.01.2011','Lhok Seumira'),
('11.11.01.2012','Ulee Jeumatan'),
('11.11.01.2013','Lancok'),
('11.11.01.2014','Paloh'),
('11.11.01.2015','Mesjid Baro'),
('11.11.01.2016','Batee Iliek'),
('11.11.01.2017','Pulo Baroh'),
('11.11.01.2018','Matang Wakeuh'),
('11.11.01.2019','Darussalam'),
('11.11.01.2020','Matang Jareung'),
('11.11.01.2021','Matang'),
('11.11.01.2022','Cot Mane'),
('11.11.01.2023','Alue Barat'),
('11.11.01.2024','Cot Siren'),
('11.11.01.2025','Ulee Alue'),
('11.11.01.2026','Pineung Siribee'),
('11.11.01.2027','Gampong Baro'),
('11.11.01.2028','Kandang'),
('11.11.01.2029','Gampong Putoh'),
('11.11.01.2030','Mideun Jok'),
('11.11.01.2031','Mideun Geudong'),
('11.11.01.2032','Lueng Keubeu'),
('11.11.01.2033','Glumpang Bungkok'),
('11.11.01.2034','Gampong Meulum'),
('11.11.01.2035','Cot Meurak Baroh'),
('11.11.01.2036','Cot Meurak Blang'),
('11.11.01.2037','Meurah'),
('11.11.01.2038','Ulee Ue'),
('11.11.01.2039','Matang Teungoh'),
('11.11.01.2040','Tanjong Baro'),
('11.11.01.2041','Angkieng Barat'),
('11.11.01.2042','Meunasah Lincah'),
('11.11.01.2043','Meunasah Lancok'),
('11.11.01.2044','Meunasah Puuk'),
('11.11.01.2045','Tanjongan Idem'),
('11.11.01.2084','Geulumpang Payong'),
('11.11.02','Jeunieb'),
('11.11.02.2018','Blang Me Timu'),
('11.11.02.2019','Lancang'),
('11.11.02.2020','Blang Lancang'),
('11.11.02.2021','Teupin Kupula'),
('11.11.02.2022','Tanjong Bungong'),
('11.11.02.2023','Dayah Baro'),
('11.11.02.2024','Ulee Rabo'),
('11.11.02.2025','Lueng Teungoh'),
('11.11.02.2026','Lampoh Oe'),
('11.11.02.2027','Pulo Rangkileh'),
('11.11.02.2028','Tufah'),
('11.11.02.2029','Sampo Ajad'),
('11.11.02.2030','Darul Aman'),
('11.11.02.2031','Lhok Kulam'),
('11.11.02.2032','Ulee Blang'),
('11.11.02.2033','Uteun Peupaleh'),
('11.11.02.2034','Ulee Gajah'),
('11.11.02.2035','Alue Seutui'),
('11.11.02.2036','Blang Neubok'),
('11.11.02.2037','Matang Bangka'),
('11.11.02.2038','Matang Teungoh'),
('11.11.02.2039','Matang Nibong'),
('11.11.02.2040','Blang Me Barat'),
('11.11.02.2041','Keude Jeunieb'),
('11.11.02.2042','Cot Geulumpang Baroh'),
('11.11.02.2043','Cot Geulumpang Tunong'),
('11.11.02.2044','Meunasah Keutapang'),
('11.11.02.2045','Meunasah Dayah'),
('11.11.02.2046','Lheu Simpang'),
('11.11.02.2047','Lheu Barat'),
('11.11.02.2048','Jeumpa Sikureng'),
('11.11.02.2049','Janggot Seungko'),
('11.11.02.2050','Meunasah Tambo'),
('11.11.02.2051','Meunasah Keupula'),
('11.11.02.2052','Meunasah Tunong Lueng'),
('11.11.02.2053','Meunasah Alue'),
('11.11.02.2054','Blang Pohroh'),
('11.11.02.2057','Meunasah Lueng'),
('11.11.02.2058','Dayah Blang Raleu'),
('11.11.02.2059','Meunasah Blang'),
('11.11.02.2060','Alue Lamsaba'),
('11.11.02.2061','Meunasah Kota'),
('11.11.02.2062','Paya Bili'),
('11.11.03','Peudada'),
('11.11.03.2001','Lawang'),
('11.11.03.2002','Matang Reuleut'),
('11.11.03.2003','Meunasah Krueng'),
('11.11.03.2004','Cot Keutapang'),
('11.11.03.2005','Meunasah Rabo'),
('11.11.03.2006','Meunasah Tambo'),
('11.11.03.2007','Meunasah Baroh'),
('11.11.03.2008','Meunasah Pulo'),
('11.11.03.2009','Matang Pasi'),
('11.11.03.2010','Blang Kubu'),
('11.11.03.2011','Garot'),
('11.11.03.2012','Ara Bungong'),
('11.11.03.2013','Jabet'),
('11.11.03.2014','Sawang'),
('11.11.03.2015','Blang Beururu'),
('11.11.03.2016','Hagu'),
('11.11.03.2017','Blang Rangkuluh'),
('11.11.03.2018','Meunasah Bungo'),
('11.11.03.2019','Paya Beunot'),
('11.11.03.2020','Meunasah Tunong'),
('11.11.03.2021','Meunasah Alue'),
('11.11.03.2022','Meunasah Cut'),
('11.11.03.2023','Gampong Mesjid'),
('11.11.03.2024','Meunasah Teungoh'),
('11.11.03.2025','Meunasah Blang'),
('11.11.03.2026','Kukue'),
('11.11.03.2027','Blang Matang'),
('11.11.03.2028','Blang Glumpang'),
('11.11.03.2029','Gampong Baro'),
('11.11.03.2030','Gampong Paya'),
('11.11.03.2031','Seuneubok Paya'),
('11.11.03.2032','Pulo Lawang'),
('11.11.03.2033','Keude Alue Rheng'),
('11.11.03.2034','Karieng'),
('11.11.03.2035','Pulo Ara'),
('11.11.03.2036','Cot Laot'),
('11.11.03.2037','Alue Sijuek'),
('11.11.03.2038','Blang Bati'),
('11.11.03.2039','Buket Paya'),
('11.11.03.2040','Dayah Mon Ara'),
('11.11.03.2041','Calok'),
('11.11.03.2042','Cot Kruet'),
('11.11.03.2043','Tanjong Seulamat'),
('11.11.03.2044','Jaba'),
('11.11.03.2045','Alue Gandai'),
('11.11.03.2046','Neubok Naleung'),
('11.11.03.2047','Paya Timu'),
('11.11.03.2048','Gampong Mulia'),
('11.11.03.2049','Pinto Rimba'),
('11.11.03.2050','Alue Keutapang'),
('11.11.03.2051','Tgk. Di Bathon'),
('11.11.03.2052','Paya Barat'),
('11.11.04','Jeumpa'),
('11.11.04.2032','Glumpang Payong'),
('11.11.04.2033','Blang Seunong'),
('11.11.04.2034','Cot Leusong'),
('11.11.04.2035','Batee Timoh'),
('11.11.04.2036','Lipah Rayeuk'),
('11.11.04.2037','Cot Geureundong'),
('11.11.04.2038','Lipah Cut'),
('11.11.04.2039','Beurawang'),
('11.11.04.2042','Geudong Tampu'),
('11.11.04.2043','Cot Tarom Baroh'),
('11.11.04.2044','Blang Cot Baroh'),
('11.11.04.2045','Blang Cot Tunong'),
('11.11.04.2046','Seuleumbah'),
('11.11.04.2047','Cot Keutapang'),
('11.11.04.2048','Cot Tarom Tunong'),
('11.11.04.2049','Blang Bladeh'),
('11.11.04.2050','Mon Jambee'),
('11.11.04.2051','Blang Dalam'),
('11.11.04.2052','Kuala Jeumpa'),
('11.11.04.2053','Cot Gadong'),
('11.11.04.2054','Cot Bada'),
('11.11.04.2055','Teupok Baroh'),
('11.11.04.2056','Teupok Tunong'),
('11.11.04.2057','Pulo Lawang'),
('11.11.04.2058','Abeuk Usong'),
('11.11.04.2059','Paloh Seulimeng'),
('11.11.04.2060','Abeuk Tingkeum'),
('11.11.04.2061','Blang Mee'),
('11.11.04.2062','Blang Seupeung'),
('11.11.04.2063','Blang Gandai'),
('11.11.04.2064','Cot Ulim'),
('11.11.04.2065','Cot Iboeh'),
('11.11.04.2071','Blang Rheum'),
('11.11.04.2072','Paloh Panyang'),
('11.11.04.2073','Seuneubok Lhong'),
('11.11.04.2075','Salah Sirong Jaya'),
('11.11.04.2076','Mon Mane'),
('11.11.04.2077','Alue Limeng'),
('11.11.04.2078','Cot Meugoe'),
('11.11.04.2079','Cot Iboeh Timu'),
('11.11.04.2080','Kuta Meuligoe'),
('11.11.04.2081','Lhaksmana'),
('11.11.05','Peusangan'),
('11.11.05.2003','Matang Glumpang Dua Mns. Timu (X)'),
('11.11.05.2004','Keude Matang Glumpang Dua'),
('11.11.05.2005','Matang Glumpang Dua Meunasah Dayah'),
('11.11.05.2006','Pante Gajah'),
('11.11.05.2007','Blang Asan'),
('11.11.05.2008','Paya Cut'),
('11.11.05.2009','Seuneubok Aceh'),
('11.11.05.2010','Panton Geulima'),
('11.11.05.2011','Neuheun'),
('11.11.05.2012','Matang Sagoe'),
('11.11.05.2013','Matang Mesjid'),
('11.11.05.2014','Matang Cot Paseh'),
('11.11.05.2015','Cot Panjoe'),
('11.11.05.2016','Paya Lipah'),
('11.11.05.2017','Paya Meuneng'),
('11.11.05.2018','Keude Tanjong'),
('11.11.05.2019','Tanjong Paya'),
('11.11.05.2020','Tanjong Nie'),
('11.11.05.2021','Tanjong Mesjid'),
('11.11.05.2022','Pante Cut'),
('11.11.05.2023','Blang Cut'),
('11.11.05.2024','Pulo Pisang'),
('11.11.05.2025','Pante Piyeu'),
('11.11.05.2026','Meunasah Nibong'),
('11.11.05.2027','Krueng Baro Babah Krueng'),
('11.11.05.2028','Krueng Baro Mesjid'),
('11.11.05.2029','Bayu'),
('11.11.05.2030','Gampong Putoh'),
('11.11.05.2031','Meunasah Meucap'),
('11.11.05.2032','Pante Ara'),
('11.11.05.2033','Gampong Raya Dagang'),
('11.11.05.2034','Gampong Raya Tambo'),
('11.11.05.2035','Kapa'),
('11.11.05.2036','Blang Panjoe'),
('11.11.05.2037','Pantee Lhong'),
('11.11.05.2038','Asan Bideun'),
('11.11.05.2040','Cot Rabo Baroh'),
('11.11.05.2041','Cot Rabo Tunong'),
('11.11.05.2042','Cot Nga'),
('11.11.05.2043','Pulo Naleung'),
('11.11.05.2044','Mata Mamplam'),
('11.11.05.2045','Alue Glumpang'),
('11.11.05.2046','Karieng'),
('11.11.05.2047','Krueng Dheu'),
('11.11.05.2048','Cot Ijue'),
('11.11.05.2049','Cot Buket'),
('11.11.05.2050','Nicah'),
('11.11.05.2051','Cot Keuranji'),
('11.11.05.2052','Paloh'),
('11.11.05.2054','Cot Bada Tunong'),
('11.11.05.2055','Cot Bada Baroh'),
('11.11.05.2056','Cot Girek'),
('11.11.05.2057','Cot Keumude'),
('11.11.05.2058','Sagoe'),
('11.11.05.2059','Pulo Ue Baroe'),
('11.11.05.2060','Cot Bada Barat'),
('11.11.05.2061','Tanoh Mirah'),
('11.11.05.2062','Seuneubok Rawa'),
('11.11.05.2063','Paya Aboe'),
('11.11.05.2064','Blang Rambong'),
('11.11.05.2065','Blang Geulanggang'),
('11.11.05.2066','Paya Reuhat'),
('11.11.05.2067','Uteun Bunta'),
('11.11.05.2068','Alue Udeng'),
('11.11.05.2069','Alue Peuno'),
('11.11.05.2105','Cot Puuk'),
('11.11.05.2106','Pante Pisang'),
('11.11.05.2107','Gampong Baro'),
('11.11.05.2108','Blang Dalam'),
('11.11.06','Makmur'),
('11.11.06.2001','Leubu Me'),
('11.11.06.2002','Paya Dua'),
('11.11.06.2003','Leubu Cot'),
('11.11.06.2004','Leubu Mesjid'),
('11.11.06.2005','Kuta Barat'),
('11.11.06.2006','Trienggadeng'),
('11.11.06.2007','Cot Kruet'),
('11.11.06.2008','Blang Khutang'),
('11.11.06.2009','Buket Seulamat'),
('11.11.06.2010','Lapehan Mesjid'),
('11.11.06.2011','Ulee Glee'),
('11.11.06.2012','Mona Ara'),
('11.11.06.2013','Pandak'),
('11.11.06.2014','Blang Dalam'),
('11.11.06.2015','Alue Dua'),
('11.11.06.2016','Seuneubok Baro'),
('11.11.06.2017','Panteu Breuh'),
('11.11.06.2018','Tanjong Mulia'),
('11.11.06.2019','Blang Mane'),
('11.11.06.2020','Meureubo'),
('11.11.06.2021','Blang Perlak'),
('11.11.06.2022','Panton Mesjid'),
('11.11.06.2023','Sukarame'),
('11.11.06.2024','Matang Kumbang'),
('11.11.06.2025','Pulo Teungoh'),
('11.11.06.2026','Batee Dabai'),
('11.11.06.2027','Ara Lipeh'),
('11.11.07','Gandapura'),
('11.11.07.2001','Keude Lapang'),
('11.11.07.2002','Lapang Barat'),
('11.11.07.2003','Lingka Kuta'),
('11.11.07.2004','Lapang Timu'),
('11.11.07.2005','Teupin Siron'),
('11.11.07.2006','Ie Rhop'),
('11.11.07.2007','Ceubo'),
('11.11.07.2008','Paloh Me'),
('11.11.07.2009','Lhok Mambang'),
('11.11.07.2010','Samuti Krueng'),
('11.11.07.2011','Cot Mane'),
('11.11.07.2012','Samuti Makmur'),
('11.11.07.2013','Samuti Rayeuk'),
('11.11.07.2014','Cot Puuk'),
('11.11.07.2015','Samuti Aman'),
('11.11.07.2016','Alue Mangki'),
('11.11.07.2017','Mon Keulayu'),
('11.11.07.2018','Geurugok'),
('11.11.07.2019','Blang Keude'),
('11.11.07.2020','Cot Tufah'),
('11.11.07.2021','Cot Tunong'),
('11.11.07.2022','Paya Baro'),
('11.11.07.2023','Paloh Kaye Kunyet'),
('11.11.07.2024','Cot Jabet'),
('11.11.07.2025','Cot Tube'),
('11.11.07.2026','Pante Sikumbong'),
('11.11.07.2027','Blang Guron'),
('11.11.07.2028','Dama Kawan'),
('11.11.07.2029','Paya Seupat'),
('11.11.07.2030','Cot Rambat'),
('11.11.07.2031','Paya Kareung'),
('11.11.07.2032','Mon Jeurujak'),
('11.11.07.2033','Tanjong Raya'),
('11.11.07.2034','Tanjong Mesjid'),
('11.11.07.2035','Blang Kubu'),
('11.11.07.2036','Tanjong Bungong'),
('11.11.07.2037','Pulo Gisa'),
('11.11.07.2038','Ujong Bayu'),
('11.11.07.2078','Mon Jambe'),
('11.11.07.2079','Blang Rheue'),
('11.11.08','Pandrah'),
('11.11.08.2001','Lancok Ulim'),
('11.11.08.2002','Nase Mee'),
('11.11.08.2003','Pandrah Kandeh'),
('11.11.08.2004','Panton'),
('11.11.08.2005','Lhok Dagang'),
('11.11.08.2006','Pandrah Janeng'),
('11.11.08.2007','Garot'),
('11.11.08.2008','Gampong Blang'),
('11.11.08.2009','Kuta Rusep'),
('11.11.08.2010','Blang Sama Gadeng'),
('11.11.08.2011','Panton Bili'),
('11.11.08.2012','Alue Igeuh'),
('11.11.08.2013','Meunasah Reudeup'),
('11.11.08.2014','Meunasah Teungoh'),
('11.11.08.2015','Bantayan'),
('11.11.08.2016','Cot Leubeng'),
('11.11.08.2017','Seunebok Baro'),
('11.11.08.2018','Uteuen Kruet'),
('11.11.08.2019','Nase Barat'),
('11.11.09','Juli'),
('11.11.09.2001','Juli Cot Mesjid'),
('11.11.09.2002','Juli Seutuy'),
('11.11.09.2003','Juli Tambo Tanjong'),
('11.11.09.2004','Juli Keude dua'),
('11.11.09.2005','Juli Tgk Dilampoh'),
('11.11.09.2006','Glumpang Meujimjim'),
('11.11.09.2007','Alue Unoe'),
('11.11.09.2008','Batee Raya'),
('11.11.09.2009','Seuneubok Peuraden'),
('11.11.09.2010','Juli Mee Teungoh'),
('11.11.09.2011','Seuneubok Gunci'),
('11.11.09.2012','Mane Meujingki'),
('11.11.09.2013','Abeuk Budi'),
('11.11.09.2014','Blang Ketumba'),
('11.11.09.2015','Pante Baro'),
('11.11.09.2016','Beunyot'),
('11.11.09.2017','Paya Cut'),
('11.11.09.2018','Teupin Mane'),
('11.11.09.2019','Simpang Jaya'),
('11.11.09.2020','Krueng Simpo'),
('11.11.09.2021','Suka Tani'),
('11.11.09.2022','Juli Seupeng'),
('11.11.09.2023','Bukit Mulia'),
('11.11.09.2024','Juli Meunasah Tambo'),
('11.11.09.2025','Alue Rambong'),
('11.11.09.2026','Juli Meunasah Teungoh'),
('11.11.09.2027','Juli Payaru'),
('11.11.09.2028','Paseh'),
('11.11.09.2029','Juli Cot Meurak'),
('11.11.09.2030','Pante Peusangan'),
('11.11.09.2031','Bale Panah'),
('11.11.09.2032','Ranto Panyang'),
('11.11.09.2033','Simpang Mulia'),
('11.11.09.2034','Seuneubok Dalam'),
('11.11.09.2035','Juli Meunasah Jok'),
('11.11.09.2036','Juli Uruek Anoe'),
('11.11.10','Jangka'),
('11.11.10.2001','Jangka Mesjid'),
('11.11.10.2002','Jangka Keutapang'),
('11.11.10.2003','Jangka Alue U'),
('11.11.10.2004','Jangka Alue'),
('11.11.10.2005','Jangka Alue Bie'),
('11.11.10.2006','Gampong Meulinteung'),
('11.11.10.2007','Paya Bieng'),
('11.11.10.2008','Meunasah Krueng'),
('11.11.10.2009','Barat Lanyan'),
('11.11.10.2010','Lamkuta'),
('11.11.10.2011','Geundot'),
('11.11.10.2012','Lueng'),
('11.11.10.2013','Kambuek'),
('11.11.10.2014','Ruseb Ara'),
('11.11.10.2015','Ruseb Dayah'),
('11.11.10.2016','Bada Barat'),
('11.11.10.2017','Bada Timu'),
('11.11.10.2018','Tanjongan'),
('11.11.10.2019','Tanah Anoe'),
('11.11.10.2020','Lhok Bugeng'),
('11.11.10.2021','Lampoh Rayeuk'),
('11.11.10.2022','Pulo Reudeup'),
('11.11.10.2023','Pulo Seuna'),
('11.11.10.2024','Linggong'),
('11.11.10.2025','Pulo Blang'),
('11.11.10.2026','Pulo Iboih'),
('11.11.10.2027','Abeuk Jaloh'),
('11.11.10.2028','Pulo U'),
('11.11.10.2029','Alue Buya'),
('11.11.10.2030','Alue Buya Pasi'),
('11.11.10.2031','Pante Sukon'),
('11.11.10.2032','Pante Paku'),
('11.11.10.2033','Bugak Blang'),
('11.11.10.2034','Bugak Mesjid'),
('11.11.10.2035','Bugak Krueng Matee'),
('11.11.10.2036','Bugak Krueng'),
('11.11.10.2037','Pante Ranub'),
('11.11.10.2038','Pulo Pineung Meunasah Dua'),
('11.11.10.2039','Punjot'),
('11.11.10.2040','Bugeng'),
('11.11.10.2041','Alue Kuta'),
('11.11.10.2042','Alue Bayeu Utang'),
('11.11.10.2043','Ulee Ceu'),
('11.11.10.2044','Kuala Cerape'),
('11.11.10.2045','Pante Peusangan'),
('11.11.10.2046','Alue Bie Pusong'),
('11.11.11','Simpang Mamplam'),
('11.11.11.2001','Rheum Barat'),
('11.11.11.2002','Rheum Baroh'),
('11.11.11.2003','Rheum Timu'),
('11.11.11.2004','Blang Kuta Coh'),
('11.11.11.2005','Blang Kuta Dua Meunasah'),
('11.11.11.2006','Lancang'),
('11.11.11.2007','Blang Teumulek'),
('11.11.11.2008','Meunasah Mesjid'),
('11.11.11.2009','Jurong Binjee'),
('11.11.11.2010','Blang Mane Dua Meunasah'),
('11.11.11.2011','Blang Mane Barat'),
('11.11.11.2012','Balee'),
('11.11.11.2013','Arongan'),
('11.11.11.2014','Meunasah Mamplam'),
('11.11.11.2015','Pulo Dapong'),
('11.11.11.2016','Ceurucok'),
('11.11.11.2017','Ie Rhob Glumpang'),
('11.11.11.2018','Ie Rhob Barat'),
('11.11.11.2019','Ie Rhob Timu'),
('11.11.11.2020','Ie Rhob Babah Lueng'),
('11.11.11.2021','Glee Meudong'),
('11.11.11.2022','Pulo Drien'),
('11.11.11.2023','Meunasah Dayah'),
('11.11.11.2024','Cot Trieng'),
('11.11.11.2025','Krueng Meuseugob'),
('11.11.11.2026','Lhok Tanoh'),
('11.11.11.2027','Blang Tambue'),
('11.11.11.2028','Keude Tambue'),
('11.11.11.2029','Meunasah Asan'),
('11.11.11.2030','Peuneulet Tunong'),
('11.11.11.2031','Cure Tunong'),
('11.11.11.2032','Cure Baroh'),
('11.11.11.2033','Peuneulet Baroh'),
('11.11.11.2034','Ulee Kareung'),
('11.11.11.2035','Blang Payang'),
('11.11.11.2036','Calok'),
('11.11.11.2037','Alue Leuhop'),
('11.11.11.2038','Paku'),
('11.11.11.2039','Lhok Mane'),
('11.11.11.2040','Tambue Barat'),
('11.11.11.2041','Meunasah Barat'),
('11.11.12','Peulimbang'),
('11.11.12.2001','Keude Plimbang'),
('11.11.12.2002','Krueng Baro'),
('11.11.12.2003','Seuneubok Nalan'),
('11.11.12.2004','Rambong Payong'),
('11.11.12.2005','Seuneubok Aceh'),
('11.11.12.2006','Seuneubok Plimbang'),
('11.11.12.2007','Seuneubok Punti'),
('11.11.12.2008','Uteun Sikumbong'),
('11.11.12.2009','Teupin Panah'),
('11.11.12.2010','Matang Kulee'),
('11.11.12.2011','Lancok Bungo'),
('11.11.12.2012','Uteun Rungkom'),
('11.11.12.2013','Padang Kasab'),
('11.11.12.2014','Seuneubok Seumawe'),
('11.11.12.2015','Jambo Dalam'),
('11.11.12.2016','Cot Gleumpang'),
('11.11.12.2017','Puuek'),
('11.11.12.2018','Balee Daka'),
('11.11.12.2019','Paloh Pupu'),
('11.11.12.2020','Seunebok Teungoh'),
('11.11.12.2021','Garab'),
('11.11.12.2022','Kuta Trieng'),
('11.11.13','Kota Juang'),
('11.11.13.2001','Bandar Bireuen'),
('11.11.13.2002','Bireuen Meunasah Reulet'),
('11.11.13.2003','Bireuen Meunasah Blang'),
('11.11.13.2004','Bireuen Meunasah Capa'),
('11.11.13.2005','Bireuen Meunasah Dayah'),
('11.11.13.2006','Bireuen Meunasah Tgk Digadong'),
('11.11.13.2007','Geudong-Geudong'),
('11.11.13.2008','Pulo Ara Geudong Teungoh'),
('11.11.13.2009','Geudong Alue'),
('11.11.13.2010','Pulo Kiton'),
('11.11.13.2011','Lhok Awe Teungoh'),
('11.11.13.2012','Geulanggang Teungoh'),
('11.11.13.2013','Cot Gapu'),
('11.11.13.2014','Geulanggang Kulam'),
('11.11.13.2015','Geulanggang Gampong'),
('11.11.13.2016','Blang Tingkeum'),
('11.11.13.2017','Buket Teukueh'),
('11.11.13.2018','Blang Reuling'),
('11.11.13.2019','Cot Jrat'),
('11.11.13.2020','Cot Peutek'),
('11.11.13.2021','Uteun Reutoh'),
('11.11.13.2022','Geulanggang Baro'),
('11.11.13.2023','Gampong Baro'),
('11.11.14','Kuala'),
('11.11.14.2001','Cot Batee'),
('11.11.14.2002','Cot Unoe'),
('11.11.14.2003','Kuta Baro'),
('11.11.14.2004','Cot Glumpang'),
('11.11.14.2005','Cot Kuta'),
('11.11.14.2006','Glumpang Baroh'),
('11.11.14.2007','Krueng Juli Timu'),
('11.11.14.2008','Krueng Juli Barat'),
('11.11.14.2009','Cot Trieng'),
('11.11.14.2010','Lhok Awe Awe'),
('11.11.14.2011','Cot Laga Sawa'),
('11.11.14.2012','Cot U Sibak'),
('11.11.14.2013','Lancok Pante Ara'),
('11.11.14.2014','Lancok-Lancok'),
('11.11.14.2015','Kareung'),
('11.11.14.2016','Balee Kuyun'),
('11.11.14.2017','Ujong Blang'),
('11.11.14.2018','Ujong Blang Mesjid'),
('11.11.14.2019','Weu Jangka'),
('11.11.14.2020','Kuala Raja'),
('11.11.15','Peusangan Siblah Krueng'),
('11.11.15.2001','Lueng Daneun'),
('11.11.15.2002','Rambong Payong'),
('11.11.15.2003','Alue Kupula'),
('11.11.15.2004','Blang Cirih'),
('11.11.15.2005','Kubu'),
('11.11.15.2006','Teupin Raya'),
('11.11.15.2007','Cot Aneuk Batee'),
('11.11.15.2008','Kubu Raya'),
('11.11.15.2009','Pante Baro Gle Siblah'),
('11.11.15.2010','Pante Baro Kumbang'),
('11.11.15.2011','Pante Baro Buket Panyang'),
('11.11.15.2012','Alue Krueb'),
('11.11.15.2013','Alue Iet'),
('11.11.15.2014','Paloh Mampre'),
('11.11.15.2015','Buket Sudan'),
('11.11.15.2016','Awe Geutah'),
('11.11.15.2017','Cot Saleuet'),
('11.11.15.2018','Alue Glumpang'),
('11.11.15.2019','Pante Karya'),
('11.11.15.2020','Awe Geutah Paya'),
('11.11.15.2021','Dayah Baro'),
('11.11.16','Peusangan Selatan'),
('11.11.16.2001','Darussalam'),
('11.11.16.2002','Blang Mane'),
('11.11.16.2003','Tanjong Beuridi'),
('11.11.16.2004','Darul Aman'),
('11.11.16.2005','Geulanggang Labu'),
('11.11.16.2006','Teupin Reudeup'),
('11.11.16.2007','Ulee Jalan'),
('11.11.16.2008','Paya Crot'),
('11.11.16.2009','Pulo Panyang'),
('11.11.16.2010','Me Rayeuk'),
('11.11.16.2011','Uteun Gathom'),
('11.11.16.2012','Lueng Kuli'),
('11.11.16.2013','Lueng Baro'),
('11.11.16.2014','Mata Ie'),
('11.11.16.2015','Blang Cut'),
('11.11.16.2016','Blang Pala'),
('11.11.16.2017','Krueng Beukah'),
('11.11.16.2018','Ceubrek'),
('11.11.16.2019','Uteun Raya'),
('11.11.16.2020','Pulo Harapan'),
('11.11.16.2021','Suwak'),
('11.11.17','Kuta Blang'),
('11.11.17.2001','Paloh Dama'),
('11.11.17.2002','Paya Rangkuluh'),
('11.11.17.2003','Paloh Raya'),
('11.11.17.2004','Crueng Kumbang'),
('11.11.17.2005','Tanjong Siron'),
('11.11.17.2006','Balee Mee'),
('11.11.17.2007','Buket Dalam'),
('11.11.17.2008','Parang Sikureung'),
('11.11.17.2009','Cot Baroh'),
('11.11.17.2010','Paloh Peuradi'),
('11.11.17.2011','Cot Mee'),
('11.11.17.2012','Blang Mee'),
('11.11.17.2013','Glee Putoh'),
('11.11.17.2014','Tingkeum Baro'),
('11.11.17.2015','Tingkeum Manyang'),
('11.11.17.2016','Kulu'),
('11.11.17.2017','Babah Suak'),
('11.11.17.2018','Ulee Pusong'),
('11.11.17.2019','Pulo Nga'),
('11.11.17.2020','Meusee'),
('11.11.17.2021','Blang Panjo'),
('11.11.17.2022','Babah Jurong'),
('11.11.17.2023','Dayah Panjoe'),
('11.11.17.2024','Pulo Blang'),
('11.11.17.2025','Imbudee'),
('11.11.17.2026','Pulo Siren'),
('11.11.17.2027','Jarommah Me'),
('11.11.17.2028','Jaromah Baroh'),
('11.11.17.2029','Lhok Nga'),
('11.11.17.2030','Pulo Reudeup'),
('11.11.17.2031','Geulanggang Meunjee'),
('11.11.17.2032','Geulanggang Panah'),
('11.11.17.2033','Ujong Blang'),
('11.11.17.2034','Geulanggang Rayeuk'),
('11.11.17.2035','Dayah Mesjid'),
('11.11.17.2036','Keurumbok'),
('11.11.17.2037','Cot Ara'),
('11.11.17.2038','Rancong'),
('11.11.17.2039','Jambo Kajeung'),
('11.11.17.2040','Kulu Kuta'),
('11.11.17.2041','Pulo Awe'),
('11.12','Kabupaten Aceh Barat Daya'),
('11.12.01','Blangpidie'),
('11.12.01.2006','Guhang'),
('11.12.01.2007','Seunaloh'),
('11.12.01.2008','Lhung Asan'),
('11.12.01.2010','Lhung Tarok'),
('11.12.01.2014','Cot Jeurat'),
('11.12.01.2015','Meudang Ara'),
('11.12.01.2016','Keude Siblah'),
('11.12.01.2017','Kuta Bahagia'),
('11.12.01.2018','Kuta Tinggi'),
('11.12.01.2019','Mata Ie'),
('11.12.01.2020','Geulumpang Payong'),
('11.12.01.2021','Panton Raya'),
('11.12.01.2022','Alue Manggota'),
('11.12.01.2023','Lam Kuta'),
('11.12.01.2024','Baharu'),
('11.12.01.2025','Keude Paya'),
('11.12.01.2026','Pasar Blangpidie'),
('11.12.01.2028','Kuta Tuha'),
('11.12.01.2029','Gudang'),
('11.12.01.2030','Babah Lhung'),
('11.12.02','Tangan-Tangan'),
('11.12.02.2001','Adan'),
('11.12.02.2002','Pante Geulumpang'),
('11.12.02.2003','Mesjid'),
('11.12.02.2004','Gunong Cut'),
('11.12.02.2005','Padang Kawa'),
('11.12.02.2006','Blang Padang'),
('11.12.02.2007','Padang Bak Jeumpa'),
('11.12.02.2008','Suak Labu'),
('11.12.02.2014','Bineh Krueng'),
('11.12.02.2015','Drien Kipah'),
('11.12.02.2016','Drien Jalo'),
('11.12.02.2017','Padang Bak Jok'),
('11.12.02.2018','Suak Nibong'),
('11.12.02.2019','Kuta Bak Drien'),
('11.12.02.2020','Ie Lhob'),
('11.12.03','Manggeng'),
('11.12.03.2001','Kedai'),
('11.12.03.2002','Padang'),
('11.12.03.2003','Tengah'),
('11.12.03.2005','Paya'),
('11.12.03.2006','Seuneulop'),
('11.12.03.2007','Lhok Puntoy'),
('11.12.03.2009','Ladang Panah'),
('11.12.03.2010','Pusu Ingin Jaya'),
('11.12.03.2011','Panton Makmur'),
('11.12.03.2022','Lhueng Baro'),
('11.12.03.2023','Tokoh'),
('11.12.03.2024','Blang Manggeng'),
('11.12.03.2025','Pante Raja'),
('11.12.03.2026','Sejahtera'),
('11.12.03.2027','Lhok Pawoh'),
('11.12.03.2029','Pante Pirak'),
('11.12.03.2030','Ujung Padang'),
('11.12.03.2031','Pante Cermin'),
('11.12.04','Susoh'),
('11.12.04.2001','Pantai Perak'),
('11.12.04.2002','Durian Rampak'),
('11.12.04.2003','Barat'),
('11.12.04.2004','Palak Hulu'),
('11.12.04.2005','Palak Hilir'),
('11.12.04.2006','Durian Jangek'),
('11.12.04.2007','Rumah Dua Lapis'),
('11.12.04.2008','Pinang'),
('11.12.04.2009','Rumah Panjang'),
('11.12.04.2010','Baharu'),
('11.12.04.2011','Pawoh'),
('11.12.04.2012','Padang Baru'),
('11.12.04.2013','Pulau Kayu'),
('11.12.04.2014','Ujung Padang'),
('11.12.04.2015','Kedai Susoh'),
('11.12.04.2016','Panjang Baru'),
('11.12.04.2017','Kedai Palak Kerambil'),
('11.12.04.2018','Ladang'),
('11.12.04.2019','Kepala Bandar'),
('11.12.04.2020','Tangah'),
('11.12.04.2021','Gadang'),
('11.12.04.2022','Padang Hilir'),
('11.12.04.2023','Blang Dalam'),
('11.12.04.2024','Meunasah'),
('11.12.04.2025','Lampoh Drien'),
('11.12.04.2026','Padang Panjang'),
('11.12.04.2027','Rubek Meupayong'),
('11.12.04.2028','Cot Mancang'),
('11.12.04.2029','Geulima Jaya'),
('11.12.05','Kuala Batee'),
('11.12.05.2001','Kota Bahagia'),
('11.12.05.2002','Pasar Kota Bahagia'),
('11.12.05.2003','Geulanggang Gajah'),
('11.12.05.2004','Kuala Terubue'),
('11.12.05.2005','Blang Makmur'),
('11.12.05.2006','Panto Cut'),
('11.12.05.2007','Alue Padee'),
('11.12.05.2008','Muka Blang'),
('11.12.05.2009','Lhung Geulumpang'),
('11.12.05.2010','Padang Sikabu'),
('11.12.05.2011','Kampung Tengah'),
('11.12.05.2012','Blang Panyang'),
('11.12.05.2013','Krueng Batee'),
('11.12.05.2014','Alue Pisang'),
('11.12.05.2015','Lhok Gajah'),
('11.12.05.2016','Ie Mameh'),
('11.12.05.2017','Keude Baro'),
('11.12.05.2018','Lama Tuha'),
('11.12.05.2019','Drien Berumbang'),
('11.12.05.2020','Rumoh Panyang'),
('11.12.05.2021','Krueng Panto'),
('11.12.06','Babah Rot'),
('11.12.06.2001','Pante Rakyat'),
('11.12.06.2002','Ie Mirah'),
('11.12.06.2003','Gunung Samarinda'),
('11.12.06.2004','Alue Jeurejak'),
('11.12.06.2005','Blang Dalam'),
('11.12.06.2006','Alue Peunawa'),
('11.12.06.2007','Pante Cermin'),
('11.12.06.2008','Blang Raja'),
('11.12.06.2009','Rukoen Dame'),
('11.12.06.2010','Simpang Gadeng'),
('11.12.06.2011','Teladan Jaya'),
('11.12.06.2012','Lhok Gayo'),
('11.12.06.2013','Alue Dawah'),
('11.12.06.2014','Cot Seumantok'),
('11.12.07','Setia'),
('11.12.07.2001','Lhang'),
('11.12.07.2002','Rambong'),
('11.12.07.2003','Pisang'),
('11.12.07.2004','Ujung Tanah'),
('11.12.07.2005','Alue Dama'),
('11.12.07.2007','Tangan-Tangan Cut'),
('11.12.07.2008','Mon Mameh'),
('11.12.07.2009','Cinta Makmur'),
('11.12.07.2010','Kuta Murni'),
('11.12.08','Jeumpa'),
('11.12.08.2001','Baru'),
('11.12.08.2002','Alue Rambot'),
('11.12.08.2003','Kuta Jeumpa'),
('11.12.08.2004','Alue Sungai Pinang'),
('11.12.08.2005','Cot Mane'),
('11.12.08.2006','Ladang Neubok'),
('11.12.08.2007','Asoe Nanggroe'),
('11.12.08.2008','Padang Geulumpang'),
('11.12.08.2009','Ikue Lhung'),
('11.12.08.2010','Kuta Makmur'),
('11.12.08.2011','Jeumpa Barat'),
('11.12.08.2012','Alue Seulaseh'),
('11.12.09','Lembah Sabil'),
('11.12.09.2001','Meurandeh'),
('11.12.09.2002','Sukadamai'),
('11.12.09.2003','Cot Bak-U'),
('11.12.09.2004','Meunasah Sukon'),
('11.12.09.2005','Meunasah Tengah'),
('11.12.09.2006','Geulanggang Batee'),
('11.12.09.2007','Kuta Paya'),
('11.12.09.2008','Ujung Tanah'),
('11.12.09.2009','Padang Keulele'),
('11.12.09.2010','Alue Rambot'),
('11.12.09.2011','Ladang Tuha I'),
('11.12.09.2012','Ladang Tuha II'),
('11.12.09.2013','Tokoh II'),
('11.12.09.2014','Kayee Aceh'),
('11.13','Kabupaten Gayo Lues'),
('11.13.01','Blangkejeren'),
('11.13.01.2001','Blangkejeren'),
('11.13.01.2002','Penampaan'),
('11.13.01.2003','Bukit'),
('11.13.01.2004','Bacang'),
('11.13.01.2005','Durin'),
('11.13.01.2007','Kampung Jawa'),
('11.13.01.2008','Porang'),
('11.13.01.2011','Kute Lintang'),
('11.13.01.2014','Leme'),
('11.13.01.2016','Gele'),
('11.13.01.2017','Sere'),
('11.13.01.2018','Cempa'),
('11.13.01.2019','Lempuh'),
('11.13.01.2021','Palok'),
('11.13.01.2022','Penggalangan'),
('11.13.01.2027','Agusen'),
('11.13.01.2031','Bustanussalam'),
('11.13.01.2032','Penampaan Uken'),
('11.13.01.2033','Raklunung'),
('11.13.01.2034','Sepang'),
('11.13.02','Kutapanjang'),
('11.13.02.2002','Tampeng'),
('11.13.02.2004','Bener'),
('11.13.02.2005','Ulun Tanoh'),
('11.13.02.2006','Kuta Ujung'),
('11.13.02.2008','Beranang'),
('11.13.02.2010','Rikit Dekat'),
('11.13.02.2011','Rema'),
('11.13.02.2014','Rema Baru'),
('11.13.02.2015','Cike'),
('11.13.02.2016','Kerukunan Kuta Panjang'),
('11.13.02.2020','Tampeng Musara'),
('11.13.02.2021','Kong Paluh'),
('11.13.03','Rikit Gaib'),
('11.13.03.2001','Ampa Kolak'),
('11.13.03.2002','Cane Toa'),
('11.13.03.2003','Padang Pasir'),
('11.13.03.2005','Pinang Rugub'),
('11.13.03.2006','Kuning'),
('11.13.03.2008','Mangang'),
('11.13.03.2011','Rempelam'),
('11.13.03.2012','Cane Uken'),
('11.13.03.2013','Tungel'),
('11.13.03.2014','Kota Rikit Gaib'),
('11.13.03.2016','Lukup Baru'),
('11.13.03.2017','Penomon Jaya'),
('11.13.03.2018','Tungel Baru'),
('11.13.04','Terangun'),
('11.13.04.2001','Jabo'),
('11.13.04.2002','Kutesange'),
('11.13.04.2003','Padang'),
('11.13.04.2006','Rumpi'),
('11.13.04.2007','Bukut'),
('11.13.04.2008','Terangun'),
('11.13.04.2010','Rempelam Pinang'),
('11.13.04.2011','Soyo'),
('11.13.04.2012','Terlis'),
('11.13.04.2013','Kutereje'),
('11.13.04.2014','Persada Tongra'),
('11.13.04.2015','Berhut'),
('11.13.04.2016','Gewat'),
('11.13.04.2017','Pantan Lues'),
('11.13.04.2018','Makmur Jaya'),
('11.13.04.2020','Blang Kuncir'),
('11.13.04.2023','Reje Pudung'),
('11.13.04.2024','Garut'),
('11.13.04.2025','Telege Jernih'),
('11.13.04.2026','Rime Raya'),
('11.13.04.2027','Lestari'),
('11.13.04.2028','Gawar Belangi'),
('11.13.04.2029','Blang Kala'),
('11.13.05','Pining'),
('11.13.05.2001','Pining'),
('11.13.05.2002','Pertik'),
('11.13.05.2003','Ekan'),
('11.13.05.2004','Uring'),
('11.13.05.2005','Gajah'),
('11.13.05.2006','Pintu Rime'),
('11.13.05.2007','Pepelah'),
('11.13.05.2008','Pasir Putih'),
('11.13.05.2009','Lesten'),
('11.13.06','Blangpegayon'),
('11.13.06.2001','Gantung Geluni'),
('11.13.06.2002','Kutabukit'),
('11.13.06.2003','Bener Baru'),
('11.13.06.2004','Blangbengkik'),
('11.13.06.2005','Kong'),
('11.13.06.2006','Ume Lah'),
('11.13.06.2007','Cinta Maju'),
('11.13.06.2008','Porang Ayu'),
('11.13.06.2009','Tetingi'),
('11.13.06.2010','Anak Reje'),
('11.13.06.2011','Bemem Buntul Pegayon'),
('11.13.06.2012','Akang Siwah'),
('11.13.07','Puteri Betung'),
('11.13.07.2001','Gumpang'),
('11.13.07.2002','Marpunge'),
('11.13.07.2003','Ramung Musara'),
('11.13.07.2004','Meloak Sepakat'),
('11.13.07.2005','Kutelengat Sepakat'),
('11.13.07.2006','Singah Mulo'),
('11.13.07.2007','Uning Pune'),
('11.13.07.2008','Gumpang Lempuh'),
('11.13.07.2009','Putri Betung'),
('11.13.08','Dabun Gelang'),
('11.13.08.2001','Pangur'),
('11.13.08.2002','Badak'),
('11.13.08.2003','Kendawi'),
('11.13.08.2004','Sangir'),
('11.13.08.2005','Panglima Linting'),
('11.13.08.2006','Blangtemung'),
('11.13.08.2007','Rerebe'),
('11.13.08.2008','Uning Gelung'),
('11.13.08.2009','Uning Sepakat'),
('11.13.09','Blangjerango'),
('11.13.09.2001','Penosan'),
('11.13.09.2002','Sekuelen'),
('11.13.09.2003','Akul'),
('11.13.09.2004','Gegarang'),
('11.13.09.2005','Peparik Gaib'),
('11.13.09.2006','Penosan Sepakat'),
('11.13.09.2007','Tingkem'),
('11.13.09.2008','Ketukah'),
('11.13.09.2009','Peparik Dekat'),
('11.13.09.2010','Blangjerango'),
('11.13.10','Teripe Jaya'),
('11.13.10.2001','Perlak'),
('11.13.10.2002','Rerebe'),
('11.13.10.2003','Pasir'),
('11.13.10.2004','Setul'),
('11.13.10.2005','UPT Paya Kumer'),
('11.13.10.2006','UPT Pantan Kela'),
('11.13.10.2007','Buntul Musara'),
('11.13.10.2008','Kuala Jernih'),
('11.13.10.2009','Uyem Beriring'),
('11.13.10.2010','Pulo Gelime'),
('11.13.11','Pantan Cuaca'),
('11.13.11.2001','Seneren'),
('11.13.11.2002','Remukut'),
('11.13.11.2003','Kenyaran'),
('11.13.11.2004','Tetingi'),
('11.13.11.2005','Atu Kapur'),
('11.13.11.2006','Suri Musara'),
('11.13.11.2007','UPT Aih Selah'),
('11.13.11.2008','Cane Baru'),
('11.13.11.2009','Kurnia'),
('11.14','Kabupaten Aceh Jaya'),
('11.14.01','Teunom'),
('11.14.01.2001','Keude Teunom'),
('11.14.01.2002','Alue Ambang'),
('11.14.01.2003','Padang Kleng'),
('11.14.01.2004','Panton'),
('11.14.01.2005','Pasi Tulak Bala'),
('11.14.01.2006','Gampong Baro'),
('11.14.01.2007','Rambong Payong'),
('11.14.01.2008','Pasi Pawang'),
('11.14.01.2009','Blang Baro'),
('11.14.01.2010','Tanoh Anoe'),
('11.14.01.2011','Tanoh Manyang'),
('11.14.01.2012','Batee Roo'),
('11.14.01.2013','Seuneubok Padang'),
('11.14.01.2014','Seumira'),
('11.14.01.2015','Kubu'),
('11.14.01.2016','Alue Meuraksa'),
('11.14.01.2017','Paya Baro'),
('11.14.01.2018','Teupin Ara'),
('11.14.01.2019','Cot Trap'),
('11.14.01.2020','Leung Gayo'),
('11.14.01.2021','Pasi Geulima'),
('11.14.01.2022','Pasi Timon'),
('11.14.02','Krueng Sabee'),
('11.14.02.2001','Bahagia'),
('11.14.02.2002','Sentosa'),
('11.14.02.2003','Dayah Baro'),
('11.14.02.2004','Gampong Blang'),
('11.14.02.2005','Keutapang'),
('11.14.02.2006','Panton Makmur'),
('11.14.02.2007','Keude Krueng Sabee'),
('11.14.02.2008','Kabong'),
('11.14.02.2009','Padang Datar'),
('11.14.02.2010','Datar Luas'),
('11.14.02.2011','Ranto Panyang'),
('11.14.02.2012','Buntha'),
('11.14.02.2013','Panggong'),
('11.14.02.2014','Curek'),
('11.14.02.2015','Alue Tho'),
('11.14.02.2016','Mon Mata'),
('11.14.02.2017','Paya Seumantok'),
('11.14.03','Setia Bakti'),
('11.14.03.2001','Sawang'),
('11.14.03.2002','Lhok Geulumpang'),
('11.14.03.2003','Padang'),
('11.14.03.2004','Gunong Meunasah'),
('11.14.03.2005','Sapek'),
('11.14.03.2006','Pante Kuyun'),
('11.14.03.2007','Glee Seubak'),
('11.14.03.2008','Gampong Baroh'),
('11.14.03.2009','Lhok Timon'),
('11.14.03.2010','Gampong Baro'),
('11.14.03.2011','Lhok Buya'),
('11.14.03.2012','Lhok Bot'),
('11.14.03.2013','Paya Laot'),
('11.14.04','Sampoi Niet'),
('11.14.04.2001','Lhok Kruet'),
('11.14.04.2002','Pulo Raya'),
('11.14.04.2003','Meunasah Kulam'),
('11.14.04.2004','Crak Mong'),
('11.14.04.2005','Alue Gro'),
('11.14.04.2006','Kuala Ligan'),
('11.14.04.2007','Babah Nipah'),
('11.14.04.2008','Jeumpheuk'),
('11.14.04.2009','Cot Langsat'),
('11.14.04.2010','Mata Ie'),
('11.14.04.2011','Blang Monlung'),
('11.14.04.2012','Krueng No'),
('11.14.04.2013','Seumantok'),
('11.14.04.2014','Ranto Sabon'),
('11.14.04.2015','Ligan'),
('11.14.04.2016','Ie Jeureungeh'),
('11.14.04.2020','Kuala Bakong'),
('11.14.04.2036','Cot Punti'),
('11.14.04.2037','Krueng Ayon'),
('11.14.05','Jaya'),
('11.14.05.2011','Pante Cermin'),
('11.14.05.2012','Sabet'),
('11.14.05.2013','Sango'),
('11.14.05.2014','Mareu'),
('11.14.05.2015','Lam Asan'),
('11.14.05.2016','Alue Rayeuk'),
('11.14.05.2017','Sapek'),
('11.14.05.2018','Lambaroh'),
('11.14.05.2019','Meudheun'),
('11.14.05.2020','Babah Ie'),
('11.14.05.2021','Ujong Sudheun'),
('11.14.05.2022','Krueng Tunong'),
('11.14.05.2023','Jambo Masi'),
('11.14.05.2024','Lamtui'),
('11.14.05.2025','Pasar Lamno'),
('11.14.05.2026','Meunasah Weh'),
('11.14.05.2027','Bak Paoh'),
('11.14.05.2028','Babah Krueng'),
('11.14.05.2029','Cot Dulang'),
('11.14.05.2030','Lamdurian'),
('11.14.05.2031','Putue'),
('11.14.05.2032','Gle Putoh'),
('11.14.05.2033','Pante Keutapang'),
('11.14.05.2034','Lamme'),
('11.14.05.2035','Meunasah Serba'),
('11.14.05.2036','Leupe'),
('11.14.05.2037','Meutara'),
('11.14.05.2038','Lhuet'),
('11.14.05.2039','Gle Jong'),
('11.14.05.2040','Darat'),
('11.14.05.2041','Gampong Baro'),
('11.14.05.2042','Panton Makmur'),
('11.14.05.2043','Rumpet'),
('11.14.05.2044','Nusa'),
('11.14.06','Panga'),
('11.14.06.2001','Keude Panga'),
('11.14.06.2002','Kuta Tuha'),
('11.14.06.2003','Tuwi Kareung'),
('11.14.06.2004','Ladang Baro'),
('11.14.06.2005','Panton Krueng'),
('11.14.06.2006','Gle Putoh'),
('11.14.06.2007','Alue Pande'),
('11.14.06.2008','Batee Meutudong'),
('11.14.06.2009','Gampong Harapan'),
('11.14.06.2010','Gunong Buloh'),
('11.14.06.2011','Gunong Meulinteung'),
('11.14.06.2013','Alue Abed'),
('11.14.06.2014','Gunong Mantok'),
('11.14.06.2015','Alue Raya'),
('11.14.06.2016','Alue Teungoh'),
('11.14.06.2017','Babah Ceupan'),
('11.14.06.2018','Tuwi Eumpeuk'),
('11.14.06.2019','Panton Kabu'),
('11.14.06.2020','Tuwi Kayee'),
('11.14.06.2021','Alue Piet'),
('11.14.07','Indra Jaya'),
('11.14.07.2001','Ujong Muloh'),
('11.14.07.2002','Janguet'),
('11.14.07.2003','Meunasah Rayeuk'),
('11.14.07.2004','Mukhan'),
('11.14.07.2005','Meunasah Teungoh'),
('11.14.07.2006','Meunasah Tutong'),
('11.14.07.2007','Babah Dua'),
('11.14.07.2008','Alue Mie'),
('11.14.07.2009','Teumareum'),
('11.14.07.2010','Kuala'),
('11.14.07.2011','Meudhang Ghon'),
('11.14.07.2012','Kareung Ateuh'),
('11.14.07.2013','Keude Unga'),
('11.14.07.2014','Ceunamprong'),
('11.14.08','Darul Hikmah'),
('11.14.08.2001','Patek'),
('11.14.08.2002','Gampong Baro Patek'),
('11.14.08.2003','Blang Dalam'),
('11.14.08.2004','Pajar'),
('11.14.08.2005','Reuntang'),
('11.14.08.2006','Cot Pange'),
('11.14.08.2007','Arongan'),
('11.14.08.2008','Paya Santeut'),
('11.14.08.2009','Krueng Tho'),
('11.14.08.2010','Panton Krueng'),
('11.14.08.2011','Alue Gajah'),
('11.14.08.2012','Sayeung'),
('11.14.08.2013','Gunong Cut'),
('11.14.08.2014','Ujong Rimba'),
('11.14.08.2015','Lamteungoh'),
('11.14.08.2016','Gampong Baro Lamteungoh'),
('11.14.08.2017','Babah Dua'),
('11.14.08.2018','Masen'),
('11.14.08.2019','Teupin Asan'),
('11.14.09','Pasie Raya'),
('11.14.09.2001','Pulo Tinggi'),
('11.14.09.2002','Alue Krueng'),
('11.14.09.2003','Pasi Teubee'),
('11.14.09.2004','Timpleung'),
('11.14.09.2005','Krueng Beukah'),
('11.14.09.2006','Tuwi Kareung'),
('11.14.09.2007','Lhok Guci'),
('11.14.09.2008','Tuwi Peuriya'),
('11.14.09.2009','Sarah Raya'),
('11.14.09.2010','Alue Jang'),
('11.14.09.2011','Ceuraceu'),
('11.14.09.2012','Alue Punti'),
('11.14.09.2013','Bintah'),
('11.14.09.2014','Buket Keumuneng'),
('11.15','Kabupaten Nagan Raya'),
('11.15.01','Kuala'),
('11.15.01.2003','Lawa Batu'),
('11.15.01.2004','Jogja'),
('11.15.01.2019','Ujong Sikuneng'),
('11.15.01.2020','Blang Muko'),
('11.15.01.2021','Pulo Ie'),
('11.15.01.2022','Purworejo'),
('11.15.01.2023','Blang Baro'),
('11.15.01.2024','Alue Ie Mameh'),
('11.15.01.2025','Ujong Pasi'),
('11.15.01.2026','Simpang Peut'),
('11.15.01.2027','Blang Teungoh'),
('11.15.01.2028','Ujong Padang'),
('11.15.01.2029','Cot Kumbang'),
('11.15.01.2030','Blang Bintang'),
('11.15.01.2031','Ujong Patihah'),
('11.15.01.2032','Kuta Makmue'),
('11.15.01.2033','Gunong Reubo'),
('11.15.02','Seunagan'),
('11.15.02.2001','Jeuram'),
('11.15.02.2002','Pante Ceureumen'),
('11.15.02.2003','Kuta Baro Jeuram'),
('11.15.02.2004','Parom'),
('11.15.02.2005','Peureulak'),
('11.15.02.2006','Kuta Sayeh'),
('11.15.02.2007','Blang Baro'),
('11.15.02.2008','Padang'),
('11.15.02.2009','Alue Tho'),
('11.15.02.2010','Lhok Parom'),
('11.15.02.2011','Sapek'),
('11.15.02.2012','Alue Dodok'),
('11.15.02.2013','Cot Kumbang'),
('11.15.02.2014','Kuta Kumbang'),
('11.15.02.2015','Nigan'),
('11.15.02.2016','Gampong Cot'),
('11.15.02.2017','Blang Pateuk'),
('11.15.02.2018','Blang Puuk Nigan'),
('11.15.02.2019','Krueng Ceh'),
('11.15.02.2020','Bantan'),
('11.15.02.2021','Cot Lhe-Lhe'),
('11.15.02.2022','Rambong Rayeuk'),
('11.15.02.2023','Paya Udeung'),
('11.15.02.2024','Alue Buloh'),
('11.15.02.2025','Kuta Paya'),
('11.15.02.2026','Krueng Ceuko'),
('11.15.02.2027','Lhok Padang'),
('11.15.02.2028','Kuta Aceh'),
('11.15.02.2029','Krueng Mangkom'),
('11.15.02.2030','Latong'),
('11.15.02.2031','Paya Undan'),
('11.15.02.2032','Blang Puuk Kulu'),
('11.15.02.2033','Blang Murong'),
('11.15.02.2034','Kulu'),
('11.15.02.2035','Rambong Cut'),
('11.15.03','Seunagan Timur'),
('11.15.03.2001','Blang Panyang'),
('11.15.03.2002','Meugat Meh'),
('11.15.03.2003','Lhok Pange'),
('11.15.03.2004','Blang Lango'),
('11.15.03.2005','Tuwi Meuleusong'),
('11.15.03.2006','Blang Geudong'),
('11.15.03.2007','Blang Teungku'),
('11.15.03.2008','Sawang Mane'),
('11.15.03.2009','Keude Neulop'),
('11.15.03.2010','Kila'),
('11.15.03.2011','Kandeh'),
('11.15.03.2012','Cot Gud'),
('11.15.03.2013','Kabu Baroh'),
('11.15.03.2014','Kabu Tunong'),
('11.15.03.2015','Keude Linteung'),
('11.15.03.2016','Meurandeh Suak'),
('11.15.03.2017','Uteun Pulo'),
('11.15.03.2018','Cot Manyang'),
('11.15.03.2019','Pulo Teungoh'),
('11.15.03.2020','Cot Dirui'),
('11.15.03.2021','Cot Teuku Dek'),
('11.15.03.2022','Sapeng'),
('11.15.03.2023','Peuleukung'),
('11.15.03.2024','Paya'),
('11.15.03.2025','Blang Preh'),
('11.15.03.2026','Blang Ara Keude'),
('11.15.03.2027','Blang Ara Gampong'),
('11.15.03.2028','Ie Beudoh'),
('11.15.03.2029','Blang Bayu'),
('11.15.03.2030','Mon Bateung'),
('11.15.03.2031','Suak Peureubong'),
('11.15.03.2032','Krueng Kulu'),
('11.15.03.2033','Cot Punti'),
('11.15.03.2034','Lhok Mesjid'),
('11.15.04','Beutong'),
('11.15.04.2001','Blang Seunong'),
('11.15.04.2002','Pante Ara'),
('11.15.04.2003','Gunong Nagan'),
('11.15.04.2004','Tuwi Bunta'),
('11.15.04.2005','Blang Mesjid'),
('11.15.04.2006','Blang Neuang'),
('11.15.04.2007','Panton Bayam'),
('11.15.04.2008','Blang Baro Pulo Raga'),
('11.15.04.2009','Krueng Cut'),
('11.15.04.2010','Blang Leumak'),
('11.15.04.2011','Babah Krueng'),
('11.15.04.2012','Blang Seumot'),
('11.15.04.2013','Lhok Seumot'),
('11.15.04.2014','Meunasah Pante'),
('11.15.04.2015','Kuta Jeumpa'),
('11.15.04.2016','Blang Dalam'),
('11.15.04.2017','Keude Seumot'),
('11.15.04.2018','Blang Baro Rambong'),
('11.15.04.2019','Ujong Blang'),
('11.15.04.2020','Meunasah Krueng'),
('11.15.04.2021','Meunasah Dayah'),
('11.15.04.2022','Meunasah Teungoh'),
('11.15.04.2023','Kulam Jeureuneh'),
('11.15.04.2028','Bumi Sari'),
('11.15.05','Darul Makmur'),
('11.15.05.2012','Lamie'),
('11.15.05.2013','Kuta Trieng'),
('11.15.05.2014','Geulanggang Gajah'),
('11.15.05.2015','Kayee Unoe'),
('11.15.05.2016','Blang Baro'),
('11.15.05.2017','Alue Bilie'),
('11.15.05.2018','Suka Raja'),
('11.15.05.2019','Gunong Cut'),
('11.15.05.2020','Suka Jadi'),
('11.15.05.2021','Tuwi Buya'),
('11.15.05.2022','Ujong Lamie'),
('11.15.05.2023','Suak Palembang'),
('11.15.05.2024','Alue Waki'),
('11.15.05.2025','Alue Geutah'),
('11.15.05.2026','Krueng Alem'),
('11.15.05.2027','Alue Rambot'),
('11.15.05.2028','Krueng Seumayam'),
('11.15.05.2029','Pulo Teungoh'),
('11.15.05.2030','Karang Anyar'),
('11.15.05.2031','Kuala Seumayam'),
('11.15.05.2032','Pulo Ie'),
('11.15.05.2033','Pulo Kruet'),
('11.15.05.2034','Alue Kuyun'),
('11.15.05.2035','Alue Raya'),
('11.15.05.2036','Alue Jampak'),
('11.15.05.2037','Suka Mulia'),
('11.15.05.2038','Simpang Dua'),
('11.15.05.2039','Sidojadi'),
('11.15.05.2040','Serba Jadi'),
('11.15.05.2041','Serba Guna'),
('11.15.05.2042','Simpang Deli Kilang'),
('11.15.05.2043','Panton Bayu'),
('11.15.05.2044','Ujong Tanjong'),
('11.15.05.2045','Suka Ramai'),
('11.15.05.2046','Ladang Baro'),
('11.15.05.2047','Alue Bateung Brok'),
('11.15.05.2048','Simpang Deli Kampong'),
('11.15.05.2049','Blang Luah'),
('11.15.05.2050','Sumber Makmur'),
('11.15.05.2051','Makarti Jaya'),
('11.15.06','Suka Makmue'),
('11.15.06.2001','Lueng Baro'),
('11.15.06.2002','Alue Kambuk'),
('11.15.06.2003','Kuta Padang'),
('11.15.06.2004','Suak Bilie'),
('11.15.06.2005','Macah'),
('11.15.06.2006','Seumambek'),
('11.15.06.2007','Cot Kuta'),
('11.15.06.2008','Kabu Blang Sapek'),
('11.15.06.2009','Cot Peuradi'),
('11.15.06.2010','Blang Sapek'),
('11.15.06.2011','Lhok Beutong'),
('11.15.06.2012','Gampong Teungoh'),
('11.15.06.2013','Lhok Rameuan'),
('11.15.06.2014','Blang Muling'),
('11.15.06.2015','Krak Tampai'),
('11.15.06.2016','Meureubo'),
('11.15.06.2017','Kuta Baro Blang Muling'),
('11.15.06.2018','Alue Peusaja'),
('11.15.06.2019','Alue Gajah'),
('11.15.07','Kuala Pesisir'),
('11.15.07.2001','Suak Puntong'),
('11.15.07.2002','Gampong Lhok'),
('11.15.07.2003','Kuala Baro'),
('11.15.07.2004','Padang Rubek'),
('11.15.07.2005','Pulo'),
('11.15.07.2006','Langkak'),
('11.15.07.2007','Kuala Tuha'),
('11.15.07.2008','Kubang Gajah'),
('11.15.07.2009','Kuala Trang'),
('11.15.07.2010','Cot Rambong'),
('11.15.07.2011','Padang Panyang'),
('11.15.07.2012','Arongan'),
('11.15.07.2013','Jati Rejo'),
('11.15.07.2014','Purwodadi'),
('11.15.07.2015','Lueng Teuku Ben'),
('11.15.07.2016','Purwosari'),
('11.15.08','Tadu Raya'),
('11.15.08.2001','Alue Bata'),
('11.15.08.2002','Gunong Sapek'),
('11.15.08.2003','Sarah Mantok'),
('11.15.08.2004','Pasie Luah'),
('11.15.08.2005','Gunong Geulugo'),
('11.15.08.2006','Gunong Kupok'),
('11.15.08.2007','Gunong Pungki'),
('11.15.08.2008','Alue Siron'),
('11.15.08.2009','Cot Mue'),
('11.15.08.2010','Babah Rot'),
('11.15.08.2011','Babah Dua'),
('11.15.08.2012','Batu Raja'),
('11.15.08.2013','Simpang Jaya'),
('11.15.08.2014','Sumber Daya'),
('11.15.08.2015','Rantau Selamat'),
('11.15.08.2016','Alue Seupeung'),
('11.15.08.2017','Krueng Itam'),
('11.15.08.2018','Alue Gajah'),
('11.15.08.2019','Alue Labu'),
('11.15.08.2020','Gapa Garu'),
('11.15.08.2021','Kuala Tadu'),
('11.15.08.2022','Cot Mee'),
('11.15.09','Tripa Makmur'),
('11.15.09.2001','Kuala Tripa'),
('11.15.09.2002','Babah Lueng'),
('11.15.09.2003','Drien Tujoh'),
('11.15.09.2004','Lueng Keubeu Jagat'),
('11.15.09.2005','Kabu'),
('11.15.09.2006','Pasie Keube Dom'),
('11.15.09.2007','Neubok Yee PK'),
('11.15.09.2008','Neubok Yee PP'),
('11.15.09.2009','Mon Dua'),
('11.15.09.2010','Ujong Krueng'),
('11.15.09.2011','Panton Pange'),
('11.15.10','Beutong Ateuh Banggalang'),
('11.15.10.2001','Blang Puuk'),
('11.15.10.2002','Babah Suak'),
('11.15.10.2003','Kuta Teungoh'),
('11.15.10.2004','Blang Meurandeh'),
('11.16','Kabupaten Aceh Tamiang'),
('11.16.01','Manyak Payed'),
('11.16.01.2001','Simpang Lhee'),
('11.16.01.2002','Buket Panyang Sa'),
('11.16.01.2003','Buket Panyang Dua'),
('11.16.01.2004','Seuneubok Baru'),
('11.16.01.2005','Sampaimah'),
('11.16.01.2006','Krueng Sikajang'),
('11.16.01.2007','Seuneubok Punti'),
('11.16.01.2008','Mesjid'),
('11.16.01.2009','Paya Ketenggar'),
('11.16.01.2010','Pahlawan'),
('11.16.01.2011','Matang Ara Aceh'),
('11.16.01.2012','Ie Bintah'),
('11.16.01.2013','Geudham'),
('11.16.01.2014','Geulanggang Merak'),
('11.16.01.2015','Bukit Paya'),
('11.16.01.2016','Dagang Setia'),
('11.16.01.2017','Meunasah Paya'),
('11.16.01.2018','Benteng Anyer'),
('11.16.01.2019','Tanjung Neraca'),
('11.16.01.2020','Lueng Manyo'),
('11.16.01.2021','Tualang Baro'),
('11.16.01.2022','Lhok Medang Ara'),
('11.16.01.2023','Kaseh Sayang'),
('11.16.01.2024','Seuneubok Pidie'),
('11.16.01.2025','Matang Cincin'),
('11.16.01.2026','Matang Ara Jawa'),
('11.16.01.2027','Meurandeh'),
('11.16.01.2028','Raja Tuha'),
('11.16.01.2029','Ujung Tanjung'),
('11.16.01.2030','Alue Ie Puteh'),
('11.16.01.2031','Alue Sentang'),
('11.16.01.2032','Seuneubok Cantek'),
('11.16.01.2033','Sapta Marga'),
('11.16.01.2034','Paya Baru'),
('11.16.01.2035','Bandung Jaya'),
('11.16.01.2036','Pandan Sari'),
('11.16.02','Bendahara'),
('11.16.02.2001','Mesjid Sungai Iyu'),
('11.16.02.2002','Alur Cantik'),
('11.16.02.2003','Tanjung Lipat I'),
('11.16.02.2004','Tanjung Lipat II'),
('11.16.02.2005','Seuneubok Dalam Mesjid'),
('11.16.02.2006','Bandar Baru'),
('11.16.02.2007','Cinta Raja'),
('11.16.02.2008','Kuala Genting'),
('11.16.02.2009','Bandar Khalifah'),
('11.16.02.2010','Suka Mulia Bendahara'),
('11.16.02.2011','Seuneubok Aceh'),
('11.16.02.2012','Tengku Tinggi'),
('11.16.02.2013','Perkebunan Sungai Iyu'),
('11.16.02.2014','Marlempang'),
('11.16.02.2015','Balai'),
('11.16.02.2016','Lubuk Batil'),
('11.16.02.2017','Lambung Blang'),
('11.16.02.2018','Tanjung Parit'),
('11.16.02.2019','Tanjung'),
('11.16.02.2020','Raja'),
('11.16.02.2021','Tumpok Tengoh'),
('11.16.02.2029','Upah'),
('11.16.02.2030','Perkebunan Upah'),
('11.16.02.2031','Matang Tepah'),
('11.16.02.2035','Seuneubok Dalam Upah'),
('11.16.02.2036','Mesjid Bendahara'),
('11.16.02.2037','Teluk Kemiri'),
('11.16.02.2038','Teluk Kepayang'),
('11.16.02.2039','Teluk Halban'),
('11.16.02.2040','Rantau Pakam'),
('11.16.02.2041','Tanjung Binjai'),
('11.16.02.2042','Tanjung Mulia'),
('11.16.02.2043','Kuala Penaga'),
('11.16.03','Karang Baru'),
('11.16.03.2001','Kesehatan'),
('11.16.03.2002','Suka Jadi'),
('11.16.03.2006','Menanggini'),
('11.16.03.2007','Tanjung Karang'),
('11.16.03.2009','Bundar'),
('11.16.03.2011','Dalam'),
('11.16.03.2012','Tanah Terban'),
('11.16.03.2013','Air Tenang'),
('11.16.03.2014','Johar'),
('11.16.03.2015','Tupah'),
('11.16.03.2016','Banai'),
('11.16.03.2017','Rantau Panjang'),
('11.16.03.2018','Medang Ara'),
('11.16.03.2019','Pahlawan'),
('11.16.03.2020','Alur Selalas'),
('11.16.03.2021','Paya Tampah'),
('11.16.03.2022','Alur Baung'),
('11.16.03.2023','Kebun Tanah Terban'),
('11.16.03.2024','Kebun Medang Ara'),
('11.16.03.2025','Kebun Afdeling Seleleh'),
('11.16.03.2026','Paya Awe'),
('11.16.03.2027','Simpang Empat'),
('11.16.03.2028','Paya Kulbi'),
('11.16.03.2029','Alur Bemban'),
('11.16.03.2030','Paya Meta'),
('11.16.03.2031','Tanjung Seumantoh'),
('11.16.03.2032','Bukit Keranji'),
('11.16.03.2033','Kebun Tanjung Seumantoh'),
('11.16.03.2034','Bukit Panjang'),
('11.16.03.2035','Alue Lhok'),
('11.16.03.2036','Suka Jadi Paya Bujok'),
('11.16.04','Seruway'),
('11.16.04.2002','Pekan Seruway'),
('11.16.04.2003','Binjai'),
('11.16.04.2004','Pantai Balai'),
('11.16.04.2005','Padang Langgis'),
('11.16.04.2006','Suka Ramai Satu'),
('11.16.04.2007','Suka Ramai Dua'),
('11.16.04.2008','Perkebunan Seruway'),
('11.16.04.2009','Gedung Biara'),
('11.16.04.2010','Alur Alim'),
('11.16.04.2011','Tualang'),
('11.16.04.2012','Matang Sentang'),
('11.16.04.2013','Air Masin'),
('11.16.04.2014','Sidodadi'),
('11.16.04.2015','Perk. Gedung Biara'),
('11.16.04.2016','Muka Sungai Kuruk'),
('11.16.04.2017','Paya Udang'),
('11.16.04.2018','Gelung'),
('11.16.04.2019','Kampung Baru'),
('11.16.04.2020','Kuala Pusung Kapal'),
('11.16.04.2021','Sungai Kuruk I'),
('11.16.04.2022','Sungai Kuruk II'),
('11.16.04.2023','Sungai Kuruk III'),
('11.16.04.2024','Tangsi Lama'),
('11.16.04.2025','Lubuk Damar'),
('11.16.05','Kota Kualasinpang'),
('11.16.05.2001','Kota Kualasimpang'),
('11.16.05.2002','Perdamaian'),
('11.16.05.2003','Sriwijaya'),
('11.16.05.2004','Bukit Tempurung'),
('11.16.05.2005','Kota Lintang'),
('11.16.06','Kejuruan Muda'),
('11.16.06.2001','Bukit Rata'),
('11.16.06.2002','Pangkalan'),
('11.16.06.2003','Tanjung Mancang'),
('11.16.06.2004','Simpang Kanan'),
('11.16.06.2005','Tanjung Genteng'),
('11.16.06.2006','Gerenggam'),
('11.16.06.2007','Suka Makmur'),
('11.16.06.2008','Alur Selebu'),
('11.16.06.2010','Sungai Liput'),
('11.16.06.2011','Kebun Sungai Liput'),
('11.16.06.2012','Purwodadi'),
('11.16.06.2013','Jawa'),
('11.16.06.2014','Sidodadi'),
('11.16.06.2015','Karang Jadi'),
('11.16.06.2016','Seumadam'),
('11.16.06.2021','Alur Mentawak'),
('11.16.07','Tamiang Hulu'),
('11.16.07.2001','Alur Tani Satu'),
('11.16.07.2002','Alur Tani Dua'),
('11.16.07.2003','Bandar Khalifah'),
('11.16.07.2004','Kaloy'),
('11.16.07.2005','Perkebunan Pulau Tiga'),
('11.16.07.2006','Harum Sari'),
('11.16.07.2007','Bandar Setia'),
('11.16.07.2008','Rongoh'),
('11.16.07.2010','Wono Sari'),
('11.16.08','Rantau'),
('11.16.08.2001','Benua Raja'),
('11.16.08.2002','Landuh'),
('11.16.08.2003','Paya Bedi'),
('11.16.08.2004','Ingin Jaya'),
('11.16.08.2005','Suka Rahmat'),
('11.16.08.2006','Suka Jadi'),
('11.16.08.2007','Durian'),
('11.16.08.2008','Rantau Pauh'),
('11.16.08.2009','Alur Cucur'),
('11.16.08.2010','Pertamina'),
('11.16.08.2011','Kebun Rantau'),
('11.16.08.2012','Alur Manis'),
('11.16.08.2013','Jamur Jelatang'),
('11.16.08.2014','Suka Rakyat'),
('11.16.08.2015','Jamur Labu'),
('11.16.08.2016','Suka Mulia'),
('11.16.08.2017','Mekar Jaya'),
('11.16.09','Banda Mulia'),
('11.16.09.2001','Telaga Meuku Sa'),
('11.16.09.2002','Telaga Meuku Dua'),
('11.16.09.2003','Alur Nunang'),
('11.16.09.2004','Tanjung Keramat'),
('11.16.09.2005','Matang Seping'),
('11.16.09.2006','Besar'),
('11.16.09.2007','Paya Rahat'),
('11.16.09.2008','Suka Jadi'),
('11.16.09.2009','Suka Mulia Upah'),
('11.16.09.2010','Suka Damai'),
('11.16.10','Bandar Pusaka'),
('11.16.10.2001','Aras Sembilan'),
('11.16.10.2002','Jambo Rambong'),
('11.16.10.2003','Blang Kandis'),
('11.16.10.2004','Alur Jambu'),
('11.16.10.2005','Perkebunan Alur Jambu'),
('11.16.10.2006','Batang Ara'),
('11.16.10.2007','Perupuk'),
('11.16.10.2008','Serba'),
('11.16.10.2009','Sunting'),
('11.16.10.2010','Rantau Bintang'),
('11.16.10.2011','Babo'),
('11.16.10.2012','Pantai Cempa'),
('11.16.10.2013','Pengidam'),
('11.16.10.2014','Bengkelang'),
('11.16.10.2015','Batu Bedulang'),
('11.16.11','Tenggulun'),
('11.16.11.2001','Tebing Tinggi'),
('11.16.11.2002','Rimba Sawang'),
('11.16.11.2003','Tenggulun'),
('11.16.11.2004','Selamat'),
('11.16.11.2005','Simpang Kiri'),
('11.16.11.2006','Sumber Makmur'),
('11.16.12','Sekerak'),
('11.16.12.2001','Bandar Mahligai'),
('11.16.12.2002','Sekerak Kiri'),
('11.16.12.2003','Pantai Tinjau'),
('11.16.12.2004','Pantai Perlak'),
('11.16.12.2005','Kebun Batang Ara'),
('11.16.12.2006','Sekerak Kanan'),
('11.16.12.2007','Lubuk Sidup'),
('11.16.12.2008','Sekumur'),
('11.16.12.2009','Tanjung Gelumpang'),
('11.16.12.2010','Pematang Durian'),
('11.16.12.2011','Juar'),
('11.16.12.2012','Sulum'),
('11.16.12.2013','Suka Makmur'),
('11.16.12.2014','Baling Karang'),
('11.17','Kabupaten Bener Meriah'),
('11.17.01','Pintu Rime Gayo'),
('11.17.01.2001','Blang Rakal'),
('11.17.01.2002','Negeri Antara'),
('11.17.01.2003','Alur Cincin'),
('11.17.01.2004','Pantan Sinaku'),
('11.17.01.2005','Bintang Berangun'),
('11.17.01.2006','Taman Firdaus'),
('11.17.01.2007','Uning Mas'),
('11.17.01.2008','Perdamaian'),
('11.17.01.2009','Ulu Naron'),
('11.17.01.2010','Pantan Lah'),
('11.17.01.2011','Pancar Jelobok'),
('11.17.01.2012','Alur Gading'),
('11.17.01.2013','Rime Raya'),
('11.17.01.2014','Singah Mulo'),
('11.17.01.2015','Simpang Lancang'),
('11.17.01.2016','Wih Porak'),
('11.17.01.2017','Bener Meriah'),
('11.17.01.2018','Musara 58'),
('11.17.01.2019','Musara Pakat'),
('11.17.01.2020','Rata Ara'),
('11.17.01.2021','Gemasih'),
('11.17.01.2022','Pulo Intan'),
('11.17.01.2023','Blang Ara'),
('11.17.02','Permata'),
('11.17.02.2001','Bener Pepanyi'),
('11.17.02.2002','Bintang Bener'),
('11.17.02.2003','Bintang Permata'),
('11.17.02.2004','Buntul Peteri'),
('11.17.02.2005','Darul Aman'),
('11.17.02.2006','GLP. Wih Tenang Uken'),
('11.17.02.2007','Pantan Tengah Jaya'),
('11.17.02.2008','Penosan Jaya'),
('11.17.02.2009','Ramung Jaya'),
('11.17.02.2010','Seni Antara'),
('11.17.02.2011','Temas Mumanang'),
('11.17.02.2012','Wih Tenang Toa'),
('11.17.02.2013','Wih Tenang Uken'),
('11.17.02.2014','Ayu Ara'),
('11.17.02.2015','Ceding Ayu'),
('11.17.02.2016','Uning Sejuk'),
('11.17.02.2017','Suku Sara Tangke'),
('11.17.02.2018','Rikit Musara'),
('11.17.02.2019','Jungke'),
('11.17.02.2020','Burni Pase'),
('11.17.02.2021','Bale Musara'),
('11.17.02.2022','Pemango'),
('11.17.02.2023','Jelobok'),
('11.17.02.2024','Kepies'),
('11.17.02.2025','Timur Jaya'),
('11.17.02.2026','Bale Purnama'),
('11.17.02.2027','Tawar Bengi'),
('11.17.03','Syiah Utama'),
('11.17.03.2001','Blang Panu'),
('11.17.03.2003','Gerpa'),
('11.17.03.2004','Goneng'),
('11.17.03.2007','Kerlang'),
('11.17.03.2008','Kutelah Lane'),
('11.17.03.2009','Pasir Putih'),
('11.17.03.2010','Payung'),
('11.17.03.2012','Rusip'),
('11.17.03.2014','Tembolon'),
('11.17.03.2015','Uning'),
('11.17.03.2016','Wihni Durin'),
('11.17.03.2017','Rata Mulie'),
('11.17.03.2018','Tempen Baru'),
('11.17.03.2019','Geruti Jaya'),
('11.17.04','Bandar'),
('11.17.04.2001','Bahgie Bertona'),
('11.17.04.2003','Bathin Baru'),
('11.17.04.2004','Blang Pulo'),
('11.17.04.2009','Bukit Wih Ilang'),
('11.17.04.2010','Hakim Wih Ilang'),
('11.17.04.2011','Janarata'),
('11.17.04.2012','Keramat Jaya'),
('11.17.04.2013','Lewa Jadi'),
('11.17.04.2014','Muyang Kute Mangku'),
('11.17.04.2016','Pakat Jeroh'),
('11.17.04.2017','Paya Baning'),
('11.17.04.2018','Blang Jorong'),
('11.17.04.2019','Pondok Baru'),
('11.17.04.2020','Pondok Gajah'),
('11.17.04.2021','Pondok Ulung'),
('11.17.04.2022','Puja Mulia'),
('11.17.04.2023','Purwosari'),
('11.17.04.2024','Selamat Rejo'),
('11.17.04.2025','Sidodadi'),
('11.17.04.2026','Simpang Utama'),
('11.17.04.2027','Suku Wih Ilang'),
('11.17.04.2028','Tanjung Pura'),
('11.17.04.2029','Wonosari'),
('11.17.04.2030','Mutiara'),
('11.17.04.2032','Tansaran Bidin'),
('11.17.04.2033','Jadi Sepakat'),
('11.17.04.2034','Selisih Mara'),
('11.17.04.2035','Kala Nempan'),
('11.17.04.2036','Gunung Antara'),
('11.17.04.2037','Gele Semayang'),
('11.17.04.2042','Tawar Sedenge'),
('11.17.04.2043','Beranun Teleden'),
('11.17.04.2044','Remang Ketike Jaya'),
('11.17.04.2045','Makmur Sentosa'),
('11.17.04.2047','Sinar Jaya Paya Ringkel'),
('11.17.05','Bukit'),
('11.17.05.2001','Bale Atu'),
('11.17.05.2002','Bale Redelong'),
('11.17.05.2003','Batin Wih Pongas'),
('11.17.05.2004','Blang Ara'),
('11.17.05.2005','Blang Sentang'),
('11.17.05.2006','Blang Tampu'),
('11.17.05.2007','Bujang'),
('11.17.05.2009','Delung Tue'),
('11.17.05.2010','Hakim Tungul Naru'),
('11.17.05.2011','Isaq Busur'),
('11.17.05.2012','Kenawat Redelong'),
('11.17.05.2013','Kute Lintang'),
('11.17.05.2014','Panji Mulia I'),
('11.17.05.2015','Panji Mulia II'),
('11.17.05.2016','Pasar Simpang Tiga'),
('11.17.05.2017','Reje Guru'),
('11.17.05.2018','Rembele'),
('11.17.05.2019','Sedie Jadi'),
('11.17.05.2020','Tingkem Asli'),
('11.17.05.2021','Tingkem Benyer'),
('11.17.05.2022','Tingkem Bersatu'),
('11.17.05.2023','Ujung Gele'),
('11.17.05.2024','Uning Bersah'),
('11.17.05.2025','Uning Teritit'),
('11.17.05.2026','Waq Pondok Sayur'),
('11.17.05.2027','Babussalam'),
('11.17.05.2028','Paya Gajah'),
('11.17.05.2029','Kute Tanyung'),
('11.17.05.2030','Meluem'),
('11.17.05.2031','Delung Asli'),
('11.17.05.2032','Pilar Jaya'),
('11.17.05.2033','Serule Kayu'),
('11.17.05.2034','Uring'),
('11.17.05.2035','Mupakat Jadi'),
('11.17.05.2036','Kute Kering'),
('11.17.05.2037','Blang Panas'),
('11.17.05.2038','Mutiara Baru'),
('11.17.05.2039','Bukit Bersatu'),
('11.17.05.2040','Godang'),
('11.17.05.2041','Karang Rejo'),
('11.17.06','Wih Pesam'),
('11.17.06.2001','Blang Paku'),
('11.17.06.2004','Pante Raya'),
('11.17.06.2005','Simpang Balek'),
('11.17.06.2006','Simpang Teritit'),
('11.17.06.2007','Suka Jadi'),
('11.17.06.2008','Suka Makmur'),
('11.17.06.2009','Suka Ramai Atas'),
('11.17.06.2010','Suka Ramai Bawah'),
('11.17.06.2011','Syura Jadi'),
('11.17.06.2012','Jamur Uluh'),
('11.17.06.2013','Gegerung'),
('11.17.06.2014','Merie Satu'),
('11.17.06.2015','Blang Benara'),
('11.17.06.2016','Bukit Pepanyi'),
('11.17.06.2017','Wih Pesam'),
('11.17.06.2018','Cinta Damai'),
('11.17.06.2019','Bener Ayu'),
('11.17.06.2020','Bener Mulie'),
('11.17.06.2021','Blang Kucak'),
('11.17.06.2022','Wonosobo'),
('11.17.06.2023','Lut Kucak'),
('11.17.06.2024','Kebun Baru'),
('11.17.06.2025','Simpang Antara'),
('11.17.06.2026','Jamur Ujung'),
('11.17.06.2027','Suka Makmur Timur'),
('11.17.06.2028','Burni Telong'),
('11.17.07','Timang gajah'),
('11.17.07.2001','Bandar Lampahan'),
('11.17.07.2002','Blang Rongka'),
('11.17.07.2003','Cekal Baru'),
('11.17.07.2004','Gegur Sepakat'),
('11.17.07.2005','Karang Jadi'),
('11.17.07.2006','Lampahan'),
('11.17.07.2010','Setie'),
('11.17.07.2011','Simpang Layang'),
('11.17.07.2012','Suka Damai'),
('11.17.07.2014','Tunyang'),
('11.17.07.2016','Datu Beru'),
('11.17.07.2017','Kenine'),
('11.17.07.2018','Rembune'),
('11.17.07.2019','Damaran Baru'),
('11.17.07.2020','Fajar Harapan'),
('11.17.07.2021','Mude Benara'),
('11.17.07.2022','Kampung Baru 76'),
('11.17.07.2023','Pantan Pediangan'),
('11.17.07.2024','Bumi Ayu'),
('11.17.07.2025','Kulem Para Kanis'),
('11.17.07.2026','Mekar Ayu'),
('11.17.07.2027','Lampahan Barat'),
('11.17.07.2028','Lampahan Timur'),
('11.17.07.2029','Timang Rasa'),
('11.17.07.2030','Gunung Tunyang'),
('11.17.07.2031','Bukit Tunyang'),
('11.17.07.2032','Linung Bale'),
('11.17.07.2033','Pantan Kemuning'),
('11.17.07.2034','Sumber Jaya'),
('11.17.07.2035','Bukit Mulie'),
('11.17.08','Bener Kelipah'),
('11.17.08.2001','Bandar Jaya'),
('11.17.08.2002','Jongok Meluem'),
('11.17.08.2003','Suku Bener'),
('11.17.08.2004','Bener Lukup II'),
('11.17.08.2005','Gunung Musara'),
('11.17.08.2006','Bener Kelipah Selatan'),
('11.17.08.2007','Bintang Musara'),
('11.17.08.2008','Kala Tenang'),
('11.17.08.2009','Bener Kelipah Utara'),
('11.17.08.2010','Lot Bener Kelipah'),
('11.17.08.2011','Nosar Tawar Jaya'),
('11.17.08.2012','Nosar Baru'),
('11.17.09','Mesidah'),
('11.17.09.2001','Cemparam Lama'),
('11.17.09.2002','Cemparam Pakat Jeroh'),
('11.17.09.2003','Cemparam Jaya'),
('11.17.09.2004','Pantan Kuli'),
('11.17.09.2005','Simpang Renggali'),
('11.17.09.2006','Jamur Atu Jaya'),
('11.17.09.2007','Sosial'),
('11.17.09.2008','Gunung Sayang'),
('11.17.09.2009','Amor'),
('11.17.09.2010','Buntul Gayo'),
('11.17.09.2011','Wih Resap'),
('11.17.09.2012','Wer Tingkem'),
('11.17.09.2013','Perumpaken Benjadi'),
('11.17.09.2014','Hakim Peteri Pintu'),
('11.17.09.2015','Simpur'),
('11.17.10','Gajah Putih'),
('11.17.10.2001','Simpang Rahmat'),
('11.17.10.2002','Gajah Putih'),
('11.17.10.2003','Gayo Setie'),
('11.17.10.2004','Umah Besi'),
('11.17.10.2005','Pante Karya'),
('11.17.10.2006','Meriah Jaya'),
('11.17.10.2007','Timang Gajah'),
('11.17.10.2008','Pantan Lues'),
('11.17.10.2009','Alam Jaya'),
('11.17.10.2010','Reronga'),
('11.18','Kabupaten Pidie Jaya'),
('11.18.01','Meureudu'),
('11.18.01.2001','Meunasah Balek'),
('11.18.01.2002','Kota Meureudu'),
('11.18.01.2003','Mesjid Tuha'),
('11.18.01.2004','Rungkom'),
('11.18.01.2005','Blang Awe'),
('11.18.01.2006','Manyang Lancok'),
('11.18.01.2007','Manyang Cut'),
('11.18.01.2008','Beurawang'),
('11.18.01.2009','Rhieng Blang'),
('11.18.01.2010','Rhieng Krueng'),
('11.18.01.2011','Rhieng Mancang'),
('11.18.01.2012','Meunasah Lhok'),
('11.18.01.2013','Meuraksa'),
('11.18.01.2014','Pulo U'),
('11.18.01.2015','Geuleudah'),
('11.18.01.2016','Dayah Timu'),
('11.18.01.2017','Bunot'),
('11.18.01.2018','Glumpang Tutong'),
('11.18.01.2019','Meunasah Hagu'),
('11.18.01.2020','Pohroh'),
('11.18.01.2021','Kudrang'),
('11.18.01.2022','Lampoh Lada'),
('11.18.01.2023','Mulieng'),
('11.18.01.2024','Dayah Tuha'),
('11.18.01.2025','Rumpuen'),
('11.18.01.2026','Rambong'),
('11.18.01.2027','Meunasah Kulam'),
('11.18.01.2028','Grong-Grong'),
('11.18.01.2029','Kuta Trieng'),
('11.18.01.2030','Teupin Peuraho'),
('11.18.02','Ulim'),
('11.18.02.2001','Dayah Baroh'),
('11.18.02.2002','Reuleut'),
('11.18.02.2003','Sambongan Baro'),
('11.18.02.2004','Tijien Husen'),
('11.18.02.2005','Meunasah Krueng'),
('11.18.02.2006','Geulanggang'),
('11.18.02.2007','Mesjid Ulim Baroh'),
('11.18.02.2008','Pulo Lhok'),
('11.18.02.2009','Dayah Leubue'),
('11.18.02.2010','Tijien Daboh'),
('11.18.02.2011','Keude Ulim'),
('11.18.02.2012','Meunasah Bueng'),
('11.18.02.2013','Balee Ulim'),
('11.18.02.2014','Grong Grong Capa'),
('11.18.02.2015','Meunasah Kumbang'),
('11.18.02.2016','Tanjong Ulim'),
('11.18.02.2017','Mesjid Ulim Tunong'),
('11.18.02.2018','Pulo Ulim'),
('11.18.02.2019','Siblah Coh'),
('11.18.02.2020','Bidok'),
('11.18.02.2021','Pantang Cot Baloi'),
('11.18.02.2022','Meunasah Pupu'),
('11.18.02.2023','Nangrhoe Barat'),
('11.18.02.2024','Nangrhoe Timu'),
('11.18.02.2025','Meunasah Mesjid'),
('11.18.02.2026','Blang Rheue'),
('11.18.02.2027','Cot Seutui'),
('11.18.02.2028','Lhok Gajah'),
('11.18.02.2029','Alue Keumiki'),
('11.18.02.2030','Blang Cari'),
('11.18.03','Jangka Buya'),
('11.18.03.2001','Meuko Jurong'),
('11.18.03.2002','Kuta Baroh'),
('11.18.03.2003','Meuko Meugit'),
('11.18.03.2004','Kiran Dayah'),
('11.18.03.2005','Kiran Baroh'),
('11.18.03.2006','Keurisi Meunasah Raya'),
('11.18.03.2007','Keurisi Meunasah Lueng'),
('11.18.03.2008','Keurisi Meunasah Beurembang'),
('11.18.03.2009','Meunasah Mee'),
('11.18.03.2010','Meunasah Kumbang'),
('11.18.03.2011','Kiran Krueng'),
('11.18.03.2012','Buket Teungoh'),
('11.18.03.2013','Reului Mangat'),
('11.18.03.2014','Gampong Cot'),
('11.18.03.2015','Jurong Binje'),
('11.18.03.2016','Jurong Teungoh'),
('11.18.03.2017','Jurong Ara'),
('11.18.03.2018','Keude Jangka Buya'),
('11.18.04','Bandar Dua'),
('11.18.04.2001','Keude Ulee Gle'),
('11.18.04.2002','Ulee Gle'),
('11.18.04.2003','Blang Dalam'),
('11.18.04.2004','Pulo'),
('11.18.04.2005','Baro'),
('11.18.04.2006','Meuko Kuthang'),
('11.18.04.2007','Uteun Bayu'),
('11.18.04.2008','Alue Ketapang'),
('11.18.04.2009','Jaulanga Barat'),
('11.18.04.2010','Kumba'),
('11.18.04.2011','Babah Krueng'),
('11.18.04.2012','Pohroh'),
('11.18.04.2013','Seunong'),
('11.18.04.2014','Alue Mee'),
('11.18.04.2015','Blang Kuta'),
('11.18.04.2016','Drien Tujoh'),
('11.18.04.2017','Alue Sane'),
('11.18.04.2018','Gahru'),
('11.18.04.2019','Lhok Pusong'),
('11.18.04.2020','Paya Pisang Klat'),
('11.18.04.2021','Cot Geurefai'),
('11.18.04.2022','Muko Dayah'),
('11.18.04.2023','Meuko Buloh'),
('11.18.04.2024','Peulakan Tunong'),
('11.18.04.2025','Adan'),
('11.18.04.2026','Meugit Kayee Panyang'),
('11.18.04.2027','Meugit Sagoe'),
('11.18.04.2028','Meurandeh Alue'),
('11.18.04.2029','Reudeup Melayu'),
('11.18.04.2030','Meunasah Paku'),
('11.18.04.2031','Jeulanga Mata Ie'),
('11.18.04.2032','Jeulanga Mesjid'),
('11.18.04.2033','Pulo Gapu'),
('11.18.04.2034','Blang Miroe'),
('11.18.04.2035','Beurasan'),
('11.18.04.2036','Cot Keng'),
('11.18.04.2037','Krueng Kiran'),
('11.18.04.2038','Asan Kumbang'),
('11.18.04.2039','Drien Bungong'),
('11.18.04.2040','Peulakan Cibrek'),
('11.18.04.2041','Paya Tunong'),
('11.18.04.2042','Peulakan Tambo'),
('11.18.04.2043','Paya Baroh'),
('11.18.04.2044','Meuko Baroh'),
('11.18.04.2045','Kuta Krueng'),
('11.18.05','Meurah Dua'),
('11.18.05.2001','Lhok Sandeng'),
('11.18.05.2002','Sarah Mane'),
('11.18.05.2003','Seunong'),
('11.18.05.2004','Lancok'),
('11.18.05.2005','Meunasah Kulam'),
('11.18.05.2006','Meunasah Teungoh'),
('11.18.05.2007','Meunasah Bie'),
('11.18.05.2008','Meunasah Raya'),
('11.18.05.2009','Geunteng'),
('11.18.05.2010','Gampong Blang'),
('11.18.05.2011','Blang Cut'),
('11.18.05.2012','Dayah Kruet'),
('11.18.05.2013','Meunasah Mancang'),
('11.18.05.2014','Dayah Usen'),
('11.18.05.2015','Lueng Bimba'),
('11.18.05.2016','Beuringen'),
('11.18.05.2017','Buangan'),
('11.18.05.2018','Meunasah Jurong'),
('11.18.05.2019','Pante Beureune'),
('11.18.06','Bandar Baru'),
('11.18.06.2001','Cut Nyong'),
('11.18.06.2002','Meunasah Gampong'),
('11.18.06.2003','Baro'),
('11.18.06.2004','Pulo Rheng'),
('11.18.06.2005','Dayah Nyong'),
('11.18.06.2006','Daboih'),
('11.18.06.2007','Beurandeh'),
('11.18.06.2008','Kaye Raya'),
('11.18.06.2009','Blang Glong'),
('11.18.06.2010','Tutong'),
('11.18.06.2011','Siren'),
('11.18.06.2012','Keude Lueng Putu'),
('11.18.06.2013','Peub Lueng Nibong'),
('11.18.06.2014','Baroh Musa'),
('11.18.06.2015','Teungoh Musa'),
('11.18.06.2016','Balee'),
('11.18.06.2017','Udeung'),
('11.18.06.2018','Ara'),
('11.18.06.2019','Baroh Lancok'),
('11.18.06.2020','Manyang'),
('11.18.06.2021','Mesjid'),
('11.18.06.2022','Pulo Pueb'),
('11.18.06.2023','Sawang'),
('11.18.06.2024','Tualada'),
('11.18.06.2025','Cut Langien'),
('11.18.06.2026','Sagoe'),
('11.18.06.2027','Dayah Langien'),
('11.18.06.2028','Baroh Cot'),
('11.18.06.2029','Meunasah Blang Iboih'),
('11.18.06.2030','Blang Sukon'),
('11.18.06.2031','Kayee Jatoe'),
('11.18.06.2032','Blang Baro'),
('11.18.06.2033','Lancang'),
('11.18.06.2034','Paru Keude'),
('11.18.06.2035','Blang Krueng'),
('11.18.06.2036','Jijiem'),
('11.18.06.2037','Sarah Panyang'),
('11.18.06.2038','Abah Lueng'),
('11.18.06.2039','Aki Neungoh'),
('11.18.06.2040','Ujong Leubat'),
('11.18.06.2041','Alue'),
('11.18.06.2042','Tanoh Mirah'),
('11.18.06.2043','Paru Cot'),
('11.18.07','Panteraja'),
('11.18.07.2001','Keude Panteraja'),
('11.18.07.2002','Tu'),
('11.18.07.2003','Hagu'),
('11.18.07.2004','Muka Blang'),
('11.18.07.2005','Lhok Puuk'),
('11.18.07.2006','Mesjid'),
('11.18.07.2007','Teungoh'),
('11.18.07.2008','Tunong'),
('11.18.07.2009','Peurade'),
('11.18.07.2010','Reudeup'),
('11.18.08','Trienggadeng'),
('11.18.08.2001','Sagoe'),
('11.18.08.2002','Mee Peuduek'),
('11.18.08.2003','Mesjid Peuduek'),
('11.18.08.2004','Tuha'),
('11.18.08.2005','Reuseb'),
('11.18.08.2006','Dee'),
('11.18.08.2007','Panton Raya'),
('11.18.08.2008','Deah Teumanah'),
('11.18.08.2009','Tampui'),
('11.18.08.2010','Keude Trienggadeng'),
('11.18.08.2011','Raya'),
('11.18.08.2012','Paya'),
('11.18.08.2013','Meue'),
('11.18.08.2014','Mesjid Trienggadeng'),
('11.18.08.2015','Teungkluet'),
('11.18.08.2016','Matang'),
('11.18.08.2017','Deah Ujong Baroh'),
('11.18.08.2018','Peulandok Teungoh'),
('11.18.08.2019','Peulandok Tunong'),
('11.18.08.2020','Deah Pangwa'),
('11.18.08.2021','Meucat'),
('11.18.08.2022','Cot Makaso'),
('11.18.08.2023','Buloh'),
('11.18.08.2024','Mee Pangwa'),
('11.18.08.2025','Kuta Pangwa'),
('11.18.08.2026','Cot Lheue Rheng'),
('11.18.08.2027','Rawasari'),
('11.71','Kota Banda Aceh'),
('11.71.01','Baiturrahman'),
('11.71.01.2001','Kampung Baru'),
('11.71.01.2002','Neusu Jaya'),
('11.71.01.2003','Sukaramai'),
('11.71.01.2004','Seutui'),
('11.71.01.2005','Peuniti'),
('11.71.01.2006','Neusu Aceh'),
('11.71.01.2007','Ateuk Pahlawan'),
('11.71.01.2008','Ateuk Jawo'),
('11.71.01.2009','Ateuk Deah Tanoh'),
('11.71.01.2010','Ateuk Munjeng'),
('11.71.02','Kuta Alam'),
('11.71.02.2001','Mulia'),
('11.71.02.2002','Peunayong'),
('11.71.02.2003','Laksana'),
('11.71.02.2004','Keuramat'),
('11.71.02.2005','Kota Baru'),
('11.71.02.2006','Beurawe'),
('11.71.02.2007','Kuta Alam'),
('11.71.02.2008','Bandar Baru'),
('11.71.02.2009','Lamdingin'),
('11.71.02.2010','Lampulo'),
('11.71.02.2011','Lambaro Skep'),
('11.71.03','Meuraxa'),
('11.71.03.2001','Punge Jurong'),
('11.71.03.2002','Ulee Lheue'),
('11.71.03.2003','Lambung'),
('11.71.03.2004','Deah Glumpang'),
('11.71.03.2005','Deah Baro'),
('11.71.03.2006','Alue Deah Teungoh'),
('11.71.03.2007','Lampaseh Aceh'),
('11.71.03.2008','Blang Oi'),
('11.71.03.2009','Asoe Nanggroe'),
('11.71.03.2010','Gampong Blang'),
('11.71.03.2011','Gampong Pie'),
('11.71.03.2012','Lamjabat'),
('11.71.03.2013','Cot Lamkuweuh'),
('11.71.03.2014','Surien'),
('11.71.03.2015','Gampong Baro'),
('11.71.03.2016','Punge Ujong'),
('11.71.04','Syiah Kuala'),
('11.71.04.2001','Jeulingke'),
('11.71.04.2002','Tibang'),
('11.71.04.2003','Deah Raya'),
('11.71.04.2004','Alue Naga'),
('11.71.04.2005','Ie Masen Kayee Adang'),
('11.71.04.2006','Pineung'),
('11.71.04.2007','Lamgugob'),
('11.71.04.2008','Kopelma Darussalam'),
('11.71.04.2009','Rukoh'),
('11.71.04.2010','Peurada'),
('11.71.05','Lueng Bata'),
('11.71.05.2001','Lueng Bata'),
('11.71.05.2002','Cot Mesjid'),
('11.71.05.2003','Panteriek'),
('11.71.05.2004','Blang Cut'),
('11.71.05.2005','Lamseupeung'),
('11.71.05.2006','Batoh'),
('11.71.05.2007','Suka Damai'),
('11.71.05.2008','Lamdom'),
('11.71.05.2009','Lampaloh'),
('11.71.06','Kuta Raja'),
('11.71.06.2001','Keudah'),
('11.71.06.2002','Peulanggahan'),
('11.71.06.2003','Merduati'),
('11.71.06.2004','Lampaseh Kota'),
('11.71.06.2005','Gampong Pande'),
('11.71.06.2006','Gampong Jawa'),
('11.71.07','Banda Raya'),
('11.71.07.2001','Geuceu Komplek'),
('11.71.07.2002','Lamlagang'),
('11.71.07.2003','Geuceu Iniem'),
('11.71.07.2004','Geuceu Kayee Jato'),
('11.71.07.2005','Lam Ara'),
('11.71.07.2006','Lhong Raya'),
('11.71.07.2007','Mibo'),
('11.71.07.2008','Peunyerat'),
('11.71.07.2009','Lhong Cut'),
('11.71.07.2010','Lampeuot'),
('11.71.08','Jaya Baru'),
('11.71.08.2001','Punge Blang Cut'),
('11.71.08.2002','Bitai'),
('11.71.08.2003','Lamjamee'),
('11.71.08.2004','Ulee Pata'),
('11.71.08.2005','Lampoh Daya'),
('11.71.08.2006','Emperom'),
('11.71.08.2007','Geuceu Meunara'),
('11.71.08.2008','Lamteumen Timur'),
('11.71.08.2009','Lamteumen Barat'),
('11.71.09','Ulee Kareng'),
('11.71.09.2001','Lambhuk'),
('11.71.09.2002','Lamteh'),
('11.71.09.2003','Ilie'),
('11.71.09.2004','Pango Raya'),
('11.71.09.2005','Pango Deah'),
('11.71.09.2006','Ceurih'),
('11.71.09.2007','Doy'),
('11.71.09.2008','Lamglumpang'),
('11.71.09.2009','Ie Masen Ulee Kareng'),
('11.72','Kota Sabang'),
('11.72.01','Sukakarya'),
('11.72.01.2004','Krueng Raya'),
('11.72.01.2005','Aneuk Laot'),
('11.72.01.2006','Kuta Timu'),
('11.72.01.2007','Kuta Barat'),
('11.72.01.2008','Kuta Ateuh'),
('11.72.02','Sukajaya'),
('11.72.02.2004','Jaboi'),
('11.72.02.2005','Balohan'),
('11.72.02.2006','Cot Abeuk'),
('11.72.02.2007','Cot Ba U'),
('11.72.02.2008','Ie Meulee'),
('11.72.02.2009','Ujoeng Kareung'),
('11.72.02.2010','Anoe Itam'),
('11.72.03','Sukamakmue'),
('11.72.03.2001','Iboih'),
('11.72.03.2002','Batee Shok'),
('11.72.03.2003','Paya Seunara'),
('11.72.03.2004','Paya'),
('11.72.03.2005','Keunekai'),
('11.72.03.2006','Beurawang'),
('11.73','Kota Lhokseumawe'),
('11.73.01','Muara Dua'),
('11.73.01.2002','Alue Awe'),
('11.73.01.2003','Blang Crum'),
('11.73.01.2004','Cut Mamplam'),
('11.73.01.2005','Meunasah Mee'),
('11.73.01.2006','Cot Girek Kandang'),
('11.73.01.2007','Keude Cunda'),
('11.73.01.2008','Uteunkot'),
('11.73.01.2009','Lhok Mon Puteh'),
('11.73.01.2010','Meunasah Mesjid'),
('11.73.01.2011','Mns. Panggoi'),
('11.73.01.2013','Paya Bili'),
('11.73.01.2014','Meunasah Alue'),
('11.73.01.2015','Paya Punteuet'),
('11.73.01.2016','Blang Poroh'),
('11.73.01.2024','Meunasah Manyang'),
('11.73.01.2025','Meunasah Blang'),
('11.73.01.2026','Paloh Batee'),
('11.73.02','Banda Sakti'),
('11.73.02.2001','Kuta Blang'),
('11.73.02.2002','Tumpok Teungoh'),
('11.73.02.2003','Simpang Empat'),
('11.73.02.2004','Kampung Jawa Lhokseumawe'),
('11.73.02.2005','Kota Lhokseumawe'),
('11.73.02.2006','Mon Geudong'),
('11.73.02.2007','Keude Aceh'),
('11.73.02.2008','Pusong Lhokseumawe'),
('11.73.02.2009','Hagu Teungoh'),
('11.73.02.2010','Uteun Bayi'),
('11.73.02.2011','Ujong Blang'),
('11.73.02.2012','Hagu Selatan'),
('11.73.02.2013','Pusong Baru'),
('11.73.02.2014','Ulee Jalan'),
('11.73.02.2015','Banda Masen'),
('11.73.02.2016','Lancang Garam'),
('11.73.02.2017','Jawa Baroe'),
('11.73.02.2018','Hagu Barat Laut'),
('11.73.03','Blang Mangat'),
('11.73.03.2001','Kuala'),
('11.73.03.2002','Blang Cut'),
('11.73.03.2003','Jambo Mesjid'),
('11.73.03.2004','Jambo Timu'),
('11.73.03.2005','Tunong'),
('11.73.03.2006','Blang Teue'),
('11.73.03.2007','Teungoh'),
('11.73.03.2008','Baloi'),
('11.73.03.2009','Mane Kareung'),
('11.73.03.2010','Asan Kareung'),
('11.73.03.2011','Rayeuk Kareung'),
('11.73.03.2012','Blang Punteuet'),
('11.73.03.2013','Kumbang Punteuet'),
('11.73.03.2014','Mesjid Punteuet'),
('11.73.03.2015','Ulee Blang Mane'),
('11.73.03.2016','Keude Punteuet'),
('11.73.03.2017','Alue Lim'),
('11.73.03.2018','Blang Buloh'),
('11.73.03.2019','Blang Weu Panjoe'),
('11.73.03.2020','Jeulikat'),
('11.73.03.2021','Blang Weu Baroh'),
('11.73.03.2022','Seuneubok'),
('11.73.04','Muara Satu'),
('11.73.04.2001','Batuphat Barat'),
('11.73.04.2002','Blang Panyang'),
('11.73.04.2003','Meunasah Dayah'),
('11.73.04.2004','Paloh Punti'),
('11.73.04.2005','Blang Pulo'),
('11.73.04.2006','Batuphat Timur'),
('11.73.04.2007','Blang Naleung Mameh'),
('11.73.04.2008','Cot Trieng'),
('11.73.04.2009','Padang Sakti'),
('11.73.04.2010','Meuria Paloh'),
('11.73.04.2011','Ujong Pacu'),
('11.74','Kota Langsa'),
('11.74.01','Langsa Timur'),
('11.74.01.2007','Buket Medang Ara'),
('11.74.01.2009','Matang Seutui'),
('11.74.01.2010','Buket Pulo'),
('11.74.01.2011','Matang Panyang'),
('11.74.01.2012','Simpang Wie'),
('11.74.01.2013','Buket Rata'),
('11.74.01.2014','Buket Meutuah'),
('11.74.01.2015','Alue Merbau'),
('11.74.01.2016','Matang Cengai'),
('11.74.01.2017','Seunubok Antara'),
('11.74.01.2018','Alue Pineung'),
('11.74.01.2019','Sukarejo'),
('11.74.01.2020','Cinta Raja'),
('11.74.01.2021','Sungai Lueng'),
('11.74.01.2025','Alue Pineung Timue'),
('11.74.01.2026','Kapa'),
('11.74.02','Langsa Barat'),
('11.74.02.2005','Lhok Banie'),
('11.74.02.2006','PB. Teungoh'),
('11.74.02.2007','PB. Beuramo'),
('11.74.02.2008','Simpang Lhee'),
('11.74.02.2009','Seuriget'),
('11.74.02.2015','Matang Seulimeng'),
('11.74.02.2016','Sungai Pauh'),
('11.74.02.2017','Kuala Langsa'),
('11.74.02.2018','Teulaga Tujuh'),
('11.74.02.2019','Serambi Indah'),
('11.74.02.2020','Sungai Pauh Pusaka'),
('11.74.02.2021','Sungai Pauh Tanjong'),
('11.74.02.2022','Sungai Pauh Firdaus'),
('11.74.03','Langsa Kota'),
('11.74.03.2001','Teungoh'),
('11.74.03.2002','Peukan Langsa'),
('11.74.03.2004','Jawa'),
('11.74.03.2005','Paya Bujok Blang Pase'),
('11.74.03.2006','Blang'),
('11.74.03.2007','Alue Beurawe'),
('11.74.03.2009','Daulat'),
('11.74.03.2010','Meutia'),
('11.74.03.2011','Blang Seunibong'),
('11.74.03.2013','Tualang Teungoh'),
('11.74.04','Langsa Lama'),
('11.74.04.2001','Pondok Kemuning'),
('11.74.04.2002','Seulalah'),
('11.74.04.2003','Pondok Pabrik'),
('11.74.04.2004','Sidodadi'),
('11.74.04.2005','Sidorejo'),
('11.74.04.2006','Baro'),
('11.74.04.2007','Meurandeh'),
('11.74.04.2008','Asam Peutik'),
('11.74.04.2009','Baroh Langsa Lama'),
('11.74.04.2010','Seulalah Baru'),
('11.74.04.2011','Sukajadi Kebun Ireng'),
('11.74.04.2012','Meurandeh Tengah'),
('11.74.04.2013','Meurandeh Dayah'),
('11.74.04.2014','Meurandeh Aceh'),
('11.74.04.2015','Batee Puteh'),
('11.74.05','Langsa Baro'),
('11.74.05.2001','Timbang Langsa'),
('11.74.05.2002','Alue Dua'),
('11.74.05.2003','Birem Puntong'),
('11.74.05.2004','Paya Bujok Seuleumak'),
('11.74.05.2005','Pondok Kelapa'),
('11.74.05.2006','Karang Anyar'),
('11.74.05.2007','Paya Bujok Tunong'),
('11.74.05.2008','Geudubang Jawa'),
('11.74.05.2009','Geudubang Aceh'),
('11.74.05.2010','Alue Dua Bakaran Batee'),
('11.74.05.2011','Lengkong'),
('11.74.05.2012','Sukajadi Makmur'),
('11.75','Kota Subulussalam'),
('11.75.01','Simpang Kiri'),
('11.75.01.2001','Subulussalam'),
('11.75.01.2002','Pegayo'),
('11.75.01.2003','Sikalondang'),
('11.75.01.2004','Buluh Dori'),
('11.75.01.2005','Subulussalam Utara'),
('11.75.01.2006','Subulussalam Selatan'),
('11.75.01.2007','Subulussalam Barat'),
('11.75.01.2008','Suka Makmur'),
('11.75.01.2009','Tangga Besi'),
('11.75.01.2010','Kuta Cepu'),
('11.75.01.2011','Pasar Panjang'),
('11.75.01.2012','Mukti Makmur'),
('11.75.01.2013','Lae Oram'),
('11.75.01.2014','Makmur Jaya'),
('11.75.01.2015','Belegen Mulia'),
('11.75.01.2016','Danau Tras'),
('11.75.01.2017','Subulussalam Timur'),
('11.75.02','Penanggalan'),
('11.75.02.2001','Penanggalan'),
('11.75.02.2002','Cepu'),
('11.75.02.2003','Kuta Tengah'),
('11.75.02.2004','Kampung Baru'),
('11.75.02.2005','Sikelang'),
('11.75.02.2006','Penuntungan'),
('11.75.02.2007','Jontor'),
('11.75.02.2008','Lae Motong'),
('11.75.02.2009','Lae Ikan'),
('11.75.02.2010','Lae Bersih'),
('11.75.02.2011','Dasan Raja'),
('11.75.02.2012','Penanggalan Timur'),
('11.75.02.2013','Penanggalan Barat'),
('11.75.03','Rundeng'),
('11.75.03.2001','Pasar Rundeng'),
('11.75.03.2002','Dah'),
('11.75.03.2003','Oboh'),
('11.75.03.2004','Sepadan'),
('11.75.03.2005','Sibuasan'),
('11.75.03.2006','Binanga'),
('11.75.03.2007','Kuta Beringin'),
('11.75.03.2008','Muara Batu-batu'),
('11.75.03.2009','Siperkas'),
('11.75.03.2010','Lae Mate'),
('11.75.03.2011','Sibungke'),
('11.75.03.2012','Harapan Baru'),
('11.75.03.2013','Teladan Baru'),
('11.75.03.2014','Bulukur Makmur'),
('11.75.03.2015','Badar'),
('11.75.03.2016','Lae Pemulaan'),
('11.75.03.2017','Panglima Saman'),
('11.75.03.2018','Suak Jampak'),
('11.75.03.2019','Geruguh'),
('11.75.03.2020','Mandilam'),
('11.75.03.2021','Tualang'),
('11.75.03.2022','Kuala Kepeng'),
('11.75.03.2023','Tanah Tumbuh'),
('11.75.04','Sultan Daulat'),
('11.75.04.2001','Pasir Belo'),
('11.75.04.2002','Bawan'),
('11.75.04.2003','Sigrun'),
('11.75.04.2004','Jabi-jabi'),
('11.75.04.2005','Lae Simolap'),
('11.75.04.2006','Lae Langge'),
('11.75.04.2007','Suka Maju'),
('11.75.04.2008','Gunung Bakti'),
('11.75.04.2009','Jambi Baru'),
('11.75.04.2010','Pulo Kedep'),
('11.75.04.2011','Pulo Belen'),
('11.75.04.2012','Singgersing'),
('11.75.04.2013','Namo Buaya'),
('11.75.04.2014','Cipare Pare'),
('11.75.04.2015','Bunga Tanjung'),
('11.75.04.2016','Cipar-Pari Timur'),
('11.75.04.2018','Darul Makmur'),
('11.75.04.2019','Jabi-Jabi Barat'),
('11.75.04.2020','Batu Napal'),
('11.75.05','Longkib'),
('11.75.05.2001','Longkib'),
('11.75.05.2002','Sepang'),
('11.75.05.2003','Panji'),
('11.75.05.2004','Lae Saga'),
('11.75.05.2005','Sikerabang'),
('11.75.05.2006','Rantau Panjang'),
('11.75.05.2007','Bukit Alim'),
('11.75.05.2008','Darul Aman'),
('11.75.05.2009','Bangun Sari'),
('11.75.05.2010','Darussalam');

-- Provinsi SUMATERA UTARA
INSERT INTO wilayah (kode, nama)
VALUES
('12','Sumatera Utara'),
('12.01','Kabupaten Tapanuli Tengah'),
('12.01.01','Barus'),
('12.01.01.1001','Pasar Batu Gerigis'),
('12.01.01.1002','Padang Masiang'),
('12.01.01.2003','Kampung Solok'),
('12.01.01.2004','Pasar Terandam'),
('12.01.01.2005','Sigambo Gambo'),
('12.01.01.2006','Ujung Batu'),
('12.01.01.2007','Kinali'),
('12.01.01.2008','Kampung Mudik'),
('12.01.01.2009','Aek Dakka'),
('12.01.01.2010','Patupangan'),
('12.01.01.2011','Gabungan Hasang'),
('12.01.01.2017','Bungo Tanjung'),
('12.01.01.2018','Kedai Gedang'),
('12.01.02','Sorkam'),
('12.01.02.1001','Sorkam'),
('12.01.02.1002','Pargarutan'),
('12.01.02.1004','Tarutung Bolak'),
('12.01.02.1009','Naipospos Barat'),
('12.01.02.2003','Teluk Roban'),
('12.01.02.2005','Fajar'),
('12.01.02.2006','Pardamean'),
('12.01.02.2007','Pelita'),
('12.01.02.2008','Rianiate'),
('12.01.02.2010','Gonting Mahe'),
('12.01.02.2011','Dolok Pantis'),
('12.01.02.2014','Pea Raja'),
('12.01.02.2015','Bottot'),
('12.01.02.2016','Sorkam Tengah'),
('12.01.02.2017','Sorkam Kiri'),
('12.01.02.2018','Pananggahan'),
('12.01.02.2019','Pagaran Julu'),
('12.01.02.2020','Hite Urat'),
('12.01.02.2021','Sihapas'),
('12.01.02.2022','Nauli'),
('12.01.02.2023','Muara Nauli'),
('12.01.03','Pandan'),
('12.01.03.1001','Pandan'),
('12.01.03.1002','Hajoran'),
('12.01.03.1003','Aek Tolang'),
('12.01.03.1004','Lubuk Tukko'),
('12.01.03.1005','Sibuluan Indah'),
('12.01.03.1006','Sibuluan Nauli'),
('12.01.03.1011','Aek Sitio-tio'),
('12.01.03.1012','Sibuluan Raya'),
('12.01.03.1013','Kalangan'),
('12.01.03.1016','Pandan Wangi'),
('12.01.03.1017','Lubuk Tukko Baru'),
('12.01.03.1018','Sibuluan Baru'),
('12.01.03.1019','Sibuluan Terpadu'),
('12.01.03.1020','Sihaporas Nauli'),
('12.01.03.1021','Pasar Baru'),
('12.01.03.1022','Budi Luhur'),
('12.01.03.1023','Kalangan Indah'),
('12.01.03.1024','Mangga Dua'),
('12.01.03.1025','Muara Nibung'),
('12.01.03.1026','Hajoran Indah'),
('12.01.03.2014','Aek Garut'),
('12.01.03.2015','Sitio-Tio Hilir'),
('12.01.04','Pinangsori'),
('12.01.04.1001','Pinangsori'),
('12.01.04.1004','Sitonong Bangun'),
('12.01.04.1007','Pinangbaru'),
('12.01.04.1009','Albion Prancis'),
('12.01.04.1010','Sori Nauli'),
('12.01.04.2002','Gunung Marijo'),
('12.01.04.2003','Sihaporas'),
('12.01.04.2005','Toga Basir'),
('12.01.04.2006','Parjalihotan Baru'),
('12.01.04.2008','Danau Pandan'),
('12.01.05','Manduamas'),
('12.01.05.1001','P.O. Manduamas'),
('12.01.05.1003','Binjohara'),
('12.01.05.1020','Perluasan'),
('12.01.05.2002','Saragih'),
('12.01.05.2004','Pagaran Nauli'),
('12.01.05.2005','Sarma Nauli'),
('12.01.05.2006','Manduamas Lama'),
('12.01.05.2007','Tumba'),
('12.01.05.2008','Tumba Jae'),
('12.01.05.2009','Lae Monong'),
('12.01.05.2010','Saragih Barat'),
('12.01.05.2011','Saragih Timur'),
('12.01.05.2012','Binjohara Uruk'),
('12.01.05.2013','Binjohara Baru'),
('12.01.05.2014','Tumba Nauli'),
('12.01.05.2015','Manduamas Baru'),
('12.01.05.2016','Muara Tapus'),
('12.01.05.2017','Pagaran Baru'),
('12.01.05.2018','Parsihotangan'),
('12.01.05.2019','Tambahan Nanjur'),
('12.01.06','Kolang'),
('12.01.06.1006','P.O. Hurlang'),
('12.01.06.1007','Kolang Nauli'),
('12.01.06.2001','Unte Mungkur IV'),
('12.01.06.2002','Unte Mungkur III'),
('12.01.06.2003','Unte Mungkur II'),
('12.01.06.2004','Unte Mungkur I'),
('12.01.06.2005','Satahi Nauli'),
('12.01.06.2008','Hurlang Muara Nauli'),
('12.01.06.2009','Sipakpahi Aek Lobu'),
('12.01.06.2010','Hodopa Nauli'),
('12.01.06.2011','Makarti Nauli'),
('12.01.06.2012','Rawa Makmur'),
('12.01.06.2013','Simarpinggang'),
('12.01.06.2014','Pargaringan'),
('12.01.07','Tapian Nauli'),
('12.01.07.1001','Tapian Nauli II'),
('12.01.07.2002','Tapian Nauli I'),
('12.01.07.2003','Tapian Nauli III'),
('12.01.07.2004','Tapian Nauli IV'),
('12.01.07.2005','Aloban Bair'),
('12.01.07.2006','Mela Dolok'),
('12.01.07.2007','Mela I'),
('12.01.07.2008','Mela II'),
('12.01.07.2009','Bair'),
('12.01.08','Sibabangun'),
('12.01.08.1002','Sibabangun'),
('12.01.08.2005','Mombang Boru'),
('12.01.08.2006','Anggoli'),
('12.01.08.2007','Muara Sibuntuon'),
('12.01.08.2008','Sibio bio'),
('12.01.08.2010','Simanosor'),
('12.01.08.2011','Hutagur-gur'),
('12.01.09','Sosorgadong'),
('12.01.09.1001','Sosor Gadong'),
('12.01.09.2002','Unte Boang'),
('12.01.09.2003','Sibintang'),
('12.01.09.2004','Barambang'),
('12.01.09.2005','Siantar Ca'),
('12.01.09.2006','Muara Bolak'),
('12.01.09.2007','Huta Tombak'),
('12.01.09.2008','Siantar Dolok'),
('12.01.09.2009','Baringin'),
('12.01.10','Sorkam Barat'),
('12.01.10.1001','Sorkam Kanan'),
('12.01.10.1019','Binasi'),
('12.01.10.2002','Sipea Pea'),
('12.01.10.2003','Pahieme I'),
('12.01.10.2004','Pasar Sorkam'),
('12.01.10.2005','Aek Raso'),
('12.01.10.2006','Pasaribu Tobing Jae'),
('12.01.10.2014','Maduma'),
('12.01.10.2016','Sidikalang'),
('12.01.10.2017','Pahieme II'),
('12.01.10.2018','Sorkam Kanan'),
('12.01.10.2020','Madani'),
('12.01.11','Sirandorung'),
('12.01.11.1001','Bajamas'),
('12.01.11.2002','Sampang Maruhur'),
('12.01.11.2003','Siordang'),
('12.01.11.2004','Pardomuan'),
('12.01.11.2005','Simpang III Lae Bingke'),
('12.01.11.2006','Sigodung'),
('12.01.11.2007','Masnauli'),
('12.01.11.2008','Muara Ode'),
('12.01.12','Andam Dewi'),
('12.01.12.1007','Rina Bolak'),
('12.01.12.2001','Sijungkang'),
('12.01.12.2002','Pangaribuan'),
('12.01.12.2003','Sogar'),
('12.01.12.2004','Sirami Ramian'),
('12.01.12.2005','Sigolang'),
('12.01.12.2006','Sosor Gonting'),
('12.01.12.2008','Bondar Sihudon I'),
('12.01.12.2009','Uratan'),
('12.01.12.2010','Ladang Tengah'),
('12.01.12.2011','Lobu Tua'),
('12.01.12.2012','Bondar Sihudon II'),
('12.01.12.2013','Sitiris-Tiris'),
('12.01.12.2014','Sawah Lamo'),
('12.01.13','Sitahuis'),
('12.01.13.1003','Nauli'),
('12.01.13.2001','Bonandolok'),
('12.01.13.2002','Rampa'),
('12.01.13.2004','Mardame'),
('12.01.13.2005','Naga Timbul'),
('12.01.13.2006','Simaninggir'),
('12.01.14','Tukka'),
('12.01.14.1001','Tukka'),
('12.01.14.1002','Bona Lumban'),
('12.01.14.1003','Huta Nabolon'),
('12.01.14.1007','Sipange'),
('12.01.14.1009','Aek Tolang Induk'),
('12.01.14.2004','Sigiring Giring'),
('12.01.14.2005','Tapian Nauli/ Saurmanggita'),
('12.01.14.2006','Sait Kalangan II'),
('12.01.14.2008','Aek Bottar'),
('12.01.15','Badiri'),
('12.01.15.1001','Hutabalang'),
('12.01.15.1002','Lopian'),
('12.01.15.2003','Jago Jago'),
('12.01.15.2004','Aek Horsik'),
('12.01.15.2005','Gunung Kelambu'),
('12.01.15.2006','Kebun Pisang'),
('12.01.15.2007','Lubuk Ampolu'),
('12.01.15.2008','Pagaran Honas'),
('12.01.15.2009','Sitardas'),
('12.01.16','Pasaribu Tobing'),
('12.01.16.2001','Suga Suga Hutagodang'),
('12.01.16.2002','Suka Maju'),
('12.01.16.2003','Makmur'),
('12.01.16.2004','Pasaribu Tobing'),
('12.01.16.2005','Aek Nadua'),
('12.01.16.2006','Simargarap'),
('12.01.16.2007','Sidaling'),
('12.01.16.2008','Sipakpahi'),
('12.01.16.2009','PO Simargarap'),
('12.01.17','Barus Utara'),
('12.01.17.2001','Hutaginjang'),
('12.01.17.2002','Sihorbo'),
('12.01.17.2003','Parik Sinomba'),
('12.01.17.2004','Purba Tua'),
('12.01.17.2005','Pananggahan'),
('12.01.17.2006','Siharbangan'),
('12.01.18','Suka Bangun'),
('12.01.18.2001','Pulo Pakkat'),
('12.01.18.2002','Tebing Tinggi'),
('12.01.18.2003','Pulo Pakkat II'),
('12.01.18.2004','Janji Maria'),
('12.01.18.2005','Sihadatuon'),
('12.01.18.2006','Sihapas'),
('12.01.19','Lumut'),
('12.01.19.1001','Lumut'),
('12.01.19.2002','Aek Gambir'),
('12.01.19.2003','Masundung'),
('12.01.19.2005','Lumut Nauli'),
('12.01.19.2006','Lumut Maju'),
('12.01.19.2007','Sialogo'),
('12.01.20','Sarudik'),
('12.01.20.1001','Sibuluan Nalambok'),
('12.01.20.1002','Sarudik'),
('12.01.20.1004','Pasir Bidang'),
('12.01.20.1005','Pondok Batu'),
('12.01.20.2003','Sipan'),
('12.02','Kabupaten Tapanuli Utara'),
('12.02.01','Tarutung'),
('12.02.01.1001','Partoli Toruan'),
('12.02.01.1002','Hutatoruan V'),
('12.02.01.1003','Hutatoruan VI'),
('12.02.01.1004','Hutatoruan VII'),
('12.02.01.1005','Hutatoruan IX'),
('12.02.01.1006','Hutatoruan X'),
('12.02.01.1007','Hutatoruan XI'),
('12.02.01.2008','Parbubu I'),
('12.02.01.2009','Parbubu II'),
('12.02.01.2010','Hutapea Banuarea'),
('12.02.01.2011','Siandor-andor'),
('12.02.01.2012','Hutauruk'),
('12.02.01.2013','Hapoltahan'),
('12.02.01.2014','Parbubu Dolok'),
('12.02.01.2015','Aek Siansimun'),
('12.02.01.2016','Htgalung Siwaluompo'),
('12.02.01.2017','Parbubu Pea'),
('12.02.01.2018','Hutatoruan IV'),
('12.02.01.2019','Sosunggulon'),
('12.02.01.2020','Hutatoruan VIII'),
('12.02.01.2021','Simamora'),
('12.02.01.2022','Parbaju Toruan'),
('12.02.01.2023','Parbaju Julu'),
('12.02.01.2024','Parbaju Tonga'),
('12.02.01.2025','Sitampurung'),
('12.02.01.2026','Siraja Oloan'),
('12.02.01.2027','Jambur Nauli'),
('12.02.01.2028','Sihujur'),
('12.02.01.2029','Partali Julu'),
('12.02.01.2030','Hutatoruan I'),
('12.02.01.2031','Hutatoruan III'),
('12.02.02','Siatas Barita'),
('12.02.02.2001','Siraja Hutagalung'),
('12.02.02.2002','Pansur Napitu'),
('12.02.02.2003','Simanampang'),
('12.02.02.2004','Sidagal'),
('12.02.02.2005','Simarakir Julu'),
('12.02.02.2006','Enda Portibi'),
('12.02.02.2007','Simorangkir Habinsaran'),
('12.02.02.2008','Sangkaran'),
('12.02.02.2009','Lumban Siagian Jae'),
('12.02.02.2010','Lumban Siagian Julu'),
('12.02.02.2011','Sitompul'),
('12.02.02.2012','Lobu Hole'),
('12.02.03','Adiankoting'),
('12.02.03.2001','Dolok Nauli'),
('12.02.03.2002','Pansurbatu'),
('12.02.03.2003','Pardomuan Nauli'),
('12.02.03.2004','Siantar Naipospos'),
('12.02.03.2005','Sibalanga'),
('12.02.03.2006','Pagaran Lambung III'),
('12.02.03.2007','Pagaran Lambung IV'),
('12.02.03.2008','Adian Koting'),
('12.02.03.2009','Pangaran Pisang'),
('12.02.03.2010','Banuaji IV'),
('12.02.03.2011','Banuaji I'),
('12.02.03.2012','Banuaji II'),
('12.02.03.2013','Pangaran Lambung I'),
('12.02.03.2014','Pangaran Lambung II'),
('12.02.03.2015','Pansurbatu I'),
('12.02.03.2016','Pansurbatu II'),
('12.02.04','Sipoholon'),
('12.02.04.1001','Situmeang Habinsaran'),
('12.02.04.2002','Hutauruk'),
('12.02.04.2003','Simanungkalit'),
('12.02.04.2004','Situmeang Hasundutan'),
('12.02.04.2005','Sipahutar'),
('12.02.04.2007','Tapian Nauli'),
('12.02.04.2008','Huta Raja'),
('12.02.04.2009','Lobu Singkam'),
('12.02.04.2010','Rura Julu Dolok'),
('12.02.04.2011','Rura Julu Toruan'),
('12.02.04.2012','Hutaraja Hasundutan'),
('12.02.04.2013','Pagarbatu'),
('12.02.04.2014','Hutaraja Simanungkalit'),
('12.02.04.2015','Hutauruk Hasundutan'),
('12.02.05','Pahae Julu'),
('12.02.05.1001','Onan Hasang'),
('12.02.05.2002','Simasom'),
('12.02.05.2003','Janji Natogu'),
('12.02.05.2004','Pagur Dotan'),
('12.02.05.2005','Sibaganding'),
('12.02.05.2006','Lumban Garaga'),
('12.02.05.2007','Sitolu Ama'),
('12.02.05.2008','Lumban Tonga'),
('12.02.05.2009','Lumban Dolok'),
('12.02.05.2010','Simataniari'),
('12.02.05.2011','Lumban Jaean'),
('12.02.05.2012','Huta Barat'),
('12.02.05.2013','Lontung Dolok'),
('12.02.05.2014','Simanampang'),
('12.02.05.2015','Lobu Pining'),
('12.02.05.2016','Pantis'),
('12.02.05.2017','Lumban Gaol'),
('12.02.05.2018','Simardangiang'),
('12.02.05.2019','Simasom Toruan'),
('12.02.06','Pahae Jae'),
('12.02.06.1001','Sarulla'),
('12.02.06.2002','Tordolok Nauli'),
('12.02.06.2003','Sigurung-gurung'),
('12.02.06.2004','Silangkitang'),
('12.02.06.2005','Sitoluompu'),
('12.02.06.2006','Siopat Bahal'),
('12.02.06.2007','Pardomuan Nainggolan'),
('12.02.06.2008','Nahornop Marsada'),
('12.02.06.2009','Parsaoran Samosir'),
('12.02.06.2010','Suka Maju'),
('12.02.06.2011','Setia'),
('12.02.06.2012','Parsaoran Nainggolan'),
('12.02.06.2013','Pardamean Nainggolan'),
('12.02.07','Simangumban'),
('12.02.07.2001','Silosung'),
('12.02.07.2002','Dolok Sanggul'),
('12.02.07.2003','Simangumban Jae'),
('12.02.07.2004','Aek Nabara'),
('12.02.07.2005','Dolok Saut'),
('12.02.07.2006','Simangumban Julu'),
('12.02.07.2007','Lobu Sihim'),
('12.02.07.2008','Pardomuan'),
('12.02.08','Purbatua'),
('12.02.08.2001','Sidua Bahal'),
('12.02.08.2002','Sibulan Bulan'),
('12.02.08.2003','Bonani Dolok'),
('12.02.08.2004','Pardomuan J.Angkola'),
('12.02.08.2005','Hutanagodang'),
('12.02.08.2006','Robean'),
('12.02.08.2007','Janji Nauli'),
('12.02.08.2008','Selamat'),
('12.02.08.2009','Purba Tua'),
('12.02.08.2010','Sitolu Bahal'),
('12.02.08.2011','Parsaoran J. Angkola'),
('12.02.09','Siborongborong'),
('12.02.09.1001','Psr Siborong Borong'),
('12.02.09.2002','Siborong Borong I'),
('12.02.09.2003','Siborong Borong II'),
('12.02.09.2004','Sitampurung'),
('12.02.09.2005','Sitabotabo'),
('12.02.09.2006','Bahal Batu I'),
('12.02.09.2007','Bahal Batu II'),
('12.02.09.2008','Bahal Batu III'),
('12.02.09.2009','Lobu Siregar I'),
('12.02.09.2010','Lobu Siregar II'),
('12.02.09.2011','Pohan Julu'),
('12.02.09.2012','Pohan Tonga'),
('12.02.09.2013','Pohan Jae'),
('12.02.09.2014','Paniaran'),
('12.02.09.2015','Parik Sabungan'),
('12.02.09.2016','Hutabulu'),
('12.02.09.2017','Lumban Tonga Tonga'),
('12.02.09.2018','Sigumbang'),
('12.02.09.2019','Siaro'),
('12.02.09.2020','Silait-Lait'),
('12.02.09.2021','Sitabotabo Toruan'),
('12.02.10','Pagaran'),
('12.02.10.2001','Simamora Hasibuan'),
('12.02.10.2002','Lumban Julu'),
('12.02.10.2003','Pagaran'),
('12.02.10.2004','Sibaragas'),
('12.02.10.2005','Sipultak'),
('12.02.10.2006','Lubis'),
('12.02.10.2007','Banualuhu'),
('12.02.10.2008','Parhorboan'),
('12.02.10.2009','Lumban Motung'),
('12.02.10.2010','Lumban Ina Ina'),
('12.02.10.2011','Doloksaribu'),
('12.02.10.2012','Lumban Silintong'),
('12.02.10.2013','Sipultak Dolok'),
('12.02.10.2014','Hasibuan'),
('12.02.11','Parmonangan'),
('12.02.11.2001','Manalu'),
('12.02.11.2002','Manalu Purba'),
('12.02.11.2003','Manalu Dolok'),
('12.02.11.2004','Hutajulu'),
('12.02.11.2005','Aek Raja'),
('12.02.11.2006','Hutatinggi'),
('12.02.11.2007','Lobusunut'),
('12.02.11.2008','Sisordak'),
('12.02.11.2009','Pertengahan'),
('12.02.11.2010','Hutatua'),
('12.02.11.2011','Hutajulu Parbalik'),
('12.02.11.2012','Horisan Ranggitgit'),
('12.02.11.2013','Purba Dolok'),
('12.02.11.2014','Batuarimo'),
('12.02.12','Sipahutar'),
('12.02.12.2001','Sabungannihuta IV'),
('12.02.12.2002','Sabungannihuta I'),
('12.02.12.2003','Sipahutar I'),
('12.02.12.2004','Sipahutar II'),
('12.02.12.2005','Sipahutar III'),
('12.02.12.2006','Onan Runggu I'),
('12.02.12.2007','Tapian Nauli III'),
('12.02.12.2008','Onan Runggu III'),
('12.02.12.2009','Siabal-abal III'),
('12.02.12.2010','Siabal-abal I'),
('12.02.12.2011','Aek Nauli II'),
('12.02.12.2012','Tapian Nauli II'),
('12.02.12.2013','Sabungannihuta III'),
('12.02.12.2014','Onan Runggu IV'),
('12.02.12.2015','Siabal-abal II'),
('12.02.12.2016','Aek Nauli I'),
('12.02.12.2017','Aek Nauli III'),
('12.02.12.2018','Onan Runggu II'),
('12.02.12.2019','Tapian Nauli I'),
('12.02.12.2020','Sabungannihuta II'),
('12.02.12.2021','Sabungannihuta V'),
('12.02.12.2022','Siabal-abal IV'),
('12.02.12.2023','Aek Nauli IV'),
('12.02.12.2024','Siabal-abal V'),
('12.02.12.2025','Siabal-abal VI'),
('12.02.13','Pangaribuan'),
('12.02.13.2001','Pakpahan'),
('12.02.13.2002','Sampagul'),
('12.02.13.2003','Godung Borotan'),
('12.02.13.2004','Parratusan'),
('12.02.13.2005','Lumban Siregar'),
('12.02.13.2006','Sigotom Julu'),
('12.02.13.2007','Rahut Bosi'),
('12.02.13.2008','Batu Nadua'),
('12.02.13.2009','Silantom Tonga'),
('12.02.13.2010','Silantom Julu'),
('12.02.13.2011','Pansurnatolu'),
('12.02.13.2012','Parlombuan'),
('12.02.13.2013','Purbatua'),
('12.02.13.2014','Lumban Sinaga Simatupang'),
('12.02.13.2015','Batumanumpak'),
('12.02.13.2016','Sibingke'),
('12.02.13.2017','Najumambe'),
('12.02.13.2018','Parsibarungan'),
('12.02.13.2019','Harianja'),
('12.02.13.2020','Silantom Jae'),
('12.02.13.2021','Padang Parsadaan'),
('12.02.13.2022','Parsorminan I'),
('12.02.13.2023','Hutaraja'),
('12.02.13.2024','Rahut Bosi Onan'),
('12.02.13.2025','Sigotom Timur'),
('12.02.13.2026','Sigotom Dolok Nauli'),
('12.02.14','Garoga'),
('12.02.14.2001','Garoga Sibargot'),
('12.02.14.2002','Lontung Jae I'),
('12.02.14.2003','Parsosoran'),
('12.02.14.2004','Padang Siandomang'),
('12.02.14.2005','Sibaganding'),
('12.02.14.2006','Sirmpang Bolon'),
('12.02.14.2007','Gonting Garoga'),
('12.02.14.2008','Lontung Jae II'),
('12.02.14.2009','Gonting Salak'),
('12.02.14.2010','Sibalanga'),
('12.02.14.2011','Aek Tangga'),
('12.02.14.2012','Parinsoran'),
('12.02.14.2013','Parmanuhan'),
('12.02.15','Muara'),
('12.02.15.2001','Hutanagodang'),
('12.02.15.2002','Unte Mungkur'),
('12.02.15.2003','Hutalontung'),
('12.02.15.2004','Hutaginjang'),
('12.02.15.2005','Dolok Matumbur'),
('12.02.15.2006','Mariba Ni Aek'),
('12.02.15.2007','Sampuran'),
('12.02.15.2008','Silando'),
('12.02.15.2009','Sibandang'),
('12.02.15.2010','Simatupang'),
('12.02.15.2011','Silali Toruan'),
('12.02.15.2012','Batubinumbun'),
('12.02.15.2013','Sitanggor'),
('12.02.15.2014','Papande'),
('12.02.15.2015','Aritonang'),
('12.03','Kabupaten Tapanuli Selatan'),
('12.03.01','Angkola Barat'),
('12.03.01.1001','Sitinjak'),
('12.03.01.1003','Simatorkis Sisoma'),
('12.03.01.2002','Panobasan'),
('12.03.01.2004','Siuhom'),
('12.03.01.2005','Sigumuru'),
('12.03.01.2006','Sibangkua'),
('12.03.01.2007','Sisundung'),
('12.03.01.2008','Aek Nabara'),
('12.03.01.2011','Parsalakan'),
('12.03.01.2015','Sitaratoit'),
('12.03.01.2016','Sialogo'),
('12.03.01.2024','Lembah Lubuk Raya'),
('12.03.01.2031','Lobu Layan Sigordang'),
('12.03.01.2035','Panobasan Lombang'),
('12.03.02','Batang Toru'),
('12.03.02.1001','Wek I'),
('12.03.02.1002','Wek II'),
('12.03.02.1011','Perkebunan Batang Toru'),
('12.03.02.1030','Padang Lancat'),
('12.03.02.1032','Aek Pining'),
('12.03.02.2003','Garoga'),
('12.03.02.2004','Huta Godang'),
('12.03.02.2005','Batu Horing'),
('12.03.02.2008','Batu Hula'),
('12.03.02.2009','Sumuran'),
('12.03.02.2015','Napa'),
('12.03.02.2016','Wek IV'),
('12.03.02.2017','Hapesong Baru'),
('12.03.02.2018','Telo'),
('12.03.02.2019','Wek III'),
('12.03.02.2020','Perkebunan Sigala-Gala'),
('12.03.02.2021','Perkebunan Hapesong'),
('12.03.02.2022','Hapesong Lama'),
('12.03.02.2023','Sipenggeng'),
('12.03.02.2025','Sianggunan'),
('12.03.02.2026','Huta Baru'),
('12.03.02.2036','Aek Ngadol Sitinjak'),
('12.03.02.2037','Sisipa'),
('12.03.03','Angkola Timur'),
('12.03.03.1098','Pasar Pargarutan'),
('12.03.03.1099','Batang Tura Sirumambe'),
('12.03.03.2003','Panompuan Jae'),
('12.03.03.2004','Pargarutan Tonga'),
('12.03.03.2008','Huraba'),
('12.03.03.2012','Marisi'),
('12.03.03.2013','Pargarutan Julu'),
('12.03.03.2014','Huta Ginjang'),
('12.03.03.2069','Lantosan Rogas'),
('12.03.03.2079','Sijungkang'),
('12.03.03.2083','Pargarutan Jae'),
('12.03.03.2094','Panompuan'),
('12.03.03.2095','Pargarutan Dolok'),
('12.03.03.2096','Sanggapati'),
('12.03.03.2097','Pall XI'),
('12.03.04','Sipirok'),
('12.03.04.1001','Pasar Sipirok'),
('12.03.04.1003','Hutasuhut'),
('12.03.04.1004','Baringin'),
('12.03.04.1005','Bunga Bondar'),
('12.03.04.1061','Parau Sorat'),
('12.03.04.1114','Sipirok Godang'),
('12.03.04.2010','Bagas Lombang'),
('12.03.04.2017','Batu Satail'),
('12.03.04.2025','Hasang Marsada'),
('12.03.04.2034','Janji Mauli'),
('12.03.04.2048','Paran Julu'),
('12.03.04.2051','Pangaribuan'),
('12.03.04.2052','Pargarutan'),
('12.03.04.2054','Panaungan'),
('12.03.04.2059','Padang Bujur'),
('12.03.04.2060','Paran Padang'),
('12.03.04.2064','Pangurabaan'),
('12.03.04.2068','Ramba Sihasur'),
('12.03.04.2069','Tolang'),
('12.03.04.2072','Sampean'),
('12.03.04.2075','Simaninggir'),
('12.03.04.2076','Sibadoar'),
('12.03.04.2085','Sialagundi'),
('12.03.04.2096','Bulu Mario'),
('12.03.04.2097','Barnang Koling'),
('12.03.04.2101','Dolok Sordang Julu'),
('12.03.04.2102','Situmba Julu'),
('12.03.04.2103','Situmba'),
('12.03.04.2104','Kilang Papan'),
('12.03.04.2105','Sialaman'),
('12.03.04.2106','Paran Dolok Mardomu'),
('12.03.04.2107','Batang Tura Julu'),
('12.03.04.2108','Batang Tura'),
('12.03.04.2109','Dolok Sordang'),
('12.03.04.2110','Pahae Aek Sagala'),
('12.03.04.2111','Marsada'),
('12.03.04.2112','Luat Lombang'),
('12.03.04.2113','Aek Batang Paya'),
('12.03.04.2115','Saba Batang Miha'),
('12.03.04.2116','Sarogodung'),
('12.03.05','Saipar Dolok Hole'),
('12.03.05.1001','Pasar Sipagimbar'),
('12.03.05.1080','Aek Simotung'),
('12.03.05.2018','Simangambat'),
('12.03.05.2069','Sidapdap Simanosor'),
('12.03.05.2070','Saut Banua Simanosor'),
('12.03.05.2071','Damparan Haunatas'),
('12.03.05.2072','Somba Debata Purba'),
('12.03.05.2073','Padang Mandailing Garugur'),
('12.03.05.2074','Ulu Mamis Situnggaling'),
('12.03.05.2075','Parau Sorat Sitabo-tabo'),
('12.03.05.2076','Pintu Padang Mandalasena'),
('12.03.05.2077','Sunge Sigiring-giring'),
('12.03.05.2078','Silangkitang Tambiski'),
('12.03.05.2079','Batang Parsuluman'),
('12.03.06','Angkola Selatan'),
('12.03.06.1001','Simarpinggan'),
('12.03.06.1007','Napa'),
('12.03.06.1014','Tapian Nauli'),
('12.03.06.1019','Pardomuan'),
('12.03.06.2004','Situmbaga'),
('12.03.06.2005','Sinyior'),
('12.03.06.2006','Pintu Padang'),
('12.03.06.2008','Sibong-bong'),
('12.03.06.2009','Siamporik Dolok'),
('12.03.06.2010','Siamporik Lombang'),
('12.03.06.2011','Sihopur'),
('12.03.06.2012','Tandihat'),
('12.03.06.2013','Perkebunan Marpinggan'),
('12.03.06.2015','Aek Natas'),
('12.03.06.2016','Dolok Godang'),
('12.03.06.2017','Sihuik-huik'),
('12.03.06.2018','Gunung Baringin'),
('12.03.07','Batang Angkola'),
('12.03.07.1001','Sigalangan'),
('12.03.07.1060','Pintu Padang I'),
('12.03.07.1061','Pintu Padang II'),
('12.03.07.1068','Bangun Purba'),
('12.03.07.2005','Aek Nauli'),
('12.03.07.2016','Sidadi I'),
('12.03.07.2018','Janji Manaon'),
('12.03.07.2020','Sitampa Simatoras'),
('12.03.07.2021','Pasar Lama'),
('12.03.07.2027','Benteng Huraba'),
('12.03.07.2029','Padang Kahombu'),
('12.03.07.2030','Sorik'),
('12.03.07.2045','Sibulele Muara'),
('12.03.07.2047','Bargot Topong'),
('12.03.07.2053','Sigulang Losung'),
('12.03.07.2055','Hurase'),
('12.03.07.2057','Sorimadingin PP'),
('12.03.07.2058','Huta Padang'),
('12.03.07.2062','Tahalak Ujung Gading'),
('12.03.07.2063','Sidadi II'),
('12.03.07.2067','Aek Gunung'),
('12.03.14','Arse'),
('12.03.14.1039','Arse'),
('12.03.14.1040','Lancat'),
('12.03.14.2028','Sipogu'),
('12.03.14.2032','Pinagar'),
('12.03.14.2033','Pardomuan'),
('12.03.14.2034','Aek Haminjon'),
('12.03.14.2035','Nanggar Jati Huta Padang'),
('12.03.14.2036','Nanggar Jati'),
('12.03.14.2037','Natambang Roncitan'),
('12.03.14.2038','Dalihan Natolu'),
('12.03.20','Marancar'),
('12.03.20.1004','Pasar Sempurna'),
('12.03.20.2002','Huraba'),
('12.03.20.2014','Gunung Binanga'),
('12.03.20.2015','Marancar Godang'),
('12.03.20.2016','Simaninggir'),
('12.03.20.2023','Sugi'),
('12.03.20.2028','Haunatas'),
('12.03.20.2032','Aek Nabara'),
('12.03.20.2033','Gapuk Tua'),
('12.03.20.2034','Marancar Julu'),
('12.03.20.2035','Aek Sabaon'),
('12.03.20.2036','Tanjung Dolok'),
('12.03.21','Sayur Matinggi'),
('12.03.21.1063','Sayur Matinggi'),
('12.03.21.2003','Janji Mauli Baringin'),
('12.03.21.2004','Mondang'),
('12.03.21.2005','Sialang'),
('12.03.21.2006','Sipange Julu'),
('12.03.21.2007','Sipange Godang'),
('12.03.21.2008','Tolang Julu'),
('12.03.21.2009','Tolang Jae'),
('12.03.21.2012','Bange'),
('12.03.21.2013','Bulu Gading'),
('12.03.21.2018','Aek Libung'),
('12.03.21.2023','Aek Badak Jae'),
('12.03.21.2024','Aek Badak Julu'),
('12.03.21.2026','Huta Pardomuan'),
('12.03.21.2056','Sipange Siunjam'),
('12.03.21.2057','Silaiya'),
('12.03.21.2058','Somanggal Parmonangan'),
('12.03.21.2059','Lumban Huayan'),
('12.03.21.2062','Silaiya Tanjung Leuk'),
('12.03.22','Aek Bilah'),
('12.03.22.2003','Sigolang'),
('12.03.22.2005','Biru'),
('12.03.22.2008','Tapus Godang'),
('12.03.22.2017','Lobu Tayas'),
('12.03.22.2020','Silangkitang'),
('12.03.22.2033','Sihulambu'),
('12.03.22.2043','Tolang'),
('12.03.22.2044','Tapus Sipagabu'),
('12.03.22.2045','Huta baru'),
('12.03.22.2046','Aek Latong'),
('12.03.22.2047','Aek Urat'),
('12.03.22.2048','Gorahut'),
('12.03.29','Muara Batang Toru'),
('12.03.29.1002','Hutaraja'),
('12.03.29.1008','Muara Manompas'),
('12.03.29.1009','Muara Ampolu'),
('12.03.29.2001','Bandar Hapinis'),
('12.03.29.2003','Pardamean'),
('12.03.29.2004','Tarapung Raya'),
('12.03.29.2007','Muara Opu'),
('12.03.29.2010','Simarlelan'),
('12.03.29.2011','Muara Huta Raja'),
('12.03.30','Tano Tombangan Angkola'),
('12.03.30.1001','Panabari Hutatonga'),
('12.03.30.2002','Aek Uncim'),
('12.03.30.2003','Panindoan'),
('12.03.30.2004','Aek Kahombu'),
('12.03.30.2005','Batu Horpak'),
('12.03.30.2006','Situmba'),
('12.03.30.2007','Purba Tua'),
('12.03.30.2008','Lumban Jabi-jabi'),
('12.03.30.2009','Ingul Jae'),
('12.03.30.2010','Sisoma'),
('12.03.30.2011','Lumban Ratus'),
('12.03.30.2012','Kota Tua'),
('12.03.30.2013','Simaninggir Tano Tombangan'),
('12.03.30.2014','Huta Raja'),
('12.03.30.2015','Harean'),
('12.03.30.2016','Aek Parupuk'),
('12.03.30.2017','Tanjung Medan'),
('12.03.31','Angkola Sangkunur'),
('12.03.31.1001','Sangkunur'),
('12.03.31.1002','Rianiate'),
('12.03.31.2003','Simatohir'),
('12.03.31.2004','Perkebunan'),
('12.03.31.2005','Bandar Tarutung'),
('12.03.31.2006','Aek Pardomuan'),
('12.03.31.2007','Tindoan Laut'),
('12.03.31.2008','Simataniari'),
('12.03.31.2009','Batu Godang'),
('12.03.31.2010','Malombu'),
('12.03.32','Angkola Muara Tais'),
('12.03.32.1001','Bintuju'),
('12.03.32.1002','Huta Tonga'),
('12.03.32.2003','Basilam Baru'),
('12.03.32.2004','Sipangko'),
('12.03.32.2005','Huta Holbung'),
('12.03.32.2006','Muara Tais I'),
('12.03.32.2007','Muara Tais II'),
('12.03.32.2008','Muara Tais III'),
('12.03.32.2009','Janji Mauli MT'),
('12.03.32.2010','Pargumbangan'),
('12.03.32.2011','Pangaribuan'),
('12.03.32.2012','Pasir Matogu'),
('12.03.32.2013','Sori Manaon'),
('12.03.32.2014','Muara Purba Nauli'),
('12.03.32.2015','Tatengger'),
('12.04','Kabupaten Nias'),
('12.04.05','Hiliduho'),
('12.04.05.2001','Ononamolo I Bot'),
('12.04.05.2021','Dima'),
('12.04.05.2022','Sinarikhi'),
('12.04.05.2023','Ombolata Salo''o'),
('12.04.05.2024','Sisobalauru'),
('12.04.05.2025','Tuhegafoa II'),
('12.04.05.2027','Fadoro Lauru'),
('12.04.05.2028','Lasara Tanose''o'),
('12.04.05.2030','Hiliduho'),
('12.04.05.2031','Hiligodu Tanose''o'),
('12.04.05.2032','Sisobahili I Tanose''o'),
('12.04.05.2033','Onozitolidulu'),
('12.04.05.2034','Mazingo Tanose''o'),
('12.04.05.2040','Onowaembo Hiligara'),
('12.04.05.2041','Silimabanua'),
('12.04.05.2042','Ombolata Sisarahili'),
('12.04.06','Gido'),
('12.04.06.2006','Hiliotalua'),
('12.04.06.2008','Akhelauwe'),
('12.04.06.2016','Hilisebua'),
('12.04.06.2017','Somi'),
('12.04.06.2018','Sirete'),
('12.04.06.2019','Hiliweto Gido'),
('12.04.06.2020','Loloana''a Gido'),
('12.04.06.2022','Sisobahili'),
('12.04.06.2023','Lahemo'),
('12.04.06.2024','Ladea'),
('12.04.06.2027','Umbu'),
('12.04.06.2028','Soewe'),
('12.04.06.2029','Lolozasai'),
('12.04.06.2030','Lasara Idanoi'),
('12.04.06.2050','Lasela'),
('12.04.06.2051','Ladea Orahua'),
('12.04.06.2052','Tulumbaho Salo''o'),
('12.04.06.2053','Nifalo''olauru'),
('12.04.06.2054','Hilizoi'),
('12.04.06.2055','Somi Botogo''o'),
('12.04.06.2056','Olindrawa Sisarahili'),
('12.04.10','Idanogawo'),
('12.04.10.2005','Hilimoasio'),
('12.04.10.2006','Tetegeona''ai'),
('12.04.10.2007','Laowo Hilimbaruzo'),
('12.04.10.2008','Hililawa''e'),
('12.04.10.2009','Tuhewaebu'),
('12.04.10.2014','Sisobahili Iraonohura'),
('12.04.10.2015','Bozihona'),
('12.04.10.2016','Oladano'),
('12.04.10.2017','Ahedano'),
('12.04.10.2018','Hilina''a Tafuo'),
('12.04.10.2019','Hilionozega'),
('12.04.10.2020','Mondrali'),
('12.04.10.2022','Tetehosi'),
('12.04.10.2023','Saiwahili Hiliadulo'),
('12.04.10.2024','Maliwa''a'),
('12.04.10.2025','Biouti'),
('12.04.10.2026','Awoni Lauso'),
('12.04.10.2027','Bobozioli Loloana''a'),
('12.04.10.2028','Sandruta'),
('12.04.10.2029','Laira'),
('12.04.10.2030','Otalua'),
('12.04.10.2031','Baruzo'),
('12.04.10.2032','Orahili Zuzundrao'),
('12.04.10.2033','Tiga Serangkai Maliwa''a'),
('12.04.10.2034','Hiligogowaya Maliwa''a'),
('12.04.10.2035','Hili''adulo'),
('12.04.10.2036','Hilimoasio Dua'),
('12.04.10.2037','Biouti Timur'),
('12.04.11','Bawolato'),
('12.04.11.2002','Sisarahili Bawolato'),
('12.04.11.2003','Hiliganoita'),
('12.04.11.2004','Gazamanu'),
('12.04.11.2005','Hilihoru'),
('12.04.11.2006','Hilialawa'),
('12.04.11.2007','Hilifaosi'),
('12.04.11.2008','Hiliwarokha'),
('12.04.11.2009','Sitolubanua'),
('12.04.11.2010','Siofaewali'),
('12.04.11.2011','Sohoya'),
('12.04.11.2012','Botohaenga'),
('12.04.11.2013','Orahili'),
('12.04.11.2014','Tagaule'),
('12.04.11.2015','Siofabanua'),
('12.04.11.2016','Sifaoro''asi Uluhou'),
('12.04.11.2017','Dahana'),
('12.04.11.2018','Orahua'),
('12.04.11.2019','Banua Sibohou Silima Ewali'),
('12.04.11.2020','Si''ofaewali Selatan'),
('12.04.11.2021','Lagasimahe'),
('12.04.11.2022','Hilihao Cugala'),
('12.04.11.2023','Orahua Faondrato'),
('12.04.11.2024','Hou'),
('12.04.11.2025','Sindrondro'),
('12.04.11.2026','Balale Toba''a'),
('12.04.20','Hiliserangkai'),
('12.04.20.2001','Fadoro Hunogoa'),
('12.04.20.2002','Lolofaoso Lalai'),
('12.04.20.2003','Fulolo Lalai'),
('12.04.20.2004','Lawa-Lawa'),
('12.04.20.2005','Lalai I/II'),
('12.04.20.2006','Lolowua'),
('12.04.20.2007','Dahadano Botombawo'),
('12.04.20.2008','Fadoro Lalai'),
('12.04.20.2009','Lolowua Hiliwarasi'),
('12.04.20.2010','Hilizia Lauru'),
('12.04.20.2011','Ehosakhozi'),
('12.04.20.2012','Awela'),
('12.04.20.2013','Onombongi'),
('12.04.20.2014','Orahili Idanoi'),
('12.04.20.2015','Lolofaoso'),
('12.04.21','Botomuzoi'),
('12.04.21.2001','Hiligodu Botomuzoi'),
('12.04.21.2002','Lasara Botomuzoi'),
('12.04.21.2003','Hiliwa''ele I'),
('12.04.21.2004','Hilimbowo Botomuzoi'),
('12.04.21.2005','Simanaere Botomuzoi'),
('12.04.21.2006','Hiliwa''ele II'),
('12.04.21.2007','Tuhegafoa I'),
('12.04.21.2008','Balohili Botomuzoi'),
('12.04.21.2009','Hilihambawa Botomuzoi'),
('12.04.21.2010','Fulolo Botomuzoi'),
('12.04.21.2011','Loloana''a'),
('12.04.21.2012','Ononamolo Talafu'),
('12.04.21.2013','Sisobahili Dola'),
('12.04.21.2014','Banua Sibohou Botomuzoi'),
('12.04.21.2015','Mohili Berua Botomuzoi'),
('12.04.21.2016','Tetehosi Botomuzoi'),
('12.04.21.2017','Talafu'),
('12.04.21.2018','Ola Nori'),
('12.04.27','Ulugawo'),
('12.04.27.2001','Orahili'),
('12.04.27.2002','Hiliweto Gela'),
('12.04.27.2003','Lawa-lawa Luo'),
('12.04.27.2004','Hilimbowo'),
('12.04.27.2005','Hilibadalu'),
('12.04.27.2006','Fatodano'),
('12.04.27.2007','Fahandrona'),
('12.04.27.2008','Onodalinga'),
('12.04.27.2009','Holi'),
('12.04.27.2010','Sisobahili Ulugawo'),
('12.04.27.2011','Sifaoroasi Ulugawo'),
('12.04.27.2012','Mohili'),
('12.04.27.2013','Hiligafoa'),
('12.04.27.2014','Sisarahili Soroma''asi'),
('12.04.28','Ma''u'),
('12.04.28.2001','Balodano'),
('12.04.28.2002','Lewuoguru II'),
('12.04.28.2003','Sihare''o III'),
('12.04.28.2004','Sisarahili Ma''u'),
('12.04.28.2005','Lasara Siwalubanua'),
('12.04.28.2006','Tuhemberua'),
('12.04.28.2007','Atualuo'),
('12.04.28.2008','Lewa-lewa'),
('12.04.28.2009','Dekha'),
('12.04.28.2010','Sihare''o III Bawosalo''o Berua'),
('12.04.28.2011','Sihare''o III Hilibadalu'),
('12.04.29','Somolo-molo'),
('12.04.29.2001','Sisobawino I'),
('12.04.29.2002','I''odano'),
('12.04.29.2003','Huno'),
('12.04.29.2004','Sisaratandrawa'),
('12.04.29.2005','Somolo-molo'),
('12.04.29.2006','Lewuoguru I'),
('12.04.29.2007','Sifaoroasi'),
('12.04.29.2008','Lewuombanua'),
('12.04.29.2009','Hiligodu Somolo-Molo'),
('12.04.29.2010','Hilimborodano'),
('12.04.29.2011','So''ewali'),
('12.04.35','Sogae''adu'),
('12.04.35.2001','Tuhembuasi'),
('12.04.35.2002','Hilibadalu'),
('12.04.35.2003','La''uri'),
('12.04.35.2004','Hilimbana'),
('12.04.35.2005','Saitagaramba'),
('12.04.35.2006','Sogae''adu'),
('12.04.35.2007','Baruzo'),
('12.04.35.2008','Tulumbaho'),
('12.04.35.2009','Sisarahili Sogae''adu'),
('12.04.35.2010','We''a-we''a'),
('12.04.35.2011','Sihare''o Sogae''adu'),
('12.05','Kabupaten Langkat'),
('12.05.01','Bahorok'),
('12.05.01.1001','Pekan Bahorok'),
('12.05.01.2002','Lau Damak'),
('12.05.01.2003','Timbang Lawan'),
('12.05.01.2004','Sampe Raya'),
('12.05.01.2005','Tanjung Lenggang'),
('12.05.01.2006','Suka Rakyat'),
('12.05.01.2007','Perkebunan Turangi'),
('12.05.01.2008','Perkebunan Bungara'),
('12.05.01.2009','Perkebunan B. Lawang'),
('12.05.01.2011','Empus'),
('12.05.01.2012','Simpang Pulo Rambung'),
('12.05.01.2013','Perkebunan Sei Musam'),
('12.05.01.2014','Batu Jong-Jong'),
('12.05.01.2015','Sematar'),
('12.05.01.2016','Perkebunan Pulo Rambung'),
('12.05.01.2017','Sei Musam Kendit'),
('12.05.01.2020','Timbang Jaya'),
('12.05.01.2021','Musam Pembangunan'),
('12.05.01.2022','Ujung Bandar'),
('12.05.02','Salapian'),
('12.05.02.1007','Tanjung Langkat'),
('12.05.02.2002','Perkebunan Tanjung Keliling'),
('12.05.02.2004','Perkebunan Gelugur Langkat'),
('12.05.02.2005','Perkebunan Tambunan'),
('12.05.02.2006','Perkebunan Bandar Telu'),
('12.05.02.2008','Naman Jahe'),
('12.05.02.2009','Turangi'),
('12.05.02.2010','Ujung Teran'),
('12.05.02.2011','Pamah Tambunan'),
('12.05.02.2014','Minta Kasih'),
('12.05.02.2019','Ujung Bandar'),
('12.05.02.2020','Lau Tepu'),
('12.05.02.2021','Parangguam'),
('12.05.02.2023','Ponco Warno'),
('12.05.02.2024','Adin Tengah'),
('12.05.02.2025','Lau Lugur'),
('12.05.02.2026','Pancur Ido'),
('12.05.03','Kuala'),
('12.05.03.1001','Pekan Kuala'),
('12.05.03.1019','Bela Rakyat'),
('12.05.03.2002','Dalan Naman'),
('12.05.03.2003','Balai Kasih'),
('12.05.03.2004','Bekiung'),
('12.05.03.2005','Blankahan'),
('12.05.03.2006','Besadi'),
('12.05.03.2007','Beruam'),
('12.05.03.2009','Raja Tengah'),
('12.05.03.2011','Namo Mbelin'),
('12.05.03.2012','Parit Bindu'),
('12.05.03.2013','Sei Penjara'),
('12.05.03.2015','Perkebunan Bekiun'),
('12.05.03.2016','Garunggang'),
('12.05.03.2017','Suka Damai'),
('12.05.03.2018','Sido Makmur'),
('12.05.04','Sei Bingai'),
('12.05.04.1005','Namu Ukur Selatan'),
('12.05.04.2001','Telagah'),
('12.05.04.2002','Rumah Galuh'),
('12.05.04.2003','Simpang Kuta Buluh'),
('12.05.04.2004','Gunung Ambat'),
('12.05.04.2006','Belinteng'),
('12.05.04.2007','Namu Ukur Utara'),
('12.05.04.2008','Pasar VI Kwala Mencirim'),
('12.05.04.2009','Emplasmen Kwala Mencirim'),
('12.05.04.2010','Purwobinangun'),
('12.05.04.2011','Pasar IV.Namo Terasi'),
('12.05.04.2012','Pasar VIII.Namo Terasi'),
('12.05.04.2013','Durian Lingga'),
('12.05.04.2014','Pekan Sawah'),
('12.05.04.2015','Tanjung Gunung'),
('12.05.04.2016','Mekar Jaya'),
('12.05.05','Binjai'),
('12.05.05.1001','Kwala Begumit'),
('12.05.05.2002','Sambi Rejo'),
('12.05.05.2003','Sendang Rejo'),
('12.05.05.2004','Tanjung Jati'),
('12.05.05.2005','Sidomulyo'),
('12.05.05.2006','Perdamaian'),
('12.05.05.2007','Suka Makmur'),
('12.05.06','Selesai'),
('12.05.06.1001','Pekan Selesai'),
('12.05.06.2002','Sei Limbat'),
('12.05.06.2003','Padang Brahrang'),
('12.05.06.2004','Tanjung Merahe'),
('12.05.06.2005','Nambiki'),
('12.05.06.2006','Lau Mulgap'),
('12.05.06.2007','Kuta Parit'),
('12.05.06.2008','Bekulap'),
('12.05.06.2009','Perhiasan'),
('12.05.06.2010','Selayang'),
('12.05.06.2011','Mancang'),
('12.05.06.2012','Kwala Air Hitam'),
('12.05.06.2013','Padang Cermin'),
('12.05.06.2014','Selayang Baru'),
('12.05.07','Stabat'),
('12.05.07.1004','Perdamaian'),
('12.05.07.1005','Kwala Bingai'),
('12.05.07.1006','Sidomulyo'),
('12.05.07.1010','Stabat Baru'),
('12.05.07.1011','Dendang'),
('12.05.07.1012','Paya Mabar'),
('12.05.07.2001','Karang Rejo'),
('12.05.07.2002','Kwala Begumit'),
('12.05.07.2003','Mangga'),
('12.05.07.2007','Banyumas'),
('12.05.07.2008','Pantai Gemi'),
('12.05.07.2009','Ara Condong'),
('12.05.08','Wampu'),
('12.05.08.1001','Bingai'),
('12.05.08.2002','Gohor Lama'),
('12.05.08.2003','Stabat Lama'),
('12.05.08.2004','Besilam Bukit Lembasa'),
('12.05.08.2005','Kebun Balok'),
('12.05.08.2006','Bukit Melintang'),
('12.05.08.2007','Gergas'),
('12.05.08.2008','Stabat Lama Barat'),
('12.05.08.2009','Sumber Mulyo'),
('12.05.08.2010','Pertumbukan'),
('12.05.08.2011','Paya Tusam'),
('12.05.08.2012','Mekar Jaya'),
('12.05.08.2013','Jentera Stabat'),
('12.05.08.2014','Stungkit'),
('12.05.09','Secanggang'),
('12.05.09.1004','Hinai Kiri'),
('12.05.09.2001','Kepala Sungai'),
('12.05.09.2002','Teluk'),
('12.05.09.2003','Cinta Raja'),
('12.05.09.2005','Kebun Kelapa'),
('12.05.09.2006','Sungai Ular'),
('12.05.09.2007','Tanjung Ibus'),
('12.05.09.2008','Secanggang'),
('12.05.09.2009','Selotong'),
('12.05.09.2010','Karang Gading'),
('12.05.09.2011','Jaring Halus'),
('12.05.09.2012','Telaga Jernih'),
('12.05.09.2013','Perkotaan'),
('12.05.09.2014','Kwala Besar'),
('12.05.09.2015','Karang Anyar'),
('12.05.09.2016','Pantai Gading'),
('12.05.09.2017','Suka Mulia'),
('12.05.10','Hinai'),
('12.05.10.1008','Kebun Lada'),
('12.05.10.2001','Cempa'),
('12.05.10.2002','Batu Malenggang'),
('12.05.10.2003','Tamaran'),
('12.05.10.2004','Tanjung Mulia'),
('12.05.10.2005','Muka Paya'),
('12.05.10.2006','Hinai Kanan'),
('12.05.10.2007','Suka Damai'),
('12.05.10.2009','Baru Pasar VIII'),
('12.05.10.2010','Perkebunan Tanjung Beringin'),
('12.05.10.2011','Suka Jadi'),
('12.05.10.2012','Paya Rengas'),
('12.05.10.2013','Suka Damai Timur'),
('12.05.11','Tanjung Pura'),
('12.05.11.1005','Pekan Tanjung Pura'),
('12.05.11.2001','Serapuh Asli'),
('12.05.11.2002','Pematang Tengah'),
('12.05.11.2003','Paya Perupuk'),
('12.05.11.2004','Lalang'),
('12.05.11.2006','Pekubuan'),
('12.05.11.2007','Teluk Bakung'),
('12.05.11.2008','Pantai Cermin'),
('12.05.11.2009','Pematang Serai'),
('12.05.11.2010','Baja Kuning'),
('12.05.11.2011','Pulau Banyak'),
('12.05.11.2012','Pematang Cengal'),
('12.05.11.2013','Kwala Serapuh'),
('12.05.11.2014','Kwala Langkat'),
('12.05.11.2015','Bubun'),
('12.05.11.2016','Tapak Kuda'),
('12.05.11.2017','Suka Maju'),
('12.05.11.2018','Karya Maju'),
('12.05.11.2019','Pematang Cengal Barat'),
('12.05.12','Padang Tualang'),
('12.05.12.1006','Tanjung Selamat'),
('12.05.12.2001','Serapuh ABC'),
('12.05.12.2002','Padang Tualang'),
('12.05.12.2003','Kwala Besilam'),
('12.05.12.2004','Buluh Telang'),
('12.05.12.2005','Besilam'),
('12.05.12.2007','Tebing Tanjung Selamat'),
('12.05.12.2008','Tanjung Putus'),
('12.05.12.2009','Suka Ramai'),
('12.05.12.2010','Jati Sari'),
('12.05.12.2011','Banjaran Raya'),
('12.05.12.2012','Bukit Sari'),
('12.05.13','Gebang'),
('12.05.13.1001','Pekan Gebang'),
('12.05.13.2002','Paluh Manis'),
('12.05.13.2003','Pasar Rawa'),
('12.05.13.2004','Padang Langkat'),
('12.05.13.2005','Air Hitam'),
('12.05.13.2006','Paya Bengkuang'),
('12.05.13.2007','Dogang'),
('12.05.13.2008','Sangga Lima'),
('12.05.13.2009','Kwala Gebang'),
('12.05.13.2010','Bukit Mengkirai'),
('12.05.13.2011','Pasiran'),
('12.05.14','Babalan'),
('12.05.14.1001','Pelawi Utara'),
('12.05.14.1006','Berandan Barat'),
('12.05.14.1007','Berandan Timur Baru'),
('12.05.14.1008','Berandan Timur'),
('12.05.14.2002','Securai Utara'),
('12.05.14.2003','Teluk Meku'),
('12.05.14.2004','Pelawi Selatan'),
('12.05.14.2005','Securai Selatan'),
('12.05.15','Pangkalan Susu'),
('12.05.15.1009','Beras Basah'),
('12.05.15.1010','Bukit Jengkol'),
('12.05.15.2001','Alur Cempedak'),
('12.05.15.2002','Sei Siur'),
('12.05.15.2003','Tanjung Pasir'),
('12.05.15.2004','Paya Tampak'),
('12.05.15.2005','Pintu Air'),
('12.05.15.2006','Sei Meran'),
('12.05.15.2007','Pulau Sembilan'),
('12.05.15.2008','Pulau Kampai'),
('12.05.15.2011','Pangkalan Siata'),
('12.05.16','Besitang'),
('12.05.16.1009','Pekan Besitang'),
('12.05.16.1010','Bukit Kubu'),
('12.05.16.1011','Kampung Lama'),
('12.05.16.2001','Halaban'),
('12.05.16.2002','Bukit Mas'),
('12.05.16.2005','Pir Adb Besitang'),
('12.05.16.2006','Sekoci'),
('12.05.16.2007','Suka Jaya'),
('12.05.16.2008','Bukit Selamat'),
('12.05.17','Sei Lepan'),
('12.05.17.1001','Sei Bilah'),
('12.05.17.1002','Alur Dua'),
('12.05.17.1008','Alur Dua Baru'),
('12.05.17.1009','Harapan Jaya'),
('12.05.17.1010','Sei Bilah Timur'),
('12.05.17.2003','Puraka I'),
('12.05.17.2004','Puraka II'),
('12.05.17.2005','Lama'),
('12.05.17.2006','Telaga Said'),
('12.05.17.2007','Lama Baru'),
('12.05.17.2011','Mekar Makmur'),
('12.05.17.2012','Harapan Baru'),
('12.05.17.2013','Harapan Maju'),
('12.05.17.2014','Harapan Makmur'),
('12.05.18','Berandan Barat'),
('12.05.18.1001','Tangkahan Durian'),
('12.05.18.1004','Pangkalan Batu'),
('12.05.18.2002','Sei Tualang'),
('12.05.18.2003','Lubuk Kasih'),
('12.05.18.2005','Lubuk Kertang'),
('12.05.18.2006','Perlis'),
('12.05.18.2007','Kelantan'),
('12.05.19','Batang Serangan'),
('12.05.19.1001','Batang Serangan'),
('12.05.19.2002','Sei Bamban'),
('12.05.19.2003','Sei Musam'),
('12.05.19.2004','Sei Serdang'),
('12.05.19.2005','Namo Sialang'),
('12.05.19.2006','Kwala Musam'),
('12.05.19.2007','Karya Jadi'),
('12.05.19.2008','Paluh Pakeh Babussalam'),
('12.05.20','Sawit Seberang'),
('12.05.20.1001','Sawit Seberang'),
('12.05.20.2002','Alur Gadung'),
('12.05.20.2003','Simpang Tiga'),
('12.05.20.2004','Sei Litur Tasik'),
('12.05.20.2005','Sawit Hulu'),
('12.05.20.2006','Mekar Sawit'),
('12.05.20.2007','Alur Melati'),
('12.05.21','Sirapit'),
('12.05.21.2001','Serapit'),
('12.05.21.2002','Gunung Tinggi'),
('12.05.21.2003','Sidorejo'),
('12.05.21.2004','Suka Pulung'),
('12.05.21.2005','Aman Damai'),
('12.05.21.2006','Tanjung Kariahan'),
('12.05.21.2007','Sebertung'),
('12.05.21.2008','Pulau Semikat'),
('12.05.21.2009','Sumber Jaya'),
('12.05.21.2010','Perkebunan Amal Tani'),
('12.05.22','Kutambaru'),
('12.05.22.2001','Namotogan'),
('12.05.22.2002','Kuta Gajah'),
('12.05.22.2003','Perkebunan Marike'),
('12.05.22.2004','Kaperas'),
('12.05.22.2005','Namoteras'),
('12.05.22.2006','Rampah'),
('12.05.22.2007','Sulkam'),
('12.05.22.2008','Kutambaru'),
('12.05.23','Pematang Jaya'),
('12.05.23.2001','Pematang Tengah'),
('12.05.23.2002','Damar Condong'),
('12.05.23.2003','Perkebunan Damar Condong'),
('12.05.23.2004','Perkebunan Perapen'),
('12.05.23.2005','Limau Mungkur'),
('12.05.23.2006','Serang Jaya Hilir'),
('12.05.23.2007','Serang Jaya'),
('12.05.23.2008','Sala Haji'),
('12.06','Kabupaten Karo'),
('12.06.01','Kabanjahe'),
('12.06.01.1009','Padang Mas'),
('12.06.01.1010','Lau Cimba'),
('12.06.01.1011','Gung Leto'),
('12.06.01.1012','Gung Negeri'),
('12.06.01.1013','Kampung Dalam'),
('12.06.01.2001','Rumah Kabanjahe'),
('12.06.01.2002','Kaban'),
('12.06.01.2003','Ketaren'),
('12.06.01.2004','Samura'),
('12.06.01.2005','Lau Simomo'),
('12.06.01.2006','Sumber Mufakat'),
('12.06.01.2007','Kandibata'),
('12.06.01.2008','Kacaribu'),
('12.06.02','Berastagi'),
('12.06.02.1006','Tambak Lau Mulgab I'),
('12.06.02.1007','Tambak Lau Mulgab II'),
('12.06.02.1008','Gundaling I'),
('12.06.02.1009','Gundaling II'),
('12.06.02.2001','Daulu'),
('12.06.02.2002','Gurusinga'),
('12.06.02.2003','Raya'),
('12.06.02.2004','Rumah Berastagi'),
('12.06.02.2005','Sempajaya'),
('12.06.02.2010','Lau Gumba'),
('12.06.03','Barusjahe'),
('12.06.03.2001','Paribun'),
('12.06.03.2002','Rumamis'),
('12.06.03.2003','Sinaman'),
('12.06.03.2004','Sukanalu'),
('12.06.03.2005','Barusjulu'),
('12.06.03.2006','Tangkidik'),
('12.06.03.2007','Sukajulu'),
('12.06.03.2008','Barusjahe'),
('12.06.03.2009','Bulanjahe'),
('12.06.03.2010','Pertumbuken'),
('12.06.03.2011','Talimbaru'),
('12.06.03.2012','Sikab'),
('12.06.03.2013','Persadanta'),
('12.06.03.2014','Bulanjulu'),
('12.06.03.2015','Semangat'),
('12.06.03.2016','Serdang'),
('12.06.03.2017','Tanjung Barus'),
('12.06.03.2018','Sarimanis'),
('12.06.03.2019','Penampen'),
('12.06.04','Tigapanah'),
('12.06.04.2001','Kutakepar'),
('12.06.04.2002','Ajijulu'),
('12.06.04.2004','Singa'),
('12.06.04.2007','Ajijahe'),
('12.06.04.2008','Bunuraya'),
('12.06.04.2010','Kubusimbelang'),
('12.06.04.2011','Tigapanah'),
('12.06.04.2012','Suka'),
('12.06.04.2014','Kacinambun'),
('12.06.04.2015','Kutajulu'),
('12.06.04.2016','Bertah'),
('12.06.04.2017','Manukmulia'),
('12.06.04.2018','Lauriman'),
('12.06.04.2019','Sukadame'),
('12.06.04.2020','Mulawari'),
('12.06.04.2023','Sukamaju'),
('12.06.04.2024','Kutambelin'),
('12.06.04.2025','Kutabale'),
('12.06.04.2026','Leparsamura'),
('12.06.04.2027','Seberaya'),
('12.06.04.2028','Ajimbelang'),
('12.06.04.2029','Ajibuhara'),
('12.06.04.2030','Lambar'),
('12.06.04.2031','Salit'),
('12.06.04.2032','Suka Mbayak'),
('12.06.04.2033','Suka Sipilihen'),
('12.06.04.2034','Sukameriah'),
('12.06.04.2035','Bekerah'),
('12.06.04.2036','Simacem'),
('12.06.05','Merek'),
('12.06.05.2001','Partibi Tembe'),
('12.06.05.2002','Negeri Tongging'),
('12.06.05.2003','Kodon-Kodon'),
('12.06.05.2004','Dokan'),
('12.06.05.2005','Nagara'),
('12.06.05.2006','Sibolangit'),
('12.06.05.2007','Sukamandi'),
('12.06.05.2008','Nagalingga'),
('12.06.05.2009','Pangambatan'),
('12.06.05.2010','Tongging'),
('12.06.05.2011','Partibi Lama'),
('12.06.05.2012','Regaji'),
('12.06.05.2013','Ajinembah'),
('12.06.05.2014','Situnggaling'),
('12.06.05.2015','Garingging'),
('12.06.05.2016','Mulia Rayat'),
('12.06.05.2017','Bandar Tongging'),
('12.06.05.2018','Pancur Batu'),
('12.06.05.2019','Merek'),
('12.06.06','Munte'),
('12.06.06.2001','Nageri'),
('12.06.06.2002','Munte'),
('12.06.06.2003','Kineppen'),
('12.06.06.2004','Bandar Meriah'),
('12.06.06.2005','Barung Kersap'),
('12.06.06.2006','Kutambaru'),
('12.06.06.2007','Buluhnaman'),
('12.06.06.2008','Singgamanik'),
('12.06.06.2009','Kuta Gerat'),
('12.06.06.2010','Pertumbungen'),
('12.06.06.2011','Sarimunte'),
('12.06.06.2012','Kaban Tua'),
('12.06.06.2013','Gunung Manumpak'),
('12.06.06.2014','Tanjung Beringin'),
('12.06.06.2015','Kuta Suah'),
('12.06.06.2016','Sarinembah'),
('12.06.06.2017','Selakkar'),
('12.06.06.2018','Parimbalang'),
('12.06.06.2019','Gunung Saribu'),
('12.06.06.2020','Sukarame'),
('12.06.06.2021','Gurubenua'),
('12.06.06.2022','Biaknampe'),
('12.06.07','Juhar'),
('12.06.07.2001','Juhar Perangin-angin'),
('12.06.07.2002','Lau Lingga'),
('12.06.07.2003','Kidupen'),
('12.06.07.2004','Namosuro'),
('12.06.07.2005','Bekilang'),
('12.06.07.2006','Sugihen'),
('12.06.07.2007','Pernantin'),
('12.06.07.2008','Nageri'),
('12.06.07.2009','Juhar Ginting'),
('12.06.07.2010','Juhar Tarigan'),
('12.06.07.2011','Pasar Baru'),
('12.06.07.2012','Batu Mamak'),
('12.06.07.2013','Naga'),
('12.06.07.2014','Kutambelin'),
('12.06.07.2015','Mbetong'),
('12.06.07.2016','Keriahen'),
('12.06.07.2017','Gunung Juhar'),
('12.06.07.2018','Ketawaren'),
('12.06.07.2019','Jandi'),
('12.06.07.2020','Buluh Pancur'),
('12.06.07.2021','Kutagugung'),
('12.06.07.2022','Sukababo'),
('12.06.07.2023','Lau Kidupen'),
('12.06.07.2024','Sigenderang'),
('12.06.07.2025','Juhar Ginting Sadanioga'),
('12.06.08','Tigabinanga'),
('12.06.08.1019','Tiga Binanga'),
('12.06.08.2001','Gunung'),
('12.06.08.2002','Kem Kem'),
('12.06.08.2003','Pertumbuken'),
('12.06.08.2004','Kuala'),
('12.06.08.2005','Limang'),
('12.06.08.2006','Perbesi'),
('12.06.08.2007','Lau Kapur'),
('12.06.08.2008','Kuta Bangun'),
('12.06.08.2009','Kuta Raya'),
('12.06.08.2010','Pergendangen'),
('12.06.08.2011','Simolap'),
('12.06.08.2012','Simpang Pergendangen'),
('12.06.08.2013','Kuta Gerat'),
('12.06.08.2014','Suka Julu'),
('12.06.08.2015','Kuta Galoh'),
('12.06.08.2016','Bunga Baru'),
('12.06.08.2017','Kutambaru Punti'),
('12.06.08.2018','Kuta Buara'),
('12.06.08.2020','Batumamak'),
('12.06.09','Laubaleng'),
('12.06.09.2001','Martelu'),
('12.06.09.2002','Mbal-Mbal Petarum'),
('12.06.09.2003','Lau Peranggunen'),
('12.06.09.2004','Tanjung Gunung'),
('12.06.09.2005','Lau Baleng'),
('12.06.09.2006','Durin Rugun'),
('12.06.09.2007','Perbulan'),
('12.06.09.2008','Kutambelin'),
('12.06.09.2009','Lingga Muda'),
('12.06.09.2010','Kinangkong'),
('12.06.09.2011','Rambah Tampu'),
('12.06.09.2012','Lau Peradep'),
('12.06.09.2013','Buluh Pancur'),
('12.06.09.2014','Batu Rongkam'),
('12.06.09.2015','Pintu Angin'),
('12.06.10','Mardingding'),
('12.06.10.2001','Lau Pengulu'),
('12.06.10.2002','Lau Mulgap'),
('12.06.10.2003','Lau Kesumpat'),
('12.06.10.2004','Rimo Bunga'),
('12.06.10.2005','Tanjung Pamah'),
('12.06.10.2006','Kuta Pengkih'),
('12.06.10.2007','Bandar Purba'),
('12.06.10.2008','Mardingding'),
('12.06.10.2009','Lau Pakam'),
('12.06.10.2010','Lau Solu'),
('12.06.10.2011','Lau Garut'),
('12.06.10.2012','Bukit Makmur'),
('12.06.11','Payung'),
('12.06.11.2001','Payung'),
('12.06.11.2004','Rimo Kayu'),
('12.06.11.2007','Selandi'),
('12.06.11.2012','Batukarang'),
('12.06.11.2015','Gurukinayan'),
('12.06.11.2017','Cimbang'),
('12.06.11.2025','Ujung Payung'),
('12.06.12','Simpang Empat'),
('12.06.12.2005','Kutatengah'),
('12.06.12.2006','Tigapancur'),
('12.06.12.2007','Pintu Besi'),
('12.06.12.2009','Gamber'),
('12.06.12.2012','Sirumbia'),
('12.06.12.2014','Ndokumsiroga'),
('12.06.12.2016','Linggajulu'),
('12.06.12.2017','Gajah'),
('12.06.12.2018','Lingga'),
('12.06.12.2019','Nangbelawan'),
('12.06.12.2022','Beganding'),
('12.06.12.2024','Torong'),
('12.06.12.2025','Berastepu'),
('12.06.12.2026','Surbakti'),
('12.06.12.2028','Jeraya'),
('12.06.12.2030','Perteguhen'),
('12.06.12.2035','Bulanbaru'),
('12.06.13','Kutabuluh'),
('12.06.13.2001','Negeri Jahe'),
('12.06.13.2002','Kutabuluh Gugung'),
('12.06.13.2003','Siabang-abang'),
('12.06.13.2004','Lau Buluh'),
('12.06.13.2005','Bintang Meriah'),
('12.06.13.2006','Jinabun'),
('12.06.13.2007','Kuta Male'),
('12.06.13.2008','Ujung Deleng'),
('12.06.13.2009','Gunung Meriah'),
('12.06.13.2010','Buah Raya'),
('12.06.13.2011','Tanjung Merahe'),
('12.06.13.2012','Rih Tengah'),
('12.06.13.2013','Kutabuluh'),
('12.06.13.2014','Liang Merdeka'),
('12.06.13.2015','Pola Tebu'),
('12.06.13.2016','Mburidi'),
('12.06.14','Dolat Rayat'),
('12.06.14.2001','Kubu Colia'),
('12.06.14.2002','Ujung Sampun'),
('12.06.14.2003','Bukit'),
('12.06.14.2004','Melas'),
('12.06.14.2005','Sampun'),
('12.06.14.2006','Sugihen'),
('12.06.14.2007','Dolat Rayat'),
('12.06.15','Merdeka'),
('12.06.15.2001','Cinta Rakyat'),
('12.06.15.2002','Semangat'),
('12.06.15.2003','Ujung Teran'),
('12.06.15.2004','Gongsol'),
('12.06.15.2005','Jaranguda'),
('12.06.15.2006','Semangat Gunung'),
('12.06.15.2007','Deram'),
('12.06.15.2008','Merdeka'),
('12.06.15.2009','Sada Perarih'),
('12.06.16','Naman Teran'),
('12.06.16.2002','Kutagugung'),
('12.06.16.2003','Kuta Tonggal'),
('12.06.16.2004','Naman'),
('12.06.16.2005','Sukanalu'),
('12.06.16.2006','Kebayaken'),
('12.06.16.2007','Kutarayat'),
('12.06.16.2009','Sukandebi'),
('12.06.16.2010','Gung Pinto'),
('12.06.16.2011','Kutambelin'),
('12.06.16.2012','Ndeskati'),
('12.06.16.2013','Sukatepu'),
('12.06.16.2014','Sigarang-garang'),
('12.06.17','Tiganderket'),
('12.06.17.2001','Sukatendel'),
('12.06.17.2002','Mardingding'),
('12.06.17.2003','Kutagaluh'),
('12.06.17.2004','Kutambaru'),
('12.06.17.2005','Jandimeriah'),
('12.06.17.2006','Tiganderket'),
('12.06.17.2007','Tanjung Pulo'),
('12.06.17.2008','Tanjung Merawa'),
('12.06.17.2009','Perbaji'),
('12.06.17.2010','Temburun'),
('12.06.17.2011','Kutakepar'),
('12.06.17.2012','Penampen'),
('12.06.17.2013','Tanjung Mbelang'),
('12.06.17.2014','Narigunung I'),
('12.06.17.2015','Narigunung II'),
('12.06.17.2016','Gunung Merlawan'),
('12.06.17.2017','Susuk'),
('12.07','Kabupaten Deli Serdang'),
('12.07.01','Gunung Meriah'),
('12.07.01.2001','Kuta Bayu'),
('12.07.01.2002','Gunung Paribuan'),
('12.07.01.2003','Simempar'),
('12.07.01.2004','Gunung Seribu'),
('12.07.01.2005','Gunung Sinembah'),
('12.07.01.2006','Bintang Meriah'),
('12.07.01.2007','Kuta Tengah'),
('12.07.01.2008','Pekan Gunung Mariah'),
('12.07.01.2009','Gunung Meriah'),
('12.07.01.2010','Ujung Meriah'),
('12.07.01.2011','Marjandi Pematang'),
('12.07.01.2012','Marjandi Tongah'),
('12.07.02','Tanjung Morawa'),
('12.07.02.1026','Pekan Tanjung Morawa'),
('12.07.02.2001','Medan Senembah'),
('12.07.02.2002','Ujung Serdang'),
('12.07.02.2003','Limau Manis'),
('12.07.02.2004','Bandar Labuhan'),
('12.07.02.2005','Bangun Rejo'),
('12.07.02.2006','Aek Pancur'),
('12.07.02.2007','Sei Merah'),
('12.07.02.2008','Naga Timbul'),
('12.07.02.2009','Lengau Seprang'),
('12.07.02.2010','Tanjung Mulia'),
('12.07.02.2011','Punden Rejo'),
('12.07.02.2012','Tanjung Morawa-B'),
('12.07.02.2013','Dagang Kerawan'),
('12.07.02.2014','Tanjung Morawa-A'),
('12.07.02.2015','Buntu Bedimbar'),
('12.07.02.2016','Bangun Sari'),
('12.07.02.2017','Dagang Kelambir'),
('12.07.02.2018','Dalu Sepuluh-A'),
('12.07.02.2019','Dalu Sepuluh-B'),
('12.07.02.2020','Wonosari'),
('12.07.02.2021','Perdamean'),
('12.07.02.2022','Penara Kebun'),
('12.07.02.2023','Bangun Sari Baru'),
('12.07.02.2024','Telaga Sari'),
('12.07.02.2025','Tanjung Baru'),
('12.07.03','Sibolangit'),
('12.07.03.2001','Bandar Baru'),
('12.07.03.2002','Batu Layang'),
('12.07.03.2003','Batu Mbelin'),
('12.07.03.2004','Betimus Mbaru'),
('12.07.03.2005','Bengkurung'),
('12.07.03.2006','Bingkawan'),
('12.07.03.2007','Buah Nabar'),
('12.07.03.2008','Bukum'),
('12.07.03.2009','Buluh Awar'),
('12.07.03.2010','Cinta Rakyat'),
('12.07.03.2011','Durin Serugun'),
('12.07.03.2012','Ketangkuhen'),
('12.07.03.2013','Kuala'),
('12.07.03.2014','Martelu'),
('12.07.03.2015','Negeri Gugung'),
('12.07.03.2016','Puangaja'),
('12.07.03.2017','Rumah Kinangkung SP'),
('12.07.03.2018','Rambung Baru'),
('12.07.03.2019','Rumah Pil Pil'),
('12.07.03.2020','Rumah Sumbul'),
('12.07.03.2021','Sala Bulan'),
('12.07.03.2022','Sayum Sabah'),
('12.07.03.2023','Sembahe'),
('12.07.03.2024','Sibolangit'),
('12.07.03.2025','Sikeben'),
('12.07.03.2026','Suka Maju'),
('12.07.03.2027','Suka Makmur'),
('12.07.03.2028','Tambunen'),
('12.07.03.2029','Tanjung Beringin'),
('12.07.03.2030','Ujung Deleng'),
('12.07.04','Kutalimbaru'),
('12.07.04.2001','Suka Makmur'),
('12.07.04.2002','Namo Mirik'),
('12.07.04.2003','Suka Dame'),
('12.07.04.2004','Pasar X'),
('12.07.04.2005','Perpanden'),
('12.07.04.2006','Kutalimbaru'),
('12.07.04.2007','Sampe Cita'),
('12.07.04.2008','Suka Rende'),
('12.07.04.2009','Kwala Lau Bicik'),
('12.07.04.2010','Lau Bekeri'),
('12.07.04.2011','Silebo-Lebo'),
('12.07.04.2012','Sawit Rejo'),
('12.07.04.2013','Namo Rube Julu'),
('12.07.04.2014','Sei Mencirim'),
('12.07.05','Pancur Batu'),
('12.07.05.2001','Bintang Meriah'),
('12.07.05.2002','Sugau'),
('12.07.05.2003','Tiang Layar'),
('12.07.05.2004','Durin Simbelang'),
('12.07.05.2005','Namo Riam'),
('12.07.05.2006','Durin Tonggal'),
('12.07.05.2007','Hulu'),
('12.07.05.2008','Pertampilen'),
('12.07.05.2009','Salam Tani'),
('12.07.05.2010','Tengah'),
('12.07.05.2011','Namo Simpur'),
('12.07.05.2012','Simalingkar A'),
('12.07.05.2013','Namo Bintang'),
('12.07.05.2014','Lama'),
('12.07.05.2015','Namo Rih'),
('12.07.05.2016','Tuntungan I'),
('12.07.05.2017','Gunung Tinggi'),
('12.07.05.2018','Tuntungan II'),
('12.07.05.2019','Durin Jangak'),
('12.07.05.2020','Sembahe Baru'),
('12.07.05.2021','Tanjung Anom'),
('12.07.05.2022','Sei Glugur'),
('12.07.05.2023','Suka Raya'),
('12.07.05.2024','Baru'),
('12.07.05.2025','Perumnas Simalingkar'),
('12.07.06','Namo Rambe'),
('12.07.06.2001','Deli Tua'),
('12.07.06.2002','Jati Kesuma'),
('12.07.06.2003','Namo Rambe'),
('12.07.06.2004','Gunung Kelawas'),
('12.07.06.2005','Ujung Labuhan'),
('12.07.06.2006','Lubang Ido'),
('12.07.06.2007','Silue-lue'),
('12.07.06.2008','Timbang Lawan'),
('12.07.06.2009','Batu Mbelin'),
('12.07.06.2010','Namo Batang'),
('12.07.06.2011','Tanjung Selamat'),
('12.07.06.2012','Bekukul'),
('12.07.06.2013','Namo Pakam'),
('12.07.06.2014','Suka Mulia Hilir'),
('12.07.06.2015','Suka Mulia Hulu'),
('12.07.06.2016','Rumah Mbacang'),
('12.07.06.2017','Cinta Rakyat'),
('12.07.06.2018','Batu Penjemuran'),
('12.07.06.2019','Kuta Tengah'),
('12.07.06.2020','Namo Landur'),
('12.07.06.2021','Gunung Berita'),
('12.07.06.2022','Tangkahan'),
('12.07.06.2023','Uruk Gedang'),
('12.07.06.2024','Rumah Keben'),
('12.07.06.2025','Namo Pinang'),
('12.07.06.2026','Sudi Rejo'),
('12.07.06.2027','Jaba'),
('12.07.06.2028','Kuta Tualah'),
('12.07.06.2029','Kwala Simeme'),
('12.07.06.2030','Batu Gemuk'),
('12.07.06.2031','Lau Mulgap'),
('12.07.06.2032','Batu Rejo'),
('12.07.06.2033','Salang Tungir'),
('12.07.06.2034','Namo Mbaru'),
('12.07.06.2035','Rimo Mungkur'),
('12.07.06.2036','Namo Mbelin'),
('12.07.07','Biru-Biru'),
('12.07.07.2001','Aji Baho'),
('12.07.07.2002','Biru-biru'),
('12.07.07.2003','Candi Rejo'),
('12.07.07.2004','Kutomulyo'),
('12.07.07.2005','Kuala Dekah'),
('12.07.07.2006','Mbaruai'),
('12.07.07.2007','Mardinding Julu'),
('12.07.07.2008','Namo Suro Baru'),
('12.07.07.2009','Peria-ria'),
('12.07.07.2010','Penen'),
('12.07.07.2011','Rumah Gerat'),
('12.07.07.2012','Sidodadi'),
('12.07.07.2013','Sidomulyo'),
('12.07.07.2014','Selamat'),
('12.07.07.2015','Sarilaba Jahe'),
('12.07.07.2016','Tanjung Sena'),
('12.07.07.2017','Namo Tualang'),
('12.07.08','Sinembah Tanjung Muda Hilir'),
('12.07.08.2001','Talun Kenas'),
('12.07.08.2002','Gunung Rintih'),
('12.07.08.2003','Sumbul'),
('12.07.08.2004','Tadukan Raga'),
('12.07.08.2005','Limau Mungkur'),
('12.07.08.2006','Negara Beringin'),
('12.07.08.2007','Lau Barus Baru'),
('12.07.08.2008','Juma Tombak'),
('12.07.08.2009','Siguci'),
('12.07.08.2010','Kuta Jurung'),
('12.07.08.2011','Tala Peta'),
('12.07.08.2012','Lau Rakit'),
('12.07.08.2013','Penungkiren'),
('12.07.08.2014','Rambai'),
('12.07.08.2015','Lau Rempak'),
('12.07.09','Bangun Purba'),
('12.07.09.2001','Bah Perak'),
('12.07.09.2002','Bandar Kwala'),
('12.07.09.2003','Bah Balua'),
('12.07.09.2005','Bandar Gugung'),
('12.07.09.2006','Bandar Meriah'),
('12.07.09.2007','Batu Gingging'),
('12.07.09.2008','Bangun Purba'),
('12.07.09.2009','Bangun Purba Tengah'),
('12.07.09.2010','Begerpang'),
('12.07.09.2011','Batu Rata'),
('12.07.09.2012','Cimahi'),
('12.07.09.2014','Damak Maliho'),
('12.07.09.2015','Greahan'),
('12.07.09.2017','Marombun Ujung Jawi'),
('12.07.09.2018','Marombun Barat'),
('12.07.09.2019','Mabar'),
('12.07.09.2020','Perguroan'),
('12.07.09.2023','Rumah Deleng'),
('12.07.09.2024','Sibaganding'),
('12.07.09.2025','Sialang'),
('12.07.09.2027','Sukaluwei'),
('12.07.09.2030','Tanjung Purba'),
('12.07.09.2032','Urung Ganjang'),
('12.07.09.2033','Ujung Rambe'),
('12.07.19','Galang'),
('12.07.19.1038','Galang Kota'),
('12.07.19.2001','Tanjung Gusti'),
('12.07.19.2002','Baru Titi Besi'),
('12.07.19.2003','Bandar Kuala'),
('12.07.19.2004','Batu Lokong'),
('12.07.19.2005','Galang Suka'),
('12.07.19.2006','Galang Barat'),
('12.07.19.2007','Jaharun A'),
('12.07.19.2008','Jaharun B'),
('12.07.19.2009','Juhar Baru'),
('12.07.19.2012','Kramat Gajah'),
('12.07.19.2013','Kotasan'),
('12.07.19.2015','Kotangan'),
('12.07.19.2016','Kelapa Satu'),
('12.07.19.2019','Nogorejo'),
('12.07.19.2022','Paku'),
('12.07.19.2023','Petumbukan'),
('12.07.19.2024','Petangguhan'),
('12.07.19.2025','Pisang Pala'),
('12.07.19.2026','Paya Itik'),
('12.07.19.2027','Pulo Tagor Baru'),
('12.07.19.2028','Paya Kuda'),
('12.07.19.2029','Paya Sampir'),
('12.07.19.2030','Sei Putih'),
('12.07.19.2031','Sei Karang'),
('12.07.19.2034','Tanah Abang'),
('12.07.19.2035','Timbang Deli'),
('12.07.19.2036','Tanah Merah'),
('12.07.19.2037','Tanjung Siporkis'),
('12.07.20','Sinembah Tanjung Muda Hulu'),
('12.07.20.2001','Tiga Juhar'),
('12.07.20.2002','Tanjung Bampu'),
('12.07.20.2003','Rumah Rih'),
('12.07.20.2004','Liang Muda'),
('12.07.20.2005','Durian IV Mbelang'),
('12.07.20.2006','Tanah Gara Hulu'),
('12.07.20.2007','Gunung Manumpak A'),
('12.07.20.2008','Bah Bah Buntu'),
('12.07.20.2009','Tanjung Muda'),
('12.07.20.2010','Tanjung Raja'),
('12.07.20.2011','Kuta Mbelin'),
('12.07.20.2012','Rumah Sumbul'),
('12.07.20.2013','Ranggit-git'),
('12.07.20.2014','Liang Pematang'),
('12.07.20.2015','Gunung Manumpak B'),
('12.07.20.2016','Rumah Lengo'),
('12.07.20.2017','Sipinggan'),
('12.07.20.2018','Tanjung Timur'),
('12.07.20.2019','Durian Tinggung'),
('12.07.20.2020','Sibunga Bunga Hilir'),
('12.07.21','Patumbak'),
('12.07.21.2001','Lantasan Baru'),
('12.07.21.2002','Patumbak I'),
('12.07.21.2003','Patumbak II'),
('12.07.21.2004','Lantasan Lama'),
('12.07.21.2005','Sigara-gara'),
('12.07.21.2006','Marindal I'),
('12.07.21.2007','Marindal II'),
('12.07.21.2008','Patumbak Kampung'),
('12.07.22','Deli Tua'),
('12.07.22.1004','Deli Tua'),
('12.07.22.1005','Deli Tua Timur'),
('12.07.22.1006','Deli Tua Barat'),
('12.07.22.2001','Kedai Durian'),
('12.07.22.2002','Suka Makmur'),
('12.07.22.2003','Mekar Sari'),
('12.07.23','Sunggal'),
('12.07.23.2001','Sei Semayang'),
('12.07.23.2002','Lalang'),
('12.07.23.2003','Puji Mulyo'),
('12.07.23.2004','Paya Geli'),
('12.07.23.2005','Mulio Rejo'),
('12.07.23.2006','Purwodadi'),
('12.07.23.2007','Sumber Melati Diski'),
('12.07.23.2008','Tanjung Gusta'),
('12.07.23.2009','Helvetia'),
('12.07.23.2010','Medan Krio'),
('12.07.23.2011','Sei Mencirim'),
('12.07.23.2012','Sukamaju'),
('12.07.23.2013','Sunggal Kanan'),
('12.07.23.2014','Serbajadi'),
('12.07.23.2015','Telaga Sari'),
('12.07.23.2016','Tanjung Selamat'),
('12.07.23.2017','Sei Beras Sekata'),
('12.07.24','Hamparan Perak'),
('12.07.24.2001','Hamparan Perak'),
('12.07.24.2002','Sei Baharu'),
('12.07.24.2003','Klumpang Kebun'),
('12.07.24.2004','Klumpang Kampung'),
('12.07.24.2005','Klambir Lima Kampung'),
('12.07.24.2006','Tandam Hulu II'),
('12.07.24.2007','Klambir'),
('12.07.24.2008','Selemak'),
('12.07.24.2009','Klambir Lima Kebun'),
('12.07.24.2010','Sialang Muda'),
('12.07.24.2011','Paya Bakung'),
('12.07.24.2012','Tandem Hulu I'),
('12.07.24.2013','Tandem Hilir I'),
('12.07.24.2014','Tandam Hilir II'),
('12.07.24.2015','Kota Datar'),
('12.07.24.2016','Bulu Cina'),
('12.07.24.2017','Kota Rantang'),
('12.07.24.2018','Paluh Manan'),
('12.07.24.2019','Lama'),
('12.07.24.2020','Paluh Kurau'),
('12.07.25','Labuhan Deli'),
('12.07.25.2001','Helvetia'),
('12.07.25.2002','Manunggal'),
('12.07.25.2003','Pematang Johar'),
('12.07.25.2004','Karang Gading'),
('12.07.25.2005','Telaga Tujuh'),
('12.07.26','Percut Sei Tuan'),
('12.07.26.1019','Kenangan'),
('12.07.26.1020','Kenangan Baru'),
('12.07.26.2001','Pematang Lalang'),
('12.07.26.2002','Sambirejo Timur'),
('12.07.26.2003','Kolam'),
('12.07.26.2004','Percut'),
('12.07.26.2005','Laut Dendang'),
('12.07.26.2006','Tembung'),
('12.07.26.2007','Cinta Rakyat'),
('12.07.26.2008','Amplas'),
('12.07.26.2009','Saentis'),
('12.07.26.2010','Sampali'),
('12.07.26.2011','Bandar Khalipah'),
('12.07.26.2012','Bandar Klippa'),
('12.07.26.2013','Tanjung Selamat'),
('12.07.26.2014','Tanjung Rejo'),
('12.07.26.2015','Medan Estate'),
('12.07.26.2016','Cinta Damai'),
('12.07.26.2017','Bandar Setia'),
('12.07.26.2018','Sei Rotan'),
('12.07.27','Batang Kuis'),
('12.07.27.2001','Sena'),
('12.07.27.2002','Tumpatan Nibung'),
('12.07.27.2003','Tanjung Sari'),
('12.07.27.2004','Baru'),
('12.07.27.2005','Batangkuis Pekan'),
('12.07.27.2006','Sidodadi'),
('12.07.27.2007','Bintang Meriah'),
('12.07.27.2008','Bakaran Batu'),
('12.07.27.2009','Paya Gambar'),
('12.07.27.2010','Mesjid'),
('12.07.27.2011','Sugiharjo'),
('12.07.28','Lubuk Pakam'),
('12.07.28.1007','Lubuk Pakam I,II'),
('12.07.28.1008','Lubuk Pakam III'),
('12.07.28.1009','Paluh Kemiri'),
('12.07.28.1010','Cemara'),
('12.07.28.1011','Syahmad'),
('12.07.28.1012','Petapahan'),
('12.07.28.1013','Lubuk Pakam Pekan'),
('12.07.28.2001','Sekip'),
('12.07.28.2002','Pagar Jati'),
('12.07.28.2003','Tanjung Garbus I'),
('12.07.28.2004','Pasar Melintang'),
('12.07.28.2005','Pagar Merbau III'),
('12.07.28.2006','Bakaran Batu'),
('12.07.31','Pagar Merbau'),
('12.07.31.2001','Tanjung Mulia'),
('12.07.31.2002','Purwodadi'),
('12.07.31.2003','Sidodadi Batu 8'),
('12.07.31.2004','Suka Mulia'),
('12.07.31.2005','Jati Rejo'),
('12.07.31.2006','Pagar Merbau I'),
('12.07.31.2007','Pagar Merbau II'),
('12.07.31.2008','Sidoharjo-I Pasar Miring'),
('12.07.31.2009','Sidoharjo-I Jati Baru'),
('12.07.31.2010','Bandar Dolok'),
('12.07.31.2011','Tanjung Garbus II'),
('12.07.31.2012','Tanjung Garbus Kampung'),
('12.07.31.2013','Perbarakan'),
('12.07.31.2014','Sukamandi Hilir'),
('12.07.31.2015','Sukamandi Hulu'),
('12.07.31.2016','Sumberejo'),
('12.07.32','Pantai Labu'),
('12.07.32.2001','Sei Tuan'),
('12.07.32.2002','Tengah'),
('12.07.32.2003','Bagan Serdang'),
('12.07.32.2004','Rantau Panjang'),
('12.07.32.2005','Rugemuk'),
('12.07.32.2006','Kubah Sentang'),
('12.07.32.2007','Pantai Labu Pekan'),
('12.07.32.2008','Pantai Labu Baru'),
('12.07.32.2009','Ramunia 1'),
('12.07.32.2010','Ramunia 2'),
('12.07.32.2011','Perkebunan Ramunia'),
('12.07.32.2012','Denai Lama'),
('12.07.32.2013','Denai Kuala'),
('12.07.32.2014','Denai Sarang Burung'),
('12.07.32.2015','Binjai Bakung'),
('12.07.32.2016','Paluh Sibaji'),
('12.07.32.2017','Kelambir'),
('12.07.32.2018','Durian'),
('12.07.32.2019','Pematang Biara'),
('12.07.33','Beringin'),
('12.07.33.2001','Serdang'),
('12.07.33.2002','Sidourip'),
('12.07.33.2003','Aras Kabu'),
('12.07.33.2004','Pasar VI Kuala Namu'),
('12.07.33.2005','Emplasmen Kuala Namu'),
('12.07.33.2006','Pasar V Kebun Kelapa'),
('12.07.33.2007','Beringin'),
('12.07.33.2008','Sidoarjo II Ramunia'),
('12.07.33.2009','Karang Anyar'),
('12.07.33.2010','Sidodadi Ramunia'),
('12.07.33.2011','Tumpatan'),
('12.08','Kabupaten Simalungun'),
('12.08.01','Siantar'),
('12.08.01.2001','Silampuyang'),
('12.08.01.2002','Marihat Baris'),
('12.08.01.2003','Dolok Marlawan'),
('12.08.01.2004','Rambung Merah'),
('12.08.01.2005','Silou Manik'),
('12.08.01.2006','Sejahtera'),
('12.08.01.2007','Siantar Estate'),
('12.08.01.2008','Karang Bangun'),
('12.08.01.2009','Nusa Harapan'),
('12.08.01.2010','Sitalasari'),
('12.08.01.2011','Lestari Indah'),
('12.08.01.2012','Laras Dua'),
('12.08.01.2013','Dolok Hataran'),
('12.08.01.2014','Pantoan Maju'),
('12.08.01.2015','Pamatang Simalungun'),
('12.08.01.2016','Silau Malaha'),
('12.08.01.2017','Pamatang Silampuyang'),
('12.08.02','Gunung Malela'),
('12.08.02.2001','Dolog Malela'),
('12.08.02.2002','Senio'),
('12.08.02.2003','Pamatang Asilom'),
('12.08.02.2004','Serapuh'),
('12.08.02.2005','Margo Mulyo'),
('12.08.02.2006','Silulu'),
('12.08.02.2007','Silou Malela'),
('12.08.02.2008','Bandar Siantar'),
('12.08.02.2009','Pamatang Gajing'),
('12.08.02.2010','Bangun'),
('12.08.02.2011','Malela'),
('12.08.02.2012','Bukit Maraja'),
('12.08.02.2013','Pamatang Sahkuda'),
('12.08.02.2014','Marihat Bukit'),
('12.08.02.2015','Sahkuda Bayu'),
('12.08.02.2016','Lingga'),
('12.08.03','Gunung Maligas'),
('12.08.03.2001','Silou Bayu'),
('12.08.03.2002','Karang Anyer'),
('12.08.03.2003','Karang Rejo'),
('12.08.03.2004','Karang Sari'),
('12.08.03.2005','Tumorang'),
('12.08.03.2006','Rabuhit'),
('12.08.03.2007','Huta Dipar'),
('12.08.03.2008','Ganjing'),
('12.08.03.2009','Bandar Malela'),
('12.08.04','Panei'),
('12.08.04.1011','Panei Tongah'),
('12.08.04.2001','Janggir Leto'),
('12.08.04.2002','Simpang Pane Raya'),
('12.08.04.2003','Siborna'),
('12.08.04.2004','Sipoldas'),
('12.08.04.2005','Bangun Rakyat'),
('12.08.04.2006','Sigodang'),
('12.08.04.2007','Sigodang Barat'),
('12.08.04.2008','Bah Bolon Tongah'),
('12.08.04.2009','Mekar Sari Raya'),
('12.08.04.2010','Simantin Pane Dame'),
('12.08.04.2012','Simpang Raya Dasma'),
('12.08.04.2013','Bangun Das Mariah'),
('12.08.04.2014','Bangun Sitolu Bah'),
('12.08.04.2015','Bah Liran Siborna'),
('12.08.04.2016','Nauli Baru'),
('12.08.04.2017','Rawang Pardomuan Nauli'),
('12.08.05','Panombeian Panei'),
('12.08.05.2001','Panombeian'),
('12.08.05.2002','Pamatang Panombeian'),
('12.08.05.2003','Nagori Bosar'),
('12.08.05.2004','Marjandi'),
('12.08.05.2005','Simpang Panei'),
('12.08.05.2006','Talun Kondot'),
('12.08.05.2007','Simbolon Tengkoh'),
('12.08.05.2008','Pamatang Panei'),
('12.08.05.2009','Marjandi Pisang'),
('12.08.05.2010','Banuh Raya'),
('12.08.05.2011','Rukun Mulyo'),
('12.08.06','Jorlang Hataran'),
('12.08.06.1008','Tiga Balata'),
('12.08.06.2001','Kasindir'),
('12.08.06.2002','Sibunga Bunga'),
('12.08.06.2003','Jorlang Hataran'),
('12.08.06.2004','Bah Sampuran'),
('12.08.06.2005','Bah Birong Ulu'),
('12.08.06.2006','Pinang Ratus'),
('12.08.06.2007','Dolok Marlawan'),
('12.08.06.2009','Panombean Hutaurung'),
('12.08.06.2010','Dipar Hataran'),
('12.08.06.2011','Pagar Pinang'),
('12.08.06.2012','Dolok Parriasan'),
('12.08.06.2013','Parmonangan'),
('12.08.07','Raya Kahean'),
('12.08.07.1008','Sindar Raya'),
('12.08.07.2001','Sambosar Raya'),
('12.08.07.2002','Panduman'),
('12.08.07.2003','Ambarokan Panei Raya'),
('12.08.07.2004','Bah Tonang'),
('12.08.07.2005','Bah Bulian'),
('12.08.07.2006','Bangun Raya'),
('12.08.07.2007','Durian Banggal'),
('12.08.07.2008','Sorba Dolog'),
('12.08.07.2009','Gunung Datas'),
('12.08.07.2010','Puli Buah'),
('12.08.07.2011','Banu Raya'),
('12.08.07.2012','Marubun Siboras'),
('12.08.07.2013','Banjaran'),
('12.08.08','Bosar Maligas'),
('12.08.08.1013','Bosar Maligas'),
('12.08.08.2001','Parbutaran'),
('12.08.08.2002','Mayang'),
('12.08.08.2003','Boluk'),
('12.08.08.2004','Sei Mangkei'),
('12.08.08.2005','Gunung Bayu'),
('12.08.08.2006','Talun Saragih'),
('12.08.08.2007','Dusun Pengkolan'),
('12.08.08.2008','Sei Torop'),
('12.08.08.2009','Marihat Tanjung'),
('12.08.08.2010','Marihat Butar'),
('12.08.08.2011','Teladan'),
('12.08.08.2012','Adil Makmur'),
('12.08.08.2014','Tempel Jaya'),
('12.08.08.2015','Sidomulyo'),
('12.08.08.2016','Mekar Rejo'),
('12.08.08.2017','Nanggar Bayu'),
('12.08.09','Sidamanik'),
('12.08.09.1013','Sarimatondang'),
('12.08.09.2001','Bah Butong I'),
('12.08.09.2002','Sidamanik'),
('12.08.09.2003','Ambarisan'),
('12.08.09.2004','Tiga Bolon'),
('12.08.09.2005','Bah Butong II'),
('12.08.09.2006','Bahal Gajah'),
('12.08.09.2007','Manik Hataran'),
('12.08.09.2008','Mekar Sidamanik'),
('12.08.09.2009','Manik Maraja'),
('12.08.09.2010','Bah Biak'),
('12.08.09.2011','Birong Ulu Manriah'),
('12.08.09.2012','Kebun Sayur Bah Butong'),
('12.08.09.2014','Manik Rambung'),
('12.08.09.2015','Bukit Rejo'),
('12.08.10','Pamatang Sidamanik'),
('12.08.10.1009','Sipolha Horisan'),
('12.08.10.2001','Sait Buttu Saribu'),
('12.08.10.2002','Pamatang Sidamanik'),
('12.08.10.2003','Sarimattin'),
('12.08.10.2004','Bandar Manik'),
('12.08.10.2005','Jorlang Huluan'),
('12.08.10.2006','Sihaporas'),
('12.08.10.2007','Pematang Tambun Raya'),
('12.08.10.2008','Simantin'),
('12.08.10.2010','Gorak'),
('12.08.11','Tanah Jawa'),
('12.08.11.1018','Pematang Tanah Jawa'),
('12.08.11.2001','Tanjung Pasir'),
('12.08.11.2002','Totap Majawa'),
('12.08.11.2003','Balimbingan'),
('12.08.11.2004','Baja Dolok'),
('12.08.11.2005','Bosar Galugur'),
('12.08.11.2006','Bah Jambi II'),
('12.08.11.2007','Bah Kisat'),
('12.08.11.2008','Panombeian Marjanji'),
('12.08.11.2009','Muara Mulia'),
('12.08.11.2010','Pardamean Asih'),
('12.08.11.2011','Mekar Mulia'),
('12.08.11.2012','Maligas Tongah'),
('12.08.11.2013','Marubun Jaya'),
('12.08.11.2014','Pagar Jambi'),
('12.08.11.2015','Baliju'),
('12.08.11.2016','Bayu Bagasan'),
('12.08.11.2017','Bah Jambi III'),
('12.08.11.2019','Parbalogan'),
('12.08.11.2020','Marubun Bayu'),
('12.08.12','Hatonduhan'),
('12.08.12.2001','Buntu Bayu'),
('12.08.12.2002','Bosar Nauli'),
('12.08.12.2003','Tangga Batu'),
('12.08.12.2004','Buntu Turunan'),
('12.08.12.2005','Saribu Asih'),
('12.08.12.2006','Jawa Tongah'),
('12.08.12.2007','Tonduhan'),
('12.08.12.2008','Parhundalian Jawa Dipar'),
('12.08.12.2009','Jawa Tongah II'),
('12.08.13','Dolok Panribuan'),
('12.08.13.2001','Negeri Dolok'),
('12.08.13.2002','Dolok Parmonangan'),
('12.08.13.2003','Dolok Tomuan'),
('12.08.13.2004','Marihat Dolok'),
('12.08.13.2005','Tiga Dolok'),
('12.08.13.2006','Ujung Bondar'),
('12.08.13.2007','Marihat Raja'),
('12.08.13.2008','Bandar Dolok'),
('12.08.13.2009','Gunung Mariah'),
('12.08.13.2010','Siatasan'),
('12.08.13.2011','Marihat Marsada'),
('12.08.13.2012','Pondok Buluh'),
('12.08.13.2013','Marihat Pondok'),
('12.08.13.2014','Lumban Gorat'),
('12.08.13.2015','Palia Naopat'),
('12.08.14','Purba'),
('12.08.14.1008','Tiga Runggu'),
('12.08.14.2001','Purba Tongah'),
('12.08.14.2002','Pematang Purba'),
('12.08.14.2003','Urung Purba'),
('12.08.14.2004','Purba Sipinggan'),
('12.08.14.2005','Hinalang'),
('12.08.14.2006','Purba Dolok'),
('12.08.14.2007','Tano Tinggir'),
('12.08.14.2009','Saribu Jandi'),
('12.08.14.2010','Huta Raja'),
('12.08.14.2011','Bandar Sauhur'),
('12.08.14.2012','Bunga Sampang'),
('12.08.14.2013','Nagori Tongah'),
('12.08.14.2014','Urung Pane'),
('12.08.15','Haranggaol Horisan'),
('12.08.15.1005','Haranggaol'),
('12.08.15.2001','Nagori Purba'),
('12.08.15.2002','Nagori Sihalpe'),
('12.08.15.2003','Purba Horisan'),
('12.08.15.2004','Purba Pasir'),
('12.08.16','Girsang Sipangan Bolon'),
('12.08.16.1003','Girsang'),
('12.08.16.1004','Parapat'),
('12.08.16.1005','Tiga Raja'),
('12.08.16.2001','Sipangan Bolon'),
('12.08.16.2002','Sibaganding'),
('12.08.16.2006','Sipangan Bolon Mekar'),
('12.08.17','Dolok Batu Nanggar'),
('12.08.17.1015','Serbelawan'),
('12.08.17.1016','Aman Sari'),
('12.08.17.2001','Silenduk'),
('12.08.17.2002','Bah Tobu'),
('12.08.17.2003','Bandar Selamat'),
('12.08.17.2004','Dolok Ilir I'),
('12.08.17.2005','Dolok Ilir II'),
('12.08.17.2006','Bahung Kahean'),
('12.08.17.2007','Dolok Mainu'),
('12.08.17.2008','Dolok Merangir I'),
('12.08.17.2009','Dolok Merangir II'),
('12.08.17.2010','Kahean'),
('12.08.17.2011','Dolok Tenera'),
('12.08.17.2012','Dolok Kataran'),
('12.08.17.2013','Padang Mainu'),
('12.08.17.2014','Bahung Huluan'),
('12.08.18','Hutabayu Raja'),
('12.08.18.1013','Huta Bayu'),
('12.08.18.2001','Mariah Hombang'),
('12.08.18.2002','Pulo Bayu'),
('12.08.18.2003','Silakkidir'),
('12.08.18.2004','Raja Maligas'),
('12.08.18.2005','Dolok Sinumbah'),
('12.08.18.2006','Maligas Bayu'),
('12.08.18.2007','Jawa Baru'),
('12.08.18.2008','Mancuk'),
('12.08.18.2009','Marihat Mayang'),
('12.08.18.2010','Bosar Bayu'),
('12.08.18.2011','Raja Maligas I'),
('12.08.18.2012','Bahal Batu'),
('12.08.18.2014','Pokan Baru'),
('12.08.18.2015','Manrayap Bayu'),
('12.08.18.2016','Talang Bayu'),
('12.08.19','Jawa Maraja Bah Jambi'),
('12.08.19.2001','Jawa Maraja'),
('12.08.19.2002','Moho'),
('12.08.19.2003','Bahalat Bayu'),
('12.08.19.2004','Mekar Bahalat'),
('12.08.19.2005','Tanjung Maraja'),
('12.08.19.2006','Mariah Jambi'),
('12.08.19.2007','Bah Joga'),
('12.08.19.2008','Bah Jambi'),
('12.08.20','Dolok Pardamean'),
('12.08.20.2001','Tigaras'),
('12.08.20.2002','Parik Sabungan'),
('12.08.20.2003','Sibuntuon'),
('12.08.20.2004','Dolok Saribu'),
('12.08.20.2007','Buntu Bayu Panei Raja'),
('12.08.20.2009','Silabah Jaya'),
('12.08.20.2010','Togu Domu Nauli'),
('12.08.20.2011','Sirube-rube Gunung Purba'),
('12.08.20.2014','Tanjung Saribu'),
('12.08.20.2015','Sihemun Baru'),
('12.08.20.2016','Nagori Bayu'),
('12.08.21','Pematang Bandar'),
('12.08.21.1009','Kerasaan I'),
('12.08.21.1010','Pematang Bandar'),
('12.08.21.2001','Purwosari'),
('12.08.21.2002','Talun Madear'),
('12.08.21.2003','Mariah Bandar'),
('12.08.21.2004','Kandangan'),
('12.08.21.2005','Pardomuan Nauli'),
('12.08.21.2006','Purba Ganda'),
('12.08.21.2007','Kerasaan II'),
('12.08.21.2008','Bandar Manis'),
('12.08.21.2011','Wonorejo'),
('12.08.21.2012','Talun Rejo'),
('12.08.21.2013','Purwodadi'),
('12.08.22','Bandar Huluan'),
('12.08.22.2001','Naga Jaya I'),
('12.08.22.2002','Bah Gunung'),
('12.08.22.2003','Bandar Tongah'),
('12.08.22.2004','Dolog Parmonangan'),
('12.08.22.2005','Laras'),
('12.08.22.2006','Naga Jaya II'),
('12.08.22.2007','Tanjung Hataran'),
('12.08.22.2008','Bandar Betsy I'),
('12.08.22.2009','Bandar Betsy II'),
('12.08.22.2010','Naga Soppa'),
('12.08.23','Bandar'),
('12.08.23.1014','Perdagangan I'),
('12.08.23.1015','Perdagangan III'),
('12.08.23.2001','Pematang Kerasaan'),
('12.08.23.2002','Marihat Bandar'),
('12.08.23.2003','Nagori Bandar'),
('12.08.23.2004','Bandar Rakyat'),
('12.08.23.2005','Bandar Pulo'),
('12.08.23.2006','Bah Lias'),
('12.08.23.2007','Perdagangan II'),
('12.08.23.2008','Perlanaan'),
('12.08.23.2009','Sugarang Bayu'),
('12.08.23.2010','Pem Kerasaan Rejo'),
('12.08.23.2011','Timbaan'),
('12.08.23.2012','Bandar Jawa'),
('12.08.23.2013','Sidotani'),
('12.08.23.2016','Landbouw'),
('12.08.24','Bandar Masilam'),
('12.08.24.2001','Bandar Masilam'),
('12.08.24.2002','Lias Baru'),
('12.08.24.2003','Bandar Silou'),
('12.08.24.2004','Panombeian Baru'),
('12.08.24.2005','Gunung Serawan'),
('12.08.24.2006','Bandar Masilam II'),
('12.08.24.2007','Partimbalan'),
('12.08.24.2008','Bandar Tinggi'),
('12.08.24.2009','Bandar Rejo'),
('12.08.24.2010','Bandar Gunung'),
('12.08.25','Silimakuta'),
('12.08.25.1012','Saribu Dolok'),
('12.08.25.2003','Bangun Mariah'),
('12.08.25.2004','Purba Sinombah'),
('12.08.25.2006','Purba Tua'),
('12.08.25.2009','Purba Tua Baru'),
('12.08.25.2014','Sinar Baru'),
('12.08.25.2016','Purba Tua Etek'),
('12.08.26','Dolok Silao'),
('12.08.26.2001','Cingkes'),
('12.08.26.2002','Panribuan'),
('12.08.26.2003','Saran Padang'),
('12.08.26.2004','Mariah Dolok'),
('12.08.26.2005','Marubun Lokkung'),
('12.08.26.2006','Dolok Mariah'),
('12.08.26.2007','Bawang'),
('12.08.26.2008','Huta Saing'),
('12.08.26.2009','Togur'),
('12.08.26.2010','Perasmian'),
('12.08.26.2011','Tanjung Purba'),
('12.08.26.2012','Silau Marawan'),
('12.08.26.2013','Bosi Sinombah'),
('12.08.26.2014','Ujung Bawang'),
('12.08.27','Silou Kahean'),
('12.08.27.2001','Simanabun'),
('12.08.27.2002','Pardomuan Tongah'),
('12.08.27.2003','Nagori Dolok'),
('12.08.27.2004','Bandar Maruhur'),
('12.08.27.2005','Silou Dunia'),
('12.08.27.2006','Dolok Marawa'),
('12.08.27.2007','Mariah Buttu'),
('12.08.27.2008','Dolok Saribu Bangun'),
('12.08.27.2009','Bandar Nagori'),
('12.08.27.2010','Silou Paribuan'),
('12.08.27.2011','Buttu Bayu'),
('12.08.27.2012','Nagori Tani'),
('12.08.27.2013','Bah Sarimah'),
('12.08.27.2014','Damaritang'),
('12.08.27.2015','Sinasih'),
('12.08.27.2016','Pardomuan Bandar'),
('12.08.28','Tapian Dolok'),
('12.08.28.1009','Sinaksak'),
('12.08.28.2001','Batu Silangit'),
('12.08.28.2002','Dolok Maraja'),
('12.08.28.2003','Dolok Ulu'),
('12.08.28.2004','Nagur Usang'),
('12.08.28.2005','Dolok Kahean'),
('12.08.28.2006','Naga Dolok'),
('12.08.28.2007','Purbasari'),
('12.08.28.2008','Pematang Dolok Kahean'),
('12.08.28.2010','Negeri Bayu Muslimin'),
('12.08.28.2011','Dolok Simbolon'),
('12.08.29','Raya'),
('12.08.29.1001','Merek Raya'),
('12.08.29.1002','Dalig Raya'),
('12.08.29.1005','Sondi Raya'),
('12.08.29.1011','Pamatang Raya'),
('12.08.29.1018','Baringin Raya'),
('12.08.29.2004','Raya Bayu'),
('12.08.29.2007','Bahapal Raya'),
('12.08.29.2010','Siporkas'),
('12.08.29.2012','Sihubu Raya'),
('12.08.29.2013','Raya Bosi'),
('12.08.29.2014','Silou Huluan'),
('12.08.29.2015','Silou Buttu'),
('12.08.29.2016','Bongguron Kariahan'),
('12.08.29.2017','Simbou Baru'),
('12.08.29.2020','Dame Raya'),
('12.08.29.2021','Limag Raya'),
('12.08.29.2022','Lokkung Raya'),
('12.08.30','Ujung Padang'),
('12.08.30.1001','Ujung Padang'),
('12.08.30.2002','Huta Parik'),
('12.08.30.2003','Dusun Ulu'),
('12.08.30.2004','Tinjowan'),
('12.08.30.2005','Sayur Matinggi'),
('12.08.30.2006','Taratak Nagodang'),
('12.08.30.2007','Sordang Bolon'),
('12.08.30.2008','Teluk Lapian'),
('12.08.30.2009','Tanjung Rapuan'),
('12.08.30.2010','Pagar Bosi'),
('12.08.30.2011','Bangun Sordang'),
('12.08.30.2012','Aek Gerger Sidodadi'),
('12.08.30.2013','Pulo Pitu Marihat'),
('12.08.30.2014','Siringan Ringan'),
('12.08.30.2015','Riah Na Poso'),
('12.08.30.2016','Sei Merbau'),
('12.08.30.2017','Kampung Lalang'),
('12.08.30.2018','Sordang Baru'),
('12.08.30.2019','Banjar Hulu'),
('12.08.30.2020','Rawa Masin'),
('12.08.31','Pamatang Silima Huta'),
('12.08.31.2001','Ujung Saribu'),
('12.08.31.2002','Silimakuta Barat'),
('12.08.31.2003','Siboras'),
('12.08.31.2004','Mardingding'),
('12.08.31.2005','Naga Saribu'),
('12.08.31.2007','Saribu Jandi'),
('12.08.31.2008','Sinar Naga Mariah'),
('12.08.31.2009','Ujung Mariah'),
('12.08.31.2010','Bandar Saribu'),
('12.08.31.2011','Naga Bosar'),
('12.08.32','Dolog Masagal'),
('12.08.32.2001','Raya Huluan'),
('12.08.32.2002','Dolog Huluan'),
('12.08.32.2003','Bintang Mariah'),
('12.08.32.2004','Bah Bolon'),
('12.08.32.2005','Raya Usang'),
('12.08.32.2006','Bangun Pane'),
('12.08.32.2007','Parjalangan'),
('12.08.32.2008','Partuahan'),
('12.08.32.2009','Sinaman Labah'),
('12.08.32.2010','Pamatang Sinaman'),
('12.09','Kabupaten Asahan'),
('12.09.08','Meranti'),
('12.09.08.2002','Meranti'),
('12.09.08.2004','Perkebunan Sei Balai'),
('12.09.08.2011','Sei Beluru'),
('12.09.08.2012','Serdang'),
('12.09.08.2019','Gajah'),
('12.09.08.2021','Air Putih'),
('12.09.08.2022','Sukajadi'),
('12.09.09','Air Joman'),
('12.09.09.1001','Binjai Serbangan'),
('12.09.09.2002','Air Joman'),
('12.09.09.2003','Air Joman Baru'),
('12.09.09.2005','Banjar'),
('12.09.09.2007','Pasar Lembu'),
('12.09.09.2008','Punggulan'),
('12.09.09.2012','Subur'),
('12.09.10','Tanjung Balai'),
('12.09.10.2001','Asahan Mati'),
('12.09.10.2002','Bagan Asahan'),
('12.09.10.2003','Bagan Asahan Baru'),
('12.09.10.2004','Bagan Asahan Pekan'),
('12.09.10.2005','Kapias Batu VIII'),
('12.09.10.2006','Pematang Sei Baru'),
('12.09.10.2007','Sei Apung'),
('12.09.10.2008','Sei Apung Jaya'),
('12.09.11','Sei Kepayang'),
('12.09.11.2008','Sei Kepayang Tengah'),
('12.09.11.2010','Sei Kepayang Kanan'),
('12.09.11.2011','Sei Paham'),
('12.09.11.2014','Pertahanan'),
('12.09.11.2015','Perbangunan'),
('12.09.11.2016','Bangun Baru'),
('12.09.12','Simpang Empat'),
('12.09.12.2002','Perkebunan Suka Raja'),
('12.09.12.2004','Perkebunan Hessa'),
('12.09.12.2006','Sei Dua Hulu'),
('12.09.12.2007','Sei Lama'),
('12.09.12.2008','Silomlom'),
('12.09.12.2009','Simpang Empat'),
('12.09.12.2012','Sipaku Area'),
('12.09.12.2013','Anjung Ganjang'),
('12.09.13','Air Batu'),
('12.09.13.2001','Sei Alim Ulu'),
('12.09.13.2003','Pinanggiripan'),
('12.09.13.2006','Perkebunan Pulahan'),
('12.09.13.2007','Hessa Perlompongan'),
('12.09.13.2008','Perkebunan Air Batu I/II'),
('12.09.13.2009','Perkebunan Air Batu III/IX'),
('12.09.13.2010','Danau Sijabut'),
('12.09.13.2012','Air Teluk Hessa'),
('12.09.13.2013','Air Genting'),
('12.09.13.2014','Hessa Air Genting'),
('12.09.13.2018','Sijabut Teratai'),
('12.09.13.2019','Pulau Pule'),
('12.09.14','Pulau Rakyat'),
('12.09.14.2001','Sei Piring'),
('12.09.14.2002','Pulau Rakyat Tua'),
('12.09.14.2003','Pulau Rakyat Pekan'),
('12.09.14.2004','Orika'),
('12.09.14.2005','Manis'),
('12.09.14.2006','Tunggul 45'),
('12.09.14.2007','Bangun'),
('12.09.14.2008','Persatuan'),
('12.09.14.2009','Padang Mahondang'),
('12.09.14.2010','Ofa Padang Mahondang'),
('12.09.14.2011','Baru'),
('12.09.14.2012','Mekar Sari'),
('12.09.15','Bandar Pulau'),
('12.09.15.2003','Bandar Pulau Pekan'),
('12.09.15.2005','Buntu Maraja'),
('12.09.15.2006','Gonting Malaha'),
('12.09.15.2010','Padang Pulau'),
('12.09.15.2012','Perkebunan Aek Tarum'),
('12.09.15.2016','Perkebunan Padang Pulau'),
('12.09.15.2019','Huta Rao'),
('12.09.15.2020','Aek Nagali'),
('12.09.15.2021','Gajah Sakti'),
('12.09.15.2022','Gunung Berkat'),
('12.09.16','Buntu Pane'),
('12.09.16.2001','Ambalutu'),
('12.09.16.2002','Buntu Pane'),
('12.09.16.2003','Lestari'),
('12.09.16.2005','Prapat Janji'),
('12.09.16.2007','Sei Silau Timur'),
('12.09.16.2016','Sionggang'),
('12.09.16.2017','Mekar Sari'),
('12.09.16.2018','Perkebunan Sei Silau'),
('12.09.16.2019','Karya Ambalutu'),
('12.09.17','Bandar Pasir Mandoge'),
('12.09.17.2001','Bandar Pasir Mandoge'),
('12.09.17.2002','Huta Bagasan'),
('12.09.17.2003','Sei Nadoras'),
('12.09.17.2004','Silau Jawa'),
('12.09.17.2005','Suka Makmur'),
('12.09.17.2006','Sei Kopas'),
('12.09.17.2007','Huta Padang'),
('12.09.17.2008','Tomuan Holbung'),
('12.09.17.2009','Gotting Sidodadi'),
('12.09.18','Aek Kuasan'),
('12.09.18.1001','Aek Loba Pekan'),
('12.09.18.2002','Aek Loba Afd I'),
('12.09.18.2003','Alang Bonbon'),
('12.09.18.2009','Sengon Sari'),
('12.09.18.2010','Lobu Jiur'),
('12.09.18.2011','Rawa Sari'),
('12.09.18.2013','Aek Loba'),
('12.09.19','Kota Kisaran Barat'),
('12.09.19.1001','Bunut'),
('12.09.19.1002','Bunut Barat'),
('12.09.19.1003','Dadimulyo'),
('12.09.19.1004','Kisaran Barat'),
('12.09.19.1005','Kisaran Baru'),
('12.09.19.1006','Kisaran Kota'),
('12.09.19.1007','Mekar Baru'),
('12.09.19.1008','Sei Renggas'),
('12.09.19.1009','Sendang Sari'),
('12.09.19.1010','Sidodadi'),
('12.09.19.1011','Sidomukti'),
('12.09.19.1012','Tebing Kisaran'),
('12.09.19.1013','Tegal Sari'),
('12.09.20','Kota Kisaran Timur'),
('12.09.20.1001','Teladan'),
('12.09.20.1002','Siumbut Umbut'),
('12.09.20.1003','Siumbut Baru'),
('12.09.20.1004','Sentang'),
('12.09.20.1005','Selawan'),
('12.09.20.1006','Mutiara'),
('12.09.20.1007','Lestari'),
('12.09.20.1008','Kisaran Timur'),
('12.09.20.1009','Kisaran Naga'),
('12.09.20.1010','Kedai Ledang'),
('12.09.20.1011','Karang Anyer'),
('12.09.20.1012','Gambir Baru'),
('12.09.21','Aek Songsongan'),
('12.09.21.2001','Aek Songsongan'),
('12.09.21.2002','Perkebunan Bandar Selamat'),
('12.09.21.2003','Perkebunan Bandar Pulau'),
('12.09.21.2004','Aek Bamban'),
('12.09.21.2005','Marjanji Aceh'),
('12.09.21.2006','Lobu Rappa'),
('12.09.21.2007','Tangga'),
('12.09.21.2008','Situnjak'),
('12.09.21.2009','Mekar Marjanji'),
('12.09.22','Rahuning'),
('12.09.22.2001','Rahuning'),
('12.09.22.2002','Perkebunan Gunung Melayu'),
('12.09.22.2003','Gunung Melayu'),
('12.09.22.2004','Batu Anam'),
('12.09.22.2005','Perkebunan Aek Nagaga'),
('12.09.22.2006','Rahuning I'),
('12.09.22.2007','Rahuning II'),
('12.09.23','Sei Dadap'),
('12.09.23.2001','Tanjung Alam'),
('12.09.23.2002','Perkebunan Sei Dadap I/II'),
('12.09.23.2003','Perkebunan Sei Dadap III/IV'),
('12.09.23.2004','Sei Kamah I'),
('12.09.23.2005','Sei Kamah II'),
('12.09.23.2006','Bahung Sibatu-batu'),
('12.09.23.2007','Sei Alim Hasak'),
('12.09.23.2008','Tanjung Asri'),
('12.09.23.2009','Sei Kamah Baru'),
('12.09.23.2010','Pasiran'),
('12.09.24','Sei Kepayang Barat'),
('12.09.24.2001','Sei Nangka'),
('12.09.24.2002','Sei Jawi-Jawi'),
('12.09.24.2003','Sei Serindan'),
('12.09.24.2004','Sei Tualang Pandau'),
('12.09.24.2005','Sei Lendir'),
('12.09.24.2006','Sei Kepayang Kiri'),
('12.09.25','Sei Kepayang Timur'),
('12.09.25.2001','Sei Lunang'),
('12.09.25.2002','Sei Pasir'),
('12.09.25.2003','Sei Tempurung'),
('12.09.25.2004','Sarang Helang'),
('12.09.25.2005','Sei Sembilang'),
('12.09.26','Tinggi Raja'),
('12.09.26.2001','Tinggi Raja'),
('12.09.26.2002','Sumber Harapan'),
('12.09.26.2003','Terusan Tengah'),
('12.09.26.2004','Piasa Ulu'),
('12.09.26.2005','Sidomulyo'),
('12.09.26.2006','Teladan'),
('12.09.26.2007','Padang Sari'),
('12.09.27','Setia Janji'),
('12.09.27.2001','Urung Pane'),
('12.09.27.2002','Sei Silau Tua'),
('12.09.27.2003','Sei Silau Barat'),
('12.09.27.2004','Silau Maraja'),
('12.09.27.2005','Bangun Sari'),
('12.09.28','Silau Laut'),
('12.09.28.2001','Silo Baru'),
('12.09.28.2002','Silo Lama'),
('12.09.28.2003','Silo Bonto'),
('12.09.28.2004','Lubuk Palas'),
('12.09.28.2005','Bangun Sari'),
('12.09.29','Rawang Panca Arga'),
('12.09.29.2001','Rawang Lama'),
('12.09.29.2002','Rawang Baru'),
('12.09.29.2003','Rawang Pasar IV'),
('12.09.29.2004','Rawang Pasar V'),
('12.09.29.2005','Pondok Bungur'),
('12.09.29.2006','Panca Arga'),
('12.09.29.2007','Rawang Pasar VI'),
('12.09.30','Pulo Bandring'),
('12.09.30.2001','Suka Damai'),
('12.09.30.2002','Perhutaan Silau'),
('12.09.30.2003','Tanah Rakyat'),
('12.09.30.2004','Taman Sari'),
('12.09.30.2005','Gedangan'),
('12.09.30.2006','Suka Makmur'),
('12.09.30.2007','Pulo Bandring'),
('12.09.30.2008','Sidomulyo'),
('12.09.30.2009','Suka Damai Barat'),
('12.09.30.2010','Bunut Seberang'),
('12.09.31','Teluk Dalam'),
('12.09.31.2001','Air Teluk Kiri'),
('12.09.31.2002','Teluk Dalam'),
('12.09.31.2003','Perkebunan Teluk Dalam'),
('12.09.31.2004','Pulau Maria'),
('12.09.31.2005','Pulau Tanjung'),
('12.09.31.2006','Mekar Tanjung'),
('12.09.32','Aek Ledong'),
('12.09.32.2001','Aek Bange'),
('12.09.32.2002','Aek Korsik'),
('12.09.32.2003','Aek Ledong'),
('12.09.32.2004','Ledong Barat'),
('12.09.32.2005','Aek Nabuntu'),
('12.09.32.2006','Ledong Timur'),
('12.09.32.2007','Padang Sipirok'),
('12.10','Kabupaten Labuhanbatu'),
('12.10.01','Rantau Utara'),
('12.10.01.1001','Padang Matinggi'),
('12.10.01.1002','Siringo-Ringo'),
('12.10.01.1003','Sirandorung'),
('12.10.01.1004','Rantauprapat'),
('12.10.01.1005','Kartini'),
('12.10.01.1006','Cendana'),
('12.10.01.1007','Binaraga'),
('12.10.01.1008','Pulo Padang'),
('12.10.01.1009','Padang Bulan'),
('12.10.01.1010','Aek Paing'),
('12.10.02','Rantau Selatan'),
('12.10.02.1001','Bakaran Batu'),
('12.10.02.1002','Sioldengan'),
('12.10.02.1003','Urung Kompas'),
('12.10.02.1004','Ujung Bandar'),
('12.10.02.1005','Sigambal'),
('12.10.02.1006','Lobusona'),
('12.10.02.1007','Pardamean'),
('12.10.02.1008','Danau Bale'),
('12.10.02.1009','Sidorejo'),
('12.10.07','Bilah Barat'),
('12.10.07.2001','Sibargot'),
('12.10.07.2002','Bandar Kumbul'),
('12.10.07.2003','Tanjung Medan'),
('12.10.07.2004','Janji'),
('12.10.07.2005','Tebing Linggahara'),
('12.10.07.2006','AFD.I Rantauprapat'),
('12.10.07.2007','AFD.II Rantauprapat'),
('12.10.07.2008','Aek Buru Selatan'),
('12.10.07.2009','Kampung Baru'),
('12.10.07.2010','Tebing Linggahara Baru'),
('12.10.08','Bilah Hilir'),
('12.10.08.1001','Negeri Lama'),
('12.10.08.1002','Negeri Baru'),
('12.10.08.2003','Perkebunan Sennah'),
('12.10.08.2004','Perkebunan Negeri Lama'),
('12.10.08.2005','Perkebunan Bilah'),
('12.10.08.2006','Kampung Bilah'),
('12.10.08.2007','Negeri Lama Seberang'),
('12.10.08.2008','Sei Tampang'),
('12.10.08.2009','Selat Besar'),
('12.10.08.2010','Tanjung Haloban'),
('12.10.08.2011','Sidomulyo'),
('12.10.08.2012','Sei Tarolat'),
('12.10.08.2013','Sei Kasih'),
('12.10.09','Bilah Hulu'),
('12.10.09.2001','Lingga Tiga'),
('12.10.09.2002','Tanjung Siram'),
('12.10.09.2003','Pematang Seleng'),
('12.10.09.2004','Perbaungan'),
('12.10.09.2005','Gunung Selamat'),
('12.10.09.2006','Emplasemen Aek Nabara'),
('12.10.09.2007','Bandar Tinggi'),
('12.10.09.2008','Kampung Dalam'),
('12.10.09.2009','Pondok Batu'),
('12.10.09.2010','Meranti'),
('12.10.09.2011','N-1 Aek Nabara'),
('12.10.09.2012','N-2 Aek Nabara'),
('12.10.09.2013','N-3 Aek Nabara'),
('12.10.09.2014','N-4 Aek Nabara'),
('12.10.09.2015','N-5 Aek Nabara'),
('12.10.09.2016','N-6 Aek Nabara'),
('12.10.09.2017','N-7 Aek Nabara'),
('12.10.09.2018','N-8 Aek Nabara'),
('12.10.09.2019','S-1 Aek Nabara'),
('12.10.09.2020','S-2 Aek Nabara'),
('12.10.09.2021','S-3 Aek Nabara'),
('12.10.09.2022','S-4 Aek Nabara'),
('12.10.09.2023','S-5 Aek Nabara'),
('12.10.09.2024','S-6 Aek Nabara'),
('12.10.14','Pangkatan'),
('12.10.14.2001','Sidorukun'),
('12.10.14.2002','Tebing Tinggi Pangkatan'),
('12.10.14.2003','Perkebunan Pangkatan'),
('12.10.14.2004','Kampung Padang'),
('12.10.14.2005','Pangkatan'),
('12.10.14.2006','Sennah'),
('12.10.14.2007','Tanjung Harapan'),
('12.10.18','Panai Tengah'),
('12.10.18.1001','Labuhan Bilik'),
('12.10.18.2002','Sei Pelancang'),
('12.10.18.2003','Sei Siarti'),
('12.10.18.2004','Sei Nahodaris'),
('12.10.18.2005','Sei Merdeka'),
('12.10.18.2006','Sei Rakyat'),
('12.10.18.2007','Selat Beting'),
('12.10.18.2008','Bagan Bilah'),
('12.10.18.2009','Telaga Suka'),
('12.10.18.2010','Pasar Tiga'),
('12.10.19','Panai Hilir'),
('12.10.19.1001','Sei Berombang'),
('12.10.19.2002','Sei Penggantungan'),
('12.10.19.2003','Sei Lumut'),
('12.10.19.2004','Sei Tawar'),
('12.10.19.2005','Sei Sanggul'),
('12.10.19.2006','Sei Sakat'),
('12.10.19.2007','Sei Baru'),
('12.10.19.2008','Wonosari'),
('12.10.20','Panai Hulu'),
('12.10.20.2001','Tanjung Sarang Elang'),
('12.10.20.2002','Perkebunan Ajamu'),
('12.10.20.2003','Teluk Sentosa'),
('12.10.20.2004','Cinta Makmur'),
('12.10.20.2005','Sei Sentosa'),
('12.10.20.2006','Meranti Paham'),
('12.10.20.2007','Sei Jawi-Jawi'),
('12.11','Kabupaten Dairi'),
('12.11.01','Sidikalang'),
('12.11.01.1005','Kuta Gambir'),
('12.11.01.1007','Sidiangkat'),
('12.11.01.1009','Batang Beruh'),
('12.11.01.1010','Sidikalang'),
('12.11.01.1015','Bintang Hulu'),
('12.11.01.2008','Belang Malum'),
('12.11.01.2011','Huta Rakyat'),
('12.11.01.2012','Kalang'),
('12.11.01.2013','Bintang'),
('12.11.01.2014','Kalang Simbara'),
('12.11.01.2017','Bintang Mersada'),
('12.11.02','Sumbul'),
('12.11.02.1007','Pegagan Julu I'),
('12.11.02.2001','Pegagan Julu X'),
('12.11.02.2002','Pegagan Julu IX'),
('12.11.02.2003','Pegagan Julu VIII'),
('12.11.02.2004','Pegagan Julu VII'),
('12.11.02.2005','Pegagan Julu VI'),
('12.11.02.2006','Pegagan Julu V'),
('12.11.02.2008','Pegagan Julu IV'),
('12.11.02.2009','Pegagan Julu III'),
('12.11.02.2010','Pegagan Julu II'),
('12.11.02.2014','Tanjung Beringin'),
('12.11.02.2015','Dolok Tolong'),
('12.11.02.2017','Pargambiran'),
('12.11.02.2018','Perjuangan'),
('12.11.02.2020','Kuta Gugung'),
('12.11.02.2024','Sileuh-leuh Parsaoran'),
('12.11.02.2025','Barisan Nauli'),
('12.11.02.2026','Pangguruan'),
('12.11.02.2027','Tanjung Beringin I'),
('12.11.03','Tigalingga'),
('12.11.03.2001','Sumbul Tengah'),
('12.11.03.2002','Ujung Teran'),
('12.11.03.2003','Juma Gerat'),
('12.11.03.2004','Sarintonu'),
('12.11.03.2005','Tigalingga'),
('12.11.03.2006','Palding'),
('12.11.03.2007','Lau Bagot'),
('12.11.03.2008','Bertungen Julu'),
('12.11.03.2009','Lau Molgap'),
('12.11.03.2010','Lau Pak-Pak'),
('12.11.03.2012','Sukandebi'),
('12.11.03.2013','Lau Mil'),
('12.11.03.2014','Lau Sireme'),
('12.11.03.2019','Palding Jaya Sumbul'),
('12.11.04','Siempat Nempu'),
('12.11.04.2001','Sinampang'),
('12.11.04.2002','Sihorbo'),
('12.11.04.2003','Soban'),
('12.11.04.2004','Adian Nangka'),
('12.11.04.2005','Bunturaja'),
('12.11.04.2006','Juma Siulok'),
('12.11.04.2007','Juma Teguh'),
('12.11.04.2008','Sosor Lontung'),
('12.11.04.2009','Huta Imbaru'),
('12.11.04.2010','Jumantuang'),
('12.11.04.2011','Gomit'),
('12.11.04.2012','Adian Gupa'),
('12.11.04.2013','Maju'),
('12.11.05','Silima Pungga Pungga'),
('12.11.05.1014','Parongil'),
('12.11.05.2008','Palipi'),
('12.11.05.2010','Longkotan'),
('12.11.05.2011','Bongkaras'),
('12.11.05.2012','Tungtung Batu'),
('12.11.05.2013','Polling Anak-Anak'),
('12.11.05.2015','Siratah'),
('12.11.05.2016','Uruk Mblin'),
('12.11.05.2017','Siboras'),
('12.11.05.2018','Bonian'),
('12.11.05.2019','Sumbari'),
('12.11.05.2020','Bakal Gajah'),
('12.11.05.2021','Lae Panginuman'),
('12.11.05.2022','Lae Ambat'),
('12.11.05.2023','Lae Rambong'),
('12.11.05.2024','Lae Pangaroan'),
('12.11.06','Tanah Pinem'),
('12.11.06.2001','Sukadame'),
('12.11.06.2002','Gunung Tua'),
('12.11.06.2003','Harapan'),
('12.11.06.2004','Lau Primbon'),
('12.11.06.2005','Kuta Gamber'),
('12.11.06.2006','Kempawa'),
('12.11.06.2007','Tanah Pinem'),
('12.11.06.2008','Pamah'),
('12.11.06.2009','Kuta Buluh'),
('12.11.06.2010','Pasir Tengah'),
('12.11.06.2011','Renun'),
('12.11.06.2012','Lau Tawar'),
('12.11.06.2013','Balandua'),
('12.11.06.2014','Mangan Molih'),
('12.11.06.2015','Liang Jering'),
('12.11.06.2016','Alur Subur'),
('12.11.06.2017','Lau Njuhar I'),
('12.11.06.2018','Pasir Mbelang'),
('12.11.06.2019','Sinar Pagi'),
('12.11.07','Siempat Nempu Hulu'),
('12.11.07.2001','Tambahan'),
('12.11.07.2002','Kuta Tengah'),
('12.11.07.2003','Lae Nuaha'),
('12.11.07.2004','Sungai Raya'),
('12.11.07.2005','Gunung Meriah'),
('12.11.07.2006','Silumboyah'),
('12.11.07.2007','Pandan'),
('12.11.07.2008','Tualang'),
('12.11.07.2009','Pangaribuan'),
('12.11.07.2010','Sigambir-gambir'),
('12.11.07.2011','Bakal Julu'),
('12.11.07.2012','Sipoltong'),
('12.11.08','Siempat Nempu Hilir'),
('12.11.08.2001','Lae Itam'),
('12.11.08.2002','Lae Luhung'),
('12.11.08.2003','Pardomuan'),
('12.11.08.2004','Lae Markelang'),
('12.11.08.2005','Jambur Indonesia'),
('12.11.08.2006','Simungun'),
('12.11.08.2007','Janji'),
('12.11.08.2008','Sopo Butar'),
('12.11.08.2009','Lae Sering'),
('12.11.08.2010','Lae Haporas'),
('12.11.09','Pegagan Hilir'),
('12.11.09.2001','Simanduma'),
('12.11.09.2002','Bandar Huta Usang'),
('12.11.09.2003','Onan Lama'),
('12.11.09.2004','Lingga Raja'),
('12.11.09.2005','Laksa'),
('12.11.09.2006','Tanjung Saluksuk'),
('12.11.09.2007','Bukit Tinggi'),
('12.11.09.2008','Simartugan'),
('12.11.09.2009','Kuta Usang'),
('12.11.09.2010','Lingga Raja II'),
('12.11.09.2011','Mbinanga'),
('12.11.09.2012','Bukit Baru'),
('12.11.09.2013','Perrik Mbue'),
('12.11.10','Parbuluan'),
('12.11.10.2001','Bangun'),
('12.11.10.2002','Lae Hole'),
('12.11.10.2003','Parbuluan IV'),
('12.11.10.2004','Parbuluan III'),
('12.11.10.2005','Parbuluan II'),
('12.11.10.2006','Parbuluan I'),
('12.11.10.2007','Parbuluan V'),
('12.11.10.2008','Parbuluan VI'),
('12.11.10.2009','Lae Hole I'),
('12.11.10.2010','Lae Hole II'),
('12.11.10.2011','Bangun I'),
('12.11.11','Lae Parira'),
('12.11.11.2001','Sumbul'),
('12.11.11.2002','Kentara'),
('12.11.11.2003','Lae Parira'),
('12.11.11.2004','Buluduri'),
('12.11.11.2005','Sempung Polling'),
('12.11.11.2006','Lumban Sihite'),
('12.11.11.2007','Lumban Toruan'),
('12.11.11.2008','Pandiangan'),
('12.11.11.2009','Kaban Julu'),
('12.11.12','Gunung Sitember'),
('12.11.12.2001','Bukit Lau Kersik'),
('12.11.12.2002','Gunung Sitember'),
('12.11.12.2003','Batu Gun Gun'),
('12.11.12.2004','Rante Besi'),
('12.11.12.2005','Gundaling'),
('12.11.12.2006','Kendit Liang'),
('12.11.12.2007','Lau Lebah'),
('12.11.12.2008','Tupak Raja'),
('12.11.13','Berampu'),
('12.11.13.2001','Sambaliang'),
('12.11.13.2002','Pasi'),
('12.11.13.2003','Banjar Toba'),
('12.11.13.2004','Berampu'),
('12.11.13.2005','Karing'),
('12.11.14','Silahisabungan'),
('12.11.14.2001','Silalahi II'),
('12.11.14.2002','Silalahi I'),
('12.11.14.2003','Paropo'),
('12.11.14.2004','Silalahi III'),
('12.11.14.2005','Paropo I'),
('12.11.15','Sitinjo'),
('12.11.15.1004','Panji Dabutar'),
('12.11.15.2001','Sitinjo'),
('12.11.15.2002','Sitinjo I'),
('12.11.15.2003','Sitinjo II'),
('12.12','Kabupaten Toba'),
('12.12.01','Balige'),
('12.12.01.1034','Balige I'),
('12.12.01.1035','Balige III'),
('12.12.01.1036','Pardede Onan'),
('12.12.01.1037','Sangkar Nihuta'),
('12.12.01.1038','Lumban Dolok Hauma Bange'),
('12.12.01.1039','Napitupulu Bagasan'),
('12.12.01.2003','Hutanamora'),
('12.12.01.2004','Hutagaol Peatalun'),
('12.12.01.2005','Hinalang Bagasan'),
('12.12.01.2006','Matio'),
('12.12.01.2007','Lumban Pea'),
('12.12.01.2008','Hutabulu Mejan'),
('12.12.01.2010','Lumban Gaol'),
('12.12.01.2011','Parsuratan'),
('12.12.01.2012','Baruara'),
('12.12.01.2013','Aek Bolon Julu'),
('12.12.01.2014','Sibolahotang SAS'),
('12.12.01.2015','Lumban Bulbul'),
('12.12.01.2016','Sianipar Sihailhail'),
('12.12.01.2017','Silalahi Pagar Batu'),
('12.12.01.2018','Lumban Silintong'),
('12.12.01.2019','Saribu Raja Janji Maria'),
('12.12.01.2022','Longat'),
('12.12.01.2023','Balige II'),
('12.12.01.2024','Aek Bolon Jae'),
('12.12.01.2025','Lumban Gorat'),
('12.12.01.2026','Sibuntuon'),
('12.12.01.2027','Siboruon'),
('12.12.01.2028','Paindoan'),
('12.12.01.2029','Bonan Dolok I'),
('12.12.01.2030','Bonan Dolok II'),
('12.12.01.2031','Bonan Dolok III'),
('12.12.01.2032','Huta Dame'),
('12.12.01.2040','Lumban Pea Timur'),
('12.12.01.2041','Tambunan Sunge'),
('12.12.02','Laguboti'),
('12.12.02.1001','Pasar Laguboti'),
('12.12.02.2002','Sibuea'),
('12.12.02.2003','Sintong Marnipi'),
('12.12.02.2004','Sibarani Nasampulu/Namungkup'),
('12.12.02.2005','Aruan'),
('12.12.02.2006','Sidulang'),
('12.12.02.2007','Ujung Tanduk'),
('12.12.02.2008','Haunatas II'),
('12.12.02.2009','Pardomuan Nauli'),
('12.12.02.2010','Sitangkola'),
('12.12.02.2011','Tinggir Nipasir'),
('12.12.02.2012','Haunatas I'),
('12.12.02.2013','Pintu Bosi'),
('12.12.02.2014','Simatibung'),
('12.12.02.2015','Lumban Binanga'),
('12.12.02.2016','Ompu Raja Hutapea'),
('12.12.02.2017','Gasaribu'),
('12.12.02.2018','Pardinggaran'),
('12.12.02.2019','Sitoluama'),
('12.12.02.2020','Lumban Bagasan'),
('12.12.02.2021','Siraja Gorat'),
('12.12.02.2022','Ompu Raja Hutapea Timur'),
('12.12.02.2023','Ompu Raja Hatulian'),
('12.12.03','Silaen'),
('12.12.03.2001','Pintu Batu'),
('12.12.03.2002','Sitorang'),
('12.12.03.2003','Parsambilan'),
('12.12.03.2004','Huta Gur- Gur II'),
('12.12.03.2005','Silaen'),
('12.12.03.2006','Ombur'),
('12.12.03.2008','Natolutali'),
('12.12.03.2009','Dalihan Natolu'),
('12.12.03.2010','Sigodang Tua'),
('12.12.03.2014','Sinta Dame'),
('12.12.03.2015','Hutanamora'),
('12.12.03.2017','Pardomuan'),
('12.12.03.2018','Huta Gur-Gur I'),
('12.12.03.2022','Lumban Dolok'),
('12.12.03.2023','Napitupulu'),
('12.12.03.2024','Hutagaol Sihujur'),
('12.12.03.2025','Meranti Barat'),
('12.12.03.2026','Sibide Barat'),
('12.12.03.2027','Sibide'),
('12.12.03.2028','Simanobak'),
('12.12.03.2029','Panindi'),
('12.12.03.2030','Siringkiron'),
('12.12.03.2031','Marbulang'),
('12.12.04','Habinsaran'),
('12.12.04.1009','Parsoburan Tengah'),
('12.12.04.2002','Lumban Rau Selatan'),
('12.12.04.2004','Lumban Rau Barat'),
('12.12.04.2006','Lumban Balik'),
('12.12.04.2007','Panamparan'),
('12.12.04.2008','Lumban Pinasa'),
('12.12.04.2010','Parsoburan Barat'),
('12.12.04.2011','Lumban Ruhap'),
('12.12.04.2012','Lumban Pea'),
('12.12.04.2014','Hitetano'),
('12.12.04.2017','Lobu Hole'),
('12.12.04.2018','Batu Nabolon'),
('12.12.04.2019','Lumban Gaol'),
('12.12.04.2020','Tornagodang'),
('12.12.04.2021','Taon Marisi'),
('12.12.04.2022','Pagar Batu'),
('12.12.04.2023','Sibuntuon'),
('12.12.04.2024','Pararungan'),
('12.12.04.2025','Lumban Lintong'),
('12.12.04.2026','Pangunjungan'),
('12.12.04.2027','Lumban Pinasa Saroha'),
('12.12.04.2028','Aek Ulok'),
('12.12.05','Pintu Pohan Meranti'),
('12.12.05.2001','Meranti Utara'),
('12.12.05.2002','Meranti Timur'),
('12.12.05.2003','Meranti Tengah'),
('12.12.05.2007','Pintu Pohan'),
('12.12.05.2008','Ambar Halim'),
('12.12.05.2009','Pintu Pohan Dolok'),
('12.12.05.2010','Halado'),
('12.12.06','Borbor'),
('12.12.06.2001','Natumingka'),
('12.12.06.2002','Pangururan'),
('12.12.06.2003','Pardomuan Nauli'),
('12.12.06.2004','Lintong'),
('12.12.06.2005','Rianiate'),
('12.12.06.2006','Aek Unsim'),
('12.12.06.2007','Purba Tua'),
('12.12.06.2008','Janji Maria'),
('12.12.06.2009','Pangururan II'),
('12.12.06.2010','Pangururan III'),
('12.12.06.2011','Hutagurgur'),
('12.12.06.2012','Simare'),
('12.12.06.2013','Lumban Sewa'),
('12.12.06.2014','Riganjang'),
('12.12.06.2015','Pasar Borbor'),
('12.12.07','Porsea'),
('12.12.07.1037','Pasar Porsea'),
('12.12.07.1038','Patane III'),
('12.12.07.1039','Parparean III'),
('12.12.07.2001','Patane IV'),
('12.12.07.2003','Lumban Gurning'),
('12.12.07.2004','Amborgang'),
('12.12.07.2005','Nalela'),
('12.12.07.2007','Patane II'),
('12.12.07.2022','Gala Gala Pangkailan'),
('12.12.07.2023','Silamosik I'),
('12.12.07.2030','Parparean IV'),
('12.12.07.2031','Parparean I'),
('12.12.07.2033','Parparean II'),
('12.12.07.2036','Patane I'),
('12.12.07.2040','Patane V'),
('12.12.07.2041','Simpang Sigura-Gura'),
('12.12.07.2042','Raut Bosi'),
('12.12.08','Ajibata'),
('12.12.08.1009','Parsaoran Ajibata'),
('12.12.08.2001','Sigapiton'),
('12.12.08.2002','Pardomuan Ajibata'),
('12.12.08.2003','Pardamean Ajibata'),
('12.12.08.2004','Motung'),
('12.12.08.2005','Horsik'),
('12.12.08.2006','Sirungkungon'),
('12.12.08.2007','Parsaoran Sibisa'),
('12.12.08.2008','Pardamean Sibisa'),
('12.12.08.2010','Pardomuan Motung'),
('12.12.09','Lumban Julu'),
('12.12.09.2002','Lintong Julu'),
('12.12.09.2003','Hatinggian'),
('12.12.09.2004','Sibaruang'),
('12.12.09.2005','Jangga Toruan'),
('12.12.09.2006','Sionggang Selatan'),
('12.12.09.2007','Pasar Lumban Julu'),
('12.12.09.2008','Sionggang Utara'),
('12.12.09.2014','Sionggang Tengah'),
('12.12.09.2015','Jangga Dolok'),
('12.12.09.2016','Hutanamora'),
('12.12.09.2017','Jonggi Nihuta'),
('12.12.09.2018','Aek Natolu Jaya'),
('12.12.10','Uluan'),
('12.12.10.2001','Dolok Saribu Janji Matogu'),
('12.12.10.2002','Dolok Nagodang'),
('12.12.10.2003','Lumban Binanga'),
('12.12.10.2004','Partor Janji Matogu'),
('12.12.10.2005','Parhabinsaran Janji Matogu'),
('12.12.10.2006','Parik'),
('12.12.10.2007','Sibuntuon'),
('12.12.10.2008','Sigaol Barat'),
('12.12.10.2009','Marom'),
('12.12.10.2010','Sigaol Timur'),
('12.12.10.2012','Siregar Aek Nalas'),
('12.12.10.2014','Lumban Holbung'),
('12.12.10.2015','Parbagasan Janji Matogu'),
('12.12.10.2016','Partoruan Janji Matogu'),
('12.12.10.2017','Lumban Nabolon'),
('12.12.10.2018','Sampuara'),
('12.12.10.2019','Dolok Saribu Lumban Nabolon'),
('12.12.19','Sigumpar'),
('12.12.19.1007','Sigumpar Dangsina'),
('12.12.19.2001','Marsangap'),
('12.12.19.2002','Nauli'),
('12.12.19.2003','Situa-tua'),
('12.12.19.2004','Sigumpar'),
('12.12.19.2005','Maju'),
('12.12.19.2006','Dolok Jior'),
('12.12.19.2008','Sigumpar Julu'),
('12.12.19.2009','Sigumpar Barat'),
('12.12.19.2010','Banua Huta'),
('12.12.20','Siantar Narumonda'),
('12.12.20.2001','Narumonda I'),
('12.12.20.2002','Narumonda II'),
('12.12.20.2003','Narumonda III'),
('12.12.20.2004','Narumonda IV'),
('12.12.20.2005','Narumonda V'),
('12.12.20.2006','Narumonda VI'),
('12.12.20.2007','Narumonda VII'),
('12.12.20.2008','Narumonda VIII'),
('12.12.20.2009','Siantar Sitio Tio'),
('12.12.20.2010','Siantar Dangsina'),
('12.12.20.2011','Siantar Tonga-tonga I'),
('12.12.20.2012','Siantar Tonga-Tonga II'),
('12.12.20.2013','Siantar Sigordang'),
('12.12.20.2014','Siantar Tonga-Tonga III'),
('12.12.21','Nassau'),
('12.12.21.2001','Lumban Rau Tengah'),
('12.12.21.2002','Lumban Rau Timur'),
('12.12.21.2003','Lumban Rau Utara'),
('12.12.21.2004','Sipagabu'),
('12.12.21.2005','Napajoring'),
('12.12.21.2006','Liat Tondung'),
('12.12.21.2007','Batu Manumpak'),
('12.12.21.2008','Lumban Rau Tenggara'),
('12.12.21.2009','Cinta Damai'),
('12.12.21.2010','Siantarasa'),
('12.12.22','Tampahan'),
('12.12.22.2001','Lintong Nihuta'),
('12.12.22.2002','Tarabunga'),
('12.12.22.2003','Meat'),
('12.12.22.2004','Gurgur Aek Raja'),
('12.12.22.2005','Tangga Batu Barat'),
('12.12.22.2006','Tangga Batu Timur'),
('12.12.23','Bonatua Lunasi'),
('12.12.23.2001','Sihiong'),
('12.12.23.2002','Sinar Sabungan'),
('12.12.23.2003','Lumban Lobu'),
('12.12.23.2004','Harungguan'),
('12.12.23.2005','Naga Timbul'),
('12.12.23.2006','Sibadihon'),
('12.12.23.2007','Silamosik II'),
('12.12.23.2011','Partoruan Lumban Lobu'),
('12.12.23.2012','Pardolok Lumban Lobu'),
('12.12.23.2013','Silombu'),
('12.12.23.2014','Lumban Sangkalan'),
('12.12.23.2015','Nagatimbul Timur'),
('12.12.24','Parmaksian'),
('12.12.24.2001','Siantar Utara'),
('12.12.24.2002','Lumban Sitorus'),
('12.12.24.2003','Banjar Ganjang'),
('12.12.24.2004','Tangga Batu I'),
('12.12.24.2005','Tangga Batu II'),
('12.12.24.2006','Pangombusan'),
('12.12.24.2007','Jonggi Manulus'),
('12.12.24.2008','Lumban Huala'),
('12.12.24.2009','Dolok Nauli'),
('12.12.24.2010','Lumban Sirait Gu'),
('12.12.24.2011','Lumban Manurung'),
('12.13','Kabupaten Mandailing Natal'),
('12.13.01','Panyabungan'),
('12.13.01.1011','Kota Siantar'),
('12.13.01.1014','Kayu Jati'),
('12.13.01.1022','Pasar Hilir'),
('12.13.01.1023','Pidoli Dolok'),
('12.13.01.1031','Panyabungan II'),
('12.13.01.1032','Panyabungan III'),
('12.13.01.1033','Panyabungan I'),
('12.13.01.1035','Sipolu-Polu'),
('12.13.01.1036','Dalan Lidang'),
('12.13.01.2001','Adian Jior'),
('12.13.01.2002','Aek Banir'),
('12.13.01.2003','Aek Mata'),
('12.13.01.2004','Darussalam'),
('12.13.01.2005','Gunung Barani'),
('12.13.01.2006','Gunung Manaon'),
('12.13.01.2007','Gunung Tua Jae'),
('12.13.01.2008','Gunung Tua Julu'),
('12.13.01.2009','Gunung Tua Tonga'),
('12.13.01.2010','Huta Lombang Lubis'),
('12.13.01.2012','Ipar Bondar'),
('12.13.01.2013','Kampung Padang'),
('12.13.01.2015','Lumban Pasir'),
('12.13.01.2016','Manyabar'),
('12.13.01.2017','Pagaran Tonga'),
('12.13.01.2018','Panyabungan Jae'),
('12.13.01.2019','Panyabungan Julu'),
('12.13.01.2020','Panyabungan Tonga'),
('12.13.01.2021','Perbangunan'),
('12.13.01.2024','Pidoli Lombang'),
('12.13.01.2025','Salam Bue'),
('12.13.01.2026','Sarak Matua'),
('12.13.01.2027','Sigalapang Julu'),
('12.13.01.2028','Siobon Julu'),
('12.13.01.2029','Sipapaga'),
('12.13.01.2030','Sopobatu'),
('12.13.01.2037','Siobon Jae'),
('12.13.01.2038','Panggorengan'),
('12.13.01.2039','Saba Jambu'),
('12.13.01.2040','Manyabar Jae'),
('12.13.02','Panyabungan Utara'),
('12.13.02.1012','Mompang Jae'),
('12.13.02.2002','Beringin Jaya'),
('12.13.02.2007','Huta damai'),
('12.13.02.2008','Jambur Padang Matinggi'),
('12.13.02.2009','Kampung Baru'),
('12.13.02.2010','Mompang Julu'),
('12.13.02.2014','Rumbio'),
('12.13.02.2015','Suka Ramai'),
('12.13.02.2017','Sopo Sorik'),
('12.13.02.2018','Simanondong'),
('12.13.02.2019','Torbanua Raja'),
('12.13.02.2020','Tanjung Mompang'),
('12.13.03','Panyabungan Timur'),
('12.13.03.1002','Gunung Baringin'),
('12.13.03.2001','Aek Nabara'),
('12.13.03.2003','Hutaimbaru'),
('12.13.03.2004','Huta Bangun'),
('12.13.03.2005','Huta Tinggi'),
('12.13.03.2006','Pagur'),
('12.13.03.2007','Pardomuan'),
('12.13.03.2008','Parmompang'),
('12.13.03.2009','Ranto Natas'),
('12.13.03.2010','Sirangkap'),
('12.13.03.2011','Tanjung'),
('12.13.03.2012','Tebing Tinggi'),
('12.13.03.2013','Tanjung Julu'),
('12.13.03.2014','Banjar Lancat'),
('12.13.03.2015','Padang Laru'),
('12.13.04','Panyabungan Selatan'),
('12.13.04.1009','Tano Bato'),
('12.13.04.2001','Aek Ngali'),
('12.13.04.2002','Hutarimbaru'),
('12.13.04.2003','Hayuraja'),
('12.13.04.2004','Huta Julu'),
('12.13.04.2005','Kayu Laut'),
('12.13.04.2006','Lumban Dolok'),
('12.13.04.2007','Roburan Dolok'),
('12.13.04.2008','Roburan Lombang'),
('12.13.04.2010','Huta Raja'),
('12.13.04.2011','Pagaran Gala-Gala'),
('12.13.05','Panyabungan Barat'),
('12.13.05.1006','Longat'),
('12.13.05.2001','Barbaran'),
('12.13.05.2002','Barbaran Jae'),
('12.13.05.2003','Batang Gadis'),
('12.13.05.2004','Huta Baringin'),
('12.13.05.2005','Huta Tonga BB'),
('12.13.05.2007','Runding'),
('12.13.05.2008','Sirambas'),
('12.13.05.2009','Saba Jior'),
('12.13.05.2010','Batang Gadis Jae'),
('12.13.06','Siabu'),
('12.13.06.1014','Siabu'),
('12.13.06.1023','Simangambat'),
('12.13.06.2001','Aek Mual'),
('12.13.06.2002','Bonan Dolok'),
('12.13.06.2003','Huta Raja'),
('12.13.06.2004','Huta Puli'),
('12.13.06.2005','Huta Baringin'),
('12.13.06.2006','Huta Godang Muda'),
('12.13.06.2007','Huraba I'),
('12.13.06.2008','Huraba II'),
('12.13.06.2009','Lumban Pinasa'),
('12.13.06.2010','Lumban Dolok'),
('12.13.06.2011','Muara Btg. Angkola'),
('12.13.06.2012','Pintu Padang Jae'),
('12.13.06.2013','Pintu Padang Julu'),
('12.13.06.2015','Sibaruang'),
('12.13.06.2016','Sihepeng'),
('12.13.06.2017','Simaninggir'),
('12.13.06.2018','Sinonoan'),
('12.13.06.2019','Tangga Bosi II'),
('12.13.06.2020','Tanjung Sialang'),
('12.13.06.2021','Tangga Bosi I'),
('12.13.06.2022','Tangga Bosi III'),
('12.13.06.2024','Sihepeng Sada'),
('12.13.06.2025','Sihepeng Dua'),
('12.13.06.2026','Sihepeng Tolu'),
('12.13.06.2027','Sihepeng Opat'),
('12.13.06.2028','Sihepeng Lima'),
('12.13.07','Bukit Malintang'),
('12.13.07.2001','Bange'),
('12.13.07.2003','Huta Bangun'),
('12.13.07.2005','Janji Matogu'),
('12.13.07.2006','Malintang Jae'),
('12.13.07.2007','Malintang Julu'),
('12.13.07.2008','Pasar Baru Malintang'),
('12.13.07.2010','Sidojadi'),
('12.13.07.2013','Lambou Darul Ihsan'),
('12.13.07.2014','Huta Bangun Jae'),
('12.13.07.2015','Bange Nauli'),
('12.13.07.2016','Malintang'),
('12.13.08','Kotanopan'),
('12.13.08.1032','Tamiang'),
('12.13.08.1036','Pasar Kotanopan'),
('12.13.08.2001','Batahan'),
('12.13.08.2002','Botung'),
('12.13.08.2003','Gading Bain'),
('12.13.08.2004','Gunung Tua MS'),
('12.13.08.2005','Gunung Tua SM'),
('12.13.08.2006','Hutapuli'),
('12.13.08.2007','Huta Padang MS'),
('12.13.08.2008','Hutarimbaru SM'),
('12.13.08.2009','Huta Baringin TB'),
('12.13.08.2010','Huta Pungkut Jae'),
('12.13.08.2011','Huta Pungkut Tonga'),
('12.13.08.2012','Huta Pungkut Julu'),
('12.13.08.2013','Huta Dangka'),
('12.13.08.2014','Muara Potan'),
('12.13.08.2015','Muara Siambak'),
('12.13.08.2016','Manambin'),
('12.13.08.2017','Muara Pungkut'),
('12.13.08.2018','Muara Botung'),
('12.13.08.2019','Pagar Gunung'),
('12.13.08.2020','Padang Bulan'),
('12.13.08.2021','Patialo'),
('12.13.08.2022','Saba Dolok'),
('12.13.08.2023','Singengu Jae'),
('12.13.08.2024','Singengu Julu'),
('12.13.08.2025','Sayur Maincat'),
('12.13.08.2026','Simpang Tolang Jae'),
('12.13.08.2027','Simpang Tolang Julu'),
('12.13.08.2028','Sibio Bio'),
('12.13.08.2029','Sopo Sorik'),
('12.13.08.2030','Simandolam'),
('12.13.08.2031','Tombang Bustak'),
('12.13.08.2033','Tobang'),
('12.13.08.2034','Ujung Marisi'),
('12.13.08.2035','Usor Tolang'),
('12.13.09','Lembah Sorik Marapi'),
('12.13.09.1008','Pasar Maga'),
('12.13.09.2001','Aek Marian MG'),
('12.13.09.2002','Bangun Purba'),
('12.13.09.2003','Maga Lombang'),
('12.13.09.2004','Maga Dolok'),
('12.13.09.2005','Purba Baru'),
('12.13.09.2006','Purba Lamo'),
('12.13.09.2007','Pangkat'),
('12.13.09.2009','Siantona'),
('12.13.10','Tambangan'),
('12.13.10.1010','Laru Lombang'),
('12.13.10.2001','Angin Barat'),
('12.13.10.2006','Huta Tonga AB'),
('12.13.10.2007','Laru Baringin'),
('12.13.10.2008','Laru Bolak'),
('12.13.10.2009','Laru Dolok'),
('12.13.10.2011','Lumban Pasir'),
('12.13.10.2012','Muara Mais'),
('12.13.10.2013','Muara Mais Jambur'),
('12.13.10.2014','Padang Sanggar'),
('12.13.10.2015','Panjaringan'),
('12.13.10.2016','Pasar Laru'),
('12.13.10.2017','Pastap'),
('12.13.10.2018','Pastap Julu'),
('12.13.10.2020','Rao Rao Dolok'),
('12.13.10.2021','Rao Rao Lombang'),
('12.13.10.2025','Simangambat TB'),
('12.13.10.2026','Tambangan Jae'),
('12.13.10.2027','Tambangan Pasoman'),
('12.13.10.2028','Tambangan Tonga'),
('12.13.11','Ulu Pungkut'),
('12.13.11.1003','Huta Godang'),
('12.13.11.2001','Alahan Kae'),
('12.13.11.2002','Habincaran'),
('12.13.11.2004','Huta Padang UP'),
('12.13.11.2005','Hutaimbaru UP'),
('12.13.11.2006','Muara Saladi'),
('12.13.11.2007','Patahajang'),
('12.13.11.2008','Simpang Banyak Jae'),
('12.13.11.2009','Simpang Banyak Julu'),
('12.13.11.2010','Simpang Duhu Dolok'),
('12.13.11.2011','Simpang Duhu Lombang'),
('12.13.11.2012','Simpang Pining'),
('12.13.11.2013','Tolang'),
('12.13.12','Muara Sipongi'),
('12.13.12.1019','Pasar Muara Sipongi'),
('12.13.12.2001','Bandar Panjang'),
('12.13.12.2002','Bandar Panjang Tuo'),
('12.13.12.2007','Kampung Pinang'),
('12.13.12.2008','Koto Baringin'),
('12.13.12.2009','Limau Manis'),
('12.13.12.2012','Ranjo Batu'),
('12.13.12.2013','Sibinail'),
('12.13.12.2015','Simpang Mandepo'),
('12.13.12.2016','Tamiang Mudo'),
('12.13.12.2017','Tanjung Alai'),
('12.13.12.2020','Tanjung Medan'),
('12.13.12.2021','Muara Kumpulan'),
('12.13.12.2022','Aek Botung'),
('12.13.12.2023','Koto Boru'),
('12.13.12.2024','Tanjung Larangan'),
('12.13.13','Batang Natal'),
('12.13.13.1017','Muara Soma'),
('12.13.13.2001','Aek Guo'),
('12.13.13.2002','Aek Holbung'),
('12.13.13.2003','Aek Manggis'),
('12.13.13.2004','Aek Nabara'),
('12.13.13.2005','Aek Nangali'),
('12.13.13.2006','Ampung Julu'),
('12.13.13.2007','Ampung Padang'),
('12.13.13.2008','Ampung Siala'),
('12.13.13.2009','Bangkelang'),
('12.13.13.2010','Banjar Malayu'),
('12.13.13.2011','Batu Madinding'),
('12.13.13.2012','Bulu Soma'),
('12.13.13.2013','Guo Batu'),
('12.13.13.2014','Hadangkahan'),
('12.13.13.2015','Hatupangan'),
('12.13.13.2016','Muara Parlampungan'),
('12.13.13.2018','Rantobi'),
('12.13.13.2019','Rao Rao'),
('12.13.13.2020','Simanguntong'),
('12.13.13.2021','Sipogu'),
('12.13.13.2022','Sopo Tinjak'),
('12.13.13.2023','Tarlola'),
('12.13.13.2024','Tombang Kaluang'),
('12.13.13.2025','Huta Lobu'),
('12.13.13.2026','Lubuk Samboa'),
('12.13.13.2027','Jambur Baru'),
('12.13.13.2028','Aek Baru Jae'),
('12.13.13.2029','Aek Baru Julu'),
('12.13.13.2030','Lubuk Bondar Panjang'),
('12.13.13.2031','Tor Naincat'),
('12.13.14','Lingga Bayu'),
('12.13.14.1024','Simpang Gambir'),
('12.13.14.1028','Tapus'),
('12.13.14.2001','Aek Garingging'),
('12.13.14.2002','Aek Manyuruk'),
('12.13.14.2003','Bandar Limabung'),
('12.13.14.2006','Lancat'),
('12.13.14.2010','Kampung Baru'),
('12.13.14.2011','Lobung'),
('12.13.14.2014','Pangkalan'),
('12.13.14.2015','Perk. Simpang Gambir'),
('12.13.14.2019','Sikumbu'),
('12.13.14.2021','Simpang Bajole'),
('12.13.14.2022','Simpang Duku'),
('12.13.14.2023','Simpang Durian'),
('12.13.14.2025','Simpang Koje'),
('12.13.14.2029','Dalan Lidang'),
('12.13.14.2031','Bonca Bayuon'),
('12.13.14.2034','Perbatasan'),
('12.13.14.2035','Tangsi Atas'),
('12.13.15','Batahan'),
('12.13.15.1011','Pasar Baru Batahan'),
('12.13.15.2001','Banjar Aur'),
('12.13.15.2003','Batahan I'),
('12.13.15.2004','Batu Sondat'),
('12.13.15.2005','Bintungan Bejangkar'),
('12.13.15.2007','Kampung Kapas'),
('12.13.15.2008','Kuala Batahan'),
('12.13.15.2009','Kubangan Tompek'),
('12.13.15.2010','Muara Pertemuan'),
('12.13.15.2012','Pasar Batahan'),
('12.13.15.2013','Pulau Tamang'),
('12.13.15.2014','Sari Kenanga Batahan'),
('12.13.15.2019','Batahan II'),
('12.13.15.2020','Batahan III'),
('12.13.15.2021','Batahan IV'),
('12.13.15.2022','Sinunukan VI'),
('12.13.15.2023','Kampung Kapas I'),
('12.13.15.2024','Kubangan Pandan Sari'),
('12.13.16','Natal'),
('12.13.16.1008','Pasar II Natal'),
('12.13.16.1025','Pasar I Natal'),
('12.13.16.2001','Balimbing'),
('12.13.16.2002','Bintuas'),
('12.13.16.2003','Bonda Kase'),
('12.13.16.2004','Buburan'),
('12.13.16.2005','Kampung Sawah'),
('12.13.16.2006','Panggautan'),
('12.13.16.2007','Pardamean Baru'),
('12.13.16.2009','Pasar III Natal'),
('12.13.16.2010','Pasar V Natal'),
('12.13.16.2011','Patiluban Hilir'),
('12.13.16.2012','Patiluban Mudik'),
('12.13.16.2013','Perkebunan Patiluban'),
('12.13.16.2014','Rukun Jaya'),
('12.13.16.2015','Setia Karya'),
('12.13.16.2016','Sikara Kara'),
('12.13.16.2017','Sikara Kara I'),
('12.13.16.2018','Sikara Kara II'),
('12.13.16.2019','Sikara Kara III'),
('12.13.16.2020','Sikara Kara IV'),
('12.13.16.2021','Sundutan Tigo'),
('12.13.16.2022','Taluk'),
('12.13.16.2023','Tegal Sari'),
('12.13.16.2024','Tunas Karya'),
('12.13.16.2026','Pasar VI Natal'),
('12.13.16.2027','Sinunukan V'),
('12.13.16.2028','Suka Maju'),
('12.13.16.2029','Sasaran'),
('12.13.16.2030','Kun-Kun'),
('12.13.17','Muara Batang Gadis'),
('12.13.17.2001','Batu Mundom'),
('12.13.17.2002','Hutaimbaru'),
('12.13.17.2003','Lubuk Kapundung'),
('12.13.17.2004','Manuncang'),
('12.13.17.2005','Panunggulan'),
('12.13.17.2006','Pasar Singkuang I'),
('12.13.17.2007','Pasar Singkuang II'),
('12.13.17.2008','Rantau Panjang'),
('12.13.17.2009','Sikapas'),
('12.13.17.2010','Tabuyung'),
('12.13.17.2011','Tagilang Julu'),
('12.13.17.2012','Sali Baru'),
('12.13.17.2013','Lubuk Kapundung II'),
('12.13.17.2014','Suka Makmur'),
('12.13.18','Ranto Baek'),
('12.13.18.2001','Manisak'),
('12.13.18.2002','Simpang Talap'),
('12.13.18.2003','Sampuran'),
('12.13.18.2004','Tandikek'),
('12.13.18.2005','Gonting'),
('12.13.18.2006','Bangun Saroha'),
('12.13.18.2007','Huta Baringin'),
('12.13.18.2008','Muara Bangko'),
('12.13.18.2009','Ranto Nalinjang'),
('12.13.18.2010','Banjar Maga'),
('12.13.18.2011','Huta Raja'),
('12.13.18.2012','Simaninggir'),
('12.13.18.2013','Ranto Panjang'),
('12.13.18.2014','Huta Nauli'),
('12.13.18.2015','Lubuk Kancah'),
('12.13.18.2016','Dua Sepakat'),
('12.13.18.2017','Gunung Godang'),
('12.13.18.2018','Padang Silojongan'),
('12.13.19','Huta Bargot'),
('12.13.19.2001','Bangun Sejati'),
('12.13.19.2002','Hutarimbaru'),
('12.13.19.2003','Pasar Huta Bargot'),
('12.13.19.2004','Huta Bargot Lombang'),
('12.13.19.2005','Huta Bargot Dolok'),
('12.13.19.2006','Huta Bargot Setia'),
('12.13.19.2007','Huta Bargot Nauli'),
('12.13.19.2008','Mondan'),
('12.13.19.2009','Sayur Maincat'),
('12.13.19.2010','Kumpulan Setia'),
('12.13.19.2011','Simalagi'),
('12.13.19.2012','Saba Padang'),
('12.13.19.2013','Binanga'),
('12.13.19.2014','Huta Naingkan'),
('12.13.20','Puncak Sorik Marapi'),
('12.13.20.2001','Huta Lombang'),
('12.13.20.2002','Huta Baru'),
('12.13.20.2003','Handel'),
('12.13.20.2004','Hutatinggi'),
('12.13.20.2005','Hutanamale'),
('12.13.20.2006','Hutabaringin Julu'),
('12.13.20.2007','Sibanggor Jae'),
('12.13.20.2008','Sibanggor Tonga'),
('12.13.20.2009','Sibanggor Julu'),
('12.13.20.2010','Purba Julu'),
('12.13.20.2011','Huta Baringin'),
('12.13.21','Pakantan'),
('12.13.21.2001','Pakantan Dolok'),
('12.13.21.2002','Pakantan Lombang'),
('12.13.21.2003','Huta Gambir'),
('12.13.21.2004','Huta Lancat'),
('12.13.21.2005','Huta Julu'),
('12.13.21.2006','Huta Toras'),
('12.13.21.2007','Huta Padang'),
('12.13.21.2008','Silogun'),
('12.13.22','Sinunukan'),
('12.13.22.2001','Sinunukan I'),
('12.13.22.2002','Sinunukan II'),
('12.13.22.2003','Sinunukan III'),
('12.13.22.2004','Sinunukan IV'),
('12.13.22.2005','Bintungan Bejangkar Baru'),
('12.13.22.2006','Banjar Aur Utara'),
('12.13.22.2007','Kampung Kapas II'),
('12.13.22.2008','Airapa'),
('12.13.22.2009','Sido Makmur'),
('12.13.22.2010','Wido Daren'),
('12.13.22.2011','Wono Sari'),
('12.13.22.2012','Suka Damai'),
('12.13.22.2013','Pasir Putih'),
('12.13.22.2014','Sinunukan I Central'),
('12.13.23','Naga Juang'),
('12.13.23.2001','Tambiski'),
('12.13.23.2002','Tarutung Panjang'),
('12.13.23.2003','Humbang I'),
('12.13.23.2004','Banua Rakyat'),
('12.13.23.2005','Sayur Matua'),
('12.13.23.2006','Banua Simanosor'),
('12.13.23.2007','Tambiski Nauli'),
('12.14','Kabupaten Nias Selatan'),
('12.14.01','Lolomatua'),
('12.14.01.2002','Hilisangowola'),
('12.14.01.2005','Hiliotalua'),
('12.14.01.2006','Koendrafo'),
('12.14.01.2008','Lawa-lawa Luo'),
('12.14.01.2016','Tuhemberua'),
('12.14.01.2017','Tesikhori'),
('12.14.01.2021','Tumari'),
('12.14.01.2023','Ewo'),
('12.14.01.2024','Ko''olotano'),
('12.14.01.2026','Botohilindruria'),
('12.14.01.2027','Caritas Sogawunasi'),
('12.14.01.2028','Orudua Lawa-lawa Luo'),
('12.14.01.2029','Hilifaondrato'),
('12.14.02','Gomo'),
('12.14.02.2005','Doli-doli Idanotae'),
('12.14.02.2007','Hiliana''a Gomo'),
('12.14.02.2015','Lawa-lawa Luo Gomo'),
('12.14.02.2017','Lolosoni'),
('12.14.02.2023','Orahili Gomo'),
('12.14.02.2024','Sifaoro''asi Gomo'),
('12.14.02.2035','Tanoniko''o'),
('12.14.02.2040','Suka Maju Mohili'),
('12.14.02.2041','Orahili Sibohou'),
('12.14.02.2042','Gunung Gabungan'),
('12.14.02.2043','Umbu Orahua'),
('12.14.03','Lahusa'),
('12.14.03.2001','Bawolato'),
('12.14.03.2002','Bawozihono'),
('12.14.03.2003','Bawo''otalua'),
('12.14.03.2004','Golambanua I'),
('12.14.03.2007','Hilisimaetano Balaekha'),
('12.14.03.2009','Lahusa'),
('12.14.03.2014','Tetezou'),
('12.14.03.2016','Orahili Balaekha'),
('12.14.03.2017','Harenoro'),
('12.14.03.2018','Sarahililaza'),
('12.14.03.2024','Hiliabolata'),
('12.14.03.2025','Hiligambukha'),
('12.14.03.2026','Sinar Baru Darodaro'),
('12.14.03.2027','Hiliorudua'),
('12.14.03.2032','Hilizomboi'),
('12.14.03.2036','Oikhoda Balaekha'),
('12.14.03.2037','Angorudua Balaekha'),
('12.14.03.2038','Hilinawalo Balaekha'),
('12.14.03.2039','Sobawagoli'),
('12.14.03.2040','Lahusa I'),
('12.14.03.2041','Hiliwatema'),
('12.14.03.2042','Mogae'),
('12.14.03.2043','Sinar Baho'),
('12.14.04','Hibala'),
('12.14.04.2001','Duru'),
('12.14.04.2002','Tuwaso'),
('12.14.04.2003','Hilioromao'),
('12.14.04.2004','Eho'),
('12.14.04.2005','Sialema'),
('12.14.04.2006','Bowonifaoso'),
('12.14.04.2007','Hilianombasela'),
('12.14.04.2008','Lumbui Melayu'),
('12.14.04.2009','Hiliorodua Tebolo'),
('12.14.04.2010','Tebolo Melayu'),
('12.14.04.2021','Lumbui Nias'),
('12.14.04.2022','Baruyu Sibohou'),
('12.14.04.2023','Sepakat'),
('12.14.04.2024','Tano Mokinu'),
('12.14.04.2025','Hilikana'),
('12.14.04.2026','Hilinifaese'),
('12.14.04.2027','Omega'),
('12.14.05','Pulau-Pulau Batu'),
('12.14.05.1046','Pasar Pulau Tello'),
('12.14.05.2001','Hiliotalua'),
('12.14.05.2002','Bawodobara'),
('12.14.05.2003','Bawo''amahelato'),
('12.14.05.2004','Bawo''omasio'),
('12.14.05.2005','Loboi'),
('12.14.05.2006','Hiliamaodula'),
('12.14.05.2007','Baruyu Lasara'),
('12.14.05.2008','Sifitu Ewali'),
('12.14.05.2009','Rapa-rapa Melayu'),
('12.14.05.2010','Sinauru'),
('12.14.05.2011','Siofa Ewali'),
('12.14.05.2012','Simaluaya'),
('12.14.05.2013','Silima Ewali'),
('12.14.05.2014','Sidua Ewali'),
('12.14.05.2027','Balogia'),
('12.14.05.2029','Lasonde'),
('12.14.05.2041','Koto'),
('12.14.05.2048','Onaya'),
('12.14.05.2049','Sisarahili'),
('12.14.05.2051','Sebuasi'),
('12.14.05.2054','Orahili'),
('12.14.06','Teluk Dalam'),
('12.14.06.1008','Pasar Teluk Dalam'),
('12.14.06.2006','Hiligeho'),
('12.14.06.2007','Hilitobara'),
('12.14.06.2009','Bawonifaoso'),
('12.14.06.2010','Bawozaua'),
('12.14.06.2011','Hiliganowo'),
('12.14.06.2023','Bawodobara'),
('12.14.06.2024','Bawolowalani'),
('12.14.06.2025','Hilisao''otoniha'),
('12.14.06.2026','Hilisondrekha'),
('12.14.06.2040','Hiliamuri'),
('12.14.06.2042','Hiliana''a'),
('12.14.06.2043','Hiliganowo Salo''o'),
('12.14.06.2044','Ganowo Saua'),
('12.14.06.2045','Nanowa'),
('12.14.06.2046','Hililaza'),
('12.14.07','Amandraya'),
('12.14.07.2004','Sifaoroasi'),
('12.14.07.2005','Hilihoru'),
('12.14.07.2006','Hilimbulawa'),
('12.14.07.2008','Tuindrao'),
('12.14.07.2009','Hilimbowo'),
('12.14.07.2011','Mohili'),
('12.14.07.2012','Lolozaria'),
('12.14.07.2013','Lolomoyo'),
('12.14.07.2014','Hilifadolo'),
('12.14.07.2015','Orahili Eho'),
('12.14.07.2016','Sisobahili'),
('12.14.07.2023','Loloabolo'),
('12.14.07.2024','Hilisalo''o'),
('12.14.07.2026','Sirofi'),
('12.14.07.2027','Hilindraso'),
('12.14.07.2028','Hilimaera'),
('12.14.07.2029','Boholu'),
('12.14.07.2030','Amandraya'),
('12.14.07.2031','Sinar Ino''o'),
('12.14.07.2032','Tuindrao I'),
('12.14.07.2033','Tuhemberua Amandraya'),
('12.14.08','Lolowau'),
('12.14.08.2001','Amuri'),
('12.14.08.2004','Bawosalo''o Siwalawa'),
('12.14.08.2009','Hilifadolo'),
('12.14.08.2014','Lolofaoso'),
('12.14.08.2015','Lolomoyo'),
('12.14.08.2016','Lolowau'),
('12.14.08.2017','Lolohowa'),
('12.14.08.2022','Sisarahili Ekholo'),
('12.14.08.2030','Tuhegafoa'),
('12.14.08.2033','Botohili'),
('12.14.08.2035','Hilikara'),
('12.14.08.2044','Samiri'),
('12.14.08.2047','Hilimbowo Siwalawa'),
('12.14.08.2048','Nituwu Boho'),
('12.14.09','Susua'),
('12.14.09.2001','Sifalago Susua'),
('12.14.09.2002','Orahili Susua'),
('12.14.09.2003','Hiliana''a Susua'),
('12.14.09.2004','Hiliorahua'),
('12.14.09.2005','Hilimboe'),
('12.14.09.2006','Hilimboho'),
('12.14.09.2008','Hiliwaebu'),
('12.14.09.2009','Hilidanayao'),
('12.14.09.2010','Hilizamurugo'),
('12.14.09.2011','Sisobahili'),
('12.14.09.2012','Dao-dao Zanuwo'),
('12.14.09.2013','Hiliorudua'),
('12.14.09.2014','Bintang Baru'),
('12.14.09.2015','Hilitobara Susua'),
('12.14.09.2016','Orahua Uluzoi'),
('12.14.09.2017','Hilisibohou'),
('12.14.09.2018','Hiliadulosoi'),
('12.14.09.2019','Orahili Bo''e'),
('12.14.10','Maniamolo'),
('12.14.10.2001','Hilisimaetano'),
('12.14.10.2002','Bawogosali'),
('12.14.10.2003','Hilifalawu'),
('12.14.10.2005','Samadaya Hilisimaetano'),
('12.14.10.2006','Idala Jaya Hilisimaetano'),
('12.14.10.2007','Pekan Hilisimaetano'),
('12.14.10.2008','Bonia Hilisimaetano'),
('12.14.10.2009','Ndraso Hilisimaetano'),
('12.14.10.2010','Faomasi Hilisimaetano'),
('12.14.10.2011','Eho Hilisimaetano'),
('12.14.10.2012','Soto''o Hilisimaetano'),
('12.14.10.2013','Hiliaurifa Hilisimaetano'),
('12.14.10.2015','Bawohosi Maniamolo'),
('12.14.10.2016','Bawosaodano'),
('12.14.11','Hilimegai'),
('12.14.11.2001','Togizita'),
('12.14.11.2002','Soledua'),
('12.14.11.2003','Bawosalo''o Dao-dao'),
('12.14.11.2004','Tuho''owo'),
('12.14.11.2005','Togizita I'),
('12.14.11.2007','Hilitoese'),
('12.14.11.2008','Dao-dao Sowo'),
('12.14.11.2009','Hiliadulo'),
('12.14.11.2010','Soledua I'),
('12.14.11.2011','Soledua II'),
('12.14.12','Toma'),
('12.14.12.2001','Hilisataro'),
('12.14.12.2002','Hilinamoniha'),
('12.14.12.2003','Hiliamaetaluo'),
('12.14.12.2004','Bawoganowo'),
('12.14.12.2005','Hili''alawa'),
('12.14.12.2006','Hilindrasoniha'),
('12.14.12.2007','Hilimagari'),
('12.14.12.2008','Hilisataro Raya'),
('12.14.12.2009','Hilisataro Gewa'),
('12.14.12.2010','Hilisoromi'),
('12.14.12.2011','Hiliasi'),
('12.14.12.2012','Hilindraso Raya'),
('12.14.12.2013','Hilisataro Nandisa'),
('12.14.12.2014','Hilisataro Eho Sofayo'),
('12.14.13','Mazino'),
('12.14.13.2001','Hilizalo''otano'),
('12.14.13.2002','Hilinawalo Mazino'),
('12.14.13.2003','Lawindra'),
('12.14.13.2004','Bawolahusa'),
('12.14.13.2005','Hilizoroi Lawa'),
('12.14.13.2006','Hilizalo''otano Laowo'),
('12.14.13.2007','Hilizalo''otano Larono'),
('12.14.13.2008','Hililaza Hilinawalo Mazino'),
('12.14.13.2009','Hilifondege Hilizoroilawa'),
('12.14.13.2010','Lolomboli'),
('12.14.13.2011','Bawolahusa Doli-doli'),
('12.14.14','Umbunasi'),
('12.14.14.2001','Lawindra'),
('12.14.14.2003','Sifaoro''asi Mola'),
('12.14.14.2004','Hiliuso'),
('12.14.14.2005','Balohili Mola'),
('12.14.14.2006','Ambukha'),
('12.14.14.2007','Tobualo'),
('12.14.14.2008','Hilibadalu'),
('12.14.14.2009','Foikhugaga'),
('12.14.14.2010','Orlin'),
('12.14.14.2011','Orahili Mola'),
('12.14.14.2012','Umbunasi'),
('12.14.15','Aramo'),
('12.14.15.2001','Hilitotao'),
('12.14.15.2002','Hiliorudua'),
('12.14.15.2003','Sisobambowo'),
('12.14.15.2004','Hiliamauzula'),
('12.14.15.2005','Aramo'),
('12.14.15.2006','Sikhorilafau'),
('12.14.15.2007','Hilifadolo'),
('12.14.15.2008','Hume'),
('12.14.15.2009','Dao-dao'),
('12.14.15.2010','Hilimagiao'),
('12.14.15.2011','Hilisawato'),
('12.14.15.2012','Balohao'),
('12.14.15.2013','Hiligafoa'),
('12.14.15.2014','Hilimbowo'),
('12.14.15.2015','Hilimezaya'),
('12.14.15.2016','Hiliadolowa'),
('12.14.15.2017','Hiligumbu'),
('12.14.15.2018','Bagoa'),
('12.14.16','Pulau-Pulau Batu Timur'),
('12.14.16.2001','Labuhan Hiu'),
('12.14.16.2002','Labuhan Bazau'),
('12.14.16.2003','Labuan Rima'),
('12.14.16.2004','Lambak'),
('12.14.16.2005','Bais'),
('12.14.16.2006','Mahang Labara'),
('12.14.16.2007','Adam'),
('12.14.16.2008','Labara'),
('12.14.16.2009','Bais Baru'),
('12.14.16.2010','Labuan Rima Baru'),
('12.14.17','Mazo'),
('12.14.17.2001','Tetegawa''ai'),
('12.14.17.2002','Hilimbaruzo'),
('12.14.17.2003','Luahandroito'),
('12.14.17.2005','Orahuahili'),
('12.14.17.2006','Ulu Mazo'),
('12.14.17.2007','Guigui'),
('12.14.17.2009','Hilimaufa'),
('12.14.17.2010','Siofabanua'),
('12.14.17.2011','Tetegawa''ai Ehomo'),
('12.14.17.2013','Tafulu'),
('12.14.18','Fanayama'),
('12.14.18.2001','Bawomataluo'),
('12.14.18.2002','Orahili Fau'),
('12.14.18.2003','Bawonahono'),
('12.14.18.2005','Siwalawa'),
('12.14.18.2006','Onohondro'),
('12.14.18.2007','Hilinawalo Fau'),
('12.14.18.2008','Lahusa Fau'),
('12.14.18.2011','Hilizihono'),
('12.14.18.2012','Hiliofonaluo'),
('12.14.18.2015','Bawofanayama'),
('12.14.18.2017','Hilikara Maha'),
('12.14.18.2018','Hilisalawa'),
('12.14.18.2019','Hiligito'),
('12.14.18.2020','Siliwulawa'),
('12.14.18.2021','Hilifarokha Lawa'),
('12.14.18.2022','Eho Orahili'),
('12.14.18.2023','Ete Batu'),
('12.14.19','Ulunoyo'),
('12.14.19.2001','Sambulu'),
('12.14.19.2002','Orahili Ulunoyo'),
('12.14.19.2003','Hiliwaebu'),
('12.14.19.2004','Amorosa'),
('12.14.19.2005','Marao'),
('12.14.19.2006','Borowosi'),
('12.14.19.2007','Hilimaera'),
('12.14.19.2008','Suka Maju'),
('12.14.19.2009','Loloana''a'),
('12.14.19.2010','Hilifakhe'),
('12.14.19.2011','Bawo Lolomatua'),
('12.14.19.2012','Ambukha I'),
('12.14.19.2013','Puncak Lolomatua'),
('12.14.20','Huruna'),
('12.14.20.2001','Ehosakhozi'),
('12.14.20.2002','Bawohosi'),
('12.14.20.2003','Hilizoliga'),
('12.14.20.2004','Olayama'),
('12.14.20.2005','Sifaoroasi'),
('12.14.20.2006','Sifalago'),
('12.14.20.2007','Lalimanawa'),
('12.14.20.2008','Tundrumbaho'),
('12.14.20.2009','Hiliuso'),
('12.14.20.2010','Sisarahili Huruna'),
('12.14.20.2011','Tarewe'),
('12.14.20.2012','Fadoro Tuhemberua'),
('12.14.20.2013','Hilifalawu'),
('12.14.20.2014','Luahamofakhe'),
('12.14.20.2015','Sifaoroasi Huruna'),
('12.14.20.2016','Hilimanawa'),
('12.14.20.2017','Mombawa Oladano'),
('12.14.21','O''o''u'),
('12.14.21.2001','Hilinamazihono'),
('12.14.21.2002','Hilimbowo'),
('12.14.21.2003','Simandraolo'),
('12.14.21.2004','Bawosalo''o Bawoluo'),
('12.14.21.2005','Hilimbuasi'),
('12.14.21.2006','Simandraolo O''o''u'),
('12.14.21.2007','Lolomaya'),
('12.14.21.2008','Suka Maju'),
('12.14.21.2009','Hiliorudua'),
('12.14.21.2010','Hilinamazihono Moale'),
('12.14.21.2011','Balohili O''o''u'),
('12.14.22','Onohazumba'),
('12.14.22.2001','Fadoro Ewo'),
('12.14.22.2002','Soroma''asi'),
('12.14.22.2003','Lauso'),
('12.14.22.2004','Sisarahili Oyo'),
('12.14.22.2005','Sisobahili Huruna'),
('12.14.22.2006','Onohazumba'),
('12.14.22.2007','Hiliweto'),
('12.14.22.2008','Orahili Huruna'),
('12.14.22.2009','Tetehosi'),
('12.14.22.2010','Helefanikha'),
('12.14.23','Hilisalawa''ahe'),
('12.14.23.2001','Maluo'),
('12.14.23.2002','Hiliadulo'),
('12.14.23.2003','Umbuasi'),
('12.14.23.2004','Sisobahili Siwalawa'),
('12.14.23.2005','Manawadano'),
('12.14.23.2006','Talio'),
('12.14.23.2007','Anaoma'),
('12.14.23.2008','Berua Siwalawa'),
('12.14.23.2009','Umbuasi Barat'),
('12.14.23.2010','Hiligodu'),
('12.14.23.2011','Bukit Burasi'),
('12.14.24','Ulususua'),
('12.14.24.2001','Fondrakoraya'),
('12.14.24.2002','Orudua Sibohou'),
('12.14.24.2003','Sisarahili Susua'),
('12.14.24.2004','Susua'),
('12.14.24.2005','Lahusa Susua'),
('12.14.24.2006','Ramba-ramba'),
('12.14.24.2007','Hilinifaoso'),
('12.14.24.2008','Sifaoroasi'),
('12.14.24.2009','Amandraya'),
('12.14.24.2010','Foikhu Fondrako'),
('12.14.24.2011','Hiliwosi'),
('12.14.24.2012','Orahili Fondrako'),
('12.14.25','Sidua''ori'),
('12.14.25.2001','Mondrowe'),
('12.14.25.2002','Hilidohona'),
('12.14.25.2003','Hililaora'),
('12.14.25.2004','Uluidanoduo'),
('12.14.25.2005','Umbu Sohahau'),
('12.14.25.2006','Hilisao''oto'),
('12.14.25.2007','Taluzusua'),
('12.14.25.2008','Hilizanuwo'),
('12.14.25.2009','Hoya'),
('12.14.25.2010','Na''ai'),
('12.14.25.2011','Olanori'),
('12.14.26','Somambawa'),
('12.14.26.2001','Sifitubanua'),
('12.14.26.2002','Siwalu Banua'),
('12.14.26.2003','Sitolu Banua'),
('12.14.26.2004','Silima Banua'),
('12.14.26.2005','Mehaga'),
('12.14.26.2006','Sihare''o'),
('12.14.26.2007','Golambanua II'),
('12.14.26.2008','Oladano'),
('12.14.26.2009','Fanedanu'),
('12.14.26.2010','Hiliorahua Tasua'),
('12.14.26.2011','Somambawa'),
('12.14.26.2012','Gabungan Tasua'),
('12.14.26.2013','Hilialawa'),
('12.14.26.2014','Sinar Susua'),
('12.14.27','Boronadu'),
('12.14.27.2001','Sifalago Gomo'),
('12.14.27.2002','Balohili Gomo'),
('12.14.27.2003','Bohalu'),
('12.14.27.2004','Orsedes'),
('12.14.27.2005','Sinar Helaowo'),
('12.14.27.2006','Siholi'),
('12.14.27.2007','Tuhegafoa'),
('12.14.27.2008','Perjuangan'),
('12.14.27.2009','Lewa-lewa'),
('12.14.27.2010','Siraha'),
('12.14.28','Simuk'),
('12.14.28.2001','Gobo'),
('12.14.28.2002','Silina'),
('12.14.28.2003','Maufa'),
('12.14.28.2004','Gondia'),
('12.14.28.2005','Gobo Baru'),
('12.14.28.2006','Silina Baru'),
('12.14.29','Pulau-Pulau Batu Barat'),
('12.14.29.2001','Fuge'),
('12.14.29.2002','Luaha Idano Pono'),
('12.14.29.2003','Sigese'),
('12.14.29.2004','Bawositora'),
('12.14.29.2005','Bintuang'),
('12.14.29.2006','Sibaranun'),
('12.14.29.2007','Bawolawindra'),
('12.14.29.2008','Hayo'),
('12.14.29.2009','Hilizamorogotano'),
('12.14.30','Pulau-Pulau Batu Utara'),
('12.14.30.2001','Siofa Banua Lorang'),
('12.14.30.2002','Silima Banua Marit'),
('12.14.30.2003','Zia Biang'),
('12.14.30.2004','Limo Biang'),
('12.14.30.2005','Memong'),
('12.14.30.2006','Bale-bale'),
('12.14.30.2007','Teluk Limo'),
('12.14.30.2008','Wawa'),
('12.14.30.2009','Marit Baru'),
('12.14.30.2010','Majino Lorang'),
('12.14.30.2011','Afore Gobo'),
('12.14.30.2012','Bale-bale Sibohou'),
('12.14.31','Tanah Masa'),
('12.14.31.2001','Baluta'),
('12.14.31.2002','Eho Baluta'),
('12.14.31.2003','Bawo Ofuloa'),
('12.14.31.2004','Hale Baluta'),
('12.14.31.2005','Bawo Orudua'),
('12.14.31.2006','Jeke'),
('12.14.31.2007','Makole'),
('12.14.31.2008','Sifauruasi'),
('12.14.31.2009','Bawo Analita Saeru'),
('12.14.31.2010','Saeru Melayu'),
('12.14.31.2011','Hiligeho Sogawu'),
('12.14.31.2012','Hiliomasio'),
('12.14.32','Luahagundre Maniamolo'),
('12.14.32.2001','Botohilitano'),
('12.14.32.2002','Botohilisalo''o'),
('12.14.32.2003','Lagundri'),
('12.14.32.2004','Orahili Faomasi'),
('12.14.32.2005','Hiliamaetaniha'),
('12.14.32.2006','Sondregeasi'),
('12.14.32.2007','Botohili Silambo'),
('12.14.32.2008','Botohili Sorake'),
('12.14.32.2009','Hilimaenamolo'),
('12.14.32.2010','Bawomaenamolo'),
('12.14.33','Onolalu'),
('12.14.33.2001','Hilifalago'),
('12.14.33.2002','Hilimondregeraya'),
('12.14.33.2003','Hilinamozaua'),
('12.14.33.2004','Hilifarono'),
('12.14.33.2005','Hilionaha'),
('12.14.33.2006','Hilikara'),
('12.14.33.2007','Hilialito Saua'),
('12.14.33.2008','Hilinamozaua Raya'),
('12.14.33.2009','Hilifalago Raya'),
('12.14.33.2010','Hilisanekhehosi'),
('12.14.34','Ulu Idanotae'),
('12.14.34.2001','Fanedanu'),
('12.14.34.2002','Fanedanu Sibohou'),
('12.14.34.2003','Lawa-lawa Luo Idanotae'),
('12.14.34.2004','Dao-dao Zanuwo Idano Tae'),
('12.14.34.2005','Sisiwa Ewali'),
('12.14.34.2006','Sisarahili Ewo'),
('12.14.34.2007','Hilialo''oa'),
('12.14.34.2008','Damai'),
('12.14.34.2009','Lolozukhu'),
('12.14.34.2010','Silima Banua Umbunasi'),
('12.14.34.2011','Sindrolo'),
('12.14.35','Idanotae'),
('12.14.35.2001','Lahusa Idanotae'),
('12.14.35.2002','Hiliserangkai'),
('12.14.35.2003','Orahua'),
('12.14.35.2004','Hilimbowo Idanotae'),
('12.14.35.2005','Sirahia'),
('12.14.35.2006','Umbu Idanotae'),
('12.14.35.2007','Awoni'),
('12.14.35.2008','Hilisalo''o'),
('12.14.35.2009','Balombaruzo Orahua'),
('12.14.35.2010','Harefa Orahua'),
('12.14.35.2011','Hiligabungan'),
('12.14.35.2012','Buhawa'),
('12.15','Kabupaten Pakpak Bharat'),
('12.15.01','Sitelu Tali Urang Jehe'),
('12.15.01.2001','Tanjung Meriah'),
('12.15.01.2002','Tanjung Mulia'),
('12.15.01.2003','Kaban Tengah'),
('12.15.01.2004','Bandar Baru'),
('12.15.01.2005','Simberruna'),
('12.15.01.2006','Perolihen'),
('12.15.01.2007','Maholida'),
('12.15.01.2008','Perjaga'),
('12.15.01.2009','Malum'),
('12.15.01.2010','Mbinalun'),
('12.15.02','Kerajaan'),
('12.15.02.2001','Sukaramai'),
('12.15.02.2002','Kuta Saga'),
('12.15.02.2003','Kuta Meriah'),
('12.15.02.2004','Kuta Dame'),
('12.15.02.2005','Perpulungen'),
('12.15.02.2006','Pardomuan'),
('12.15.02.2014','Majanggut I'),
('12.15.02.2015','Majanggut II'),
('12.15.02.2016','Surung Mersada'),
('12.15.02.2021','Perduhapen'),
('12.15.03','Salak'),
('12.15.03.2001','Salak I'),
('12.15.03.2002','Salak II'),
('12.15.03.2003','Boangmanalu'),
('12.15.03.2009','Sibongkaras'),
('12.15.03.2013','Kuta Tinggi'),
('12.15.03.2014','Penanggalan Binanga Boang'),
('12.15.04','Sitelu Tali Urang Julu'),
('12.15.04.2001','Ulumerah'),
('12.15.04.2002','Pardomuan'),
('12.15.04.2003','Silima Kuta'),
('12.15.04.2004','Lae Langge Namuseng'),
('12.15.04.2005','Cikaok'),
('12.15.05','Pergetteng Getteng Sengkut'),
('12.15.05.2001','Kecupak I'),
('12.15.05.2002','Kecupak II'),
('12.15.05.2003','Aornakan I'),
('12.15.05.2004','Simerpara'),
('12.15.05.2005','Aornakan II'),
('12.15.06','Pagindar'),
('12.15.06.2001','Sibagindar'),
('12.15.06.2002','Napatalun Perlambuken'),
('12.15.06.2003','Lae Mbentar'),
('12.15.06.2004','Pagindar'),
('12.15.07','Tinada'),
('12.15.07.2001','Kuta Babo'),
('12.15.07.2002','Tinada'),
('12.15.07.2003','Silima Kuta'),
('12.15.07.2004','Mahala'),
('12.15.07.2005','Prongil'),
('12.15.07.2006','Buluh Tellang'),
('12.15.08','Siempat Rube'),
('12.15.08.2001','Siempat Rube II'),
('12.15.08.2002','Siempat Rube I'),
('12.15.08.2003','Mungkur'),
('12.15.08.2004','Siempat Rube IV'),
('12.15.08.2005','Kuta Jungak'),
('12.15.08.2006','Traju'),
('12.16','Kabupaten Humbang Hasundutan'),
('12.16.01','Parlilitan'),
('12.16.01.2002','Pusuk II Simaninggir'),
('12.16.01.2003','Sionom Hudon VII'),
('12.16.01.2004','Baringin'),
('12.16.01.2005','Sionom Hudon Julu'),
('12.16.01.2006','Sionom Hudon Tonga'),
('12.16.01.2007','Sionom Hudon Utara'),
('12.16.01.2008','Sionom Hudon Selatan'),
('12.16.01.2009','Sionom Hudon Timur'),
('12.16.01.2010','Sihotang Hasugian Tonga'),
('12.16.01.2011','Pusuk I'),
('12.16.01.2012','Sionom Hudon Toruan'),
('12.16.01.2013','Simataniari'),
('12.16.01.2014','Sionom Hudon Timur II'),
('12.16.01.2015','Sihotang Hasugian Dolok II'),
('12.16.01.2016','Sihotang Hasugian Habinsaran'),
('12.16.01.2017','Sionom Hudon Sibulbulon'),
('12.16.01.2018','Sionom Hudon Runggu'),
('12.16.01.2019','Janji Hutanapa'),
('12.16.01.2020','Baringin Natam'),
('12.16.01.2021','Sihotang Hasugian Dolok I'),
('12.16.02','Pollung'),
('12.16.02.2001','Parsingguran I'),
('12.16.02.2002','Hutapaung'),
('12.16.02.2003','Pollung'),
('12.16.02.2004','Hutajulu'),
('12.16.02.2005','Ria Ria'),
('12.16.02.2006','Parsingguran II'),
('12.16.02.2007','Pansurbatu'),
('12.16.02.2008','Aek Nauli I'),
('12.16.02.2009','Aek Nauli II'),
('12.16.02.2010','Pandumaan'),
('12.16.02.2011','Sipituhuta'),
('12.16.02.2012','Pardomuan'),
('12.16.02.2013','Hutapaung Utara'),
('12.16.03','Baktiraja'),
('12.16.03.2001','Marbun Toruan'),
('12.16.03.2002','Simamora'),
('12.16.03.2003','Tipang'),
('12.16.03.2004','Sinambela'),
('12.16.03.2005','Simangulampe'),
('12.16.03.2006','Siunong Unong Julu'),
('12.16.03.2007','Marbun Tonga Marbun Dolok'),
('12.16.04','Paranginan'),
('12.16.04.2001','Sihonongan'),
('12.16.04.2002','Paranginan Selatan'),
('12.16.04.2003','Paranginan Utara'),
('12.16.04.2004','Lumban Sialaman'),
('12.16.04.2005','Pearung'),
('12.16.04.2006','Lobutolong'),
('12.16.04.2007','Lumban Barat'),
('12.16.04.2008','Siboru Torop'),
('12.16.04.2009','Pearung Silali'),
('12.16.04.2010','Lumban Sianturi'),
('12.16.04.2011','Lobutolong Habinsaran'),
('12.16.05','Lintong Nihuta'),
('12.16.05.2001','Sibuntuon Partur'),
('12.16.05.2002','Siharjulu'),
('12.16.05.2003','Sitolu Bahal'),
('12.16.05.2004','Tapian Nauli'),
('12.16.05.2005','Pargaulan'),
('12.16.05.2006','Lobutua'),
('12.16.05.2007','Dolok Margu'),
('12.16.05.2008','Hutasoit I'),
('12.16.05.2009','Nagasaribu I'),
('12.16.05.2010','Nagasaribu II'),
('12.16.05.2011','Sibuntoan Parpea'),
('12.16.05.2012','Siponjot'),
('12.16.05.2013','Habeahan'),
('12.16.05.2014','Sigompul'),
('12.16.05.2015','Bonan Dolok'),
('12.16.05.2016','Sigumpar'),
('12.16.05.2017','Parulohan'),
('12.16.05.2018','Sitio II'),
('12.16.05.2019','Hutasoit II'),
('12.16.05.2020','Nagasaribu III'),
('12.16.05.2021','Nagasaribu IV'),
('12.16.05.2022','Nagasaribu V'),
('12.16.06','Dolok Sanggul'),
('12.16.06.1001','Pasar Dolok Sanggul'),
('12.16.06.2002','Sileang'),
('12.16.06.2003','Purba Manalu'),
('12.16.06.2004','Pasaribu'),
('12.16.06.2005','Simarigung'),
('12.16.06.2006','Sampean'),
('12.16.06.2007','Silaga Laga'),
('12.16.06.2008','Sosor Gonting'),
('12.16.06.2009','Sosor Tambok'),
('12.16.06.2010','Purba Dolok'),
('12.16.06.2011','Sihite I'),
('12.16.06.2012','Lumban Tobing'),
('12.16.06.2013','Hutabagasan'),
('12.16.06.2014','Matiti II'),
('12.16.06.2015','Saitnihuta'),
('12.16.06.2016','Hutaraja'),
('12.16.06.2017','Lumban Purba'),
('12.16.06.2018','Bonanionan'),
('12.16.06.2019','Parik Sinomba'),
('12.16.06.2020','Sihite II'),
('12.16.06.2021','Janji'),
('12.16.06.2022','Pakkat'),
('12.16.06.2023','Sirisirisi'),
('12.16.06.2024','Hutagurgur'),
('12.16.06.2025','Matiti'),
('12.16.06.2026','Aek Lung'),
('12.16.06.2027','Simangaronsang'),
('12.16.06.2028','Sosortolong Sihite III'),
('12.16.07','Sijamapolang'),
('12.16.07.2001','Batunajagar'),
('12.16.07.2002','Sanggaran I'),
('12.16.07.2003','Sitapongan'),
('12.16.07.2004','Sigulok'),
('12.16.07.2005','Hutaginjang'),
('12.16.07.2006','Siborboron'),
('12.16.07.2007','Bonan Dolok I'),
('12.16.07.2008','Bonan Dolok II'),
('12.16.07.2009','Sibuntuon'),
('12.16.07.2010','Nagurguran'),
('12.16.08','Onan Ganjang'),
('12.16.08.2001','Batu Nagodang Siatas'),
('12.16.08.2002','Onan Ganjang'),
('12.16.08.2003','Parbotihan'),
('12.16.08.2004','Sihikit'),
('12.16.08.2005','Parnapa'),
('12.16.08.2006','Janji Nagodang'),
('12.16.08.2007','Sampe Tua'),
('12.16.08.2008','Hutajulu'),
('12.16.08.2009','Sibuluan'),
('12.16.08.2010','Sigalogo'),
('12.16.08.2011','Aek Godang Arbaan'),
('12.16.08.2012','Sanggaran II'),
('12.16.09','Pakkat'),
('12.16.09.2001','Purba Bersatu'),
('12.16.09.2002','Purba Baringin'),
('12.16.09.2003','Karya'),
('12.16.09.2004','Manalu'),
('12.16.09.2005','Sijarango'),
('12.16.09.2006','Tukka Dolok'),
('12.16.09.2007','Siambaton'),
('12.16.09.2008','Parmonangan'),
('12.16.09.2009','Sipagabu'),
('12.16.09.2010','Banuarea'),
('12.16.09.2011','Rura Tanjung'),
('12.16.09.2012','Rura Aek Sopang'),
('12.16.09.2013','Lumban Tonga-Tonga'),
('12.16.09.2014','Pulo Godang'),
('12.16.09.2015','Pakkat Hauagong'),
('12.16.09.2016','Peadungdung'),
('12.16.09.2017','Sijarango I'),
('12.16.09.2018','Ambobi Paranginan'),
('12.16.09.2019','Purba Sianjur'),
('12.16.09.2020','Siambaton Pahae'),
('12.16.09.2021','Panggugunan'),
('12.16.09.2022','Hauagong'),
('12.16.10','Tarabintang'),
('12.16.10.2001','Tarabintang'),
('12.16.10.2002','Sihotang Hasugian Toruan'),
('12.16.10.2003','Sibongkare'),
('12.16.10.2004','Sitanduk'),
('12.16.10.2005','Sihombu'),
('12.16.10.2006','Simbara'),
('12.16.10.2007','Marpadan'),
('12.16.10.2008','Mungkur'),
('12.16.10.2009','Sibongkare Sianju'),
('12.17','Kabupaten Samosir'),
('12.17.01','Simanindo'),
('12.17.01.1016','Tuktuk Siadong'),
('12.17.01.2001','Tomok'),
('12.17.01.2002','Sihusapi'),
('12.17.01.2003','Maduma'),
('12.17.01.2004','Dosroha'),
('12.17.01.2005','Ambarita'),
('12.17.01.2006','Martoba'),
('12.17.01.2007','Garoga'),
('12.17.01.2008','Simanindo Sangkal'),
('12.17.01.2009','Cinta Dame'),
('12.17.01.2010','Huta Ginjang'),
('12.17.01.2011','Pardomuan'),
('12.17.01.2012','Parmonangan'),
('12.17.01.2013','Parbalohan'),
('12.17.01.2014','Tanjungan'),
('12.17.01.2015','Simarmata'),
('12.17.01.2017','Tomok Parsaoran'),
('12.17.01.2018','Marlumba'),
('12.17.01.2019','Simanindo'),
('12.17.01.2020','Unjur'),
('12.17.01.2021','Siallagan Pindaraya'),
('12.17.02','Onan Runggu'),
('12.17.02.2001','Pakpahan'),
('12.17.02.2002','Huta Hotang'),
('12.17.02.2003','Sitinjak'),
('12.17.02.2004','Pardomuan'),
('12.17.02.2005','Tambun Sungkean'),
('12.17.02.2006','Rina Bolak'),
('12.17.02.2007','Onan Runggu'),
('12.17.02.2008','Sitamiang'),
('12.17.02.2009','Janji Matogu'),
('12.17.02.2010','Silima Lombu'),
('12.17.02.2011','Sipira'),
('12.17.02.2012','Harian'),
('12.17.03','Nainggolan'),
('12.17.03.1011','Parhusip III'),
('12.17.03.1012','Sirumahombar'),
('12.17.03.2001','Pangaloan'),
('12.17.03.2002','Hutarihit'),
('12.17.03.2003','Sinaga Uruk Pandiangan'),
('12.17.03.2004','Toguan Galung'),
('12.17.03.2005','Pananggangan'),
('12.17.03.2006','Pasaran Parsaoran'),
('12.17.03.2007','Sipinggan Lumban Siantar'),
('12.17.03.2008','Sibonor Ompu Ratus'),
('12.17.03.2009','Nainggolan'),
('12.17.03.2010','Pasaran I'),
('12.17.03.2013','Pananggangan II'),
('12.17.03.2014','Sipinggan'),
('12.17.03.2015','Janji Marapot'),
('12.17.04','Palipi'),
('12.17.04.2001','Suhutnihuta Pardomuan'),
('12.17.04.2002','Gorat Pallombuan'),
('12.17.04.2003','Urat II'),
('12.17.04.2004','Palipi'),
('12.17.04.2005','Pardomuan Nauli'),
('12.17.04.2006','Hatoguan'),
('12.17.04.2007','Simbolon Purba'),
('12.17.04.2008','Sigaol Simbolon'),
('12.17.04.2009','Urat Timur'),
('12.17.04.2010','Saor Nauli Hatoguan'),
('12.17.04.2011','Parsaoran Urat'),
('12.17.04.2012','Hutaginjang'),
('12.17.04.2014','Sigaol Marbun'),
('12.17.04.2018','Hutadame'),
('12.17.04.2019','Pallombuan'),
('12.17.04.2020','Pamutaran'),
('12.17.04.2021','Sideak'),
('12.17.05','Harian'),
('12.17.05.2001','Sosor Dolok'),
('12.17.05.2002','Partungkonaginjang'),
('12.17.05.2003','Hariara Pohan'),
('12.17.05.2004','Dolok Raja'),
('12.17.05.2006','Sampur Toba'),
('12.17.05.2007','Siparmahan'),
('12.17.05.2008','Turpuk Limbong'),
('12.17.05.2009','Turpuk Sagala'),
('12.17.05.2010','Turpuk Malau'),
('12.17.05.2011','Turpuk Sihotang'),
('12.17.05.2012','Janji Martahan'),
('12.17.05.2014','Hutagalung'),
('12.17.05.2015','Hariara Pintu'),
('12.17.06','Sianjar Mula Mula'),
('12.17.06.2001','Huta Ginjang'),
('12.17.06.2002','Singkam'),
('12.17.06.2003','Hasinggaan'),
('12.17.06.2004','Aek Sipitudai'),
('12.17.06.2005','Huta Gurgur'),
('12.17.06.2006','Sianjur Mula Mula'),
('12.17.06.2007','Boho'),
('12.17.06.2008','Siboro'),
('12.17.06.2009','Simarihit'),
('12.17.06.2010','Ginolat'),
('12.17.06.2011','Bonan Dolok'),
('12.17.06.2012','Habeahan Naburahan'),
('12.17.07','Ronggur Nihuta'),
('12.17.07.2001','Salaon Toba'),
('12.17.07.2002','Lintong Nihuta'),
('12.17.07.2003','Salaon Tonga Tonga'),
('12.17.07.2004','Salaon Dolok'),
('12.17.07.2005','Ronggur Nihuta'),
('12.17.07.2006','Sabungan Nihuta'),
('12.17.07.2007','Paraduan'),
('12.17.07.2008','Sijambur'),
('12.17.08','Pangururan'),
('12.17.08.1026','Pasar Pangururan'),
('12.17.08.1027','Pintu Sona'),
('12.17.08.1028','Siogung-Ogung'),
('12.17.08.2001','Lumban SS Dolok'),
('12.17.08.2002','Lumban SS Torua'),
('12.17.08.2003','Parbaba Dolok'),
('12.17.08.2004','Huta Tinggi'),
('12.17.08.2005','Parhorasan'),
('12.17.08.2006','Pardomuan Nauli'),
('12.17.08.2007','Parsaoran I'),
('12.17.08.2008','Rianiate'),
('12.17.08.2009','Huta Bolon'),
('12.17.08.2010','Panampangan'),
('12.17.08.2011','Pardugul'),
('12.17.08.2012','Huta Namora'),
('12.17.08.2013','Parlondut'),
('12.17.08.2014','Tanjung Bunga'),
('12.17.08.2015','Parmonangan'),
('12.17.08.2016','Sait Nihuta'),
('12.17.08.2017','Situngkir'),
('12.17.08.2018','Sianting-Anting'),
('12.17.08.2019','Sialanguan'),
('12.17.08.2020','Lumban Pinggol'),
('12.17.08.2021','Pardomuan I'),
('12.17.08.2022','Sitolu Huta'),
('12.17.08.2023','Sinabulan'),
('12.17.08.2024','Aek Nauli'),
('12.17.08.2025','Siopat Sosor'),
('12.17.09','Sitio-tio'),
('12.17.09.2001','Holbung'),
('12.17.09.2002','Janji Raja'),
('12.17.09.2003','Sabulan'),
('12.17.09.2004','Buntu Mauli'),
('12.17.09.2005','Tamba Dolok'),
('12.17.09.2006','Cinta Maju'),
('12.17.09.2007','Parsaoran'),
('12.17.09.2008','Janji Maria'),
('12.18','Kabupaten Serdang Bedagai'),
('12.18.01','Pantai Cermin'),
('12.18.01.2001','Pantai Cermin Kanan'),
('12.18.01.2002','Pantai Cermin Kiri'),
('12.18.01.2003','Kota Pari'),
('12.18.01.2004','Celawan'),
('12.18.01.2005','Ujung Rambung'),
('12.18.01.2006','Kuala Lama'),
('12.18.01.2007','Besar II Terjun'),
('12.18.01.2008','Sementara'),
('12.18.01.2009','Ara Payung'),
('12.18.01.2010','Pematang Kasih'),
('12.18.01.2011','Lubuk Saban'),
('12.18.01.2012','Naga Kisar'),
('12.18.02','Perbaungan'),
('12.18.02.1038','Melati I'),
('12.18.02.1039','Simpang Tiga Pekan'),
('12.18.02.1040','Batang Terap'),
('12.18.02.1041','Tualang'),
('12.18.02.2001','Adolina'),
('12.18.02.2003','Bengkel'),
('12.18.02.2005','Cinta Air'),
('12.18.02.2006','Citaman Jernih'),
('12.18.02.2007','Deli Muda Hulu'),
('12.18.02.2008','Deli Muda Hilir'),
('12.18.02.2009','Jambur Pulau'),
('12.18.02.2012','Kesatuan'),
('12.18.02.2013','Kota Galuh'),
('12.18.02.2015','Lidah Tanah'),
('12.18.02.2016','Lubuk Bayas'),
('12.18.02.2017','Lubuk Cemara'),
('12.18.02.2018','Lubuk Dendang'),
('12.18.02.2019','Lubuk Rotan'),
('12.18.02.2020','Melati II'),
('12.18.02.2024','Pematang Sijonam'),
('12.18.02.2025','Pematang Tatal'),
('12.18.02.2028','Suka Beras'),
('12.18.02.2029','Sukajadi'),
('12.18.02.2031','Sei Buluh'),
('12.18.02.2032','Sei Nagalawan'),
('12.18.02.2033','Sei Sijenggi'),
('12.18.02.2034','Tanah Merah'),
('12.18.02.2035','Tanjung Buluh'),
('12.18.03','Teluk Mengkudu'),
('12.18.03.2001','Sei Buluh'),
('12.18.03.2002','Liberia'),
('12.18.03.2003','Mata Pao'),
('12.18.03.2004','Pematang Setrak'),
('12.18.03.2005','Makmur'),
('12.18.03.2006','Pasar Baru'),
('12.18.03.2007','Pekan Sialang Buah'),
('12.18.03.2008','Pematang Guntung'),
('12.18.03.2009','Sialang Buah'),
('12.18.03.2010','Sentang'),
('12.18.03.2011','Bogak Besar'),
('12.18.03.2012','Pematang Kuala'),
('12.18.04','Sei Rampah'),
('12.18.04.2001','Cempedak Lobang'),
('12.18.04.2002','Firdaus'),
('12.18.04.2004','Pergulaan'),
('12.18.04.2006','Sei Rampah'),
('12.18.04.2008','Sei Rejo'),
('12.18.04.2009','Sei Parit'),
('12.18.04.2010','Silau Rakyat'),
('12.18.04.2012','Firdaus Estate'),
('12.18.04.2014','Pematang Ganjang'),
('12.18.04.2015','Pematang Pelintahan'),
('12.18.04.2016','Rambung Estate'),
('12.18.04.2017','Rambung Sialang Hulu'),
('12.18.04.2018','Rambung Sialang Tengah'),
('12.18.04.2019','Rambung Sialang Hilir'),
('12.18.04.2024','Simpang Empat'),
('12.18.04.2026','Sinah Kasih'),
('12.18.04.2027','Tanah Raja'),
('12.18.05','Tanjung Beringin'),
('12.18.05.2001','Pekan Tanjung Beringin'),
('12.18.05.2002','Nagur'),
('12.18.05.2003','Mangga Dua'),
('12.18.05.2004','Sukajadi'),
('12.18.05.2005','Tebing Tinggi'),
('12.18.05.2006','Pematang Cermai'),
('12.18.05.2007','Pematang Terang'),
('12.18.05.2008','Bagan Kuala'),
('12.18.06','Bandar Khalipah'),
('12.18.06.2001','Bandar Tengah'),
('12.18.06.2002','Juhar'),
('12.18.06.2003','Gelam Sei Serimah'),
('12.18.06.2004','Pekan Bandar Khalipah'),
('12.18.06.2005','Kayu Besar'),
('12.18.07','Dolok Merawan'),
('12.18.07.2001','Nagaraja I'),
('12.18.07.2002','Panglong'),
('12.18.07.2003','Bandarawan'),
('12.18.07.2004','Gunung Para II'),
('12.18.07.2005','Limbong'),
('12.18.07.2006','Dolok Merawan'),
('12.18.07.2007','Paritokan'),
('12.18.07.2008','Kalembak'),
('12.18.07.2009','Afd. VI Dolok Ilir'),
('12.18.07.2010','Pabatu I'),
('12.18.07.2011','Afd. VII Dolok Ilir'),
('12.18.07.2012','Pabatu II'),
('12.18.07.2013','Mainu Tengah'),
('12.18.07.2014','Bahdamar'),
('12.18.07.2015','Pabatu III'),
('12.18.07.2016','Pabatu VI'),
('12.18.07.2017','Korajim'),
('12.18.08','Sipispis'),
('12.18.08.2001','Sipispis'),
('12.18.08.2002','Serbananti'),
('12.18.08.2003','Bartong'),
('12.18.08.2004','Marubun'),
('12.18.08.2005','Pispis'),
('12.18.08.2006','Baja Dolok'),
('12.18.08.2007','Tinokkah'),
('12.18.08.2008','Nagur Pane'),
('12.18.08.2009','Parlambean'),
('12.18.08.2010','Naga Raja'),
('12.18.08.2011','Mariah Nagur'),
('12.18.08.2012','Rimbun'),
('12.18.08.2013','Marjanji'),
('12.18.08.2014','Silau Padang'),
('12.18.08.2015','Buluh Duri'),
('12.18.08.2016','Gunung Monako'),
('12.18.08.2017','Damak Urat'),
('12.18.08.2018','Simalas'),
('12.18.08.2019','Gunung Pane'),
('12.18.08.2020','Sibarau'),
('12.18.09','Dolok Masihul'),
('12.18.09.1029','Pekan Dolok Masihul'),
('12.18.09.2001','Dame'),
('12.18.09.2002','Blok 10'),
('12.18.09.2003','Kota Tengah'),
('12.18.09.2004','Silau Merawan'),
('12.18.09.2005','Pekan Kamis'),
('12.18.09.2006','Batu 12'),
('12.18.09.2007','Batu 13'),
('12.18.09.2008','Baja Ronggi'),
('12.18.09.2009','Dolok Sagala'),
('12.18.09.2010','Dolok Manampang'),
('12.18.09.2011','Pardomuan'),
('12.18.09.2012','Tegal Sari'),
('12.18.09.2013','Pertambatan'),
('12.18.09.2015','Huta Nauli'),
('12.18.09.2016','Bantan'),
('12.18.09.2017','Bukit Cermin Hilir'),
('12.18.09.2018','Malasori'),
('12.18.09.2019','Sarang Giting'),
('12.18.09.2020','Durian Puloan'),
('12.18.09.2021','Sarang Torop'),
('12.18.09.2022','Havea'),
('12.18.09.2023','Aras Panjang'),
('12.18.09.2024','Martebing'),
('12.18.09.2025','Kerapuh'),
('12.18.09.2026','Tanjung Maria'),
('12.18.09.2027','Bah Kerapuh'),
('12.18.09.2028','Ujung Silau'),
('12.18.10','Kotarih'),
('12.18.10.2001','Kotarih Pekan'),
('12.18.10.2002','Kotarih Baru'),
('12.18.10.2003','Banjaran Godang'),
('12.18.10.2004','Si Ujan Ujan'),
('12.18.10.2010','Sei Kari'),
('12.18.10.2013','Bandar Bayu'),
('12.18.10.2014','Durian Kondot'),
('12.18.10.2015','Perbahingan'),
('12.18.10.2022','Sialtong'),
('12.18.10.2023','Huta Galuh'),
('12.18.10.2024','Rubun Dunia'),
('12.18.11','Silinda'),
('12.18.11.2004','Batu Masagi'),
('12.18.11.2013','Damak Gelugur'),
('12.18.11.2016','Kulasar'),
('12.18.11.2021','Pagar Manik'),
('12.18.11.2022','Pamah'),
('12.18.11.2026','Silinda'),
('12.18.11.2028','Sungai Buaya'),
('12.18.11.2029','Tarean'),
('12.18.11.2031','Tapak Meriah'),
('12.18.12','Serba Jadi'),
('12.18.12.2010','Tanjung Harap'),
('12.18.12.2011','Kuala Bali'),
('12.18.12.2014','Karang Tengah'),
('12.18.12.2015','Kelapa Bajohom'),
('12.18.12.2018','Manggis'),
('12.18.12.2020','Pulau Gambar'),
('12.18.12.2021','Pulau Tagor'),
('12.18.12.2032','Serba Jadi'),
('12.18.12.2033','Tambak Cekur'),
('12.18.12.2038','Bah Sidua-dua'),
('12.18.13','Tebing Tinggi'),
('12.18.13.2001','Bah Sumbu'),
('12.18.13.2002','Naga Kesiangan'),
('12.18.13.2003','Jambu'),
('12.18.13.2004','Mariah Padang'),
('12.18.13.2005','Pertapaan'),
('12.18.13.2006','Paya Lombang'),
('12.18.13.2007','Sei Serimah'),
('12.18.13.2008','Paya Bagas'),
('12.18.13.2009','Paya Mabar'),
('12.18.13.2010','Sei. Priok'),
('12.18.13.2011','Kuta Baru'),
('12.18.13.2018','Kedai Damar'),
('12.18.13.2019','Penonggol'),
('12.18.13.2020','Gunung Kataran'),
('12.18.14','Pegajahan'),
('12.18.14.1012','Melati Kebun'),
('12.18.14.2001','Bengabing'),
('12.18.14.2002','Bingkat'),
('12.18.14.2003','Jati Mulyo'),
('12.18.14.2004','Karang Anyar'),
('12.18.14.2005','Lestari Dadi'),
('12.18.14.2006','Pegajahan'),
('12.18.14.2007','Petuaran Hulu'),
('12.18.14.2008','Petuaran Hilir'),
('12.18.14.2009','Pondok Tengah'),
('12.18.14.2010','Sukasari'),
('12.18.14.2011','Tanjung Putus'),
('12.18.14.2013','Sennah'),
('12.18.15','Sei Bamban'),
('12.18.15.2001','Pon'),
('12.18.15.2002','Sei Bamban'),
('12.18.15.2003','Bakaran Batu'),
('12.18.15.2004','Gempolan'),
('12.18.15.2005','Rampah Estate'),
('12.18.15.2006','Suka Damai'),
('12.18.15.2007','Sei Bamban Estate'),
('12.18.15.2008','Sei Belutu'),
('12.18.15.2009','Sei Buluh'),
('12.18.15.2010','Penggalangan'),
('12.18.16','Tebing Syahbandar'),
('12.18.16.2001','Penggalian'),
('12.18.16.2002','Laut Tador'),
('12.18.16.2003','Tanah Besih'),
('12.18.16.2004','Binjai'),
('12.18.16.2005','Paya Pasir'),
('12.18.16.2006','Bahilang'),
('12.18.16.2007','Penggalangan'),
('12.18.16.2008','Paya Pinang'),
('12.18.16.2009','Kuta Pinang'),
('12.18.16.2010','Sibulan'),
('12.18.17','Bintang Bayu'),
('12.18.17.2001','Gudang Garam'),
('12.18.17.2002','Dolok Masango'),
('12.18.17.2003','Panombean'),
('12.18.17.2004','Bandar Negeri'),
('12.18.17.2005','Ujung Negeri Kahan'),
('12.18.17.2006','Bandar Magodang'),
('12.18.17.2007','Ujung Negeri Hulu'),
('12.18.17.2008','Pegajahan Hulu'),
('12.18.17.2009','Marihat Dolok'),
('12.18.17.2010','Bintang Bayu'),
('12.18.17.2011','Bandar Pinang Kebun'),
('12.18.17.2012','Damak Tolong Buho'),
('12.18.17.2013','Bandar Pinang Rambe'),
('12.18.17.2014','Pegajahan Kahan'),
('12.18.17.2015','Huta Durian'),
('12.18.17.2016','Kampung Kristen'),
('12.18.17.2017','Sarang Ginting Kahan'),
('12.18.17.2018','Sarang Ginting Hulu'),
('12.18.17.2019','Siahap'),
('12.19','Kabupaten Batu Bara'),
('12.19.01','Medang Deras'),
('12.19.01.1001','Pangkalan Dodek'),
('12.19.01.1002','Pangkalan Dodek Baru'),
('12.19.01.1021','Pagurawan'),
('12.19.01.2003','Aek Nauli'),
('12.19.01.2004','Durian'),
('12.19.01.2005','Lalang'),
('12.19.01.2006','Medang'),
('12.19.01.2007','Pakam'),
('12.19.01.2008','Pakam Raya'),
('12.19.01.2009','Pematang Cengkering'),
('12.19.01.2010','Sei Buah Keras'),
('12.19.01.2011','Sei Rakyat'),
('12.19.01.2012','Sidomulyo'),
('12.19.01.2013','Tanjung Sigoni'),
('12.19.01.2014','Nenas Siam'),
('12.19.01.2015','Pakam Raya Selatan'),
('12.19.01.2016','Mandarsah'),
('12.19.01.2017','Medang Baru'),
('12.19.01.2018','Pematang Nibung'),
('12.19.01.2019','Cengkering Pekan'),
('12.19.01.2020','Sei Raja'),
('12.19.02','Sei Suka'),
('12.19.02.1001','Perkebunan Sipare pare'),
('12.19.02.2007','Sei Suka Deras'),
('12.19.02.2008','Simodong'),
('12.19.02.2009','Pematang Jering'),
('12.19.02.2010','Pematang Kuning'),
('12.19.02.2011','Kuala Indah'),
('12.19.02.2012','Kuala Tanjung'),
('12.19.02.2018','Tanjung Gading'),
('12.19.02.2019','Simpang Kopi'),
('12.19.02.2020','Brohol'),
('12.19.03','Air Putih'),
('12.19.03.1001','Indrapura'),
('12.19.03.1019','Indrasakti'),
('12.19.03.2002','Limau Sundai'),
('12.19.03.2003','Pematang Panjang'),
('12.19.03.2004','Sukaraja'),
('12.19.03.2005','Tanah Tinggi'),
('12.19.03.2006','Tanjungmuda'),
('12.19.03.2007','Tanah Merah'),
('12.19.03.2008','Aras'),
('12.19.03.2009','Pasar Lapan'),
('12.19.03.2010','Sipare-pare'),
('12.19.03.2011','Tanjungkubah'),
('12.19.03.2012','Tanjungharapan'),
('12.19.03.2013','Suka Ramai'),
('12.19.03.2014','Tanah Rendah'),
('12.19.03.2015','Tanjungmulya'),
('12.19.03.2016','Titi Payung'),
('12.19.03.2017','Perkotaan'),
('12.19.03.2018','Kampung Kelapa'),
('12.19.04','Lima Puluh'),
('12.19.04.1001','Lima Puluh Kota'),
('12.19.04.2011','Mangkai Baru'),
('12.19.04.2012','Mangkai Lama'),
('12.19.04.2014','Perkebunan Dolok'),
('12.19.04.2015','Perkebunan Kwala Gunung'),
('12.19.04.2016','Antara'),
('12.19.04.2017','Perkebunan Lima Puluh'),
('12.19.04.2018','Perkebunan Limau Manis'),
('12.19.04.2019','Perkebunan Tanah Gambus'),
('12.19.04.2025','Simpang Gambus'),
('12.19.04.2026','Sumber Makmur'),
('12.19.04.2027','Sumber Padi'),
('12.19.05','Talawi'),
('12.19.05.1001','Labuhan Ruku'),
('12.19.05.2004','Dahari Selebar'),
('12.19.05.2006','Mesjid Lama'),
('12.19.05.2007','Padang Genting'),
('12.19.05.2008','Pahang'),
('12.19.05.2009','Panjang'),
('12.19.05.2014','Gunung Rante'),
('12.19.05.2015','Dahari Indah'),
('12.19.05.2016','Indra Yaman'),
('12.19.05.2017','Benteng'),
('12.19.06','Tanjung Tiram'),
('12.19.06.1001','Tanjung Tiram'),
('12.19.06.1022','Bagan Arya'),
('12.19.06.2002','Guntung'),
('12.19.06.2004','Bagan Dalam'),
('12.19.06.2005','Bogak'),
('12.19.06.2006','Suka Maju'),
('12.19.06.2016','Suka Jaya'),
('12.19.06.2017','Pahlawan'),
('12.19.06.2018','Bandar Rahmat'),
('12.19.06.2019','Kampung Lalang'),
('12.19.07','Sei Balai'),
('12.19.07.2001','Kwala Sikasim'),
('12.19.07.2002','Sei Balai'),
('12.19.07.2004','Durian'),
('12.19.07.2005','Perkebunan Sei Balai'),
('12.19.07.2007','Suka Ramai'),
('12.19.07.2008','Sei Bejangkar'),
('12.19.07.2009','Mekar Mulio'),
('12.19.07.2010','Perkebunan Sei Bejangkar'),
('12.19.07.2012','Benteng Jaya'),
('12.19.07.2013','Tanah Timbul'),
('12.19.07.2014','Perjuangan'),
('12.19.07.2015','Sidomulio'),
('12.19.07.2016','Mekar Baru'),
('12.19.07.2017','Suko Rejo'),
('12.19.08','Laut Tador'),
('12.19.08.2001','Tanjung Prapat'),
('12.19.08.2002','Laut Tador'),
('12.19.08.2003','Pelanggiran Laut Tador'),
('12.19.08.2004','Perkebunan Tanjung Kasau'),
('12.19.08.2005','Dewi Sri'),
('12.19.08.2006','Tanjung Kasau'),
('12.19.08.2007','Tanjung Seri'),
('12.19.08.2008','Mekar Sari'),
('12.19.08.2009','Sei Simujur'),
('12.19.08.2010','Kandangan'),
('12.19.09','Lima Puluh Pesisir'),
('12.19.09.2001','Gambus Laut'),
('12.19.09.2002','Perupuk'),
('12.19.09.2003','Guntung'),
('12.19.09.2004','Barung-Barung'),
('12.19.09.2005','Titi Putih'),
('12.19.09.2006','Pasir Permit'),
('12.19.09.2007','Titi Merah'),
('12.19.09.2008','Pematang Panjang'),
('12.19.09.2009','Bulan-Bulan'),
('12.19.09.2010','Gunung Bandung'),
('12.19.09.2011','Lubuk Cuik'),
('12.19.09.2012','Tanah Itam Ilir'),
('12.19.09.2013','Pematang Tengah'),
('12.19.10','Datuk Lima Puluh'),
('12.19.10.2001','Perkebunan Tanah Itam Ulu'),
('12.19.10.2002','Empat Negeri'),
('12.19.10.2003','Sumber Rejo'),
('12.19.10.2004','Lubuk Hulu'),
('12.19.10.2005','Lubuk Besar'),
('12.19.10.2006','Pulau Sejuk'),
('12.19.10.2007','Simpang Dolok'),
('12.19.10.2008','Air Hitam'),
('12.19.10.2009','Kwala Gunung'),
('12.19.10.2010','Cahaya Pardomuan'),
('12.19.11','Datuk Tanah Datar'),
('12.19.11.2001','Sumber Tani'),
('12.19.11.2002','Sei Muka'),
('12.19.11.2003','Perkebunan Tanah Datar'),
('12.19.11.2004','Binjai Baru'),
('12.19.11.2005','Bangun Sari'),
('12.19.11.2006','Karang Baru'),
('12.19.11.2007','Perkebunan Petatal'),
('12.19.11.2008','Mekar Baru'),
('12.19.11.2009','Petatal'),
('12.19.11.2010','Glugur Makmur'),
('12.19.12','Nibung Hangus'),
('12.19.12.2001','Sentang'),
('12.19.12.2002','Tanjung Mulia'),
('12.19.12.2003','Jati Mulia'),
('12.19.12.2004','Lima Laras'),
('12.19.12.2005','Mekar Laras'),
('12.19.12.2006','Bandar Sono'),
('12.19.12.2007','Ujung Kubu'),
('12.19.12.2008','Sei Mentaram'),
('12.19.12.2009','Pematang Rambai'),
('12.19.12.2010','Tali Air Permai'),
('12.19.12.2011','Bagan Baru'),
('12.19.12.2012','Kapal Merah'),
('12.20','Kabupaten Padang Lawas Utara'),
('12.20.01','Dolok Sigompulon'),
('12.20.01.2001','Janji Manahan GNT'),
('12.20.01.2002','Pasang Lela'),
('12.20.01.2003','Aek Jabut'),
('12.20.01.2004','Nabundong'),
('12.20.01.2005','Gunung Sormin'),
('12.20.01.2006','Sihalo Halo'),
('12.20.01.2007','Kuala Simpang'),
('12.20.01.2008','Simundol'),
('12.20.01.2009','Nahula Julu'),
('12.20.01.2010','Simaninggir Simundol'),
('12.20.01.2011','Simangambat'),
('12.20.01.2012','Saba Bangun'),
('12.20.01.2013','Malino'),
('12.20.01.2014','Gonting Bange'),
('12.20.01.2015','Hutaimbaru Simundol'),
('12.20.01.2016','Padang Matinggi Simundol'),
('12.20.01.2017','Sunut'),
('12.20.01.2018','Batu Hibul'),
('12.20.01.2019','Sigordang'),
('12.20.01.2020','Pamarai'),
('12.20.01.2021','Padang Matinggi GNT'),
('12.20.01.2022','Gadung Holbung'),
('12.20.01.2023','Salusuhan'),
('12.20.01.2024','Panyabungan'),
('12.20.01.2025','Sayur Matinggi'),
('12.20.01.2026','Hasahatan'),
('12.20.01.2027','Pinarik'),
('12.20.01.2028','Unte Manis'),
('12.20.01.2029','Sipogas'),
('12.20.01.2030','Sipogas A'),
('12.20.01.2031','Padang Malakka'),
('12.20.01.2032','Aek Simanap'),
('12.20.01.2033','Pulo Liman'),
('12.20.01.2034','Aek Kundur'),
('12.20.01.2035','Hatiran'),
('12.20.01.2036','Karang Anyar'),
('12.20.01.2037','Aek Kanan'),
('12.20.01.2038','Nahula Jae'),
('12.20.01.2039','Simadihon'),
('12.20.01.2040','Pasar Sayur Matinggi'),
('12.20.01.2041','Tj. Baru Silaiya'),
('12.20.01.2042','Sitonun'),
('12.20.01.2043','Pasar Simundol'),
('12.20.01.2044','Pamonoran'),
('12.20.02','Dolok'),
('12.20.02.2001','Siguga'),
('12.20.02.2002','Singanyal'),
('12.20.02.2003','Binanga Panasahan'),
('12.20.02.2004','Aek Haruaya'),
('12.20.02.2005','Tanjung Baru B'),
('12.20.02.2006','Pasar Sipiongot'),
('12.20.02.2007','Bintais Julu'),
('12.20.02.2008','Bunut'),
('12.20.02.2009','Paya Ombik'),
('12.20.02.2010','Aek Suhat Jae'),
('12.20.02.2011','Huta Baru Sil'),
('12.20.02.2012','Sijorang'),
('12.20.02.2013','Simaninggir Sip'),
('12.20.02.2014','Pangaran Julu I'),
('12.20.02.2015','Mompang Lombang'),
('12.20.02.2016','Janji Manahan Sil'),
('12.20.02.2017','Baringin Sip'),
('12.20.02.2018','Gunung Maria'),
('12.20.02.2019','Mompang Dolok'),
('12.20.02.2020','Aek Rao TN'),
('12.20.02.2021','Sijantung Julu'),
('12.20.02.2022','Batu Runding'),
('12.20.02.2023','Lubuk Godang'),
('12.20.02.2024','Bahap'),
('12.20.02.2025','Aek Ilung'),
('12.20.02.2026','Tarutung Bolak'),
('12.20.02.2027','Sungai Pining'),
('12.20.02.2028','Siloung'),
('12.20.02.2029','Hutaimbaru Gul'),
('12.20.02.2030','Sipiongot'),
('12.20.02.2031','Gumbot'),
('12.20.02.2032','Gunung Selamat'),
('12.20.02.2033','Silogo Logo'),
('12.20.02.2034','Lubuk Kundur'),
('12.20.02.2035','Jambur Batu'),
('12.20.02.2036','Simatorkis'),
('12.20.02.2037','Rancaran'),
('12.20.02.2038','Naga Saribu'),
('12.20.02.2039','Simataniari Jae'),
('12.20.02.2040','Janji Manahan Gul'),
('12.20.02.2041','Simataniari'),
('12.20.02.2042','Parmeraan'),
('12.20.02.2043','Panca'),
('12.20.02.2044','Dalihan Natolu'),
('12.20.02.2045','Sungai Datar'),
('12.20.02.2046','Lubuk Lanjang'),
('12.20.02.2047','Arse'),
('12.20.02.2048','Simangambat Tua'),
('12.20.02.2049','Sigala Gala'),
('12.20.02.2050','Sibayo Jae'),
('12.20.02.2051','Dolok Sanggul'),
('12.20.02.2052','Silangge'),
('12.20.02.2053','Pijor Koling'),
('12.20.02.2054','Pagaran Julu II'),
('12.20.02.2055','Siala Gundi'),
('12.20.02.2056','Siraga HP'),
('12.20.02.2057','Aek Sundur'),
('12.20.02.2058','Baringin Sil'),
('12.20.02.2059','Hula Baringin'),
('12.20.02.2060','Nabonggal'),
('12.20.02.2061','Purba Tua'),
('12.20.02.2062','Tanjung Longat'),
('12.20.02.2063','Sibio Bio'),
('12.20.02.2064','Situmbaga'),
('12.20.02.2065','Sijara Jara'),
('12.20.02.2066','Huta Baru Sip'),
('12.20.02.2067','Pagaran Siregar'),
('12.20.02.2068','Parigi'),
('12.20.02.2069','Napasundali'),
('12.20.02.2070','Aek Suhat TR'),
('12.20.02.2071','Gumaruntar'),
('12.20.02.2072','Sijantung Jae'),
('12.20.02.2073','Janji Matogu'),
('12.20.02.2074','Sialang Dolok'),
('12.20.02.2075','Binanga Gumbot'),
('12.20.02.2076','Simanosor'),
('12.20.02.2077','Bukit Tinggi'),
('12.20.02.2078','Simambal'),
('12.20.02.2079','Bandar Nauli'),
('12.20.02.2080','Sibayo'),
('12.20.02.2081','Sinabongan'),
('12.20.02.2082','Siranap'),
('12.20.02.2083','Aek Tangga'),
('12.20.02.2084','Rongkare'),
('12.20.02.2085','Siburbur'),
('12.20.02.2086','Pintu Padang Merdeka'),
('12.20.03','Halongonan'),
('12.20.03.2001','Hutaimbaru'),
('12.20.03.2002','Hambulo'),
('12.20.03.2003','Paolan'),
('12.20.03.2004','Pangirkiran'),
('12.20.03.2005','Balimbing'),
('12.20.03.2006','Rondaman Siburegar'),
('12.20.03.2007','Sipaho'),
('12.20.03.2008','Silantoyung'),
('12.20.03.2009','Hiteurat'),
('12.20.03.2010','Siboru Angin'),
('12.20.03.2011','Sandean Jae'),
('12.20.03.2012','Sandean Tonga'),
('12.20.03.2013','Sandean Julu'),
('12.20.03.2014','Hasahatan'),
('12.20.03.2015','Pagar Gunung'),
('12.20.03.2016','Pangarambangan'),
('12.20.03.2017','Napa Lancat'),
('12.20.03.2018','Halongonan'),
('12.20.03.2019','Bargot Topong Julu'),
('12.20.03.2020','Bargot Topong Jae'),
('12.20.03.2021','Siringki Jae'),
('12.20.03.2022','Ujung Padang'),
('12.20.03.2023','Sigala Gala'),
('12.20.03.2032','Hutanopan'),
('12.20.03.2036','Sipenggeng'),
('12.20.03.2037','Saba'),
('12.20.03.2038','Sitabola'),
('12.20.03.2039','Sitonun'),
('12.20.03.2040','Tapus Jae'),
('12.20.03.2041','Japinulik'),
('12.20.03.2042','Paran Honas'),
('12.20.03.2043','Siringki Julu'),
('12.20.03.2044','Batu Tunggal'),
('12.20.04','Padang Bolak'),
('12.20.04.1001','Pasar Gunung Tua'),
('12.20.04.2008','Lubuk Torop'),
('12.20.04.2012','Tanjung Marulak'),
('12.20.04.2013','Ambasang Natigor'),
('12.20.04.2014','Napagadung Laut'),
('12.20.04.2015','Rampa Jae'),
('12.20.04.2016','Rampa Julu'),
('12.20.04.2017','Mananti'),
('12.20.04.2018','Paran Padang'),
('12.20.04.2019','Rahuning Jae'),
('12.20.04.2020','Botung'),
('12.20.04.2021','Sigimbal'),
('12.20.04.2022','Dolok Sae'),
('12.20.04.2023','Simasi'),
('12.20.04.2024','Sihapas Hapas'),
('12.20.04.2025','Sungai Tolang'),
('12.20.04.2026','Losung Batu'),
('12.20.04.2027','Batu Mamak'),
('12.20.04.2028','Sampuran'),
('12.20.04.2029','Gunung Tua Baru'),
('12.20.04.2030','Sibatang Kayu'),
('12.20.04.2031','Aek Suhat'),
('12.20.04.2038','Gunung Tua Tonga'),
('12.20.04.2039','Gunung Tua Jae'),
('12.20.04.2040','Gunung Tua Julu'),
('12.20.04.2041','Hutalombang'),
('12.20.04.2042','Batang Baruhar Julu'),
('12.20.04.2043','Batang Baruhar Jae'),
('12.20.04.2044','Purba Sinomba'),
('12.20.04.2045','Hambiri'),
('12.20.04.2046','Sosopan'),
('12.20.04.2047','Pagaran Singkam'),
('12.20.04.2048','Pagaran Tonga'),
('12.20.04.2049','Sibagasi'),
('12.20.04.2050','Batu Tambun'),
('12.20.04.2051','Tanjung Tiram'),
('12.20.04.2052','Garoga'),
('12.20.04.2053','Hajoran'),
('12.20.04.2054','Batu Sundung'),
('12.20.04.2055','Garonggang'),
('12.20.04.2056','Nabonggal'),
('12.20.04.2057','Liang Hasona'),
('12.20.04.2058','Simandiangin Dolok'),
('12.20.04.2059','Simandiangin Lombang'),
('12.20.04.2060','Padang Garugur'),
('12.20.04.2061','Simanosor'),
('12.20.04.2062','Sigama'),
('12.20.04.2063','Sigama Ujung Gading'),
('12.20.04.2064','Parlimbatan'),
('12.20.04.2065','Saba Sitahul tahul'),
('12.20.04.2066','Saba Bangunan'),
('12.20.04.2067','Sidingkat'),
('12.20.04.2069','Gunung Manaon II'),
('12.20.04.2070','Purba Tua'),
('12.20.04.2071','Sungai Durian'),
('12.20.04.2072','Sungai Orosan'),
('12.20.04.2073','Hutaimbaru II'),
('12.20.04.2074','Siombob'),
('12.20.04.2075','Aek Gambir'),
('12.20.04.2076','Bukit Raya Sordang'),
('12.20.04.2077','Aek Jangkang'),
('12.20.04.2078','Simbolon'),
('12.20.05','Padang Bolak Julu'),
('12.20.05.2001','Pancur Pangko'),
('12.20.05.2002','Hasambi'),
('12.20.05.2003','Paran Nangka'),
('12.20.05.2004','Batu Rancang'),
('12.20.05.2005','Sitanggoru'),
('12.20.05.2006','Siunggam Dolok'),
('12.20.05.2007','Balimbing Jae'),
('12.20.05.2008','Sipupus Lombang'),
('12.20.05.2009','Balimbing Julu'),
('12.20.05.2010','Sobar'),
('12.20.05.2011','Pamuntaran'),
('12.20.05.2012','Paran Gadung'),
('12.20.05.2013','Padang Bujur'),
('12.20.05.2014','Ubar'),
('12.20.05.2015','Lantosan II'),
('12.20.05.2016','Batu Gana'),
('12.20.05.2017','Padang Baruas'),
('12.20.05.2018','Aek Bargot'),
('12.20.05.2019','Gariang'),
('12.20.05.2020','Balakka'),
('12.20.05.2021','Parupuk Jae'),
('12.20.05.2022','Parupuk Julu'),
('12.20.05.2023','Sialang'),
('12.20.06','Portibi'),
('12.20.06.2002','Sitopayan'),
('12.20.06.2003','Lantosan I'),
('12.20.06.2004','Aek Haruaya'),
('12.20.06.2005','Gunung Baringin'),
('12.20.06.2006','Hadungdung'),
('12.20.06.2007','Rondaman Dolok'),
('12.20.06.2008','Sipirok'),
('12.20.06.2009','Tanjung Salamat'),
('12.20.06.2010','Rondaman Lombang'),
('12.20.06.2011','Parsarmaan'),
('12.20.06.2012','Aloban'),
('12.20.06.2013','Portibi Julu'),
('12.20.06.2014','Portibi Jae'),
('12.20.06.2015','Gunung Manaon I'),
('12.20.06.2016','Pasir Pinang'),
('12.20.06.2017','Bahal'),
('12.20.06.2018','Bara'),
('12.20.06.2019','Simandiangin'),
('12.20.06.2020','Hotang Sasa'),
('12.20.06.2021','Aek Siala'),
('12.20.06.2022','Gumarupu Baru'),
('12.20.06.2023','Padang Manjoir'),
('12.20.06.2024','Gumarupu Lama'),
('12.20.06.2025','Gunung Martua'),
('12.20.06.2026','Sihambeng'),
('12.20.06.2027','Aek Torop'),
('12.20.06.2028','Napa Lombang'),
('12.20.06.2029','Mangaledang Lama'),
('12.20.06.2030','Mangaledang'),
('12.20.06.2031','Bangkudu'),
('12.20.06.2032','Balakka Torop'),
('12.20.06.2033','Janji Matogu'),
('12.20.06.2034','Muara Sigama'),
('12.20.06.2035','Napahalas'),
('12.20.06.2036','Sigama Napahalas'),
('12.20.06.2039','Torluk Muara Dolok'),
('12.20.07','Batang Onang'),
('12.20.07.1001','Sayur Matinggi'),
('12.20.07.2002','Pangkal Dolok Lama'),
('12.20.07.2003','Pangkal Dolok Julu'),
('12.20.07.2004','Pintu Padang'),
('12.20.07.2005','Batang Onang Lama'),
('12.20.07.2006','Bonan Dolok'),
('12.20.07.2007','Simardona'),
('12.20.07.2008','Batang Onang Baru'),
('12.20.07.2009','Parau Sorat'),
('12.20.07.2010','Pasar Matanggor'),
('12.20.07.2011','Batu Pulut'),
('12.20.07.2012','Huta Lambung'),
('12.20.07.2013','Galanggang'),
('12.20.07.2014','Gunungtua Tumbu Jati'),
('12.20.07.2015','Gunungtua Batang Onang'),
('12.20.07.2016','Simanapang'),
('12.20.07.2017','Simaninggir'),
('12.20.07.2018','Batu Mamak'),
('12.20.07.2019','Padang Garugur'),
('12.20.07.2020','Padang Matinggi'),
('12.20.07.2021','Purba Tua'),
('12.20.07.2022','Janji Mauli'),
('12.20.07.2023','Sayur Matinggi Julu'),
('12.20.07.2024','Gunung Tua Julu'),
('12.20.07.2025','Pasir Ampolu Hopong'),
('12.20.07.2026','Pagaran Batu'),
('12.20.07.2027','Tamosu'),
('12.20.07.2028','Simangambat Dolok'),
('12.20.07.2029','Janji Manahan'),
('12.20.07.2030','Padang Bujur Baru'),
('12.20.07.2031','Batu Nanggar'),
('12.20.07.2032','Morang'),
('12.20.08','Simangambat'),
('12.20.08.2014','Ulak Tano'),
('12.20.08.2015','Aekraru'),
('12.20.08.2016','Tanjung Maria'),
('12.20.08.2017','Mandasip'),
('12.20.08.2018','Huta Baru'),
('12.20.08.2019','Janji Matogu'),
('12.20.08.2020','Paran Padang'),
('12.20.08.2021','Tanjung Botung'),
('12.20.08.2022','Huta Pasir'),
('12.20.08.2023','Langkimat'),
('12.20.08.2024','Jabi Jabi'),
('12.20.08.2025','Simangambat Jae'),
('12.20.08.2026','Ujung Gading Jae'),
('12.20.08.2027','Huta Baringin'),
('12.20.08.2028','Gunung Manaon Sim'),
('12.20.08.2029','Sionggoton'),
('12.20.08.2030','Paran Tonga Sim'),
('12.20.08.2031','Ujung Gading Julu'),
('12.20.08.2032','Simangambat Julu'),
('12.20.08.2033','Sigagan'),
('12.20.08.2034','Kosik Putih'),
('12.20.09','Hulu Sihapas'),
('12.20.09.2001','Aek Godang'),
('12.20.09.2002','Aek Nauli'),
('12.20.09.2003','Sampuran Simarloting'),
('12.20.09.2004','Pangirkiran'),
('12.20.09.2005','Simaninggir'),
('12.20.09.2006','Suka Dame'),
('12.20.09.2007','Pintu Bosi'),
('12.20.09.2008','Sidong-dong'),
('12.20.09.2009','Sitabar'),
('12.20.09.2010','Parmeraan'),
('12.20.10','Padang Bolak Tenggara'),
('12.20.10.2001','Siunggam Julu'),
('12.20.10.2002','Siunggam Tonga'),
('12.20.10.2003','Siunggam Jae'),
('12.20.10.2004','Aek Bayur'),
('12.20.10.2005','Aek Tolong'),
('12.20.10.2006','Tangga-Tangga Hambeng'),
('12.20.10.2007','Simaninggir'),
('12.20.10.2008','Bangun Purba'),
('12.20.10.2009','Naga Saribu'),
('12.20.10.2010','Sihoda-Hoda'),
('12.20.10.2011','Mompang II'),
('12.20.10.2012','Gulangan'),
('12.20.10.2013','Pijor Koling'),
('12.20.10.2014','Purba Tua Dolok'),
('12.20.11','Halongonan Timur'),
('12.20.11.2001','Siancimun'),
('12.20.11.2002','Bolatan'),
('12.20.11.2003','Pasir Bara'),
('12.20.11.2004','Gunung Intan'),
('12.20.11.2005','Mompang I'),
('12.20.11.2006','Gunung Manaon III'),
('12.20.11.2007','Sihopuk Baru'),
('12.20.11.2008','Sihopuk Lama'),
('12.20.11.2009','Rondaman'),
('12.20.11.2010','Hutabaru Nangka'),
('12.20.11.2011','Situmbaga'),
('12.20.11.2012','Batang Pane I'),
('12.20.11.2013','Batang Pane II'),
('12.20.11.2014','Batang Pane III'),
('12.20.12','Ujung Batu'),
('12.20.12.2001','Huta Raja'),
('12.20.12.2002','Ujung Batu Julu'),
('12.20.12.2003','Gunung Manaon UB'),
('12.20.12.2004','Labuhan Jurung'),
('12.20.12.2005','Martujuan'),
('12.20.12.2006','Paya Bahung UB'),
('12.20.12.2007','Tobing Tinggi UB'),
('12.20.12.2008','Ujung Batu Jae'),
('12.20.12.2009','Marlaung'),
('12.20.12.2010','Mananti'),
('12.20.12.2011','Jambu Tonang'),
('12.20.12.2012','Manare Tua'),
('12.20.12.2013','Pasir Lancat UB'),
('12.21','Kabupaten Padang Lawas'),
('12.21.01','Sosopan'),
('12.21.01.2001','Pagaranbira Jae'),
('12.21.01.2002','Pagaran Bira Julu'),
('12.21.01.2003','Huta Bargot'),
('12.21.01.2004','Siundol Jae'),
('12.21.01.2005','Siundol Julu'),
('12.21.01.2006','Siundol Dolok'),
('12.21.01.2007','Hutabaru Siundol'),
('12.21.01.2008','Binanga Tolu'),
('12.21.01.2009','Aek Bargot'),
('12.21.01.2010','Ulu Aer'),
('12.21.01.2011','Hulim'),
('12.21.01.2012','Sianggunan'),
('12.21.01.2013','Simaninggir Sosopan'),
('12.21.01.2014','Sibualbuali'),
('12.21.01.2015','Sosopan'),
('12.21.01.2016','Sigala-Gala'),
('12.21.01.2017','Sihaporas'),
('12.21.01.2018','Banua Tonga'),
('12.21.01.2019','Sosopan Julu'),
('12.21.01.2020','Huta Bara'),
('12.21.01.2021','Hutabaru Sosopan'),
('12.21.01.2022','Simartolu'),
('12.21.02','Barumun Tengah'),
('12.21.02.2001','Gunung Baringin'),
('12.21.02.2002','Pasar Binanga'),
('12.21.02.2003','Sihaborgoan Dalan'),
('12.21.02.2004','Aek Tanduk'),
('12.21.02.2005','PP. Makmur'),
('12.21.02.2006','Siboris Bahal'),
('12.21.02.2007','Bangkudu'),
('12.21.02.2008','Siolip'),
('12.21.02.2009','Aek Tunjang'),
('12.21.02.2010','Binanga'),
('12.21.02.2011','Manombo'),
('12.21.02.2012','Janji Raja'),
('12.21.02.2013','Pangirkiran Dolok'),
('12.21.02.2014','Sihaborgoan Barumun'),
('12.21.02.2015','Siboris Dolok'),
('12.21.02.2016','Padang Matinggi'),
('12.21.02.2017','Tandihat'),
('12.21.02.2018','Bara Batu'),
('12.21.02.2019','Bahal Batu'),
('12.21.02.2020','Ginduang Batu'),
('12.21.02.2021','Padang Garugur'),
('12.21.02.2022','Gunung Manaon'),
('12.21.02.2023','Siboris Lombang'),
('12.21.02.2024','Janji Matogu'),
('12.21.02.2025','Gunung Malintang'),
('12.21.02.2026','Sibatu Loting'),
('12.21.02.2028','Janji Manahan'),
('12.21.02.2029','Siparau'),
('12.21.02.2030','Unterudang'),
('12.21.03','Huristak'),
('12.21.03.2001','Binanga Tolu'),
('12.21.03.2002','Tanjung Baringin'),
('12.21.03.2003','Huristak'),
('12.21.03.2004','Paran Tonga'),
('12.21.03.2005','Gonting Julu'),
('12.21.03.2006','Bulu Cina'),
('12.21.03.2007','Sigading'),
('12.21.03.2008','Pasir Lancat Lama'),
('12.21.03.2009','Siala Gundi'),
('12.21.03.2010','Tobing Julu'),
('12.21.03.2011','Tar Sihoda-Hoda'),
('12.21.03.2012','Huta Pasir Ulak Tano'),
('12.21.03.2013','Tobing Jae'),
('12.21.03.2014','Pasar Huristak'),
('12.21.03.2015','Sipirok Baru'),
('12.21.03.2016','Pasir Lancat Baru'),
('12.21.03.2017','Tobing Tinggi'),
('12.21.03.2018','Ganal'),
('12.21.03.2019','Paya Bujing'),
('12.21.03.2020','Pulo Bariang'),
('12.21.03.2021','Ramba'),
('12.21.03.2022','Gonting Jae'),
('12.21.03.2023','Gala Bonang'),
('12.21.03.2024','Tanjung Morang'),
('12.21.03.2025','Gunung Manaon'),
('12.21.03.2026','Gunung Matinggi'),
('12.21.03.2027','Pasir Pinang'),
('12.21.04','Lubuk Barumun'),
('12.21.04.2001','Janji Matogu'),
('12.21.04.2002','Pagaran Silindung'),
('12.21.04.2003','Tangga Bosi'),
('12.21.04.2004','Hutaibus'),
('12.21.04.2005','Pagaran Jalu-Jalu'),
('12.21.04.2006','Hutanopan'),
('12.21.04.2007','Pasar Latong'),
('12.21.04.2008','Pagaran Jae Batu'),
('12.21.04.2009','Aek Lancat'),
('12.21.04.2010','Batang Tanggal Baru'),
('12.21.04.2011','Bonal'),
('12.21.04.2012','Pagaran Malaka'),
('12.21.04.2013','Huta Dolok'),
('12.21.04.2014','Gunung Manobot'),
('12.21.04.2015','Batang Bulu Jae'),
('12.21.04.2016','Suro Dingin'),
('12.21.04.2017','Janji Lobi Lima'),
('12.21.04.2018','Sangkilon'),
('12.21.04.2019','Siali-Ali'),
('12.21.04.2020','Huta Lombang'),
('12.21.04.2021','Pagaran Mompang'),
('12.21.04.2022','Parsombaan'),
('12.21.04.2023','Sihiuk'),
('12.21.04.2024','Batang Bulu Tanggal'),
('12.21.05','Hutaraja Tinggi'),
('12.21.05.2004','Lubuk Bunut'),
('12.21.05.2005','Ujung Padang'),
('12.21.05.2006','Tanjung Baringin'),
('12.21.05.2007','Sibodak Sosa Jae'),
('12.21.05.2008','Parmainan'),
('12.21.05.2009','Pagaran Dolok Sosa Jae'),
('12.21.05.2010','Aliaga'),
('12.21.05.2011','Mananti Sosa Jae'),
('12.21.05.2012','Panyabungan'),
('12.21.05.2013','Pasar Panyabungan'),
('12.21.05.2014','Sigalapung'),
('12.21.05.2015','Siabu'),
('12.21.05.2016','Paya Ombur'),
('12.21.05.2017','Hutaraja Tinggi'),
('12.21.05.2018','Sungai Korang'),
('12.21.05.2019','Ujung Batu I'),
('12.21.05.2020','Ujung Batu II'),
('12.21.05.2021','Ujung Batu III'),
('12.21.05.2022','Ujung Batu IV'),
('12.21.05.2023','Ujung Batu V'),
('12.21.05.2026','Pir Trans Sosa III A'),
('12.21.05.2027','Pir Trans Sosa III B'),
('12.21.05.2028','Pir Trans Sosa II'),
('12.21.05.2029','Pir Trans Sosa IV'),
('12.21.05.2030','Pir Trans Sosa V'),
('12.21.05.2031','Pir Trans Sosa VI'),
('12.21.06','Ulu Barumun'),
('12.21.06.2001','Simanuldang Jae'),
('12.21.06.2002','Simanuldang Julu'),
('12.21.06.2003','Tapian Nauli'),
('12.21.06.2004','Handang Kopo'),
('12.21.06.2005','Subulussalam'),
('12.21.06.2006','Pintu Padang'),
('12.21.06.2007','Matondang'),
('12.21.06.2008','Pasar Ipuh'),
('12.21.06.2009','Paringgonan'),
('12.21.06.2010','Paringgonan Julu'),
('12.21.06.2011','Paran Batu'),
('12.21.06.2012','Sibual Buali'),
('12.21.06.2013','Tanjung'),
('12.21.06.2014','Siraisan'),
('12.21.06.2015','Aek Haruaya'),
('12.21.07','Barumun'),
('12.21.07.1001','Pasar Sibuhuan'),
('12.21.07.2002','Sibuhuan Julu'),
('12.21.07.2003','Bangun Raya'),
('12.21.07.2004','Purba Tua'),
('12.21.07.2005','Handis Julu'),
('12.21.07.2006','Sialambue'),
('12.21.07.2007','Sibuhuan Jae'),
('12.21.07.2008','Janjilobi'),
('12.21.07.2021','Tanjung Durian'),
('12.21.07.2022','Tanjung Botung'),
('12.21.07.2023','Tanobato'),
('12.21.07.2024','Hutarimbaru'),
('12.21.07.2025','Sayur Matua'),
('12.21.07.2037','Bulusonik'),
('12.21.07.2038','Arsesimatorkis'),
('12.21.07.2039','Pancaukan'),
('12.21.07.2040','Pagaran Baringin'),
('12.21.08','Sosa'),
('12.21.08.2006','Pasar Ujung Batu'),
('12.21.08.2008','Plasma Mondang'),
('12.21.08.2011','Hutaimbaru'),
('12.21.08.2012','Mondang'),
('12.21.08.2013','Sisoma'),
('12.21.08.2014','Aek Tinga'),
('12.21.08.2015','Gunung Baringin'),
('12.21.08.2016','Simarancar'),
('12.21.08.2017','Huta Raja Lamo'),
('12.21.08.2018','Tanjung Botung Sosa Jae'),
('12.21.08.2019','Ujung Batu'),
('12.21.08.2020','Janjiraja'),
('12.21.08.2021','Rao-Rao Dolok'),
('12.21.08.2022','Parau Sorat'),
('12.21.08.2023','Aer Bale'),
('12.21.08.2024','Tanjung Bale'),
('12.21.09','Batang Lubu Sutam'),
('12.21.09.2001','Tanjung Baru'),
('12.21.09.2002','Tamiang'),
('12.21.09.2003','Tanjung Barani'),
('12.21.09.2004','Manggis'),
('12.21.09.2005','Pagaran Tayas'),
('12.21.09.2006','Hatongga'),
('12.21.09.2007','Botung'),
('12.21.09.2008','Siadam'),
('12.21.09.2009','Siojo'),
('12.21.09.2010','Pagaran Manggis'),
('12.21.09.2011','Muara Malinto Lama'),
('12.21.09.2012','Hutabaru'),
('12.21.09.2013','Huta Nopan'),
('12.21.09.2014','Tandolan'),
('12.21.09.2015','Tangga Batu'),
('12.21.09.2016','Pagaran Dolok Pinarik'),
('12.21.09.2017','Muara Malinto Baru'),
('12.21.09.2018','Aek Sorik'),
('12.21.09.2019','Tanjung Botung Pinarik'),
('12.21.09.2020','Pinarik'),
('12.21.10','Barumun Selatan'),
('12.21.10.2001','Batang Bulu Lama'),
('12.21.10.2002','Pagur Satio'),
('12.21.10.2003','Batang Bulu Baru'),
('12.21.10.2004','Gunung Intan'),
('12.21.10.2005','Tanjung Purba Tua'),
('12.21.10.2006','Banua Tonga'),
('12.21.10.2007','Gunung Barani'),
('12.21.10.2008','Tanjung Baringin Simarulak'),
('12.21.10.2009','Sayur Mahincat'),
('12.21.10.2010','Sidomulio'),
('12.21.10.2011','Panarian'),
('12.21.11','Aek Nabara Barumun'),
('12.21.11.2001','Aek Nabara Tonga'),
('12.21.11.2002','Aek Nabara Jae'),
('12.21.11.2003','Padang Garugur Jae'),
('12.21.11.2004','Huta Bargot'),
('12.21.11.2005','Janji Maria'),
('12.21.11.2006','Padang Garugur Julu'),
('12.21.11.2007','Sidokan'),
('12.21.11.2008','Tobing'),
('12.21.11.2009','Hadungdung Aek Rampah'),
('12.21.11.2010','Tobing Tinggi'),
('12.21.11.2011','Sipagabu'),
('12.21.11.2012','Tanjung'),
('12.21.11.2013','Paran Tonga'),
('12.21.11.2014','Paran Julu'),
('12.21.11.2015','Hadungdung Pintu Padang'),
('12.21.11.2016','Tanjung Rokan'),
('12.21.11.2017','Aek Bonban'),
('12.21.11.2018','Marenu'),
('12.21.11.2019','Aek Nabara Julu'),
('12.21.11.2020','Padang Garugur Tonga'),
('12.21.11.2021','Bangkuang'),
('12.21.11.2022','Paya bahung'),
('12.21.11.2023','Aek Buaton'),
('12.21.11.2024','Sayur Matua'),
('12.21.11.2025','Sayur Mahincat'),
('12.21.12','Sihapas Barumun'),
('12.21.12.2001','Lubuk Gonting'),
('12.21.12.2002','Padang Hasior Dolok'),
('12.21.12.2003','Padang Hasior Lombang'),
('12.21.12.2004','Sitada-Tada'),
('12.21.12.2005','Paran Dolok'),
('12.21.12.2006','Ujung Gading'),
('12.21.12.2007','Simaninggir'),
('12.21.12.2008','Tanjung Morang'),
('12.21.12.2009','Silenjeng'),
('12.21.12.2010','Aek Goti'),
('12.21.12.2011','Gulangan'),
('12.21.12.2012','Ujung Padang'),
('12.21.12.2013','Balangka'),
('12.21.13','Barumun Baru'),
('12.21.13.2001','Hasahatan Julu'),
('12.21.13.2002','Hasahatan Jae'),
('12.21.13.2003','Sabahotang'),
('12.21.13.2004','Sigorbus Julu'),
('12.21.13.2005','Sigorbus Jae'),
('12.21.13.2006','Mompang'),
('12.21.13.2007','Sitarolo Julu'),
('12.21.13.2008','Siolip'),
('12.21.13.2009','Saba Rimba'),
('12.21.13.2010','Limbong'),
('12.21.13.2011','Simaninggir'),
('12.21.13.2012','Binabo Julu'),
('12.21.13.2013','Binabo Jae'),
('12.21.14','Ulu Sosa'),
('12.21.14.2001','Hapung'),
('12.21.14.2002','Batu Gajah'),
('12.21.14.2003','Hapung Torop'),
('12.21.14.2004','Harang Jae'),
('12.21.14.2005','Harang Julu'),
('12.21.14.2006','Handio'),
('12.21.14.2007','Gunung Tua'),
('12.21.14.2008','Mandian'),
('12.21.14.2009','Parapat'),
('12.21.14.2010','Horuon'),
('12.21.14.2011','Bonan Dolok'),
('12.21.15','Sosa Julu'),
('12.21.15.2001','Pasir Julu'),
('12.21.15.2002','Lumban Huayan'),
('12.21.15.2003','Siborna Bunut'),
('12.21.15.2004','Mananti Sosa Julu'),
('12.21.15.2005','Ampolu'),
('12.21.15.2006','Siginduang'),
('12.21.15.2007','Ramba'),
('12.21.15.2008','Roburan'),
('12.21.15.2009','Tanjung'),
('12.21.15.2010','Hurung Jilok'),
('12.21.15.2011','Pasir Jae'),
('12.21.15.2012','Sungai Jior'),
('12.21.16','Barumun Barat'),
('12.21.16.2001','Gading'),
('12.21.16.2002','Huta Ruhom'),
('12.21.16.2003','Aek Siala'),
('12.21.16.2004','Bire'),
('12.21.16.2005','Sibontar'),
('12.21.16.2006','Para Napa Jae'),
('12.21.16.2007','Para Napa Dolok'),
('12.21.16.2008','Batusundung'),
('12.21.16.2009','Sidongdong'),
('12.21.16.2010','Sisalean'),
('12.21.17','Sosa Timur'),
('12.21.17.2001','Tanjung Ale'),
('12.21.17.2002','Sigala-Gala'),
('12.21.17.2003','Simangambat'),
('12.21.17.2004','Pir Trans Sosa I B'),
('12.21.17.2005','Pir Trans Sosa I A'),
('12.21.17.2006','Gunung Manaon'),
('12.21.17.2007','Muara Tige'),
('12.21.17.2008','Sibodak Papaso'),
('12.21.17.2009','Gunung Inten'),
('12.21.17.2010','Pagaran Baringin'),
('12.21.17.2011','Salambue'),
('12.21.17.2012','Papaso'),
('12.21.17.2013','Rombayan'),
('12.22','Kabupaten Labuhanbatu Selatan'),
('12.22.01','Kotapinang'),
('12.22.01.1001','Kotapinang'),
('12.22.01.2002','Simatahari'),
('12.22.01.2003','Mampang'),
('12.22.01.2004','Pasir Tuntung'),
('12.22.01.2005','Sisumut'),
('12.22.01.2006','Hadundung'),
('12.22.01.2007','Sosopan'),
('12.22.01.2008','Perkebunan Nomark'),
('12.22.01.2009','Perkebunan Nagodang'),
('12.22.01.2010','Perk. Sei Rumbia'),
('12.22.02','Kampung Rakyat'),
('12.22.02.2001','Perk. Perlabian'),
('12.22.02.2002','Perk. Teluk Panji'),
('12.22.02.2003','Perk. Tolan I/II'),
('12.22.02.2004','Perk. Batang Saponggol'),
('12.22.02.2005','Perk. Tolan'),
('12.22.02.2006','Air Merah'),
('12.22.02.2007','Teluk Panji'),
('12.22.02.2008','Tanjung Medan'),
('12.22.02.2009','Kampung Perlabian'),
('12.22.02.2010','Tanjung Selamat'),
('12.22.02.2011','Tanjung Mulia'),
('12.22.02.2012','Teluk Panji I'),
('12.22.02.2013','Teluk Panji II'),
('12.22.02.2014','Teluk Panji III'),
('12.22.02.2015','Teluk Panji IV'),
('12.22.03','Torgamba'),
('12.22.03.2001','Bangai'),
('12.22.03.2002','Rasau'),
('12.22.03.2003','Teluk Rampah'),
('12.22.03.2004','Pangarungan'),
('12.22.03.2005','Bunut'),
('12.22.03.2006','Aek Batu'),
('12.22.03.2007','Pinang Damai'),
('12.22.03.2008','Aek Raso'),
('12.22.03.2009','Torgamba'),
('12.22.03.2010','Asam Jawa'),
('12.22.03.2011','Torganda'),
('12.22.03.2012','Beringin Jaya'),
('12.22.03.2013','Bukit Tujuh'),
('12.22.03.2014','Sei Meranti'),
('12.22.04','Sungai Kanan'),
('12.22.04.1001','Langga Payung'),
('12.22.04.2002','Batang Nadenggan'),
('12.22.04.2003','Sabungan'),
('12.22.04.2004','Hajoran'),
('12.22.04.2005','Ujung Gading'),
('12.22.04.2006','Huta Godang'),
('12.22.04.2007','Parimburan'),
('12.22.04.2008','Sampean'),
('12.22.04.2009','Marsonja'),
('12.22.05','Silangkitang'),
('12.22.05.2001','Mandalasena'),
('12.22.05.2002','Binangadua'),
('12.22.05.2003','Aek Goti'),
('12.22.05.2004','Ulu Mahuam'),
('12.22.05.2005','Rintis'),
('12.22.05.2006','Sukadame'),
('12.23','Kabupaten Labuhanbatu Utara'),
('12.23.01','Kualuh Hulu'),
('12.23.01.1001','Aek Kanopan'),
('12.23.01.1002','Aek Kanopan Timur'),
('12.23.01.2003','Kuala Beringin'),
('12.23.01.2004','Parpaudangan'),
('12.23.01.2005','Pulo Dogom'),
('12.23.01.2006','Londut'),
('12.23.01.2007','Perkebunan Kanopan Ulu'),
('12.23.01.2008','Perkebunan Membang Muda'),
('12.23.01.2009','Perkebunan Labuhan Haji'),
('12.23.01.2010','Perkebunan Hanna'),
('12.23.01.2011','Sonomartani'),
('12.23.01.2012','Sukarame'),
('12.23.01.2013','Sukarame Baru'),
('12.23.02','Kualuh Leidong'),
('12.23.02.1001','Tanjung Leidong'),
('12.23.02.2002','Teluk Pulai Dalam'),
('12.23.02.2003','Teluk Pulai Luar'),
('12.23.02.2004','Kelapa Sebatang'),
('12.23.02.2005','Simandulang'),
('12.23.02.2006','Air Hitam'),
('12.23.02.2007','Pangkalan Lunang'),
('12.23.03','Kualuh Hilir'),
('12.23.03.1001','Kampung Mesjid'),
('12.23.03.2002','Kuala Bangka'),
('12.23.03.2003','Sei Sentang'),
('12.23.03.2004','Teluk Piai'),
('12.23.03.2005','Tanjung Mangedar'),
('12.23.03.2006','Teluk Binjai'),
('12.23.03.2007','Sei Apung'),
('12.23.04','Aek Kuo'),
('12.23.04.2001','Aek Korsik'),
('12.23.04.2002','Bandar Selamat'),
('12.23.04.2003','Perk. Padang Halaban'),
('12.23.04.2004','Perkebunan Panigoran'),
('12.23.04.2005','Sidomulyo'),
('12.23.04.2006','Karang Anyar'),
('12.23.04.2007','Padang Maninjau'),
('12.23.04.2008','Purworejo'),
('12.23.05','Marbau'),
('12.23.05.1001','Marbau'),
('12.23.05.2002','Perkebunan Pernantian'),
('12.23.05.2003','Perk. Marbau Selatan'),
('12.23.05.2004','Perkebunan Milano'),
('12.23.05.2005','Perkebunan Brussel'),
('12.23.05.2006','Pulo Bargot'),
('12.23.05.2007','Sipare Pare Tengah'),
('12.23.05.2008','Sipare Pare Hilir'),
('12.23.05.2009','Tubiran'),
('12.23.05.2010','Belongkut'),
('12.23.05.2011','Simpang Empat'),
('12.23.05.2012','Babussalam'),
('12.23.05.2013','Marbau Selatan'),
('12.23.05.2014','Aek Tapa'),
('12.23.05.2015','Lobu Rampah'),
('12.23.05.2016','Bulungihit'),
('12.23.05.2017','Aek Hitetoras'),
('12.23.05.2018','Sumber Mulyo'),
('12.23.06','Na IX-X'),
('12.23.06.1001','Aek Kota Batu'),
('12.23.06.2002','Pematang'),
('12.23.06.2003','Batu Tunggal'),
('12.23.06.2004','Sungai Raja'),
('12.23.06.2005','Perkebunan Berangir'),
('12.23.06.2006','Silumajang'),
('12.23.06.2007','Pulo Jantan'),
('12.23.06.2008','Kampung Pajak'),
('12.23.06.2009','Meranti Omas'),
('12.23.06.2010','Hatapang'),
('12.23.06.2011','Pasang Lela'),
('12.23.06.2012','Simpang Marbau'),
('12.23.06.2013','Bangun Rejo'),
('12.23.07','Aek Natas'),
('12.23.07.1001','Bandar Durian'),
('12.23.07.2002','Poldung'),
('12.23.07.2003','Rombisan'),
('12.23.07.2004','Sibito'),
('12.23.07.2005','Simonis'),
('12.23.07.2006','Perk. Aek Pamienke'),
('12.23.07.2007','Pangkalan'),
('12.23.07.2008','Adian Torop'),
('12.23.07.2009','Ujung Padang'),
('12.23.07.2010','Kampung Yaman'),
('12.23.07.2011','Terang Bulan'),
('12.23.07.2012','Perkebunan Halimbe'),
('12.23.08','Kualuh Selatan'),
('12.23.08.1001','Gunting Saga'),
('12.23.08.2002','Damuli Pekan'),
('12.23.08.2003','Siamporik'),
('12.23.08.2004','Lobu Huala'),
('12.23.08.2005','Gunung Melayu'),
('12.23.08.2006','Damuli Kebun'),
('12.23.08.2007','Hasang'),
('12.23.08.2008','Bandar Lama'),
('12.23.08.2009','Sidua Dua'),
('12.23.08.2010','Simangalam'),
('12.23.08.2011','Tanjung Pasir'),
('12.23.08.2012','Sialang Taji'),
('12.24','Kabupaten Nias Utara'),
('12.24.01','Lotu'),
('12.24.01.2001','Hilidundra'),
('12.24.01.2002','Lawira Satua'),
('12.24.01.2003','Fadoro Fulolo'),
('12.24.01.2004','Lawira I'),
('12.24.01.2005','Hiligodu'),
('12.24.01.2006','Lombuza''ua'),
('12.24.01.2007','Maziaya'),
('12.24.01.2008','Baho'),
('12.24.01.2009','Lolofaoso'),
('12.24.01.2010','Lawira II'),
('12.24.01.2011','Dahadano'),
('12.24.01.2012','Lolomboli'),
('12.24.01.2013','Hiligeo Afia'),
('12.24.02','Sawo'),
('12.24.02.2001','Seriwa''u'),
('12.24.02.2002','Ombolata Sawo'),
('12.24.02.2003','Sanawuyu'),
('12.24.02.2004','Onozitoli Sawo'),
('12.24.02.2005','Sifahandro'),
('12.24.02.2006','Sisarahili Teluk Siabang'),
('12.24.02.2007','Lasara Sawo'),
('12.24.02.2008','Sawo'),
('12.24.02.2009','Hiliduruwa'),
('12.24.02.2010','Teluk Bengkuang'),
('12.24.03','Tuhemberua'),
('12.24.03.2001','Botolakha'),
('12.24.03.2002','Siofa Banua'),
('12.24.03.2003','La''aya'),
('12.24.03.2004','Alo''oa'),
('12.24.03.2005','Ladara'),
('12.24.03.2006','Banua Gea'),
('12.24.03.2007','Silima Banua'),
('12.24.03.2008','Fino'),
('12.24.04','Sitolu Ori'),
('12.24.04.2001','Tetehosi Maziaya'),
('12.24.04.2002','Umbubalodano'),
('12.24.04.2003','Hilimbosi'),
('12.24.04.2004','Hilisalo''o'),
('12.24.04.2005','Fulolo Salo''o'),
('12.24.04.2006','Botombawo'),
('12.24.05','Namohalu Esiwa'),
('12.24.05.2001','Berua'),
('12.24.05.2002','Esiwa'),
('12.24.05.2003','Dahana Hiligodu'),
('12.24.05.2004','Hilibanua'),
('12.24.05.2005','Sisarahili'),
('12.24.05.2006','Sisobahili'),
('12.24.05.2007','Lasara'),
('12.24.05.2008','Namohalu'),
('12.24.05.2009','Tuhenakhe I'),
('12.24.05.2010','Orahili'),
('12.24.05.2011','Banua Sibohou'),
('12.24.06','Alasa Talumuzoi'),
('12.24.06.2001','Banua Sibohou III'),
('12.24.06.2002','Harefanaese'),
('12.24.06.2003','Hilimbowo Kare'),
('12.24.06.2004','Laehuwa'),
('12.24.06.2005','Mazingo'),
('12.24.06.2006','Hilina''a'),
('12.24.07','Alasa'),
('12.24.07.2001','Bitaya'),
('12.24.07.2002','Lahemboho'),
('12.24.07.2003','Anaoma'),
('12.24.07.2004','Dahana Tugala Oyo'),
('12.24.07.2005','Fulolo'),
('12.24.07.2006','Hiligawoni'),
('12.24.07.2007','Ononamolo Tumula'),
('12.24.07.2008','Banua Sibohou I'),
('12.24.07.2009','Ombolata'),
('12.24.07.2010','Banua Sibohou II'),
('12.24.07.2011','Dahana Alasa'),
('12.24.07.2012','Ononamolo Alasa'),
('12.24.07.2013','Loloana''a'),
('12.24.07.2014','Hilisebua Siwalubanua'),
('12.24.08','Tugala Oyo'),
('12.24.08.2001','Te''olo'),
('12.24.08.2002','Siwawo'),
('12.24.08.2003','Fabaliwa Oyo'),
('12.24.08.2004','Ononazara'),
('12.24.08.2005','Humene Siheneasi'),
('12.24.08.2006','Gunung Tua'),
('12.24.08.2007','Botona''ai'),
('12.24.08.2008','Harefa'),
('12.24.09','Afulu'),
('12.24.09.2001','Afulu'),
('12.24.09.2002','Lauru Fadoro'),
('12.24.09.2003','Lauru I'),
('12.24.09.2004','Ombolata Afulu'),
('12.24.09.2005','Harewakhe'),
('12.24.09.2006','Sisobahili'),
('12.24.09.2007','Lauru Lahewa'),
('12.24.09.2008','Sifaoro''asi'),
('12.24.09.2009','Faekhuna''a'),
('12.24.10','Lahewa'),
('12.24.10.1001','Pasar Lahewa'),
('12.24.10.2002','Iraono Lase'),
('12.24.10.2003','Holi'),
('12.24.10.2004','Sifaoro''asi'),
('12.24.10.2005','Hilizukhu'),
('12.24.10.2006','Onozalukhu'),
('12.24.10.2007','Hilina''a'),
('12.24.10.2008','Hiligodu Hoya'),
('12.24.10.2009','Sitolubanua'),
('12.24.10.2010','Hilihati'),
('12.24.10.2011','Fadoro Sitolu Hili'),
('12.24.10.2012','Marafala'),
('12.24.10.2013','Hiligawolo'),
('12.24.10.2014','Balefadoro Tuho'),
('12.24.10.2015','Ombolata'),
('12.24.10.2016','Afia'),
('12.24.10.2017','Moawo'),
('12.24.10.2018','Lasara'),
('12.24.10.2019','Sihene''asi'),
('12.24.10.2020','Fadoro Hilimbowo'),
('12.24.10.2021','Fadoro Hilihambawa'),
('12.24.11','Lahewa Timur'),
('12.24.11.2001','Laowowaga'),
('12.24.11.2002','Lukhu Lase'),
('12.24.11.2003','Tetehosi Sorowi'),
('12.24.11.2004','Tefa''o'),
('12.24.11.2005','Tugala Lauru'),
('12.24.11.2006','Muzoi'),
('12.24.11.2007','Meafu'),
('12.25','Kabupaten Nias Barat'),
('12.25.01','Lahomi'),
('12.25.01.2001','Sisobaoho'),
('12.25.01.2002','Bawozamaiwo'),
('12.25.01.2003','Sitolubanua'),
('12.25.01.2004','Lologundre'),
('12.25.01.2005','Iraonogaila'),
('12.25.01.2006','Tigaserangkai'),
('12.25.01.2007','Onowaembo'),
('12.25.01.2008','Onolimbu'),
('12.25.01.2009','Haliadulo'),
('12.25.01.2010','Sisobambowo'),
('12.25.01.2011','Lolowau'),
('12.25.02','Sirombu'),
('12.25.02.2001','Bawosaloo'),
('12.25.02.2002','Imana'),
('12.25.02.2003','Tuwa Tuwa'),
('12.25.02.2004','Kafo Kafo'),
('12.25.02.2005','Bawasawa'),
('12.25.02.2006','Pulau Bogi'),
('12.25.02.2007','Halamona'),
('12.25.02.2008','Hanofa'),
('12.25.02.2009','Lahawa'),
('12.25.02.2010','Hinako'),
('12.25.02.2011','Sineneeto'),
('12.25.02.2012','Balowondrate'),
('12.25.02.2013','Hilimberuanaa'),
('12.25.02.2014','Lahusa'),
('12.25.02.2015','Ombolata'),
('12.25.02.2016','Tetehosi'),
('12.25.02.2017','Togimbogi'),
('12.25.02.2018','Sisobandrao'),
('12.25.02.2019','Fadoro'),
('12.25.02.2020','Tugala Gawu'),
('12.25.02.2021','Sirombu'),
('12.25.02.2022','Togideu'),
('12.25.02.2023','Tugala'),
('12.25.02.2024','Orahili'),
('12.25.02.2025','Gunungcahaya'),
('12.25.03','Mandrehe Barat'),
('12.25.03.2001','Onolimbu Raya'),
('12.25.03.2002','Ononamolo III'),
('12.25.03.2003','Sisobaoho'),
('12.25.03.2004','Iraonogeba'),
('12.25.03.2005','Lolohia'),
('12.25.03.2006','Fadorosifulubanua'),
('12.25.03.2007','Hillidaura'),
('12.25.03.2008','Sisarahili II'),
('12.25.03.2009','Lasara Bagawu'),
('12.25.03.2010','Sisobandrao'),
('12.25.03.2011','Mazingo'),
('12.25.03.2012','Onolimbu You'),
('12.25.03.2013','Lasarafaga'),
('12.25.03.2014','Orahili Badalu'),
('12.25.04','Moro''o'),
('12.25.04.2001','Hiliwaloo II'),
('12.25.04.2002','Gunungbaru'),
('12.25.04.2003','Hilisoromi'),
('12.25.04.2004','Siduahili'),
('12.25.04.2005','Sitolubanua Fadoro'),
('12.25.04.2006','Halifadolo'),
('12.25.04.2007','Lasara Bahili'),
('12.25.04.2008','Hiliwaele'),
('12.25.04.2009','Sitoluewali'),
('12.25.04.2010','Onozalukhu You'),
('12.25.05','Mandrehe'),
('12.25.05.2001','Simaeasi'),
('12.25.05.2002','Lologolu'),
('12.25.05.2003','Tuwuna'),
('12.25.05.2004','Tuhemberua'),
('12.25.05.2005','Lolozirugi'),
('12.25.05.2006','Lakhene'),
('12.25.05.2007','Hiliwaloo I'),
('12.25.05.2008','Sianaa'),
('12.25.05.2009','Fadoro'),
('12.25.05.2010','Iraonogambo'),
('12.25.05.2011','Tuhoowo'),
('12.25.05.2012','Fadoro Bahili'),
('12.25.05.2013','Tumori'),
('12.25.05.2014','Lasara Baene'),
('12.25.05.2015','Tetehosi'),
('12.25.05.2016','Sisarahili I'),
('12.25.05.2017','Doli-Doli'),
('12.25.05.2018','Hayo'),
('12.25.05.2019','Zuzundrao'),
('12.25.05.2020','Sisobambowo'),
('12.25.06','Mandrehe Utara'),
('12.25.06.2001','Balodano'),
('12.25.06.2002','Hiambanua'),
('12.25.06.2003','Hilimayo'),
('12.25.06.2004','Sihareo'),
('12.25.06.2005','Lolomboli'),
('12.25.06.2006','Ononamolo I'),
('12.25.06.2007','Hilimbaruzo'),
('12.25.06.2008','Tarahoso'),
('12.25.06.2009','Ononamolo II'),
('12.25.06.2010','Taraha'),
('12.25.06.2011','Lahagu'),
('12.25.06.2012','Hilimbowo'),
('12.25.07','Lolofitu Moi'),
('12.25.07.2001','Sisobawino II'),
('12.25.07.2002','Duria'),
('12.25.07.2003','Ambukha'),
('12.25.07.2004','Hilimbowo Mau'),
('12.25.07.2005','Hilimbuasi'),
('12.25.07.2006','Lolofitu'),
('12.25.07.2007','Hiliuso'),
('12.25.07.2008','Wango'),
('12.25.08','Ulu Moro''o'),
('12.25.08.2001','Bukit Tinggi'),
('12.25.08.2002','Lawelu'),
('12.25.08.2003','Saloo'),
('12.25.08.2004','Hilisangawola'),
('12.25.08.2005','Hilibadalu'),
('12.71','Kota Medan'),
('12.71.01','Medan Kota'),
('12.71.01.1001','Pasar Baru'),
('12.71.01.1002','Pusat Pasar'),
('12.71.01.1003','Sei Rengas I'),
('12.71.01.1004','Mesjid'),
('12.71.01.1005','Pandau Hulu I'),
('12.71.01.1006','Kotamatsum III'),
('12.71.01.1007','Pasar Merah Barat'),
('12.71.01.1008','Teladan Timur'),
('12.71.01.1009','Teladan Barat'),
('12.71.01.1010','Sudirejo 1'),
('12.71.01.1011','Sudirejo II'),
('12.71.01.1012','Sitirejo I'),
('12.71.02','Medan Sunggal'),
('12.71.02.1001','Lalang'),
('12.71.02.1002','Sei Sikambing B'),
('12.71.02.1003','Sunggal'),
('12.71.02.1004','Babura Sunggal'),
('12.71.02.1005','Tanjung Rejo'),
('12.71.02.1006','Simpang Tanjung'),
('12.71.03','Medan Helvetia'),
('12.71.03.1001','Helvetia'),
('12.71.03.1002','Helvetia Tengah'),
('12.71.03.1003','Helvetia Timur'),
('12.71.03.1004','Tanjung Gusta'),
('12.71.03.1005','Cinta Damai'),
('12.71.03.1006','Dwi Kora'),
('12.71.03.1007','Sei Sikambing C II'),
('12.71.04','Medan Denai'),
('12.71.04.1001','Tegal S Mandala I'),
('12.71.04.1002','Tegal S Mandala II'),
('12.71.04.1003','Tegal S Mandala III'),
('12.71.04.1004','Denai'),
('12.71.04.1005','Binjai'),
('12.71.04.1006','Medan Tenggara'),
('12.71.05','Medan Barat'),
('12.71.05.1001','Kesawan'),
('12.71.05.1002','Silalas'),
('12.71.05.1003','Glugur Kota'),
('12.71.05.1004','Pulo Berayan Kota'),
('12.71.05.1005','Sei Agul'),
('12.71.05.1006','Karang Berombak'),
('12.71.06','Medan Deli'),
('12.71.06.1001','Titipapan'),
('12.71.06.1002','Tanjung Mulia Hilir'),
('12.71.06.1003','Tanjung Mulya'),
('12.71.06.1004','Kota Bangun'),
('12.71.06.1005','Mabar'),
('12.71.06.1006','Mabar Hilir'),
('12.71.07','Medan Tuntungan'),
('12.71.07.1001','Tanjung Selamat'),
('12.71.07.1002','Simpang Selayang'),
('12.71.07.1003','Namo Gajah'),
('12.71.07.1004','Kemenangan Tani'),
('12.71.07.1005','Laucih'),
('12.71.07.1006','Sidomulyo'),
('12.71.07.1007','Ladang Bambu'),
('12.71.07.1008','Simalingkar B'),
('12.71.07.1009','Mangga'),
('12.71.08','Medan Belawan'),
('12.71.08.1001','Belawan I'),
('12.71.08.1002','Belawan II'),
('12.71.08.1003','Belawan Bahagia'),
('12.71.08.1004','Belawan Bahari'),
('12.71.08.1005','Belawan Sicanang'),
('12.71.08.1006','Bagan Deli'),
('12.71.09','Medan Amplas'),
('12.71.09.1001','Amplas'),
('12.71.09.1002','Sitirejo II'),
('12.71.09.1003','Sitirejo III'),
('12.71.09.1004','Harjosari I'),
('12.71.09.1005','Harjosari II'),
('12.71.09.1006','Timbang Deli'),
('12.71.09.1007','Bangun Mulia'),
('12.71.10','Medan Area'),
('12.71.10.1001','Sukaramai I'),
('12.71.10.1002','Sukaramai II'),
('12.71.10.1003','Sei Rengas II'),
('12.71.10.1004','S. Rengas Permata'),
('12.71.10.1005','Pandau Hulu II'),
('12.71.10.1006','Kota Matsum I'),
('12.71.10.1007','Kota Matsum II'),
('12.71.10.1008','Kota Matsum IV'),
('12.71.10.1009','Pasar Merah Timur'),
('12.71.10.1010','Tegal Sari I'),
('12.71.10.1011','Tegal Sari II'),
('12.71.10.1012','Tegal Sari III'),
('12.71.11','Medan Johor'),
('12.71.11.1001','Suka Maju'),
('12.71.11.1002','Titi Kuning'),
('12.71.11.1003','Kedai Durian'),
('12.71.11.1004','Pangkalan Mansur'),
('12.71.11.1005','Gedung Johor'),
('12.71.11.1006','Kwala Bekala'),
('12.71.12','Medan Marelan'),
('12.71.12.1001','Labuhan Deli'),
('12.71.12.1002','Rengas Pulau'),
('12.71.12.1003','Terjun'),
('12.71.12.1004','Tanah Enam Ratus'),
('12.71.12.1005','Paya Pasir'),
('12.71.13','Medan Labuhan'),
('12.71.13.1001','Pekan Labuhan'),
('12.71.13.1002','Sei Mati'),
('12.71.13.1003','Besar'),
('12.71.13.1004','Martubung'),
('12.71.13.1005','Nelayan Indah'),
('12.71.13.1006','Tangkahan'),
('12.71.14','Medan Tembung'),
('12.71.14.1001','Indra Kasih'),
('12.71.14.1002','Sidorejo Hilir'),
('12.71.14.1003','Sidorejo'),
('12.71.14.1004','Bantan'),
('12.71.14.1005','Tembung'),
('12.71.14.1006','Bandar Selamat'),
('12.71.14.1007','Bantan Timur'),
('12.71.15','Medan Maimun'),
('12.71.15.1001','Aur'),
('12.71.15.1002','Hamdan'),
('12.71.15.1003','Jati'),
('12.71.15.1004','Sukaraja'),
('12.71.15.1005','Sei Mati'),
('12.71.15.1006','Kampung Baru'),
('12.71.16','Medan Polonia'),
('12.71.16.1001','Madras Hulu'),
('12.71.16.1002','Polonia'),
('12.71.16.1003','Sari Rejo'),
('12.71.16.1004','Suka Damai'),
('12.71.16.1005','Anggrung'),
('12.71.17','Medan Baru'),
('12.71.17.1001','Petisah Hulu'),
('12.71.17.1002','Babura'),
('12.71.17.1003','Merdeka'),
('12.71.17.1004','Darat'),
('12.71.17.1005','Padang Bulan'),
('12.71.17.1006','Titi Rante'),
('12.71.18','Medan Perjuangan'),
('12.71.18.1001','Pandau Hilir'),
('12.71.18.1002','Pahlawan'),
('12.71.18.1003','Sei Kera Hilir I'),
('12.71.18.1004','Sei Kera Hilir II'),
('12.71.18.1005','Sei Kera Hulu'),
('12.71.18.1006','Sidorame Timur'),
('12.71.18.1007','Sidorame Barat I'),
('12.71.18.1008','Sidorame Barat II'),
('12.71.18.1009','Tegalrejo'),
('12.71.19','Medan Petisah'),
('12.71.19.1001','Petisah Tengah'),
('12.71.19.1002','Sekip'),
('12.71.19.1003','Sei Sikambing D'),
('12.71.19.1004','Sei Putih Barat'),
('12.71.19.1005','Sei Putih Tengah'),
('12.71.19.1006','Sei Putih Timur I'),
('12.71.19.1007','Sei Putih Timur II'),
('12.71.20','Medan Timur'),
('12.71.20.1001','Gang Buntu'),
('12.71.20.1002','Sidodadi'),
('12.71.20.1003','Durian'),
('12.71.20.1004','Glugur Darat I'),
('12.71.20.1005','Glugur Darat II'),
('12.71.20.1006','P Berayan Darat I'),
('12.71.20.1007','P Berayan Darat II'),
('12.71.20.1008','P Berayan Bengkel'),
('12.71.20.1009','PB Bengkel Baru'),
('12.71.20.1010','Perintis'),
('12.71.20.1011','Gaharu'),
('12.71.21','Medan Selayang'),
('12.71.21.1001','Asam Kumbang'),
('12.71.21.1002','Tanjungsari'),
('12.71.21.1003','P Bulan Selayang II'),
('12.71.21.1004','Beringin'),
('12.71.21.1005','P Bulan Selayang I'),
('12.71.21.1006','Sempakata'),
('12.72','Kota Pematangsiantar'),
('12.72.01','Siantar Timur'),
('12.72.01.1001','Kebun Sayur'),
('12.72.01.1002','Tomuan'),
('12.72.01.1003','Pahlawan'),
('12.72.01.1004','Asuhan'),
('12.72.01.1005','Merdeka'),
('12.72.01.1006','Pardomuan'),
('12.72.01.1007','Siopat Suhu'),
('12.72.02','Siantar Barat'),
('12.72.02.1001','Dwikora'),
('12.72.02.1002','Proklamasi'),
('12.72.02.1003','Bantan'),
('12.72.02.1004','Timbang Galung'),
('12.72.02.1005','Simarito'),
('12.72.02.1006','Sipinggolpinggol'),
('12.72.02.1007','Banjar'),
('12.72.02.1008','Teladan'),
('12.72.03','Siantar Utara'),
('12.72.03.1001','Melayu'),
('12.72.03.1002','Martoba'),
('12.72.03.1003','Baru'),
('12.72.03.1004','Sukadame'),
('12.72.03.1005','Kahean'),
('12.72.03.1006','Sigulanggulang'),
('12.72.03.1007','Bane'),
('12.72.04','Siantar Selatan'),
('12.72.04.1001','Toba'),
('12.72.04.1002','Karo'),
('12.72.04.1003','Simalungun'),
('12.72.04.1004','Martimbang'),
('12.72.04.1005','Kristen'),
('12.72.04.1006','Aek Nauli'),
('12.72.05','Siantar Marihat'),
('12.72.05.1002','Sukaraja'),
('12.72.05.1005','Baringin Pancur Nauli'),
('12.72.05.1006','Pardamean'),
('12.72.05.1007','Sukamaju'),
('12.72.05.1008','Parhorasan Nauli'),
('12.72.05.1009','Sukamakmur'),
('12.72.05.1010','Mekar Nauli'),
('12.72.06','Siantar Martoba'),
('12.72.06.1001','Sumber Jaya'),
('12.72.06.1003','Tambun Nabolon'),
('12.72.06.1007','Naga Pita'),
('12.72.06.1008','Pondok Sayur'),
('12.72.06.1009','Tanjung Tongah'),
('12.72.06.1010','Naga Pitu'),
('12.72.06.1011','Tanjung Pinggir'),
('12.72.07','Siantar Sitalasari'),
('12.72.07.1001','Gurilla'),
('12.72.07.1002','Bah Kapul'),
('12.72.07.1003','Setia Negara'),
('12.72.07.1004','Bukit Sofa'),
('12.72.07.1005','Bah Sorma'),
('12.72.08','Siantar Marimbun'),
('12.72.08.1001','Simarimbun'),
('12.72.08.1002','Tong Marimbun'),
('12.72.08.1003','Naga Huta'),
('12.72.08.1004','Naga Huta Timur'),
('12.72.08.1005','Pematang Marihat'),
('12.72.08.1006','Marihat Jaya'),
('12.73','Kota Sibolga'),
('12.73.01','Sibolga Utara'),
('12.73.01.1001','Huta Barangan'),
('12.73.01.1002','Angin Nauli'),
('12.73.01.1003','Huta Tonga-tonga'),
('12.73.01.1004','Sibolga Ilir'),
('12.73.01.1005','Simare-Mare'),
('12.73.02','Sibolga Kota'),
('12.73.02.1001','Kota Baringin'),
('12.73.02.1002','Pasar Baru'),
('12.73.02.1003','Pasar Belakang'),
('12.73.02.1004','Pancuran Gerobak'),
('12.73.03','Sibolga Selatan'),
('12.73.03.1001','Aek Habil'),
('12.73.03.1002','Aek Manis'),
('12.73.03.1003','Aek Muara Pinang'),
('12.73.03.1004','Aek Parombunan'),
('12.73.04','Sibolga Sambas'),
('12.73.04.1001','Pancuran Kerambil'),
('12.73.04.1002','Pancuran Dewa'),
('12.73.04.1003','Pancuran Pinang'),
('12.73.04.1004','Pancuran Bambu'),
('12.74','Kota Tanjungbalai'),
('12.74.01','Tanjungbalai Selatan'),
('12.74.01.1001','Tanjungbalai Kota I'),
('12.74.01.1002','Tanjungbalai Kota II'),
('12.74.01.1003','Perwira'),
('12.74.01.1004','Karya'),
('12.74.01.1005','Pantai Burung'),
('12.74.01.1006','Indra Sakti'),
('12.74.02','Tanjungbalai Utara'),
('12.74.02.1001','Tanjungbalai Kota III'),
('12.74.02.1002','Tanjungbalai Kota IV'),
('12.74.02.1003','Sejahtera'),
('12.74.02.1004','Kuala Silo Bestari'),
('12.74.02.1005','Matahalasan'),
('12.74.03','Sei Tualang Raso'),
('12.74.03.1001','Keramat Kubah'),
('12.74.03.1002','Sumber Sari'),
('12.74.03.1003','Muara Sentosa'),
('12.74.03.1004','Pasar Baru'),
('12.74.03.1005','Sei Raja'),
('12.74.04','Teluk Nibung'),
('12.74.04.1001','Sei Merbau'),
('12.74.04.1002','Pematang Pasir'),
('12.74.04.1003','Perjuangan'),
('12.74.04.1004','Kapias Pulau Buaya'),
('12.74.04.1005','Beting Kuala Kapias'),
('12.74.05','Datuk Bandar'),
('12.74.05.1003','Gading'),
('12.74.05.1004','Sirantau'),
('12.74.05.1005','Sijambi'),
('12.74.05.1006','Pahang'),
('12.74.05.1010','Pantai Johor'),
('12.74.06','Datuk Bandar Timur'),
('12.74.06.1001','Pulau Simardan'),
('12.74.06.1002','Semula Jadi'),
('12.74.06.1003','Selat Lancang'),
('12.74.06.1004','Bunga Tanjung'),
('12.74.06.1005','Selat Tanjung Medan'),
('12.75','Kota Binjai'),
('12.75.01','Binjai Utara'),
('12.75.01.1001','Pahlawan'),
('12.75.01.1002','Jati Negara'),
('12.75.01.1003','Nangka'),
('12.75.01.1004','Damai'),
('12.75.01.1005','Kebun Lada'),
('12.75.01.1006','Cengkeh Turi'),
('12.75.01.1007','Jati Utomo'),
('12.75.01.1008','Jati Makmur'),
('12.75.01.1009','Jati Karya'),
('12.75.02','Binjai Kota'),
('12.75.02.1001','Berngam'),
('12.75.02.1002','Satria'),
('12.75.02.1003','Setia'),
('12.75.02.1004','Kartini'),
('12.75.02.1005','Tangsi'),
('12.75.02.1006','Binjai'),
('12.75.02.1007','Pekan Binjai'),
('12.75.03','Binjai Barat'),
('12.75.03.1001','Bandar Senembah'),
('12.75.03.1002','Limau Mungkur'),
('12.75.03.1003','Limau Sundai'),
('12.75.03.1004','Paya Roba'),
('12.75.03.1005','Suka Maju'),
('12.75.03.1006','Sukaramai'),
('12.75.04','Binjai Timur'),
('12.75.04.1001','Tanah Tinggi'),
('12.75.04.1002','Dataran Tinggi'),
('12.75.04.1003','Timbang Langkat'),
('12.75.04.1004','Mencirim'),
('12.75.04.1005','Tunggurono'),
('12.75.04.1006','Sumber Mulyorejo'),
('12.75.04.1007','Sumber Karya'),
('12.75.05','Binjai Selatan'),
('12.75.05.1001','Tanah Merah'),
('12.75.05.1002','Binjai Estate'),
('12.75.05.1003','Bhakti Karya'),
('12.75.05.1004','Rambung Dalam'),
('12.75.05.1005','Pujidadi'),
('12.75.05.1006','Tanah Seribu'),
('12.75.05.1007','Rambung Barat'),
('12.75.05.1008','Rambung Timur'),
('12.76','Kota Tebing Tinggi'),
('12.76.01','Padang Hulu'),
('12.76.01.1001','Pabatu'),
('12.76.01.1002','Lubuk Baru'),
('12.76.01.1006','Persiakan'),
('12.76.01.1007','Bandar Sono'),
('12.76.01.1010','Tualang'),
('12.76.01.1011','Padang Merbau'),
('12.76.01.1012','Lubuk Raya'),
('12.76.02','Rambutan'),
('12.76.02.1004','Rantau Laban'),
('12.76.02.1007','Karya Jaya'),
('12.76.02.1009','Lalang'),
('12.76.02.1010','Tanjung Marulak'),
('12.76.02.1011','Sri Padang'),
('12.76.02.1012','Tanjung Marulak Hilir'),
('12.76.02.1013','Mekar Sentosa'),
('12.76.03','Padang Hilir'),
('12.76.03.1001','Bagelen'),
('12.76.03.1002','Tambangan'),
('12.76.03.1004','Tebing Tinggi'),
('12.76.03.1006','Satria'),
('12.76.03.1007','Damar Sari'),
('12.76.03.1008','Tambangan Hulu'),
('12.76.03.1009','Deblod Sundoro'),
('12.76.04','Bajenis'),
('12.76.04.1001','Durian'),
('12.76.04.1002','Pelita'),
('12.76.04.1003','Bulian'),
('12.76.04.1004','Berohol'),
('12.76.04.1005','Bandar Sakti'),
('12.76.04.1006','Pinang Mancung'),
('12.76.04.1007','Teluk Karang'),
('12.76.05','Tebing Tinggi Kota'),
('12.76.05.1001','Mandailing'),
('12.76.05.1002','Pasar Baru'),
('12.76.05.1003','Pasar Gambir'),
('12.76.05.1004','Badak Bejuang'),
('12.76.05.1005','Bandar Utama'),
('12.76.05.1006','Rambung'),
('12.76.05.1007','Tebing Tinggi Lama'),
('12.77','Kota Padangsidimpuan'),
('12.77.01','Padangsidimpuan Utara'),
('12.77.01.1001','Wek I'),
('12.77.01.1002','Wek II'),
('12.77.01.1003','Wek III'),
('12.77.01.1004','Wek IV'),
('12.77.01.1005','Tanobato'),
('12.77.01.1006','Tobat'),
('12.77.01.1007','Batang Ayumi Jae'),
('12.77.01.1008','Batang Ayumi Julu'),
('12.77.01.1009','Sadabuan'),
('12.77.01.1010','Panyanggar'),
('12.77.01.1011','Bonan Dolok'),
('12.77.01.1012','Losung Batu'),
('12.77.01.1013','Timbangan'),
('12.77.01.1014','Bincar'),
('12.77.01.1015','Kantin'),
('12.77.01.1016','Kayu Ombun'),
('12.77.02','Padangsidimpuan Selatan'),
('12.77.02.1001','Wek V'),
('12.77.02.1002','Wek VI'),
('12.77.02.1003','Losung'),
('12.77.02.1004','Sitamiang'),
('12.77.02.1005','Ujung Padang'),
('12.77.02.1006','Aek Tampang'),
('12.77.02.1007','Padang Matinggi'),
('12.77.02.1008','Silandit'),
('12.77.02.1009','Sidangkal'),
('12.77.02.1010','Hanopan'),
('12.77.02.1011','Padang Matinggi Lestari'),
('12.77.02.1012','Sitamiang Baru'),
('12.77.03','Padangsidimpuan Batunadua'),
('12.77.03.1001','Batunadua Jae'),
('12.77.03.1002','Batunadua Julu'),
('12.77.03.2003','Purwodadi'),
('12.77.03.2004','Gunung Hasahatan'),
('12.77.03.2005','Ujunggurap'),
('12.77.03.2006','Aek Tuhul'),
('12.77.03.2007','Baruas'),
('12.77.03.2008','Siloting'),
('12.77.03.2009','Aek Bayur'),
('12.77.03.2010','Pudun Jae'),
('12.77.03.2011','Pudun Julu'),
('12.77.03.2012','Batang Bahal'),
('12.77.03.2013','Aek Najaji'),
('12.77.03.2014','Simirik'),
('12.77.03.2015','Bargottopong'),
('12.77.04','Padangsidimpuan Hutaimbaru'),
('12.77.04.1001','Hutaimbaru'),
('12.77.04.1002','Lubuk Raya'),
('12.77.04.1003','Sabungan Jae'),
('12.77.04.1004','Lembah Lubuk Manik'),
('12.77.04.1005','Palopat Maria'),
('12.77.04.2006','Sabungan Sipabangun'),
('12.77.04.2007','Singali'),
('12.77.04.2008','Huta Padang'),
('12.77.04.2009','Partihaman Saroha'),
('12.77.04.2010','Tinjoman Lama'),
('12.77.05','Padangsidimpuan Tenggara'),
('12.77.05.1001','Sihitang'),
('12.77.05.1002','Pijor Koling'),
('12.77.05.2003','Palopat Pijor Koling'),
('12.77.05.2004','Salambue'),
('12.77.05.2005','Purbatua Pijor Koling'),
('12.77.05.2006','Sigulang'),
('12.77.05.2007','Manunggang Julu'),
('12.77.05.2008','Goti'),
('12.77.05.2009','Manegen'),
('12.77.05.2010','Huta Koje'),
('12.77.05.2011','Hutalimbong'),
('12.77.05.2012','Huta Padang'),
('12.77.05.2013','Perkebunan Pijor Koling'),
('12.77.05.2014','Labuhan Labo'),
('12.77.05.2015','Huta Lombang'),
('12.77.05.2016','Manunggang Jae'),
('12.77.05.2017','Labuhan Rasoki'),
('12.77.05.2018','Tarutung Baru'),
('12.77.06','Padangsidimpuan Angkola Julu'),
('12.77.06.2001','Joring Lombang'),
('12.77.06.2002','Batu Layan'),
('12.77.06.2003','Simasom'),
('12.77.06.2004','Pintu Langit Jae'),
('12.77.06.2005','Mompang'),
('12.77.06.2006','Rimba Soping'),
('12.77.06.2007','Simatohir'),
('12.77.06.2008','Joring Natobang'),
('12.78','Kota Gunungsitoli'),
('12.78.01','Gunungsitoli'),
('12.78.01.1030','Pasar Gunungsitoli'),
('12.78.01.1031','Saombo'),
('12.78.01.1032','Ilir'),
('12.78.01.2001','Bawodesolo'),
('12.78.01.2002','Boyo'),
('12.78.01.2003','Dahadano Gawu-Gawu'),
('12.78.01.2004','Dahana Tabaloho'),
('12.78.01.2005','Fadoro Lasara'),
('12.78.01.2006','Hilihao'),
('12.78.01.2007','Hilimbaruzo'),
('12.78.01.2008','Hilina''a'),
('12.78.01.2009','Iraonogeba'),
('12.78.01.2010','Lasara Bahili'),
('12.78.01.2011','Lolowonu Niko''otano'),
('12.78.01.2012','Madula'),
('12.78.01.2013','Madolaoli'),
('12.78.01.2014','Mudik'),
('12.78.01.2015','Miga'),
('12.78.01.2016','Mo''awo'),
('12.78.01.2017','Ombolata Ulu'),
('12.78.01.2018','Onowaembo'),
('12.78.01.2019','Onozitoli Olora'),
('12.78.01.2020','Onozitoli Sifaoroasi'),
('12.78.01.2021','Saewe'),
('12.78.01.2022','Sifalaete Tabaloho'),
('12.78.01.2023','Sifalaete Ulu'),
('12.78.01.2024','Sihare''o II Tabaloho'),
('12.78.01.2025','Simandraolo'),
('12.78.01.2026','Sisarahiligamo'),
('12.78.01.2027','Sisarahili Sisambualahe'),
('12.78.01.2028','Sisobahili Tabaloho'),
('12.78.01.2029','Tuhemberua Ulu'),
('12.78.02','Gunungsitoli Selatan'),
('12.78.02.2001','Ononamolo I Lot'),
('12.78.02.2002','Fodo'),
('12.78.02.2003','Faekhu'),
('12.78.02.2004','Lolofaoso Tabaloho'),
('12.78.02.2005','Lolomboli'),
('12.78.02.2006','Mazingo Tabaloho'),
('12.78.02.2007','Onozitoli Tabaloho'),
('12.78.02.2008','Lololakha'),
('12.78.02.2009','Sihare''o I Tabaloho'),
('12.78.02.2010','Ombolata Simenari'),
('12.78.02.2011','Hiligara'),
('12.78.02.2012','Luahalaraga'),
('12.78.02.2013','Sisobahili II Tanose''o'),
('12.78.02.2014','Hiligodu Ombolata'),
('12.78.02.2015','Tetehosi Ombolata'),
('12.78.03','Gunungsitoli Utara'),
('12.78.03.2001','Afia'),
('12.78.03.2002','Lolo''ana''a Lolomoyo'),
('12.78.03.2003','Lasara Sowu'),
('12.78.03.2004','Telukbelukar'),
('12.78.03.2005','Tetehosi Afia'),
('12.78.03.2006','Hambawa'),
('12.78.03.2007','Gawu-Gawu Bo''uso'),
('12.78.03.2008','Olora'),
('12.78.03.2009','Hilimbowo Olora'),
('12.78.03.2010','Hiligodu Ulu'),
('12.78.04','Gunungsitoli Idanoi'),
('12.78.04.2001','Sifalaete'),
('12.78.04.2002','Hilimbawodesolo'),
('12.78.04.2003','Dahana'),
('12.78.04.2004','Bawodesolo'),
('12.78.04.2005','Tuhegeo I'),
('12.78.04.2006','Simanaere'),
('12.78.04.2007','Humene'),
('12.78.04.2008','Siwalubanua II'),
('12.78.04.2009','Helefanikha'),
('12.78.04.2010','Tetehosi I'),
('12.78.04.2011','Fowa'),
('12.78.04.2012','Binaka'),
('12.78.04.2013','Idanotae'),
('12.78.04.2014','Tetehosi II'),
('12.78.04.2015','Lolo''ana''a Idanoi'),
('12.78.04.2016','Siwalubanua I'),
('12.78.04.2017','Hilihambawa'),
('12.78.04.2018','Awa''ai'),
('12.78.04.2019','Lewuoguru Idanoi'),
('12.78.04.2020','Fadoro'),
('12.78.04.2021','Hiliweto Idanoi'),
('12.78.04.2022','Hilimbowo Idanoi'),
('12.78.04.2023','Onowaembo'),
('12.78.04.2024','Ombolata'),
('12.78.04.2025','Samasi'),
('12.78.04.2026','Tuhegeo II'),
('12.78.05','Gunungsitoli Alo''oa'),
('12.78.05.2001','Nazalou Alo''oa'),
('12.78.05.2002','Niko''otano Dao'),
('12.78.05.2003','Iraonolase'),
('12.78.05.2004','Orahili Tanose''o'),
('12.78.05.2005','Tarakhaini'),
('12.78.05.2006','Fadoro Hilimbowo'),
('12.78.05.2007','Fadoro You'),
('12.78.05.2008','Lololawa'),
('12.78.05.2009','Nazalou Lolowua'),
('12.78.06','Gunungsitoli Barat'),
('12.78.06.2001','Tumori'),
('12.78.06.2002','Tumori Balohili'),
('12.78.06.2003','Orahili Tumori'),
('12.78.06.2004','Gada'),
('12.78.06.2005','Lolomoyo Tuhemberua'),
('12.78.06.2006','Sihare''o Siwahili'),
('12.78.06.2007','Hilinakhe'),
('12.78.06.2008','Onozikho'),
('12.78.06.2009','Ononamolo II Lot');

-- Provinsi SUMATERA BARAT
INSERT INTO wilayah (kode, nama)
VALUES
('13','Sumatera Barat'),
('13.01','Kabupaten Pesisir Selatan'),
('13.01.01','Pancung Soal'),
('13.01.01.2001','Inderapura'),
('13.01.01.2002','Muaro Sakai Inderapura'),
('13.01.01.2003','Tiga Sepakat Inderapura'),
('13.01.01.2004','Inderapura Barat'),
('13.01.01.2005','Kudo-Kudo Inderapura'),
('13.01.01.2006','Inderapura Selatan'),
('13.01.01.2009','Simpang Lama Inderapura'),
('13.01.01.2010','Tigo Sungai Inderapura'),
('13.01.01.2011','Tluk Amplu Inderapura'),
('13.01.01.2012','Inderapura Tengah'),
('13.01.02','Ranah Pesisir'),
('13.01.02.2001','Pelangai'),
('13.01.02.2002','Sungai Tunu'),
('13.01.02.2003','Sungai Tunu Utara'),
('13.01.02.2004','Sungai Tunu Barat'),
('13.01.02.2005','Nyiur Melambai Pelangai'),
('13.01.02.2006','Sungai Liku Pelangai'),
('13.01.02.2007','Koto VIII Pelangai'),
('13.01.02.2008','Pelangai Gadang'),
('13.01.02.2009','Pelangai Kaciak'),
('13.01.02.2010','Pasia Pelangai'),
('13.01.03','Lengayang'),
('13.01.03.2001','Kambang'),
('13.01.03.2002','Lakitan'),
('13.01.03.2003','Kambang Utara'),
('13.01.03.2004','Kambang Timur'),
('13.01.03.2005','Kambang Barat'),
('13.01.03.2006','Lakitan Utara'),
('13.01.03.2007','Lakitan Selatan'),
('13.01.03.2008','Lakitan Timur'),
('13.01.03.2009','Lakitan Tengah'),
('13.01.04','Batang Kapas'),
('13.01.04.2001','IV Koto Hilie'),
('13.01.04.2002','IV Koto Mudiek'),
('13.01.04.2003','Taluak'),
('13.01.04.2004','Koto Nan Duo IV Koto Hilie'),
('13.01.04.2005','Koto Nan Tigo IV Koto Hilie'),
('13.01.04.2006','Teratak Tempatih IV Koto Mudiek'),
('13.01.04.2007','Tuik IV Koto Mudiek'),
('13.01.04.2008','Sungai Nyalo IV Koto Mudiek'),
('13.01.04.2009','Taluk Tigo Sakato'),
('13.01.05','IV Jurai'),
('13.01.05.2001','Painan'),
('13.01.05.2002','Tambang'),
('13.01.05.2003','Salido'),
('13.01.05.2004','Lumpo'),
('13.01.05.2005','Bunga Pasang Salido'),
('13.01.05.2006','Sago Salido'),
('13.01.05.2007','Salido Sari Bulan'),
('13.01.05.2008','Koto Rawang'),
('13.01.05.2009','Limau Gadang Lumpo'),
('13.01.05.2010','Batu Kunik Lumpo'),
('13.01.05.2011','Taratak Tangah Lumpo'),
('13.01.05.2012','Ampuan Lumpo'),
('13.01.05.2013','Ampang Tareh Lumpo'),
('13.01.05.2014','Balai Sinayan Lumpo'),
('13.01.05.2015','Sungai Gayo Lumpo'),
('13.01.05.2016','Sungai Sariak Lumpo'),
('13.01.05.2017','Bukik Kaciak Lumpo'),
('13.01.05.2018','Gunung Bungkuak Lumpo'),
('13.01.05.2019','Painan Selatan Painan'),
('13.01.05.2020','Painan Timur Painan'),
('13.01.06','Bayang'),
('13.01.06.2005','Koto Berapak'),
('13.01.06.2006','Talaok'),
('13.01.06.2007','Pasar Baru'),
('13.01.06.2008','Gurun Panjang'),
('13.01.06.2009','Api-api Pasar Baru'),
('13.01.06.2010','Tanjung Durian Pasar Baru'),
('13.01.06.2011','Asam Kamba Pasar Baru'),
('13.01.06.2012','Sawah Laweh Pasar Baru'),
('13.01.06.2013','Kapeh Panji Jaya Talaok'),
('13.01.06.2014','Aur Begalung Talaok'),
('13.01.06.2015','Kapelgam Koto Berapak'),
('13.01.06.2016','Koto Baru Koto Berapak'),
('13.01.06.2017','Kubang Koto Berapak'),
('13.01.06.2018','Kapujan Koto Berapak'),
('13.01.06.2019','Gurun Panjang Utara'),
('13.01.06.2020','Gurun Panjang Barat'),
('13.01.06.2021','Gurun Panjang Selatan'),
('13.01.07','Koto XI Tarusan'),
('13.01.07.2001','Siguntur'),
('13.01.07.2002','Sungai Pinang'),
('13.01.07.2003','Duku'),
('13.01.07.2004','Batu Hampa'),
('13.01.07.2005','Nanggalo'),
('13.01.07.2006','Ampang Pulai'),
('13.01.07.2007','Kapuh'),
('13.01.07.2008','Barung-Barung Balantai'),
('13.01.07.2009','Barung-Barung Balantai Selatan'),
('13.01.07.2010','Mandeh'),
('13.01.07.2011','Kapuah Utara'),
('13.01.07.2012','Taratak Sungai Lundang'),
('13.01.07.2013','Siguntur Tua'),
('13.01.07.2014','Kampung Baru Korong Nan Ampek'),
('13.01.07.2015','Duku Utara'),
('13.01.07.2016','Pulau Karam Ampang Pulai'),
('13.01.07.2017','Jinang Kampung Pansur Ampang Pulai'),
('13.01.07.2018','Cerocok Anau Ampang Pulai'),
('13.01.07.2019','Sungai Nyalo Mudiak Aia'),
('13.01.07.2020','Batu Hampar Selatan'),
('13.01.07.2021','Barung-Barung Balantai Timur'),
('13.01.07.2022','Barung-Barung Balantai Tengah'),
('13.01.07.2023','Setara Nanggalo'),
('13.01.08','Sutera'),
('13.01.08.2001','Taratak'),
('13.01.08.2002','Surantih'),
('13.01.08.2003','Amping Parak'),
('13.01.08.2004','Amping Parak Timur'),
('13.01.08.2005','Koto Taratak'),
('13.01.08.2006','Lansano Taratak'),
('13.01.08.2007','Aur Duri Surantih'),
('13.01.08.2008','Rawang Gunung Malelo Surantih'),
('13.01.08.2009','Koto Nan Tigo Selatan Surantih'),
('13.01.08.2010','Koto Nan Tigo Utara Surantih'),
('13.01.08.2011','Ganting Mudiak Selatan Surantih'),
('13.01.08.2012','Ganting Mudiak Utara Surantih'),
('13.01.09','Linggo Sari Baganti'),
('13.01.09.2001','Punggasan'),
('13.01.09.2002','Air Haji'),
('13.01.09.2003','Punggasan Utara'),
('13.01.09.2004','Punggasan Timur'),
('13.01.09.2005','Padang XI Punggasan'),
('13.01.09.2006','Lagan Mudik Punggasan'),
('13.01.09.2007','Lagan Hilir Punggasan'),
('13.01.09.2008','Air Haji Tenggara'),
('13.01.09.2009','Pasar Lama Muara Air Haji'),
('13.01.09.2010','Pasar Bukit Air Haji'),
('13.01.09.2011','Air Haji Barat'),
('13.01.09.2012','Air Haji Tengah'),
('13.01.09.2013','Rantau Simalenang Air Haji'),
('13.01.09.2014','Muara Gadang Air Haji'),
('13.01.09.2015','Sungai Sirah Air Haji'),
('13.01.09.2016','Muara Kandis Punggasan'),
('13.01.10','Lunang'),
('13.01.10.2001','Lunang'),
('13.01.10.2003','Lunang Utara'),
('13.01.10.2004','Lunang Selatan'),
('13.01.10.2005','Lunang Barat'),
('13.01.10.2015','Sindang Lunang'),
('13.01.10.2016','Pondok Parian Lunang'),
('13.01.10.2017','Lunang Tengah'),
('13.01.10.2018','Lunang Satu'),
('13.01.10.2019','Lunang Dua'),
('13.01.10.2020','Lunang Tiga'),
('13.01.11','Basa Ampek Balai Tapan'),
('13.01.11.2001','Tapan'),
('13.01.11.2002','Pasar Tapan'),
('13.01.11.2007','Batang Arah Tapan'),
('13.01.11.2008','Ampang Tulak Tapan'),
('13.01.11.2009','Tanjung Pondok Tapan'),
('13.01.11.2010','Batang Betung Tapan'),
('13.01.11.2016','Bukit Buai Tapan'),
('13.01.11.2017','Riak Danau Tapan'),
('13.01.11.2018','Koto Anau Tapan'),
('13.01.11.2019','Dusun Baru Tapan'),
('13.01.12','IV Nagari Bayang Utara'),
('13.01.12.2001','Puluik-Puluik'),
('13.01.12.2002','Koto Ranah'),
('13.01.12.2003','Muaro Aie'),
('13.01.12.2004','Pancuang Taba'),
('13.01.12.2005','Puluik-Puluik Selatan'),
('13.01.12.2006','Limau Gadang Pancung Taba'),
('13.01.13','Airpura'),
('13.01.13.2001','Inderapura Utara'),
('13.01.13.2002','Muara Inderapura'),
('13.01.13.2003','Damar Lapan Batang Inderapura'),
('13.01.13.2004','Lalang Panjang Inderapura'),
('13.01.13.2005','Palokan Inderapura'),
('13.01.13.2006','Lubuk Betung Inderapura'),
('13.01.13.2007','Tluk Kualo Inderapura'),
('13.01.13.2008','Tanah Bakali Inderapura'),
('13.01.13.2009','Inderapura Timur'),
('13.01.13.2010','Pulau Rajo Inderapura'),
('13.01.14','Ranah Ampek Hulu Tapan'),
('13.01.14.2001','Sungai Gambir Sako Tapan'),
('13.01.14.2002','Limau Purut Tapan'),
('13.01.14.2003','Talang Balarik Tapan'),
('13.01.14.2004','Tebing Tinggi Tapan'),
('13.01.14.2005','Binjai Tapan'),
('13.01.14.2006','Sungai Pinang Tapan'),
('13.01.14.2007','Talang Koto Pulai Tapan'),
('13.01.14.2008','Kampung Tengah Tapan'),
('13.01.14.2009','Kubu Tapan'),
('13.01.14.2010','Simpang Gunung Tapan'),
('13.01.15','Silaut'),
('13.01.15.2001','Silaut'),
('13.01.15.2002','Sungai Sirah'),
('13.01.15.2003','Sungai Sarik'),
('13.01.15.2004','Sungai Pulai'),
('13.01.15.2005','Pasir Binjai'),
('13.01.15.2006','Talang Binjai'),
('13.01.15.2007','Durian Seribu'),
('13.01.15.2008','Lubuk Bunta'),
('13.01.15.2009','Air Hitam'),
('13.01.15.2010','Sambungo'),
('13.02','Kabupaten Solok'),
('13.02.03','Pantai Cermin'),
('13.02.03.2001','Lolo'),
('13.02.03.2002','Surian'),
('13.02.04','Lembah Gumanti'),
('13.02.04.2001','Alahan Panjang'),
('13.02.04.2002','Sungai Nanam'),
('13.02.04.2003','Salimpat'),
('13.02.04.2004','Aie Dingin'),
('13.02.05','Payung Sekaki'),
('13.02.05.2001','Supayang'),
('13.02.05.2002','Sirukam'),
('13.02.05.2003','Aie Luo'),
('13.02.06','Lembang Jaya'),
('13.02.06.2001','Batu Banyak'),
('13.02.06.2002','Batu Bajanjang'),
('13.02.06.2003','Koto Laweh'),
('13.02.06.2004','Limau Lunggo'),
('13.02.06.2005','Koto Gadang Koto Anau'),
('13.02.06.2006','Selayo Tanang B. Sileh'),
('13.02.07','Gunung Talang'),
('13.02.07.2001','Cupak'),
('13.02.07.2002','Talang'),
('13.02.07.2003','Koto Gadang Guguak'),
('13.02.07.2004','Jawi Jawi'),
('13.02.07.2005','Sungai Janiah'),
('13.02.07.2006','Batang Barus'),
('13.02.07.2007','Aie Batumbuak'),
('13.02.07.2008','Koto Gaek Guguk'),
('13.02.08','Bukit Sundi'),
('13.02.08.2001','Muaro Paneh'),
('13.02.08.2002','Kinari'),
('13.02.08.2003','Bukit Tandang'),
('13.02.08.2004','Parambahan'),
('13.02.08.2005','Dilam'),
('13.02.09','IX Koto Sungai Lasi'),
('13.02.09.2001','Taruang-Taruang'),
('13.02.09.2002','Siaro-Aro'),
('13.02.09.2003','Pianggu'),
('13.02.09.2004','Sungai Durian'),
('13.02.09.2005','Bukik Bais'),
('13.02.09.2006','Sungai Jambur'),
('13.02.09.2007','Guguak Sarai'),
('13.02.09.2008','Koto Laweh'),
('13.02.09.2009','Indudur'),
('13.02.10','Kubung'),
('13.02.10.2001','Koto Baru'),
('13.02.10.2002','Selayo'),
('13.02.10.2003','Panyakalan'),
('13.02.10.2004','Gaung'),
('13.02.10.2005','Gantuang Ciri'),
('13.02.10.2006','Saok Laweh'),
('13.02.10.2007','Koto Hilalang'),
('13.02.10.2008','Tanjung Bingkung'),
('13.02.11','X Koto Singkarak'),
('13.02.11.2001','Sumani'),
('13.02.11.2002','Tikalak'),
('13.02.11.2003','Koto Sani'),
('13.02.11.2004','Singkarak'),
('13.02.11.2005','Aripan'),
('13.02.11.2006','Kacang'),
('13.02.11.2007','Tanjung Alai'),
('13.02.11.2008','Saniangbaka'),
('13.02.12','X Koto Diatas'),
('13.02.12.2001','Sulit Air'),
('13.02.12.2002','Tanjung Balik'),
('13.02.12.2003','Paninjauan'),
('13.02.12.2004','Kuncir'),
('13.02.12.2005','Katialo'),
('13.02.12.2006','Pasilihan'),
('13.02.12.2007','Bukit Kanduang'),
('13.02.12.2008','Sibarambang'),
('13.02.12.2009','Labuh Panjang'),
('13.02.13','Junjung Sirih'),
('13.02.13.2001','Paninggahan'),
('13.02.13.2002','Muaro Pingai'),
('13.02.17','Hiliran Gumanti'),
('13.02.17.2001','Talang Babungo'),
('13.02.17.2002','Sariak Alahan Tigo'),
('13.02.17.2003','Sungai Abu'),
('13.02.18','Tigo Lurah'),
('13.02.18.2001','Rangkiang Luluih'),
('13.02.18.2002','Batu Bajanjang'),
('13.02.18.2003','Garabak Data'),
('13.02.18.2004','Tanjung Balik Sumiso'),
('13.02.18.2005','Simanau'),
('13.02.19','Danau Kembar'),
('13.02.19.2001','Simpang Tj. Nan IV'),
('13.02.19.2002','Kampung Batu Dalam'),
('13.03','Kabupaten Sijunjung'),
('13.03.03','Tanjung Gadang'),
('13.03.03.2001','Timbulun'),
('13.03.03.2002','Tanjung Gadang'),
('13.03.03.2003','Taratak Baru'),
('13.03.03.2004','Pulasan'),
('13.03.03.2005','Langki'),
('13.03.03.2006','Sibakur'),
('13.03.03.2007','Tanjung Lolo'),
('13.03.03.2008','Taratak Baru Utara'),
('13.03.03.2009','Sinyamu'),
('13.03.04','Sijunjung'),
('13.03.04.2001','Muaro'),
('13.03.04.2002','Kandang Baru'),
('13.03.04.2003','Silokek'),
('13.03.04.2004','Pematang Panjang'),
('13.03.04.2005','Solok Ambah'),
('13.03.04.2006','Paru'),
('13.03.04.2007','Durian Gadang'),
('13.03.04.2008','Aie Angek'),
('13.03.04.2009','Sijunjung'),
('13.03.05','IV Nagari'),
('13.03.05.2001','Palangki'),
('13.03.05.2002','Koto Baru'),
('13.03.05.2003','Muaro Bodi'),
('13.03.05.2004','Mundam Sakti'),
('13.03.05.2005','Koto Tuo'),
('13.03.06','Kamang Baru'),
('13.03.06.2001','Sungai Lansek'),
('13.03.06.2002','Kamang'),
('13.03.06.2003','Muaro Takuang'),
('13.03.06.2004','Aie Amo'),
('13.03.06.2005','Sungai Batuang'),
('13.03.06.2006','Kunangan Parik Rantang'),
('13.03.06.2007','Tanjung Kaliang'),
('13.03.06.2008','Padang Tarok'),
('13.03.06.2009','Siaur'),
('13.03.06.2010','Lubuk Tarantang'),
('13.03.06.2011','Maloro'),
('13.03.07','Lubuk Tarok'),
('13.03.07.2001','Lubuak Tarok'),
('13.03.07.2002','Lalan'),
('13.03.07.2003','Buluah Kasok'),
('13.03.07.2004','Kampung Dalam'),
('13.03.07.2005','Silongo'),
('13.03.07.2006','Latang'),
('13.03.08','Koto VII'),
('13.03.08.2001','Limo Koto'),
('13.03.08.2002','Palaluar'),
('13.03.08.2003','Guguak'),
('13.03.08.2004','Padang Laweh'),
('13.03.08.2005','Tanjung'),
('13.03.08.2006','Bukit Bual'),
('13.03.08.2007','Padang Laweh Selatan'),
('13.03.09','Sumpur Kudus'),
('13.03.09.2001','Silantai'),
('13.03.09.2002','Sisawah'),
('13.03.09.2003','Unggan'),
('13.03.09.2004','Tanjung Bonai Aur'),
('13.03.09.2005','Sumpur Kudus'),
('13.03.09.2006','Tamparungo'),
('13.03.09.2007','Kumanis'),
('13.03.09.2008','Manganti'),
('13.03.09.2009','Sumpur Kudus Selatan'),
('13.03.09.2010','Tanjung Labuah'),
('13.03.09.2011','Tanjung Bonai Aur Selatan'),
('13.03.10','Kupitan'),
('13.03.10.2001','Batu Manjulur'),
('13.03.10.2002','Pamuatan'),
('13.03.10.2003','Padang Sibusuk'),
('13.03.10.2004','Desa Kampung Baru'),
('13.04','Kabupaten Tanah Datar'),
('13.04.01','X Koto'),
('13.04.01.2001','Tambangan'),
('13.04.01.2002','Jaho'),
('13.04.01.2003','Singgalang'),
('13.04.01.2004','Paninjauan'),
('13.04.01.2005','Panyalaian'),
('13.04.01.2006','Koto Laweh'),
('13.04.01.2007','Aie Angek'),
('13.04.01.2008','Pandai Sikek'),
('13.04.01.2009','Koto Baru'),
('13.04.02','Batipuh'),
('13.04.02.2001','Andaleh'),
('13.04.02.2002','Sabu'),
('13.04.02.2003','Batipuah Ateh'),
('13.04.02.2004','Batipuah Baruah'),
('13.04.02.2005','Gunuang Rajo'),
('13.04.02.2006','Pitalah'),
('13.04.02.2007','Tanjuang Barulak'),
('13.04.02.2008','Bungo Tanjuang'),
('13.04.03','Rambatan'),
('13.04.03.2001','Simawang'),
('13.04.03.2002','Balimbiang'),
('13.04.03.2003','III Koto'),
('13.04.03.2004','Padang Magek'),
('13.04.03.2005','Rambatan'),
('13.04.04','Lima Kaum'),
('13.04.04.2001','Baringin'),
('13.04.04.2002','Limo Kaum'),
('13.04.04.2003','Parambahan'),
('13.04.04.2004','Cubadak'),
('13.04.04.2005','Labuh'),
('13.04.05','Tanjung Emas'),
('13.04.05.2001','Tanjung Barulak'),
('13.04.05.2002','Saruaso'),
('13.04.05.2003','Koto Tangah'),
('13.04.05.2004','Pagaruyung'),
('13.04.06','Lintau Buo'),
('13.04.06.2001','Taluk'),
('13.04.06.2002','Buo'),
('13.04.06.2003','Tigo Jangko'),
('13.04.06.2004','Pangian'),
('13.04.07','Sungayang'),
('13.04.07.2001','Sungai Patai'),
('13.04.07.2002','Andaleh Baruh Bukik'),
('13.04.07.2003','Tanjung'),
('13.04.07.2004','Sungayang'),
('13.04.07.2005','Minang Kabau'),
('13.04.08','Sungai Tarab'),
('13.04.08.2001','Simpuruik'),
('13.04.08.2002','Sungai Tarab'),
('13.04.08.2003','Gurun'),
('13.04.08.2004','Talang Tangah'),
('13.04.08.2005','Padang Laweh'),
('13.04.08.2006','Pasie Laweh'),
('13.04.08.2007','Koto Tuo'),
('13.04.08.2008','Rao Rao'),
('13.04.08.2009','Kumango'),
('13.04.08.2010','Koto Baru'),
('13.04.09','Pariangan'),
('13.04.09.2001','Batu Basa'),
('13.04.09.2002','Tabek'),
('13.04.09.2003','Sawah Tangah'),
('13.04.09.2004','Simabur'),
('13.04.09.2005','Pariangan'),
('13.04.09.2006','Sungai Jambu'),
('13.04.10','Salimpaung'),
('13.04.10.2001','Sumanik'),
('13.04.10.2002','Situmbuk'),
('13.04.10.2003','Lawang Mandahiling'),
('13.04.10.2004','Supayang'),
('13.04.10.2005','Salimpaung'),
('13.04.10.2006','Tabek Patah'),
('13.04.11','Padang Ganting'),
('13.04.11.2001','Atar'),
('13.04.11.2002','Padang Ganting'),
('13.04.12','Tanjuang Baru'),
('13.04.12.2001','Tanjuang Alam'),
('13.04.12.2002','Barulak'),
('13.04.13','Lintau Buo Utara'),
('13.04.13.2001','Batu Bulek'),
('13.04.13.2002','Balai Tangah'),
('13.04.13.2003','Tanjuang Bonai'),
('13.04.13.2004','Lubuak Jantan'),
('13.04.13.2005','Tapi Selo'),
('13.04.14','Batipuah Selatan'),
('13.04.14.2001','Batu Taba'),
('13.04.14.2002','Sumpur'),
('13.04.14.2003','Padang Laweh Malalo'),
('13.04.14.2004','Guguak Malalo'),
('13.05','Kabupaten Padang Pariaman'),
('13.05.01','Lubuak Aluang'),
('13.05.01.2001','Lubuk Alung'),
('13.05.01.2002','Pungguang Kasiak Lubuk Alung'),
('13.05.01.2003','Pasie Laweh Lubuk Alung'),
('13.05.01.2004','Aie Tajun Lubuk Alung'),
('13.05.01.2005','Sikabu Lubuk Alung'),
('13.05.01.2006','Sungai Abang Lubuk Alung'),
('13.05.01.2007','Singguliang Lubuk Alung'),
('13.05.01.2008','Salibutan Lubuk Alung'),
('13.05.01.2009','Nagari Balah Hilia Lubuk Alung'),
('13.05.02','Batang Anai'),
('13.05.02.2001','Katapiang'),
('13.05.02.2002','Kasang'),
('13.05.02.2003','Sungai Buluah'),
('13.05.02.2004','Buayan Lubuk Alung'),
('13.05.02.2005','Sungai Buluah Timur'),
('13.05.02.2006','Sungai Buluah Barat'),
('13.05.02.2007','Sungai Buluah Utara'),
('13.05.02.2008','Sungai Buluah Selatan'),
('13.05.03','Nan Sabaris'),
('13.05.03.2001','Kapalo Koto'),
('13.05.03.2002','Pauh Kambar'),
('13.05.03.2003','Padang Bintungan'),
('13.05.03.2004','Kurai Taji'),
('13.05.03.2005','Sunua'),
('13.05.03.2006','Padang Kandang Pulau Air Padang Bintungan'),
('13.05.03.2007','Sunua Tengah'),
('13.05.03.2008','Sunua Barat'),
('13.05.03.2009','Kurai Taji Timur'),
('13.05.04','2 x 11 Anam Lingkuang'),
('13.05.04.2002','Sicincin'),
('13.05.04.2003','Lubuk Pandan'),
('13.05.04.2004','Sungai Asam'),
('13.05.05','VII Koto'),
('13.05.05.2001','Balah Aie'),
('13.05.05.2002','Sungai Sariak'),
('13.05.05.2003','Lurah Ampalu'),
('13.05.05.2004','Lareh Nan Panjang'),
('13.05.05.2005','Lareh Nan Panjang Selatan'),
('13.05.05.2006','Lareh Nan Panjang Barat'),
('13.05.05.2007','Bisati Sungai Sariak'),
('13.05.05.2008','Ambuang Kapua Sungai Sariak'),
('13.05.05.2009','Lareh Nan Panjang Sungai Sariak'),
('13.05.05.2010','Limpato Sungai Sariak'),
('13.05.05.2011','Balah Aie Utara'),
('13.05.05.2012','Balah Aie Timur'),
('13.05.06','V Koto'),
('13.05.06.2001','Campago'),
('13.05.06.2002','Sikucua'),
('13.05.06.2003','Campago Barat'),
('13.05.06.2004','Campago Selatan'),
('13.05.06.2005','Sikucua Utara'),
('13.05.06.2006','Sikucua Timur'),
('13.05.06.2007','Sikucua Tengah'),
('13.05.06.2008','Sikucua Barat'),
('13.05.07','Sungai Garinggiang'),
('13.05.07.2001','Kuranji Hulu'),
('13.05.07.2002','Malai III Koto'),
('13.05.07.2003','Batu Gadang Kuranji Hulu'),
('13.05.07.2004','Sungai Sirah Kuranji Hulu'),
('13.05.08','Sungai Limau'),
('13.05.08.2001','Kuranji Hilir'),
('13.05.08.2002','Pilubang'),
('13.05.08.2003','Guguak Kuranji Hilir'),
('13.05.08.2004','Koto Tinggi Kuranji Hilir'),
('13.05.09','IV Koto Aua Malintang'),
('13.05.09.2001','III Koto Aur Malintang'),
('13.05.09.2002','III Koto Aur Malintang Utara'),
('13.05.09.2003','III Koto Aur Malintang Timur'),
('13.05.09.2004','III Koto Aur Malintang Selatan'),
('13.05.09.2005','Balai Baiak Malai III Koto'),
('13.05.10','Ulakan Tapakih'),
('13.05.10.2001','Tapakih'),
('13.05.10.2002','Ulakan'),
('13.05.10.2003','Padang Toboh Ulakan'),
('13.05.10.2004','Sungai Gimba Ulakan'),
('13.05.10.2005','Seulayat Ulakan'),
('13.05.10.2006','Manggopoh Palak Gadang Ulakan'),
('13.05.10.2007','Sandi Ulakan'),
('13.05.10.2008','Kampuang Gelapuang Ulakan'),
('13.05.11','Sintuak Toboh Gadang'),
('13.05.11.2001','Sintuak'),
('13.05.11.2002','Toboh Gadang'),
('13.05.11.2003','Toboh Gadang Selatan'),
('13.05.11.2004','Toboh Gadang Barat'),
('13.05.11.2005','Toboh Gadang Timur'),
('13.05.12','VII Koto Padang Sago'),
('13.05.12.2001','Koto Baru'),
('13.05.12.2002','Koto Dalam'),
('13.05.12.2003','Batu Kalang'),
('13.05.12.2004','Koto Dalam Barat'),
('13.05.12.2005','Koto Dalam Selatan'),
('13.05.12.2006','Batu Kalang Utara'),
('13.05.13','Batang Gasan'),
('13.05.13.2001','Malai V Suku'),
('13.05.13.2002','Gasan Gadang'),
('13.05.13.2003','Malai V Suku Timur'),
('13.05.14','V Koto Timur'),
('13.05.14.2001','Kudu Gantiang'),
('13.05.14.2002','Limau Puruik'),
('13.05.14.2003','Gunung Padang Alai'),
('13.05.14.2004','Kudu Gantiang Barat'),
('13.05.15','2 x 11 Kayu Tanam'),
('13.05.15.2001','Kayu Tanam'),
('13.05.15.2002','Guguak'),
('13.05.15.2003','Anduriang'),
('13.05.15.2004','Kapalo Hilalang'),
('13.05.16','Koto Patamuan'),
('13.05.16.2001','Sungai Durian'),
('13.05.16.2002','Tandikek'),
('13.05.16.2003','Tandikek Utara'),
('13.05.16.2004','Tandikek Selatan'),
('13.05.16.2005','Tandikek Barat'),
('13.05.16.2006','Kampuang Tanjuang Koto Mambang Sungai Durian'),
('13.05.17','Anam Lingkuang'),
('13.05.17.2001','Pakandangan'),
('13.05.17.2002','Koto Tinggi'),
('13.05.17.2003','Toboh Ketek'),
('13.05.17.2004','Parit Malintang'),
('13.05.17.2005','Gadur'),
('13.06','Kabupaten Agam'),
('13.06.01','Tanjung Mutiara'),
('13.06.01.2001','Tiku Selatan'),
('13.06.01.2002','Tiku Utara'),
('13.06.01.2003','Tiku Limo Jorong'),
('13.06.01.2004','Durian Kapeh Darussalam'),
('13.06.02','Lubuk Basung'),
('13.06.02.2001','Lubuk Basung'),
('13.06.02.2002','Garagahan'),
('13.06.02.2003','Kampung Pinang'),
('13.06.02.2004','Kampung Tangah'),
('13.06.02.2005','Manggopoh'),
('13.06.03','Tanjung Raya'),
('13.06.03.2001','Tanjung Sani'),
('13.06.03.2002','Sungai Batang'),
('13.06.03.2003','Maninjau'),
('13.06.03.2004','Bayua'),
('13.06.03.2006','Koto Kaciak'),
('13.06.03.2007','Duo Koto'),
('13.06.03.2008','Koto Gadang Anam Koto'),
('13.06.03.2009','Koto Malintang'),
('13.06.03.2010','Paninjauan'),
('13.06.03.2011','Dalko'),
('13.06.04','Matur'),
('13.06.04.2001','Matua Hilia'),
('13.06.04.2002','Matua Mudiak'),
('13.06.04.2003','Tigo Balai'),
('13.06.04.2004','Lawang'),
('13.06.04.2005','Parik Panjang'),
('13.06.04.2006','Panta Pauah'),
('13.06.05','IV Koto'),
('13.06.05.2002','Sungai Landia'),
('13.06.05.2003','Balingka'),
('13.06.05.2004','Koto Tuo'),
('13.06.05.2005','Guguak Tabek Sarojo'),
('13.06.05.2006','Koto Panjang'),
('13.06.05.2007','Sianok Anam Suku'),
('13.06.05.2008','Koto Gadang'),
('13.06.06','Banuhampu'),
('13.06.06.2001','Padang Lua'),
('13.06.06.2002','Taluak Ampek Suku'),
('13.06.06.2003','Pakan Sinayan'),
('13.06.06.2004','Kubang Putiah'),
('13.06.06.2005','Ladang Laweh'),
('13.06.06.2006','Cingkariang'),
('13.06.06.2007','Sungai Tanang'),
('13.06.07','Ampek Angkek'),
('13.06.07.2001','Batu Taba'),
('13.06.07.2002','Biaro Gadang'),
('13.06.07.2003','Lambah'),
('13.06.07.2004','Panampuang'),
('13.06.07.2005','Ampang Gadang'),
('13.06.07.2006','Pasia'),
('13.06.07.2008','Balai Gurah'),
('13.06.08','Baso'),
('13.06.08.2001','Koto Tinggi'),
('13.06.08.2002','Tabek Panjang'),
('13.06.08.2004','Simarasok'),
('13.06.08.2005','Padang Tarok'),
('13.06.08.2006','Salo'),
('13.06.08.2007','Koto Baru'),
('13.06.08.2008','Sungai Cubadak'),
('13.06.08.2009','Koto Gadang'),
('13.06.09','Tilatang Kamang'),
('13.06.09.2001','Koto Tangah'),
('13.06.09.2003','Gadut'),
('13.06.09.2004','Kapau'),
('13.06.10','Palupuh'),
('13.06.10.2001','Koto Rantang'),
('13.06.10.2002','Pasia Laweh'),
('13.06.10.2003','Pagadih'),
('13.06.10.2004','Nan Tujuah'),
('13.06.10.2005','Nan Limo'),
('13.06.11','Palembayan'),
('13.06.11.2001','Baringin'),
('13.06.11.2002','Sipinang'),
('13.06.11.2003','Sungai Puar'),
('13.06.11.2004','Ampek Koto Palembayan'),
('13.06.11.2005','Tigo Koto Silungkang'),
('13.06.11.2006','Salareh Aia'),
('13.06.11.2007','Salareh Aia Timur'),
('13.06.11.2008','Salareh Aia Utara'),
('13.06.11.2009','Salareh Aia Barat'),
('13.06.12','Sungai Pua'),
('13.06.12.2001','Padang Laweh'),
('13.06.12.2002','Sungai Pua'),
('13.06.12.2003','Batagak'),
('13.06.12.2004','Batu Palano'),
('13.06.12.2005','Sariak'),
('13.06.13','Ampek Nagari'),
('13.06.13.2001','Batu Kambing'),
('13.06.13.2002','Sitalang'),
('13.06.13.2003','Bawan'),
('13.06.13.2004','Sitanang'),
('13.06.14','Candung'),
('13.06.14.2001','Canduang Koto Laweh'),
('13.06.14.2002','Lasi'),
('13.06.14.2003','Bukik Batabuah'),
('13.06.15','Kamang Magek'),
('13.06.15.2001','Magek'),
('13.06.15.2002','Kamang Hilia'),
('13.06.15.2003','Kamang Mudiak'),
('13.06.15.2004','Kamang Tangah Anam Suku'),
('13.06.15.2005','Pauh Kamang Mudiak'),
('13.06.16','Malalak'),
('13.06.16.2001','Malalak Utara'),
('13.06.16.2002','Malalak Timur'),
('13.06.16.2003','Malalak Selatan'),
('13.06.16.2004','Malalak Barat'),
('13.07','Kabupaten Lima Puluh Kota'),
('13.07.01','Suliki'),
('13.07.01.2001','Kurai'),
('13.07.01.2002','Sungai Rimbang'),
('13.07.01.2003','Tanjuang Bungo'),
('13.07.01.2004','Suliki'),
('13.07.01.2005','Limbanang'),
('13.07.01.2006','Andiang'),
('13.07.02','Guguak'),
('13.07.02.2001','Guguak VIII Koto'),
('13.07.02.2002','VII Koto Talago'),
('13.07.02.2003','Sungai Talang'),
('13.07.02.2004','Kubang'),
('13.07.02.2005','Simpang Sugiran'),
('13.07.03','Payakumbuh'),
('13.07.03.2001','Koto Baru Simalanggang'),
('13.07.03.2002','Taeh Bukik'),
('13.07.03.2003','Simalanggang'),
('13.07.03.2004','Sungai Beringin'),
('13.07.03.2005','Piobang'),
('13.07.03.2006','Taeh Baruah'),
('13.07.03.2007','Koto Tangah Simalanggang'),
('13.07.04','Luak'),
('13.07.04.2001','Tj. Haro Sikabu-kabu Pd. Panjang'),
('13.07.04.2002','Mungo'),
('13.07.04.2003','Sungai Kamuyang'),
('13.07.04.2004','Andaleh'),
('13.07.05','Harau'),
('13.07.05.2001','Taram'),
('13.07.05.2002','Solok Bio Bio'),
('13.07.05.2003','Tarantang'),
('13.07.05.2004','Bukik Limbuku'),
('13.07.05.2005','Harau'),
('13.07.05.2006','Batu Balang'),
('13.07.05.2007','Sarilamak'),
('13.07.05.2008','Gurun'),
('13.07.05.2009','Lubuak Batingkok'),
('13.07.05.2010','Koto Tuo'),
('13.07.05.2011','Pilubang'),
('13.07.06','Pangkalan Koto Baru'),
('13.07.06.2001','Manggilang'),
('13.07.06.2002','Tanjuang Balik'),
('13.07.06.2003','Gunuang Malintang'),
('13.07.06.2004','Pangkalan'),
('13.07.06.2005','Koto Alam'),
('13.07.06.2006','Tanjung Pauh'),
('13.07.07','Kapur IX'),
('13.07.07.2001','Muaro Paiti'),
('13.07.07.2002','Koto Bangun'),
('13.07.07.2003','Lubuak Alai'),
('13.07.07.2004','Koto Lamo'),
('13.07.07.2005','Durian Tinggi'),
('13.07.07.2006','Sialang'),
('13.07.07.2007','Galugua'),
('13.07.08','Gunuang Omeh'),
('13.07.08.2001','Pandam Gadang'),
('13.07.08.2002','Koto Tinggi'),
('13.07.08.2003','Talang Anau'),
('13.07.09','Lareh Sago Halaban'),
('13.07.09.2001','Labuah Gunuang'),
('13.07.09.2002','Batu Payuang'),
('13.07.09.2003','Ampalu'),
('13.07.09.2004','Bukik Sikumpa'),
('13.07.09.2005','Balai Panjang'),
('13.07.09.2006','Halaban'),
('13.07.09.2007','Tanjuang Gadang'),
('13.07.09.2008','Sitanang'),
('13.07.10','Situjuah Limo Nagari'),
('13.07.10.2001','Situjuah Batua'),
('13.07.10.2002','Situjuah Ladang Laweh'),
('13.07.10.2003','Tungka'),
('13.07.10.2004','Situjuah Banda Dalam'),
('13.07.10.2005','Situjuah Gadang'),
('13.07.11','Mungka'),
('13.07.11.2001','Jopang Manganti'),
('13.07.11.2002','Simpang Kapuak'),
('13.07.11.2003','Mungka'),
('13.07.11.2004','Talang Maur'),
('13.07.11.2005','Sungai Antuan'),
('13.07.12','Bukik Barisan'),
('13.07.12.2001','Maek'),
('13.07.12.2002','Banja Loweh'),
('13.07.12.2003','Baruah Gunuang'),
('13.07.12.2004','Sungai Naniang'),
('13.07.12.2005','Koto Tangah'),
('13.07.13','Akabiluru'),
('13.07.13.2001','Sariak Laweh'),
('13.07.13.2002','Koto Tangah Batu Ampa'),
('13.07.13.2003','Batuhampar'),
('13.07.13.2004','Suayan'),
('13.07.13.2005','Sungai Balantiak'),
('13.07.13.2006','Pauh Sangik'),
('13.07.13.2007','Durian Gadang'),
('13.08','Kabupaten Pasaman'),
('13.08.04','Bonjol'),
('13.08.04.2001','Limo Koto'),
('13.08.04.2002','Koto Kaciak'),
('13.08.04.2003','Ganggo Mudiak'),
('13.08.04.2004','Ganggo Hilia'),
('13.08.04.2007','Koto Kaciak Barat'),
('13.08.05','Lubuk Sikaping'),
('13.08.05.2001','Tanjuang Baringin'),
('13.08.05.2002','Jambak'),
('13.08.05.2003','Durian Tinggi'),
('13.08.05.2004','Pauah'),
('13.08.05.2005','Aia Manggih'),
('13.08.05.2006','Sundata'),
('13.08.05.2007','Tanjuang Baringin Utara'),
('13.08.05.2008','Tanjuang Baringin Selatan'),
('13.08.05.2009','Aia Manggih Utara'),
('13.08.05.2010','Aia Manggih Selatan'),
('13.08.05.2011','Aia Manggih Barat'),
('13.08.05.2012','Sundata Utara'),
('13.08.05.2013','Sundata Selatan'),
('13.08.07','Panti'),
('13.08.07.2001','Panti'),
('13.08.07.2003','Panti Timur'),
('13.08.07.2004','Panti Selatan'),
('13.08.07.2005','Panti Utara'),
('13.08.08','Mapat Tunggul'),
('13.08.08.2001','Muara Tais'),
('13.08.08.2002','Lubuak Gadang'),
('13.08.08.2005','Pintu Padang'),
('13.08.08.2006','Muaro Tais Koto Gadang'),
('13.08.12','Duo Koto'),
('13.08.12.2001','Simpang Tonang'),
('13.08.12.2002','Cubadak'),
('13.08.12.2003','Simpang Tonang Selatan'),
('13.08.12.2004','Simpang Tonang Utara'),
('13.08.12.2005','Cubadak Timur'),
('13.08.12.2006','Cubadak Tengah'),
('13.08.12.2007','Cubadak Barat'),
('13.08.13','Tigo Nagari'),
('13.08.13.2001','Malampah'),
('13.08.13.2002','Ladang Panjang'),
('13.08.13.2003','Binjai'),
('13.08.13.2004','Malampah Barat'),
('13.08.13.2005','Ladang Panjang Barat'),
('13.08.14','Rao'),
('13.08.14.2002','Taruang Taruang'),
('13.08.14.2005','Padang Mantinggi'),
('13.08.14.2008','Taruang Taruang Selatan'),
('13.08.14.2009','Taruang Taruang Utara'),
('13.08.14.2010','Padang Mantinggi Utara'),
('13.08.15','Mapat Tunggul Selatan'),
('13.08.15.2001','Silayang'),
('13.08.15.2002','Muaro Sungai Lolo'),
('13.08.16','Simpang Alahan Mati'),
('13.08.16.2001','Alahan Mati'),
('13.08.16.2002','Simpang'),
('13.08.16.2003','Alahan Mati Hilia'),
('13.08.16.2004','Simpang Utara'),
('13.08.17','Padang Gelugur'),
('13.08.17.2001','Padang Gelugur'),
('13.08.17.2002','Sontang Cubadak'),
('13.08.17.2003','Sitombol Padang Gelugua'),
('13.08.17.2004','Bahagia Padang Gelugua'),
('13.08.18','Rao Utara'),
('13.08.18.2001','Koto Nopan'),
('13.08.18.2002','Koto Rajo'),
('13.08.18.2003','Languang'),
('13.08.19','Rao Selatan'),
('13.08.19.2001','Lansek Kadok'),
('13.08.19.2002','Lubuak Layang'),
('13.08.19.2003','Tanjung Betung'),
('13.08.19.2004','Lansek Kadok Barat'),
('13.08.19.2005','Tanjung Betung Utara'),
('13.08.19.2006','Tanjung Betung Timur'),
('13.09','Kabupaten Kepulauan Mentawai'),
('13.09.01','Pagai Utara'),
('13.09.01.2007','Betumonga'),
('13.09.01.2008','Silabu'),
('13.09.01.2009','Saumanganya'),
('13.09.02','Sipora Selatan'),
('13.09.02.2001','Bosua'),
('13.09.02.2002','Beriulou'),
('13.09.02.2003','Nemnemleleu'),
('13.09.02.2004','Mara'),
('13.09.02.2006','Sioban'),
('13.09.02.2007','Matobe'),
('13.09.02.2008','Saureinu'),
('13.09.03','Siberut Selatan'),
('13.09.03.2002','Muara Siberut'),
('13.09.03.2003','Maileppet'),
('13.09.03.2004','Muntei'),
('13.09.03.2005','Matotonan'),
('13.09.03.2007','Madobag'),
('13.09.04','Siberut Utara'),
('13.09.04.2003','Bojakan'),
('13.09.04.2004','Sotboyak'),
('13.09.04.2005','Mongan Poula'),
('13.09.04.2006','Muara Sikabaluan'),
('13.09.04.2007','Sirilogui'),
('13.09.04.2008','Malancan'),
('13.09.05','Siberut Barat'),
('13.09.05.2001','Simatalu'),
('13.09.05.2002','Simalegi'),
('13.09.05.2003','Sigapokna'),
('13.09.06','Siberut Barat Daya'),
('13.09.06.2001','Katurei'),
('13.09.06.2002','Sagulubbeg'),
('13.09.06.2003','Pasakiat Taileleu'),
('13.09.07','Siberut Tengah'),
('13.09.07.2001','Saibi Samukop'),
('13.09.07.2002','Cimpungan'),
('13.09.07.2003','Saliguma'),
('13.09.08','Sipora Utara'),
('13.09.08.2001','Betumonga'),
('13.09.08.2002','Goisooinan'),
('13.09.08.2003','Tuapejat'),
('13.09.08.2004','Sido Makmur'),
('13.09.08.2005','Bukit Pamewa'),
('13.09.08.2006','Sipora Jaya'),
('13.09.09','Sikakap'),
('13.09.09.2001','Sikakap'),
('13.09.09.2002','Taikako'),
('13.09.09.2003','Matobe'),
('13.09.10','Pagai Selatan'),
('13.09.10.2001','Sinaka'),
('13.09.10.2002','Bulasat'),
('13.09.10.2003','Malakopa'),
('13.09.10.2004','Makalo'),
('13.10','Kabupaten Dharmasraya'),
('13.10.01','Koto Baru'),
('13.10.01.2002','Koto Baru'),
('13.10.01.2003','Sialang Gaung'),
('13.10.01.2005','Ampang Kuranji'),
('13.10.01.2008','Koto Padang'),
('13.10.02','Pulau Punjung'),
('13.10.02.2001','Sungai Dareh'),
('13.10.02.2002','Tebing Tinggi'),
('13.10.02.2006','Empat Koto Pulau Punjung'),
('13.10.02.2007','Sungai Kambut'),
('13.10.02.2008','Gunung Selasih'),
('13.10.02.2009','Sikabau'),
('13.10.03','Sungai Rumbai'),
('13.10.03.2003','Sungai Rumbai'),
('13.10.03.2004','Kurnia Koto Salak'),
('13.10.03.2007','Sungai Rumbai Timur'),
('13.10.03.2008','Kurnia Selatan'),
('13.10.04','Sitiung'),
('13.10.04.2001','Sitiung'),
('13.10.04.2002','Siguntur'),
('13.10.04.2004','Gunung Medan'),
('13.10.04.2005','Sungai Duo'),
('13.10.05','Sembilan Koto'),
('13.10.05.2001','Silago'),
('13.10.05.2002','Lubuak Karak'),
('13.10.05.2003','Koto Nan Empat Dibawuh'),
('13.10.05.2004','Banai'),
('13.10.06','Timpeh'),
('13.10.06.2001','Timpeh'),
('13.10.06.2002','Taratak Tinggi'),
('13.10.06.2003','Tabek'),
('13.10.06.2004','Panyubarangan'),
('13.10.06.2005','Ranah Palabi'),
('13.10.07','Koto Salak'),
('13.10.07.2001','Koto Salak'),
('13.10.07.2002','Ampalu'),
('13.10.07.2003','Padukuan'),
('13.10.07.2004','Pulau Mainan'),
('13.10.07.2005','Simalidu'),
('13.10.08','Tiumang'),
('13.10.08.2001','Tiumang'),
('13.10.08.2002','Sungai Langkok'),
('13.10.08.2003','Koto Beringin'),
('13.10.08.2004','Sipangkur'),
('13.10.09','Padang Laweh'),
('13.10.09.2001','Padang Laweh'),
('13.10.09.2002','Batu Rijal'),
('13.10.09.2003','Muaro Sopan'),
('13.10.09.2004','Sopan Jaya'),
('13.10.10','Asam Jujuhan'),
('13.10.10.2001','Sungai Limau'),
('13.10.10.2002','Alahan Nan Tigo'),
('13.10.10.2003','Lubuk Besar'),
('13.10.10.2004','Tanjung Alam'),
('13.10.10.2005','Sinamar'),
('13.10.11','Koto Besar'),
('13.10.11.2001','Koto Besar'),
('13.10.11.2002','Koto Tinggi'),
('13.10.11.2003','Koto Gadang'),
('13.10.11.2004','Bonjol'),
('13.10.11.2005','Abai Siat'),
('13.10.11.2006','Koto Laweh'),
('13.10.11.2007','Koto Ranah'),
('13.11','Kabupaten Solok Selatan'),
('13.11.01','Sangir'),
('13.11.01.2001','Lubuk Gadang'),
('13.11.01.2002','Lubuk Gadang Timur'),
('13.11.01.2003','Lubuk Gadang Selatan'),
('13.11.01.2004','Lubuk Gadang Utara'),
('13.11.02','Sungai Pagu'),
('13.11.02.2001','Pasir Talang'),
('13.11.02.2002','Koto Baru'),
('13.11.02.2004','Sako Pasia Talang'),
('13.11.02.2005','Pasar Muara Labuh'),
('13.11.02.2006','Pulakek Koto Baru'),
('13.11.02.2007','Bomas'),
('13.11.02.2008','Sako Utara Pasia Talang'),
('13.11.02.2009','Sako Selatan Pasia Talang'),
('13.11.02.2010','Pasir Talang Barat'),
('13.11.02.2011','Pasir Talang Timur'),
('13.11.02.2012','Pasir Talang Selatan'),
('13.11.03','Koto Parik Gadang Diateh'),
('13.11.03.2001','Pakan Rabaa'),
('13.11.03.2002','Pakan Rabaa Timur'),
('13.11.03.2003','Pakan Rabaa Utara'),
('13.11.03.2004','Pakan Rabaa Tengah'),
('13.11.04','Sangir Jujuan'),
('13.11.04.2001','Lubuk Malako'),
('13.11.04.2002','Bidar Alam'),
('13.11.04.2004','Padang Air Dingin'),
('13.11.04.2005','Padang Limau Sundai'),
('13.11.04.2006','Padang Gantiang'),
('13.11.05','Sangir Batang Hari'),
('13.11.05.2001','Abai'),
('13.11.05.2002','Dusun Tangah'),
('13.11.05.2003','Lubuk Ulang Aling'),
('13.11.05.2004','Ranah Pantai Cermin'),
('13.11.05.2005','Sitapus'),
('13.11.05.2006','Lubuk Ulang Aling Selatan'),
('13.11.05.2007','Lubuk Ulang Aling Tengah'),
('13.11.06','Pauh Duo'),
('13.11.06.2001','Alam Pauh Duo'),
('13.11.06.2002','Kapau Alam Pauh Duo'),
('13.11.06.2003','Luak Kapau Alam Pauh Duo'),
('13.11.06.2004','Pauh Duo Nan Batigo'),
('13.11.07','Sangir Balai Janggo'),
('13.11.07.2001','Sungai Kunyit'),
('13.11.07.2002','Talao Sungai Kunyit'),
('13.11.07.2003','Sungai Kunyit Barat'),
('13.11.07.2004','Talunan Maju'),
('13.12','Kabupaten Pasaman Barat'),
('13.12.01','Sungai Beremas'),
('13.12.01.2001','Aia Bangih'),
('13.12.02','Lembah Melintang'),
('13.12.02.2001','Ujung Gading'),
('13.12.02.2002','Brastagi Ujung Gading'),
('13.12.02.2003','Tampus Damai Ujung Gading'),
('13.12.02.2004','Taluak Ambun Ujung Gading'),
('13.12.02.2005','Koto Gunung Ujung Gading'),
('13.12.02.2006','Koto Sawah Ujung Gading'),
('13.12.02.2007','Salido Saroha Ujung Gading'),
('13.12.02.2008','Kuamang Alai Ujung Gading'),
('13.12.02.2009','Situak Ujung Gading'),
('13.12.03','Pasaman'),
('13.12.03.2003','Lingkuang Aua'),
('13.12.03.2004','Aua Kuniang'),
('13.12.03.2006','Aia Gadang'),
('13.12.03.2007','Lingkuang Aua Timur'),
('13.12.03.2008','Lingkuang Aua Baru'),
('13.12.03.2009','Lingkuang Aua Bandarajo'),
('13.12.03.2010','Lingkuang Aua Jambak'),
('13.12.03.2011','Lingkuang Aua Koto Dalam'),
('13.12.03.2012','Lingkuang Aua Barat'),
('13.12.03.2013','Lingkuang Aua Hilia'),
('13.12.03.2014','Sukomananti Aua Kuniang'),
('13.12.03.2015','Aia Gadang Timur'),
('13.12.03.2016','Aia Gadang Barat'),
('13.12.03.2017','Pinaga Aua Kuniang'),
('13.12.03.2018','Lubuak Landua Aua Kuniang'),
('13.12.03.2019','Lembah Binuang Aua Kuniang'),
('13.12.04','Talamau'),
('13.12.04.2001','Kajai'),
('13.12.04.2002','Talu'),
('13.12.04.2003','Sinuruik'),
('13.12.04.2004','Simpang Timbo Abu Kajai'),
('13.12.04.2005','Kajai Selatan'),
('13.12.04.2006','Sungai Janiah Talu'),
('13.12.04.2007','Tabek Sirah Talu'),
('13.12.05','Kinali'),
('13.12.05.2001','Kinali'),
('13.12.05.2002','Katiagan'),
('13.12.05.2003','Ampek Koto'),
('13.12.05.2004','Ampek Koto Barat'),
('13.12.05.2005','Bancah Kariang'),
('13.12.05.2006','Mudiak Labuah'),
('13.12.05.2007','Tandikek'),
('13.12.05.2008','Langgam Sepakat'),
('13.12.05.2009','Langgam Saiyo'),
('13.12.05.2010','Anam Koto Selatan'),
('13.12.05.2011','Sigunanti'),
('13.12.05.2012','Koto Gadang Jaya'),
('13.12.05.2013','Anam Koto Utara'),
('13.12.05.2014','Bandua Balai'),
('13.12.05.2015','Bunuik'),
('13.12.05.2016','Padang Canduh'),
('13.12.05.2017','Limau Purut'),
('13.12.06','Gunung Tuleh'),
('13.12.06.2001','Muaro Kiawai'),
('13.12.06.2002','Rabi Jonggor'),
('13.12.06.2003','Seberang Kenaikan'),
('13.12.06.2004','Bahoras'),
('13.12.06.2005','Ranah Sungai Magelang'),
('13.12.06.2006','Muaro Kiawai Barat'),
('13.12.06.2007','Muaro Kiawai Hilir'),
('13.12.07','Ranah Batahan'),
('13.12.07.2001','Batahan'),
('13.12.07.2002','Desa Baru'),
('13.12.07.2003','Batahan Utara'),
('13.12.07.2004','Batahan Tengah'),
('13.12.07.2005','Batahan Barat'),
('13.12.07.2006','Batahan Selatan'),
('13.12.07.2007','Desa Baru Barat'),
('13.12.08','Koto Balingka'),
('13.12.08.2001','Parit'),
('13.12.08.2002','Koto Tangah'),
('13.12.08.2003','Koto Tuo'),
('13.12.08.2004','Koto Nan Duo'),
('13.12.08.2005','Pematang Panjang'),
('13.12.08.2006','Ranah Koto Tinggi'),
('13.12.09','Sungai Aur'),
('13.12.09.2001','Sungai Aua'),
('13.12.09.2002','Salingka Muaro'),
('13.12.09.2003','Ranah Malintang'),
('13.12.09.2004','Ranah Air Haji'),
('13.12.09.2005','Kasikputih Sungaitanang'),
('13.12.09.2006','Aua Serumpun'),
('13.12.09.2007','Sikilang Sungai Aur Selatan'),
('13.12.10','Luhak Nan Duo'),
('13.12.10.2001','Koto Baru'),
('13.12.10.2002','Kapa'),
('13.12.10.2003','Giri Maju'),
('13.12.10.2004','Ophir'),
('13.12.10.2005','Mahakarya'),
('13.12.10.2006','Sariak'),
('13.12.10.2007','Sungai Talang'),
('13.12.10.2008','Jambak Selatan'),
('13.12.10.2009','Pujorahayu'),
('13.12.11','Sasak Ranah Pasisie'),
('13.12.11.2001','Sasak'),
('13.12.11.2002','Padang Harapan'),
('13.12.11.2003','Ranah Pasisie'),
('13.12.11.2004','Maligi'),
('13.71','Kota Padang'),
('13.71.01','Padang Selatan'),
('13.71.01.1001','Belakang Pondok'),
('13.71.01.1002','Alang Laweh'),
('13.71.01.1003','Ranah Parak Rumbio'),
('13.71.01.1004','Pasa Gadang'),
('13.71.01.1005','Batang Arau'),
('13.71.01.1006','Seberang Palinggam'),
('13.71.01.1007','Seberang Padang'),
('13.71.01.1008','Mata Air'),
('13.71.01.1009','Rawang'),
('13.71.01.1010','Teluk Bayur'),
('13.71.01.1011','Air Manis'),
('13.71.01.1012','Bukit Gado-gado'),
('13.71.02','Padang Timur'),
('13.71.02.1001','Sawahan'),
('13.71.02.1002','Jati Baru'),
('13.71.02.1003','Jati'),
('13.71.02.1004','Sawahan Timur'),
('13.71.02.1005','Simpang Haru'),
('13.71.02.1006','Kubu Marapalam'),
('13.71.02.1007','Andalas'),
('13.71.02.1008','Kubu Dalam Parak Karakah'),
('13.71.02.1009','Parak Gadang Timur'),
('13.71.02.1010','Ganting Parak Gadang'),
('13.71.03','Padang Barat'),
('13.71.03.1001','Flamboyan Baru'),
('13.71.03.1002','Rimbo Kaluang'),
('13.71.03.1003','Ujung Gurun'),
('13.71.03.1004','Purus'),
('13.71.03.1005','Padang Pasir'),
('13.71.03.1006','Olo'),
('13.71.03.1007','Kampung Jawa'),
('13.71.03.1008','Belakang Tangsi'),
('13.71.03.1009','Kampung Pondok'),
('13.71.03.1010','Berok Nipah'),
('13.71.04','Padang Utara'),
('13.71.04.1001','Air Tawar Timur'),
('13.71.04.1002','Air Tawar Barat'),
('13.71.04.1003','Ulak Karang Utara'),
('13.71.04.1004','Ulak Karang Selatan'),
('13.71.04.1005','Lolong Belanti'),
('13.71.04.1006','Alai Parak Kopi'),
('13.71.04.1007','Gunung Pangilun'),
('13.71.05','Bungus Teluk Kabung'),
('13.71.05.1001','Bungus Timur'),
('13.71.05.1002','Bungus Barat'),
('13.71.05.1003','Bungus Selatan'),
('13.71.05.1004','Teluk Kabung Utara'),
('13.71.05.1005','Teluk Kabung Tengah'),
('13.71.05.1006','Teluk Kabung Selatan'),
('13.71.06','Lubuk Begalung'),
('13.71.06.1001','Cangkeh Nan XX'),
('13.71.06.1002','Kampung Baru Nan XX'),
('13.71.06.1003','Tanah Sirah Piai Nan XX'),
('13.71.06.1004','Tanjung Saba Pitameh Nan XX'),
('13.71.06.1005','Lubuk Begalung Nan XX'),
('13.71.06.1006','Gurun Laweh Nan XX'),
('13.71.06.1007','Tanjung Aua Nan XX'),
('13.71.06.1008','Koto Baru Nan XX'),
('13.71.06.1009','Banuaran Nan XX'),
('13.71.06.1010','Parak Laweh Pulau Aia Nan XX'),
('13.71.06.1011','Batung Taba Nan XX'),
('13.71.06.1012','Pegambiran Ampalu Nan XX'),
('13.71.06.1013','Pampangan Nan XX'),
('13.71.06.1014','Gates Nan XX'),
('13.71.06.1015','Kampung Jua Nan XX'),
('13.71.07','Lubuk Kilangan'),
('13.71.07.1001','Indarung'),
('13.71.07.1002','Padang Besi'),
('13.71.07.1003','Batu Gadang'),
('13.71.07.1004','Banda Buek'),
('13.71.07.1005','Koto Lalang'),
('13.71.07.1006','Baringin'),
('13.71.07.1007','Tarantang'),
('13.71.08','Pauh'),
('13.71.08.1001','Limau Manis'),
('13.71.08.1002','Koto Lua'),
('13.71.08.1003','Limau Manis Selatan'),
('13.71.08.1004','Piai Tangah'),
('13.71.08.1005','Cupak Tangah'),
('13.71.08.1006','Pisang'),
('13.71.08.1007','Binuang Kampung Dalam'),
('13.71.08.1008','Kapalo Koto'),
('13.71.08.1009','Lambung Bukit'),
('13.71.09','Kuranji'),
('13.71.09.1001','Pasar Ambacang'),
('13.71.09.1002','Anduring'),
('13.71.09.1003','Lubuk Lintah'),
('13.71.09.1004','Ampang'),
('13.71.09.1005','Kalumbuk'),
('13.71.09.1006','Korong Gadang'),
('13.71.09.1007','Kuranji'),
('13.71.09.1008','Gunung Sarik'),
('13.71.09.1009','Sungai Sapih'),
('13.71.10','Nanggalo'),
('13.71.10.1001','Surau Gadang'),
('13.71.10.1002','Kampung Olo'),
('13.71.10.1003','Kurao Pagang'),
('13.71.10.1004','Gurun Laweh'),
('13.71.10.1005','Tabiang Banda Gadang'),
('13.71.10.1006','Kampung Lapai'),
('13.71.11','Koto Tangah'),
('13.71.11.1001','Balai Gadang'),
('13.71.11.1002','Lubuk Minturun'),
('13.71.11.1003','Aie Pacah'),
('13.71.11.1004','Dadok Tunggul Hitam'),
('13.71.11.1005','Koto Panjang Ikua Koto'),
('13.71.11.1006','Koto Pulai'),
('13.71.11.1007','Batipuh Panjang'),
('13.71.11.1008','Padang Sarai'),
('13.71.11.1009','Lubuk Buaya'),
('13.71.11.1010','Batang Kabung Ganting'),
('13.71.11.1011','Bungo Pasang'),
('13.71.11.1012','Parupuk Tabing'),
('13.71.11.1013','Pasie Nan Tigo'),
('13.72','Kota Solok'),
('13.72.01','Lubuk Sikarah'),
('13.72.01.1001','Tanah Garam'),
('13.72.01.1002','VI Suku'),
('13.72.01.1003','Sinapa Piliang'),
('13.72.01.1004','IX Korong'),
('13.72.01.1005','Kampai Tabu Karambia'),
('13.72.01.1006','Aro IV Korong'),
('13.72.01.1007','Simpang Rumbio'),
('13.72.02','Tanjung Harapan'),
('13.72.02.1001','Koto Panjang'),
('13.72.02.1002','Pasar Pandan Air Mati'),
('13.72.02.1003','Tanjung Paku'),
('13.72.02.1004','Nan Balimo'),
('13.72.02.1005','Kampung Jawa'),
('13.72.02.1006','Laing'),
('13.73','Kota Sawahlunto'),
('13.73.01','Lembah Segar'),
('13.73.01.1001','Aur Mulio'),
('13.73.01.1002','Kubang Sirakuk Utara'),
('13.73.01.1003','Kubang S. Selatan'),
('13.73.01.1004','Pasar'),
('13.73.01.1005','Tanah Lapang'),
('13.73.01.1006','Aia Dingin'),
('13.73.01.2007','Lunto Timur'),
('13.73.01.2008','Lunto Barat'),
('13.73.01.2009','Kubang Tangah'),
('13.73.01.2010','Kubang Utara Sikabu'),
('13.73.01.2011','Pasa Kubang'),
('13.73.02','Barangin'),
('13.73.02.1001','Saringan'),
('13.73.02.1002','Lubang Panjang'),
('13.73.02.1003','Durian I'),
('13.73.02.1004','Durian II'),
('13.73.02.2005','Santur'),
('13.73.02.2006','Kolok Mudiak'),
('13.73.02.2007','Kolok Nan Tuo'),
('13.73.02.2008','Talago Gunung'),
('13.73.02.2009','Lumindai'),
('13.73.02.2010','Balai Batu Sandaran'),
('13.73.03','Silungkang'),
('13.73.03.2001','Silungkang Duo'),
('13.73.03.2002','Silungkang Oso'),
('13.73.03.2003','Silungkang Tigo'),
('13.73.03.2004','Muaro Kalaban'),
('13.73.03.2005','Taratak Boncah'),
('13.73.04','Talawi'),
('13.73.04.2001','Talawi Hilie'),
('13.73.04.2002','Talawi Mudiak'),
('13.73.04.2003','Bukit Gadang'),
('13.73.04.2004','Batu Tanjung'),
('13.73.04.2005','Kumbayau'),
('13.73.04.2006','Tumpuk Tangah'),
('13.73.04.2007','Datar Mansiang'),
('13.73.04.2008','Sijantang Koto'),
('13.73.04.2009','Salak'),
('13.73.04.2010','Sikalang'),
('13.73.04.2011','Rantih'),
('13.74','Kota Padang Panjang'),
('13.74.01','Padang Panjang Timur'),
('13.74.01.1001','Ganting'),
('13.74.01.1002','Sigando'),
('13.74.01.1003','Ekor Lubuk'),
('13.74.01.1004','Ngalau'),
('13.74.01.1005','Guguk Malintang'),
('13.74.01.1006','Koto Panjang'),
('13.74.01.1007','Koto Katik'),
('13.74.01.1008','Tanah Pak Lambik'),
('13.74.02','Padang Panjang Barat'),
('13.74.02.1001','Bukit Surungan'),
('13.74.02.1002','Pasar Usang'),
('13.74.02.1003','Kampung Manggis'),
('13.74.02.1004','Silaing Bawah'),
('13.74.02.1005','Silaing Atas'),
('13.74.02.1006','Pasar Baru'),
('13.74.02.1007','Tanah Hitam'),
('13.74.02.1008','Balai-balai'),
('13.75','Kota Bukittinggi'),
('13.75.01','Guguak Panjang'),
('13.75.01.1001','Tarok Dipo'),
('13.75.01.1002','Bukit Cangang Kayu Ramang'),
('13.75.01.1003','Pakan Kurai'),
('13.75.01.1004','Aur Tajungkang Tangah Sawah'),
('13.75.01.1005','Benteng Pasar Atas'),
('13.75.01.1006','Kayu Kubu'),
('13.75.01.1007','Bukik Apik Puhun'),
('13.75.02','Mandiangin Koto Selayan'),
('13.75.02.1001','Campago Guguk Bulek'),
('13.75.02.1002','Campago Ipuh'),
('13.75.02.1003','Puhun Tembok'),
('13.75.02.1004','Kubu Gulai Bancah'),
('13.75.02.1005','Puhun Pintu Kabun'),
('13.75.02.1006','Pulai Anak Air'),
('13.75.02.1007','Koto Selayan'),
('13.75.02.1008','Garegeh'),
('13.75.02.1009','Manggis Ganting'),
('13.75.03','Aur Birugo Tigo Baleh'),
('13.75.03.1001','Aur Kuning'),
('13.75.03.1002','Birugo'),
('13.75.03.1003','Belakang Balok'),
('13.75.03.1004','Sapiran'),
('13.75.03.1005','Kubu Tanjung'),
('13.75.03.1006','Pakan Labuah'),
('13.75.03.1007','Parit Antang'),
('13.75.03.1008','Ladang Cakiah'),
('13.76','Kota Payakumbuh'),
('13.76.01','Payakumbuh Barat'),
('13.76.01.1002','Pakan Sinayan'),
('13.76.01.1003','Kubu Gadang'),
('13.76.01.1004','Bulakan Balai Kandi'),
('13.76.01.1005','Payolansek'),
('13.76.01.1007','Talang'),
('13.76.01.1009','Padang Tinggi Piliang'),
('13.76.01.1011','Koto Tangah'),
('13.76.01.1013','Subarang Batuang'),
('13.76.01.1016','Parik Rantang'),
('13.76.01.1017','Parak Batuang'),
('13.76.01.1018','Nunang Daya Bangun'),
('13.76.01.1020','Labuah Basilang'),
('13.76.01.1021','Ibuah'),
('13.76.01.1022','Tanjuang Pauh'),
('13.76.01.1032','Tanjuanggodang Sungaipinago'),
('13.76.01.1033','Padangtongah Balainanduo'),
('13.76.01.1034','Padangdata Tanahmati'),
('13.76.02','Payakumbuh Utara'),
('13.76.02.1002','Napar'),
('13.76.02.1032','Ompang Tanah Sirah'),
('13.76.02.1033','Taratak Padang Kampuang'),
('13.76.02.1034','Tigo Koto Dibaruah'),
('13.76.02.1035','Tigo Koto Diate'),
('13.76.02.1036','Ikua Koto Dibalai'),
('13.76.02.1037','Balai Tongah Koto'),
('13.76.02.1038','Kapalo Koto Dibalai'),
('13.76.02.1039','Kotokociak Kubu Tapakrajo'),
('13.76.03','Payakumbuh Timur'),
('13.76.03.1001','Balai Jaring'),
('13.76.03.1002','Padang Alai Bodi'),
('13.76.03.1003','Padang Tangah Payobadar'),
('13.76.03.1005','Sicincin'),
('13.76.03.1007','Padang Tiakar'),
('13.76.03.1009','Payobasung'),
('13.76.03.1010','Koto Panjang'),
('13.76.03.1011','Koto Baru'),
('13.76.03.1015','Tiakar'),
('13.76.04','Lamposi Tigo Nagori'),
('13.76.04.1001','Sungai Durian'),
('13.76.04.1002','Parit Muko Aie'),
('13.76.04.1003','Parambahan'),
('13.76.04.1004','Padang Sikabu'),
('13.76.04.1005','Koto Panjang Padang'),
('13.76.04.1006','Koto Panjang Dalam'),
('13.76.05','Payakumbuh Selatan'),
('13.76.05.1001','Padang Karambia'),
('13.76.05.1002','Kototuo Limokampuang'),
('13.76.05.1003','Limbukan'),
('13.76.05.1005','Balai Panjang'),
('13.76.05.1006','Kapalo Koto Ampangan'),
('13.76.05.1010','Sawahpadang Aua Kuniang'),
('13.77','Kota Pariaman'),
('13.77.01','Pariaman Tengah'),
('13.77.01.1001','Karan Aur'),
('13.77.01.1002','Kampung Perak'),
('13.77.01.1003','Lohong'),
('13.77.01.1004','Pasir'),
('13.77.01.1005','Kampung Pondok'),
('13.77.01.1006','Pondok II'),
('13.77.01.1007','Kampung Jawa I'),
('13.77.01.1008','Kampung Jawa II'),
('13.77.01.1009','Alai Gelombang'),
('13.77.01.1010','Jawi Jawi I'),
('13.77.01.1011','Jawi Jawi II'),
('13.77.01.1012','Jalan Baru'),
('13.77.01.1013','Taratak'),
('13.77.01.1014','Jalan Kereta Api'),
('13.77.01.1015','Ujung Batung'),
('13.77.01.1016','Jati Hilir'),
('13.77.01.2017','Pauh Barat'),
('13.77.01.2018','Pauh Timur'),
('13.77.01.2019','Rawang'),
('13.77.01.2020','Kampung Baru'),
('13.77.01.2021','Cimparuh'),
('13.77.01.2025','Jati Mudik'),
('13.77.02','Pariaman Utara'),
('13.77.02.2005','Ampalu'),
('13.77.02.2006','Apar'),
('13.77.02.2007','Tanjung Sabar'),
('13.77.02.2008','Cubadak Air Selatan'),
('13.77.02.2009','Sikapak Barat'),
('13.77.02.2010','Sikapak Timur'),
('13.77.02.2011','Manggung'),
('13.77.02.2012','Cubadak Air Utara'),
('13.77.02.2013','Tungkal Selatan'),
('13.77.02.2014','Naras Hilir'),
('13.77.02.2015','Naras I'),
('13.77.02.2016','Balai Naras'),
('13.77.02.2017','Padang Birik Birik'),
('13.77.02.2018','Sintuk'),
('13.77.02.2019','Sungai Rambai'),
('13.77.02.2020','Tungkal Utara'),
('13.77.02.2021','Cubadak Air'),
('13.77.03','Pariaman Selatan'),
('13.77.03.2006','Pasir Sunur'),
('13.77.03.2007','Balai Kurai Taji'),
('13.77.03.2008','Pauh Kurai Taji'),
('13.77.03.2009','Simpang'),
('13.77.03.2010','Toboh Palabah'),
('13.77.03.2011','Marabau'),
('13.77.03.2012','Batang Tajongkek'),
('13.77.03.2013','Sikabu'),
('13.77.03.2014','Sungai Kasai'),
('13.77.03.2015','Palak Aneh'),
('13.77.03.2016','Kampung Apar'),
('13.77.03.2017','Marunggi'),
('13.77.03.2018','Taluk'),
('13.77.03.2019','Padang Cakur'),
('13.77.03.2020','Punggung Lading'),
('13.77.03.2021','Rambai'),
('13.77.04','Pariaman Timur'),
('13.77.04.2001','Talago Sarik'),
('13.77.04.2002','Pakasai'),
('13.77.04.2003','Kampung Baru Padusunan'),
('13.77.04.2004','Kampung Gadang'),
('13.77.04.2005','Koto Marapak'),
('13.77.04.2006','Batang Kabung'),
('13.77.04.2007','Bato'),
('13.77.04.2008','Air Santok'),
('13.77.04.2009','Cubadak Mentawai'),
('13.77.04.2010','Sungai Sirah'),
('13.77.04.2011','Sungai Pasak'),
('13.77.04.2012','Bungo Tanjung'),
('13.77.04.2013','Kampung Tangah'),
('13.77.04.2014','Kampung Kandang'),
('13.77.04.2015','Kaluat'),
('13.77.04.2016','Kajai');

-- Provinsi RIAU
INSERT INTO wilayah (kode, nama)
VALUES
('14','Riau'),
('14.01','Kabupaten Kampar'),
('14.01.01','Bangkinang Kota'),
('14.01.01.1011','Bangkinang'),
('14.01.01.1013','Langgini'),
('14.01.01.2009','Kumantan'),
('14.01.01.2010','Ridan Permai'),
('14.01.02','Kampar'),
('14.01.02.1027','Air Tiris'),
('14.01.02.2001','Batu Belah'),
('14.01.02.2003','Tanjung Berulak'),
('14.01.02.2006','Ranah'),
('14.01.02.2007','Penyasawan'),
('14.01.02.2008','Rumbio'),
('14.01.02.2013','Padang Mutung'),
('14.01.02.2023','Pulau Jambu'),
('14.01.02.2024','Tanjung Rambutan'),
('14.01.02.2025','Simpang Kubu'),
('14.01.02.2028','Limau Manis'),
('14.01.02.2030','Naumbai'),
('14.01.02.2031','Pulau Tinggi'),
('14.01.02.2032','Ranah Baru'),
('14.01.02.2033','Bukit Ranah'),
('14.01.02.2034','Pulau Sarak'),
('14.01.02.2035','Koto Tibun'),
('14.01.02.2036','Ranah Singkuang'),
('14.01.03','Tambang'),
('14.01.03.2001','Tambang'),
('14.01.03.2002','Kuapan'),
('14.01.03.2003','Gobah'),
('14.01.03.2004','Teluk Kenidai'),
('14.01.03.2005','Aursati'),
('14.01.03.2006','Padang Luas'),
('14.01.03.2007','Terantang'),
('14.01.03.2008','Kualu'),
('14.01.03.2009','Rimbo Panjang'),
('14.01.03.2010','Parit Baru'),
('14.01.03.2011','Kemang Indah'),
('14.01.03.2012','Kualu Nenas'),
('14.01.03.2013','Tarai Bangun'),
('14.01.03.2014','Sungai Pinang'),
('14.01.03.2015','Balam Jaya'),
('14.01.03.2016','Pulau Permai'),
('14.01.03.2017','Palung Raya'),
('14.01.04','XIII Koto Kampar'),
('14.01.04.1018','Batu Bersurat'),
('14.01.04.2004','Gunung Bungsu'),
('14.01.04.2005','Koto Tuo'),
('14.01.04.2006','Balung'),
('14.01.04.2007','Muara Takus'),
('14.01.04.2010','Pulau Gadang'),
('14.01.04.2011','Tanjung Alai'),
('14.01.04.2012','Ranah Sungkai'),
('14.01.04.2013','Lubuk Agung'),
('14.01.04.2014','Koto Mesjid'),
('14.01.04.2016','Pongkai Istiqomah'),
('14.01.04.2017','Binamang'),
('14.01.04.2019','Koto Tuo Barat'),
('14.01.05','Kuok'),
('14.01.05.2001','Kuok'),
('14.01.05.2005','Merangin'),
('14.01.05.2006','Empat Balai'),
('14.01.05.2007','Pulau Jambu'),
('14.01.05.2008','Silam'),
('14.01.05.2010','Bukit Melintang'),
('14.01.05.2011','Pulau Terap'),
('14.01.05.2012','Lereng'),
('14.01.05.2013','Batu Langka Kecil'),
('14.01.06','Siak Hulu'),
('14.01.06.2001','Pangkalan Baru'),
('14.01.06.2002','Desa Baru'),
('14.01.06.2003','Teratak Buluh'),
('14.01.06.2005','Lubuk Siam'),
('14.01.06.2006','Buluh Cina'),
('14.01.06.2007','Buluh Nipis'),
('14.01.06.2011','Tanah Merah'),
('14.01.06.2012','Pandau Jaya'),
('14.01.06.2013','Tanjung Balam'),
('14.01.06.2014','Kepau Jaya'),
('14.01.06.2015','Pangkalan Serik'),
('14.01.06.2016','Kubang Jaya'),
('14.01.07','Kampar Kiri'),
('14.01.07.1027','Lipat Kain'),
('14.01.07.2003','Kuntu'),
('14.01.07.2004','Padang Sawah'),
('14.01.07.2005','Domo'),
('14.01.07.2006','IV Koto Setingkai'),
('14.01.07.2008','Teluk Paman'),
('14.01.07.2013','Sungai Geringging'),
('14.01.07.2016','Sungai Paku'),
('14.01.07.2019','Muara Selayah'),
('14.01.07.2020','Sungai Rambai'),
('14.01.07.2021','Tanjung Harapan'),
('14.01.07.2023','Sungai Raja'),
('14.01.07.2026','Sungai Sarik'),
('14.01.07.2028','Lipat Kain Utara'),
('14.01.07.2029','Lipat Kain Selatan'),
('14.01.07.2030','Kuntu Darussalam'),
('14.01.07.2031','Tanjung Mas'),
('14.01.07.2032','Sungai Harapan'),
('14.01.07.2033','Sungai Liti'),
('14.01.07.2034','Teluk Paman Timur'),
('14.01.08','Kampar Kiri Hilir'),
('14.01.08.1001','Sungai Pagar'),
('14.01.08.2002','Mentulik'),
('14.01.08.2003','Sungai Simpang Dua'),
('14.01.08.2004','Sungai Bungo'),
('14.01.08.2005','Rantau Kasih'),
('14.01.08.2006','Sungai Petai'),
('14.01.08.2007','Gading Permai'),
('14.01.08.2008','Bangun Sari'),
('14.01.09','Kampar Kiri Hulu'),
('14.01.09.2001','Gema'),
('14.01.09.2002','Tanjung Belit'),
('14.01.09.2003','Tanjung Belit Selatan'),
('14.01.09.2004','Koto Lama'),
('14.01.09.2005','Batu Sanggan'),
('14.01.09.2006','Aur Kuning'),
('14.01.09.2007','Ludai'),
('14.01.09.2008','Tanjung Karang'),
('14.01.09.2009','Batu Sasak'),
('14.01.09.2010','Pangkalan Kapas'),
('14.01.09.2011','Kebun Tinggi'),
('14.01.09.2012','Tanjung Beringin'),
('14.01.09.2013','Gajah Bertalut'),
('14.01.09.2014','Danau Sontul'),
('14.01.09.2015','Pangkalan Serai'),
('14.01.09.2016','Dua Sepakat'),
('14.01.09.2017','Terusan'),
('14.01.09.2018','Deras Tajak'),
('14.01.09.2019','Sungai Santi'),
('14.01.09.2020','Subayang Jaya'),
('14.01.09.2021','Tanjung Permai'),
('14.01.09.2022','Bukit Betung'),
('14.01.09.2023','Muaro Bio'),
('14.01.09.2024','Lubuk Bigau'),
('14.01.10','Tapung'),
('14.01.10.2001','Petapahan'),
('14.01.10.2002','Pantai Cermin'),
('14.01.10.2003','Petapahan Jaya'),
('14.01.10.2004','Mukti Sari'),
('14.01.10.2005','Sungai Putih'),
('14.01.10.2006','Indra Sakti'),
('14.01.10.2007','Gading Sari'),
('14.01.10.2008','Sumber Makmur'),
('14.01.10.2009','Pancuran Gading'),
('14.01.10.2010','Sari Galuh'),
('14.01.10.2011','Tri Manunggal'),
('14.01.10.2012','Air Terbit'),
('14.01.10.2013','Tanjung Sawit'),
('14.01.10.2014','Pagaruyung'),
('14.01.10.2015','Sibuak'),
('14.01.10.2016','Pelambaian'),
('14.01.10.2017','Kenantan'),
('14.01.10.2018','Indrapuri'),
('14.01.10.2019','Sungai Lambu Makmur'),
('14.01.10.2020','Muara Mahat Baru'),
('14.01.10.2021','Karya Indah'),
('14.01.10.2022','Kijang Rejo'),
('14.01.10.2023','Sungai Agung'),
('14.01.10.2024','Bencah Kelubi'),
('14.01.10.2025','Batu Gajah'),
('14.01.11','Tapung Hilir'),
('14.01.11.2001','Koto Garo'),
('14.01.11.2002','Sekijang'),
('14.01.11.2003','Beringin Lestari'),
('14.01.11.2004','Kota Bangun'),
('14.01.11.2005','Cinta Damai'),
('14.01.11.2006','Suka Maju'),
('14.01.11.2007','Kota Baru'),
('14.01.11.2008','Tebing Lestari'),
('14.01.11.2009','Tanah Tinggi'),
('14.01.11.2010','Koto Aman'),
('14.01.11.2011','Tapung Lestari'),
('14.01.11.2012','Tapung Makmur'),
('14.01.11.2013','Tandan Sari'),
('14.01.11.2014','Gerbang Sari'),
('14.01.11.2015','Kijang Jaya'),
('14.01.11.2016','Kijang Makmur'),
('14.01.12','Tapung Hulu'),
('14.01.12.2001','Senama Nenek'),
('14.01.12.2002','Kasikan'),
('14.01.12.2003','Bukit Kemuning'),
('14.01.12.2004','Danau Lancang'),
('14.01.12.2005','Muara Intan'),
('14.01.12.2006','Intan Jaya'),
('14.01.12.2007','Tanah Datar'),
('14.01.12.2008','Rimba Jaya'),
('14.01.12.2009','Rimba Makmur'),
('14.01.12.2010','Rimba Beringin'),
('14.01.12.2011','Sukaramai'),
('14.01.12.2012','Sumber Sari'),
('14.01.12.2013','Kusau Makmur'),
('14.01.12.2014','Talang Danto'),
('14.01.13','Salo'),
('14.01.13.2001','Salo'),
('14.01.13.2002','Siabu'),
('14.01.13.2003','Salo Timur'),
('14.01.13.2004','Sipungguk'),
('14.01.13.2005','Ganting Damai'),
('14.01.13.2006','Ganting'),
('14.01.14','Rumbio Jaya'),
('14.01.14.2001','Pulau Payung'),
('14.01.14.2002','Teratak'),
('14.01.14.2003','Alam Panjang'),
('14.01.14.2004','Bukit Kratai'),
('14.01.14.2005','Batang Batindih'),
('14.01.14.2006','Tambusai'),
('14.01.14.2007','Simpang Petai'),
('14.01.15','Bangkinang'),
('14.01.15.1007','Pulau'),
('14.01.15.1008','Pasir Sialang'),
('14.01.15.2001','Pulau Lawas'),
('14.01.15.2002','Muara Uwai'),
('14.01.15.2003','Laboy Jaya'),
('14.01.15.2004','Bukit Payung'),
('14.01.15.2005','Suka Mulya'),
('14.01.15.2006','Bukit Sembilan'),
('14.01.15.2009','Binuang'),
('14.01.16','Perhentian Raja'),
('14.01.16.2001','Kampung Pinang'),
('14.01.16.2002','Pantai Raja'),
('14.01.16.2003','Hangtuah'),
('14.01.16.2004','Sialang Kubang'),
('14.01.16.2005','Lubuk Sakat'),
('14.01.17','Kampa'),
('14.01.17.2001','Pulau Birandang'),
('14.01.17.2002','Pulau Rambai'),
('14.01.17.2003','Kampar'),
('14.01.17.2004','Koto Perambahan'),
('14.01.17.2005','Sungai Putih'),
('14.01.17.2006','Deli Makmur'),
('14.01.17.2007','Sungai Tarap'),
('14.01.17.2008','Tanjung Bungo'),
('14.01.17.2009','Sawah Baru'),
('14.01.18','Kampar Utara'),
('14.01.18.2001','Muara Jalai'),
('14.01.18.2002','Sawah'),
('14.01.18.2003','Kampung Panjang'),
('14.01.18.2004','Kayu Aro'),
('14.01.18.2005','Sungai Tonang'),
('14.01.18.2006','Sungai Jalau'),
('14.01.18.2007','Sendayan'),
('14.01.18.2008','Naga Beralih'),
('14.01.19','Kampar Kiri Tengah'),
('14.01.19.2001','Simalinyang'),
('14.01.19.2002','Bina Baru'),
('14.01.19.2003','Hidup Baru'),
('14.01.19.2004','Karya Bakti'),
('14.01.19.2005','Lubuk Sakai'),
('14.01.19.2006','Penghidupan'),
('14.01.19.2007','Mayang Pongkai'),
('14.01.19.2008','Koto Damai'),
('14.01.19.2009','Utama Karya'),
('14.01.19.2010','Bukit Sakai'),
('14.01.19.2011','Mekar Jaya'),
('14.01.20','Gunung Sahilan'),
('14.01.20.2001','Kebun Durian'),
('14.01.20.2002','Gunung Sahilan'),
('14.01.20.2003','Gunung Sari'),
('14.01.20.2004','Suka Makmur'),
('14.01.20.2005','Subarak'),
('14.01.20.2006','Sungai Lipai'),
('14.01.20.2007','Sahilan Darussalam'),
('14.01.20.2008','Gunung Mulya'),
('14.01.20.2009','Makmur Sejahtera'),
('14.01.21','Koto Kampar Hulu'),
('14.01.21.2001','Siberuang'),
('14.01.21.2002','Bandur Picak'),
('14.01.21.2003','Gunung Malelo'),
('14.01.21.2004','Tabing'),
('14.01.21.2005','Pongkai'),
('14.01.21.2006','Tanjung'),
('14.02','Kabupaten Indragiri Hulu'),
('14.02.01','Rengat'),
('14.02.01.1004','Kampung Dagang'),
('14.02.01.1006','Pasar Kota'),
('14.02.01.1007','Kampung Besar Kota'),
('14.02.01.1008','Sekip Hulu'),
('14.02.01.1011','Kampung Besar Seberang'),
('14.02.01.1018','Sekip Hilir'),
('14.02.01.2001','Sungai Guntung Tengah'),
('14.02.01.2002','Sungai Guntung Hilir'),
('14.02.01.2003','Kuantan Babu'),
('14.02.01.2005','Kampung Pulau'),
('14.02.01.2009','Sungai Beringin'),
('14.02.01.2010','Pasir Kemilu'),
('14.02.01.2012','Rantau Mapesai'),
('14.02.01.2013','Pulau Gajah'),
('14.02.01.2014','Sungai Raya'),
('14.02.01.2023','Rawa Bangun'),
('14.02.02','Rengat Barat'),
('14.02.02.1009','Pematang Reba'),
('14.02.02.2001','Barangan'),
('14.02.02.2002','Alang Kepayang'),
('14.02.02.2003','Kota Lama'),
('14.02.02.2004','Redang'),
('14.02.02.2005','Pekan Heran'),
('14.02.02.2006','Rantau Bakung'),
('14.02.02.2007','Talang Jerinjing'),
('14.02.02.2008','Sialang Dua Dahan'),
('14.02.02.2010','Sungai Dawu'),
('14.02.02.2011','Bukit Petaling'),
('14.02.02.2012','Pematang Jaya'),
('14.02.02.2013','Danau Baru'),
('14.02.02.2014','Tanah Datar'),
('14.02.02.2015','Tani Makmur'),
('14.02.02.2016','Sungai Baung'),
('14.02.02.2017','Danau Tiga'),
('14.02.02.2018','Air Jernih'),
('14.02.03','Kelayang'),
('14.02.03.1019','Simpang Kelayang'),
('14.02.03.2007','Pulau Sengkilo'),
('14.02.03.2008','Kota Medan'),
('14.02.03.2009','Simpang Kota Medan'),
('14.02.03.2010','Polak Pisang'),
('14.02.03.2018','Pelangko'),
('14.02.03.2020','Teluk Sejuah'),
('14.02.03.2021','Bongkal Malang'),
('14.02.03.2022','Dusun Tua'),
('14.02.03.2024','Sungai Banyak Ikan'),
('14.02.03.2025','Tanjung Beludu'),
('14.02.03.2026','Sungai Pasir Putih'),
('14.02.03.2027','Sungai Golang'),
('14.02.03.2028','Pasir Beringin'),
('14.02.03.2029','Sungai Kuning Benio'),
('14.02.03.2030','Bukit Selanjut'),
('14.02.03.2031','Dusun Tua Pelang'),
('14.02.04','Pasir Penyu'),
('14.02.04.1007','Air Molek I'),
('14.02.04.1020','Kembang Harum'),
('14.02.04.1031','Tanjung Gading'),
('14.02.04.1032','Sekar Mawar'),
('14.02.04.1033','Tanah Merah'),
('14.02.04.2006','Petalongan'),
('14.02.04.2008','Air Molek II'),
('14.02.04.2009','Pasir Keranji'),
('14.02.04.2016','Jati Rejo'),
('14.02.04.2017','Batu Gajah'),
('14.02.04.2018','Candi Rejo'),
('14.02.04.2019','Lembah Dusun Gading'),
('14.02.04.2030','Serumpun Jaya'),
('14.02.05','Peranap'),
('14.02.05.1005','Peranap'),
('14.02.05.1008','Batu Rijal Hilir'),
('14.02.05.2003','Semelinang Tebing'),
('14.02.05.2004','Gumanti'),
('14.02.05.2007','Batu Rijal Hulu'),
('14.02.05.2009','Semelinang Darat'),
('14.02.05.2010','Pauh Ranap'),
('14.02.05.2012','Serai Wangi'),
('14.02.05.2013','Pandan Wangi'),
('14.02.05.2017','Katipo Pura'),
('14.02.05.2019','Batu Rijal Barat'),
('14.02.05.2020','Setako Raya'),
('14.02.06','Seberida'),
('14.02.06.1001','Pangkalan Kasai'),
('14.02.06.2002','Kelesa'),
('14.02.06.2003','Beligan'),
('14.02.06.2004','Seresam'),
('14.02.06.2005','Paya Rumbai'),
('14.02.06.2006','Bukit Meranti'),
('14.02.06.2007','Buluh Rampai'),
('14.02.06.2008','Titian Resak'),
('14.02.06.2009','Petala Bumi'),
('14.02.06.2010','Sibabat'),
('14.02.06.2011','Bandar Padang'),
('14.02.07','Batang Cenaku'),
('14.02.07.2002','Anak Talang'),
('14.02.07.2004','Bukit Lingkar'),
('14.02.07.2005','Bukit Lipai'),
('14.02.07.2006','Kuala Gading'),
('14.02.07.2007','Kuala Kilan'),
('14.02.07.2008','Kerubung Jaya'),
('14.02.07.2009','Pejangki'),
('14.02.07.2010','Pematang Manggis'),
('14.02.07.2011','Sipang'),
('14.02.07.2012','Talang Bersemi'),
('14.02.07.2013','Talang Mulya'),
('14.02.07.2014','Punti Anai'),
('14.02.07.2015','Petaling Jaya'),
('14.02.07.2017','Cenaku Kecil'),
('14.02.07.2018','Alim'),
('14.02.07.2019','Aur Cina'),
('14.02.07.2020','Lahai Kemuning'),
('14.02.07.2021','Kepayang Sari'),
('14.02.07.2022','Batu Papan'),
('14.02.07.2023','Sanglap'),
('14.02.08','Batang Gansal'),
('14.02.08.2001','Siambul'),
('14.02.08.2002','Rantau Langsat'),
('14.02.08.2003','Sungai Akar'),
('14.02.08.2004','Usul'),
('14.02.08.2005','Seberida'),
('14.02.08.2006','Talang Lakat'),
('14.02.08.2007','Belimbing'),
('14.02.08.2008','Ringin'),
('14.02.08.2010','Penyaguan'),
('14.02.08.2011','Danau Rambai'),
('14.02.09','Lirik'),
('14.02.09.2001','Japura'),
('14.02.09.2002','Sidomulyo'),
('14.02.09.2003','Pasir Ringgit'),
('14.02.09.2004','Gudang Batu'),
('14.02.09.2005','Sungai Sagu'),
('14.02.09.2006','Lirik Area'),
('14.02.09.2007','Rejosari'),
('14.02.09.2008','Lambang Sari V'),
('14.02.09.2009','Lambang Sari IV'),
('14.02.09.2010','Lambang Sari I, II, III'),
('14.02.09.2011','Wonosari'),
('14.02.09.2012','Seko Lubuk Tigo'),
('14.02.09.2013','Banjar Balam'),
('14.02.09.2014','Redang Seko'),
('14.02.09.2015','Sukajadi'),
('14.02.09.2016','Mekar Sari'),
('14.02.09.2017','Pasir Sialang Jaya'),
('14.02.10','Kuala Cenaku'),
('14.02.10.2001','Tambak'),
('14.02.10.2002','Kuala Cenaku'),
('14.02.10.2003','Pulau Gelang'),
('14.02.10.2004','Kuala Mulya'),
('14.02.10.2005','Tanjung Sari'),
('14.02.10.2006','Rawa Sekip'),
('14.02.10.2007','Rawa Asri'),
('14.02.10.2008','Suka Jadi'),
('14.02.10.2009','Teluk Sungkai'),
('14.02.10.2010','Pulau Jum''at'),
('14.02.11','Sungai Lala'),
('14.02.11.2001','Morong'),
('14.02.11.2002','Pasir Bongkal'),
('14.02.11.2003','Pasir Selabau'),
('14.02.11.2004','Pasir Batu Mandi'),
('14.02.11.2005','Pasir Kelampaian'),
('14.02.11.2006','Kuala Lala'),
('14.02.11.2007','Sungai Lala'),
('14.02.11.2008','Kelawat'),
('14.02.11.2009','Perkebunan Sungai Parit'),
('14.02.11.2010','Perkebunan Sungai Lala'),
('14.02.11.2011','Tanjung Danau'),
('14.02.11.2012','Sungai Air Putih'),
('14.02.12','Lubuk Batu Jaya'),
('14.02.12.2001','Rimpian'),
('14.02.12.2002','Pondok Gelugur'),
('14.02.12.2003','Lubuk Batu Tinggal'),
('14.02.12.2004','Sungai Beras Hilir'),
('14.02.12.2005','Kulim Jaya'),
('14.02.12.2006','Sungai Beras Beras'),
('14.02.12.2007','Tasik Juang'),
('14.02.12.2008','Pontian Mekar'),
('14.02.12.2009','Air Putih'),
('14.02.13','Rakit Kulim'),
('14.02.13.2001','Talang Tujuh Buah Tangga'),
('14.02.13.2002','Talang Durian Cacar'),
('14.02.13.2003','Talang Selantai'),
('14.02.13.2004','Talang Perigi'),
('14.02.13.2005','Kuantan Tenang'),
('14.02.13.2006','Kota Baru'),
('14.02.13.2007','Rimba Seminai'),
('14.02.13.2008','Kelayang'),
('14.02.13.2009','Talang Gedabu'),
('14.02.13.2010','Talang Sungai Limau'),
('14.02.13.2011','Talang Sungai Parit'),
('14.02.13.2012','Batu Sawar'),
('14.02.13.2013','Petonggan'),
('14.02.13.2014','Lubuk Sitarak'),
('14.02.13.2015','Bukit Indah'),
('14.02.13.2016','Sungai Ekok'),
('14.02.13.2017','Talang Suka Maju'),
('14.02.13.2018','Kampung Bunga'),
('14.02.13.2019','Talang Pring Jaya'),
('14.02.14','Batang Peranap'),
('14.02.14.2001','Pesajian'),
('14.02.14.2002','Punti Kayu'),
('14.02.14.2003','Pematang'),
('14.02.14.2004','Selunak'),
('14.02.14.2005','Suka Maju'),
('14.02.14.2006','Pematang Benteng'),
('14.02.14.2007','Sencano Jaya'),
('14.02.14.2008','Sungai Aur'),
('14.02.14.2009','Peladangan'),
('14.02.14.2010','Koto Tuo'),
('14.03','Kabupaten Bengkalis'),
('14.03.01','Bengkalis'),
('14.03.01.1001','Bengkalis Kota'),
('14.03.01.1002','Damon'),
('14.03.01.1003','Rimba Sekampung'),
('14.03.01.2004','Kelapapati'),
('14.03.01.2005','Pedekik'),
('14.03.01.2006','Pangkalan Batang'),
('14.03.01.2007','Sebauk'),
('14.03.01.2008','Teluk Latak'),
('14.03.01.2009','Meskom'),
('14.03.01.2010','Senggoro'),
('14.03.01.2011','Air Putih'),
('14.03.01.2012','Sungai Alam'),
('14.03.01.2013','Penampi'),
('14.03.01.2014','Temeran'),
('14.03.01.2015','Penebal'),
('14.03.01.2016','Pematang Duku'),
('14.03.01.2017','Ketam Putih'),
('14.03.01.2018','Kelemantan'),
('14.03.01.2019','Sekodi'),
('14.03.01.2020','Wonosari'),
('14.03.01.2021','Kuala Alam'),
('14.03.01.2022','Kelebuk'),
('14.03.01.2023','Palkun'),
('14.03.01.2024','Sungai Batang'),
('14.03.01.2025','Prapat Tunggal'),
('14.03.01.2026','Simpang Ayam'),
('14.03.01.2027','Senderak'),
('14.03.01.2028','Kelemantan Barat'),
('14.03.01.2029','Damai'),
('14.03.01.2030','Pangkalan Batang Barat'),
('14.03.01.2031','Pematang Duku Timur'),
('14.03.02','Bantan'),
('14.03.02.2001','Bantan Tengah'),
('14.03.02.2002','Bantan Air'),
('14.03.02.2003','Bantan Tua'),
('14.03.02.2004','Teluk Pambang'),
('14.03.02.2005','Selat Baru'),
('14.03.02.2006','Teluk Lancar'),
('14.03.02.2007','Kembung Luar'),
('14.03.02.2008','Jangkang'),
('14.03.02.2009','Muntai'),
('14.03.02.2010','Resam Lapis'),
('14.03.02.2011','Berancah'),
('14.03.02.2012','Ulu Pulau'),
('14.03.02.2013','Mentayan'),
('14.03.02.2014','Pambang Pesisir'),
('14.03.02.2015','Sukamaju'),
('14.03.02.2016','Pambang Baru'),
('14.03.02.2017','Kembung Baru'),
('14.03.02.2018','Pasiran'),
('14.03.02.2019','Bantan Sari'),
('14.03.02.2020','Bantan Timur'),
('14.03.02.2021','Teluk Papal'),
('14.03.02.2022','Muntai Barat'),
('14.03.02.2023','Deluk'),
('14.03.03','Bukit Batu'),
('14.03.03.1010','Sungai Pakning'),
('14.03.03.2001','Sejangat'),
('14.03.03.2002','Dompas'),
('14.03.03.2003','Pangkalan Jambi'),
('14.03.03.2004','Sungai Selari'),
('14.03.03.2005','Buruk Bakul'),
('14.03.03.2006','Bukit Batu'),
('14.03.03.2007','Sukajadi'),
('14.03.03.2016','Batang Duku'),
('14.03.03.2017','Pakning Asal'),
('14.03.09','Mandau'),
('14.03.09.1001','Air Jamban'),
('14.03.09.1002','Babussalam'),
('14.03.09.1003','Batang Serosa'),
('14.03.09.1004','Balik Alam'),
('14.03.09.1006','Duri Barat'),
('14.03.09.1007','Duri Timur'),
('14.03.09.1008','Gajah Sakti'),
('14.03.09.1009','Talang Mandi'),
('14.03.09.1010','Pematang Pudu'),
('14.03.09.2011','Harapan Baru'),
('14.03.09.2021','Bathin Betuah'),
('14.03.10','Rupat'),
('14.03.10.1001','Batu Panjang'),
('14.03.10.1002','Pergam'),
('14.03.10.1003','Terkul'),
('14.03.10.1004','Tanjung Kapal'),
('14.03.10.2005','Sungai Cingam'),
('14.03.10.2006','Teluk Lecah'),
('14.03.10.2007','Makeruh'),
('14.03.10.2008','Hutan Panjang'),
('14.03.10.2009','Pangkalan Nyirih'),
('14.03.10.2010','Sukarjo Mesim'),
('14.03.10.2011','Darul Aman'),
('14.03.10.2012','Parit Kebumen'),
('14.03.10.2013','Sri Tanjung'),
('14.03.10.2014','Pancur Jaya'),
('14.03.10.2015','Pangkalan Pinang'),
('14.03.10.2016','Dungun Baru'),
('14.03.11','Rupat Utara'),
('14.03.11.2001','Tanjung Medang'),
('14.03.11.2002','Teluk Rhu'),
('14.03.11.2003','Tanjung Punak'),
('14.03.11.2004','Kadur'),
('14.03.11.2005','Titi Akar'),
('14.03.11.2006','Hutan Ayu'),
('14.03.11.2007','Suka Damai'),
('14.03.11.2008','Puteri Sembilan'),
('14.03.12','Siak Kecil'),
('14.03.12.2001','Lubuk Muda'),
('14.03.12.2002','Tanjung Belit'),
('14.03.12.2003','Sungai Siput'),
('14.03.12.2004','Sepotong'),
('14.03.12.2005','Lubuk Gaung'),
('14.03.12.2006','Langkat'),
('14.03.12.2007','Sadar Jaya'),
('14.03.12.2008','Sungai Linau'),
('14.03.12.2009','Bandar Jaya'),
('14.03.12.2010','Muara Dua'),
('14.03.12.2011','Tanjung Damai'),
('14.03.12.2012','Sumber Jaya'),
('14.03.12.2013','Lubuk Garam'),
('14.03.12.2014','Liang Banir'),
('14.03.12.2015','Tanjung Datuk'),
('14.03.12.2016','Koto Raja'),
('14.03.12.2017','Sungai Nibung'),
('14.03.13','Pinggir'),
('14.03.13.1001','Titian Antui'),
('14.03.13.1012','Balai Raja'),
('14.03.13.2003','Balai Pungut'),
('14.03.13.2005','Muara Basung'),
('14.03.13.2007','Pinggir'),
('14.03.13.2008','Semunai'),
('14.03.13.2011','Tengganau'),
('14.03.13.2014','Sungai Meranti'),
('14.03.13.2015','Pangkalan Libut'),
('14.03.13.2016','Buluh Apo'),
('14.03.14','Bandar Laksamana'),
('14.03.14.2001','Parit I Api-Api'),
('14.03.14.2002','Temiang'),
('14.03.14.2003','Api-Api'),
('14.03.14.2004','Tenggayun'),
('14.03.14.2005','Sepahat'),
('14.03.14.2006','Bukit Kerikil'),
('14.03.14.2007','Tanjung Leban'),
('14.03.15','Talang Muandau'),
('14.03.15.2001','Tasik Serai'),
('14.03.15.2002','Tasik Serai Barat'),
('14.03.15.2003','Kualo Penaso'),
('14.03.15.2004','Beringin'),
('14.03.15.2005','Koto Pait Beringin'),
('14.03.15.2006','Melibur'),
('14.03.15.2007','Tasik Serai Timur'),
('14.03.15.2008','Tasik Tebing Serai'),
('14.03.15.2009','Serai Wangi'),
('14.03.16','Bathin Solapan'),
('14.03.16.2001','Petani'),
('14.03.16.2002','Air Kulim'),
('14.03.16.2003','Buluh Manis'),
('14.03.16.2004','Bumbung'),
('14.03.16.2005','Pamesi'),
('14.03.16.2006','Kesumbo Ampai'),
('14.03.16.2007','Bathin Sobanga'),
('14.03.16.2008','Sebangar'),
('14.03.16.2009','Boncah Mahang'),
('14.03.16.2010','Balai Makam'),
('14.03.16.2011','Tambusai Batang Dui'),
('14.03.16.2012','Simpang Padang'),
('14.03.16.2013','Pematang Obo'),
('14.04','Kabupaten Indragiri Hilir'),
('14.04.01','Reteh'),
('14.04.01.1001','Pulaukijang'),
('14.04.01.1017','Metro'),
('14.04.01.1018','Madani'),
('14.04.01.2002','Sanglar'),
('14.04.01.2003','Pulaukecil'),
('14.04.01.2004','Sungaiterap'),
('14.04.01.2009','Sungaiundan'),
('14.04.01.2010','Seberang Sanglar'),
('14.04.01.2011','Mekar Sari'),
('14.04.01.2012','Seberang Pulau Kijang'),
('14.04.01.2013','Sungaiasam'),
('14.04.01.2014','Pulauruku'),
('14.04.01.2019','Tanjunglabuh'),
('14.04.01.2020','Sungaimahang'),
('14.04.02','Enok'),
('14.04.02.1001','Enok'),
('14.04.02.1002','Pusaran'),
('14.04.02.1003','Telukmedan'),
('14.04.02.1013','Pantaiseberang Makmur'),
('14.04.02.2004','Pengalihan'),
('14.04.02.2005','Sungaiambat'),
('14.04.02.2006','Simpang Tiga'),
('14.04.02.2007','Rantau Panjang'),
('14.04.02.2008','Sungairukam'),
('14.04.02.2009','Bagan Jaya'),
('14.04.02.2010','Suhada'),
('14.04.02.2011','Jaya Bhakti'),
('14.04.02.2012','Sungailokan'),
('14.04.02.2014','Simpang Tiga Daratan'),
('14.04.03','Kuala Indragiri'),
('14.04.03.1007','Sapat'),
('14.04.03.2001','Sungaibuluh'),
('14.04.03.2002','Tanjunglajau'),
('14.04.03.2003','Sungaibela'),
('14.04.03.2006','Telukdalam'),
('14.04.03.2008','Sungaipiyai'),
('14.04.03.2009','Perigi Raja'),
('14.04.03.2010','Tanjungmelayu'),
('14.04.04','Tembilahan'),
('14.04.04.1001','Tembilahan Kota'),
('14.04.04.1002','Tembilahan Hilir'),
('14.04.04.1003','Seberang Tembilahan'),
('14.04.04.1004','Sungaiperak'),
('14.04.04.1005','Sungaiberingin'),
('14.04.04.1006','Pekan Arba'),
('14.04.04.1007','Seberang Tembilahan Barat'),
('14.04.04.1008','Seberang Tembilahan Selatan'),
('14.04.05','Tempuling'),
('14.04.05.1004','Sungaisalak'),
('14.04.05.1005','Tempuling'),
('14.04.05.1016','Tanjungpidada'),
('14.04.05.1017','Pangkalan Tujuh'),
('14.04.05.2002','Telukkiambang'),
('14.04.05.2003','Mumpa'),
('14.04.05.2007','Telukjira'),
('14.04.05.2009','Karya Tunas Jaya'),
('14.04.05.2011','Harapan Jaya'),
('14.04.06','Gaung Anak Serka'),
('14.04.06.1004','Sungaiempat'),
('14.04.06.1005','Telukpinang'),
('14.04.06.1009','Tanjungharapan'),
('14.04.06.2001','Kuala Gaung'),
('14.04.06.2002','Telukpantaian'),
('14.04.06.2003','Teluksungka'),
('14.04.06.2006','Sungaiiliran'),
('14.04.06.2007','Teluktuasan'),
('14.04.06.2008','Rambaian'),
('14.04.06.2010','Harapan Makmur'),
('14.04.06.2011','Kelumpang'),
('14.04.06.2012','Idaman'),
('14.04.07','Mandah'),
('14.04.07.1004','Khairiah Mandah'),
('14.04.07.2001','Pulaucawan'),
('14.04.07.2002','Belaras'),
('14.04.07.2003','Bente'),
('14.04.07.2005','Igal'),
('14.04.07.2006','Pelanduk'),
('14.04.07.2007','Bakau Aceh'),
('14.04.07.2008','Batang Tumu'),
('14.04.07.2009','Bekawan'),
('14.04.07.2010','Bantayan'),
('14.04.07.2011','Batang Sari'),
('14.04.07.2012','Bolak Raya'),
('14.04.07.2013','Cahaya Baru'),
('14.04.07.2014','Belaras Barat'),
('14.04.07.2015','Sepakat Jaya'),
('14.04.07.2016','Suraya Mandiri'),
('14.04.07.2017','Bidari Tanjung Datuk'),
('14.04.08','Kateman'),
('14.04.08.1001','Tegaraja'),
('14.04.08.1009','Amal Bakti'),
('14.04.08.1010','Bandar Sri Gemilang'),
('14.04.08.2002','Kuala Selat'),
('14.04.08.2003','Sungaisimbar'),
('14.04.08.2004','Penjuru'),
('14.04.08.2005','Sari Mulia'),
('14.04.08.2006','Air Tawar'),
('14.04.08.2007','Tanjungraja'),
('14.04.08.2008','Sungaiteritip'),
('14.04.08.2011','Makmur Jaya'),
('14.04.09','Keritang'),
('14.04.09.1003','Kota Baru Reteh'),
('14.04.09.2001','Pebenaan'),
('14.04.09.2002','Seberang Pebenaan'),
('14.04.09.2004','Nusantara Jaya'),
('14.04.09.2005','Kota Baru Seberida'),
('14.04.09.2006','Kembang Mekarsari'),
('14.04.09.2007','Pasar Kembang'),
('14.04.09.2008','Kuala Keritang'),
('14.04.09.2009','Kuala Lemang'),
('14.04.09.2010','Telukkelasa'),
('14.04.09.2011','Pengalihan'),
('14.04.09.2012','Pancur'),
('14.04.09.2013','Sencalang'),
('14.04.09.2014','Petalongan'),
('14.04.09.2015','Nyiur Permai'),
('14.04.09.2016','Lintas Utara'),
('14.04.09.2017','Kayu Raja'),
('14.04.10','Tanah Merah'),
('14.04.10.1001','Kuala Enok'),
('14.04.10.2002','Selatnama'),
('14.04.10.2003','Sungainyiur'),
('14.04.10.2004','Tanjungbaru'),
('14.04.10.2005','Tekulai Hilir'),
('14.04.10.2006','Tekulai Hulu'),
('14.04.10.2007','Tekulai Bugis'),
('14.04.10.2008','Tanjungpasir'),
('14.04.10.2009','Tanah Merah'),
('14.04.10.2010','Sungailaut'),
('14.04.11','Batang Tuaka'),
('14.04.11.1001','Sungaipiring'),
('14.04.11.2002','Sungailuar'),
('14.04.11.2003','Sungaidusun'),
('14.04.11.2004','Sungaijunjangan'),
('14.04.11.2005','Sungairaya'),
('14.04.11.2006','Kuala Sebatu'),
('14.04.11.2007','Tanjungsiantar'),
('14.04.11.2008','Sungairawa'),
('14.04.11.2009','Sialang Jaya'),
('14.04.11.2010','Gemilang Jaya'),
('14.04.11.2011','Tasik Raya'),
('14.04.11.2012','Pasir Emas'),
('14.04.11.2013','Simpang Jaya'),
('14.04.12','Gaung'),
('14.04.12.1006','Kuala Lahang'),
('14.04.12.2001','Terusan Kempas'),
('14.04.12.2002','Lahang Baru'),
('14.04.12.2003','Simpang Gaung'),
('14.04.12.2004','Belantaraya'),
('14.04.12.2005','Sungaibaru'),
('14.04.12.2007','Lahang Tengah'),
('14.04.12.2008','Lahang Hulu'),
('14.04.12.2009','Pungkat'),
('14.04.12.2010','Jerambang'),
('14.04.12.2011','Telukkabung'),
('14.04.12.2012','Gembira'),
('14.04.12.2013','Semambu Kuning'),
('14.04.12.2014','Telukmerbau'),
('14.04.12.2015','Soren'),
('14.04.12.2016','Pintasan'),
('14.04.13','Tembilahan Hulu'),
('14.04.13.1001','Tembilahan Hulu'),
('14.04.13.1005','Tembilahan Barat'),
('14.04.13.2002','Pekan Kamis'),
('14.04.13.2003','Pulaupalas'),
('14.04.13.2004','Sialang Panjang'),
('14.04.13.2006','Sungaiintan'),
('14.04.14','Kemuning'),
('14.04.14.1001','Selensen'),
('14.04.14.2002','Batu Ampar'),
('14.04.14.2003','Keritang'),
('14.04.14.2004','Air Balui'),
('14.04.14.2005','Tuk Jimun'),
('14.04.14.2006','Kemuning Tua'),
('14.04.14.2007','Kemuning Muda'),
('14.04.14.2008','Limau Manis'),
('14.04.14.2009','Lubuk Besar'),
('14.04.14.2010','Sekara'),
('14.04.14.2011','Talang Jangkang'),
('14.04.14.2012','Sekayan'),
('14.04.15','Pelangiran'),
('14.04.15.1002','Pelangiran'),
('14.04.15.2001','Rotan Semelur'),
('14.04.15.2003','Simpang Kateman'),
('14.04.15.2004','Tanjungsimpang'),
('14.04.15.2005','Baung Rejo Jaya'),
('14.04.15.2006','Tagagiri Tama Jaya'),
('14.04.15.2007','Pinang Jaya'),
('14.04.15.2008','Wonosari'),
('14.04.15.2009','Tegal Rejo'),
('14.04.15.2010','Intan Mulia Jaya'),
('14.04.15.2011','Saka Palas Jaya'),
('14.04.15.2012','Catur Karya'),
('14.04.15.2013','Bagan Jaya'),
('14.04.15.2014','Telukbunian'),
('14.04.15.2015','Terusan Beringin Jaya'),
('14.04.15.2016','Hidayah'),
('14.04.16','Teluk Belengkong'),
('14.04.16.2001','Hibrida Mulia'),
('14.04.16.2002','Indra Sari Jaya'),
('14.04.16.2003','Tunggal Rahayu Jaya'),
('14.04.16.2004','Griya Mukti Jaya'),
('14.04.16.2005','Beringin Mulia'),
('14.04.16.2006','Hibrida Jaya'),
('14.04.16.2007','Sumber Jaya'),
('14.04.16.2008','Sumber Makmur Jaya'),
('14.04.16.2009','Sumber Sari Jaya'),
('14.04.16.2010','Kelapa Patih Jaya'),
('14.04.16.2011','Sapta Mulia Jaya'),
('14.04.16.2012','Saka Rotan'),
('14.04.16.2013','Gembaran'),
('14.04.17','Pulau Burung'),
('14.04.17.2001','Pulauburung'),
('14.04.17.2002','Teluknibung'),
('14.04.17.2003','Sungaidanai'),
('14.04.17.2004','Mayang Sari Jaya'),
('14.04.17.2005','Bukit Sari Intan Jaya'),
('14.04.17.2006','Manunggal Jaya'),
('14.04.17.2007','Bangun Harjo Jaya'),
('14.04.17.2008','Ringin Jaya'),
('14.04.17.2009','Sri Damai'),
('14.04.17.2010','Sapta Jaya'),
('14.04.17.2011','Keramat Jaya'),
('14.04.17.2012','Binagun Jaya'),
('14.04.17.2013','Suka Jaya'),
('14.04.17.2014','Sukaharjo Jaya'),
('14.04.18','Concong'),
('14.04.18.1001','Concong Luar'),
('14.04.18.2002','Concong Dalam'),
('14.04.18.2003','Concong Tengah'),
('14.04.18.2004','Kampung Baru'),
('14.04.18.2005','Panglima Raja'),
('14.04.18.2006','Sungaiberapit'),
('14.04.19','Kempas'),
('14.04.19.1002','Kempas Jaya'),
('14.04.19.1007','Harapan Tani'),
('14.04.19.2001','Pekan Tua'),
('14.04.19.2003','Rumbai Jaya'),
('14.04.19.2004','Bayas Jaya'),
('14.04.19.2005','Sungaiara'),
('14.04.19.2006','Sungaigantang'),
('14.04.19.2008','Karya Tani'),
('14.04.19.2009','Kerta Jaya'),
('14.04.19.2010','Kulim Jaya'),
('14.04.19.2011','Danaupulai Indah'),
('14.04.19.2012','Sungairabit'),
('14.04.20','Sungai Batang'),
('14.04.20.1001','Benteng'),
('14.04.20.2002','Benteng Utara'),
('14.04.20.2003','Pasenggerahan'),
('14.04.20.2004','Kuala Sungai Batang'),
('14.04.20.2005','Kuala Patah Parang'),
('14.04.20.2006','Benteng Barat'),
('14.04.20.2007','Pandan Sari'),
('14.04.20.2008','Mugo Mulyo'),
('14.05','Kabupaten Pelalawan'),
('14.05.01','Ukui'),
('14.05.01.1010','Ukui I'),
('14.05.01.2001','Air Hitam'),
('14.05.01.2002','Air Emas'),
('14.05.01.2003','Bukit Gajah'),
('14.05.01.2004','Bukit Jaya'),
('14.05.01.2005','Kampung Baru'),
('14.05.01.2006','Lubuk Kembang Bunga'),
('14.05.01.2007','Lubuk Kembang Sari'),
('14.05.01.2008','Silikuan Hulu'),
('14.05.01.2009','Tri Mulya Jaya'),
('14.05.01.2011','Ukui Dua'),
('14.05.01.2012','Bagan Limau'),
('14.05.02','Pangkalan Kerinci'),
('14.05.02.1007','Pangkalan Kerinci Barat'),
('14.05.02.1008','Pangkalan Kerinci Kota'),
('14.05.02.1009','Pangkalan Kerinci Timur'),
('14.05.02.2001','Mekar Jaya'),
('14.05.02.2002','Kuala Terusan'),
('14.05.02.2003','Makmur'),
('14.05.02.2005','Rantau Baru'),
('14.05.03','Pangkalan Kuras'),
('14.05.03.1001','Sorek I'),
('14.05.03.2002','Sorek II'),
('14.05.03.2003','Dundangan'),
('14.05.03.2004','Palas'),
('14.05.03.2005','Terantang Manuk'),
('14.05.03.2006','Kemang'),
('14.05.03.2007','Talau'),
('14.05.03.2008','Tanjung Beringin'),
('14.05.03.2009','Betung'),
('14.05.03.2010','Kesuma'),
('14.05.03.2011','Surya Indah'),
('14.05.03.2012','Sialang Indah'),
('14.05.03.2013','Beringin Indah'),
('14.05.03.2014','Meranti'),
('14.05.03.2015','Harapan Jaya'),
('14.05.03.2016','Batang Kulim'),
('14.05.03.2017','Sidomukti'),
('14.05.04','Pangkalan Lesung'),
('14.05.04.1001','Pangkalan Lesung'),
('14.05.04.2002','Dusun Tua'),
('14.05.04.2003','Genduang'),
('14.05.04.2004','Mayang Sari'),
('14.05.04.2005','Rawang Sari'),
('14.05.04.2006','Mulya Subur'),
('14.05.04.2007','Sari Mulya'),
('14.05.04.2008','Sari Makmur'),
('14.05.04.2009','Tanjung Kuyo'),
('14.05.04.2010','Pesaguan'),
('14.05.05','Langgam'),
('14.05.05.1001','Langgam'),
('14.05.05.2002','Tambak'),
('14.05.05.2003','Penarikan'),
('14.05.05.2004','Segati'),
('14.05.05.2005','Sotol'),
('14.05.05.2006','Pangkalan Gondai'),
('14.05.05.2007','Langkan'),
('14.05.05.2008','Padang Luas'),
('14.05.06','Pelalawan'),
('14.05.06.1001','Pelalawan'),
('14.05.06.2002','Sungai Ara'),
('14.05.06.2003','Ransang'),
('14.05.06.2004','Kuala Tolam'),
('14.05.06.2005','Sering'),
('14.05.06.2006','Telayap'),
('14.05.06.2007','Batang Nilo Kecil'),
('14.05.06.2008','Delik'),
('14.05.06.2010','Lalang Kabung'),
('14.05.07','Kerumutan'),
('14.05.07.1001','Kerumutan'),
('14.05.07.2002','Pangkalan Panduk'),
('14.05.07.2003','Pangkalan Tampui'),
('14.05.07.2004','Bukit Lembah Subur'),
('14.05.07.2005','Banjar Panjang'),
('14.05.07.2006','Beringin Makmur'),
('14.05.07.2007','Pematang Tinggi'),
('14.05.07.2008','Tanjung Air Hitam'),
('14.05.07.2009','Mak Teduh'),
('14.05.07.2010','Lipai Bulan'),
('14.05.08','Bunut'),
('14.05.08.1011','Pangkalan Bunut'),
('14.05.08.2001','Petani'),
('14.05.08.2002','Merbau'),
('14.05.08.2003','Sungai Buluh'),
('14.05.08.2008','Lubuk Mas'),
('14.05.08.2009','Balam Merah'),
('14.05.08.2010','Bagan Laguh'),
('14.05.08.2013','Lubuk Mandian Gajah'),
('14.05.08.2017','Keriung'),
('14.05.08.2018','Sialang Kayu Batu'),
('14.05.09','Teluk Meranti'),
('14.05.09.1001','Teluk Meranti'),
('14.05.09.2002','Kuala Panduk'),
('14.05.09.2003','Petodaan'),
('14.05.09.2004','Teluk Binjai'),
('14.05.09.2005','Pulau Muda'),
('14.05.09.2006','Gambut Mutiara'),
('14.05.09.2007','Labuhan Bilik'),
('14.05.09.2008','Pangkalan Terap'),
('14.05.09.2009','Segamai'),
('14.05.10','Kuala Kampar'),
('14.05.10.1001','Teluk Dalam'),
('14.05.10.2002','Tanjung Sum'),
('14.05.10.2003','Sungai Solok'),
('14.05.10.2004','Sungai Upih'),
('14.05.10.2005','Teluk'),
('14.05.10.2006','Serapung'),
('14.05.10.2007','Teluk Beringin'),
('14.05.10.2008','Sokoi'),
('14.05.10.2009','Sungai Mas'),
('14.05.10.2010','Teluk Bakau'),
('14.05.11','Bandar Sei Kijang'),
('14.05.11.1001','Sei Kijang'),
('14.05.11.2002','Lubuk Ogung'),
('14.05.11.2003','Simpang Beringin'),
('14.05.11.2004','Muda Setia'),
('14.05.11.2005','Kiab Jaya'),
('14.05.12','Bandar Petalangan'),
('14.05.12.1002','Rawang Empat'),
('14.05.12.2001','Kuala Semundam'),
('14.05.12.2003','Tambun'),
('14.05.12.2004','Terbangiang'),
('14.05.12.2005','Lubuk Terap'),
('14.05.12.2006','Angkasa'),
('14.05.12.2007','Sialang Godang'),
('14.05.12.2008','Lubuk Raja'),
('14.05.12.2009','Lubuk Keranji Timur'),
('14.05.12.2010','Airterjun'),
('14.05.12.2011','Sialang Bungkuk'),
('14.06','Kabupaten Rokan Hulu'),
('14.06.01','Ujung Batu'),
('14.06.01.1001','Ujung Batu'),
('14.06.01.2002','Suka Damai'),
('14.06.01.2003','Ngaso'),
('14.06.01.2004','Ujung Batu Timur'),
('14.06.01.2005','Pematang Tebih'),
('14.06.02','Rokan IV Koto'),
('14.06.02.1001','Rokan'),
('14.06.02.2002','Cipang Kanan'),
('14.06.02.2003','Cipang Kiri Hulu'),
('14.06.02.2004','Cipang Kiri Hilir'),
('14.06.02.2006','Tanjung Medan'),
('14.06.02.2007','Lubuk Bendahara Timur'),
('14.06.02.2008','Lubuk Bendahara'),
('14.06.02.2010','Sikebau Jaya'),
('14.06.02.2013','Rokan Koto Ruang'),
('14.06.02.2014','Rokan Timur'),
('14.06.02.2016','Lubuk Betung'),
('14.06.02.2017','Pemandang'),
('14.06.02.2018','Alahan'),
('14.06.02.2019','Tibawan'),
('14.06.03','Rambah'),
('14.06.03.1001','Pasir Pengarayan'),
('14.06.03.2002','Rambah Tengah Utara'),
('14.06.03.2003','Rambah Tengah Hilir'),
('14.06.03.2004','Rambah Tengah Hulu'),
('14.06.03.2005','Rambah Tengah Barat'),
('14.06.03.2006','Menaming'),
('14.06.03.2007','Pasir Baru'),
('14.06.03.2008','Sialang Jaya'),
('14.06.03.2009','Tanjung Belit'),
('14.06.03.2010','Koto Tinggi'),
('14.06.03.2011','Suka Maju'),
('14.06.03.2012','Pematang Berangan'),
('14.06.03.2013','Babussalam'),
('14.06.03.2014','Pasir Maju'),
('14.06.04','Tambusai'),
('14.06.04.1001','Tambusai Tengah'),
('14.06.04.2002','Tambusai Barat'),
('14.06.04.2003','Tambusai Timur'),
('14.06.04.2004','Batas'),
('14.06.04.2005','Talikumain'),
('14.06.04.2006','Rantau Panjang'),
('14.06.04.2007','Sungai Kumango'),
('14.06.04.2008','Batang Kumu'),
('14.06.04.2009','Sialang Rindang'),
('14.06.04.2010','Suka Maju'),
('14.06.04.2011','Lubuk Soting'),
('14.06.04.2012','Tingkok'),
('14.06.05','Kepenuhan'),
('14.06.05.1001','KepenuhanTengah'),
('14.06.05.2003','Kepenuhan Barat'),
('14.06.05.2004','Kepenuhan Hilir'),
('14.06.05.2005','Kepenuhan Timur'),
('14.06.05.2006','Kepenuhan Barat Sei Rokan Jaya'),
('14.06.05.2007','Kepenuhan Raya'),
('14.06.05.2008','Kepenuhan Baru'),
('14.06.05.2009','Kepenuhan Barat Mulya'),
('14.06.05.2010','Ulak Patian'),
('14.06.05.2012','Rantau Binuang Sakti'),
('14.06.06','Kunto Darussalam'),
('14.06.06.1001','Kota Lama'),
('14.06.06.2003','Kota Intan'),
('14.06.06.2004','Muara Dilam'),
('14.06.06.2008','Kota Raya'),
('14.06.06.2009','Kota Baru'),
('14.06.06.2010','Sungai Kuti'),
('14.06.06.2011','Pasir Indah'),
('14.06.06.2012','Pasir Luhur'),
('14.06.06.2017','Bukit Intan Makmur'),
('14.06.06.2018','Bagan Tujuh'),
('14.06.07','Rambah Samo'),
('14.06.07.2001','Rambah Samo'),
('14.06.07.2002','Rambah Samo Barat'),
('14.06.07.2003','Rambah Baru'),
('14.06.07.2004','Rambah Utama'),
('14.06.07.2005','Pasir Makmur'),
('14.06.07.2006','Karya Mulya'),
('14.06.07.2007','Marga Mulya'),
('14.06.07.2008','Langkitin'),
('14.06.07.2009','Masda Makmur'),
('14.06.07.2010','Lubuk Napal'),
('14.06.07.2011','Teluk Aur'),
('14.06.07.2012','Sei Salak'),
('14.06.07.2013','Sei Kuning'),
('14.06.07.2014','Lubuk Bilang'),
('14.06.08','Rambah Hilir'),
('14.06.08.2001','Rambah Hilir'),
('14.06.08.2002','Rambah Hilir Tengah'),
('14.06.08.2003','Rambah Hilir Timur'),
('14.06.08.2004','Pasir Utama'),
('14.06.08.2005','Pasir Jaya'),
('14.06.08.2006','Rambah Muda'),
('14.06.08.2007','Sungai Sitolang'),
('14.06.08.2008','Lubuk Kerapat'),
('14.06.08.2009','Rambah'),
('14.06.08.2010','Serombou Indah'),
('14.06.08.2011','Sungai Dua Indah'),
('14.06.08.2012','Muara Musu'),
('14.06.08.2013','Sejati'),
('14.06.09','Tambusai Utara'),
('14.06.09.2001','Tambusai Utara'),
('14.06.09.2002','Mahato'),
('14.06.09.2003','Bangun Jaya'),
('14.06.09.2004','Simpang Harapan'),
('14.06.09.2005','Pagar Mayang'),
('14.06.09.2006','Payung Sekaki'),
('14.06.09.2007','Mekar Jaya'),
('14.06.09.2008','Tanjung Medan'),
('14.06.09.2009','Suka Damai'),
('14.06.09.2010','Rantau Sakti'),
('14.06.09.2011','Mahato Sakti'),
('14.06.10','Bangun Purba'),
('14.06.10.2001','Pasir Agung'),
('14.06.10.2002','Pasir Intan'),
('14.06.10.2003','Rambah Jaya'),
('14.06.10.2004','Bangun Purba'),
('14.06.10.2005','Bangun Purba Timur Jaya'),
('14.06.10.2006','Bangun Purba Barat'),
('14.06.10.2007','Tangun'),
('14.06.11','Tandun'),
('14.06.11.2001','Tandun'),
('14.06.11.2002','Kumain'),
('14.06.11.2003','Bono Tapung'),
('14.06.11.2004','Dayo'),
('14.06.11.2005','Tapung Jaya'),
('14.06.11.2006','Puo Raya'),
('14.06.11.2007','Sei Kuning'),
('14.06.11.2008','Koto Tandun'),
('14.06.11.2009','Tandun Barat'),
('14.06.12','Kabun'),
('14.06.12.2001','Kabun'),
('14.06.12.2002','Aliantan'),
('14.06.12.2003','Koto Ranah'),
('14.06.12.2004','Boncah Kesuma'),
('14.06.12.2005','Batu Langkah Besar'),
('14.06.12.2006','Giti'),
('14.06.13','Bonai Darussalam'),
('14.06.13.2001','Teluk Sono'),
('14.06.13.2002','Sontang'),
('14.06.13.2003','Bonai'),
('14.06.13.2004','Rawa Makmur'),
('14.06.13.2005','Pauh'),
('14.06.13.2006','Kasang Padang'),
('14.06.13.2007','Kasang Mungkal'),
('14.06.14','Pagaran Tapah Darussalam'),
('14.06.14.2001','Pagaran Tapah'),
('14.06.14.2002','Kembang Damai'),
('14.06.14.2005','Sangkir Indah'),
('14.06.15','Kepenuhan Hulu'),
('14.06.15.2001','Kepenuhan Hulu'),
('14.06.15.2002','Pekan Tebih'),
('14.06.15.2003','Kepayang'),
('14.06.15.2004','Muara Jaya'),
('14.06.15.2005','Kepenuhan Jaya'),
('14.06.16','Pendalian IV Koto'),
('14.06.16.2001','Pendalian'),
('14.06.16.2002','Bengkolan Salak'),
('14.06.16.2003','Suligi'),
('14.06.16.2004','Air Panas'),
('14.06.16.2005','Sei Kandis'),
('14.07','Kabupaten Rokan Hilir'),
('14.07.01','Kubu'),
('14.07.01.1010','Telukmerbau'),
('14.07.01.2002','Tanjungleban'),
('14.07.01.2003','Sungaikubu'),
('14.07.01.2004','Rantau Panjang Kanan'),
('14.07.01.2012','Telukpiyai'),
('14.07.01.2013','Sungaisegajah'),
('14.07.01.2015','Sei Segajah Makmur'),
('14.07.01.2020','Telukpiyai Pesisir'),
('14.07.01.2021','Sungaikubu Hulu'),
('14.07.01.2022','Sungai Segajah Jaya'),
('14.07.02','Bangko'),
('14.07.02.1011','Bagan Punak'),
('14.07.02.1012','Bagan Kota'),
('14.07.02.1015','Bagan Hulu'),
('14.07.02.1016','Bagan Barat'),
('14.07.02.1017','Bagan Timur'),
('14.07.02.2009','Labuhan Tangga Kecil'),
('14.07.02.2010','Labuhan Tangga Besar'),
('14.07.02.2013','Bagan Jawa'),
('14.07.02.2014','Parit Aman'),
('14.07.02.2019','Labuhan Tangga Baru'),
('14.07.02.2021','Bagan Jawa Pesisir'),
('14.07.02.2022','Serusa'),
('14.07.02.2023','Labuhan Tangga Hilir'),
('14.07.02.2024','Bagan Punak Meranti'),
('14.07.02.2025','Bagan Punak Pesisir'),
('14.07.03','Tanah Putih'),
('14.07.03.1007','Sedinginan'),
('14.07.03.1010','Banjar XII'),
('14.07.03.1019','Cempedak Rahuk'),
('14.07.03.2001','Ujung Tanjung'),
('14.07.03.2002','Rantau Bais'),
('14.07.03.2005','Sekeladi'),
('14.07.03.2006','Teluk Mega'),
('14.07.03.2008','Putat'),
('14.07.03.2009','Sintong'),
('14.07.03.2011','Mumugo'),
('14.07.03.2012','Teluk Berembun'),
('14.07.03.2013','Menggala Sakti'),
('14.07.03.2014','Sekeladi Hilir'),
('14.07.03.2015','Menggala Sempurna'),
('14.07.03.2016','Sintong Pusaka'),
('14.07.03.2017','Sintong Bakti'),
('14.07.03.2018','Sintong Makmur'),
('14.07.04','Rimba Melintang'),
('14.07.04.1001','Rimba Melintang'),
('14.07.04.2002','Jumrah'),
('14.07.04.2003','Telukpulau Hilir'),
('14.07.04.2004','Telukpulau Hulu'),
('14.07.04.2005','Langgadai Hulu'),
('14.07.04.2006','Lenggadai Hilir'),
('14.07.04.2007','Mukti Jaya'),
('14.07.04.2008','Karya Mukti'),
('14.07.04.2009','Harapan Jaya'),
('14.07.04.2010','Seremban Jaya'),
('14.07.04.2011','Pematang Botam'),
('14.07.04.2012','Pematang Sikek'),
('14.07.05','Bagansinembah'),
('14.07.05.1018','Bagan Batu Kota'),
('14.07.05.1019','Bahtera Makmur Kota'),
('14.07.05.2002','Bagan Batu'),
('14.07.05.2003','Bahtera Makmur'),
('14.07.05.2007','Pelita'),
('14.07.05.2008','Gelora'),
('14.07.05.2015','Suka Maju'),
('14.07.05.2016','Bagan Manunggal'),
('14.07.05.2017','Bagan Sapta Permai'),
('14.07.05.2025','Bakti Makmur'),
('14.07.05.2028','Jaya Agung'),
('14.07.05.2030','Meranti Makmur'),
('14.07.05.2031','Bhayangkara Jaya'),
('14.07.06','Pasir Limau Kapas'),
('14.07.06.1007','Panipahan'),
('14.07.06.2001','Panipahan'),
('14.07.06.2002','Telukpulai'),
('14.07.06.2003','Pasir Limau Kapas'),
('14.07.06.2004','Sungai Daun'),
('14.07.06.2005','Panipahan Darat'),
('14.07.06.2006','Panipahan Laut'),
('14.07.06.2008','Pulaujemur'),
('14.07.07','Sinaboi'),
('14.07.07.1005','Sinaboi Kota'),
('14.07.07.2001','Sinaboi'),
('14.07.07.2002','Sei Bakau'),
('14.07.07.2003','Raja Bejamu'),
('14.07.07.2004','Sungai Nyamuk'),
('14.07.07.2006','Darussalam'),
('14.07.08','Pujud'),
('14.07.08.1010','Pujud Selatan'),
('14.07.08.2001','Teluk Nayang'),
('14.07.08.2002','Pujud'),
('14.07.08.2003','Air Hitam'),
('14.07.08.2004','Kasang Bangsawan'),
('14.07.08.2005','Sungaipinang'),
('14.07.08.2008','Siarang-arang'),
('14.07.08.2011','Suka Jadi'),
('14.07.08.2015','Pujud Utara'),
('14.07.08.2016','Babussalam Rokan'),
('14.07.08.2017','Perkebunan Siarang-arang'),
('14.07.09','Tanah Putih Tanjung Melawan'),
('14.07.09.1005','Melayu Besar Kota'),
('14.07.09.2001','Melayu Besar'),
('14.07.09.2002','Melayu Tengah'),
('14.07.09.2003','Batu Hampar'),
('14.07.09.2004','Mesah'),
('14.07.09.2006','Labuhan Papan'),
('14.07.10','Bangko Pusako'),
('14.07.10.1001','Bangko Kanan'),
('14.07.10.1006','Bangko Kiri'),
('14.07.10.2002','Bangko Jaya'),
('14.07.10.2003','Bangko Sempurna'),
('14.07.10.2004','Bangko Bakti'),
('14.07.10.2005','Bangko Pusako'),
('14.07.10.2007','Sei Manasib'),
('14.07.10.2008','Teluk Bano I'),
('14.07.10.2009','Bangko Makmur'),
('14.07.10.2010','Pematang Damar'),
('14.07.10.2011','Pematang Ibul'),
('14.07.10.2012','Bangko Permata'),
('14.07.10.2013','Bangko Mukti'),
('14.07.10.2014','Bangko Lestari'),
('14.07.10.2015','Bangko Balam'),
('14.07.10.2016','Bangko Mas Raya'),
('14.07.11','Simpang Kanan'),
('14.07.11.1001','Simpang Kanan'),
('14.07.11.2002','Kota Parit'),
('14.07.11.2003','Bagan Nibung'),
('14.07.11.2004','Bukit Damar'),
('14.07.11.2005','Bukit Mas'),
('14.07.11.2006','Bukit Selamat'),
('14.07.12','Batu Hampar'),
('14.07.12.1004','Bantayan Hilir'),
('14.07.12.2001','Bantaian'),
('14.07.12.2002','Sungaisialang'),
('14.07.12.2003','Bantayan Baru'),
('14.07.12.2005','Sungaisialang Hulu'),
('14.07.13','Rantau Kopar'),
('14.07.13.1002','Rantau Kopar'),
('14.07.13.1003','Sungai Rangau'),
('14.07.13.2001','Sekapas'),
('14.07.13.2004','Bagan Cempedak'),
('14.07.14','Pekaitan'),
('14.07.14.2001','Pedamaran'),
('14.07.14.2002','Rokan Baru'),
('14.07.14.2003','Sei Besar'),
('14.07.14.2004','Suak Temenggung'),
('14.07.14.2005','Teluk Bano II'),
('14.07.14.2006','Pekaitan'),
('14.07.14.2007','Suak Air Hitam'),
('14.07.14.2008','Kubu I'),
('14.07.14.2009','Karyo Mulyo Sari'),
('14.07.14.2010','Rokan Baru Pesisir'),
('14.07.15','Kubu Babussalam'),
('14.07.15.2001','Rantau Panjang Kiri'),
('14.07.15.2002','Teluknilap'),
('14.07.15.2003','Sungaimajo'),
('14.07.15.2004','Sungaipinang'),
('14.07.15.2005','Sungaipanji-panji'),
('14.07.15.2006','Jojol'),
('14.07.15.2007','Pulauhalang Muka'),
('14.07.15.2008','Pulauhalang Belakang'),
('14.07.15.2009','Rantau Panjang Kiri Hilir'),
('14.07.15.2010','Teluknilap Jaya'),
('14.07.15.2011','Sungaimajo Pusako'),
('14.07.15.2012','Pulauhalang Hulu'),
('14.07.16','Tanjung Medan'),
('14.07.16.2001','Tanjung Medan'),
('14.07.16.2002','Tanjung Medan Utara'),
('14.07.16.2003','Tanjung Medan Barat'),
('14.07.16.2004','Sei Meranti'),
('14.07.16.2005','Sei Meranti Darussalam'),
('14.07.16.2006','Akar Belingkar'),
('14.07.16.2007','Tangga Batu'),
('14.07.16.2008','Perkebunan Tanjung Medan'),
('14.07.16.2009','Sri Kayangan'),
('14.07.16.2010','Pondok Kresek'),
('14.07.16.2011','Sungai Tapah'),
('14.07.16.2012','Tanjung Sari'),
('14.07.17','Bagan Sinembah Raya'),
('14.07.17.1001','Bagan Sinembah Kota'),
('14.07.17.2002','Bagan Sinembah'),
('14.07.17.2003','Harapan Makmur Selatan'),
('14.07.17.2004','Harapan Makmur'),
('14.07.17.2005','Makmur Jaya'),
('14.07.17.2006','Salak'),
('14.07.17.2007','Panca Mukti'),
('14.07.17.2008','Bagansinembah Timur'),
('14.07.17.2009','Bagansinembah Utara'),
('14.07.17.2010','Bagansinembah Barat'),
('14.07.18','Balai Jaya'),
('14.07.18.1001','Balai Jaya Kota'),
('14.07.18.1002','Balam Sempurna Kota'),
('14.07.18.2003','Balam Jaya'),
('14.07.18.2004','Balai Jaya'),
('14.07.18.2005','Balam Sempurna'),
('14.07.18.2006','Bagan Bhakti'),
('14.07.18.2007','Kencana'),
('14.07.18.2008','Pasir Putih'),
('14.07.18.2009','Pasir Putih Utara'),
('14.07.18.2010','Pasir Putih Barat'),
('14.07.18.2011','Lubuk Jawi'),
('14.08','Kabupaten Siak'),
('14.08.01','Siak'),
('14.08.01.1001','Kampung Dalam'),
('14.08.01.1002','Kampung Rempak'),
('14.08.01.2003','Langkai'),
('14.08.01.2011','Tumang'),
('14.08.01.2012','Merempan Hulu'),
('14.08.01.2013','Rawang Air Putih'),
('14.08.01.2014','Suak Lanjut'),
('14.08.01.2015','Buantan Besar'),
('14.08.02','Sungai Apit'),
('14.08.02.1001','Sungai Apit'),
('14.08.02.2002','Teluk Lanus'),
('14.08.02.2003','Tanjung Kuras'),
('14.08.02.2004','Parit I/II'),
('14.08.02.2005','Teluk Mesjid'),
('14.08.02.2008','Sungai Kayu Ara'),
('14.08.02.2009','Lalang'),
('14.08.02.2010','Mengkapan'),
('14.08.02.2011','Sungai Rawa'),
('14.08.02.2012','Penyengat'),
('14.08.02.2014','Teluk Batil'),
('14.08.02.2016','Bunsur'),
('14.08.02.2017','Harapan'),
('14.08.02.2019','Kayu Ara Permai'),
('14.08.02.2020','Rawa Mekar Jaya'),
('14.08.03','Minas'),
('14.08.03.1001','Minas Jaya'),
('14.08.03.2002','Minas Timur'),
('14.08.03.2003','Minas Barat'),
('14.08.03.2004','Mandi Angin'),
('14.08.03.2005','Rantau Bertuah'),
('14.08.04','Tualang'),
('14.08.04.1001','Perawang'),
('14.08.04.2002','Tualang'),
('14.08.04.2003','Pinang Sebatang'),
('14.08.04.2004','Meredan'),
('14.08.04.2005','Pinang Sebatang Timur'),
('14.08.04.2006','Pinang Sebatang Barat'),
('14.08.04.2007','Meredan Barat'),
('14.08.04.2008','Perawang Barat'),
('14.08.04.2009','Tualang Timur'),
('14.08.05','Sungai Mandau'),
('14.08.05.2001','Muara Kelantan'),
('14.08.05.2002','Teluk Lancang'),
('14.08.05.2003','Sungai Selodang'),
('14.08.05.2004','Olak'),
('14.08.05.2005','Lubuk Jering'),
('14.08.05.2006','Muara Bungkal'),
('14.08.05.2007','Lubuk Umbut'),
('14.08.05.2008','Bencah Umbai'),
('14.08.05.2009','Tasik Betung'),
('14.08.06','Dayun'),
('14.08.06.2001','Dayun'),
('14.08.06.2002','Banjar Seminai'),
('14.08.06.2003','Teluk Merbau'),
('14.08.06.2004','Merangkai'),
('14.08.06.2005','Lubuk Tilan'),
('14.08.06.2006','Berumbung Baru'),
('14.08.06.2007','Pangkalan Makmur'),
('14.08.06.2008','Buana Makmur'),
('14.08.06.2009','Suka Mulya'),
('14.08.06.2010','Sawit Permai'),
('14.08.06.2011','Sialang Sakti'),
('14.08.07','Kerinci Kanan'),
('14.08.07.2001','Kerinci Kanan'),
('14.08.07.2002','Kerinci Kiri'),
('14.08.07.2003','Buana Bakti'),
('14.08.07.2004','Bukit Harapan'),
('14.08.07.2005','Kumbara Utama'),
('14.08.07.2006','Bukit Agung'),
('14.08.07.2008','Simpang Perak Jaya'),
('14.08.07.2009','Buatan Baru'),
('14.08.07.2010','Gabung Makmur'),
('14.08.07.2011','Jati Mulya'),
('14.08.07.2012','Seminai'),
('14.08.07.2013','Delima Jaya'),
('14.08.08','Bunga Raya'),
('14.08.08.2001','Bunga Raya'),
('14.08.08.2002','Jati Baru'),
('14.08.08.2003','Jayapura'),
('14.08.08.2011','Kemuning Muda'),
('14.08.08.2012','Buatan Lestari'),
('14.08.08.2013','Tuah Indrapura'),
('14.08.08.2014','Langsat Permai'),
('14.08.08.2015','Temusai'),
('14.08.08.2016','Dayang Suri'),
('14.08.08.2017','Suak Merambai'),
('14.08.09','Koto Gasib'),
('14.08.09.2001','Pangkalan Pisang'),
('14.08.09.2002','Kuala Gasib'),
('14.08.09.2003','Teluk Rimba'),
('14.08.09.2004','Buatan I'),
('14.08.09.2005','Buatan II'),
('14.08.09.2006','Sengkemang'),
('14.08.09.2007','Rantau Panjang'),
('14.08.09.2008','Empang Pandan'),
('14.08.09.2009','Keranji Guguh'),
('14.08.09.2010','Sri Gemilang'),
('14.08.09.2011','Tasik Seminai'),
('14.08.10','Kandis'),
('14.08.10.1001','Simpang Belutu'),
('14.08.10.1002','Telaga Sam-sam'),
('14.08.10.1003','Kandis Kota'),
('14.08.10.2004','Belutu'),
('14.08.10.2005','Kandis'),
('14.08.10.2006','Sam-Sam'),
('14.08.10.2007','Bekalar'),
('14.08.10.2008','Jambai Makmur'),
('14.08.10.2009','Sungai Gondang'),
('14.08.10.2010','Pencing Bekulo'),
('14.08.10.2011','Libo Jaya'),
('14.08.11','Lubuk Dalam'),
('14.08.11.2001','Lubuk Dalam'),
('14.08.11.2002','Rawang Kao'),
('14.08.11.2003','Sri Gading'),
('14.08.11.2004','Sialang Baru'),
('14.08.11.2005','Sialang Palas'),
('14.08.11.2006','Empang Baru'),
('14.08.11.2007','Rawang Kao Barat'),
('14.08.12','Sabak Auh'),
('14.08.12.2001','Bandar Sungai'),
('14.08.12.2002','Rempak'),
('14.08.12.2003','Belading'),
('14.08.12.2004','Sungai Tengah'),
('14.08.12.2005','Laksamana'),
('14.08.12.2006','Sabak Permai'),
('14.08.12.2007','Bandar Pedada'),
('14.08.12.2008','Selat Guntung'),
('14.08.13','Mempura'),
('14.08.13.1006','Sungaimempura'),
('14.08.13.2001','Kota Ringin'),
('14.08.13.2002','Paluh'),
('14.08.13.2003','Benteng Hilir'),
('14.08.13.2004','Benteng Hulu'),
('14.08.13.2005','Kampung Tengah'),
('14.08.13.2007','Merempan Hilir'),
('14.08.13.2008','Telukmerempan'),
('14.08.14','Pusako'),
('14.08.14.2001','Sungai Berbari'),
('14.08.14.2002','Sungai Limau'),
('14.08.14.2003','Dosan'),
('14.08.14.2004','Benayah'),
('14.08.14.2005','Pebadaran'),
('14.08.14.2006','Dusun Pusaka'),
('14.08.14.2007','Perincit'),
('14.09','Kabupaten Kuantan Singingi'),
('14.09.01','Kuantan Mudik'),
('14.09.01.1012','Pasar Lubuk Jambi'),
('14.09.01.2004','Air Buluh'),
('14.09.01.2005','Pantai'),
('14.09.01.2007','Lubuk Ramo'),
('14.09.01.2008','Seberang Cengar'),
('14.09.01.2009','Koto Cengar'),
('14.09.01.2010','Sangau'),
('14.09.01.2011','Banjar Padang'),
('14.09.01.2013','Kasang'),
('14.09.01.2014','Koto Lubuk Jambi'),
('14.09.01.2015','Pulaubinjai'),
('14.09.01.2016','Seberang Pantai'),
('14.09.01.2017','Rantau Sialang'),
('14.09.01.2018','Luai'),
('14.09.01.2019','Banjar Guntung'),
('14.09.01.2020','Bukitpedusunan'),
('14.09.01.2021','Saik'),
('14.09.01.2022','Pebaun Hulu'),
('14.09.01.2023','Pebaun Hilir'),
('14.09.01.2024','Kinali'),
('14.09.01.2025','Bukit Kauman'),
('14.09.01.2026','Aur Duri'),
('14.09.01.2027','Sungaimanau'),
('14.09.01.2030','Muaro Tombang'),
('14.09.02','Kuantan Tengah'),
('14.09.02.1016','Pasar Teluk'),
('14.09.02.1018','Simpang Tiga'),
('14.09.02.1025','Sungaijering'),
('14.09.02.2001','Bandar Alai'),
('14.09.02.2002','Pulaukedundung'),
('14.09.02.2003','Pulauaro'),
('14.09.02.2004','Seberang Taluk'),
('14.09.02.2005','Pulau Baru'),
('14.09.02.2006','Koto Tuo'),
('14.09.02.2007','Kopah'),
('14.09.02.2008','Munsalo'),
('14.09.02.2014','Sawah'),
('14.09.02.2015','Koto Taluk'),
('14.09.02.2017','Koto Kari'),
('14.09.02.2019','Pintu Gobang'),
('14.09.02.2020','Jake'),
('14.09.02.2021','Pulau Godang Kari'),
('14.09.02.2022','Jaya'),
('14.09.02.2023','Beringin Taluk'),
('14.09.02.2024','Sitorajo'),
('14.09.02.2026','Seberang Taluk Hilir'),
('14.09.02.2027','Titian Modang Kopah'),
('14.09.02.2028','Pulaubanjar Kari'),
('14.09.03','Singingi'),
('14.09.03.1003','Muara Lembu'),
('14.09.03.2001','Pangkalan Indarung'),
('14.09.03.2002','Pulaupadang'),
('14.09.03.2004','Logas'),
('14.09.03.2005','Kebun Lado'),
('14.09.03.2006','Sungaikuning'),
('14.09.03.2007','Sungaisirih'),
('14.09.03.2008','Sungaibawang'),
('14.09.03.2009','Air Emas'),
('14.09.03.2010','Pasir Emas'),
('14.09.03.2011','Petai Baru'),
('14.09.03.2012','Sungaikeranji'),
('14.09.03.2013','Sumber Datar'),
('14.09.03.2014','Logas Hilir'),
('14.09.04','Kuantan Hilir'),
('14.09.04.1001','Pasar Usang'),
('14.09.04.1002','Pasar Baru'),
('14.09.04.2003','Simpang Tanah Lapang'),
('14.09.04.2004','Rawang Bonto'),
('14.09.04.2005','Koto Tuo'),
('14.09.04.2006','Banuaran'),
('14.09.04.2007','Kampung Madura'),
('14.09.04.2009','Pulau Kijang'),
('14.09.04.2015','Pulaumadinah'),
('14.09.04.2016','Kampung Tengah'),
('14.09.04.2017','Kampung Medan'),
('14.09.04.2018','Kepala Pulau'),
('14.09.04.2019','Teratak Baru'),
('14.09.04.2020','Dusun Tuo'),
('14.09.04.2028','Gunungmelintang'),
('14.09.04.2030','Simpang Pulauberalo'),
('14.09.05','Cerenti'),
('14.09.05.1001','Pasar Cerenti'),
('14.09.05.1002','Koto Peraku'),
('14.09.05.2003','Kompe Berangin'),
('14.09.05.2004','Sikakak'),
('14.09.05.2005','Kampung Baru'),
('14.09.05.2006','Pulaujambu'),
('14.09.05.2007','Koto Cerenti'),
('14.09.05.2008','Pulaubayur'),
('14.09.05.2009','Pulau Panjang Cerenti'),
('14.09.05.2010','Pesikaian'),
('14.09.05.2011','Telukpauh'),
('14.09.05.2012','Tanjungmedan'),
('14.09.05.2013','Kampung Baru Timur'),
('14.09.06','Benai'),
('14.09.06.1001','Benai'),
('14.09.06.2003','Banjar Benai'),
('14.09.06.2004','Talontom'),
('14.09.06.2005','Gunungkesiangan'),
('14.09.06.2006','Pulaukalimanting'),
('14.09.06.2007','Banjar Lopak'),
('14.09.06.2008','Tanjungsimandolak'),
('14.09.06.2009','Siberakun'),
('14.09.06.2010','Pulautongah'),
('14.09.06.2011','Ujung Tanjung'),
('14.09.06.2012','Pulauingu'),
('14.09.06.2013','Simandolak'),
('14.09.06.2014','Tebing Tinggi'),
('14.09.06.2015','Pulaulancang'),
('14.09.06.2016','Benai Kecil'),
('14.09.06.2021','Koto Benai'),
('14.09.07','Gunungtoar'),
('14.09.07.2001','Pulaumungkur'),
('14.09.07.2002','Telukberingin'),
('14.09.07.2003','Pulaurumput'),
('14.09.07.2004','Seberang Gunung'),
('14.09.07.2005','Teberau Panjang'),
('14.09.07.2006','Koto Gunung'),
('14.09.07.2007','Gunung'),
('14.09.07.2008','Toar'),
('14.09.07.2009','Petapahan'),
('14.09.07.2010','Kampung Baru'),
('14.09.07.2011','Pisang Berebus'),
('14.09.07.2012','Lubuk Terentang'),
('14.09.07.2013','Siberobah'),
('14.09.07.2014','Seberang Sungai'),
('14.09.08','Singingi Hilir'),
('14.09.08.2001','Koto Baru'),
('14.09.08.2002','Petai'),
('14.09.08.2003','Sungaipaku'),
('14.09.08.2004','Tanjungpauh'),
('14.09.08.2005','Simpang Raya'),
('14.09.08.2006','Sungaibuluh'),
('14.09.08.2007','Suka Damai'),
('14.09.08.2008','Sumber Jaya'),
('14.09.08.2009','Muara Bahan'),
('14.09.08.2010','Bukitraya'),
('14.09.08.2011','Beringin Jaya'),
('14.09.08.2012','Suka Maju'),
('14.09.09','Pangean'),
('14.09.09.2001','Pasar Baru Pangean'),
('14.09.09.2002','Koto Pangean'),
('14.09.09.2003','Pulaukumpai'),
('14.09.09.2004','Pulautongah'),
('14.09.09.2005','Pulauderas'),
('14.09.09.2006','Telukpauh'),
('14.09.09.2007','Tanah Bekali'),
('14.09.09.2008','Padang Tanggung'),
('14.09.09.2009','Padang Kunik'),
('14.09.09.2010','Pembatang'),
('14.09.09.2011','Pauh Angit'),
('14.09.09.2012','Sukaping'),
('14.09.09.2013','Pulaurengas'),
('14.09.09.2014','Rawang Binjai'),
('14.09.09.2015','Sako'),
('14.09.09.2016','Sungailangsat'),
('14.09.09.2017','Pauh Angit Hulu'),
('14.09.10','Logas Tanah Darat'),
('14.09.10.2001','Perhentian Luas'),
('14.09.10.2002','Logas'),
('14.09.10.2003','Lubuk Kebun'),
('14.09.10.2004','Sungai Rambai'),
('14.09.10.2005','Situgal'),
('14.09.10.2006','Rambahan'),
('14.09.10.2007','Teratak Rendah'),
('14.09.10.2008','Sikijang'),
('14.09.10.2009','Sukaraja'),
('14.09.10.2010','Sako Margasari'),
('14.09.10.2011','Kuantan Sako'),
('14.09.10.2012','Hulu Teso'),
('14.09.10.2013','Giri Sako'),
('14.09.10.2014','Bumi Mulya'),
('14.09.10.2015','Sidodadi'),
('14.09.11','Inuman'),
('14.09.11.2001','Pasar Inuman'),
('14.09.11.2002','Koto Inuman'),
('14.09.11.2003','Pulaupanjang Hulu'),
('14.09.11.2004','Pulaupanjang Hilir'),
('14.09.11.2005','Sigaruntang'),
('14.09.11.2006','Pulaubusuk'),
('14.09.11.2007','Bedeng Sikuran'),
('14.09.11.2008','Banjar Nan Tigo'),
('14.09.11.2009','Pulausipan'),
('14.09.11.2010','Pulaubusuk Jaya'),
('14.09.11.2011','Seberang Pulau Busuk'),
('14.09.11.2012','Lebuh Lurus'),
('14.09.11.2013','Kampung Baru Koto'),
('14.09.11.2014','Ketaping Jaya'),
('14.09.12','Hulu Kuantan'),
('14.09.12.2001','Lubuk Ambacang'),
('14.09.12.2002','Sungaikelelawar'),
('14.09.12.2003','Tanjung'),
('14.09.12.2004','Sungaipinang'),
('14.09.12.2005','Sungaialah'),
('14.09.12.2006','Koto Kombu'),
('14.09.12.2007','Sumpu'),
('14.09.12.2008','Mudik Ulo'),
('14.09.12.2009','Inuman'),
('14.09.12.2010','Tanjungmedang'),
('14.09.12.2011','Serosa'),
('14.09.12.2012','Sampurago'),
('14.09.13','Kuantan Hilir Seberang'),
('14.09.13.2001','Pulaubaru'),
('14.09.13.2002','Pulauberalo'),
('14.09.13.2003','Pulaukulur'),
('14.09.13.2004','Pelukahan'),
('14.09.13.2005','Pengalihan'),
('14.09.13.2006','Lumbok'),
('14.09.13.2007','Teratak Jering'),
('14.09.13.2008','Tanjungpisang'),
('14.09.13.2009','Danau'),
('14.09.13.2010','Kasang Limau Sundai'),
('14.09.13.2011','Koto Rajo'),
('14.09.13.2012','Tanjung'),
('14.09.13.2013','Sungaisorik'),
('14.09.13.2014','Rawang Oguang'),
('14.09.14','Sentajo Raya'),
('14.09.14.1015','Beringin Jaya'),
('14.09.14.2001','Pulaukomang Sentajo'),
('14.09.14.2002','Muaro Sentajo'),
('14.09.14.2003','Koto Sentajo'),
('14.09.14.2004','Kampungbaru Sentajo'),
('14.09.14.2005','Pulaukopung Sentajo'),
('14.09.14.2006','Teratak Air Hitam'),
('14.09.14.2007','Seberang Teratak Air Hitam'),
('14.09.14.2008','Parit Teratak Air Hitam'),
('14.09.14.2009','Jalur Patah'),
('14.09.14.2010','Geringing Baru'),
('14.09.14.2011','Marsawa'),
('14.09.14.2012','Langsat Hulu'),
('14.09.14.2013','Muara Langsat'),
('14.09.14.2014','Geringging Jaya'),
('14.09.15','Pucuk Rantau'),
('14.09.15.2001','Perhentian Sungkai'),
('14.09.15.2002','Ibul'),
('14.09.15.2003','Muarapetai'),
('14.09.15.2004','Pangkalan'),
('14.09.15.2005','Sungaibesar'),
('14.09.15.2006','Setiang'),
('14.09.15.2007','Muaro Tiu Makmur'),
('14.09.15.2008','Muaratobek'),
('14.09.15.2009','Sungaibesar Hilir'),
('14.09.15.2010','Kampung Baru Ibul'),
('14.10','Kabupaten Kepulauan Meranti'),
('14.10.01','Tebing Tinggi'),
('14.10.01.1001','Selatpanjang Kota'),
('14.10.01.1002','Selatpanjang Barat'),
('14.10.01.1003','Selatpanjang Selatan'),
('14.10.01.1004','Selatpanjang Timur'),
('14.10.01.2005','Banglas'),
('14.10.01.2006','Alah Air'),
('14.10.01.2007','Alah Air Timur'),
('14.10.01.2008','Sesap'),
('14.10.01.2016','Banglas Barat'),
('14.10.02','Rangsang Barat'),
('14.10.02.2001','Segomeng'),
('14.10.02.2002','Bantar'),
('14.10.02.2003','Anak Setatah'),
('14.10.02.2004','Lemang'),
('14.10.02.2005','Bokor'),
('14.10.02.2006','Sungai Cina'),
('14.10.02.2007','Melai'),
('14.10.02.2011','Telaga Baru'),
('14.10.02.2012','Bina Maju'),
('14.10.02.2015','Sialang Pasung'),
('14.10.02.2016','Permai'),
('14.10.02.2017','Mekar Baru'),
('14.10.03','Rangsang'),
('14.10.03.2001','Tanjung Samak'),
('14.10.03.2002','Tanjung Medang'),
('14.10.03.2004','Gemala Sari'),
('14.10.03.2007','Topang'),
('14.10.03.2008','Penyagun'),
('14.10.03.2010','Repan'),
('14.10.03.2011','Tanjung Bakau'),
('14.10.03.2012','Teluk Samak'),
('14.10.03.2013','Sungai Gayung Kiri'),
('14.10.03.2014','Citra Damai'),
('14.10.03.2016','Dwi Tunggal'),
('14.10.03.2017','Wonosari'),
('14.10.03.2018','Tebun'),
('14.10.03.2020','Tanjung Gemuk'),
('14.10.04','Tebing Tinggi Barat'),
('14.10.04.2001','Alai'),
('14.10.04.2002','Tenan'),
('14.10.04.2003','Insit'),
('14.10.04.2004','Tanjung'),
('14.10.04.2005','Tanjung Peranap'),
('14.10.04.2006','Kundur'),
('14.10.04.2007','Mekong'),
('14.10.04.2008','Batang Malas'),
('14.10.04.2009','Mantiasa'),
('14.10.04.2010','Gogok Darussalam'),
('14.10.04.2011','Maini Darul Aman'),
('14.10.04.2012','Mengkikip'),
('14.10.04.2013','Alai Selatan'),
('14.10.04.2014','Tanjung Darul Takzim'),
('14.10.05','Merbau'),
('14.10.05.1001','Teluk Belitung'),
('14.10.05.2002','Meranti Bunting'),
('14.10.05.2003','Lukit'),
('14.10.05.2004','Bagan Melibur'),
('14.10.05.2018','Pelantai'),
('14.10.05.2019','Tanjung Kulim'),
('14.10.05.2021','Mekar Sari'),
('14.10.05.2023','Mayang Sari'),
('14.10.05.2026','Sungai Anak Kamal'),
('14.10.05.2027','Sungai Tengah'),
('14.10.06','Pulaumerbau'),
('14.10.06.2001','Kuala Merbau'),
('14.10.06.2002','Renak Dungun'),
('14.10.06.2003','Baran Melintang'),
('14.10.06.2004','Teluk Ketapang'),
('14.10.06.2005','Semukut'),
('14.10.06.2006','Centai'),
('14.10.06.2007','Tanjungbunga'),
('14.10.06.2008','Batang Meranti'),
('14.10.06.2009','Pangkalan Balai'),
('14.10.06.2010','Padang Kamal'),
('14.10.06.2011','Ketapang Permai'),
('14.10.07','Tebing Tinggi Timur'),
('14.10.07.2001','Lukun'),
('14.10.07.2002','Sungai Tohor'),
('14.10.07.2003','Nipah Sendanu'),
('14.10.07.2004','Tanjung Sari'),
('14.10.07.2005','Tanjung Gadai'),
('14.10.07.2006','Teluk Buntal'),
('14.10.07.2007','Kepau Baru'),
('14.10.07.2008','Sungai Tohor Barat'),
('14.10.07.2009','Sendanu Darul Ihsan'),
('14.10.07.2010','Batin Suir'),
('14.10.08','Tasik Putri Puyu'),
('14.10.08.2001','Tanjung Padang'),
('14.10.08.2002','Putri Puyu'),
('14.10.08.2003','Mekar Delima'),
('14.10.08.2004','Dedap'),
('14.10.08.2005','Kudap'),
('14.10.08.2006','Bandul'),
('14.10.08.2007','Selat Akar'),
('14.10.08.2008','Tanjung Pisang'),
('14.10.08.2009','Mengkopot'),
('14.10.08.2010','Mengkirau'),
('14.10.09','Rangsang Pesisir'),
('14.10.09.2001','Tanjung Kedabu'),
('14.10.09.2002','Beting'),
('14.10.09.2003','Sokop'),
('14.10.09.2004','Telesung'),
('14.10.09.2005','Bungur'),
('14.10.09.2006','Tenggayun Raya'),
('14.10.09.2007','Sendaur'),
('14.10.09.2008','Kayu Ara'),
('14.10.09.2009','Sonde'),
('14.10.09.2010','Kedabu Rapat'),
('14.10.09.2011','Tanah Merah'),
('14.71','Kota Pekanbaru'),
('14.71.01','Sukajadi'),
('14.71.01.1002','Jadirejo'),
('14.71.01.1003','Kampung Tengah'),
('14.71.01.1004','Kampung Melayu'),
('14.71.01.1005','Kedung Sari'),
('14.71.01.1006','Harjosari'),
('14.71.01.1007','Sukajadi'),
('14.71.01.1008','Pulau Karomah'),
('14.71.02','Pekanbaru Kota'),
('14.71.02.1001','Simpang Empat'),
('14.71.02.1002','Sumahilang'),
('14.71.02.1003','Tanah Datar'),
('14.71.02.1004','Kota Baru'),
('14.71.02.1005','Sukaramai'),
('14.71.02.1006','Kota Tinggi'),
('14.71.03','Sail'),
('14.71.03.1001','Cinta Raja'),
('14.71.03.1002','Sukamulya'),
('14.71.03.1003','Sukamaju'),
('14.71.04','Limapuluh'),
('14.71.04.1001','Rintis'),
('14.71.04.1002','Tanjung RHU'),
('14.71.04.1003','Pesisir'),
('14.71.04.1004','Sekip'),
('14.71.05','Senapelan'),
('14.71.05.1001','Padang Bulan'),
('14.71.05.1002','Sago'),
('14.71.05.1003','Kampung Baru'),
('14.71.05.1004','Kampung Dalam'),
('14.71.05.1005','Kampung Bandar'),
('14.71.05.1006','Padang Terubuk'),
('14.71.06','Rumbai Barat'),
('14.71.06.1003','Rumbai Bukit'),
('14.71.06.1005','Muarafajar Timur'),
('14.71.06.1010','Muarafajar Barat'),
('14.71.06.1011','Rantaupanjang'),
('14.71.06.1012','Maharani'),
('14.71.06.1013','Agrowisata'),
('14.71.07','Bukit Raya'),
('14.71.07.1005','Simpang Tiga'),
('14.71.07.1006','Tangkerang Selatan'),
('14.71.07.1008','Tangkerang Utara'),
('14.71.07.1011','Tangkerang Labuai'),
('14.71.07.1012','Airdingin'),
('14.71.08','Binawidya'),
('14.71.08.1001','Simpangbaru'),
('14.71.08.1008','Delima'),
('14.71.08.1009','Tobekgodang'),
('14.71.08.1010','Binawidya'),
('14.71.08.1014','Sungaisibam'),
('14.71.09','Marpoyan Damai'),
('14.71.09.1001','Tangkerang Barat'),
('14.71.09.1002','Tangkerang Tengah'),
('14.71.09.1003','Sidomulyo Timur'),
('14.71.09.1004','Wonorejo'),
('14.71.09.1005','Maharatu'),
('14.71.09.1006','Perhentianmarpoyan'),
('14.71.10','Tenayan Raya'),
('14.71.10.1002','Bencahlesung'),
('14.71.10.1003','Tangkerang Timur'),
('14.71.10.1004','Rejosari'),
('14.71.10.1005','Bambukuning'),
('14.71.10.1010','Melebung'),
('14.71.10.1011','Industritenayan'),
('14.71.10.1012','Sialangsakti'),
('14.71.10.1013','Tuahnegeri'),
('14.71.11','Payung Sekaki'),
('14.71.11.1001','Tampan'),
('14.71.11.1002','Labuh Baru Timur'),
('14.71.11.1003','Labuh Baru Barat'),
('14.71.11.1004','Air Hitam'),
('14.71.11.1005','Bandarraya'),
('14.71.11.1007','Tirtasiak'),
('14.71.12','Rumbai'),
('14.71.12.1001','Meranti Pandak'),
('14.71.12.1004','Lembah Damai'),
('14.71.12.1006','Limbungan Baru'),
('14.71.12.1009','Sri Meranti'),
('14.71.12.1010','Palas'),
('14.71.12.1011','Umban Sari'),
('14.71.13','Tuahmadani'),
('14.71.13.1001','Sidomulyo Barat'),
('14.71.13.1002','Sialangmunggu'),
('14.71.13.1003','Tuahkarya'),
('14.71.13.1004','Tuahmadani'),
('14.71.13.1005','Airputih'),
('14.71.14','Kulim'),
('14.71.14.1001','Kulim'),
('14.71.14.1002','Mentangor'),
('14.71.14.1003','Sialangrampai'),
('14.71.14.1004','Pebatuan'),
('14.71.14.1005','Pematangkapau'),
('14.71.15','Rumbai Timur'),
('14.71.15.1001','Tebing Tinggi Okura'),
('14.71.15.1002','Sungaiukai'),
('14.71.15.1003','Sungaiambang'),
('14.71.15.1004','Lembah Sari'),
('14.71.15.1005','Limbungan'),
('14.72','Kota Dumai'),
('14.72.01','Dumai Barat'),
('14.72.01.1003','Pangkalan Sesai'),
('14.72.01.1006','Purnama'),
('14.72.01.1008','Bagan Keladi'),
('14.72.01.1009','Simpang Tetap Darul Ichsan'),
('14.72.02','Dumai Timur'),
('14.72.02.1002','Teluk Binjai'),
('14.72.02.1003','Tanjung Palas'),
('14.72.02.1004','Jaya Mukti'),
('14.72.02.1006','Buluh Kasap'),
('14.72.02.1009','Bukit Batrem'),
('14.72.03','Bukit Kapur'),
('14.72.03.1001','Bukit Nenas'),
('14.72.03.1002','Bukit Kayu Kapur'),
('14.72.03.1003','Gurun Panjang'),
('14.72.03.1004','Bagan Besar'),
('14.72.03.1005','Kampung Baru'),
('14.72.03.1006','Bagan Besar Timur'),
('14.72.03.1007','Bukit Kapur'),
('14.72.04','Sungai Sembilan'),
('14.72.04.1001','Lubuk Gaung'),
('14.72.04.1002','Tanjung Penyembal'),
('14.72.04.1003','Bangsal Aceh'),
('14.72.04.1004','Basilam Baru'),
('14.72.04.1005','Batu Teritip'),
('14.72.04.1006','Sungai Geniot'),
('14.72.05','Medang Kampai'),
('14.72.05.1001','Teluk Makmur'),
('14.72.05.1002','Mundam'),
('14.72.05.1003','Guntung'),
('14.72.05.1004','Pelintung'),
('14.72.06','Dumai Kota'),
('14.72.06.1001','Laksamana'),
('14.72.06.1002','Rimba Sekampung'),
('14.72.06.1003','Dumai Kota'),
('14.72.06.1004','Bintan'),
('14.72.06.1005','Sukajadi'),
('14.72.07','Dumai Selatan'),
('14.72.07.1001','Ratu Sima'),
('14.72.07.1002','Bukit Timah'),
('14.72.07.1003','Mekar Sari'),
('14.72.07.1004','Bukit Datuk'),
('14.72.07.1005','Bumi Ayu');

-- Provinsi JAMBI
INSERT INTO wilayah (kode, nama)
VALUES
('15','Jambi'),
('15.01','Kabupaten Kerinci'),
('15.01.01','Gunung Raya'),
('15.01.01.1004','Lempur Tengah'),
('15.01.01.2001','Selam Paung'),
('15.01.01.2002','Air Mumu'),
('15.01.01.2003','Lempur Mudik'),
('15.01.01.2005','Masgo'),
('15.01.01.2006','Lempur Hilir'),
('15.01.01.2011','Kebun Baru'),
('15.01.01.2012','Perikan Tengah'),
('15.01.01.2013','Dusun Baru Lempur'),
('15.01.01.2016','Sungaihangat'),
('15.01.01.2018','Manjunto Lempur'),
('15.01.01.2019','Kebun Lima'),
('15.01.02','Danau Kerinci'),
('15.01.02.2001','Sanggaran Agung'),
('15.01.02.2002','Kota Baru Sanggaran Agung'),
('15.01.02.2003','Pendung Talang Genting'),
('15.01.02.2004','Seleman'),
('15.01.02.2005','Tebing Tinggi'),
('15.01.02.2006','Cupak'),
('15.01.02.2007','Tanjungtanah'),
('15.01.02.2008','Koto Tengah'),
('15.01.02.2013','Simpang Empat'),
('15.01.02.2014','Talang Kemulun'),
('15.01.02.2015','Dusun Baru Tanjung Tanah'),
('15.01.02.2016','Pasar Sore Seleman'),
('15.01.02.2018','Tanjungharapan'),
('15.01.04','Sitinjau Laut'),
('15.01.04.2008','Hiang Tinggi'),
('15.01.04.2009','Ambai Atas'),
('15.01.04.2010','Tanjungmudo'),
('15.01.04.2011','Pendung Tengah'),
('15.01.04.2012','Pendung Hilir'),
('15.01.04.2013','Koto Baru Hiang'),
('15.01.04.2014','Betung Kuning'),
('15.01.04.2026','Ambai Bawah'),
('15.01.04.2028','Hiang Karya'),
('15.01.04.2029','Hiang Lestari'),
('15.01.04.2030','Angkasa Pura'),
('15.01.04.2031','Hiang Sakti'),
('15.01.04.2033','Koto Sekilan Ambai'),
('15.01.04.2034','Penawar Tinggi'),
('15.01.05','Air Hangat'),
('15.01.05.2002','Koto Baru Semurup'),
('15.01.05.2004','Koto Dua Lama'),
('15.01.05.2012','Koto Di Air'),
('15.01.05.2013','Pasar Semurup'),
('15.01.05.2014','Balai'),
('15.01.05.2015','Koto Majidin Hilir'),
('15.01.05.2016','Pendung Hilir'),
('15.01.05.2018','Pendung Mudik'),
('15.01.05.2022','Air Tenang'),
('15.01.05.2024','Muara Semerah'),
('15.01.05.2029','Koto Majidin Mudik'),
('15.01.05.2035','Muara Semerah Mudik'),
('15.01.05.2036','Sawahan Koto Majidin'),
('15.01.05.2037','Sawahan Jaya'),
('15.01.05.2038','Koto Majidin Di Air'),
('15.01.05.2039','Pendung Tengah'),
('15.01.06','Gunung Kerinci'),
('15.01.06.1009','Siulak Deras'),
('15.01.06.2010','Sungaibetung Hilir'),
('15.01.06.2011','Sungaibatu Gantih'),
('15.01.06.2012','Tanjunggenting'),
('15.01.06.2013','Simpang Tutup'),
('15.01.06.2014','Suko Pangkat'),
('15.01.06.2015','Sungaibetung Mudik'),
('15.01.06.2016','Danautinggi'),
('15.01.06.2017','Sungaigelampeh'),
('15.01.06.2018','Siulak Deras Mudik'),
('15.01.06.2019','Siulak Tenang'),
('15.01.06.2039','Sungai Batu Gantih Hilir'),
('15.01.06.2040','Baru Sungai Betung Mudik'),
('15.01.06.2041','Tanjunggenting Mudik'),
('15.01.06.2042','Air Betung'),
('15.01.06.2043','Ujung Ladang'),
('15.01.07','Batang Merangin'),
('15.01.07.2004','Tarutung'),
('15.01.07.2006','Lubuk Paku'),
('15.01.07.2007','Tamiai'),
('15.01.07.2008','Pematang Lingkung'),
('15.01.07.2009','Pasar Tamiai'),
('15.01.07.2010','Seberang Merangin'),
('15.01.07.2011','Baru Pulau Sangkar'),
('15.01.07.2013','Batang Merangin'),
('15.01.07.2014','Muara Hemat'),
('15.01.08','Keliling Danau'),
('15.01.08.2001','Jujun'),
('15.01.08.2002','Talang Lindung'),
('15.01.08.2003','Keluru'),
('15.01.08.2004','Pidung'),
('15.01.08.2005','Tanjungbatu'),
('15.01.08.2006','Benik'),
('15.01.08.2007','Kt Tuo P. Tengah'),
('15.01.08.2008','Kt. Dian P. Tengah'),
('15.01.08.2012','Lempur Danau'),
('15.01.08.2013','Dsn. Baru P. Tengah'),
('15.01.08.2018','Telago'),
('15.01.08.2019','Koto Agung'),
('15.01.08.2022','Pulautengah'),
('15.01.08.2023','Koto Baru'),
('15.01.08.2025','Jembatan Merah Pulau Tengah'),
('15.01.08.2026','Limok Manaih Pulau Tengah'),
('15.01.08.2027','Pasar Jujun'),
('15.01.08.2028','Pancuran Bangko'),
('15.01.09','Kayu Aro'),
('15.01.09.2010','Koto Tuo'),
('15.01.09.2011','Sungaitanduk'),
('15.01.09.2012','Kersik Tuo'),
('15.01.09.2013','Sangir'),
('15.01.09.2014','Koto Baru'),
('15.01.09.2015','Koto Panjang'),
('15.01.09.2016','Koto Tengah'),
('15.01.09.2017','Sungaibendung Air'),
('15.01.09.2022','Sungaisampun'),
('15.01.09.2024','Bedeng Baru'),
('15.01.09.2025','Batang Sangir'),
('15.01.09.2030','Sungaidalam'),
('15.01.09.2038','Koto Periang'),
('15.01.09.2039','Lindung Jaya'),
('15.01.09.2041','Renah Kasah'),
('15.01.09.2042','Pasar Sungai Tanduk'),
('15.01.09.2043','Mekar Sari'),
('15.01.09.2045','Mekar Jaya'),
('15.01.09.2047','Sangir Tengah'),
('15.01.09.2048','Tanjungbungo'),
('15.01.09.2049','Bendung Air Timur'),
('15.01.11','Air Hangat Timur'),
('15.01.11.2001','Kemantan Tinggi'),
('15.01.11.2002','Kemantan Kebalai'),
('15.01.11.2003','Kemantan Darat'),
('15.01.11.2004','Sungaiabu'),
('15.01.11.2005','Pondok Sungaiabu'),
('15.01.11.2006','Koto Tebat'),
('15.01.11.2007','Sungaimedang'),
('15.01.11.2008','Air Hangat'),
('15.01.11.2009','Baru Sungai Tutung'),
('15.01.11.2010','Pungut Tengah'),
('15.01.11.2011','Pungut Hilir'),
('15.01.11.2012','Pungut Mudik'),
('15.01.11.2014','Kemantan Hilir'),
('15.01.11.2015','Sungaitutung'),
('15.01.11.2018','Kemantan Agung'),
('15.01.11.2019','Sungaideras'),
('15.01.11.2020','Kemantan Mudik'),
('15.01.11.2021','Simpang Empat Sungai Tutung'),
('15.01.11.2022','Baru Sungaideras'),
('15.01.11.2023','Taman Jernih Sungaitutung'),
('15.01.11.2024','Baru Sungaimedang'),
('15.01.11.2025','Kemantan Raya'),
('15.01.11.2026','Baru Air Hangat'),
('15.01.11.2027','Air Panas Sungaiabu'),
('15.01.11.2028','Baru Sungaiabu'),
('15.01.15','Gunung Tujuh'),
('15.01.15.2001','Sungairumpun'),
('15.01.15.2002','Sungaisikai'),
('15.01.15.2003','Tangkil'),
('15.01.15.2004','Pelompek'),
('15.01.15.2005','Jernih Jaya'),
('15.01.15.2006','Bengkolan Duo'),
('15.01.15.2007','Lubuk Pauh'),
('15.01.15.2008','Telun Berasap'),
('15.01.15.2009','Bumbun Duri'),
('15.01.15.2010','Pesisir Bukit'),
('15.01.15.2011','Pauh Tinggi'),
('15.01.15.2012','Sungaijernih'),
('15.01.15.2013','Pelompek Pasar Baru'),
('15.01.16','Siulak'),
('15.01.16.2001','Siulak Gedang'),
('15.01.16.2004','Pasar Siulak Gedang'),
('15.01.16.2005','Siulak Panjang'),
('15.01.16.2006','Siulak Kecil Mudik'),
('15.01.16.2007','Koto Rendah'),
('15.01.16.2009','Lubuk Nagodang'),
('15.01.16.2010','Sungaipegeh'),
('15.01.16.2011','Sungailebuh'),
('15.01.16.2012','Koto Kapeh'),
('15.01.16.2013','Koto Beringin'),
('15.01.16.2014','Dusun Baru'),
('15.01.16.2015','Dusun Dalam'),
('15.01.16.2016','Air Terjun'),
('15.01.16.2019','Koto Aro'),
('15.01.16.2021','Koto Lebuh Tinggi'),
('15.01.16.2024','Siulak Kecil Hilir'),
('15.01.16.2025','Koto Tengah'),
('15.01.16.2028','Telago Biru'),
('15.01.16.2030','Tutung Bungkuk'),
('15.01.16.2033','Baru Sungaipegeh'),
('15.01.16.2034','Bendar Sedap'),
('15.01.16.2035','Plak Naneh'),
('15.01.16.2036','Padang Jantung'),
('15.01.16.2038','Pelak Gedang'),
('15.01.16.2039','Demong Sakti'),
('15.01.16.2040','Pasar Senen'),
('15.01.17','Depati Tujuh'),
('15.01.17.2001','Belui'),
('15.01.17.2002','Baru Kubang'),
('15.01.17.2003','Koto Panjang'),
('15.01.17.2004','Kubang Gedang'),
('15.01.17.2005','Semumu'),
('15.01.17.2006','Belui Tinggi'),
('15.01.17.2007','Koto Tuo'),
('15.01.17.2008','Koto Payang'),
('15.01.17.2009','Tebat Ijuk'),
('15.01.17.2010','Sekungkung'),
('15.01.17.2011','Simpang Belui'),
('15.01.17.2012','Koto Lanang'),
('15.01.17.2013','Ladeh'),
('15.01.17.2014','Lubuk Suli'),
('15.01.17.2015','Kayu Aho Mangkak Koto Lanang'),
('15.01.17.2016','Tambak Tinggi'),
('15.01.17.2017','Kubang Agung'),
('15.01.17.2018','Tebat Ijuk Dili'),
('15.01.17.2019','Koto Simpai Kubang'),
('15.01.17.2020','Pahlawan Belui'),
('15.01.18','Siulak Mukai'),
('15.01.18.2001','Mukai Hilir'),
('15.01.18.2002','Mukai Tengah'),
('15.01.18.2003','Mukai Mudik'),
('15.01.18.2004','Senimpik'),
('15.01.18.2005','Tebing Tinggi'),
('15.01.18.2006','Mukai Tinggi'),
('15.01.18.2007','Mukai Pintu'),
('15.01.18.2008','Sungailangkap'),
('15.01.18.2009','Pasir Jaya'),
('15.01.18.2010','Sungaikuning'),
('15.01.18.2011','Mukai Seberang'),
('15.01.18.2012','Talang Tinggi'),
('15.01.18.2013','Lubuk Tabun'),
('15.01.18.2014','Koto Lua'),
('15.01.19','Kayu Aro Barat'),
('15.01.19.2001','Batu Hampar'),
('15.01.19.2002','Sungairenah'),
('15.01.19.2003','Bedeng Delapan'),
('15.01.19.2004','Bedeng Dua'),
('15.01.19.2005','Sako Duo'),
('15.01.19.2006','Sungailintang'),
('15.01.19.2007','Kebun Baru'),
('15.01.19.2008','Patok Empat'),
('15.01.19.2009','Sungaijambu'),
('15.01.19.2010','Sungaikering'),
('15.01.19.2011','Giri Mulyo'),
('15.01.19.2012','Gununglabu'),
('15.01.19.2013','Bento'),
('15.01.19.2014','Kampung Baru'),
('15.01.19.2015','Sungaiasam'),
('15.01.19.2016','Pasar Minggu'),
('15.01.19.2017','Ensatu'),
('15.01.20','Bukit Kerman'),
('15.01.20.2001','Pasar Kerman'),
('15.01.20.2002','Lolo Gedang'),
('15.01.20.2003','Lolo Kecil'),
('15.01.20.2004','Lolo Hilir'),
('15.01.20.2005','Tanjung Syam'),
('15.01.20.2006','Talang Kemuning'),
('15.01.20.2007','Pondok'),
('15.01.20.2008','Muak'),
('15.01.20.2009','Pengasi Lama'),
('15.01.20.2010','Pulaupandan'),
('15.01.20.2011','Pulausangkar'),
('15.01.20.2012','Bintang Marak'),
('15.01.20.2013','Karang Pandan'),
('15.01.20.2014','Pengasi Baru'),
('15.01.20.2015','Muaro Lulo'),
('15.01.21','Air Hangat Barat'),
('15.01.21.2001','Koto Mebai'),
('15.01.21.2002','Baru'),
('15.01.21.2003','Air Panas'),
('15.01.21.2004','Hamparan Pugu'),
('15.01.21.2005','Pugu'),
('15.01.21.2006','Koto Mudik'),
('15.01.21.2007','Koto Tengah'),
('15.01.21.2008','Koto Datuk'),
('15.01.21.2009','Koto Dua Baru'),
('15.01.21.2010','Koto Cayo'),
('15.01.21.2011','Kecil'),
('15.01.21.2012','Air Bersih'),
('15.01.22','Tanah Cogok'),
('15.01.22.2001','Kayu Aro Ambai'),
('15.01.22.2002','Bunga Tanjung'),
('15.01.22.2003','Pondok Beringin'),
('15.01.22.2004','Semerah'),
('15.01.22.2005','Sebukar'),
('15.01.22.2006','Koto Tuo Ujung Pasir'),
('15.01.22.2007','Ujung Pasir'),
('15.01.22.2008','Koto Petai'),
('15.01.22.2009','Koto Salak'),
('15.01.22.2010','Agung Koto Iman'),
('15.01.22.2011','Koto Iman'),
('15.01.22.2012','Baru Semerah'),
('15.01.23','Danau Kerinci Barat'),
('15.01.23.2001','Pancuran Tiga'),
('15.01.23.2002','Tanjung Pauh Mudik'),
('15.01.23.2003','Bukit Pulai'),
('15.01.23.2004','Punai Merindu'),
('15.01.23.2005','Sumur Jauh'),
('15.01.23.2006','Permai Baru'),
('15.01.23.2007','Tanjung Pauh Hilir'),
('15.01.23.2008','Serumpun Pauh'),
('15.01.23.2009','Pondok Siguang'),
('15.01.23.2010','Koto Tengah'),
('15.01.23.2011','Semerap'),
('15.01.23.2012','Koto Baru Semerap'),
('15.01.23.2013','Pasar Semerap'),
('15.01.23.2014','Koto Patah'),
('15.02','Kabupaten Merangin'),
('15.02.01','Jangkat'),
('15.02.01.2001','Renah Kemumu'),
('15.02.01.2002','Tanjung Kasri'),
('15.02.01.2003','Lubuk Mentilin'),
('15.02.01.2004','Rantau Kermas'),
('15.02.01.2005','Renah Alai'),
('15.02.01.2008','Pulau Tengah'),
('15.02.01.2009','Lubuk Pungguk'),
('15.02.01.2010','Koto Renah'),
('15.02.01.2011','Muara Madras'),
('15.02.01.2023','Renah Pelaan'),
('15.02.01.2024','Koto Rawang'),
('15.02.02','Bangko'),
('15.02.02.1009','Pasar Atas'),
('15.02.02.1010','Pasar Bangko'),
('15.02.02.1011','Dusun Bangko'),
('15.02.02.1013','Pematang Kandis'),
('15.02.02.2004','Kungkai'),
('15.02.02.2008','Mudo'),
('15.02.02.2012','Langling'),
('15.02.02.2024','Sungai Kapas'),
('15.02.03','Muara Siau'),
('15.02.03.2004','Durian Rambun'),
('15.02.03.2007','Lubuk Birah'),
('15.02.03.2008','Lubuk Beringin'),
('15.02.03.2009','Rantau Macang'),
('15.02.03.2010','Peradun Temeras'),
('15.02.03.2011','Teluk Sikumbang'),
('15.02.03.2012','Muara Siau'),
('15.02.03.2013','Tiaro'),
('15.02.03.2015','Air Lago'),
('15.02.03.2016','Badak Tekurung'),
('15.02.03.2017','Rantau Bidaro'),
('15.02.03.2018','Rantau Panjang'),
('15.02.03.2021','Pulau Raman'),
('15.02.03.2024','Pasar Muara Siau'),
('15.02.03.2027','Sepantai Renah'),
('15.02.03.2028','Sungai Ulas'),
('15.02.03.2029','Rantau Bayur'),
('15.02.04','Sungai Manau'),
('15.02.04.2007','Sungai Pinang'),
('15.02.04.2008','Tiangko'),
('15.02.04.2009','Palipan'),
('15.02.04.2010','Seringat'),
('15.02.04.2011','Durian Lecah'),
('15.02.04.2015','Bukit Batu'),
('15.02.04.2016','Sungai Nilau'),
('15.02.04.2017','Sungai Manau'),
('15.02.04.2025','Benteng'),
('15.02.04.2026','Gelanggang'),
('15.02.05','Tabir'),
('15.02.05.1002','Dusun Baru'),
('15.02.05.1003','Pasar Rantau Panjang'),
('15.02.05.1005','Kampung Baruh'),
('15.02.05.1020','Mampun'),
('15.02.05.1036','Pasar Baru Rantau'),
('15.02.05.2007','Kandang'),
('15.02.05.2008','Koto Rayo'),
('15.02.05.2011','Tanjung Ilir'),
('15.02.05.2014','Beluran Panjang'),
('15.02.05.2015','Seling'),
('15.02.05.2035','Lubuk Napal'),
('15.02.06','Pamenang'),
('15.02.06.1008','Pamenang'),
('15.02.06.2004','Jelatang'),
('15.02.06.2005','Tanjung Gedang'),
('15.02.06.2006','Empang Benao'),
('15.02.06.2007','Rejo Sari'),
('15.02.06.2009','Keroya'),
('15.02.06.2010','Muara Belengo'),
('15.02.06.2011','Karang Berahi'),
('15.02.06.2012','Pauh Menang'),
('15.02.06.2013','Pematang Kancil'),
('15.02.06.2014','Tanah Abang'),
('15.02.06.2015','Sialang'),
('15.02.06.2026','Sungai Udang'),
('15.02.06.2027','Pelakar Jaya'),
('15.02.07','Tabir Ulu'),
('15.02.07.2009','Muara Jernih'),
('15.02.07.2010','Kapuk'),
('15.02.07.2011','Pulau Aro'),
('15.02.07.2012','Rantau Ngarau'),
('15.02.07.2013','Medan Baru'),
('15.02.07.2014','Muaro Seketuk'),
('15.02.08','Tabir Selatan'),
('15.02.08.2001','Sungai Sahut'),
('15.02.08.2002','Bungo Antoi'),
('15.02.08.2003','Muara Delang'),
('15.02.08.2004','Sinar Gading'),
('15.02.08.2005','Bungo Tanjung'),
('15.02.08.2006','Rawa Jaya'),
('15.02.08.2007','Gading Jaya'),
('15.02.08.2008','Mekar Jaya'),
('15.02.09','Lembah Masurai'),
('15.02.09.2001','Nilo Dingin'),
('15.02.09.2002','Tanjung Berugo'),
('15.02.09.2003','Tuo'),
('15.02.09.2004','Koto Rami'),
('15.02.09.2005','Rancan'),
('15.02.09.2006','Pasar Masurai'),
('15.02.09.2007','Rantau Jering'),
('15.02.09.2008','Tanjung Dalam'),
('15.02.09.2009','Muaro Pangi'),
('15.02.09.2010','Sungai Lalang'),
('15.02.09.2011','Talang Asal'),
('15.02.09.2012','Muara Kelukup'),
('15.02.09.2013','Muara Lengayo'),
('15.02.09.2014','Talang Paruh'),
('15.02.09.2015','Durian Mukut'),
('15.02.10','Bangko Barat'),
('15.02.10.2001','Pulau Rengas'),
('15.02.10.2002','Biuku Tanjung'),
('15.02.10.2003','Bedeng Rejo'),
('15.02.10.2004','Sungai Putih'),
('15.02.10.2005','Bukit Beringin'),
('15.02.10.2006','Pulau Rengas Ulu'),
('15.02.11','Nalo Tantan'),
('15.02.11.2001','Sungai Ulak'),
('15.02.11.2002','Aur Berduri'),
('15.02.11.2003','Telun'),
('15.02.11.2004','Nalo Gedang'),
('15.02.11.2005','Baru Nalo'),
('15.02.11.2006','Mentawak'),
('15.02.11.2007','Danau'),
('15.02.12','Batang Masumai'),
('15.02.12.2001','Lubuk Gaung'),
('15.02.12.2002','Salam Buku'),
('15.02.12.2003','Pulau Baru'),
('15.02.12.2004','Nibung'),
('15.02.12.2005','Titian Teras'),
('15.02.12.2006','Kederasan Panjang'),
('15.02.12.2007','Rantau Alai'),
('15.02.12.2008','Tambang Besi'),
('15.02.12.2009','Pelangki'),
('15.02.12.2010','Pulau Layang'),
('15.02.13','Pamenang Barat'),
('15.02.13.2001','Tanjung Lamin'),
('15.02.13.2002','Limbur Merangin'),
('15.02.13.2003','Karang Anyar'),
('15.02.13.2004','Pinang Merah'),
('15.02.13.2005','Simpang Limbur Merangin'),
('15.02.13.2006','Mampun Baru'),
('15.02.13.2007','Papit'),
('15.02.13.2008','PulauTujuh'),
('15.02.14','Tabir Ilir'),
('15.02.14.2001','Rantau Limau Manis'),
('15.02.14.2002','Ulak Makam'),
('15.02.14.2003','Air Batu'),
('15.02.14.2004','Rejo Sari'),
('15.02.14.2005','Kota Raja'),
('15.02.14.2006','Tunggul Bulin'),
('15.02.14.2007','Mekar Limau Manis'),
('15.02.15','Tabir Timur'),
('15.02.15.2001','Sungai Limau'),
('15.02.15.2002','Sungai Bulian'),
('15.02.15.2003','Sri Sembilan'),
('15.02.15.2004','Bukit Subur'),
('15.02.16','Renah Pembarap'),
('15.02.16.2001','Muaro Panco Barat'),
('15.02.16.2002','Talang Segegah'),
('15.02.16.2003','Durian Batakuk'),
('15.02.16.2004','Muara Bantan'),
('15.02.16.2005','Parit Ujung Tanjung'),
('15.02.16.2006','Guguk'),
('15.02.16.2007','Markeh'),
('15.02.16.2008','Air Batu'),
('15.02.16.2009','Marus Jaya'),
('15.02.16.2010','Renah Medan'),
('15.02.16.2011','Simpang Parit'),
('15.02.16.2012','Muaro Panco Timur'),
('15.02.17','Pangkalan Jambu'),
('15.02.17.2001','Baru Pangkalan Jambu'),
('15.02.17.2002','Bukit Perentak'),
('15.02.17.2003','Birun'),
('15.02.17.2004','Tiga Alur'),
('15.02.17.2005','Bungo Tanjung'),
('15.02.17.2006','Sungai Jering'),
('15.02.17.2007','Kampung Limo'),
('15.02.17.2008','Tanjung Mudo'),
('15.02.18','Jangkat Timur'),
('15.02.18.2001','Tanjung Mudo'),
('15.02.18.2002','Koto Teguh'),
('15.02.18.2003','Baru'),
('15.02.18.2004','Talang Tembago'),
('15.02.18.2005','Beringin Tinggi'),
('15.02.18.2006','Pematang Pauh'),
('15.02.18.2007','Rantau Suli'),
('15.02.18.2008','Gedang'),
('15.02.18.2010','Koto Baru'),
('15.02.18.2011','Tanjung Benuang'),
('15.02.18.2012','Jangkat'),
('15.02.18.2013','Tanjung Alam'),
('15.02.18.2014','Kabu'),
('15.02.18.2015','Simpang Talang Tembago'),
('15.02.19','Renah Pamenang'),
('15.02.19.2001','Meranti'),
('15.02.19.2002','Bukit Bungkul'),
('15.02.19.2003','Rasau'),
('15.02.19.2004','Lantak Seribu'),
('15.02.20','Pamenang Selatan'),
('15.02.20.2001','Tambang Emas'),
('15.02.20.2002','Tanjung Benuang'),
('15.02.20.2003','Pulau Bayur'),
('15.02.20.2004','Selango'),
('15.02.21','Margo Tabir'),
('15.02.21.2001','Tanjung Rejo'),
('15.02.21.2002','Sumber Agung'),
('15.02.21.2003','Suko Rejo'),
('15.02.21.2004','Sido Rukun'),
('15.02.21.2005','Lubuk Bumbun'),
('15.02.21.2006','Tegal Rejo'),
('15.02.22','Tabir Lintas'),
('15.02.22.2001','Tambang Baru'),
('15.02.22.2002','Sido Lego'),
('15.02.22.2003','Mensango'),
('15.02.22.2004','Koto Baru'),
('15.02.22.2005','Sido Harjo'),
('15.02.23','Tabir Barat'),
('15.02.23.2001','Muara Kibul'),
('15.02.23.2002','Tanjung Putus'),
('15.02.23.2003','Pulau Tebakar'),
('15.02.23.2004','Batang Kibul'),
('15.02.23.2005','Sungai Tabir'),
('15.02.23.2006','Telentam'),
('15.02.23.2007','Ngaol'),
('15.02.23.2008','Air Liki'),
('15.02.23.2009','Pulau Lebar'),
('15.02.23.2010','Muara Langeh'),
('15.02.23.2011','Tanjung Beringin'),
('15.02.23.2012','Baru Kibul'),
('15.02.23.2013','Ngaol Ilir'),
('15.02.23.2014','Air Liki Baru'),
('15.02.24','Tiang Pumpung'),
('15.02.24.2001','Sekancing'),
('15.02.24.2002','Sekancing Ilir'),
('15.02.24.2003','Beringin Sanggul'),
('15.02.24.2004','Baru Bukit Punjung'),
('15.02.24.2005','Rantau Limau Kapas'),
('15.02.24.2006','Baru Sungai Sakai'),
('15.03','Kabupaten Sarolangun'),
('15.03.01','Batang Asai'),
('15.03.01.2001','Tambak Ratu'),
('15.03.01.2002','Sungai Keradak'),
('15.03.01.2003','Muaro Air Dua'),
('15.03.01.2004','Simpang Narso'),
('15.03.01.2005','Batin Pengambang'),
('15.03.01.2006','Batu Empang'),
('15.03.01.2007','Rantau Panjang'),
('15.03.01.2008','P. Salak Baru'),
('15.03.01.2009','Muaro Pemuat'),
('15.03.01.2010','Lubuk Bangkar'),
('15.03.01.2011','Pekan Gedang'),
('15.03.01.2012','Raden Anom'),
('15.03.01.2013','Datuk Nan Duo'),
('15.03.01.2014','Bukit Kalimau Ulu'),
('15.03.01.2015','Sungai Bemban'),
('15.03.01.2016','Muara Cuban'),
('15.03.01.2017','Sungai Baung'),
('15.03.01.2018','Padang Jering'),
('15.03.01.2019','Kasiro'),
('15.03.01.2020','Kasiro Hilir'),
('15.03.01.2021','Bukit Berantai'),
('15.03.01.2022','Bukit Sulah'),
('15.03.01.2023','Paniban Baru'),
('15.03.02','Limun'),
('15.03.02.2005','Pulau Pandan'),
('15.03.02.2006','Temenggung'),
('15.03.02.2007','Ranggo'),
('15.03.02.2008','Panca Karya'),
('15.03.02.2009','Lubuk Bedorong'),
('15.03.02.2010','Meribung'),
('15.03.02.2011','Napal Melintang'),
('15.03.02.2012','Berkun'),
('15.03.02.2013','Mersip'),
('15.03.02.2014','Tanjung Raden'),
('15.03.02.2016','Moenti'),
('15.03.02.2017','Muara Mensao'),
('15.03.02.2018','Demang'),
('15.03.02.2021','Temalang'),
('15.03.02.2022','Muara Limun'),
('15.03.02.2023','Suka Damai'),
('15.03.03','Sarolangun'),
('15.03.03.1001','Dusun Sarolangun'),
('15.03.03.1015','Sukasari'),
('15.03.03.1016','Pasar Sarolangun'),
('15.03.03.1019','Sarolangun Kembang'),
('15.03.03.1025','Gunung Kembang'),
('15.03.03.1026','Aur Gading'),
('15.03.03.2002','Bernai'),
('15.03.03.2003','Sungai Baung'),
('15.03.03.2004','Panti'),
('15.03.03.2005','Tinting'),
('15.03.03.2006','Sungai Abang'),
('15.03.03.2013','Lidung'),
('15.03.03.2014','Ladang Panjang'),
('15.03.03.2024','Desa Baru'),
('15.03.03.2027','Ujung Tanjung'),
('15.03.03.2028','Bernai Dalam'),
('15.03.04','Pauh'),
('15.03.04.1005','Pauh'),
('15.03.04.2001','Pangidaran'),
('15.03.04.2002','Karang Mendapo'),
('15.03.04.2003','Batu Ampar'),
('15.03.04.2004','Batu Kucing'),
('15.03.04.2006','Semaran'),
('15.03.04.2007','Kasang Melintang'),
('15.03.04.2008','Pangkal Bulian'),
('15.03.04.2009','Lubuk Napal'),
('15.03.04.2010','Sepintun'),
('15.03.04.2011','Lamban Sigatal'),
('15.03.04.2020','Seko Besar'),
('15.03.04.2021','Taman Bandung'),
('15.03.04.2022','Danau Serdang'),
('15.03.05','Pelawan'),
('15.03.05.2001','Penegah'),
('15.03.05.2002','Pelawan'),
('15.03.05.2003','Pulauaro'),
('15.03.05.2004','Bukit'),
('15.03.05.2005','Lubuk Sepuh'),
('15.03.05.2006','Rantau Tenang'),
('15.03.05.2007','Muara Danau'),
('15.03.05.2013','Sungai Merah'),
('15.03.05.2016','Pematang Kulim'),
('15.03.05.2017','Batu Putih'),
('15.03.05.2019','Mekar Sari'),
('15.03.05.2021','Pasar Pelawan'),
('15.03.05.2022','Pelawan Jaya'),
('15.03.05.2023','Lubuk Sayak'),
('15.03.06','Mandiangin'),
('15.03.06.2001','Mandiangin'),
('15.03.06.2002','Rangkiling Simpang'),
('15.03.06.2003','Pemusiran'),
('15.03.06.2004','Gurun Tuo Simpang'),
('15.03.06.2005','Gurun Mudo'),
('15.03.06.2006','Gurun Tuo'),
('15.03.06.2007','Rangkiling'),
('15.03.06.2008','Mandiangin Tuo'),
('15.03.06.2009','Kertopati'),
('15.03.06.2010','Muaro Ketalo'),
('15.03.06.2011','Taman Dewa'),
('15.03.06.2012','Simpang Kertopati'),
('15.03.06.2013','Bukit Peranginan'),
('15.03.06.2020','Gurun Baru'),
('15.03.06.2021','Kute Jaye'),
('15.03.06.2022','Mandiangin Pasar'),
('15.03.06.2023','Sungai Rotan'),
('15.03.06.2028','Talang Serdang'),
('15.03.07','Air Hitam'),
('15.03.07.2001','Lubuk Jering'),
('15.03.07.2002','Jernih'),
('15.03.07.2003','Desa Baru'),
('15.03.07.2004','Semurung'),
('15.03.07.2005','Lubuk Kepayang'),
('15.03.07.2006','Pematang Kabau'),
('15.03.07.2007','Bukit Suban'),
('15.03.07.2008','Mentawak Baru'),
('15.03.07.2009','Mentawak Ulu'),
('15.03.08','Bathin VIII'),
('15.03.08.1011','Limbur Tembesi'),
('15.03.08.2001','Rantau Gedang'),
('15.03.08.2002','Penarun'),
('15.03.08.2003','Pulau Lintang'),
('15.03.08.2004','Tanjung'),
('15.03.08.2005','Bangun Jayo'),
('15.03.08.2006','Teluk kecimbung'),
('15.03.08.2007','Pulau Melako'),
('15.03.08.2008','Batu Penyabung'),
('15.03.08.2009','Tanjung Gagak'),
('15.03.08.2010','Pulau Buayo'),
('15.03.08.2012','Dusun Dalam'),
('15.03.08.2013','Muara Lati'),
('15.03.08.2014','Suka Jadi'),
('15.03.08.2015','Teluk Mancur'),
('15.03.09','Singkut'),
('15.03.09.1001','Sungai Benteng'),
('15.03.09.2002','Bukit Tigo'),
('15.03.09.2003','Sungai Gedang'),
('15.03.09.2004','Payo Lebar'),
('15.03.09.2005','Bukit Murau'),
('15.03.09.2006','Perdamaian'),
('15.03.09.2007','Pasar Singkut'),
('15.03.09.2008','Siliwangi'),
('15.03.09.2009','Simpang Nibung'),
('15.03.09.2010','Bukit Talang Mas'),
('15.03.09.2011','Bukit Bumi Raya'),
('15.03.09.2012','Argo Sari'),
('15.03.09.2013','Sendang Sari'),
('15.03.10','Cermin Nan Gedang'),
('15.03.10.2001','Kampung Tujuh'),
('15.03.10.2002','Lubuk Resam'),
('15.03.10.2003','Teluk Rendah'),
('15.03.10.2004','Teluk Tigo'),
('15.03.10.2005','Lubuk Resam Hilir'),
('15.03.10.2006','Pemuncak'),
('15.03.10.2007','Tambang Tinggi'),
('15.03.10.2008','Tendah'),
('15.03.10.2009','Sungai Keramat'),
('15.03.10.2010','Sekamis'),
('15.03.11','Mandiangin Timur'),
('15.03.11.2001','Guruh Baru'),
('15.03.11.2002','Petiduran Baru'),
('15.03.11.2003','Sungai Butang'),
('15.03.11.2004','Butang Baru'),
('15.03.11.2005','Suka Maju'),
('15.03.11.2006','Jati Baru'),
('15.03.11.2007','Jati Baru Mudo'),
('15.03.11.2008','Meranti Baru'),
('15.03.11.2009','Meranti Jaya'),
('15.03.11.2010','Jernang Baru'),
('15.04','Kabupaten Batanghari'),
('15.04.01','Mersam'),
('15.04.01.1001','Kembang Paseban'),
('15.04.01.2002','Sengkati Kecil'),
('15.04.01.2003','Sengkati Gedang'),
('15.04.01.2004','Sengkati Baru'),
('15.04.01.2005','Kembang Tanjung'),
('15.04.01.2006','Mersam'),
('15.04.01.2007','Benteng Rendah'),
('15.04.01.2008','Sungai Puar'),
('15.04.01.2009','Rantau Gedang'),
('15.04.01.2010','Pematang Gadung'),
('15.04.01.2011','Teluk Melintang'),
('15.04.01.2012','Bukit Harapan'),
('15.04.01.2013','Belanti Jaya'),
('15.04.01.2014','Tapah Sari'),
('15.04.01.2015','Bukit Kemuning'),
('15.04.01.2016','Simpang Rantau Gedang'),
('15.04.01.2017','Tanjung Putra'),
('15.04.01.2018','Sengkati Mudo'),
('15.04.02','Muara Tembesi'),
('15.04.02.1001','Kampung Baru'),
('15.04.02.1002','Pasar Muara Tembesi'),
('15.04.02.2003','Jebak'),
('15.04.02.2004','Ampelu'),
('15.04.02.2005','Rambutan Masam'),
('15.04.02.2006','Rantau Kapas Mudo'),
('15.04.02.2007','Rantau Kapas Tuo'),
('15.04.02.2008','Sungai Pulai'),
('15.04.02.2009','Pulau'),
('15.04.02.2010','Tanjung Marwo'),
('15.04.02.2011','Suka Ramai'),
('15.04.02.2012','Ampelu Mudo'),
('15.04.02.2013','Pelayangan'),
('15.04.02.2015','Pematang Lima Suku'),
('15.04.03','Muara Bulian'),
('15.04.03.1001','Muara Bulian'),
('15.04.03.1002','Teratai'),
('15.04.03.1003','Sridadi'),
('15.04.03.1004','Pasar Baru'),
('15.04.03.1005','Rengas Condong'),
('15.04.03.2006','Pasar Terusan'),
('15.04.03.2007','Simpang Terusan'),
('15.04.03.2008','Malapari'),
('15.04.03.2009','Napal Sisik'),
('15.04.03.2010','Rambahan'),
('15.04.03.2011','Olak'),
('15.04.03.2012','Muaro Singoan'),
('15.04.03.2013','Aro'),
('15.04.03.2014','Rantau Puri'),
('15.04.03.2015','Sungai Baung'),
('15.04.03.2016','Bajubang Laut'),
('15.04.03.2017','Singkawang'),
('15.04.03.2018','Tenam'),
('15.04.03.2019','Sungai Buluh'),
('15.04.03.2020','Kilangan'),
('15.04.03.2021','Pelayangan'),
('15.04.04','Batin XXIV'),
('15.04.04.1003','Durian Luncuk'),
('15.04.04.1012','Muara Jangga'),
('15.04.04.2001','Jelutih'),
('15.04.04.2002','Olak Besar'),
('15.04.04.2004','Aur Gading'),
('15.04.04.2005','Paku Aji'),
('15.04.04.2006','Hajran'),
('15.04.04.2007','Mata Gual'),
('15.04.04.2008','Jangga'),
('15.04.04.2009','Koto Boyo'),
('15.04.04.2010','Simpang Karmeo'),
('15.04.04.2011','Karmeo'),
('15.04.04.2013','Jangga Baru'),
('15.04.04.2014','Terentang Baru'),
('15.04.04.2015','Bulian Baru'),
('15.04.04.2016','Simpang Jelutih'),
('15.04.04.2017','Simpang Aur Gading'),
('15.04.05','Pemayung'),
('15.04.05.1002','Jembatan Mas'),
('15.04.05.2001','Tebing Tinggi'),
('15.04.05.2003','Serasah'),
('15.04.05.2004','Lubuk Ruso'),
('15.04.05.2005','Kuap'),
('15.04.05.2006','Senaning'),
('15.04.05.2007','Kubu Kandang'),
('15.04.05.2008','Ture'),
('15.04.05.2009','Pulau Betung'),
('15.04.05.2010','Lopak Aur'),
('15.04.05.2011','Selat'),
('15.04.05.2012','Teluk'),
('15.04.05.2013','Pulau Raman'),
('15.04.05.2014','Kaos'),
('15.04.05.2015','Simpang Kubu Kandang'),
('15.04.05.2016','Awin'),
('15.04.05.2017','Olak Rambahan'),
('15.04.05.2019','Teluk Ketapang'),
('15.04.05.2020','Kampung Pulau'),
('15.04.06','Maro Sebo Ulu'),
('15.04.06.1014','Simpang S. Rengas'),
('15.04.06.2001','Batu Sawar'),
('15.04.06.2002','Peninjauan'),
('15.04.06.2003','Teluk Leban'),
('15.04.06.2004','Kampung Baru'),
('15.04.06.2005','Rengas IX'),
('15.04.06.2006','Kembang Seri'),
('15.04.06.2007','Buluh Kasab'),
('15.04.06.2008','Tebing Tinggi'),
('15.04.06.2009','Olak Kemang'),
('15.04.06.2010','Padang Kelapo'),
('15.04.06.2011','Sungai Lingkar'),
('15.04.06.2012','Sungai Ruan Ulu'),
('15.04.06.2013','Sungai Ruan Ilir'),
('15.04.06.2015','Rawa Mekar'),
('15.04.06.2016','Mekar Sari'),
('15.04.06.2017','Kembang Seri Baru'),
('15.04.07','Bajubang'),
('15.04.07.1004','Bajubang'),
('15.04.07.2001','Bungku'),
('15.04.07.2002','Pompa Air'),
('15.04.07.2003','Ladang Peris'),
('15.04.07.2005','Penerokan'),
('15.04.07.2006','Petajen'),
('15.04.07.2007','Batin'),
('15.04.07.2008','Mekar Jaya'),
('15.04.07.2009','Sungkai'),
('15.04.07.2010','Mekar Sari Nes'),
('15.04.08','Maro Sebo Ilir'),
('15.04.08.1008','Terusan'),
('15.04.08.2001','Bulian Jaya'),
('15.04.08.2002','Tidar Kuranji'),
('15.04.08.2003','Kehidupan Baru'),
('15.04.08.2004','Bukit Sari'),
('15.04.08.2005','Karya Mukti'),
('15.04.08.2006','Terusan'),
('15.04.08.2007','Danau Embat'),
('15.05','Kabupaten Muaro Jambi'),
('15.05.01','Jambi Luar Kota'),
('15.05.01.1003','Pijoan'),
('15.05.01.2002','Sungai Bertam'),
('15.05.01.2004','Pematang Jering'),
('15.05.01.2005','Muaro Pijoan'),
('15.05.01.2006','Sungai Duren'),
('15.05.01.2007','Mendalo Darat'),
('15.05.01.2008','Rengas Bandung'),
('15.05.01.2009','Sarang Burung'),
('15.05.01.2010','Mendalo Laut'),
('15.05.01.2011','Sembubuk'),
('15.05.01.2012','Senaung'),
('15.05.01.2013','Penyengat Olak'),
('15.05.01.2014','Simpang Sungai Duren'),
('15.05.01.2015','Kedemangan'),
('15.05.01.2016','Muhajirin'),
('15.05.01.2017','Maro Sebo'),
('15.05.01.2019','Danau Sarang Elang'),
('15.05.01.2020','Simpang Limo'),
('15.05.01.2021','Mendalo Indah'),
('15.05.01.2022','Pematang Gajah'),
('15.05.02','Sekernan'),
('15.05.02.1010','Sengeti'),
('15.05.02.2001','Suak Putat'),
('15.05.02.2002','Rantau Majo'),
('15.05.02.2003','Pulau Kayu Aro'),
('15.05.02.2004','Pematang Pulai'),
('15.05.02.2005','Tan Tan'),
('15.05.02.2006','Kedotan'),
('15.05.02.2007','Keranggan'),
('15.05.02.2008','Berembang'),
('15.05.02.2009','Sekernan'),
('15.05.02.2011','Gerunggung'),
('15.05.02.2012','Tunas Baru'),
('15.05.02.2013','Bukit Baling'),
('15.05.02.2014','Tanjung Lanjut'),
('15.05.02.2015','Suko Awin Jaya'),
('15.05.02.2016','Tunas Mudo'),
('15.05.03','Kumpeh'),
('15.05.03.1008','Tanjung'),
('15.05.03.2001','Puding'),
('15.05.03.2002','Pulau Mentaro'),
('15.05.03.2003','Betung'),
('15.05.03.2004','Pematang Raman'),
('15.05.03.2005','Sungai Bungur'),
('15.05.03.2006','Seponjen'),
('15.05.03.2007','Sogo'),
('15.05.03.2009','Sungai Aur'),
('15.05.03.2010','Jebus'),
('15.05.03.2011','Gedong Karya'),
('15.05.03.2013','Rantau Panjang'),
('15.05.03.2014','Londerang'),
('15.05.03.2016','Petanang'),
('15.05.03.2017','Mekar Sari'),
('15.05.03.2018','Rondang'),
('15.05.03.2019','Maju Jaya'),
('15.05.04','Maro Sebo'),
('15.05.04.1002','Jambi Kecil'),
('15.05.04.2001','Setiris'),
('15.05.04.2003','Tanjung Katung'),
('15.05.04.2004','Jambi Tulo'),
('15.05.04.2005','Baru'),
('15.05.04.2006','Danau Lamo'),
('15.05.04.2007','Muaro Jambi'),
('15.05.04.2016','Niaso'),
('15.05.04.2017','Bakung'),
('15.05.04.2018','Danau Kedap'),
('15.05.04.2019','Mudung Darat'),
('15.05.04.2020','Lubuk Raman'),
('15.05.05','Mestong'),
('15.05.05.1009','Tempino'),
('15.05.05.2001','Tanjung Pauh Km. 32'),
('15.05.05.2002','Pelempang'),
('15.05.05.2003','Sungai Landai'),
('15.05.05.2004','Ibru'),
('15.05.05.2005','Nagasari'),
('15.05.05.2006','Sebapo'),
('15.05.05.2010','Baru'),
('15.05.05.2011','Tanjung Pauh Km. 39'),
('15.05.05.2012','Nyogan'),
('15.05.05.2015','Suka Damai'),
('15.05.05.2016','Pondok Meja'),
('15.05.05.2017','Suka Maju'),
('15.05.05.2018','Tanjung Pauh Talang Pelita'),
('15.05.05.2019','Muaro Sebapo'),
('15.05.06','Kumpeh Ulu'),
('15.05.06.2001','Pudak'),
('15.05.06.2002','Muara Kumpeh'),
('15.05.06.2003','Kota Karang'),
('15.05.06.2004','Kasang Lopak Alai'),
('15.05.06.2005','Kasang Pudak'),
('15.05.06.2008','Solok'),
('15.05.06.2009','Sakean'),
('15.05.06.2010','Lopak Alai'),
('15.05.06.2011','Tarikan'),
('15.05.06.2012','Ramin'),
('15.05.06.2013','Teluk Raya'),
('15.05.06.2014','Pemunduran'),
('15.05.06.2015','Sipin Teluk Duren'),
('15.05.06.2016','Arang Arang'),
('15.05.06.2017','Sumber Jaya'),
('15.05.06.2018','Sungai Terap'),
('15.05.06.2023','Kasang Kumpeh'),
('15.05.06.2024','Kasang Kota Karang'),
('15.05.07','Sungai Bahar'),
('15.05.07.2004','Suka Makmur'),
('15.05.07.2005','Marga Mulya'),
('15.05.07.2006','Panca Mulya'),
('15.05.07.2007','Marga Manunggal Jaya'),
('15.05.07.2012','Tanjung Harapan'),
('15.05.07.2013','Berkah'),
('15.05.07.2018','Bukit Makmur'),
('15.05.07.2021','Bukit Mas'),
('15.05.07.2025','Mekar Sari Makmur'),
('15.05.07.2033','Bakti Mulya'),
('15.05.07.2034','Panca Bakti'),
('15.05.08','Sungai Gelam'),
('15.05.08.2001','Kebon IX'),
('15.05.08.2002','Talang Belido'),
('15.05.08.2003','Talang Kerinci'),
('15.05.08.2004','Ladang Panjang'),
('15.05.08.2005','Tangkit'),
('15.05.08.2006','Tangkit Baru'),
('15.05.08.2007','Sungai Gelam'),
('15.05.08.2008','Parit'),
('15.05.08.2009','Petaling Jaya'),
('15.05.08.2010','Sumber Agung'),
('15.05.08.2011','Mingkung Jaya'),
('15.05.08.2012','Trimulya Jaya'),
('15.05.08.2013','Mekar Jaya'),
('15.05.08.2014','Sido Mukti'),
('15.05.08.2015','Gambut Jaya'),
('15.05.09','Bahar Utara'),
('15.05.09.2001','Talang Bukit'),
('15.05.09.2002','Talang Datar'),
('15.05.09.2003','Sumber Mulya'),
('15.05.09.2004','Mulya Jaya'),
('15.05.09.2005','Matra Manunggal'),
('15.05.09.2006','Bukit Mulya'),
('15.05.09.2007','Sumber Jaya'),
('15.05.09.2008','Pinang Tinggi'),
('15.05.09.2009','Markanding'),
('15.05.09.2010','Sungai Dayo'),
('15.05.09.2011','Bahar Mulya'),
('15.05.10','Bahar Selatan'),
('15.05.10.2001','Bukit Subur'),
('15.05.10.2002','Tri Jaya'),
('15.05.10.2003','Mekar Jaya'),
('15.05.10.2004','Ujung Tanjung'),
('15.05.10.2005','Tanjung Baru'),
('15.05.10.2006','Tanjung Mulia'),
('15.05.10.2007','Adipura Kencana'),
('15.05.10.2008','Bukit Jaya'),
('15.05.10.2009','Tanjung Sari'),
('15.05.10.2010','Tanjung Lebar'),
('15.05.11','Taman Rajo'),
('15.05.11.2001','Kunangan'),
('15.05.11.2002','Talang Duku'),
('15.05.11.2003','Tebat Patah'),
('15.05.11.2004','Kemingking Dalam'),
('15.05.11.2005','Teluk Jambu'),
('15.05.11.2006','Dusun Mudo'),
('15.05.11.2007','Sekumbung'),
('15.05.11.2008','Kemingking Luar'),
('15.05.11.2009','Rukam'),
('15.05.11.2010','Manis Mato'),
('15.06','Kabupaten Tanjung Jabung Barat'),
('15.06.01','Tungkal Ulu'),
('15.06.01.1005','Pelabuhan Dagang'),
('15.06.01.2001','Badang'),
('15.06.01.2002','Tanjung Tayas'),
('15.06.01.2003','Kuala Dasal'),
('15.06.01.2004','Pematang Pauh'),
('15.06.01.2006','Taman Raja'),
('15.06.01.2017','Brasau'),
('15.06.01.2019','Gemuruh'),
('15.06.01.2020','Pematang Tembesu'),
('15.06.01.2021','Badang Sepakat'),
('15.06.02','Tungkal Ilir'),
('15.06.02.1004','Tungkal Empat Kota'),
('15.06.02.1005','Tungkal III'),
('15.06.02.1006','Tungkal Harapan'),
('15.06.02.1007','Tungkal II'),
('15.06.02.1015','Kampung Nelayan'),
('15.06.02.1016','Patunas'),
('15.06.02.1017','Sriwijaya'),
('15.06.02.1018','Sungainibung'),
('15.06.02.2003','Tungkal I'),
('15.06.02.2014','Teluk Sialang'),
('15.06.03','Pengabuan'),
('15.06.03.1001','Teluknilau'),
('15.06.03.2006','Parit Pudin'),
('15.06.03.2007','Sungai Serindit'),
('15.06.03.2008','Mekar Jati'),
('15.06.03.2012','Sungai Pampang'),
('15.06.03.2013','Parit Sidang'),
('15.06.03.2014','Sungai Jering'),
('15.06.03.2015','Parit Bilal'),
('15.06.03.2016','Suak Samin'),
('15.06.03.2017','Sungai Baung'),
('15.06.03.2018','Karya Maju'),
('15.06.03.2019','Sungai Raya'),
('15.06.03.2020','Pasar Senin'),
('15.06.04','Betara'),
('15.06.04.1007','Mekar Jaya'),
('15.06.04.2001','Pematang Lumut'),
('15.06.04.2008','Makmur Jaya'),
('15.06.04.2009','Serdang Jaya'),
('15.06.04.2010','Terjun Gajah'),
('15.06.04.2011','Lubuk Terentang'),
('15.06.04.2012','Pematang Buluh'),
('15.06.04.2013','Muntialo'),
('15.06.04.2014','Teluk Kulbi'),
('15.06.04.2015','Bunga Tanjung'),
('15.06.04.2016','Sungai Terap'),
('15.06.04.2017','Mandala Jaya'),
('15.06.05','Merlung'),
('15.06.05.1007','Merlung'),
('15.06.05.2005','Penyabungan'),
('15.06.05.2006','Lubuk Terap'),
('15.06.05.2008','Tanjung Paku'),
('15.06.05.2012','Tanjung Benanak'),
('15.06.05.2013','Bukit Harapan'),
('15.06.05.2014','Adi Purwa'),
('15.06.05.2018','Pinang Gading'),
('15.06.05.2020','Merlung'),
('15.06.05.2021','Tanjung Makmur'),
('15.06.06','Tebing Tinggi'),
('15.06.06.1001','Tebing Tinggi'),
('15.06.06.2002','Purwodadi'),
('15.06.06.2003','Suka Damai'),
('15.06.06.2004','Adi Jaya'),
('15.06.06.2005','Kelagian'),
('15.06.06.2006','Teluk Pengkah'),
('15.06.06.2007','Talang Makmur'),
('15.06.06.2008','Sungai Keruh'),
('15.06.06.2009','Dataran Kempas'),
('15.06.06.2010','Delima'),
('15.06.07','Batang Asam'),
('15.06.07.1001','Dusun Kebun'),
('15.06.07.2002','Sri Agung'),
('15.06.07.2003','Suban'),
('15.06.07.2004','Tanjung Bojo'),
('15.06.07.2005','Kampung Baru'),
('15.06.07.2006','Lubuk Bernai'),
('15.06.07.2007','Rawa Medang'),
('15.06.07.2008','Sungai Penoban'),
('15.06.07.2009','Rawang Kempas'),
('15.06.07.2010','Lubuk Lawas'),
('15.06.07.2011','Sungai Badar'),
('15.06.08','Renah Mendaluh'),
('15.06.08.1001','Lubuk Kambing'),
('15.06.08.2002','Pulau Pauh'),
('15.06.08.2003','Rantau Benar'),
('15.06.08.2004','Lampisi'),
('15.06.08.2005','Cinta Damai'),
('15.06.08.2006','Sungai Rotan'),
('15.06.08.2007','Muara Danau'),
('15.06.08.2008','Tanah Tumbuh'),
('15.06.08.2009','Sungai Paur'),
('15.06.08.2010','Bukit Bakar'),
('15.06.09','Muara Papalik'),
('15.06.09.1001','Rantau Badak'),
('15.06.09.2002','Dusun Mudo'),
('15.06.09.2003','Intan Jaya'),
('15.06.09.2004','Bukit Indah'),
('15.06.09.2005','Kemang Manis'),
('15.06.09.2006','Rantau Badak Lamo'),
('15.06.09.2007','Lubuk Sebontan'),
('15.06.09.2008','Sungai Papauh'),
('15.06.09.2009','Sungai Muluk'),
('15.06.09.2010','Pematang Balam'),
('15.06.10','Seberang Kota'),
('15.06.10.1001','Tungkal V'),
('15.06.10.2002','Tungkal IV Desa'),
('15.06.10.2003','Kuala Baru'),
('15.06.10.2004','Teluk Pulai Raya'),
('15.06.10.2005','Mekar Alam'),
('15.06.10.2006','Harapan Jaya'),
('15.06.10.2007','Kuala Kahar'),
('15.06.10.2008','Muara Seberang'),
('15.06.11','Bram Itam'),
('15.06.11.1001','Bram Itam Kiri'),
('15.06.11.2002','Bram Itam Kanan'),
('15.06.11.2003','Tanjung Senjulang'),
('15.06.11.2004','Pembengis'),
('15.06.11.2005','Bram Itam Raya'),
('15.06.11.2006','Pantai Gading'),
('15.06.11.2007','Jati Emas'),
('15.06.11.2008','Kemuning'),
('15.06.11.2009','Mekar Tanjung'),
('15.06.11.2010','Semau'),
('15.06.12','Kuala Betara'),
('15.06.12.1001','Betara Kiri'),
('15.06.12.2002','Sungai Dualap'),
('15.06.12.2003','Betara Kanan'),
('15.06.12.2004','Sungai Gebar'),
('15.06.12.2005','Dataran Pinang'),
('15.06.12.2006','Tanjung Pasir'),
('15.06.12.2007','Sungai Gebar Barat'),
('15.06.12.2008','Sungai Dungun'),
('15.06.12.2009','Kuala Indah'),
('15.06.12.2010','Suak Labu'),
('15.06.13','Senyerang'),
('15.06.13.1001','Senyerang'),
('15.06.13.2002','Sungai Kayu Aro'),
('15.06.13.2003','Teluk Ketapang'),
('15.06.13.2004','Sungai Rambai'),
('15.06.13.2005','Margo Rukun'),
('15.06.13.2006','Kempas Jaya'),
('15.06.13.2007','Lumahan'),
('15.06.13.2008','Sungai Landak'),
('15.06.13.2009','Sungsang'),
('15.06.13.2010','Sungai Kepayang'),
('15.07','Kabupaten Tanjung Jabung Timur'),
('15.07.01','Muara Sabak Timur'),
('15.07.01.1010','Muara Sabak Ilir'),
('15.07.01.1013','Muara Sabak Ulu'),
('15.07.01.2001','Alang-Alang'),
('15.07.01.2002','Lambur'),
('15.07.01.2004','Simbur Naik'),
('15.07.01.2011','Lambur I'),
('15.07.01.2012','Lambur II'),
('15.07.01.2014','Kota Raja'),
('15.07.01.2015','Siau Dalam'),
('15.07.01.2016','Sungai Ular'),
('15.07.01.2017','Kota Harapan'),
('15.07.01.2018','Kuala Simbur'),
('15.07.02','Nipah Panjang'),
('15.07.02.1001','Nipah Panjang I'),
('15.07.02.1002','Nipah Panjang II'),
('15.07.02.2003','Simpang Jelita'),
('15.07.02.2004','Simpang Datuk'),
('15.07.02.2005','Teluk Kijing'),
('15.07.02.2006','Sungai Raya'),
('15.07.02.2007','Pemusiran'),
('15.07.02.2008','Sungai Tering'),
('15.07.02.2009','Sungai Jeruk'),
('15.07.02.2010','Bunga Tanjung'),
('15.07.03','Mendahara'),
('15.07.03.1002','Mendahara Ilir'),
('15.07.03.2001','Pangkal Duri'),
('15.07.03.2003','Mendahara Tengah'),
('15.07.03.2007','Lagan Ilir'),
('15.07.03.2014','Sinar Kalimantan'),
('15.07.03.2015','Sungai Tawar'),
('15.07.03.2016','Bakti Idaman'),
('15.07.03.2017','Merbau'),
('15.07.03.2018','Pangkal Duri Ilir'),
('15.07.04','Rantau Rasau'),
('15.07.04.1006','Bandar Jaya'),
('15.07.04.2004','Rantau Rasau I'),
('15.07.04.2005','Rantau Rasau II'),
('15.07.04.2007','Harapan Makmur'),
('15.07.04.2008','Bangun Karya'),
('15.07.04.2009','Rantau Jaya'),
('15.07.04.2011','Sungai Dusun'),
('15.07.04.2013','Karya Bakti'),
('15.07.04.2014','Marga Mulya'),
('15.07.04.2015','Pematang Mayan'),
('15.07.04.2016','Tri Mulyo'),
('15.07.05','Sadu'),
('15.07.05.1005','Sungai Lokan'),
('15.07.05.2001','Sungai Sayang'),
('15.07.05.2002','Air Hitam Laut'),
('15.07.05.2003','Sungai Jambat'),
('15.07.05.2004','Sungai Itik'),
('15.07.05.2006','Sungai Benuh'),
('15.07.05.2007','Sungai Cemara'),
('15.07.05.2008','Remau Baku Tuo'),
('15.07.05.2009','Labuhan Pering'),
('15.07.06','Dendang'),
('15.07.06.1006','Rantau Indah'),
('15.07.06.2003','Kuala Dendang'),
('15.07.06.2004','Koto Kandis Dendang'),
('15.07.06.2005','Koto Kandis'),
('15.07.06.2007','Sido Mukti'),
('15.07.06.2008','Catur Rahayu'),
('15.07.06.2009','Jati Mulyo'),
('15.07.07','Muara Sabak Barat'),
('15.07.07.1001','Kampung Singkep'),
('15.07.07.1002','Nibung Putih'),
('15.07.07.1003','Rano'),
('15.07.07.1004','Talang Babat'),
('15.07.07.1005','Parit Culum I'),
('15.07.07.1006','Parit Culum II'),
('15.07.07.1007','Teluk Dawan'),
('15.07.08','Kuala Jambi'),
('15.07.08.1001','Kampung Laut'),
('15.07.08.1002','Tanjung Solok'),
('15.07.08.2003','Teluk Majelis'),
('15.07.08.2004','Kuala Lagan'),
('15.07.08.2005','Majelis Hidayah'),
('15.07.08.2006','Manunggal Makmur'),
('15.07.09','Mendahara Ulu'),
('15.07.09.1001','Simpang Tuan'),
('15.07.09.2002','Pematang Rahim'),
('15.07.09.2003','Sungai Toman'),
('15.07.09.2004','Bukit Tempurung'),
('15.07.09.2005','Sinar Wajo'),
('15.07.09.2006','Sungai Beras'),
('15.07.09.2007','Mencolok'),
('15.07.10','Geragai'),
('15.07.10.1010','Pandan Jaya'),
('15.07.10.2001','Lagan Ulu'),
('15.07.10.2002','Lagan Tengah'),
('15.07.10.2004','Pandan Makmur'),
('15.07.10.2005','Pandan Lagan'),
('15.07.10.2006','Suka Maju'),
('15.07.10.2007','Kota Baru'),
('15.07.10.2008','Rantau Karya'),
('15.07.10.2009','Pandan Sejahtera'),
('15.07.11','Berbak'),
('15.07.11.1001','Simpang'),
('15.07.11.2002','Rantau Rasau'),
('15.07.11.2003','Rantau Makmur'),
('15.07.11.2004','Sungai Rambut'),
('15.07.11.2005','Rawasari'),
('15.07.11.2006','Telaga Limo'),
('15.08','Kabupaten Bungo'),
('15.08.01','Tanah Tumbuh'),
('15.08.01.2001','Pedukun'),
('15.08.01.2002','Lubuk Niur'),
('15.08.01.2003','Teluk Kecimbung'),
('15.08.01.2004','Tanah Tumbuh'),
('15.08.01.2005','Rambah'),
('15.08.01.2006','Tebing Tinggi Uleh'),
('15.08.01.2007','Bukit Kemang'),
('15.08.01.2008','Panjang'),
('15.08.01.2009','Perenti Luweh'),
('15.08.01.2015','Renah Jelmu'),
('15.08.01.2016','Koto Jayo'),
('15.08.02','Rantau Pandan'),
('15.08.02.2001','Rantau Duku'),
('15.08.02.2002','Talang Sungai Bungo'),
('15.08.02.2003','Rantau Pandan'),
('15.08.02.2004','Leban'),
('15.08.02.2005','Lubuk Kayu Aro'),
('15.08.02.2015','Lubuk Mayan'),
('15.08.03','Pasar Muaro Bungo'),
('15.08.03.1006','Tanjung Gedang'),
('15.08.03.1007','Bungo Timur'),
('15.08.03.1008','Bungo Barat'),
('15.08.03.1022','Jaya Setia'),
('15.08.03.1023','Batang Bungo'),
('15.08.04','Jujuhan'),
('15.08.04.2001','Tanjung Belit'),
('15.08.04.2002','Rantau Ikil'),
('15.08.04.2003','Pulau Jelmu'),
('15.08.04.2004','Sirih Sekapur'),
('15.08.04.2005','Ujung Tanjung'),
('15.08.04.2007','Jumbak'),
('15.08.04.2009','Rantau Panjang'),
('15.08.04.2013','Talang Pamesun'),
('15.08.04.2014','Baru Balai Panjang'),
('15.08.04.2015','Sirih Sekapur Perkembangan'),
('15.08.05','Tanah Sepenggal'),
('15.08.05.2001','Teluk Pandak'),
('15.08.05.2003','Empelu'),
('15.08.05.2006','Pasar Lubuk Landai'),
('15.08.05.2007','Sungai Gambir'),
('15.08.05.2009','Candi'),
('15.08.05.2010','Tanjung'),
('15.08.05.2012','Tanah Bekali'),
('15.08.05.2015','Telentam'),
('15.08.05.2017','Pasar Rantau Embacang'),
('15.08.05.2019','Tenam'),
('15.08.06','Pelepat'),
('15.08.06.2001','Baru Pelepat'),
('15.08.06.2002','Dwi Karya Bakti'),
('15.08.06.2003','Rantau Keloyang'),
('15.08.06.2004','Balai Jaya'),
('15.08.06.2005','Rantel'),
('15.08.06.2006','Senamat'),
('15.08.06.2007','Sungai Beringin'),
('15.08.06.2008','Sungai Gurun'),
('15.08.06.2009','Batu Kerbau'),
('15.08.06.2010','Gapura Suci'),
('15.08.06.2011','Mulya Bakti'),
('15.08.06.2012','Mulya Jaya'),
('15.08.06.2013','Cilodang'),
('15.08.06.2014','Bukit Telago'),
('15.08.06.2015','Sekampil'),
('15.08.07','Limbur Lubuk Mengkuang'),
('15.08.07.2001','Tanjung Bungo'),
('15.08.07.2002','Tuo Lbk. Mengkuang'),
('15.08.07.2003','Pauh Agung'),
('15.08.07.2004','Tuo Limbur'),
('15.08.07.2005','Renah Sungai Besar'),
('15.08.07.2006','Muaro Tebo Pandak'),
('15.08.07.2007','Rantau Tipu'),
('15.08.07.2008','Baru Lbk. Mengkuang'),
('15.08.07.2009','Lbk. Tanah Terban'),
('15.08.07.2010','Pemunyian'),
('15.08.07.2011','Renah Sungai Ipuh'),
('15.08.07.2012','Tebo Jaya'),
('15.08.07.2013','Sekar Mengkuang'),
('15.08.07.2014','Limbur Baru'),
('15.08.08','Muko-muko Bathin VII'),
('15.08.08.2001','Mangun Jayo'),
('15.08.08.2002','Tanjung Agung'),
('15.08.08.2003','Tebat'),
('15.08.08.2004','Baru Pusat Jalo'),
('15.08.08.2005','Bedaro'),
('15.08.08.2006','Tebing Tinggi'),
('15.08.08.2007','Datar'),
('15.08.08.2008','Suka Jaya'),
('15.08.08.2009','Pekan Jum''at'),
('15.08.09','Pelepat Ilir'),
('15.08.09.2001','Koto Jayo'),
('15.08.09.2002','Danau'),
('15.08.09.2003','Muara Kuamang'),
('15.08.09.2004','Lubuk'),
('15.08.09.2005','Purwosari'),
('15.08.09.2006','Lembah Kuamang'),
('15.08.09.2007','Sumber Harapan'),
('15.08.09.2008','Daya Murni'),
('15.08.09.2009','Sumber Mulya'),
('15.08.09.2010','Maju Jaya'),
('15.08.09.2011','Tirta Mulya'),
('15.08.09.2012','Lingga Kuamang'),
('15.08.09.2013','Bangun Harjo'),
('15.08.09.2014','Kuning gading'),
('15.08.09.2015','Kuamang Jaya'),
('15.08.09.2016','Karya Harapan Mukti'),
('15.08.09.2017','Padang Palangeh'),
('15.08.10','Batin II Babeko'),
('15.08.10.2001','Tanjung Menanti'),
('15.08.10.2002','Babeko'),
('15.08.10.2003','Sepunggur'),
('15.08.10.2004','Simpang Bebeko'),
('15.08.10.2005','Suka Makmur'),
('15.08.10.2006','Tuo Sepunggur'),
('15.08.11','Bathin III'),
('15.08.11.1001','Manggis'),
('15.08.11.1003','Bungo Taman Agung'),
('15.08.11.1004','Sungai Binjai'),
('15.08.11.2002','Lubuk Benteng'),
('15.08.11.2005','Air Gemuruh'),
('15.08.11.2006','Purwo Bakti'),
('15.08.11.2007','Sarana Jaya'),
('15.08.11.2008','Teluk Panjang'),
('15.08.12','Bungo Dani'),
('15.08.12.1001','Sungai Pinang'),
('15.08.12.1002','Sungai Kerjan'),
('15.08.12.2003','Talang Pantai'),
('15.08.12.2004','Sungai Arang'),
('15.08.12.2005','Pulau Pekan'),
('15.08.13','Rimbo Tengah'),
('15.08.13.1001','Pasir Putih'),
('15.08.13.1002','Cadika'),
('15.08.13.2003','Sungai Mengkuang'),
('15.08.13.2004','Sungai Buluh'),
('15.08.14','Bathin III Ulu'),
('15.08.14.2001','Muara Buat'),
('15.08.14.2002','Buat'),
('15.08.14.2003','Laman Panjang'),
('15.08.14.2004','Karak Apung'),
('15.08.14.2005','Timbolasi'),
('15.08.14.2006','Senamat Ulu'),
('15.08.14.2007','Aur Cino'),
('15.08.14.2008','Lubuk Beringin'),
('15.08.14.2009','Sungai Telang'),
('15.08.15','Bathin II Pelayang'),
('15.08.15.2001','Pelayang'),
('15.08.15.2002','Peninjau'),
('15.08.15.2003','Talang Silungko'),
('15.08.15.2004','Pulau Kerakap'),
('15.08.15.2005','Seberang Jaya'),
('15.08.16','Jujuhan Ilir'),
('15.08.16.2001','Tepian Danto'),
('15.08.16.2002','Aur Gading'),
('15.08.16.2003','Pulau Batu'),
('15.08.16.2004','Sari Mulya'),
('15.08.16.2005','Bukit Sari'),
('15.08.16.2006','Lubuk Tenam'),
('15.08.16.2007','Kuamang'),
('15.08.17','Tanah Sepenggal Lintas'),
('15.08.17.2001','Sungai Mancur'),
('15.08.17.2002','Tanah Periuk'),
('15.08.17.2003','Lubuk Landai'),
('15.08.17.2004','Rantau Embacang'),
('15.08.17.2005','Tebing Tinggi'),
('15.08.17.2006','Embacang Gedang'),
('15.08.17.2007','Sungai Puri'),
('15.08.17.2008','Paku Aji'),
('15.08.17.2009','Pematang Panjang'),
('15.08.17.2010','Sungai Lilin'),
('15.08.17.2011','Sungai Tembang'),
('15.08.17.2012','Rantau Makmur'),
('15.09','Kabupaten Tebo'),
('15.09.01','Tebo Tengah'),
('15.09.01.1001','Muara Tebo'),
('15.09.01.1002','Tebing Tinggi'),
('15.09.01.2003','Bedaro Rampak'),
('15.09.01.2004','Mangun Jayo'),
('15.09.01.2005','Teluk Pandak'),
('15.09.01.2006','Tengah Ulu'),
('15.09.01.2007','Semabu'),
('15.09.01.2008','Kandang'),
('15.09.01.2009','Pelayang'),
('15.09.01.2010','Sungai Keruh'),
('15.09.01.2011','Aburan Batang Tebo'),
('15.09.01.2012','Sungai Alai'),
('15.09.02','Tebo Ilir'),
('15.09.02.1001','Sungai Bengkal'),
('15.09.02.2002','Sungai Aro'),
('15.09.02.2003','Teluk Rendah Pasar'),
('15.09.02.2004','Teluk Rendah Ulu'),
('15.09.02.2005','Teluk Rendah Ilir'),
('15.09.02.2008','Tuo Ilir'),
('15.09.02.2011','Betung Bedarah Timur'),
('15.09.02.2012','Betung Bedarah Barat'),
('15.09.02.2014','Kunangan'),
('15.09.02.2015','Muara ketalo'),
('15.09.02.2017','Sungai Bengkal Barat'),
('15.09.02.2018','Kemantan'),
('15.09.03','Tebo Ulu'),
('15.09.03.1001','Pulau Temiang'),
('15.09.03.2002','Sungai Rambai'),
('15.09.03.2003','Pagar Puding'),
('15.09.03.2004','Teluk Kembang Jambu'),
('15.09.03.2005','Teluk Kasai Rambahan'),
('15.09.03.2006','Rantau langkap'),
('15.09.03.2007','Tanjung Aur'),
('15.09.03.2008','Bungo Tanjung'),
('15.09.03.2009','Pulau Panjang'),
('15.09.03.2010','Lubuk Benteng'),
('15.09.03.2011','Teluk Kuali'),
('15.09.03.2012','Melako Intan'),
('15.09.03.2015','Jambu'),
('15.09.03.2016','Pulau Jelmu'),
('15.09.03.2017','Medan Seri Rambahan'),
('15.09.03.2018','Ulak Banjir Rambahan'),
('15.09.03.2019','Teluk Pandan Rambahan'),
('15.09.04','Rimbo Bujang'),
('15.09.04.1001','Wirotho Agung'),
('15.09.04.1009','Sarana Agung'),
('15.09.04.1010','Mandiri Agung'),
('15.09.04.2002','Perintis'),
('15.09.04.2003','Rimbo Mulyo'),
('15.09.04.2004','Purwo Harjo'),
('15.09.04.2005','Tegal Arum'),
('15.09.04.2006','Tirta Kencana'),
('15.09.04.2007','Sapta Mulia'),
('15.09.04.2008','Pematang Sapat'),
('15.09.04.2011','Mekar Kencana'),
('15.09.04.2012','Purwo Dadi'),
('15.09.04.2013','Tegal Asri'),
('15.09.04.2014','Perintis Jaya'),
('15.09.04.2015','Perintis Makmur'),
('15.09.04.2016','Jaya Mulya'),
('15.09.05','Sumay'),
('15.09.05.2001','Teluk Singkawang'),
('15.09.05.2002','Lembak Bungur'),
('15.09.05.2003','Teluk Langkap'),
('15.09.05.2004','Tambun Arang'),
('15.09.05.2005','Punti Kalo'),
('15.09.05.2006','Jati Belarik'),
('15.09.05.2007','Tuo Sumay'),
('15.09.05.2008','Teriti'),
('15.09.05.2009','Suo-Suo'),
('15.09.05.2010','Muara Sekalo'),
('15.09.05.2011','Semambu'),
('15.09.05.2012','Pemayungan'),
('15.09.06','VII Koto'),
('15.09.06.2001','Tanjung Pucuk Jambi'),
('15.09.06.2002','Kuamang'),
('15.09.06.2003','Teluk Kayu Putih'),
('15.09.06.2004','Sungai Abang'),
('15.09.06.2005','Aur Cino'),
('15.09.06.2007','Muara Niro'),
('15.09.06.2013','Teluk Lancang'),
('15.09.06.2014','Dusun Baru'),
('15.09.06.2015','Tabun'),
('15.09.06.2016','Muara Tabun'),
('15.09.07','Rimbo Ulu'),
('15.09.07.2001','Suka Damai'),
('15.09.07.2002','Wana Reja'),
('15.09.07.2003','Sumber Sari'),
('15.09.07.2004','Sido Rukun'),
('15.09.07.2005','Sungai Pandan'),
('15.09.07.2006','Suka Maju'),
('15.09.07.2007','Mekar Sari'),
('15.09.07.2008','Wana Arum'),
('15.09.07.2009','Wana Mulya'),
('15.09.07.2010','Damai Makmur'),
('15.09.07.2011','Suka Jaya'),
('15.09.07.2012','Sido Mulyo'),
('15.09.08','Rimbo Ilir'),
('15.09.08.2001','Giriwinangun'),
('15.09.08.2002','Sidorejo'),
('15.09.08.2003','Pulung Rejo'),
('15.09.08.2004','Karang Dadi'),
('15.09.08.2005','Giri Purno'),
('15.09.08.2006','Sumber Agung'),
('15.09.08.2007','Sari Mulya'),
('15.09.08.2008','Sepakat Bersatu'),
('15.09.08.2009','Rantau Kembang'),
('15.09.08.2010','Giri Mulyo'),
('15.09.09','Tengah Ilir'),
('15.09.09.2001','Muara Kilis'),
('15.09.09.2002','Penapalan'),
('15.09.09.2003','Mengupeh'),
('15.09.09.2004','Rantau Api'),
('15.09.09.2005','Lubuk Mandarsah'),
('15.09.09.2006','Lubuk Mandarsah Ulu'),
('15.09.10','Serai Serumpun'),
('15.09.10.2001','Pinang Belai'),
('15.09.10.2002','Sekutur Jaya'),
('15.09.10.2003','Bukit Pemuatan'),
('15.09.10.2004','Napal Putih'),
('15.09.10.2005','Sako Makmur'),
('15.09.10.2006','Pagar Puding Lamo'),
('15.09.10.2007','Tanjung Aur Seberang'),
('15.09.10.2008','Teluk Melintang'),
('15.09.11','VII Koto Ilir'),
('15.09.11.2001','Teluk Kepayang Pulau Indah'),
('15.09.11.2002','Balai Rajo'),
('15.09.11.2003','Cermin Alam'),
('15.09.11.2004','Sungai Karang'),
('15.09.11.2005','Paseban'),
('15.09.11.2006','Pasir Mayang'),
('15.09.12','Muara Tabir'),
('15.09.12.2001','Tanah Garo'),
('15.09.12.2002','Pintas Tuo'),
('15.09.12.2003','Embacang Gedang'),
('15.09.12.2004','Bangun Seranten'),
('15.09.12.2005','Tambun Arang'),
('15.09.12.2006','Sungai Jernih'),
('15.09.12.2007','Bangko Pintas'),
('15.09.12.2008','Olak Kemang'),
('15.71','Kota Jambi'),
('15.71.01','Telanaipura'),
('15.71.01.1001','Simpang IV Sipin'),
('15.71.01.1002','Buluran Kenali'),
('15.71.01.1003','Teluk Kenali'),
('15.71.01.1004','Telanaipura'),
('15.71.01.1010','Penyengat Rendah'),
('15.71.01.1011','Pematang Sulur'),
('15.71.01.1012','Aur Kenali'),
('15.71.02','Jambi Selatan'),
('15.71.02.1002','Pasir Putih'),
('15.71.02.1003','Tambak Sari'),
('15.71.02.1004','Thehok'),
('15.71.02.1005','Wijaya Pura'),
('15.71.02.1006','Pakuan Baru'),
('15.71.03','Jambi Timur'),
('15.71.03.1001','Sijenjang'),
('15.71.03.1002','Kasang Jaya'),
('15.71.03.1003','Talang Banjar'),
('15.71.03.1004','Budiman'),
('15.71.03.1005','Sulanjana'),
('15.71.03.1006','Kasang'),
('15.71.03.1007','Tanjung Sari'),
('15.71.03.1008','Rajawali'),
('15.71.03.1010','Tanjung Pinang'),
('15.71.04','Pasar Jambi'),
('15.71.04.1001','Beringin'),
('15.71.04.1002','Orang Kayo Hitam'),
('15.71.04.1003','Pasar Jambi'),
('15.71.04.1004','Sungai Asam'),
('15.71.05','Pelayangan'),
('15.71.05.1001','Arab Melayu'),
('15.71.05.1002','Mudung Laut'),
('15.71.05.1003','Jelmu'),
('15.71.05.1004','Tengah'),
('15.71.05.1005','Tahtul Yaman'),
('15.71.05.1006','Tanjung Johor'),
('15.71.06','Danau Teluk'),
('15.71.06.1001','Pasir Panjang'),
('15.71.06.1002','Tanjung Raden'),
('15.71.06.1003','Olak Kemang'),
('15.71.06.1004','Tanjung Pasir'),
('15.71.06.1005','Ulu Gedong'),
('15.71.07','Kota Baru'),
('15.71.07.1001','Suka Karya'),
('15.71.07.1002','Simpang III Sipin'),
('15.71.07.1004','Paal Lima'),
('15.71.07.1005','Kenali Asam Bawah'),
('15.71.07.1006','Kenali Asam Atas'),
('15.71.07.1011','Talang Gulo'),
('15.71.07.1012','Kenali Asam'),
('15.71.08','Jelutung'),
('15.71.08.1001','Talang Jauh'),
('15.71.08.1002','Cempaka Putih'),
('15.71.08.1003','Kebun Handil'),
('15.71.08.1004','Lebak Bandung'),
('15.71.08.1005','Payo Lebar'),
('15.71.08.1006','Jelutung'),
('15.71.08.1007','Handil Jaya'),
('15.71.09','Alam Barajo'),
('15.71.09.1001','Kenali Besar'),
('15.71.09.1002','Rawa Sari'),
('15.71.09.1003','Mayang Mangurai'),
('15.71.09.1004','Bagan Pete'),
('15.71.09.1005','Beliung'),
('15.71.09.1006','Simpang Rimbo'),
('15.71.09.1007','Pinang Merah'),
('15.71.10','Danau Sipin'),
('15.71.10.1001','Sungai Putri'),
('15.71.10.1002','Murni'),
('15.71.10.1003','Legok'),
('15.71.10.1004','Selamat'),
('15.71.10.1005','Solok Sipin'),
('15.71.11','Paal Merah'),
('15.71.11.1001','Talang Bakung'),
('15.71.11.1002','Payo Selincah'),
('15.71.11.1003','Eka Jaya'),
('15.71.11.1004','Lingkar Selatan'),
('15.71.11.1005','Paal Merah'),
('15.71.11.1006','Bakung Jaya'),
('15.72','Kota Sungai Penuh'),
('15.72.01','Sungai Penuh'),
('15.72.01.1001','Sungai Penuh'),
('15.72.01.1003','Pasar Sungai Penuh'),
('15.72.01.2004','Pasar Baru'),
('15.72.01.2006','Gedang'),
('15.72.01.2014','Amar Sakti'),
('15.72.02','Pesisir Bukit'),
('15.72.02.2001','Koto Renah'),
('15.72.02.2002','Koto Keras'),
('15.72.02.2003','Koto Bento'),
('15.72.02.2004','Koto Lolo'),
('15.72.02.2005','Koto Tengah'),
('15.72.02.2008','Koto Duo'),
('15.72.02.2010','Sungai Liuk'),
('15.72.02.2011','Seberang'),
('15.72.02.2015','Sumur Gedang'),
('15.72.03','Hamparan Rawang'),
('15.72.03.2001','Kampung Diilir'),
('15.72.03.2002','Koto Beringin'),
('15.72.03.2003','Maliki Air'),
('15.72.03.2004','Tanjung'),
('15.72.03.2005','Koto Teluk'),
('15.72.03.2006','Kampung Dalam'),
('15.72.03.2007','Simpang Tiga Rawang'),
('15.72.03.2008','Larik Kemahan'),
('15.72.03.2009','Dusun Diilir'),
('15.72.03.2010','Paling Serumpun'),
('15.72.03.2011','Koto Dian'),
('15.72.03.2012','Tanjung Muda'),
('15.72.03.2013','Cempaka'),
('15.72.04','Tanah Kampung'),
('15.72.04.2001','Baru Debai'),
('15.72.04.2002','Pendung Hiang'),
('15.72.04.2003','Koto Pudung'),
('15.72.04.2004','Koto Dumo'),
('15.72.04.2005','Sembilan'),
('15.72.04.2006','Koto Tuo'),
('15.72.04.2007','Koto Panap'),
('15.72.04.2008','Koto Tengah'),
('15.72.04.2009','Tanjung Bunga'),
('15.72.04.2010','Koto Padang'),
('15.72.04.2011','Tanjung Karang'),
('15.72.04.2012','Kt. Baru Tanah Kampung'),
('15.72.04.2013','Mekar Jaya'),
('15.72.05','Kumun Debai'),
('15.72.05.2001','Kumun Hilir'),
('15.72.05.2002','Kumun Mudik'),
('15.72.05.2003','Air Teluh'),
('15.72.05.2004','Sandaran Galeh'),
('15.72.05.2005','Debai'),
('15.72.05.2006','Pinggir Air'),
('15.72.05.2007','Renah Kayu Embun'),
('15.72.05.2008','Ulu Air'),
('15.72.05.2009','Muara Jaya'),
('15.72.06','Pondok Tinggi'),
('15.72.06.1008','Pondok Tinggi'),
('15.72.06.2001','Sungai Jernih'),
('15.72.06.2002','Aur Duri'),
('15.72.06.2003','Pondok Agung'),
('15.72.06.2004','Permanti'),
('15.72.06.2005','Lawang Agung'),
('15.72.06.2006','Karya Bakti'),
('15.72.06.2007','Koto Lebu'),
('15.72.07','Koto Baru'),
('15.72.07.2001','Koto Baru'),
('15.72.07.2002','Koto Limau Manis'),
('15.72.07.2003','Kampung Tengah'),
('15.72.07.2004','Dujung Sakti'),
('15.72.07.2005','Permai Indah'),
('15.72.07.2006','Srimenanti'),
('15.72.08','Sungai Bungkal'),
('15.72.08.1005','Dusun Baru'),
('15.72.08.2001','Sumur Anyir'),
('15.72.08.2002','Koto Tinggi'),
('15.72.08.2003','Talang Lindung'),
('15.72.08.2004','Pelayang Raya'),
('15.72.08.2006','Sungai Ning');

-- Provinsi SUMATERA SELATAN
INSERT INTO wilayah (kode, nama)
VALUES
('16','Sumatera Selatan'),
('16.01','Kabupaten Ogan Komering Ulu'),
('16.01.07','Sosoh Buay Rayap'),
('16.01.07.2001','Negeri Sindang'),
('16.01.07.2002','Rantau Kumpai'),
('16.01.07.2003','Lubuk Baru'),
('16.01.07.2004','Kungkilan'),
('16.01.07.2005','Penyandingan'),
('16.01.07.2006','Bandar'),
('16.01.07.2007','Lubuk Leban'),
('16.01.07.2008','Tungku Jaya'),
('16.01.07.2009','Mekar Sari'),
('16.01.07.2010','Mekar Jaya'),
('16.01.07.2011','Penantian'),
('16.01.08','Pengandonan'),
('16.01.08.2001','Gunung Meraksa'),
('16.01.08.2003','Tanjung Pura'),
('16.01.08.2004','Tanjung Sari'),
('16.01.08.2005','Tangsi Lontar'),
('16.01.08.2006','Belambangan'),
('16.01.08.2007','Kesambirata'),
('16.01.08.2008','Gunung Liwat'),
('16.01.08.2015','Pengandonan'),
('16.01.08.2016','Semanding'),
('16.01.08.2017','Tanjungan'),
('16.01.08.2018','Ujanmas'),
('16.01.08.2019','Gunung Kuripan'),
('16.01.09','Peninjauan'),
('16.01.09.2001','Kepayang'),
('16.01.09.2002','Kedondong'),
('16.01.09.2003','Belimbing'),
('16.01.09.2004','Durian'),
('16.01.09.2006','Lubuk Rukam'),
('16.01.09.2007','Bindu'),
('16.01.09.2009','Mendala'),
('16.01.09.2010','Peninjauan'),
('16.01.09.2011','Saung Naga'),
('16.01.09.2022','Makartitama'),
('16.01.09.2023','Espetiga'),
('16.01.09.2024','Makarti Jaya'),
('16.01.09.2025','Mitra Kencana'),
('16.01.09.2026','Penilikan'),
('16.01.09.2027','Panji Jaya'),
('16.01.09.2028','Karang Dapo'),
('16.01.13','Baturaja Barat'),
('16.01.13.1003','Tanjungagung'),
('16.01.13.1004','Saung Naga'),
('16.01.13.1005','Talang Jawa'),
('16.01.13.1007','Batu Kuning'),
('16.01.13.1011','Air Gading'),
('16.01.13.2001','Batu Putih'),
('16.01.13.2002','Laya'),
('16.01.13.2006','Pusar'),
('16.01.13.2008','Karang Agung'),
('16.01.13.2009','Karang Endah'),
('16.01.13.2010','Tanjung Karang'),
('16.01.13.2012','Sukamaju'),
('16.01.14','Baturaja Timur'),
('16.01.14.1001','Baturaja Lama'),
('16.01.14.1003','Pasar Baru'),
('16.01.14.1004','Kemalaraja'),
('16.01.14.1005','Sukaraya'),
('16.01.14.1006','Sukajadi'),
('16.01.14.1011','Kemelak Bindung Langit'),
('16.01.14.1012','Sepancar Lawang Kulon'),
('16.01.14.1013','Baturaja Permai'),
('16.01.14.1014','Sekar Jaya'),
('16.01.14.2007','Tanjung Kemala'),
('16.01.14.2008','Tanjung Baru'),
('16.01.14.2015','Air Paoh'),
('16.01.14.2016','Terusan'),
('16.01.20','Ulu Ogan'),
('16.01.20.2001','Kelumpang'),
('16.01.20.2002','Gunung Tiga'),
('16.01.20.2003','Mendingin'),
('16.01.20.2004','Ulak Lebar'),
('16.01.20.2005','Pedataran'),
('16.01.20.2006','Sukajadi'),
('16.01.20.2007','Belandang'),
('16.01.21','Semidang Aji'),
('16.01.21.2001','Tanjung Kurung'),
('16.01.21.2002','Sukarami'),
('16.01.21.2003','Batanghari'),
('16.01.21.2004','Nyiur Sayak'),
('16.01.21.2005','Suka Merindu'),
('16.01.21.2006','Padang Bindu'),
('16.01.21.2007','Panggal Panggang'),
('16.01.21.2008','Bedegung'),
('16.01.21.2009','Ulak Pandan'),
('16.01.21.2010','Keban Agung'),
('16.01.21.2011','Tubohan'),
('16.01.21.2012','Raksa Jiwa'),
('16.01.21.2013','Seleman'),
('16.01.21.2014','Kebun Jati'),
('16.01.21.2015','Singapura'),
('16.01.21.2016','Pengaringan'),
('16.01.21.2017','Banjarsari'),
('16.01.21.2018','Pandan Dulang'),
('16.01.21.2020','Panai Makmur'),
('16.01.21.2021','Guna Makmur'),
('16.01.21.2022','Tebing Kampung'),
('16.01.22','Lubuk Batang'),
('16.01.22.2001','Merbau'),
('16.01.22.2002','Gunung Meraksa'),
('16.01.22.2003','Kurup'),
('16.01.22.2004','Banu Ayu'),
('16.01.22.2005','Tanjung Dalam'),
('16.01.22.2006','Lubuk Batang Baru'),
('16.01.22.2007','Lubuk Batang Lama'),
('16.01.22.2008','Belatung'),
('16.01.22.2009','Karta Mulya'),
('16.01.22.2010','Lunggaian'),
('16.01.22.2011','Bandar Agung'),
('16.01.22.2012','Tanjung Manggus'),
('16.01.22.2015','Markisa'),
('16.01.22.2016','Air Wall'),
('16.01.22.2017','Sumber Bahagia'),
('16.01.28','Lengkiti'),
('16.01.28.2001','Bandar Jaya'),
('16.01.28.2002','Karang Endah'),
('16.01.28.2003','Pajar Bulan'),
('16.01.28.2004','Pagar Dewa'),
('16.01.28.2005','Bumi Kawa'),
('16.01.28.2006','Tanjunglengkayap'),
('16.01.28.2007','Lubuk Dalam'),
('16.01.28.2008','Negeri Ratu'),
('16.01.28.2009','Segara Kembang'),
('16.01.28.2010','Tihang'),
('16.01.28.2011','Lubuk Hara'),
('16.01.28.2012','Sukaraja'),
('16.01.28.2013','Negeri Agung'),
('16.01.28.2014','Gedung Pekuon'),
('16.01.28.2015','Tualang'),
('16.01.28.2016','Sundan'),
('16.01.28.2017','Bunga Tanjung'),
('16.01.28.2018','Way Heling'),
('16.01.28.2019','Umpam'),
('16.01.28.2020','Fajar Jaya'),
('16.01.28.2021','Simpang Empat'),
('16.01.28.2022','Tanjungagung'),
('16.01.29','Sinar Peninjauan'),
('16.01.29.2001','Karya Jaya'),
('16.01.29.2002','Karya Mukti'),
('16.01.29.2003','Marga Bakti'),
('16.01.29.2004','Sri Mulya'),
('16.01.29.2005','Marga Mulya'),
('16.01.29.2006','Tanjung Makmur'),
('16.01.30','Lubuk Raja'),
('16.01.30.2001','Batu Marta I'),
('16.01.30.2002','Batu Marta II'),
('16.01.30.2003','Lekis Rejo'),
('16.01.30.2004','Lubuk Banjar'),
('16.01.30.2005','Marta Jaya'),
('16.01.30.2006','Batu Raden'),
('16.01.30.2007','Battu Winangun'),
('16.01.31','Muara Jaya'),
('16.01.31.2001','Kemala Jaya'),
('16.01.31.2002','Lontar'),
('16.01.31.2003','Muara Saeh'),
('16.01.31.2004','Lubuk Tupak'),
('16.01.31.2005','Beringin'),
('16.01.31.2006','Surau'),
('16.01.31.2007','Karang Lantang'),
('16.01.32','Kedaton Peninjauan Raya'),
('16.01.32.2001','Bunglai'),
('16.01.32.2002','Kedaton'),
('16.01.32.2003','Kampai'),
('16.01.32.2004','Rantau Panjang'),
('16.01.32.2005','Kedaton Timur'),
('16.01.32.2006','Suka Pindah'),
('16.01.32.2007','Sinar Kedaton'),
('16.01.32.2008','Lubuk Kemiling'),
('16.02','Kabupaten Ogan Komering Ilir'),
('16.02.02','Tanjung Lubuk'),
('16.02.02.1011','Tanjung Lubuk'),
('16.02.02.2001','Ulak Kapal'),
('16.02.02.2002','Tanjung Merindu'),
('16.02.02.2003','Tanjung Baru'),
('16.02.02.2004','Seritanjung'),
('16.02.02.2005','Pengaraian'),
('16.02.02.2006','Sukarami'),
('16.02.02.2008','Sukamulya'),
('16.02.02.2010','Pulau Gemantung'),
('16.02.02.2012','Bumiagung'),
('16.02.02.2013','Kotabumi'),
('16.02.02.2014','Tanjung Beringin'),
('16.02.02.2015','Tanjung Laga'),
('16.02.02.2016','Tanjung Laut'),
('16.02.02.2017','Ulak Balam'),
('16.02.02.2018','Jambu Ilir'),
('16.02.02.2031','Jukdadak'),
('16.02.02.2032','Atar Balam'),
('16.02.02.2033','Tanjung Harapan'),
('16.02.02.2034','Pulau Gemantung Ilir'),
('16.02.02.2035','Pulau Gemantung Ulu'),
('16.02.02.2036','Pulau Gemantung Darat'),
('16.02.03','Pedamaran'),
('16.02.03.2002','Pedamaran VI'),
('16.02.03.2003','Pedamaran V'),
('16.02.03.2004','Pedamaran IV'),
('16.02.03.2005','Pedamaran III'),
('16.02.03.2006','Pedamaran II'),
('16.02.03.2007','Pedamaran I'),
('16.02.03.2008','Cinta Jaya'),
('16.02.03.2009','Sukadamai'),
('16.02.03.2010','Serinanti'),
('16.02.03.2011','Sukaraja'),
('16.02.03.2017','Burnai Timur'),
('16.02.03.2018','Suka Pulih'),
('16.02.03.2019','Menang Raya'),
('16.02.03.2021','Lebuh Rarak'),
('16.02.04','Mesuji'),
('16.02.04.2001','Pematang Panggang'),
('16.02.04.2002','Sungai Sodong'),
('16.02.04.2005','Pagar Dewa'),
('16.02.04.2006','Surya Adi'),
('16.02.04.2007','Makarti Mulya'),
('16.02.04.2008','Marga Bakti'),
('16.02.04.2009','Jaya Bakti'),
('16.02.04.2025','Sukamukti'),
('16.02.04.2026','Mekar Wangi'),
('16.02.04.2035','Karya Mukti'),
('16.02.04.2037','Kalideras'),
('16.02.04.2038','Sumber Deras'),
('16.02.04.2047','Kembang Jajar'),
('16.02.04.2050','Kota Baru'),
('16.02.04.2051','Sido Basuki'),
('16.02.04.2052','Pematang Kasih'),
('16.02.04.2053','Labuhan Jaya'),
('16.02.05','Kayu Agung'),
('16.02.05.1001','Jua-jua'),
('16.02.05.1002','Kayuagung'),
('16.02.05.1003','Sidakersa'),
('16.02.05.1004','Cintaraja'),
('16.02.05.1005','Mangun Jaya'),
('16.02.05.1006','Paku'),
('16.02.05.1007','Kedaton'),
('16.02.05.1008','Sukadana'),
('16.02.05.1009','Perigi'),
('16.02.05.1010','Kutaraja'),
('16.02.05.1025','Tanjung Rancing'),
('16.02.05.2011','Kijang Ulu'),
('16.02.05.2012','Muarabaru'),
('16.02.05.2013','Tanjung Lubuk'),
('16.02.05.2014','Arisan Buntal'),
('16.02.05.2015','Celikah'),
('16.02.05.2016','Banding Anyar'),
('16.02.05.2017','Buluh Cawang'),
('16.02.05.2018','Lubuk Dalam'),
('16.02.05.2019','Anyar'),
('16.02.05.2020','Tanjung Menang'),
('16.02.05.2021','Teloko'),
('16.02.05.2022','Tanjung Serang'),
('16.02.05.2023','Serigeni Baru'),
('16.02.05.2024','Serigeni'),
('16.02.08','Sirah Pulau Padang'),
('16.02.08.2001','Tanjung Alai'),
('16.02.08.2002','Batu Ampar'),
('16.02.08.2003','Awal Terusan'),
('16.02.08.2004','Ulak Jermun'),
('16.02.08.2005','Mangun Jaya'),
('16.02.08.2006','Terusan Menang'),
('16.02.08.2007','Belanti'),
('16.02.08.2008','Terate'),
('16.02.08.2009','Rengas Pitu'),
('16.02.08.2010','Pantai'),
('16.02.08.2011','Sirah Pulau Padang'),
('16.02.08.2012','Serdang Menang'),
('16.02.08.2013','Bungin Tinggi'),
('16.02.08.2014','Penyandingan'),
('16.02.08.2015','Berkat'),
('16.02.08.2016','Sukaraja'),
('16.02.08.2017','Pematang Buluran'),
('16.02.08.2018','Rawang Besar'),
('16.02.08.2019','Batu Ampar Baru'),
('16.02.08.2020','Terusan Laut'),
('16.02.11','Tulung Selapan'),
('16.02.11.1016','Tulung Selapan Ulu'),
('16.02.11.2001','Simpang Tiga'),
('16.02.11.2002','Pulau Beruang'),
('16.02.11.2003','Penyandingan'),
('16.02.11.2004','Tanjung Batu'),
('16.02.11.2005','Toman'),
('16.02.11.2006','Cambai'),
('16.02.11.2007','Kayuara'),
('16.02.11.2008','Petaling'),
('16.02.11.2009','Tulung Selapan Ilir'),
('16.02.11.2010','Ujung Tanjung'),
('16.02.11.2011','Lebung Gajah'),
('16.02.11.2012','Lebung Itam'),
('16.02.11.2013','Penanggoan Duren'),
('16.02.11.2014','Jerambah Rengas'),
('16.02.11.2015','Simpang Tiga Makmur'),
('16.02.11.2017','Simpang Tiga Jaya'),
('16.02.11.2018','Simpang Tiga Sakti'),
('16.02.11.2019','Tulung Seluang'),
('16.02.11.2020','Rantau Lurus'),
('16.02.11.2021','Kuala Dua Belas'),
('16.02.11.2022','Simpang Tiga Abadi'),
('16.02.11.2023','Tulung Selapan Timur'),
('16.02.12','Pampangan'),
('16.02.12.2001','Ulak Kemang'),
('16.02.12.2002','Sepang'),
('16.02.12.2003','Keman'),
('16.02.12.2004','Kandis'),
('16.02.12.2005','Ulak Depati'),
('16.02.12.2006','Pulau Layang'),
('16.02.12.2007','Tapus'),
('16.02.12.2008','Pulau Betung'),
('16.02.12.2009','Bangsal'),
('16.02.12.2010','Kuro'),
('16.02.12.2011','Menggeris'),
('16.02.12.2012','Pampangan'),
('16.02.12.2013','Serimenang'),
('16.02.12.2014','Secondong'),
('16.02.12.2015','Jermun'),
('16.02.12.2016','Serdang'),
('16.02.12.2017','Jungkal'),
('16.02.12.2035','Tanjung Kemang'),
('16.02.12.2036','Ulak Pianggu'),
('16.02.12.2037','Ulak Kemang Baru'),
('16.02.12.2038','Keman Baru'),
('16.02.12.2039','Sri Mulya'),
('16.02.13','Lempuing'),
('16.02.13.2005','Tebing Suluh'),
('16.02.13.2006','Cahya Bumi'),
('16.02.13.2007','Kutapandan'),
('16.02.13.2008','Cahaya Maju'),
('16.02.13.2009','Bumiagung'),
('16.02.13.2010','Sumberagung'),
('16.02.13.2011','Tugumulyo'),
('16.02.13.2013','Dabuk Rejo'),
('16.02.13.2014','Suka Mulya'),
('16.02.13.2015','Bumi Arjo'),
('16.02.13.2016','Tulung Harapan'),
('16.02.13.2017','Kepayang'),
('16.02.13.2025','Tugu Jaya'),
('16.02.13.2026','Tugu Agung'),
('16.02.13.2027','Sindang Sari'),
('16.02.13.2028','Mekar Jaya'),
('16.02.13.2034','Bumiarjo Makmur'),
('16.02.13.2035','Cahaya Makmur'),
('16.02.13.2036','Sumber Makmur'),
('16.02.14','Air Sugihan'),
('16.02.14.2001','Tirta Mulya'),
('16.02.14.2002','Suka Mulya'),
('16.02.14.2003','Jadi Mulya'),
('16.02.14.2004','Marga Tani'),
('16.02.14.2005','Bandar Jaya'),
('16.02.14.2006','Mukti Jaya'),
('16.02.14.2007','Srijaya Baru'),
('16.02.14.2008','Nusantara'),
('16.02.14.2009','Kerta Mukti'),
('16.02.14.2010','Nusakerta'),
('16.02.14.2011','Banyu Biru'),
('16.02.14.2012','Pangkalan Damai'),
('16.02.14.2013','Negeri Sakti'),
('16.02.14.2014','Rantau Karya'),
('16.02.14.2015','Pangkalan Sakti'),
('16.02.14.2016','Simpang Heran'),
('16.02.14.2017','Rengas Abang'),
('16.02.14.2018','Bukit Batu'),
('16.02.14.2019','Sungai Batang'),
('16.02.15','Sungai Menang'),
('16.02.15.2001','Sungai Menang'),
('16.02.15.2002','Karangsia'),
('16.02.15.2003','Sungai Ceper'),
('16.02.15.2004','Gajah Mati'),
('16.02.15.2005','Sungai Tepuk'),
('16.02.15.2006','Sungai Sibur'),
('16.02.15.2007','Talang Makmur'),
('16.02.15.2008','Harapan Jaya'),
('16.02.15.2009','Talang Jaya'),
('16.02.15.2010','Sidomulyo'),
('16.02.15.2011','Bumi Pratama Mandira'),
('16.02.15.2012','Pinang Indah'),
('16.02.15.2013','Gajah Makmur'),
('16.02.15.2014','Gading Jaya'),
('16.02.15.2015','Gajah Mukti'),
('16.02.15.2016','Gajah Mulya'),
('16.02.15.2017','Sri Gading'),
('16.02.15.2018','Gading Mas'),
('16.02.17','Jejawi'),
('16.02.17.2001','Tanjung Aur'),
('16.02.17.2002','Lubuk Ketepeng'),
('16.02.17.2003','Talang Cempedak'),
('16.02.17.2004','Bubusan'),
('16.02.17.2005','Air Itam'),
('16.02.17.2006','Jejawi'),
('16.02.17.2007','Karang Agung'),
('16.02.17.2008','Muara Batun'),
('16.02.17.2009','Lingkis'),
('16.02.17.2010','Terusan Jawa'),
('16.02.17.2011','Tanjung Ali'),
('16.02.17.2012','Sukadarma'),
('16.02.17.2013','Ulak Tembaga'),
('16.02.17.2014','Pedu'),
('16.02.17.2015','Pematang Kijang'),
('16.02.17.2016','Simpang Empat'),
('16.02.17.2017','Padang Bulan'),
('16.02.17.2018','Batun Baru'),
('16.02.17.2019','Danau Ceper'),
('16.02.18','Cengal'),
('16.02.18.2001','Sungai Somor'),
('16.02.18.2002','Sungai Lumpur'),
('16.02.18.2003','Sungai Jeruju'),
('16.02.18.2004','Sungai Ketupak'),
('16.02.18.2005','Ulak Kedondong'),
('16.02.18.2006','Pelimbangan'),
('16.02.18.2007','Cengal'),
('16.02.18.2008','Talang Rimba'),
('16.02.18.2009','Sungai Pasir'),
('16.02.18.2010','Kuala Sungai Jeruju'),
('16.02.18.2011','Kuala Sungai Pasir'),
('16.02.18.2012','Pantai Harapan'),
('16.02.18.2013','Adil Makmur'),
('16.02.18.2014','Balam Jeruju'),
('16.02.18.2015','Kebun Cabe'),
('16.02.18.2016','Lebak Beriang'),
('16.02.18.2017','Parit Raya'),
('16.02.19','Pangkalan Lampam'),
('16.02.19.2001','Deling'),
('16.02.19.2002','Pangkalan Lampan'),
('16.02.19.2003','Lirik'),
('16.02.19.2004','Lebung Batang'),
('16.02.19.2005','Sungai Bungin'),
('16.02.19.2006','Sukaraja'),
('16.02.19.2007','Darat'),
('16.02.19.2008','Pulauan'),
('16.02.19.2009','Riding'),
('16.02.19.2010','Sunggutan'),
('16.02.19.2011','Suka Damai'),
('16.02.19.2012','Air Pedara'),
('16.02.19.2013','Rimba Samak'),
('16.02.19.2014','Talang Daya'),
('16.02.19.2015','Air Rumbai'),
('16.02.19.2016','Rambai'),
('16.02.19.2017','Perigi'),
('16.02.19.2018','Bukit Batu'),
('16.02.19.2019','Rawa Tenam'),
('16.02.20','Mesuji Makmur'),
('16.02.20.2001','Catur Tunggal'),
('16.02.20.2002','Surya Karta'),
('16.02.20.2003','Tegal Sari'),
('16.02.20.2004','Mukti Karya'),
('16.02.20.2005','Pematang Jaya'),
('16.02.20.2006','Pematang Sukatani'),
('16.02.20.2007','Kampung Baru'),
('16.02.20.2008','Cahaya Mas'),
('16.02.20.2009','Karya Usaha'),
('16.02.20.2010','Pematang Binatani'),
('16.02.20.2011','Bina Karsa'),
('16.02.20.2012','Pematang Sari'),
('16.02.20.2013','Pematang Sukaramah'),
('16.02.20.2014','Cahaya Mulya'),
('16.02.20.2015','Gading Sari'),
('16.02.20.2017','Karya Jaya'),
('16.02.20.2018','Mesuji Jaya'),
('16.02.20.2019','Sumber Mulya'),
('16.02.20.2020','Beringin Jaya'),
('16.02.21','Mesuji Raya'),
('16.02.21.2001','Embacang'),
('16.02.21.2002','Balian'),
('16.02.21.2003','Sumbu Sari'),
('16.02.21.2004','Suka Sari'),
('16.02.21.2005','Ciptasari'),
('16.02.21.2006','Mataram Jaya'),
('16.02.21.2007','Bumi Makmur'),
('16.02.21.2008','Sumber Baru'),
('16.02.21.2009','Mulya Jaya'),
('16.02.21.2010','Rotan Mulya'),
('16.02.21.2011','Embacang Permai'),
('16.02.21.2012','Gedung Rejo'),
('16.02.21.2013','Kertamukti'),
('16.02.21.2014','Kemang Indah'),
('16.02.21.2015','Balian Makmur'),
('16.02.21.2016','Sedyomulyo'),
('16.02.21.2017','Dabuk Makmur'),
('16.02.22','Lempuing Jaya'),
('16.02.22.2001','Tanjung Sari I'),
('16.02.22.2002','Lubuk Seberuk'),
('16.02.22.2003','Rantau Durian I'),
('16.02.22.2004','Sungai Belida'),
('16.02.22.2005','Lempuing Indah'),
('16.02.22.2006','Muktisari'),
('16.02.22.2007','Tania Makmur'),
('16.02.22.2008','Sukamaju'),
('16.02.22.2009','Muara Burnai II'),
('16.02.22.2010','Suka Jaya'),
('16.02.22.2011','Rantau Durian II'),
('16.02.22.2012','Tanjung Sari II'),
('16.02.22.2013','Purwo Asri'),
('16.02.22.2014','Muara Burnai I'),
('16.02.22.2015','Lubuk Makmur'),
('16.02.22.2016','Rantau Durian Asli'),
('16.02.23','Teluk Gelam'),
('16.02.23.2001','Benawa'),
('16.02.23.2002','Serapek'),
('16.02.23.2003','Sugih Waras'),
('16.02.23.2004','Muara Telang'),
('16.02.23.2005','Kuripan'),
('16.02.23.2006','Cinta Marga'),
('16.02.23.2007','Penyandingan'),
('16.02.23.2008','Talang Pengeran'),
('16.02.23.2009','Ulak Ketapang'),
('16.02.23.2010','Mulyaguna'),
('16.02.23.2011','Panca Tunggal Benawa'),
('16.02.23.2012','Bumi Harapan'),
('16.02.23.2013','Sinar Harapan Mulya'),
('16.02.23.2014','Seriguna'),
('16.02.24','Pedamaran Timur'),
('16.02.24.2001','Pulau Geronggang'),
('16.02.24.2002','Sumber Hidup'),
('16.02.24.2003','Gading Raja'),
('16.02.24.2004','Maribaya'),
('16.02.24.2005','Pancawarna'),
('16.02.24.2006','Tanjung Makmur'),
('16.02.24.2007','Kayu Labu'),
('16.03','Kabupaten Muara Enim'),
('16.03.01','Tanjung Agung'),
('16.03.01.2011','Embawang'),
('16.03.01.2012','Pagar Dewa'),
('16.03.01.2013','Tanjung Bulan'),
('16.03.01.2014','Lesung Batu'),
('16.03.01.2015','Pandan Enim'),
('16.03.01.2016','Paduraksa'),
('16.03.01.2017','Matas'),
('16.03.01.2018','Tanjung Agung'),
('16.03.01.2019','Muara Emil'),
('16.03.01.2020','Tanjung Karangan'),
('16.03.01.2021','Seleman'),
('16.03.01.2022','Penyandingan'),
('16.03.01.2023','Tanjung Lalang'),
('16.03.01.2024','Pulau Panggung'),
('16.03.02','Muara Enim'),
('16.03.02.1006','Tungkal'),
('16.03.02.1007','Pasar II Muara Enim'),
('16.03.02.1008','Pasar III Muara Enim'),
('16.03.02.1009','Pasar I Muara Enim'),
('16.03.02.1010','Muara Enim'),
('16.03.02.1016','Air Lintang'),
('16.03.02.2001','Tanjung Raja'),
('16.03.02.2002','Karang Raja'),
('16.03.02.2003','Muara Lawai'),
('16.03.02.2004','Tanjung Jati'),
('16.03.02.2005','Lubuk Emplas'),
('16.03.02.2011','Kepur'),
('16.03.02.2012','Tanjung Serian'),
('16.03.02.2013','Muara Harapan'),
('16.03.02.2014','Saka Jaya'),
('16.03.02.2015','Harapan Jaya'),
('16.03.03','Rambang Niru'),
('16.03.03.2001','Gemawang'),
('16.03.03.2002','Lubuk Raman'),
('16.03.03.2003','Jemenang'),
('16.03.03.2004','Tanjung Menang'),
('16.03.03.2005','Tebat Agung'),
('16.03.03.2006','Gerinam'),
('16.03.03.2014','Suban Jeriji'),
('16.03.03.2015','Air Limau'),
('16.03.03.2016','Muara Emburung'),
('16.03.03.2017','Manunggal Jaya'),
('16.03.03.2018','Air Talas'),
('16.03.03.2019','Air Enau'),
('16.03.03.2020','Manunggal Makmur'),
('16.03.03.2021','Aur Duri'),
('16.03.03.2023','Kasih Dewa'),
('16.03.03.2024','Air Cekdam'),
('16.03.04','Gunung Megang'),
('16.03.04.2001','Penanggiran'),
('16.03.04.2002','Gunung Megang Luar'),
('16.03.04.2003','Gunung Megang Dalam'),
('16.03.04.2004','Lubuk Mumpo'),
('16.03.04.2005','Perjito'),
('16.03.04.2006','Tanjung Muning'),
('16.03.04.2007','Tanjung Terang'),
('16.03.04.2016','Bangun Sari'),
('16.03.04.2017','Sumaja Makmur'),
('16.03.04.2018','Sidomulyo'),
('16.03.04.2019','Pajar Indah'),
('16.03.04.2020','Kayu Ara Sakti'),
('16.03.04.2021','Panang Jaya'),
('16.03.06','Gelumbang'),
('16.03.06.1010','Gelumbang'),
('16.03.06.2004','Gaung Telang'),
('16.03.06.2006','Pinang Banjar'),
('16.03.06.2008','Segayam'),
('16.03.06.2009','Tambangan Kelekar'),
('16.03.06.2011','Suka Menang'),
('16.03.06.2013','Karang Endah'),
('16.03.06.2014','Jambu'),
('16.03.06.2015','Midar'),
('16.03.06.2016','Mililian'),
('16.03.06.2017','Pedataran'),
('16.03.06.2018','Teluk Limau'),
('16.03.06.2019','Kerta Mulya'),
('16.03.06.2020','Sebau'),
('16.03.06.2021','Sigam'),
('16.03.06.2022','Payabakal'),
('16.03.06.2023','Bitis'),
('16.03.06.2024','Gumai'),
('16.03.06.2025','Putak'),
('16.03.06.2026','Talang Taling'),
('16.03.06.2030','Suka Jaya'),
('16.03.06.2031','Karang Endah Selatan'),
('16.03.06.2032','Betung'),
('16.03.07','Lawang Kidul'),
('16.03.07.1001','Tanjung Enim'),
('16.03.07.1002','Pasar Tanjung Enim'),
('16.03.07.1003','Tanjung Enim Selatan'),
('16.03.07.2004','Tegal Rejo'),
('16.03.07.2005','Lingga'),
('16.03.07.2006','Keban Agung'),
('16.03.07.2007','Darmo'),
('16.03.08','Semende Darat Laut'),
('16.03.08.2001','Penindaian'),
('16.03.08.2002','Babatan'),
('16.03.08.2003','Muara Dua'),
('16.03.08.2004','Muara Danau'),
('16.03.08.2005','Penyandingan'),
('16.03.08.2006','Tanah Abang'),
('16.03.08.2007','Pagar Agung'),
('16.03.08.2008','Pulau Panggung'),
('16.03.08.2009','Karya Nyata'),
('16.03.08.2010','Perapau'),
('16.03.09','Semende Darat Tengah'),
('16.03.09.2001','Tenam Bungkuk'),
('16.03.09.2002','Kota Padang'),
('16.03.09.2003','Gunung Agung'),
('16.03.09.2004','Sri Tanjung'),
('16.03.09.2005','Tebing Abang'),
('16.03.09.2006','Batu Surau'),
('16.03.09.2007','Tanjung Raya'),
('16.03.09.2008','Muara Tenang'),
('16.03.09.2009','Rekimai Jaya'),
('16.03.09.2010','Palak Tanah'),
('16.03.09.2011','Kota Agung'),
('16.03.09.2012','Swarna Dwipa'),
('16.03.10','Semende Darat Ulu'),
('16.03.10.2001','Tanjung Tiga'),
('16.03.10.2002','Cahaya Alam'),
('16.03.10.2003','Datar Lebar'),
('16.03.10.2004','Segamit'),
('16.03.10.2005','Siring Agung'),
('16.03.10.2006','Aremantai'),
('16.03.10.2007','Tanjung Agung'),
('16.03.10.2008','Pajar Bulan'),
('16.03.10.2009','Pelakat'),
('16.03.10.2010','Danau Gerak'),
('16.03.11','Ujan Mas'),
('16.03.11.2001','Pinang Belarik'),
('16.03.11.2002','Ujan Mas Lama'),
('16.03.11.2003','Ujan Mas Baru'),
('16.03.11.2004','Tanjung Raman'),
('16.03.11.2005','Muara Gula Baru'),
('16.03.11.2006','Muara Gula Lama'),
('16.03.11.2007','Guci'),
('16.03.11.2008','Ulak Bandung'),
('16.03.11.2009','Ujan Mas Ulu'),
('16.03.14','Lubai'),
('16.03.14.2005','Aur'),
('16.03.14.2006','Beringin'),
('16.03.14.2007','Kota Baru'),
('16.03.14.2008','Pagar Gunung'),
('16.03.14.2009','Gunung Raja'),
('16.03.14.2010','Tanjung Kemala'),
('16.03.14.2011','Suka Merindu'),
('16.03.14.2014','Jiwa Baru'),
('16.03.14.2020','Air Asam'),
('16.03.14.2021','Menanti'),
('16.03.15','Rambang'),
('16.03.15.2001','Baru Rambang'),
('16.03.15.2002','Sugihan'),
('16.03.15.2003','Tanjung Raya'),
('16.03.15.2004','Tanjung Dalam'),
('16.03.15.2005','Sukarami'),
('16.03.15.2006','Pagar Agung'),
('16.03.15.2007','Sugih Waras'),
('16.03.15.2008','Sumber Rahayu'),
('16.03.15.2009','Marga Mulya'),
('16.03.15.2010','Kencana Mulia'),
('16.03.15.2011','Negeri Agung'),
('16.03.15.2012','Sugihwaras Barat'),
('16.03.15.2013','Air Keruh'),
('16.03.16','Sungai Rotan'),
('16.03.16.2001','Tanjung Miring'),
('16.03.16.2002','Danau Tampang'),
('16.03.16.2003','Kasai'),
('16.03.16.2004','Sungai Rotan'),
('16.03.16.2005','Sukamerindu'),
('16.03.16.2006','Tanding Marga'),
('16.03.16.2007','Muara Lematang'),
('16.03.16.2008','Sukadana'),
('16.03.16.2009','Modong'),
('16.03.16.2010','Sukacinta'),
('16.03.16.2011','Penandingan'),
('16.03.16.2012','Danau Rata'),
('16.03.16.2013','Paya Angus'),
('16.03.16.2014','Sukarami'),
('16.03.16.2015','Petar Dalam'),
('16.03.16.2016','Sukajadi'),
('16.03.16.2017','Sukamaju'),
('16.03.16.2018','Danau Baru'),
('16.03.16.2019','Petar Luar'),
('16.03.17','Lembak'),
('16.03.17.2007','Petanang'),
('16.03.17.2008','Talang Nangka'),
('16.03.17.2009','Alai'),
('16.03.17.2010','Sungai Duren'),
('16.03.17.2011','Tapus'),
('16.03.17.2012','Lembak'),
('16.03.17.2013','Kemang'),
('16.03.17.2014','Lubuk Enau'),
('16.03.17.2015','Alai Selatan'),
('16.03.17.2019','Tanjung Baru'),
('16.03.19','Benakat'),
('16.03.19.2001','Padang Bindu'),
('16.03.19.2002','Betung'),
('16.03.19.2003','Pagar Dewa'),
('16.03.19.2004','Pagarjati'),
('16.03.19.2005','Hidup Baru'),
('16.03.19.2006','Rami Pasai'),
('16.03.21','Kelekar'),
('16.03.21.2001','Embacang Kelekar'),
('16.03.21.2002','Menanti'),
('16.03.21.2003','Menanti Selatan'),
('16.03.21.2004','Suban Baru'),
('16.03.21.2005','Pelempang'),
('16.03.21.2006','Teluk Jaya'),
('16.03.21.2007','Tanjung Medang'),
('16.03.22','Muara Belida'),
('16.03.22.2001','Gedung Buruk'),
('16.03.22.2002','Arisan Musi'),
('16.03.22.2003','Harapan Mulia'),
('16.03.22.2004','Mulia Abadi'),
('16.03.22.2005','Arisan Musi Timur'),
('16.03.22.2006','Patra Tani'),
('16.03.22.2007','Tanjung Baru'),
('16.03.22.2008','Kayu Ara Batu'),
('16.03.23','Belimbing'),
('16.03.23.2001','Tanjung'),
('16.03.23.2002','Simpang Tanjung'),
('16.03.23.2003','Cinta Kasih'),
('16.03.23.2004','Teluk Lubuk'),
('16.03.23.2005','Berugo'),
('16.03.23.2006','Belimbing'),
('16.03.23.2007','Bulang'),
('16.03.23.2008','Belimbing Jaya'),
('16.03.23.2009','Darmo Kasih'),
('16.03.23.2010','Dalam'),
('16.03.24','Belida Darat'),
('16.03.24.2001','Tanjung Bunut'),
('16.03.24.2002','Babat'),
('16.03.24.2003','Lubuk Semantung'),
('16.03.24.2004','Lubuk Getam'),
('16.03.24.2005','Talang Balai'),
('16.03.24.2006','Talang Beliung'),
('16.03.24.2007','Sialingan'),
('16.03.24.2008','Tanjung Tiga'),
('16.03.24.2009','Ibul'),
('16.03.24.2010','Gaung Asam'),
('16.03.25','Lubai Ulu'),
('16.03.25.2001','Karang Agung'),
('16.03.25.2002','Karang Sari'),
('16.03.25.2003','Karang Mulya'),
('16.03.25.2004','Sumber Mulya'),
('16.03.25.2005','Sumber Asri'),
('16.03.25.2006','Pagar Dewa'),
('16.03.25.2007','Prabumenang'),
('16.03.25.2008','Lecah'),
('16.03.25.2009','Mekar Jaya'),
('16.03.25.2010','Lubai Persada'),
('16.03.25.2011','Lubai Makmur'),
('16.03.26','Empat Petulai Dangku'),
('16.03.26.2001','Muara Niru'),
('16.03.26.2002','Kahuripan Baru'),
('16.03.26.2003','Pangkalan Babat'),
('16.03.26.2004','Gunung Raja'),
('16.03.26.2005','Banuayu'),
('16.03.26.2006','Kuripan'),
('16.03.26.2007','Kuripan Selatan'),
('16.03.26.2008','Batu Raja'),
('16.03.26.2009','Dangku'),
('16.03.26.2010','Siku'),
('16.03.27','Panang Enim'),
('16.03.27.2001','Lebak Budi'),
('16.03.27.2002','Lambur'),
('16.03.27.2003','Pagar Jati'),
('16.03.27.2004','Tanjung Baru'),
('16.03.27.2005','Sukaraja'),
('16.03.27.2006','Pandan Dulang'),
('16.03.27.2007','Muara Meo'),
('16.03.27.2008','Sugih Waras'),
('16.03.27.2009','Indramayu'),
('16.03.27.2010','Bedegung'),
('16.03.27.2011','Padang Bindu'),
('16.03.27.2012','Lubuk Nipis'),
('16.04','Kabupaten Lahat'),
('16.04.01','Tanjungsakti Pumu'),
('16.04.01.2001','Kembang Ayun'),
('16.04.01.2002','Gunung Meraksa'),
('16.04.01.2003','Tanjung Alam'),
('16.04.01.2004','Batu Rancing'),
('16.04.01.2005','Suban'),
('16.04.01.2006','Genting'),
('16.04.01.2007','Gunung Ayu'),
('16.04.01.2008','Ujung Pulau'),
('16.04.01.2009','Muara Cawang'),
('16.04.01.2010','Kepala Siring'),
('16.04.01.2011','Simpang III Pumu'),
('16.04.01.2012','Gunung Raya'),
('16.04.01.2013','Talang Tinggi'),
('16.04.01.2014','Karang Agung'),
('16.04.06','Jarai'),
('16.04.06.2008','Sadan'),
('16.04.06.2009','Penantian'),
('16.04.06.2010','Bandar Aji'),
('16.04.06.2011','Tertap'),
('16.04.06.2012','Serambi'),
('16.04.06.2013','Muara Tawi'),
('16.04.06.2014','Kedaton'),
('16.04.06.2015','Pelajaran'),
('16.04.06.2016','Nanti Giri'),
('16.04.06.2017','Pama Salak'),
('16.04.06.2018','Jemaring'),
('16.04.06.2019','Aromantai'),
('16.04.06.2020','Jarai'),
('16.04.06.2021','Tanjung Menang'),
('16.04.06.2022','Mangun Sari'),
('16.04.06.2023','Pagar Dewa'),
('16.04.06.2024','Sukananti'),
('16.04.06.2025','Lubuk Saung'),
('16.04.06.2026','Karang Tanding'),
('16.04.06.2027','Gunung Raya'),
('16.04.06.2028','Gunung Megang'),
('16.04.07','Kota Agung'),
('16.04.07.2001','Bangke'),
('16.04.07.2002','Tebat Langsat'),
('16.04.07.2003','Singapure'),
('16.04.07.2004','Gunung Liwat'),
('16.04.07.2005','Kebun Jati'),
('16.04.07.2006','Bintuhan'),
('16.04.07.2007','Mutar Alam Baru'),
('16.04.07.2008','Pandan Arang Ulu'),
('16.04.07.2009','Mutar Alam Lama'),
('16.04.07.2010','Tanjung Raman'),
('16.04.07.2011','Tunggul Bute'),
('16.04.07.2012','Karang Endah'),
('16.04.07.2013','Karang Agung'),
('16.04.07.2014','Suka Raja'),
('16.04.07.2015','Gedung Agung'),
('16.04.07.2016','Kota Agung'),
('16.04.07.2017','Lawang Agung'),
('16.04.07.2018','Sukarami'),
('16.04.07.2019','Tanjung Beringin'),
('16.04.07.2020','Pagaruyung'),
('16.04.07.2031','Muara Gula'),
('16.04.07.2032','Tanjung Bulan'),
('16.04.08','Pulau Pinang'),
('16.04.08.2008','Tanjung Mulak'),
('16.04.08.2009','Pulau Pinang'),
('16.04.08.2010','Tanjung Sirih'),
('16.04.08.2011','Lubuk Sepang'),
('16.04.08.2012','Karang Dalam'),
('16.04.08.2013','Kuba'),
('16.04.08.2014','Jati'),
('16.04.08.2016','Pagar Batu'),
('16.04.08.2017','Muara Siban'),
('16.04.08.2018','Perigi'),
('16.04.09','Merapi Barat'),
('16.04.09.2010','Suka Cinta'),
('16.04.09.2011','Gunung Agung'),
('16.04.09.2012','Tanjung Pinang'),
('16.04.09.2013','Suka Marga'),
('16.04.09.2014','Payo'),
('16.04.09.2015','Karang Endah'),
('16.04.09.2016','Tanjung Telang'),
('16.04.09.2017','Lubuk Kepayang'),
('16.04.09.2018','Muara Temiang'),
('16.04.09.2019','Ulak Pandan'),
('16.04.09.2020','Negeri Agung'),
('16.04.09.2021','Lebak Budi'),
('16.04.09.2022','Tanjung Baru'),
('16.04.09.2023','Kebur'),
('16.04.09.2024','Telatang'),
('16.04.09.2025','Muara Maung'),
('16.04.09.2026','Merapi'),
('16.04.09.2040','Purwosari'),
('16.04.09.2041','Karang Rejo'),
('16.04.10','Lahat'),
('16.04.10.1031','Lahat Tengah'),
('16.04.10.1032','Gunung Gajah'),
('16.04.10.1033','Pagar Agung'),
('16.04.10.1037','Talang Jawa'),
('16.04.10.1038','Pasar Baru'),
('16.04.10.1040','Kota Baru'),
('16.04.10.1041','Pasar Lama'),
('16.04.10.1042','Pasar Bawah'),
('16.04.10.1043','RD. PJKA'),
('16.04.10.1046','Bandar Agung'),
('16.04.10.1051','Kota Negara'),
('16.04.10.1052','Kota Jaya'),
('16.04.10.1054','RD. PJKA Bandar Agung'),
('16.04.10.1058','Sari Bunga Mas'),
('16.04.10.1059','Bandar Jaya'),
('16.04.10.1060','Talang Jawa Selatan'),
('16.04.10.1061','Talang Jawa Utara'),
('16.04.10.2012','Padang Lengkuas'),
('16.04.10.2027','Selawi'),
('16.04.10.2030','Sukanegara'),
('16.04.10.2034','Kota Raya'),
('16.04.10.2035','Keban'),
('16.04.10.2036','Pagar Sari'),
('16.04.10.2039','Pagar Negara'),
('16.04.10.2049','Senabing'),
('16.04.10.2050','Manggul'),
('16.04.10.2053','Ulak Lebar'),
('16.04.10.2055','Giri Mulya'),
('16.04.10.2056','Makarti Tama'),
('16.04.10.2057','Ulak Mas'),
('16.04.12','Pajar Bulan'),
('16.04.12.2001','Talang Baru'),
('16.04.12.2002','Talang Pagar Agung'),
('16.04.12.2003','Bantunan'),
('16.04.12.2004','Suka Bumi'),
('16.04.12.2005','Pulau Panggung'),
('16.04.12.2006','Pajar Bulan'),
('16.04.12.2007','Kota Raya Lembak'),
('16.04.12.2008','Sumur'),
('16.04.12.2009','Gelung Sakti'),
('16.04.12.2010','Pulau'),
('16.04.12.2011','Ulak Bandung'),
('16.04.12.2012','Talang Padang Tinggi'),
('16.04.12.2019','Aceh'),
('16.04.12.2020','Pajar Tinggi'),
('16.04.12.2025','Kota Raya Darat'),
('16.04.12.2026','Jenti''an'),
('16.04.12.2027','Tongkok'),
('16.04.12.2028','Benua Raja'),
('16.04.12.2029','Talang Mengkenang'),
('16.04.12.2030','Talang Tangsi'),
('16.04.15','Mulak Ulu'),
('16.04.15.2007','Pajar Bulan'),
('16.04.15.2008','Sukananti'),
('16.04.15.2009','Karang Lebak'),
('16.04.15.2011','Babatan'),
('16.04.15.2014','Muara Tiga'),
('16.04.15.2015','Sengkuang'),
('16.04.15.2016','Penindayan'),
('16.04.15.2017','Datar Balam'),
('16.04.15.2018','Tebing Tinggi'),
('16.04.15.2019','Geramat'),
('16.04.15.2020','Pengentaan'),
('16.04.15.2021','Lesung Batu'),
('16.04.15.2022','Air Puar'),
('16.04.15.2024','Mengkenang'),
('16.04.15.2029','Lawang Agung Mulak'),
('16.04.15.2030','Padang Masat'),
('16.04.16','Kikim Selatan'),
('16.04.16.2001','Pandan Arang'),
('16.04.16.2002','Tanjung Kurung'),
('16.04.16.2003','Nanjungan'),
('16.04.16.2004','Pagardin'),
('16.04.16.2005','Pulau Beringin'),
('16.04.16.2006','Beriningin Jaya'),
('16.04.16.2007','Banu Ayu'),
('16.04.16.2008','Tanjung Alam'),
('16.04.16.2009','Sirah Pulau'),
('16.04.16.2010','Tanjung Beringin'),
('16.04.16.2011','Pagar Jati'),
('16.04.16.2012','Karang Cahaya'),
('16.04.16.2013','Jaga Baya'),
('16.04.16.2014','Keban Agung'),
('16.04.16.2015','Padang Bindu'),
('16.04.16.2016','Beringin Janggut'),
('16.04.16.2017','Keban Raya'),
('16.04.16.2018','Lubuk Tungkang'),
('16.04.17','Kikim Timur'),
('16.04.17.2001','Bunga Mas'),
('16.04.17.2002','Gunung Kembang'),
('16.04.17.2003','Tanjung Bindu'),
('16.04.17.2004','Lubuk Tapang'),
('16.04.17.2005','Lubuk Nambulan'),
('16.04.17.2006','Gelumbang'),
('16.04.17.2007','Gunung Aji'),
('16.04.17.2008','Gunung Karto'),
('16.04.17.2009','Karang Endah'),
('16.04.17.2010','Padu Raksa'),
('16.04.17.2011','Seronggo'),
('16.04.17.2012','Datar Serdang'),
('16.04.17.2013','Batu Urip'),
('16.04.17.2014','Cecar'),
('16.04.17.2015','Patikal Lama'),
('16.04.17.2016','Muara Empayang'),
('16.04.17.2017','Lubuk Kute'),
('16.04.17.2018','Patikal Baru'),
('16.04.17.2019','Gedung Agung'),
('16.04.17.2020','Babat Lama'),
('16.04.17.2021','Tanda Raja'),
('16.04.17.2022','Muara Danau'),
('16.04.17.2023','Sendawar'),
('16.04.17.2024','Lubuk Layang Ilir'),
('16.04.17.2025','Binjai'),
('16.04.17.2026','Lubuk Layang Ulu'),
('16.04.17.2027','Cempaka Sakti'),
('16.04.17.2028','Suka Harjo'),
('16.04.17.2029','Marga Mulya'),
('16.04.17.2030','Kencana Sari'),
('16.04.17.2031','Linggar Jaya'),
('16.04.17.2032','Purwaraja'),
('16.04.18','Kikim Tengah'),
('16.04.18.2001','Sungai Laru'),
('16.04.18.2002','Muara Lingsing'),
('16.04.18.2003','Tanjung Baru'),
('16.04.18.2004','Kepala Siring'),
('16.04.18.2005','Maspura'),
('16.04.18.2006','Suka Raja'),
('16.04.18.2007','Tanjung Aur'),
('16.04.18.2008','Purbamas'),
('16.04.18.2009','Banyu Mas'),
('16.04.19','Kikim Barat'),
('16.04.19.2001','Saung Naga'),
('16.04.19.2002','Penantian'),
('16.04.19.2003','Suka Merindu'),
('16.04.19.2004','Jajaran Baru'),
('16.04.19.2005','Wonorejo'),
('16.04.19.2006','Babatan Baru'),
('16.04.19.2007','Jajaran Lama'),
('16.04.19.2008','Lubuk Seketi'),
('16.04.19.2009','Sukarami'),
('16.04.19.2010','Singapura'),
('16.04.19.2011','Ulak Bandung'),
('16.04.19.2012','Bandar Jaya'),
('16.04.19.2013','Purnama Sari'),
('16.04.19.2014','Wanaraya'),
('16.04.19.2015','Purworejo'),
('16.04.19.2016','Suka Bakti'),
('16.04.19.2017','Mekar Jaya'),
('16.04.19.2018','Darma Raharja'),
('16.04.19.2019','Sido Makmur'),
('16.04.20','Pseksu'),
('16.04.20.2001','Sukajadi'),
('16.04.20.2002','Tanjung Agung'),
('16.04.20.2003','Penandingan'),
('16.04.20.2004','Talang Tinggi'),
('16.04.20.2005','Batu Niding'),
('16.04.20.2006','Tanjung Raya'),
('16.04.20.2007','Lubuk Mabar'),
('16.04.20.2008','Pagar Agung'),
('16.04.20.2009','Lubuk Tuba'),
('16.04.20.2010','Lubuk Atung'),
('16.04.20.2011','Muara Cawang'),
('16.04.21','Gumay Talang'),
('16.04.21.2001','Sugi Waras'),
('16.04.21.2002','Tanjung Periuk'),
('16.04.21.2003','Tanjung Karangan'),
('16.04.21.2004','Muara Tandi'),
('16.04.21.2005','Darmo'),
('16.04.21.2006','Indikat Ilir'),
('16.04.21.2007','Tanjung Baru'),
('16.04.21.2008','Mandi Angin'),
('16.04.21.2009','Ngalam Baru'),
('16.04.21.2010','Sukarami'),
('16.04.21.2011','Tanjung Dalam'),
('16.04.21.2012','Tanah Pilih'),
('16.04.21.2013','Tanjung Beringin'),
('16.04.21.2014','Batay'),
('16.04.21.2015','Suka Makmur'),
('16.04.22','Pagar Gunung'),
('16.04.22.2001','Kedaton'),
('16.04.22.2002','Tanjung Agung'),
('16.04.22.2003','Karang Agung'),
('16.04.22.2004','Bandung Agung'),
('16.04.22.2005','Lesung Batu'),
('16.04.22.2006','Air Lingkar'),
('16.04.22.2007','Batu Rusa'),
('16.04.22.2008','Kupang'),
('16.04.22.2009','Sawah Darat'),
('16.04.22.2010','Danau'),
('16.04.22.2011','Siring Agung'),
('16.04.22.2012','Pagar Alam'),
('16.04.22.2013','Rimba Sujud'),
('16.04.22.2014','Germidar Ilir'),
('16.04.22.2015','Pagar Gunung'),
('16.04.22.2016','Germidar Ulu'),
('16.04.22.2017','Padang Pagun'),
('16.04.22.2018','Muara Dua'),
('16.04.22.2019','Penantian'),
('16.04.22.2020','Merindu'),
('16.04.23','Merapi Timur'),
('16.04.23.1014','Lebuay Bandung'),
('16.04.23.2001','Sirah Pulau'),
('16.04.23.2002','Gunung Kembang'),
('16.04.23.2003','Prabu Menang'),
('16.04.23.2004','Banjar Sari'),
('16.04.23.2005','Arahan'),
('16.04.23.2006','Nanjungan'),
('16.04.23.2007','Sengkuang'),
('16.04.23.2008','Tanjung Lontar'),
('16.04.23.2009','Gedung Agung'),
('16.04.23.2010','Muara Lawai'),
('16.04.23.2011','Tanjung Jambu'),
('16.04.23.2012','Cempaka Wangi'),
('16.04.23.2013','Lematang Jaya'),
('16.04.24','Tanjung Sakti Pumi'),
('16.04.24.2001','Pulau Panas'),
('16.04.24.2002','Sindang Panjang'),
('16.04.24.2003','Gunung Kembang'),
('16.04.24.2004','Pagar Agung'),
('16.04.24.2005','Benteng'),
('16.04.24.2006','Ulak Lebar'),
('16.04.24.2007','Gunung Agung'),
('16.04.24.2008','Masam Bulau'),
('16.04.24.2009','Pajar Bulan'),
('16.04.24.2010','Tanjung Bulan'),
('16.04.24.2011','Penandingan'),
('16.04.24.2012','Tanjung Sakti'),
('16.04.24.2013','Negeri Kaya'),
('16.04.24.2014','Pulau Panggung'),
('16.04.24.2015','Gunung Kerto'),
('16.04.24.2016','Lubuk Tabun'),
('16.04.24.2017','Pagar Jati'),
('16.04.24.2018','Lubuk Dalam'),
('16.04.25','Gumay Ulu'),
('16.04.25.2001','Tinggi Hari'),
('16.04.25.2002','Tanjung Raja'),
('16.04.25.2003','Sinjar Bulan'),
('16.04.25.2004','Padang Gumay'),
('16.04.25.2005','Tanjung Aur'),
('16.04.25.2006','Simpur'),
('16.04.25.2007','Lubuk Selo'),
('16.04.25.2008','Rindu Hati'),
('16.04.25.2009','Sumber Karya'),
('16.04.25.2010','Trans SP II Padang Muara Dua'),
('16.04.26','Merapi Selatan'),
('16.04.26.2001','Padang'),
('16.04.26.2002','Tanjung Menang'),
('16.04.26.2003','Lubuk Pedaro'),
('16.04.26.2004','Suka Merindu'),
('16.04.26.2005','Tanjung Beringin'),
('16.04.26.2006','Talang Akar'),
('16.04.26.2007','Lubuk Betung'),
('16.04.26.2008','Perangai'),
('16.04.26.2009','Geramat'),
('16.04.27','Tanjungtebat'),
('16.04.27.2001','Pandan Arang Ilir'),
('16.04.27.2002','Tanjung Kurung Ulu'),
('16.04.27.2003','Tanjung Kurung Ilir'),
('16.04.27.2004','Tanjung Baru'),
('16.04.27.2005','Tanjung Nibung'),
('16.04.27.2006','TanjungTebat'),
('16.04.27.2007','Tanjung Bai'),
('16.04.27.2008','Tanjung Menang'),
('16.04.27.2009','Tanjung Raya'),
('16.04.27.2010','Air Dingin Lama'),
('16.04.27.2011','Air Dingin Baru'),
('16.04.27.2012','Muara Danau'),
('16.04.27.2013','Talang Jawa'),
('16.04.27.2014','Padang Perigi'),
('16.04.28','Muarapayang'),
('16.04.28.2001','Muara Payang'),
('16.04.28.2002','Muara Gelumpai'),
('16.04.28.2003','Talang Tinggi'),
('16.04.28.2004','Lawang Agung Lama'),
('16.04.28.2005','Lawang Agung Baru'),
('16.04.28.2006','Muara Jauh'),
('16.04.28.2007','Bandu Agung'),
('16.04.29','Sukamerindu'),
('16.04.29.2001','Sukamerindu'),
('16.04.29.2002','Guru Agung'),
('16.04.29.2003','Karang Caya'),
('16.04.29.2004','Gunung liwat'),
('16.04.29.2005','Kapitan'),
('16.04.29.2006','Rambai Kaca'),
('16.04.29.2007','Pagar Kaya'),
('16.04.29.2008','Tanjung Raya'),
('16.04.29.2009','Sukaraja'),
('16.04.29.2010','Tanjung Agung'),
('16.04.30','Mulak Sebingkai'),
('16.04.30.2001','Jadian Baru'),
('16.04.30.2002','Jadian Lama'),
('16.04.30.2003','Talang Berangin'),
('16.04.30.2004','Padang Bindu'),
('16.04.30.2005','Keban Agung'),
('16.04.30.2006','Danau Belidang'),
('16.04.30.2007','Talang Padang'),
('16.04.30.2008','Lubuk Dendan'),
('16.04.30.2009','Penandingan'),
('16.04.30.2010','Durian Dangkal'),
('16.04.31','Lahat Selatan'),
('16.04.31.2001','Banjar Negara'),
('16.04.31.2002','Tanjung Payang'),
('16.04.31.2003','Tanjung Tebat'),
('16.04.31.2004','Nantal'),
('16.04.31.2005','Karang Anyar'),
('16.04.31.2006','Karang Baru'),
('16.04.31.2007','Kerung'),
('16.04.31.2008','Muara Cawang'),
('16.04.31.2009','Talang Sawah'),
('16.04.31.2010','Talang Sejemput'),
('16.05','Kabupaten Musi Rawas'),
('16.05.01','Tugumulyo'),
('16.05.01.1001','B. Srikaton'),
('16.05.01.2002','Surodadi'),
('16.05.01.2003','Tegal Rejo'),
('16.05.01.2004','Trikoyo'),
('16.05.01.2005','Kalibening'),
('16.05.01.2006','Widodo'),
('16.05.01.2007','Wonokerto'),
('16.05.01.2008','Nawangsasi'),
('16.05.01.2009','Sukomulyo'),
('16.05.01.2010','Wukirsari'),
('16.05.01.2011','Ngadirejo'),
('16.05.01.2012','Dwijaya'),
('16.05.01.2013','Siti Harjo'),
('16.05.01.2014','Mataram'),
('16.05.01.2015','Tambahasri'),
('16.05.01.2016','Wonorejo'),
('16.05.01.2017','Sidoharjo'),
('16.05.01.2018','Triwikaton'),
('16.05.02','Muara Lakitan'),
('16.05.02.1019','Muara Lakitan'),
('16.05.02.2001','Tri Anggun Jaya'),
('16.05.02.2002','Semangus'),
('16.05.02.2003','Anyar'),
('16.05.02.2004','Muara Rengas'),
('16.05.02.2005','Sungai Pinang'),
('16.05.02.2006','Semeteh'),
('16.05.02.2007','Prabumulih II'),
('16.05.02.2008','Prabumulih I'),
('16.05.02.2009','Lubuk Pandan'),
('16.05.02.2010','Pelita Jaya'),
('16.05.02.2011','Sidomulyo'),
('16.05.02.2012','Marga Baru'),
('16.05.02.2013','Pendingan'),
('16.05.02.2014','Bumi Makmur'),
('16.05.02.2015','Mukti Karya'),
('16.05.02.2016','Harapan Makmur'),
('16.05.02.2017','Pian Raya'),
('16.05.02.2018','Sindang Laya'),
('16.05.02.2020','Semanggus Baru'),
('16.05.03','Muara Kelingi'),
('16.05.03.1013','Muara Kelingi'),
('16.05.03.2001','Binjai'),
('16.05.03.2002','Pulau Panggung'),
('16.05.03.2003','Tanjung Lama'),
('16.05.03.2012','Mandi Aur'),
('16.05.03.2014','Lubuk Tua'),
('16.05.03.2015','Mambang'),
('16.05.03.2016','Bingin Janggut'),
('16.05.03.2017','Tugu Sempurna'),
('16.05.03.2019','Marga Sakti'),
('16.05.03.2021','Karya Sakti'),
('16.05.03.2022','Petrans Jaya'),
('16.05.03.2023','Karya Mukti'),
('16.05.03.2024','Beliti Jaya'),
('16.05.03.2026','Karya Teladan'),
('16.05.03.2027','Temuan Sari'),
('16.05.03.2028','Temuan Jaya'),
('16.05.03.2029','Mekar Sari'),
('16.05.03.2030','Mangan Jaya'),
('16.05.03.2031','Lubuk Muda'),
('16.05.03.2032','Sukamenang'),
('16.05.08','Jayaloka'),
('16.05.08.1006','Marga Tunggal'),
('16.05.08.2001','Giri Yoso'),
('16.05.08.2002','Kertosono'),
('16.05.08.2003','Margoyoso'),
('16.05.08.2004','Bumi Rejo'),
('16.05.08.2005','Sidodadi'),
('16.05.08.2007','Marga Tani'),
('16.05.08.2008','Sukowono'),
('16.05.08.2010','Purwodadi'),
('16.05.08.2012','Dono Rejo'),
('16.05.08.2015','Ngesti Boga I'),
('16.05.08.2016','Ngesti Boga II'),
('16.05.08.2020','Ngestikarya'),
('16.05.09','Muara Beliti'),
('16.05.09.1003','Pasar Muara Beliti'),
('16.05.09.2001','Pedang'),
('16.05.09.2002','Muara Beliti Baru'),
('16.05.09.2004','Mana Resmi'),
('16.05.09.2005','Bumi Agung'),
('16.05.09.2014','Suro'),
('16.05.09.2015','Tanah Periuk'),
('16.05.09.2016','Ketuan Jaya'),
('16.05.09.2017','Air Satan'),
('16.05.09.2018','Durian Remuk'),
('16.05.09.2019','Satan Indah Jaya'),
('16.05.09.2020','Air Lesing'),
('16.05.10','STL Ulu Terawas'),
('16.05.10.1017','Terawas'),
('16.05.10.2001','Sumber Karya'),
('16.05.10.2002','Suko Rejo'),
('16.05.10.2003','Suka Karya'),
('16.05.10.2011','Sri Mulyo'),
('16.05.10.2014','Sukamerindu'),
('16.05.10.2015','Paduraksa'),
('16.05.10.2016','Babat'),
('16.05.10.2018','Pasenan'),
('16.05.10.2019','Sukaraya'),
('16.05.10.2020','Sukamana'),
('16.05.10.2021','Kosgoro'),
('16.05.10.2022','Sukaraya Baru'),
('16.05.11','Selangit'),
('16.05.11.1001','Selangit'),
('16.05.11.2002','Lubuk Ngin'),
('16.05.11.2003','Napal Melintang'),
('16.05.11.2004','Taba Tengah'),
('16.05.11.2005','Taba Remanik'),
('16.05.11.2006','Batu Gane'),
('16.05.11.2007','Karang Panggung'),
('16.05.11.2008','Muara Nilau'),
('16.05.11.2009','Perabumenang'),
('16.05.11.2010','Taba Rena'),
('16.05.11.2011','Taba Gindo'),
('16.05.11.2012','Lubuk Ngin Baru'),
('16.05.12','Megang Sakti'),
('16.05.12.1001','Megang Sakti I'),
('16.05.12.1021','Talang Ubi'),
('16.05.12.2002','Muara Megang'),
('16.05.12.2003','Megang Sakti II'),
('16.05.12.2004','Megang Sakti III'),
('16.05.12.2005','Megang Sakti IV'),
('16.05.12.2006','Jajaran Baru'),
('16.05.12.2007','Sumber Rejo'),
('16.05.12.2008','Rejo Sari'),
('16.05.12.2009','Mekar Sari'),
('16.05.12.2010','Campur Sari'),
('16.05.12.2011','Tegal Sari'),
('16.05.12.2012','Marga Puspita'),
('16.05.12.2013','Megang Sakti V'),
('16.05.12.2014','Pagar Ayu'),
('16.05.12.2015','Karya Mulia'),
('16.05.12.2016','Wonosari'),
('16.05.12.2017','Trisakti'),
('16.05.12.2018','Jajaran Baru II'),
('16.05.12.2019','Muara Megang I'),
('16.05.12.2020','Mulyo Sari'),
('16.05.13','Purwodadi'),
('16.05.13.1005','Purwodadi'),
('16.05.13.1007','Mangun Harjo'),
('16.05.13.2001','Bangun Sari'),
('16.05.13.2002','Kerto Sari'),
('16.05.13.2003','Pagar Sari'),
('16.05.13.2004','Mardi Harjo'),
('16.05.13.2006','Karya Dadi'),
('16.05.13.2008','Rejo Sari'),
('16.05.13.2009','Sadar Karya'),
('16.05.13.2010','Purwakarya'),
('16.05.13.2011','Tri Karya'),
('16.05.14','BTS. Ulu'),
('16.05.14.1017','Bangun Jaya'),
('16.05.14.2001','Kembang Tanjung'),
('16.05.14.2002','Gn. Kembang Baru'),
('16.05.14.2003','Gn. Kembang Lama'),
('16.05.14.2004','Sungai Bunut'),
('16.05.14.2005','Sungai Naik'),
('16.05.14.2006','Pangkalan T. Lama'),
('16.05.14.2007','Sadu'),
('16.05.14.2008','Tambangan'),
('16.05.14.2009','Pelawe'),
('16.05.14.2010','Lubuk Pauh'),
('16.05.14.2011','Tri Jaya'),
('16.05.14.2012','Mulyo Harjo'),
('16.05.14.2013','Suka Makmur'),
('16.05.14.2014','Raksa Budi'),
('16.05.14.2015','Kota Baru'),
('16.05.14.2016','Trimukti'),
('16.05.14.2018','Mekar Jaya'),
('16.05.14.2019','Sembatu Jaya'),
('16.05.18','Tiang Pumpung Kepungut'),
('16.05.18.2001','Lubuk Besar'),
('16.05.18.2002','Batu Bandung'),
('16.05.18.2003','Rantau Bingin'),
('16.05.18.2004','Rantau Serik'),
('16.05.18.2005','Muara Kati Lama'),
('16.05.18.2006','Muara Kati Baru I'),
('16.05.18.2007','Muara Kati Baru II'),
('16.05.18.2008','Kebur'),
('16.05.18.2009','Simpang Gegas Temuan'),
('16.05.18.2010','Kebur Jaya'),
('16.05.19','Sumber Harta'),
('16.05.19.1002','Sumber Harta'),
('16.05.19.2001','Sumber Jaya'),
('16.05.19.2003','Sukamaju'),
('16.05.19.2004','Jamburejo'),
('16.05.19.2005','Sumber Sari'),
('16.05.19.2006','Suka Mulya'),
('16.05.19.2007','Sukajaya'),
('16.05.19.2008','Madang'),
('16.05.19.2009','Sukarami Jaya'),
('16.05.19.2010','Sumber Asri'),
('16.05.20','Tuah Negeri'),
('16.05.20.2001','Banpres'),
('16.05.20.2002','Jaya Tunggal'),
('16.05.20.2003','Sukamulya'),
('16.05.20.2004','Darma Sakti'),
('16.05.20.2005','Jaya Bhakti'),
('16.05.20.2006','Remayu'),
('16.05.20.2007','Petunang'),
('16.05.20.2008','Lubuk Rumbai'),
('16.05.20.2009','Air Beliti'),
('16.05.20.2010','Leban Jaya'),
('16.05.20.2011','Bamasco'),
('16.05.21','Suka Karya'),
('16.05.21.2001','Sukowarno'),
('16.05.21.2002','Sugih Waras'),
('16.05.21.2003','Bangun Rejo'),
('16.05.21.2004','Ciptodadi'),
('16.05.21.2005','Sukarena'),
('16.05.21.2006','Yudha Karya Bakti'),
('16.05.21.2007','Rantau Alih'),
('16.05.21.2008','Ciptodadi II'),
('16.06','Kabupaten Musi Banyuasin'),
('16.06.01','Sekayu'),
('16.06.01.1009','Kayu Ara'),
('16.06.01.1010','Serasan Jaya'),
('16.06.01.1011','Soak baru'),
('16.06.01.1012','Balai Agung'),
('16.06.01.2001','Sukarami'),
('16.06.01.2002','Lumpatan'),
('16.06.01.2003','Bailangu'),
('16.06.01.2004','Muara Teladan'),
('16.06.01.2005','Bandar Jaya'),
('16.06.01.2006','Sungai Medak'),
('16.06.01.2007','Sungai Batang'),
('16.06.01.2008','Rimba Ukur'),
('16.06.01.2013','Lumpatan 2'),
('16.06.01.2014','Baliangu Timur'),
('16.06.02','Lais'),
('16.06.02.2001','Danau Cala'),
('16.06.02.2002','Rantau Keroya'),
('16.06.02.2003','Tanjung Agung Timur'),
('16.06.02.2004','Petaling'),
('16.06.02.2005','Lais'),
('16.06.02.2006','Teluk'),
('16.06.02.2007','Epil'),
('16.06.02.2008','Purwosari'),
('16.06.02.2009','Teluk Kijing I'),
('16.06.02.2010','Teluk Kijing II'),
('16.06.02.2011','Teluk Kijing III'),
('16.06.02.2012','Tanjung Agung Utara'),
('16.06.02.2013','Tanjung Agung Barat'),
('16.06.02.2014','Tanjung Agung Selatan'),
('16.06.02.2015','Lais Utara'),
('16.06.02.2016','Epil Barat'),
('16.06.03','Sungai Keruh'),
('16.06.03.2002','Pagar Kaya'),
('16.06.03.2003','Sukalali'),
('16.06.03.2004','Kartayu'),
('16.06.03.2006','Sungai Dua'),
('16.06.03.2007','Sindang Marga'),
('16.06.03.2008','Tebing Bulang'),
('16.06.03.2009','Gajah Mati'),
('16.06.03.2010','Rantau Sialang'),
('16.06.03.2014','Kerta Jaya'),
('16.06.03.2015','Keramat Jaya'),
('16.06.04','Batang Hari Leko'),
('16.06.04.2001','Bukit Sejahtera'),
('16.06.04.2002','Bukit Pangkuasan'),
('16.06.04.2003','Tanah Abang'),
('16.06.04.2004','Talang Leban'),
('16.06.04.2005','Talang Buluh'),
('16.06.04.2006','Lubuk Buah'),
('16.06.04.2007','Sungai Napal'),
('16.06.04.2008','Lubuk Bintialo'),
('16.06.04.2009','Sako Suban'),
('16.06.04.2010','Bukit Selabu'),
('16.06.04.2011','Saut'),
('16.06.04.2012','Tanjung Bali'),
('16.06.04.2013','Pinggap'),
('16.06.04.2014','Pengaturan'),
('16.06.04.2015','Ulak Kembang'),
('16.06.04.2016','Pangkalan Bulian'),
('16.06.05','Sanga Desa'),
('16.06.05.1016','Ngulak I'),
('16.06.05.1019','Ngulak'),
('16.06.05.2001','Air Balui'),
('16.06.05.2002','Nganti'),
('16.06.05.2003','Jud I'),
('16.06.05.2004','Jud II'),
('16.06.05.2005','Penggage'),
('16.06.05.2006','Ngunang'),
('16.06.05.2007','Ngulak II'),
('16.06.05.2008','Ngulak III'),
('16.06.05.2009','Ulak Embacang'),
('16.06.05.2010','Terusan'),
('16.06.05.2011','Kemang'),
('16.06.05.2012','Tanjung Raya'),
('16.06.05.2013','Air Itam'),
('16.06.05.2014','Keban I'),
('16.06.05.2015','Keban II'),
('16.06.05.2017','Panai'),
('16.06.05.2018','Macang Sakti'),
('16.06.06','Babat Toman'),
('16.06.06.1038','Babat'),
('16.06.06.1039','Mangun Jaya'),
('16.06.06.2001','Sereka'),
('16.06.06.2002','Sugi Raya'),
('16.06.06.2003','Sugi Waras'),
('16.06.06.2004','Beruge'),
('16.06.06.2005','Muara Punjung'),
('16.06.06.2007','Bangun Sari'),
('16.06.06.2008','Toman'),
('16.06.06.2009','Kasmaran'),
('16.06.06.2022','Sungai Angit'),
('16.06.06.2023','Srimulyo'),
('16.06.06.2042','Pangkalan Jaya'),
('16.06.06.2043','Toman Baru'),
('16.06.07','Sungai Lilin'),
('16.06.07.1020','Sungai Lilin'),
('16.06.07.1030','Sungai Lilin Jaya'),
('16.06.07.2007','Sri Gunung'),
('16.06.07.2008','Sumber Rejeki'),
('16.06.07.2009','Linggo Sari'),
('16.06.07.2010','Mulyo Rejo'),
('16.06.07.2011','Suka Damai Baru'),
('16.06.07.2012','Cinta Damai'),
('16.06.07.2013','Berlian Makmur'),
('16.06.07.2014','Bumi Kencana'),
('16.06.07.2015','Mekar Jadi'),
('16.06.07.2016','Nusa Serasan'),
('16.06.07.2017','Pinang Banjar'),
('16.06.07.2019','Panca Tunggal'),
('16.06.07.2021','Bukit Jaya'),
('16.06.08','Keluang'),
('16.06.08.1015','Keluang'),
('16.06.08.2001','Tenggaro'),
('16.06.08.2003','Tanjung Dalam'),
('16.06.08.2004','Dawas'),
('16.06.08.2005','Mekar Jaya'),
('16.06.08.2006','Sumber Agung'),
('16.06.08.2007','Karya Maju'),
('16.06.08.2008','Tegal Mulyo'),
('16.06.08.2009','Cipta Praja'),
('16.06.08.2010','Loka Jaya'),
('16.06.08.2011','Mekar Sari'),
('16.06.08.2012','Sido Rejo'),
('16.06.08.2013','Mulyo Asih'),
('16.06.08.2014','Sridamai'),
('16.06.09','Bayung Lencir'),
('16.06.09.1016','Bayung Lencir'),
('16.06.09.1065','Bayung Lencir Indah'),
('16.06.09.2006','Muara Merang'),
('16.06.09.2007','Mangsang'),
('16.06.09.2008','Tampang Baru'),
('16.06.09.2009','Kali Berau'),
('16.06.09.2010','Sindang Marga'),
('16.06.09.2011','Telang'),
('16.06.09.2012','Pagar Desa'),
('16.06.09.2013','Mendis'),
('16.06.09.2014','Pulai Gading'),
('16.06.09.2015','Muara Medak'),
('16.06.09.2017','Sukajaya'),
('16.06.09.2026','Senawar Jaya'),
('16.06.09.2048','Simpang Bayat'),
('16.06.09.2049','Bayat Ilir'),
('16.06.09.2050','Pangkalan Bayat'),
('16.06.09.2051','Muara Bahar'),
('16.06.09.2058','Mekar Jaya'),
('16.06.09.2059','Mendis Jaya'),
('16.06.09.2060','Kepayang'),
('16.06.09.2061','Wono Rejo'),
('16.06.09.2063','Lubuk Harjo'),
('16.06.10','Plakat Tinggi'),
('16.06.10.2001','Sido Mukti'),
('16.06.10.2002','Suka Damai'),
('16.06.10.2003','Suka Jaya'),
('16.06.10.2004','Suka Makmur'),
('16.06.10.2005','Suka Maju'),
('16.06.10.2006','Bangun Harja'),
('16.06.10.2007','Sido Rahayu'),
('16.06.10.2008','Bukit Indah'),
('16.06.10.2009','Warga Mulya'),
('16.06.10.2010','Tanjung Kaputran'),
('16.06.10.2011','Air Putih Ulu'),
('16.06.10.2012','Sialang Agung'),
('16.06.10.2013','Cinta Karya'),
('16.06.10.2014','Air Putih Ilir'),
('16.06.10.2015','Sumber Rejeki'),
('16.06.11','Lalan'),
('16.06.11.2001','Karang Agung'),
('16.06.11.2002','Karang Rejo'),
('16.06.11.2003','Karang Makmur'),
('16.06.11.2004','Perumpung Raya'),
('16.06.11.2005','Galih Sari'),
('16.06.11.2006','Karang Tirta'),
('16.06.11.2007','Purwo Agung'),
('16.06.11.2008','Karya Mukti'),
('16.06.11.2009','Sri Karang Rejo'),
('16.06.11.2010','Mekar Sari'),
('16.06.11.2011','Agung Jaya'),
('16.06.11.2012','Bumi Agung'),
('16.06.11.2013','Jaya Agung'),
('16.06.11.2014','Suka Makmur'),
('16.06.11.2015','Mandala Sari'),
('16.06.11.2016','Bandar Agung'),
('16.06.11.2017','Karang Sari'),
('16.06.11.2018','Sri Gading'),
('16.06.11.2019','Mulya Agung'),
('16.06.11.2020','Karang Mukti'),
('16.06.11.2021','Madya Mulya'),
('16.06.11.2022','Mulya Jaya'),
('16.06.11.2023','Sari Agung'),
('16.06.11.2024','Suka Jadi'),
('16.06.11.2025','Ringin Agung'),
('16.06.11.2026','Tri Mulya Agung'),
('16.06.11.2027','Mekar Jaya'),
('16.06.12','Tungkal Jaya'),
('16.06.12.2001','Peninggalan'),
('16.06.12.2002','Suka Damai'),
('16.06.12.2003','Berlian Jaya'),
('16.06.12.2004','Simpang Tungkal'),
('16.06.12.2005','Pangkalan Tungkal'),
('16.06.12.2006','Sumber Harum'),
('16.06.12.2007','Sumber Sari'),
('16.06.12.2008','Sinar Harapan'),
('16.06.12.2009','Banjar Jaya'),
('16.06.12.2010','Beji Mulyo'),
('16.06.12.2011','Bero Jaya Timur'),
('16.06.12.2012','Pandan Sari'),
('16.06.12.2013','Margo Mulyo'),
('16.06.12.2014','Sri Mulyo'),
('16.06.12.2015','Sido Mulyo'),
('16.06.12.2016','Sinar Tungkal'),
('16.06.13','Lawan Wetan'),
('16.06.13.2001','Ulak Paceh'),
('16.06.13.2002','Ulak Paceh Jaya'),
('16.06.13.2003','Tanjung Durian'),
('16.06.13.2004','Napal'),
('16.06.13.2005','Rantau Kasih'),
('16.06.13.2006','Karang Ringin I'),
('16.06.13.2007','Karang Ringin II'),
('16.06.13.2008','Ulak Teberau'),
('16.06.13.2009','Bumi Ayu'),
('16.06.13.2010','Karang Waru'),
('16.06.13.2011','Karang Anyar'),
('16.06.13.2012','Rantau Panjang'),
('16.06.13.2013','Simpang Sari'),
('16.06.13.2014','Talang Piase'),
('16.06.13.2015','Pandan Dulang'),
('16.06.14','Babat Supat'),
('16.06.14.2001','Suka Maju'),
('16.06.14.2002','Letang'),
('16.06.14.2003','Supat'),
('16.06.14.2004','Babat Banyuasin'),
('16.06.14.2005','Tanjung Kerang'),
('16.06.14.2006','Langkap'),
('16.06.14.2007','Gajah Mati'),
('16.06.14.2008','Tenggulang Jaya'),
('16.06.14.2009','Bandar Tenggulang'),
('16.06.14.2010','Sumber Jaya'),
('16.06.14.2011','Tenggulang Baru'),
('16.06.14.2012','Supat Barat'),
('16.06.14.2013','Supat Timur'),
('16.06.14.2014','Seratus Lapan'),
('16.06.14.2015','Babat Ramba Jaya'),
('16.06.14.2016','Gajah Muda'),
('16.06.15','Jirak Jaya'),
('16.06.15.2001','Jirak'),
('16.06.15.2002','Rukun Rahayu'),
('16.06.15.2003','Talang Simpang'),
('16.06.15.2004','Jembatan Gantung'),
('16.06.15.2005','Talang Mandung'),
('16.06.15.2006','Rejosari'),
('16.06.15.2007','Bangkit Jaya'),
('16.06.15.2008','Baru Jaya'),
('16.06.15.2009','Sinar Jaya'),
('16.06.15.2010','Setia Jaya'),
('16.06.15.2011','Mekar Jaya'),
('16.06.15.2012','Layan'),
('16.07','Kabupaten Banyuasin'),
('16.07.01','Banyuasin I'),
('16.07.01.1016','Mariana'),
('16.07.01.1021','Mariana Ilir'),
('16.07.01.2001','Sungai Rebo'),
('16.07.01.2002','Sungai Gerong'),
('16.07.01.2003','Merah Mata'),
('16.07.01.2004','Perajen'),
('16.07.01.2005','Cinta Manis Lama'),
('16.07.01.2008','Perambahan'),
('16.07.01.2011','Pematang Palas'),
('16.07.01.2012','Tirto Sari'),
('16.07.01.2014','Pulau Borang'),
('16.07.01.2025','Perambahan Baru'),
('16.07.01.2028','Duren Ijo'),
('16.07.02','Banyuasin II'),
('16.07.02.2001','Sungsang I'),
('16.07.02.2002','Sungsang II'),
('16.07.02.2003','Sungsang III'),
('16.07.02.2004','Sungsang IV'),
('16.07.02.2010','Teluk Payo'),
('16.07.02.2013','Tanah Pilih'),
('16.07.02.2015','Perajen Jaya'),
('16.07.02.2016','Rimau Sungsang'),
('16.07.02.2018','Marga Sungsang'),
('16.07.02.2019','Muara Sungsang'),
('16.07.03','Banyuasin III'),
('16.07.03.1008','Kayuara Kuning'),
('16.07.03.1009','Mulia Agung'),
('16.07.03.1012','Pangkalan Balai'),
('16.07.03.1023','Seterio'),
('16.07.03.1033','Kedondong Raye'),
('16.07.03.2006','Langkan'),
('16.07.03.2007','Pangkalan Panji'),
('16.07.03.2010','Lubuk Saung'),
('16.07.03.2011','Ujung Tanjung'),
('16.07.03.2013','Sidang Mas'),
('16.07.03.2014','Galang Tinggi'),
('16.07.03.2015','Petaling'),
('16.07.03.2016','Rimba Alai'),
('16.07.03.2017','Pelajau Ilir'),
('16.07.03.2018','Regan Agung'),
('16.07.03.2019','Suka Mulia'),
('16.07.03.2020','Tanjung Agung'),
('16.07.03.2021','Tanjung Menang'),
('16.07.03.2022','Sri Bandung'),
('16.07.03.2024','Pelajau'),
('16.07.03.2025','Tanjung Beringin'),
('16.07.03.2026','Terentang'),
('16.07.03.2028','Tanjung Kepayang'),
('16.07.03.2034','Sukaraja Baru'),
('16.07.03.2037','Terlangu'),
('16.07.03.2038','Rimba Balai'),
('16.07.04','Pulau Rimau'),
('16.07.04.2002','Teluk Betung'),
('16.07.04.2004','Mukut'),
('16.07.04.2006','Sumber Rejeki'),
('16.07.04.2007','Dana Mulya'),
('16.07.04.2008','Wana Mukti'),
('16.07.04.2009','Budi Asih'),
('16.07.04.2013','Rukun Makmur'),
('16.07.04.2014','Nunggal Sari'),
('16.07.04.2017','Majatra'),
('16.07.04.2018','Wonosari'),
('16.07.04.2031','Sumber Mulya'),
('16.07.04.2032','Rawa Banda'),
('16.07.04.2037','Senda Mukti'),
('16.07.04.2038','Tirta Mulya'),
('16.07.04.2039','Banjar Sari'),
('16.07.04.2040','Buana Murti'),
('16.07.04.2041','Tabuan Asri'),
('16.07.05','Betung'),
('16.07.05.1017','Betung'),
('16.07.05.1021','Rimba Asam'),
('16.07.05.1022','Betung Selatan'),
('16.07.05.2002','Pulau Rajak'),
('16.07.05.2003','Bukit'),
('16.07.05.2004','Sri Kembang'),
('16.07.05.2005','Lubuk Karet'),
('16.07.05.2014','Taja Mulya'),
('16.07.05.2015','Taja Raya I'),
('16.07.05.2016','Taja Indah'),
('16.07.05.2018','Taja Raya II'),
('16.07.05.2020','Suka Mulya'),
('16.07.06','Rambutan'),
('16.07.06.1021','Jakabaring Selatan'),
('16.07.06.2001','Kebon Sahang'),
('16.07.06.2002','Siju'),
('16.07.06.2003','Tanah Lembak'),
('16.07.06.2004','Parit'),
('16.07.06.2005','Pelaju'),
('16.07.06.2006','Suka Pindah'),
('16.07.06.2007','Baru'),
('16.07.06.2008','Tanjung Kerang'),
('16.07.06.2009','Rambutan'),
('16.07.06.2010','Tanjung Merbu'),
('16.07.06.2011','Sako'),
('16.07.06.2012','Gelebak Dalam'),
('16.07.06.2013','Menten'),
('16.07.06.2014','Pangkalan Gelebak'),
('16.07.06.2015','Sungai Dua'),
('16.07.06.2016','Sungai Pinang'),
('16.07.06.2017','Sungai Kedukan'),
('16.07.06.2019','Durian Gadis'),
('16.07.06.2020','Pulau Parang'),
('16.07.07','Muara Padang'),
('16.07.07.2001','Muara Padang'),
('16.07.07.2002','Tanjung Baru'),
('16.07.07.2003','Karang Anyar'),
('16.07.07.2006','Purwodadi'),
('16.07.07.2007','Sumber Makmur'),
('16.07.07.2008','Air Gading'),
('16.07.07.2009','Tirto Raharjo'),
('16.07.07.2010','Daya Utama'),
('16.07.07.2011','Daya Makmur'),
('16.07.07.2012','Sido Mulyo 18'),
('16.07.07.2013','Sido Rejo'),
('16.07.07.2018','Sido Mulyo 20'),
('16.07.07.2037','Margo Mulyo 20'),
('16.07.07.2038','Margo Sugihan'),
('16.07.07.2042','Tirta Jaya'),
('16.07.08','Muara Telang'),
('16.07.08.2007','Marga Rahayu'),
('16.07.08.2008','Sumber Mulya'),
('16.07.08.2009','Sumber Hidup'),
('16.07.08.2010','Telang Rejo'),
('16.07.08.2011','Telang Jaya'),
('16.07.08.2013','Telang Makmur'),
('16.07.08.2014','Telang Karya'),
('16.07.08.2015','Panca Mukti'),
('16.07.08.2016','Mukti Jaya'),
('16.07.08.2019','Mekar Sari'),
('16.07.08.2024','Talang Indah'),
('16.07.08.2025','Mekar Mukti'),
('16.07.08.2026','Upang Jaya'),
('16.07.08.2027','Upang Karya'),
('16.07.08.2028','Upang Cemara'),
('16.07.08.2029','Upang Ceria'),
('16.07.09','Makarti Jaya'),
('16.07.09.1012','Makarti Jaya'),
('16.07.09.2002','Delta Upang'),
('16.07.09.2006','Pendowo Harjo'),
('16.07.09.2007','Pangestu'),
('16.07.09.2008','Tirta Kencana'),
('16.07.09.2010','Upang Makmur'),
('16.07.09.2013','Upang Mulya'),
('16.07.09.2017','Purwosari'),
('16.07.09.2019','Tanjung Mas'),
('16.07.09.2020','Tanjung Baru'),
('16.07.09.2021','Sungai Semut'),
('16.07.09.2022','Muara Baru'),
('16.07.10','Talang Kelapa'),
('16.07.10.1002','Air Batu'),
('16.07.10.1003','Sukomoro'),
('16.07.10.1004','Sukajadi'),
('16.07.10.1006','Kenten'),
('16.07.10.1022','Tanah Mas'),
('16.07.10.1023','Talang Keramat'),
('16.07.10.1024','Sukajadi Timur'),
('16.07.10.1025','Tanah Mas Indah'),
('16.07.10.1026','Rawa Maju'),
('16.07.10.1027','Air Batu Jaya'),
('16.07.10.1028','Sei Sedapat'),
('16.07.10.1029','Azhar Permai'),
('16.07.10.1030','Keramat Raya'),
('16.07.10.2001','Sungai Rengit'),
('16.07.10.2005','Pangkalan Benteng'),
('16.07.10.2007','Gasing'),
('16.07.10.2019','Talang Buluh'),
('16.07.10.2020','Sungai Rengit Murni'),
('16.07.10.2021','Kenten Laut'),
('16.07.11','Rantau Bayur'),
('16.07.11.2001','Muara Abab'),
('16.07.11.2002','Tanjung Pasir'),
('16.07.11.2003','Tanjung Tiga'),
('16.07.11.2004','Rantau Bayur'),
('16.07.11.2005','Pagar Bulan'),
('16.07.11.2006','Kemang Bejalu'),
('16.07.11.2007','Tanjung Menang'),
('16.07.11.2008','Srijaya'),
('16.07.11.2009','Sejagung'),
('16.07.11.2010','Sungai Pinang'),
('16.07.11.2011','Semuntul'),
('16.07.11.2012','Lebung'),
('16.07.11.2013','Lubuk Rengas'),
('16.07.11.2014','Paldas'),
('16.07.11.2015','Tebing Abang'),
('16.07.11.2016','Talang Kemang'),
('16.07.11.2017','Rantau Harapan'),
('16.07.11.2018','Penandingan'),
('16.07.11.2019','Sungai Naik'),
('16.07.11.2020','Sungai Lilin'),
('16.07.11.2021','Sukarela'),
('16.07.12','Tanjung Lago'),
('16.07.12.2001','Telang Sari'),
('16.07.12.2002','Mulya Sari'),
('16.07.12.2003','Purwosari'),
('16.07.12.2004','Sri Menanti'),
('16.07.12.2005','Sebalik'),
('16.07.12.2006','Tanjung Lago'),
('16.07.12.2007','Kuala Puntian'),
('16.07.12.2008','Sukatani'),
('16.07.12.2009','Sukadamai'),
('16.07.12.2010','Banyu Urip'),
('16.07.12.2011','Bangun Sari'),
('16.07.12.2012','Sumber Mekar Mukti'),
('16.07.12.2013','Muara Sugih'),
('16.07.12.2014','Manggar Raya'),
('16.07.12.2015','Bunga Karang'),
('16.07.13','Muara Sugihan'),
('16.07.13.2001','Margo Mulyo 16'),
('16.07.13.2002','Rejo Sari'),
('16.07.13.2003','Daya Murni'),
('16.07.13.2004','Daya Bangun Harjo'),
('16.07.13.2005','Sumber Mulyo'),
('16.07.13.2006','Sugih Waras'),
('16.07.13.2007','Indrapura'),
('16.07.13.2008','Cendana'),
('16.07.13.2009','Argo Mulyo'),
('16.07.13.2010','Tirta Harja'),
('16.07.13.2011','Tirta Mulya'),
('16.07.13.2012','Daya Kesuma'),
('16.07.13.2013','Margo Rukun'),
('16.07.13.2014','Ganesha Mukti'),
('16.07.13.2015','Timbul Jaya'),
('16.07.13.2016','Jalur Mulya'),
('16.07.13.2017','Gilirang'),
('16.07.13.2018','Juru Taro'),
('16.07.13.2019','Kuala Sugihan'),
('16.07.13.2020','Beringin Agung'),
('16.07.13.2021','Mekar Jaya'),
('16.07.13.2022','Sido Makmur'),
('16.07.14','Air Salek'),
('16.07.14.2001','Air Solok Batu'),
('16.07.14.2002','Sri Mulyo'),
('16.07.14.2003','Srikaton'),
('16.07.14.2004','Sidoharjo'),
('16.07.14.2005','Bintaran'),
('16.07.14.2006','Damar Wulan'),
('16.07.14.2007','Enggal Rejo'),
('16.07.14.2008','Saleh Jaya'),
('16.07.14.2009','Saleh Agung'),
('16.07.14.2010','Saleh Mulya'),
('16.07.14.2011','Saleh Mukti'),
('16.07.14.2012','Saleh Makmur'),
('16.07.14.2013','Upang'),
('16.07.14.2014','Upang Marga'),
('16.07.15','Tungkal Ilir'),
('16.07.15.2001','Bentayan'),
('16.07.15.2002','Teluk Tenggulang'),
('16.07.15.2004','Suka Mulya'),
('16.07.15.2005','Suka Raja'),
('16.07.15.2006','Karang Anyar'),
('16.07.15.2007','Karang Asem'),
('16.07.15.2008','Marga Rahayu'),
('16.07.15.2009','Sido Mulyo'),
('16.07.15.2010','Keluang'),
('16.07.15.2011','Bumi Serdang'),
('16.07.15.2012','Karang Mulya'),
('16.07.15.2013','Suka Karya'),
('16.07.15.2014','Panca Mulya'),
('16.07.15.2015','Suka Jaya'),
('16.07.16','Suak Tapeh'),
('16.07.16.2001','Talang Ipuh'),
('16.07.16.2002','Durian Daun'),
('16.07.16.2003','Lubuk Lancang'),
('16.07.16.2004','Biyuku'),
('16.07.16.2005','Bengkuang'),
('16.07.16.2006','Rimba Terap'),
('16.07.16.2007','Sedang'),
('16.07.16.2008','Tanjung Laut'),
('16.07.16.2009','Air Senggeris'),
('16.07.16.2010','Meranti'),
('16.07.16.2011','Sukaraja'),
('16.07.17','Sembawa'),
('16.07.17.2001','Mainan'),
('16.07.17.2002','Santan Sari'),
('16.07.17.2003','Limau'),
('16.07.17.2004','Rejodadi'),
('16.07.17.2005','Lalang Sembawa'),
('16.07.17.2006','Muara Damai'),
('16.07.17.2007','Pulau Harapan'),
('16.07.17.2008','Purwosari'),
('16.07.17.2009','Limbang Mulia'),
('16.07.17.2010','Sako Makmur'),
('16.07.17.2011','Pulau Muning'),
('16.07.18','Sumber Marga Telang'),
('16.07.18.2001','Terusan Dalam'),
('16.07.18.2002','Karang Anyar'),
('16.07.18.2003','Muara Telang'),
('16.07.18.2004','Terusan Tengah'),
('16.07.18.2005','Sumber Jaya'),
('16.07.18.2006','Karang Baru'),
('16.07.18.2007','Muara Telang Marga'),
('16.07.18.2008','Terusan Muara'),
('16.07.18.2009','Talang Lubuk'),
('16.07.18.2010','Sri Tiga'),
('16.07.19','Air Kumbang'),
('16.07.19.2001','Cinta Manis Baru'),
('16.07.19.2002','Sido Makmur'),
('16.07.19.2003','Sidomulyo'),
('16.07.19.2004','Nusa Makmur'),
('16.07.19.2005','Rimba Jaya'),
('16.07.19.2006','Teluk Tenggirik'),
('16.07.19.2007','Sebubus'),
('16.07.19.2008','Padang Rejo'),
('16.07.19.2009','Kumbang Padang Permata'),
('16.07.19.2010','Muara Baru'),
('16.07.19.2011','Tirta Makmur'),
('16.07.19.2012','Panca Mulya'),
('16.07.19.2013','Budi Mulya'),
('16.07.19.2014','Panca Desa'),
('16.07.19.2015','Air Kumbang Bakti'),
('16.07.19.2016','Sebokor'),
('16.07.20','Karang Agung Ilir'),
('16.07.20.2001','Karang Sari'),
('16.07.20.2002','Maju Ria'),
('16.07.20.2003','Sri Agung'),
('16.07.20.2004','Sumber Rejeki'),
('16.07.20.2005','Tabala Jaya'),
('16.07.20.2006','Jati Sari'),
('16.07.20.2007','Mekar Sari'),
('16.07.21','Selat Penuguan'),
('16.07.21.2001','Penuguan'),
('16.07.21.2002','Sumber Rejo'),
('16.07.21.2003','Sumber Mukti'),
('16.07.21.2004','Sumber Agung'),
('16.07.21.2005','Wonodadi'),
('16.07.21.2006','Mekar Sari'),
('16.07.21.2007','Songo Makmur'),
('16.07.21.2008','Karang Manunggal'),
('16.07.21.2009','Purwodadi'),
('16.07.21.2010','Ringin Harjo'),
('16.07.21.2011','Bumi Rejo'),
('16.07.21.2012','Kelapa Dua'),
('16.08','Kabupaten Ogan Komering Ulu Timur'),
('16.08.01','Martapura'),
('16.08.01.1007','Dusun Martapura'),
('16.08.01.1008','Pasar Martapura'),
('16.08.01.1014','Paku Sengkunyit'),
('16.08.01.1016','Bukit Sari'),
('16.08.01.1017','Sungai Tuha Jaya'),
('16.08.01.1018','Terukis Rahayu'),
('16.08.01.1019','Veteran Jaya'),
('16.08.01.2006','Tanjung Kemala'),
('16.08.01.2009','Kota Baru'),
('16.08.01.2010','Keromongan'),
('16.08.01.2011','Perjaya'),
('16.08.01.2015','Sukomulyo'),
('16.08.01.2020','Kotabaru Barat'),
('16.08.01.2021','Kotabaru Selatan'),
('16.08.01.2022','Perjaya Barat'),
('16.08.01.2023','Tanjung Kemala Barat'),
('16.08.02','Buay Madang'),
('16.08.02.2001','Suka Raja'),
('16.08.02.2002','Kurungan Nyawa'),
('16.08.02.2003','Pisang Jaya'),
('16.08.02.2004','Sumber Agung'),
('16.08.02.2005','Tebat Jaya'),
('16.08.02.2006','Sridadi'),
('16.08.02.2009','Tanjung Bulan'),
('16.08.02.2010','Way Halom'),
('16.08.02.2031','Kurungan Nyawa I'),
('16.08.02.2032','Kurungan Nyawa II'),
('16.08.02.2033','Kurungan Nyawa III'),
('16.08.02.2034','Cipta Muda'),
('16.08.02.2035','Aman Jaya'),
('16.08.02.2036','Sukaraja Tuha'),
('16.08.02.2037','Ganjar Agung'),
('16.08.02.2038','Mulyo Agung'),
('16.08.02.2039','Muda Sentosa'),
('16.08.03','Belitang'),
('16.08.03.2001','Sido Rahayu'),
('16.08.03.2002','Tawang Rejo'),
('16.08.03.2006','Tanjung Raya'),
('16.08.03.2007','Sido Mulyo'),
('16.08.03.2008','Harjo Winangun'),
('16.08.03.2009','Pujo Rahayu'),
('16.08.03.2010','Triyoso'),
('16.08.03.2011','Sumber Suko'),
('16.08.03.2013','Suko Sari'),
('16.08.03.2014','Gumawang'),
('16.08.03.2015','Bedilan'),
('16.08.03.2016','Tegal Rejo'),
('16.08.03.2017','Sido Gede'),
('16.08.03.2018','Sido Makmur'),
('16.08.03.2021','Suka Jadi'),
('16.08.03.2022','Serbaguna'),
('16.08.03.2023','Sukarami'),
('16.08.03.2024','Gedung Rejo'),
('16.08.03.2025','Sidodadi'),
('16.08.03.2026','Gunung Mas'),
('16.08.03.2027','Sumbersuko jaya'),
('16.08.03.2028','Karang Kemiri'),
('16.08.03.2029','Mojosari'),
('16.08.04','Cempaka'),
('16.08.04.2001','Gunung Batu'),
('16.08.04.2010','Ulak Baru'),
('16.08.04.2011','Gunung Jati'),
('16.08.04.2012','Kuripan'),
('16.08.04.2013','Negeri Sakti'),
('16.08.04.2014','Campang Tiga Hulu'),
('16.08.04.2015','Sukaraja'),
('16.08.04.2016','Cempaka'),
('16.08.04.2017','Sukabumi'),
('16.08.04.2018','Campang Tiga Ilir'),
('16.08.04.2019','Maluai Indah'),
('16.08.04.2020','Harisan Jaya'),
('16.08.04.2021','Campang Tiga Jaya'),
('16.08.05','Buay Pemuka Peliung'),
('16.08.05.2001','Negeri Pakuan'),
('16.08.05.2002','Negeri Agung'),
('16.08.05.2003','Banu Mas'),
('16.08.05.2004','Banu Ayu'),
('16.08.05.2005','Pulau Negara'),
('16.08.05.2006','Saung Dadi'),
('16.08.05.2007','Trantang Sakti'),
('16.08.05.2008','Pemetung Besuki'),
('16.08.05.2009','Pahang Asri'),
('16.08.05.2010','Bantan'),
('16.08.05.2011','Bandar Jaya'),
('16.08.05.2012','Negeri Agung Jaya'),
('16.08.05.2013','Bantan Pelita'),
('16.08.06','Madang Suku II'),
('16.08.06.2001','Karang Negara'),
('16.08.06.2002','Riang Bandung'),
('16.08.06.2005','Kota Negara'),
('16.08.06.2006','Karta Negara'),
('16.08.06.2007','Pandan Agung'),
('16.08.06.2009','Sri Mulyo'),
('16.08.06.2010','Margo Tani'),
('16.08.06.2011','Jati Mulya II'),
('16.08.06.2012','Pandan Jaya'),
('16.08.06.2014','Rasuan Baru'),
('16.08.06.2020','Banbanrejo'),
('16.08.06.2021','Suka Negara'),
('16.08.06.2022','Srikencana'),
('16.08.06.2023','Dadimulyo'),
('16.08.06.2024','Riang Bandung Ilir'),
('16.08.06.2025','Margotani II'),
('16.08.06.2026','Kota Negara Timur'),
('16.08.06.2027','Talang Giring'),
('16.08.06.2028','Kalirejo'),
('16.08.07','Madang Suku I'),
('16.08.07.2002','Mendayun'),
('16.08.07.2003','Gunung Terang'),
('16.08.07.2004','Karta Mulya'),
('16.08.07.2007','SP. Kerta Mulya'),
('16.08.07.2014','Harjo Mulyo'),
('16.08.07.2015','Jaya Bakti'),
('16.08.07.2016','Rasuan'),
('16.08.07.2017','Mengulak'),
('16.08.07.2019','Jati Sari'),
('16.08.07.2021','Tri Dadi'),
('16.08.07.2022','Agung Jati'),
('16.08.07.2023','Rasuan Darat'),
('16.08.07.2024','Harjo Mulyo Jaya'),
('16.08.08','Semendawai Suku III'),
('16.08.08.2002','Jaya Mulya'),
('16.08.08.2003','Gunung Sugih'),
('16.08.08.2007','Margo Rejo'),
('16.08.08.2009','Trimoharjo'),
('16.08.08.2010','Taman Agung'),
('16.08.08.2011','Krujon'),
('16.08.08.2013','Karang Endah'),
('16.08.08.2014','Sriwangi'),
('16.08.08.2015','Cahaya Negeri'),
('16.08.08.2016','Suka Mulya'),
('16.08.08.2017','Taraman'),
('16.08.08.2025','Mujo Rahayu'),
('16.08.08.2026','Taman Harjo'),
('16.08.08.2027','Margodadi'),
('16.08.08.2028','Taraman Jaya'),
('16.08.08.2029','Karang Marga'),
('16.08.08.2030','Trimo Rejo'),
('16.08.08.2031','Sriwangi Ulu'),
('16.08.08.2032','Taman Mulyo'),
('16.08.09','Belitang II'),
('16.08.09.2004','Tanjung Kemuning'),
('16.08.09.2005','Raman Jaya'),
('16.08.09.2006','Sumber Jaya'),
('16.08.09.2007','Sumber Rejo'),
('16.08.09.2008','Sumber Sari'),
('16.08.09.2009','Tegal Sari'),
('16.08.09.2010','Sri Bantolo'),
('16.08.09.2011','Sumber Rahayu'),
('16.08.09.2012','Margo Mulyo'),
('16.08.09.2015','Purwosari'),
('16.08.09.2016','Karang Manik'),
('16.08.09.2017','Sumber Harapan'),
('16.08.09.2018','Keli Rejo'),
('16.08.09.2019','Toto Rejo'),
('16.08.09.2020','Karang Jaya'),
('16.08.09.2021','Kemuning Jaya'),
('16.08.09.2022','Bangun Rejo'),
('16.08.09.2023','Batu Mas'),
('16.08.09.2024','Suka Jaya'),
('16.08.09.2025','Srijaya'),
('16.08.09.2026','Tegal Besar'),
('16.08.09.2027','Darma Buana'),
('16.08.09.2028','Rejo Mulyo'),
('16.08.09.2029','Purworejo'),
('16.08.10','Belitang III'),
('16.08.10.2001','Kutosari'),
('16.08.10.2002','Nusa Raya'),
('16.08.10.2003','Nusa Tunggal'),
('16.08.10.2004','Nusa Bali'),
('16.08.10.2005','Nusa Bakti'),
('16.08.10.2006','Nusa Jaya'),
('16.08.10.2007','Nusa Tenggara'),
('16.08.10.2008','Nusa Agung'),
('16.08.10.2009','Nusa Maju'),
('16.08.10.2010','Senu Marga'),
('16.08.10.2011','Karang Sari'),
('16.08.10.2013','Trikarya'),
('16.08.10.2016','Suka Negara'),
('16.08.10.2017','Karang Jadi'),
('16.08.10.2018','Dadi Rejo'),
('16.08.10.2019','Ganti Warno'),
('16.08.10.2020','Sinar Bali'),
('16.08.10.2021','Sumber Rejo'),
('16.08.10.2022','Ringin Sari'),
('16.08.10.2023','Karya Maju'),
('16.08.11','Bunga Mayang'),
('16.08.11.2001','Batu Raja Bungin'),
('16.08.11.2002','Tulang Bawang'),
('16.08.11.2003','Sabahlioh'),
('16.08.11.2004','Negeri Ratu'),
('16.08.11.2005','Peracak'),
('16.08.11.2006','Negeri Ratu Baru'),
('16.08.11.2007','Tunas Peracak'),
('16.08.11.2008','Sukabaru'),
('16.08.12','Buay Madang Timur'),
('16.08.12.2001','Tanjung Mas'),
('16.08.12.2002','Tanjungsari'),
('16.08.12.2003','Teko Rejo'),
('16.08.12.2004','Sumber Asri'),
('16.08.12.2005','Suka Maju'),
('16.08.12.2006','Srikaton'),
('16.08.12.2007','Liman Sari'),
('16.08.12.2008','Sumber Harjo'),
('16.08.12.2009','Sumber Mulyo'),
('16.08.12.2010','Karang Tengah'),
('16.08.12.2011','Bangun Harjo'),
('16.08.12.2012','Tambak Boyo'),
('16.08.12.2013','Pengandonan'),
('16.08.12.2014','Rejo Dadi'),
('16.08.12.2015','Sukoharjo'),
('16.08.12.2016','Sumedang Sari'),
('16.08.12.2017','Rowodadi'),
('16.08.12.2018','Sukodadi'),
('16.08.12.2019','Kumpul Rejo'),
('16.08.12.2020','Metro Rejo'),
('16.08.12.2021','Kedu'),
('16.08.12.2022','Kedung Rejo'),
('16.08.12.2023','Banyumas Asri'),
('16.08.12.2024','Gumuk Rejo'),
('16.08.12.2025','Tanjung Mulya'),
('16.08.12.2026','Raman Agung'),
('16.08.12.2027','Bukit Mas'),
('16.08.12.2028','Tanjung Agung'),
('16.08.12.2029','Berasan Mulya'),
('16.08.12.2030','Sumber Tani'),
('16.08.13','Madang Suku III'),
('16.08.13.2001','Banding Agung'),
('16.08.13.2002','Nikan'),
('16.08.13.2003','Surabaya'),
('16.08.13.2004','Wana Bakti'),
('16.08.13.2005','Batu Marta VI'),
('16.08.13.2006','Karya Makmur'),
('16.08.13.2007','Bina Amarta'),
('16.08.13.2008','Suka Damai'),
('16.08.13.2009','Batu Marta X'),
('16.08.13.2010','Marta V Jaya'),
('16.08.14','Semendawai Barat'),
('16.08.14.2001','Tanjung Kukuh'),
('16.08.14.2002','Betung'),
('16.08.14.2003','Tanjung Mas'),
('16.08.14.2004','Menanga Besar'),
('16.08.14.2005','Menanga Tengah'),
('16.08.14.2006','Adu manis'),
('16.08.14.2007','Suka Negeri'),
('16.08.14.2008','Kangkung'),
('16.08.14.2009','Sri Tanjung'),
('16.08.14.2010','Kangkung Ilir'),
('16.08.14.2011','Betung Timur'),
('16.08.14.2012','Menanga Sari'),
('16.08.15','Semendawai Timur'),
('16.08.15.2001','Karang Melati'),
('16.08.15.2002','Karang Menjangan'),
('16.08.15.2003','Karang Anyar'),
('16.08.15.2004','Tulung Harapan'),
('16.08.15.2005','Kota Tanah'),
('16.08.15.2006','Nirwana'),
('16.08.15.2007','Burnai Mulya'),
('16.08.15.2008','Kota Mulya'),
('16.08.15.2009','Bungin Jaya'),
('16.08.15.2010','Burnai Jaya'),
('16.08.15.2011','Mulia Jaya'),
('16.08.15.2012','Melati Jaya'),
('16.08.15.2013','Karang Mulya'),
('16.08.15.2014','Wanasari'),
('16.08.15.2015','Harapan Jaya'),
('16.08.15.2016','Melati Agung'),
('16.08.15.2017','Wana Makmur'),
('16.08.15.2018','Bawang Tikar'),
('16.08.15.2019','Karya Bakti'),
('16.08.16','Jayapura'),
('16.08.16.2001','Jayapura'),
('16.08.16.2002','Bunga Mayang'),
('16.08.16.2003','Way Salak'),
('16.08.16.2004','Mendah'),
('16.08.16.2005','Tumijaya'),
('16.08.16.2006','Condong'),
('16.08.16.2007','Peracak Jaya'),
('16.08.16.2008','Kambang'),
('16.08.17','Belitang Jaya'),
('16.08.17.2001','Rejosari'),
('16.08.17.2002','Sido Rejo'),
('16.08.17.2003','Banjar Rejo'),
('16.08.17.2004','Panca Tunggal'),
('16.08.17.2005','Marga Koyo'),
('16.08.17.2006','Sumber Agung'),
('16.08.17.2007','Karsa Jaya'),
('16.08.17.2008','Windusari'),
('16.08.17.2009','Karya Makmur'),
('16.08.17.2010','Giri Mulyo'),
('16.08.17.2011','Madugondo'),
('16.08.17.2012','Argomulyo'),
('16.08.17.2013','Rejosari Jaya'),
('16.08.18','Belitang Madang Raya'),
('16.08.18.2001','Tugu Mulyo'),
('16.08.18.2002','Bangsa Negara'),
('16.08.18.2003','Tugu Harum'),
('16.08.18.2004','Tulus Ayu'),
('16.08.18.2005','Yosowinangun'),
('16.08.18.2006','Karang Binangun'),
('16.08.18.2007','Jati Mulyo I'),
('16.08.18.2008','Pandan Sari I'),
('16.08.18.2009','Pelita Jaya'),
('16.08.18.2010','Mekar Jaya'),
('16.08.18.2011','Lubuk Harjo'),
('16.08.18.2012','Tanah Merah'),
('16.08.18.2013','Rantau Jaya'),
('16.08.18.2014','Tebing Sari Mulya'),
('16.08.18.2015','Marga Cinta'),
('16.08.18.2016','Karang Binangun II'),
('16.08.19','Belitang Mulya'),
('16.08.19.2001','Sari Guna'),
('16.08.19.2002','Sido Waluyo'),
('16.08.19.2003','Sugih Waras'),
('16.08.19.2004','Rejo Sari'),
('16.08.19.2005','Petanggan'),
('16.08.19.2006','Purwodadi'),
('16.08.19.2007','Sri Mulyo'),
('16.08.19.2008','Ulak Buntar'),
('16.08.19.2009','Sribudaya'),
('16.08.19.2010','Sukoharjo'),
('16.08.19.2011','Tulung Sari'),
('16.08.19.2012','Mulya Sari'),
('16.08.20','Buay Pemuka Bangsa Raja'),
('16.08.20.2001','Sri Bunga'),
('16.08.20.2002','Anyar'),
('16.08.20.2003','Pandan Sari II'),
('16.08.20.2004','Rawasari'),
('16.08.20.2005','Surya Menang'),
('16.08.20.2006','Muncak Kabau'),
('16.08.20.2007','Sri Bulan'),
('16.09','Kabupaten Ogan Komering Ulu Selatan'),
('16.09.01','Muara Dua'),
('16.09.01.1013','Batu Belang Jaya'),
('16.09.01.1014','Bumi Agung'),
('16.09.01.1015','Pancur Pungah'),
('16.09.01.1016','Kisau'),
('16.09.01.1019','Pasar Muaradua'),
('16.09.01.2002','Gedung Lepihan'),
('16.09.01.2003','Gunung Tiga'),
('16.09.01.2004','Suka Banjar'),
('16.09.01.2005','Sukaraja II'),
('16.09.01.2017','Pendagan'),
('16.09.01.2018','Mehanggin'),
('16.09.01.2024','Pelangki'),
('16.09.01.2025','Batu Belang 2'),
('16.09.01.2026','Datar'),
('16.09.02','Pulau Beringin'),
('16.09.02.2012','Tanjung Bulan'),
('16.09.02.2013','Pulau Beringin'),
('16.09.02.2014','Aromantai'),
('16.09.02.2015','Tanjung Kari'),
('16.09.02.2016','Simpang Pancur'),
('16.09.02.2017','Pagar Agung'),
('16.09.02.2018','Gunung Batu'),
('16.09.02.2019','Kemu'),
('16.09.02.2020','Anugerah Kemu'),
('16.09.02.2021','Kemu Ulu'),
('16.09.02.2022','Pematang Obar'),
('16.09.02.2023','Tanjung Bulan Ulu'),
('16.09.02.2024','Pulau Beringin Utara'),
('16.09.03','Banding Agung'),
('16.09.03.1023','Bandar Agung Ranau'),
('16.09.03.2020','Way Timah'),
('16.09.03.2021','Sipatuhu'),
('16.09.03.2022','Banding Agung'),
('16.09.03.2024','Surabaya'),
('16.09.03.2025','Sugih Waras'),
('16.09.03.2026','Suka Negeri'),
('16.09.03.2027','Rantau Nipis'),
('16.09.03.2028','Air Rupik'),
('16.09.03.2031','Talang Merbau'),
('16.09.03.2032','Tanjung Agung'),
('16.09.03.2033','Tanjung Harapan'),
('16.09.03.2034','Telanai'),
('16.09.03.2035','Sumber Makmur'),
('16.09.03.2036','Karang Indah'),
('16.09.03.2037','Tangsi Agung'),
('16.09.03.2038','Penantian'),
('16.09.03.2039','Suka Maju'),
('16.09.03.2040','Sidodadi'),
('16.09.03.2041','Sipatuhu II'),
('16.09.03.2042','Terap Mulia'),
('16.09.03.2043','Surabaya Timur'),
('16.09.04','Muara Dua Kisam'),
('16.09.04.2001','Lawang Agung'),
('16.09.04.2002','Bayur Tengah'),
('16.09.04.2003','Tanjung Tebat'),
('16.09.04.2004','Sugihan'),
('16.09.04.2005','Penyandingan'),
('16.09.04.2006','Alun Dua'),
('16.09.04.2007','Bandar Alam Baru'),
('16.09.04.2008','Dusun Tengah'),
('16.09.04.2009','Ulak Agung Ilir'),
('16.09.04.2011','Gunung Gare'),
('16.09.04.2018','Ulak Agung Ulu'),
('16.09.04.2019','Muaradua Kisam'),
('16.09.04.2020','Sukananti'),
('16.09.04.2021','Pagar Dewa'),
('16.09.04.2022','Tanjung Beringin'),
('16.09.04.2028','Panantian'),
('16.09.04.2029','Sukaraja'),
('16.09.04.2040','Simpang Lubuk Dalam'),
('16.09.05','Simpang'),
('16.09.05.2001','Karang Agung'),
('16.09.05.2007','Lubar'),
('16.09.05.2008','Tanjung Sari'),
('16.09.05.2009','Simpangan'),
('16.09.05.2010','Bungin Campang'),
('16.09.05.2029','Simpang Agung'),
('16.09.05.2030','Sinar Mulyo'),
('16.09.06','Buay Sandang Aji'),
('16.09.06.2007','Sukarami'),
('16.09.06.2008','Tanjung Raya'),
('16.09.06.2010','Tanjung Menang Ilir'),
('16.09.06.2011','Tanjung Menang Ulu'),
('16.09.06.2012','Kenali'),
('16.09.06.2013','Negeri Cahya'),
('16.09.06.2014','Sukaraja I'),
('16.09.06.2015','Tanjung Iman'),
('16.09.06.2016','Bunga Mas'),
('16.09.06.2017','Lubuk Liku'),
('16.09.06.2018','Kota Karang'),
('16.09.06.2019','Negeri Batin'),
('16.09.06.2020','Madura'),
('16.09.06.2021','Negeri Agung'),
('16.09.06.2022','Gunung Terang'),
('16.09.06.2023','Talang Baru'),
('16.09.07','Buay Runjung'),
('16.09.07.2001','Sugih Rawas'),
('16.09.07.2002','Padang Sari'),
('16.09.07.2003','Padang Bindu'),
('16.09.07.2005','Saung Naga'),
('16.09.07.2006','Negeri Batin Baru'),
('16.09.07.2007','Kota Aman'),
('16.09.07.2008','Belambangan'),
('16.09.07.2009','Paninjauan'),
('16.09.07.2018','Nagar Agung'),
('16.09.07.2019','Simpang Saga'),
('16.09.07.2020','Perupus Blambangan'),
('16.09.07.2021','Kagelang Blambangan'),
('16.09.07.2022','Sukajadi Blambangan'),
('16.09.07.2023','Bedeng Blambangan'),
('16.09.08','Mekakau Ilir'),
('16.09.08.2001','Kota Dalam'),
('16.09.08.2002','Teluk Agung'),
('16.09.08.2003','Pulau Duku'),
('16.09.08.2004','Tanjung Besar'),
('16.09.08.2005','Sinar Marga'),
('16.09.08.2006','Kota Baru'),
('16.09.08.2007','Galang Tinggi'),
('16.09.08.2008','Sukaraja'),
('16.09.08.2009','Sri Menanti'),
('16.09.08.2010','Kepayang'),
('16.09.08.2011','Kemang Bandung'),
('16.09.08.2012','Selabung Belimbing Jaya'),
('16.09.08.2013','Bunut'),
('16.09.08.2014','Air Baru'),
('16.09.08.2015','Pere''an'),
('16.09.09','Buay Pemaca'),
('16.09.09.2001','Tanjung Durian'),
('16.09.09.2002','Sipin'),
('16.09.09.2003','Kota Way'),
('16.09.09.2004','Talang Padang'),
('16.09.09.2005','Sri Menanti'),
('16.09.09.2006','Serakat Jaya'),
('16.09.09.2007','Karet Jaya'),
('16.09.09.2008','Danau Jaya'),
('16.09.09.2009','Sumber Ringin'),
('16.09.09.2010','Kembang Tinggi'),
('16.09.09.2011','Sido Rahayu'),
('16.09.09.2012','Sidodadi'),
('16.09.09.2013','Durian Sembilan'),
('16.09.09.2014','Sumber Raya'),
('16.09.09.2015','Sinar Napalan'),
('16.09.09.2016','Tanjung Jaya'),
('16.09.09.2017','Sinar Baru'),
('16.09.09.2018','Mekar Jaya'),
('16.09.09.2019','Tanjung Sari'),
('16.09.09.2020','Tanjung Baru'),
('16.09.09.2021','Air Kelian'),
('16.09.09.2022','Tanjung Menang'),
('16.09.10','Kisam Tinggi'),
('16.09.10.2001','Balayan'),
('16.09.10.2002','Berasang'),
('16.09.10.2003','Tebat Gabus'),
('16.09.10.2004','Padang Lay'),
('16.09.10.2005','Danau Rata'),
('16.09.10.2006','Pajar Bulan'),
('16.09.10.2007','Bandar Alam Lama'),
('16.09.10.2008','Muara Payang'),
('16.09.10.2009','Siring Agung'),
('16.09.10.2010','Kota Padang'),
('16.09.10.2011','Padang Bindu'),
('16.09.10.2012','Tenang'),
('16.09.10.2013','Gunung Megang'),
('16.09.10.2014','Ulak Pandan'),
('16.09.10.2015','Pulau Panggung'),
('16.09.10.2016','Simpang Tiga'),
('16.09.10.2017','Simpang Empat'),
('16.09.10.2018','Singa Laga'),
('16.09.10.2019','Air Alun'),
('16.09.11','Kisam Ilir'),
('16.09.11.2001','Pius'),
('16.09.11.2002','Pengandonan'),
('16.09.11.2003','Siring Alam'),
('16.09.11.2004','Simpang Campang'),
('16.09.11.2005','Pulau Kemiling'),
('16.09.11.2006','Keban Agung'),
('16.09.11.2007','Muara Sindang'),
('16.09.11.2008','Campang Jaya'),
('16.09.11.2009','Tanjung Jati'),
('16.09.12','Buay Pematang Ribu Ranau Tengah'),
('16.09.12.1013','Simpang Sender'),
('16.09.12.2001','Tanjung Kemala'),
('16.09.12.2002','Sukamarga'),
('16.09.12.2003','Subik'),
('16.09.12.2004','Jepara'),
('16.09.12.2005','Hangkusa'),
('16.09.12.2006','Sukarami'),
('16.09.12.2007','Padang Ratu'),
('16.09.12.2008','Tanjung Setia'),
('16.09.12.2009','Gedung Baru'),
('16.09.12.2010','Tanjung Sari'),
('16.09.12.2011','Suka Bumi'),
('16.09.12.2012','Sumber Mulia'),
('16.09.12.2014','Way Relai'),
('16.09.12.2015','Tanjung Baru Ranau'),
('16.09.12.2016','Simpang Sender Selatan'),
('16.09.12.2017','Simpang Sender Utara'),
('16.09.12.2018','Simpang Sender Timur'),
('16.09.12.2019','Simpang Sender Tengah'),
('16.09.12.2020','Sumber Jaya'),
('16.09.12.2021','Pakhda Suka'),
('16.09.12.2022','Serumpun Jaya'),
('16.09.13','Warkuk Ranau Selatan'),
('16.09.13.2001','Sukajaya'),
('16.09.13.2002','Kota Batu'),
('16.09.13.2003','Pagar Dewa'),
('16.09.13.2004','Tanjung Jati'),
('16.09.13.2005','Gunung Aji'),
('16.09.13.2006','Pilla'),
('16.09.13.2007','Gunung Raya'),
('16.09.13.2008','Remanam Jaya'),
('16.09.13.2009','Kiwis Raya'),
('16.09.13.2010','Segigok Raya'),
('16.09.13.2011','Bumi Agung'),
('16.09.13.2012','Mekar Sari'),
('16.09.13.2013','Bedeng Tiga'),
('16.09.13.2014','Gedung Ranau'),
('16.09.13.2015','Tanjung Baru'),
('16.09.13.2016','Way Wangi Seminung'),
('16.09.14','Runjung Agung'),
('16.09.14.2001','Merpang'),
('16.09.14.2002','Tanjung Kurung'),
('16.09.14.2003','Air Baru'),
('16.09.14.2004','Penanggungan'),
('16.09.14.2005','Bumi Genap'),
('16.09.14.2006','Gedung Nyawa'),
('16.09.14.2007','Gedung Wani'),
('16.09.14.2008','Sura'),
('16.09.14.2009','Karang Endah'),
('16.09.15','Sungai Are'),
('16.09.15.2001','Pulau Kemuning'),
('16.09.15.2002','Guntung Jaya'),
('16.09.15.2003','Tanah Pilih'),
('16.09.15.2004','Ujan Mas'),
('16.09.15.2005','Pecah Pinggan'),
('16.09.15.2006','Cukoh Nau'),
('16.09.15.2007','Simpang Luas'),
('16.09.15.2008','Sedau Jaya'),
('16.09.15.2009','Sebaja'),
('16.09.16','Sindang Danau'),
('16.09.16.2001','Tanjung Harapan'),
('16.09.16.2002','Muara Sindang Ilir'),
('16.09.16.2003','Muara Sindang Tengah'),
('16.09.16.2004','Pematang Danau'),
('16.09.16.2005','Ulu Danau'),
('16.09.16.2006','Tebat Layang'),
('16.09.16.2007','Watas'),
('16.09.17','Buana Pemaca'),
('16.09.17.2001','Tekana'),
('16.09.17.2002','Tanjung Beringin'),
('16.09.17.2003','Bandar'),
('16.09.17.2004','Jagaraga'),
('16.09.17.2005','Damarpura'),
('16.09.17.2006','Tunas Jaya'),
('16.09.17.2007','Sinar Danau'),
('16.09.17.2008','Gemiung'),
('16.09.18','Tiga Dihaji'),
('16.09.18.2001','Peninggiran'),
('16.09.18.2002','Kuripan'),
('16.09.18.2003','Surabaya'),
('16.09.18.2004','Sukarena'),
('16.09.18.2005','Karang Pendeta'),
('16.09.18.2006','Kota Agung'),
('16.09.18.2007','Sukabumi'),
('16.09.18.2008','Kuripan II'),
('16.09.19','Buay Rawan'),
('16.09.19.2001','Rantau Panjang'),
('16.09.19.2002','Sukajaya'),
('16.09.19.2003','Banjar Agung'),
('16.09.19.2004','Ruos'),
('16.09.19.2005','Gunung Cahya'),
('16.09.19.2006','Bumi Jaya'),
('16.09.19.2007','Bendi'),
('16.09.19.2008','Pekuolan'),
('16.09.19.2009','Pelawi'),
('16.09.19.2011','Majar'),
('16.09.19.2012','Bumi Agung Jaya'),
('16.10','Kabupaten Ogan Ilir'),
('16.10.01','Muara Kuang'),
('16.10.01.1011','Muara Kuang'),
('16.10.01.2005','Munggu'),
('16.10.01.2006','Seri Menanti'),
('16.10.01.2007','Rantau Sialang'),
('16.10.01.2008','Kuang Anyar'),
('16.10.01.2009','Kasah'),
('16.10.01.2012','Tanabang Ulu'),
('16.10.01.2013','Seri Kembang'),
('16.10.01.2014','Nagasari'),
('16.10.01.2015','Suka Cinta'),
('16.10.01.2016','Kelampadu'),
('16.10.01.2029','Sukajadi'),
('16.10.01.2030','Ramakasih'),
('16.10.01.2031','Tanabang Ilir'),
('16.10.02','Tanjung Batu'),
('16.10.02.1017','Tanjung Batu'),
('16.10.02.1037','Tanjung Batu Timur'),
('16.10.02.2010','Seri Bandung'),
('16.10.02.2011','Seri Tanjung'),
('16.10.02.2012','Tanjung Tambak'),
('16.10.02.2013','Senuro Timur'),
('16.10.02.2014','Tanjung Baru Petai'),
('16.10.02.2015','Tanjung Batu Seberang'),
('16.10.02.2016','Pajar Bulan'),
('16.10.02.2018','Tanjung Atap'),
('16.10.02.2019','Tanjung Pinang I'),
('16.10.02.2020','Limbang Jaya I'),
('16.10.02.2021','Tanjung Laut'),
('16.10.02.2026','Burai'),
('16.10.02.2027','Sentul'),
('16.10.02.2031','Bangun Jaya'),
('16.10.02.2032','Tanjung Tambak Baru'),
('16.10.02.2033','Limbang Jaya II'),
('16.10.02.2034','Senuro Barat'),
('16.10.02.2035','Tanjung Pinang II'),
('16.10.02.2036','Tanjung Atap Barat'),
('16.10.03','Tanjung Raja'),
('16.10.03.1001','Tanjung Raja'),
('16.10.03.1027','Tanjung Raja Barat'),
('16.10.03.1028','Tanjung Raja Utara'),
('16.10.03.1035','Tanjung Raja Timur'),
('16.10.03.2002','Suka Pindah'),
('16.10.03.2007','Tanjung Temiang'),
('16.10.03.2008','Seri Dalam'),
('16.10.03.2018','Kerinjing'),
('16.10.03.2019','Ulak Kerbau Baru'),
('16.10.03.2020','Ulak Kerbau Lama'),
('16.10.03.2021','Tanjung Agas'),
('16.10.03.2022','Siring Alam'),
('16.10.03.2023','Talang Balai Baru I'),
('16.10.03.2024','Talang Balai Lama'),
('16.10.03.2030','Skonjing'),
('16.10.03.2031','Tanjung Raja Selatan'),
('16.10.03.2032','Belanti'),
('16.10.03.2033','Tanjung Harapan'),
('16.10.03.2034','Talang Balai Baru II'),
('16.10.04','Indralaya'),
('16.10.04.1030','Indralaya Raya'),
('16.10.04.1031','Indralaya Indah'),
('16.10.04.1032','Indralaya Mulia'),
('16.10.04.2005','Lubuk Sakti'),
('16.10.04.2006','Tanjung Gelam'),
('16.10.04.2007','Tanjung Agung'),
('16.10.04.2008','Tanjung Sejaro'),
('16.10.04.2009','Sakatiga Seberang'),
('16.10.04.2010','Muara P. Ulu'),
('16.10.04.2012','Tanjung Seteko'),
('16.10.04.2013','Saka Tiga'),
('16.10.04.2014','Ulak Banding'),
('16.10.04.2015','Muara P. Ilir'),
('16.10.04.2016','Talang Aur'),
('16.10.04.2017','Ulak Bedil'),
('16.10.04.2018','Penyandingan'),
('16.10.04.2019','Sudimampir'),
('16.10.04.2027','Ulak Segelung'),
('16.10.04.2028','Sejaro Sakti'),
('16.10.04.2029','Tunas Aur'),
('16.10.05','Pemulutan'),
('16.10.05.2015','Aurstanding'),
('16.10.05.2016','Sukarami'),
('16.10.05.2017','Muara Dua'),
('16.10.05.2018','Palu'),
('16.10.05.2019','Teluk Kecapi'),
('16.10.05.2020','Pelabuhan Dalam'),
('16.10.05.2021','Pemulutan Ulu'),
('16.10.05.2022','Pemulutan Ilir'),
('16.10.05.2023','Sungai Rasau'),
('16.10.05.2024','Ibul Besar I'),
('16.10.05.2025','Pegayut'),
('16.10.05.2029','S. Pelabuhan Dlm'),
('16.10.05.2030','Ibul Besar II'),
('16.10.05.2031','Ibul Besar III'),
('16.10.05.2032','Mekar Jaya'),
('16.10.05.2033','Kedukan Bujang'),
('16.10.05.2034','Rawa Jaya'),
('16.10.05.2035','Babatan Saudagar'),
('16.10.05.2036','Tanjung Pasir'),
('16.10.05.2037','Harapan'),
('16.10.05.2038','Pipa Putih'),
('16.10.05.2039','Sungai Buaya'),
('16.10.05.2040','Muara Baru'),
('16.10.05.2041','Sembadak'),
('16.10.05.2042','Lebung Jangkar'),
('16.10.06','Rantau Alai'),
('16.10.06.2006','Sirah Pulau Kilip'),
('16.10.06.2011','Kelampaian'),
('16.10.06.2012','Sukananti'),
('16.10.06.2013','Sukamarga'),
('16.10.06.2014','Rantau Alai'),
('16.10.06.2015','Kerta Bayang'),
('16.10.06.2016','Tanjung Mas'),
('16.10.06.2017','Talang Sari'),
('16.10.06.2018','Lebung Bandung'),
('16.10.06.2020','Sanding Marga'),
('16.10.06.2021','Sukamaju'),
('16.10.06.2022','Mekar Sari'),
('16.10.06.2023','Sukananti Baru'),
('16.10.07','Indralaya Utara'),
('16.10.07.1016','Timbangan'),
('16.10.07.2001','Tanjung Pering'),
('16.10.07.2002','Bakung'),
('16.10.07.2003','Lorok'),
('16.10.07.2004','Parit'),
('16.10.07.2005','Payakabung'),
('16.10.07.2006','Sungai Rambutan'),
('16.10.07.2007','Purna Jaya'),
('16.10.07.2008','Soak Batok'),
('16.10.07.2009','Tanjung Baru'),
('16.10.07.2010','Tanjung Pule'),
('16.10.07.2011','Permata Baru'),
('16.10.07.2012','Suka Mulia'),
('16.10.07.2013','Pulau Kabai'),
('16.10.07.2014','Pulau Semambu'),
('16.10.07.2015','Palem Raya'),
('16.10.08','Indralaya Selatan'),
('16.10.08.2001','Mandi Angin'),
('16.10.08.2002','Tanjung Lubuk'),
('16.10.08.2003','Tebing Gerinting Selatan'),
('16.10.08.2004','Arisan Gading'),
('16.10.08.2005','Tanjung Dayang Selatan'),
('16.10.08.2006','Beti'),
('16.10.08.2007','Meranjat I'),
('16.10.08.2008','Meranjat Ilir'),
('16.10.08.2009','Meranjat II'),
('16.10.08.2010','Sukaraja Lama'),
('16.10.08.2011','Sukaraja Baru'),
('16.10.08.2012','Tebing Gerinting Utara'),
('16.10.08.2013','Tanjung Dayang Utara'),
('16.10.08.2014','Meranjat III'),
('16.10.09','Pemulutan Selatan'),
('16.10.09.2001','Pematang Bangsal'),
('16.10.09.2002','Maya Pati'),
('16.10.09.2003','Sungai Lebung'),
('16.10.09.2005','Kapuk'),
('16.10.09.2006','Ulak Aurstanding'),
('16.10.09.2007','Maju Jaya'),
('16.10.09.2008','Naikan Tembakang'),
('16.10.09.2009','Segayam'),
('16.10.09.2010','Cahaya Marga'),
('16.10.09.2011','S. Lebung Ulu'),
('16.10.09.2012','Sungai Keli'),
('16.10.09.2013','Lebak Pering'),
('16.10.09.2014','Sungai Ondok'),
('16.10.09.2015','Harimau Tandang'),
('16.10.09.2016','Pematang Bungur'),
('16.10.10','Pemulutan Barat'),
('16.10.10.2001','Suka Merindu'),
('16.10.10.2002','Sarang Lang'),
('16.10.10.2003','Kamal'),
('16.10.10.2004','Pulau Negara'),
('16.10.10.2005','Talang Pangeran Ulu'),
('16.10.10.2006','Ulak Kembahang I'),
('16.10.10.2007','Ulak Petangisan'),
('16.10.10.2008','Sribanding'),
('16.10.10.2009','Ulak Kembahang II'),
('16.10.10.2010','Talang Pangeran Ilir'),
('16.10.10.2011','Arisan Jaya'),
('16.10.11','Rantau Panjang'),
('16.10.11.2001','Kotadaro I'),
('16.10.11.2002','Ketapang I'),
('16.10.11.2003','Rantau Panjang Ilir'),
('16.10.11.2004','Jagaraja'),
('16.10.11.2005','Jagalano'),
('16.10.11.2006','Sejangko I'),
('16.10.11.2007','Kota Daro II'),
('16.10.11.2008','Sungai Rotan'),
('16.10.11.2009','Rantau Panjang Ulu'),
('16.10.11.2010','Ketapang II'),
('16.10.11.2011','Sejangko II'),
('16.10.11.2012','Arisan Deras'),
('16.10.12','Sungai Pinang'),
('16.10.12.1007','Sungai Pinang'),
('16.10.12.2001','Serijabo'),
('16.10.12.2002','Sungai Pinang II'),
('16.10.12.2003','Talang Dukun'),
('16.10.12.2004','Tanjung Serian'),
('16.10.12.2005','Penyandingan'),
('16.10.12.2006','Sungai Pinang III'),
('16.10.12.2008','Pinang Jaya'),
('16.10.12.2009','Sungai Pinang I'),
('16.10.12.2010','Pinang Mas'),
('16.10.12.2011','S. Pinang Lagati'),
('16.10.12.2012','S. Pinang Nibung'),
('16.10.12.2013','Seri Jabo Baru'),
('16.10.13','Kandis'),
('16.10.13.2001','Lubuk Rukam'),
('16.10.13.2002','Tanjung Alai'),
('16.10.13.2003','Kandis I'),
('16.10.13.2004','Kumbang Ulu'),
('16.10.13.2005','Kumbang Ilir'),
('16.10.13.2006','Miji'),
('16.10.13.2007','Santapan Barat'),
('16.10.13.2008','Pandan Arang'),
('16.10.13.2009','Muara Kumbang'),
('16.10.13.2010','Kandis II'),
('16.10.13.2011','Santapan Timur'),
('16.10.13.2012','Lubuk Segonang'),
('16.10.14','Rambang Kuang'),
('16.10.14.2001','Ibul Dalam'),
('16.10.14.2002','Beringin Dalam'),
('16.10.14.2003','Kuang Dalam Barat'),
('16.10.14.2004','Lubuk Tunggal'),
('16.10.14.2005','Ulak Segara'),
('16.10.14.2006','Tanjung Bulan'),
('16.10.14.2007','Tambang Rambang'),
('16.10.14.2008','Sukananti'),
('16.10.14.2009','Kayu Ara'),
('16.10.14.2010','Tanjung Miring'),
('16.10.14.2011','Sunur'),
('16.10.14.2012','Kuang Dalam Timur'),
('16.10.14.2013','Tangai'),
('16.10.15','Lubuk Keliat'),
('16.10.15.2001','Ulak Kembahang'),
('16.10.15.2002','Lubuk Keliat'),
('16.10.15.2003','Embacang'),
('16.10.15.2004','Kasih Raja'),
('16.10.15.2005','Talang Tengah Darat'),
('16.10.15.2006','Betung II'),
('16.10.15.2007','Ketiau'),
('16.10.15.2008','Payalingkung'),
('16.10.15.2009','Betung I'),
('16.10.15.2010','Talang Tengah Laut'),
('16.10.16','Payaraman'),
('16.10.16.1012','Payaraman Barat'),
('16.10.16.1013','Payaraman Timur'),
('16.10.16.2001','Tebedak I'),
('16.10.16.2002','Lubuk Bandung'),
('16.10.16.2003','Talang Seleman'),
('16.10.16.2004','Tebedak II'),
('16.10.16.2005','Tanjung lalang'),
('16.10.16.2006','Seri Kembang I'),
('16.10.16.2007','Rengas I'),
('16.10.16.2008','Paya Besar'),
('16.10.16.2009','Rengas II'),
('16.10.16.2010','Seri Kembang II'),
('16.10.16.2011','Seri Kembang III'),
('16.11','Kabupaten Empat Lawang'),
('16.11.01','Muara Pinang'),
('16.11.01.2001','Batu Jungul'),
('16.11.01.2002','Suka Dana'),
('16.11.01.2003','Padang Burnai'),
('16.11.01.2004','Belimbing'),
('16.11.01.2005','Tanjung Kurung'),
('16.11.01.2006','Muara Pinang Baru'),
('16.11.01.2007','Lubuk Tanjung'),
('16.11.01.2008','Talang Baru'),
('16.11.01.2009','Sapa Panjang'),
('16.11.01.2010','Muara Pinang Lama'),
('16.11.01.2011','Tanjung Tawang'),
('16.11.01.2012','Gedung Agung'),
('16.11.01.2013','Pajar Menang'),
('16.11.01.2014','Niur'),
('16.11.01.2015','Muara Semah'),
('16.11.01.2016','Talang Benteng'),
('16.11.01.2017','Lubuk Ulak'),
('16.11.01.2018','Batu Galang'),
('16.11.01.2019','Muara Timbuk'),
('16.11.01.2020','Seleman Ilir'),
('16.11.01.2021','Seleman Ulu'),
('16.11.01.2022','Sawah'),
('16.11.02','Pendopo'),
('16.11.02.1018','Beruge Ilir'),
('16.11.02.1030','Pendopo'),
('16.11.02.1031','Pagar Tengah'),
('16.11.02.2001','Jarakan'),
('16.11.02.2002','Bandar Agung'),
('16.11.02.2003','Lubuk Sepang'),
('16.11.02.2004','Lubuk Layang'),
('16.11.02.2005','Nanjungan'),
('16.11.02.2006','Tanjung Eran'),
('16.11.02.2007','Tanjung Raman'),
('16.11.02.2020','Bayau'),
('16.11.02.2022','Gn. Meraksa Baru'),
('16.11.02.2023','Landur'),
('16.11.02.2024','Muara Karang'),
('16.11.02.2025','Sarang Bulan'),
('16.11.02.2026','Tanjung Baru'),
('16.11.02.2027','Batu Cawang'),
('16.11.02.2028','Manggilan'),
('16.11.02.2029','Gn Merakasa Lama'),
('16.11.03','Ulu Musi'),
('16.11.03.2001','Air Kelinsar'),
('16.11.03.2002','Talang Bengkulu'),
('16.11.03.2003','Kunduran'),
('16.11.03.2004','Simpang Perigi'),
('16.11.03.2005','Muara Kalangan'),
('16.11.03.2006','Batu Lintang'),
('16.11.03.2007','Padang Tepong'),
('16.11.03.2008','Muara Betung'),
('16.11.03.2009','Lb. Puding Baru'),
('16.11.03.2010','Pulau Kemang'),
('16.11.03.2011','Lb. Puding Lama'),
('16.11.03.2012','Batu Bidung'),
('16.11.03.2024','Tanjung Agung'),
('16.11.03.2025','Galang'),
('16.11.04','Tebing Tinggi'),
('16.11.04.1010','Kupang'),
('16.11.04.1013','Tanjungkupang'),
('16.11.04.1014','Tanjung Makmur'),
('16.11.04.1017','Ps. Tebing Tinggi'),
('16.11.04.1033','Jaya Loka'),
('16.11.04.1036','Kelumpang Jaya'),
('16.11.04.2001','Ujung Alih'),
('16.11.04.2002','Lb. Gelanggang'),
('16.11.04.2003','Ulak Mengkudu'),
('16.11.04.2004','Batu Pance'),
('16.11.04.2005','Aur Gading'),
('16.11.04.2006','Terusan Lama'),
('16.11.04.2007','Terusan Baru'),
('16.11.04.2008','Rantau Tenang'),
('16.11.04.2009','Seguring Kecil'),
('16.11.04.2011','Kemang Manis'),
('16.11.04.2012','Lampar Baru'),
('16.11.04.2021','Kota Gading'),
('16.11.04.2022','Batu Raja Baru'),
('16.11.04.2023','Batu Raja Lama'),
('16.11.04.2024','Sugi Waras'),
('16.11.04.2027','Mekar Jaya'),
('16.11.04.2030','Fajar Bakti'),
('16.11.04.2032','Pancur Mas'),
('16.11.04.2034','Makarti Jaya'),
('16.11.04.2035','Tanjung Kupang Baru'),
('16.11.05','Lintang Kanan'),
('16.11.05.2001','Umo Jati'),
('16.11.05.2002','Tanjung Jati'),
('16.11.05.2003','Pagar Jati'),
('16.11.05.2004','Nibung'),
('16.11.05.2005','Batu Ampar'),
('16.11.05.2006','Karang Tanding'),
('16.11.05.2007','Lubuk Cik'),
('16.11.05.2008','Rantau Kasai'),
('16.11.05.2009','Suka Rami'),
('16.11.05.2010','Rantau Alih'),
('16.11.05.2011','Tanjung Alam'),
('16.11.05.2012','Lesung Batu'),
('16.11.05.2013','Babatan'),
('16.11.05.2014','Muara Danau'),
('16.11.05.2015','Endalo'),
('16.11.05.2016','Lubuk Tapang'),
('16.11.06','Talang Padang'),
('16.11.06.2001','Karang Are'),
('16.11.06.2002','Padang Titiran'),
('16.11.06.2003','Kembahang Lama'),
('16.11.06.2004','Pasar Tl. Padang'),
('16.11.06.2005','Macang Manis'),
('16.11.06.2006','Lubuk Buntak'),
('16.11.06.2007','Talang Durian'),
('16.11.06.2008','Talang Padang'),
('16.11.06.2009','Kembahang Baru'),
('16.11.06.2010','Canggu'),
('16.11.06.2011','Remantai'),
('16.11.06.2012','Ulak Dabuk'),
('16.11.06.2013','Lampar Baru'),
('16.11.07','Pasemah Air Keruh'),
('16.11.07.2001','Talang Padang'),
('16.11.07.2002','Tanjung Beringin'),
('16.11.07.2003','Penantian'),
('16.11.07.2004','Pagar Jati'),
('16.11.07.2005','Kebon Jati'),
('16.11.07.2006','Bandar Agung'),
('16.11.07.2007','Lawang Agung'),
('16.11.07.2008','Nanjungan'),
('16.11.07.2009','Talang Randai'),
('16.11.07.2010','Air Mayam'),
('16.11.07.2011','Muara Rungga'),
('16.11.07.2012','Padang Gelai'),
('16.11.07.2013','Padang Bindu'),
('16.11.07.2014','Muara Sindang'),
('16.11.07.2015','Muara Aman'),
('16.11.08','Sikap Dalam'),
('16.11.08.2001','Puntang'),
('16.11.08.2002','Bandar Aji'),
('16.11.08.2003','Paduraksa'),
('16.11.08.2004','Karang Gede'),
('16.11.08.2005','Karang Dapo Baru'),
('16.11.08.2006','Karang Dapo Lama'),
('16.11.08.2007','Tangga Rasa'),
('16.11.08.2008','Tapa Baru'),
('16.11.08.2009','Tapa Lama'),
('16.11.08.2010','Martapura'),
('16.11.08.2011','Karang Anyar'),
('16.11.09','Saling'),
('16.11.09.2001','Lubuk Kelumpang'),
('16.11.09.2002','Tanjungning Simpang'),
('16.11.09.2003','Tanjungning Tengah'),
('16.11.09.2004','Tanjungning Lama'),
('16.11.09.2005','Tanjungning Jaya'),
('16.11.09.2006','Sawah'),
('16.11.09.2007','Kebon'),
('16.11.09.2008','Suka Kaya'),
('16.11.09.2009','Taba'),
('16.11.09.2010','Muara Saling'),
('16.11.10','Pendopo Barat'),
('16.11.10.2001','Muaralintang Lama'),
('16.11.10.2002','Muaralintang Baru'),
('16.11.10.2003','Tebat Payang'),
('16.11.10.2004','Karang Caya'),
('16.11.10.2005','Tanjungraya'),
('16.11.10.2006','Padang Bindu'),
('16.11.10.2007','Air Kandis'),
('16.11.10.2008','Lingge'),
('16.11.10.2009','Rantau Dodor'),
('16.11.10.2010','Kungkilan'),
('16.12','Kabupaten Penukal Abab Lematang Ilir'),
('16.12.01','Talang Ubi'),
('16.12.01.1003','Talang Ubi Timur'),
('16.12.01.1010','Talang Ubi Barat'),
('16.12.01.1011','Talang Ubi Utara'),
('16.12.01.1012','Talang Ubi Selatan'),
('16.12.01.1017','Pasar Bhayangkara'),
('16.12.01.1018','Handayani Mulya'),
('16.12.01.2001','Talang Bulang'),
('16.12.01.2002','Benuang'),
('16.12.01.2004','Talang Akar'),
('16.12.01.2005','Sungai Ibul'),
('16.12.01.2006','Karta Dewa'),
('16.12.01.2007','Panta Dewa'),
('16.12.01.2008','Sungai Baung'),
('16.12.01.2009','Semangus'),
('16.12.01.2013','Sinar Dewa'),
('16.12.01.2014','Benakat Minyak'),
('16.12.01.2015','Suka Maju'),
('16.12.01.2016','Suka Damai'),
('16.12.01.2019','Beruge Darat'),
('16.12.01.2020','Simpang Tais'),
('16.12.02','Penukal Utara'),
('16.12.02.2001','Sukarami'),
('16.12.02.2002','Tanjung Baru'),
('16.12.02.2003','Prabu Menang'),
('16.12.02.2004','Tanding Marga'),
('16.12.02.2005','Karang Tanding'),
('16.12.02.2006','Lubuk Tampui'),
('16.12.02.2007','Tempirai'),
('16.12.02.2008','Tempirai Selatan'),
('16.12.02.2009','Kota Baru'),
('16.12.02.2010','Tempirai Utara'),
('16.12.02.2011','Tempirai Timur'),
('16.12.02.2012','Tambak'),
('16.12.02.2013','Muara Ikan'),
('16.12.03','Penukal'),
('16.12.03.2001','Purun'),
('16.12.03.2002','Gunung Menang'),
('16.12.03.2003','Mangkunegara'),
('16.12.03.2004','Raja Jaya'),
('16.12.03.2005','Air Itam'),
('16.12.03.2006','Gunung Raja'),
('16.12.03.2007','Air Itam Timur'),
('16.12.03.2008','Sungai Langan'),
('16.12.03.2009','Spantan Jaya'),
('16.12.03.2010','Babat'),
('16.12.03.2011','Suka Raja'),
('16.12.03.2012','Purun Timur'),
('16.12.03.2013','Mangkunegara Timur'),
('16.12.04','Abab'),
('16.12.04.2001','Betung'),
('16.12.04.2002','Betung Barat'),
('16.12.04.2003','Karang Agung'),
('16.12.04.2004','Tanjung Kurung'),
('16.12.04.2005','Pengabuan'),
('16.12.04.2006','Prambatan'),
('16.12.04.2007','Pengabuan Timur'),
('16.12.04.2008','Betung Selatan'),
('16.12.05','Tanah Abang'),
('16.12.05.2001','Bumi Ayu'),
('16.12.05.2002','Muara Sungai'),
('16.12.05.2003','Tanah Abang Utara'),
('16.12.05.2004','Sedupi'),
('16.12.05.2005','Sukaraja'),
('16.12.05.2006','Curup'),
('16.12.05.2007','Raja'),
('16.12.05.2008','Pandan'),
('16.12.05.2009','Modong'),
('16.12.05.2010','Tanah Abang Selatan'),
('16.12.05.2011','Harapan Jaya'),
('16.12.05.2012','Tanjung Dalam'),
('16.12.05.2013','Lunas Jaya'),
('16.12.05.2014','Raja Barat'),
('16.12.05.2015','Tanah Abang Jaya'),
('16.12.05.2016','Muara Dua'),
('16.12.05.2017','Sukamanis'),
('16.13','Kabupaten Musi Rawas Utara'),
('16.13.01','Rupit'),
('16.13.01.1007','Muara Rupit'),
('16.13.01.2001','Tanjung Beringin'),
('16.13.01.2002','Noman'),
('16.13.01.2003','Batu Gajah'),
('16.13.01.2004','Maur Lama'),
('16.13.01.2005','Maur Baru'),
('16.13.01.2006','Bingin Rupit'),
('16.13.01.2008','Lubuk Rumbai'),
('16.13.01.2009','Pantai'),
('16.13.01.2010','Lawang Agung'),
('16.13.01.2011','Karang Waru'),
('16.13.01.2012','Karang Anyar'),
('16.13.01.2013','Sungai Jernih'),
('16.13.01.2014','Beringin Jaya'),
('16.13.01.2015','Lubuk Rumbai Baru'),
('16.13.01.2016','Noman Baru'),
('16.13.01.2017','Batu Gajah Baru'),
('16.13.02','Rawas Ulu'),
('16.13.02.1005','Pasar Surulangun'),
('16.13.02.2001','Pangkalan'),
('16.13.02.2002','Kerta Dewa'),
('16.13.02.2003','Teladas'),
('16.13.02.2004','Pulau Lebar'),
('16.13.02.2006','Sungai Baung'),
('16.13.02.2007','Sungai Jauh'),
('16.13.02.2008','Sungai Kijang'),
('16.13.02.2009','Surulangun'),
('16.13.02.2010','Lesung Batu'),
('16.13.02.2011','Lubuk Kemang'),
('16.13.02.2012','Remban'),
('16.13.02.2013','Lesung Batu Muda'),
('16.13.02.2014','Simpang Nibung Rawas'),
('16.13.02.2015','Lubuk Mas'),
('16.13.02.2016','Sungai Lanang'),
('16.13.02.2017','Sukomoro'),
('16.13.03','Nibung'),
('16.13.03.1003','Karya Makmur'),
('16.13.03.2001','Tebing Tinggi'),
('16.13.03.2002','Jadi Mulya'),
('16.13.03.2004','Mulya Jaya'),
('16.13.03.2005','Sumber Makmur'),
('16.13.03.2006','Sri Jaya Makmur'),
('16.13.03.2007','Kelumpang Jaya'),
('16.13.03.2008','Bumi Makmur'),
('16.13.03.2009','Sumber Sari'),
('16.13.03.2010','Krani Jaya'),
('16.13.03.2011','Jadi Mulya I'),
('16.13.04','Rawas Ilir'),
('16.13.04.1005','Bingin Teluk'),
('16.13.04.2001','Pauh'),
('16.13.04.2002','Batu Kucing'),
('16.13.04.2003','Belani'),
('16.13.04.2004','Tanjung Raja'),
('16.13.04.2006','Mandi Angin'),
('16.13.04.2007','Air Bening'),
('16.13.04.2008','Beringin Sakti'),
('16.13.04.2009','Beringin Makmur I'),
('16.13.04.2010','Beringin Makmur II'),
('16.13.04.2011','Pauh I'),
('16.13.04.2012','Ketapat Bening'),
('16.13.04.2013','Mekarsari'),
('16.13.05','Karang Dapo'),
('16.13.05.1004','Karang Dapo'),
('16.13.05.2001','Aringin'),
('16.13.05.2002','Biaro Baru'),
('16.13.05.2003','Biaro Lama'),
('16.13.05.2005','Rantau Kadam'),
('16.13.05.2006','Kerta Sari'),
('16.13.05.2007','Karang Dapo I'),
('16.13.05.2008','Setia Marga'),
('16.13.05.2009','Bina Karya'),
('16.13.06','Karang Jaya'),
('16.13.06.1009','Karang Jaya'),
('16.13.06.2001','Bukit Ulu'),
('16.13.06.2002','Sukaraja'),
('16.13.06.2003','Lubuk Kumbung'),
('16.13.06.2004','Muara Batang Empu'),
('16.13.06.2005','Tanjung Agung'),
('16.13.06.2006','Rantau Telang'),
('16.13.06.2007','Suka Menang'),
('16.13.06.2008','Terusan'),
('16.13.06.2010','Muara Tiku'),
('16.13.06.2011','Embacang Baru'),
('16.13.06.2012','Embacang Lama'),
('16.13.06.2013','Rantau Jaya'),
('16.13.06.2014','Bukit Langkap'),
('16.13.06.2015','Embacang Baru Ilir'),
('16.13.07','Ulu Rawas'),
('16.13.07.1007','Muara Kulam'),
('16.13.07.2001','Jangkat'),
('16.13.07.2002','Napal Licin'),
('16.13.07.2003','Sosokan'),
('16.13.07.2004','Kuto Tanjung'),
('16.13.07.2005','Muara Kuis'),
('16.13.07.2006','Pulau Kidak'),
('16.71','Kota Palembang'),
('16.71.01','Ilir Barat Dua'),
('16.71.01.1001','Tiga-puluh-lima Ilir'),
('16.71.01.1002','Tiga-puluh-dua Ilir'),
('16.71.01.1003','Tiga-puluh Ilir'),
('16.71.01.1004','Dua-puluh-sembilan Ilir'),
('16.71.01.1005','Dua-puluh-delapan Ilir'),
('16.71.01.1006','Dua-puluh-tujuh Ilir'),
('16.71.01.1007','Kemangmanis'),
('16.71.02','Seberang Ulu Satu'),
('16.71.02.1002','Satu Ulu'),
('16.71.02.1003','Dua Ulu'),
('16.71.02.1004','Tiga Empat Ulu'),
('16.71.02.1005','Lima Ulu'),
('16.71.02.1006','Tujuh Ulu'),
('16.71.03','Seberang Ulu Dua'),
('16.71.03.1001','Sebelas Ulu'),
('16.71.03.1002','Dua-belas Ulu'),
('16.71.03.1003','Tiga-belas Ulu'),
('16.71.03.1004','Empat-belas Ulu'),
('16.71.03.1005','Enam-belas Ulu'),
('16.71.03.1006','Tanggatakat'),
('16.71.03.1007','Sentosa'),
('16.71.04','Ilir Barat Satu'),
('16.71.04.1001','Bukitlama'),
('16.71.04.1002','Lorokpakjo'),
('16.71.04.1003','Dua-puluh-enam Ilir Satu'),
('16.71.04.1004','Siringagung'),
('16.71.04.1005','Demang-Lebardaun'),
('16.71.04.1006','Bukitbaru'),
('16.71.05','Ilir Timur Satu'),
('16.71.05.1001','Delapan-belas Ilir'),
('16.71.05.1002','Enam-belas Ilir'),
('16.71.05.1003','Tiga-belas Ilir'),
('16.71.05.1004','Empat-belas Ilir'),
('16.71.05.1005','Lima-belas Ilir'),
('16.71.05.1006','Tujuh-belas Ilir'),
('16.71.05.1007','Dua-puluh Ilir Tiga'),
('16.71.05.1008','Dua-puluh Ilir Empat'),
('16.71.05.1009','Dua-puluh Ilir Satu'),
('16.71.05.1010','Sungaipangeran'),
('16.71.05.1011','Kepandean-Baru'),
('16.71.06','Ilir Timur Dua'),
('16.71.06.1005','Lima Ilir'),
('16.71.06.1006','Tiga Ilir'),
('16.71.06.1007','Satu Ilir'),
('16.71.06.1008','Dua Ilir'),
('16.71.06.1009','Lawangkidul'),
('16.71.06.1012','Sungaibuah'),
('16.71.07','Sukarami'),
('16.71.07.1002','Talangbetutu'),
('16.71.07.1004','Sukajaya'),
('16.71.07.1005','Sukarami'),
('16.71.07.1007','Kebunbunga'),
('16.71.07.1009','Sukabangun'),
('16.71.07.1010','Talangjambe'),
('16.71.07.1011','Sukodadi'),
('16.71.08','Sako'),
('16.71.08.1001','Sukamaju'),
('16.71.08.1002','Sako'),
('16.71.08.1006','Sialang'),
('16.71.08.1007','Sako Baru'),
('16.71.09','Kemuning'),
('16.71.09.1001','Dua-puluh Ilir Dua'),
('16.71.09.1002','Ario Kemuning'),
('16.71.09.1003','Sekipjaya'),
('16.71.09.1004','Pahlawan'),
('16.71.09.1005','Pipareja'),
('16.71.09.1006','Talangaman'),
('16.71.10','Kalidoni'),
('16.71.10.1001','Bukitsangkal'),
('16.71.10.1002','Kalidoni'),
('16.71.10.1003','Sungaiselayur'),
('16.71.10.1004','Sungaiselincah'),
('16.71.10.1005','Sungailais'),
('16.71.11','Bukitkecil'),
('16.71.11.1001','Sembilan-belas Ilir'),
('16.71.11.1002','Dua-puluh-dua Ilir'),
('16.71.11.1003','Dua-puluh-tiga Ilir'),
('16.71.11.1004','Dua-puluh-empat Ilir'),
('16.71.11.1005','Dua-puluh-enam Ilir'),
('16.71.11.1006','Talangsemut'),
('16.71.12','Gandus'),
('16.71.12.1001','Gandus'),
('16.71.12.1002','Karanganyar'),
('16.71.12.1003','Tiga-puluh-enam Ilir'),
('16.71.12.1004','Karangjaya'),
('16.71.12.1005','Pulokerto'),
('16.71.13','Kertapati'),
('16.71.13.1001','Kemasrindo'),
('16.71.13.1002','Kemangagung'),
('16.71.13.1003','Keramasan'),
('16.71.13.1004','Kertapati'),
('16.71.13.1005','Karyajaya'),
('16.71.13.1006','Oganbaru'),
('16.71.14','Plaju'),
('16.71.14.1001','Plaju Ulu'),
('16.71.14.1002','Plaju Darat'),
('16.71.14.1003','Plaju Ilir'),
('16.71.14.1004','Baguskuning'),
('16.71.14.1005','Komperta'),
('16.71.14.1006','Talangputri'),
('16.71.14.1007','Talangbubuk'),
('16.71.15','Alang-alang Lebar'),
('16.71.15.1001','Alang-Alang Lebar'),
('16.71.15.1002','Srijaya'),
('16.71.15.1003','Talangkelapa'),
('16.71.15.1004','Karyabaru'),
('16.71.16','Sematangborang'),
('16.71.16.1001','Srimulya'),
('16.71.16.1002','Sukamulya'),
('16.71.16.1003','Lebung-Gajah'),
('16.71.16.1005','Karyamulya'),
('16.71.17','Jakabaring'),
('16.71.17.1001','Delapan Ulu'),
('16.71.17.1002','Sembilan Sepuluh Ulu'),
('16.71.17.1003','Lima-belas Ulu'),
('16.71.17.1004','Silaberanti'),
('16.71.17.1005','Tuankentang'),
('16.71.18','Ilir Timur Tiga'),
('16.71.18.1001','Delapan Ilir'),
('16.71.18.1002','Sembilan Ilir'),
('16.71.18.1003','Sepuluh Ilir'),
('16.71.18.1004','Sebelas Ilir'),
('16.71.18.1005','Kutobatu'),
('16.71.18.1006','Duku'),
('16.72','Kota Pagar Alam'),
('16.72.01','Pagar Alam Utara'),
('16.72.01.1001','Sukorejo'),
('16.72.01.1002','Bangun Rejo'),
('16.72.01.1005','Pagar Alam'),
('16.72.01.1007','Alun Dua'),
('16.72.01.1014','Selibar'),
('16.72.01.1016','Beringin Jaya'),
('16.72.01.1018','Dempo Makmur'),
('16.72.01.1019','Kuripan Babas'),
('16.72.01.1020','Bangun Jaya'),
('16.72.01.1021','Curup Jare'),
('16.72.02','Pagar Alam Selatan'),
('16.72.02.1003','Sidorejo'),
('16.72.02.1004','Nendagung'),
('16.72.02.1005','Gunung Dempo'),
('16.72.02.1018','Tebat Giri Indah'),
('16.72.02.1019','Tumbak Ulas'),
('16.72.02.1020','Ulu Rurah'),
('16.72.02.1021','Tanjung Agung'),
('16.72.02.1022','Besemah Serasan'),
('16.72.03','Dempo Utara'),
('16.72.03.1006','Jangkar Mas'),
('16.72.03.1012','Bumi Agung'),
('16.72.03.1019','Muara Siban'),
('16.72.03.1022','Agung Lawangan'),
('16.72.03.1023','Pagar Wangi'),
('16.72.03.1024','Burung Dinang'),
('16.72.03.1025','Rebah Tinggi'),
('16.72.04','Dempo Selatan'),
('16.72.04.1002','Lubuk Buntak'),
('16.72.04.1018','Prahu Dipo'),
('16.72.04.1020','Kance Diwe'),
('16.72.04.1021','Atung Bungsu'),
('16.72.04.1022','Penjalang'),
('16.72.05','Dempo Tengah'),
('16.72.05.1001','Karang Dalo'),
('16.72.05.1003','Pelang Kenidai'),
('16.72.05.1008','Jokoh'),
('16.72.05.1011','Padang Temu'),
('16.72.05.1012','Candi Jaya'),
('16.73','Kota Lubuk Linggau'),
('16.73.01','Lubuk Linggau Timur I'),
('16.73.01.1001','Air Kuti'),
('16.73.01.1002','Majapahit'),
('16.73.01.1003','Taba Jemekeh'),
('16.73.01.1004','Nikan Jaya'),
('16.73.01.1005','Taba Lestari'),
('16.73.01.1007','Batu Urip Taba'),
('16.73.01.1015','Taba Koji'),
('16.73.01.1016','Watervang'),
('16.73.02','Lubuk Linggau Barat I'),
('16.73.02.1001','Kayu Ara'),
('16.73.02.1002','Lubuk Tanjung'),
('16.73.02.1003','Tanjung Indah'),
('16.73.02.1004','Bandung Ujung'),
('16.73.02.1008','Bandung Kiri'),
('16.73.02.1009','Sukajadi'),
('16.73.02.1010','Muara Enim'),
('16.73.02.1015','Watas Lubuk Durian'),
('16.73.02.1016','Lubuk Aman'),
('16.73.02.1018','Tanjung Aman'),
('16.73.02.1019','Pelita Jaya'),
('16.73.03','Lubuk Linggau Selatan I'),
('16.73.03.1001','Lubuk Kupang'),
('16.73.03.1003','Rahmah'),
('16.73.03.1008','Jukung'),
('16.73.03.1009','Air Kati'),
('16.73.03.1010','Air Teman'),
('16.73.03.1011','Perumnas Rahmah'),
('16.73.03.1012','Lubuk Binjai'),
('16.73.04','Lubuk Linggau Utara I'),
('16.73.04.1001','Durian Rampak'),
('16.73.04.1002','Tanjung Raya'),
('16.73.04.1003','Sumber Agung'),
('16.73.04.1004','Marga Bakti'),
('16.73.04.1005','Belalau I'),
('16.73.04.1006','Belalau II'),
('16.73.04.1007','Taba Baru'),
('16.73.04.1008','Margorejo'),
('16.73.04.1009','Petanang Ulu'),
('16.73.04.1010','Petanang Ilir'),
('16.73.05','Lubuk Linggau Timur II'),
('16.73.05.1001','Jawa Kanan'),
('16.73.05.1002','Jawa Kanan SS'),
('16.73.05.1003','Wira Karya'),
('16.73.05.1004','Dempo'),
('16.73.05.1005','Jawa Kiri'),
('16.73.05.1006','Karya Bakti'),
('16.73.05.1007','Mesat Jaya'),
('16.73.05.1008','Mesat Seni'),
('16.73.05.1009','Cereme Taba'),
('16.73.06','Lubuk Linggau Barat II'),
('16.73.06.1001','Sidorejo'),
('16.73.06.1002','Ulak Lebar'),
('16.73.06.1003','Tapak Lebar'),
('16.73.06.1004','Bandung Kanan'),
('16.73.06.1005','Keputraan'),
('16.73.06.1006','Lubuklinggau Ilir'),
('16.73.06.1007','Lubuklinggau Ulu'),
('16.73.06.1008','Pasar Permiri'),
('16.73.07','Lubuk Linggau Selatan II'),
('16.73.07.1001','Tanah Periuk'),
('16.73.07.1002','Simpang Periuk'),
('16.73.07.1003','Karang Ketuan'),
('16.73.07.1004','Siring Agung'),
('16.73.07.1005','Eka Marga'),
('16.73.07.1006','Marga Mulya'),
('16.73.07.1007','Marga Rahayu'),
('16.73.07.1008','Taba Pingin'),
('16.73.07.1009','Moneng Sepati'),
('16.73.08','Lubuk Linggau Utara II'),
('16.73.08.1001','Batu Urip'),
('16.73.08.1002','Ulak Surung'),
('16.73.08.1003','Kenanga'),
('16.73.08.1004','Pasar Satelit'),
('16.73.08.1005','Senalang'),
('16.73.08.1006','Megang'),
('16.73.08.1007','Jogoboyo'),
('16.73.08.1008','Puncak Kemuning'),
('16.73.08.1009','Ponorogo'),
('16.73.08.1010','Kali Serayu'),
('16.74','Kota Prabumulih'),
('16.74.01','Prabumulih Barat'),
('16.74.01.1001','Prabumulih'),
('16.74.01.1007','Patih Galung'),
('16.74.01.1009','Muntang Tapus'),
('16.74.01.1011','Gunung Kemala'),
('16.74.01.1012','Payuputat'),
('16.74.01.1014','Tebing Tanah Puteh'),
('16.74.01.2013','Tanjung Telang'),
('16.74.02','Prabumulih Timur'),
('16.74.02.1003','Karang Raja'),
('16.74.02.1004','Tugu Kecil'),
('16.74.02.1005','Prabu Jaya'),
('16.74.02.1006','Muara Dua'),
('16.74.02.1007','Gunung Ibul'),
('16.74.02.1008','Gunung Ibul Barat'),
('16.74.02.1009','Sukajadi'),
('16.74.02.1010','Karang Jaya'),
('16.74.02.1011','Muara Dua Barat'),
('16.74.02.1012','Gunung Ibul Timur'),
('16.74.02.1013','Gunung Ibul Selatan'),
('16.74.02.1014','Gunung Ibul Utara'),
('16.74.02.1015','Arimbi Jaya'),
('16.74.03','Cambai'),
('16.74.03.1001','Cambai'),
('16.74.03.1002','Sindur'),
('16.74.03.1005','Sungai Medang'),
('16.74.03.2003','Pangkul'),
('16.74.03.2004','Muara Sungai'),
('16.74.04','Rambang Kapak Tengah'),
('16.74.04.1001','Tanjung Rambang'),
('16.74.04.2003','Karya Mulya'),
('16.74.04.2005','Rambang Senuling'),
('16.74.04.2006','Jungai'),
('16.74.04.2007','Talang Batu'),
('16.74.04.2008','Karangan'),
('16.74.04.2009','Karang Bindu'),
('16.74.04.2010','Sinar Rambang'),
('16.74.04.2011','Kemang Tanduk'),
('16.74.05','Prabumulih Utara'),
('16.74.05.1001','Pasar Prabumulih I'),
('16.74.05.1002','Pasar Prabumulih II'),
('16.74.05.1003','Wonosari'),
('16.74.05.1004','Mangga Besar'),
('16.74.05.1005','Anak Petai'),
('16.74.05.1006','Sidomulyo'),
('16.74.05.1007','Sidogede'),
('16.74.06','Prabumulih Selatan'),
('16.74.06.1001','Majasari'),
('16.74.06.1002','Tanjung Raman'),
('16.74.06.1003','Sukaraja'),
('16.74.06.2004','Tanjung Menang');

-- Provinsi BENGKULU
INSERT INTO wilayah (kode, nama)
VALUES
('17','Bengkulu'),
('17.01','Kabupaten Bengkulu Selatan'),
('17.01.01','Kedurang'),
('17.01.01.2001','Batu Ampar'),
('17.01.01.2002','Rantau Sialang'),
('17.01.01.2003','Bumi Agung'),
('17.01.01.2004','Palak Siring'),
('17.01.01.2005','Keban Agung I'),
('17.01.01.2006','Keban Agung II'),
('17.01.01.2007','Tanjung Alam'),
('17.01.01.2008','Tanjung Negara'),
('17.01.01.2009','Keban Agung III'),
('17.01.01.2010','Suka Nanti'),
('17.01.01.2011','Muara Tiga'),
('17.01.01.2012','Tanjung Besar'),
('17.01.01.2013','Pajar Bulan'),
('17.01.01.2014','Durian Sebatang'),
('17.01.01.2015','Lawang Agung'),
('17.01.01.2027','Nanti Agung'),
('17.01.01.2028','Karang Agung'),
('17.01.01.2029','Lubuk Resam'),
('17.01.01.2030','Muara Tiga Ilir'),
('17.01.02','Seginim'),
('17.01.02.1024','Pasar Baru'),
('17.01.02.2001','Padang Lebar'),
('17.01.02.2002','Sukaraja'),
('17.01.02.2004','Tanjung Menang'),
('17.01.02.2005','Darat Sawah'),
('17.01.02.2006','Kota Agung'),
('17.01.02.2007','Babatan Ilir'),
('17.01.02.2008','Babatan Ulu'),
('17.01.02.2009','Muara Danau'),
('17.01.02.2011','Gunung Ayu'),
('17.01.02.2014','Muara Pulutan'),
('17.01.02.2015','Kota Bumi Baru'),
('17.01.02.2016','Sindang Bulan'),
('17.01.02.2017','Muara Payang'),
('17.01.02.2018','Durian Seginim'),
('17.01.02.2020','Banding Agung'),
('17.01.02.2021','Pajar Bulan'),
('17.01.02.2022','Dusun Tengah'),
('17.01.02.2023','Padang Siring'),
('17.01.02.2029','Darat Sawah Ulu'),
('17.01.02.2030','Tanjung Agung'),
('17.01.02.2031','Dusun Baru'),
('17.01.03','Pino'),
('17.01.03.1018','Masat'),
('17.01.03.2001','Tanjung Aur I'),
('17.01.03.2002','Anggut'),
('17.01.03.2003','Tanjung Eran'),
('17.01.03.2004','Padang Lebar'),
('17.01.03.2005','Gedung Agung'),
('17.01.03.2015','Batu Bandung'),
('17.01.03.2016','Ulak Lebar'),
('17.01.03.2017','Kota Bumi'),
('17.01.03.2019','Air Umban'),
('17.01.03.2020','Sebilo'),
('17.01.03.2021','Ganjuh'),
('17.01.03.2022','Puding'),
('17.01.03.2023','Padang Tambak'),
('17.01.03.2024','Padang Mumpo'),
('17.01.03.2025','Beringin Datar'),
('17.01.04','Manna'),
('17.01.04.1022','Kayu Kunyit'),
('17.01.04.2001','Tanjung Raman'),
('17.01.04.2016','Tanjung Besar'),
('17.01.04.2017','Manggul'),
('17.01.04.2018','Terulung'),
('17.01.04.2019','Ketaping'),
('17.01.04.2020','Lubuk Sirih Ulu'),
('17.01.04.2021','Lubuk Sirih Ilir'),
('17.01.04.2023','Kota Padang'),
('17.01.04.2024','Mela''o'),
('17.01.04.2025','Gunung Sakti'),
('17.01.04.2026','Jeranglah Rendah'),
('17.01.04.2027','Jeranglah Tinggi'),
('17.01.04.2028','Kembang Ayun'),
('17.01.04.2029','Tambangan'),
('17.01.04.2031','Padang Manis'),
('17.01.04.2032','Padang Pandan'),
('17.01.04.2033','Gunung Kembang'),
('17.01.05','Kota Manna'),
('17.01.05.1009','Gunung Ayu'),
('17.01.05.1010','Kota Medan'),
('17.01.05.1016','Kampung Baru'),
('17.01.05.1017','Pasar Baru'),
('17.01.05.1019','Ibul'),
('17.01.05.1020','Padang Kapuk'),
('17.01.05.2001','Pagar Dewa'),
('17.01.05.2004','Padang Niur'),
('17.01.05.2005','Tebat Kubu'),
('17.01.05.2006','Gelumbang'),
('17.01.05.2018','Padang Berangin'),
('17.01.06','Pino Raya'),
('17.01.06.2001','Selali'),
('17.01.06.2002','Air Kemang'),
('17.01.06.2003','Pasar Pino'),
('17.01.06.2004','Tanggo Raso'),
('17.01.06.2005','Talang Padang'),
('17.01.06.2006','Tungkal I'),
('17.01.06.2007','Tungkal II'),
('17.01.06.2008','Bandung Ayu'),
('17.01.06.2009','Napal Melintang'),
('17.01.06.2010','Serang Bulan'),
('17.01.06.2011','Suka Bandung'),
('17.01.06.2012','Pagar Gading'),
('17.01.06.2013','Cinto Mandi'),
('17.01.06.2014','Kembang Seri'),
('17.01.06.2015','Karang Cayo'),
('17.01.06.2016','Tanjung Aur II'),
('17.01.06.2017','Nanjungan'),
('17.01.06.2018','Kemang Manis'),
('17.01.06.2019','Padang Beriang'),
('17.01.06.2020','Padang Serasan'),
('17.01.06.2021','Telaga Dalam'),
('17.01.07','Kedurang Ilir'),
('17.01.07.2001','Karang Caya'),
('17.01.07.2002','Betungan'),
('17.01.07.2003','Pagar Banyu'),
('17.01.07.2004','Nanjungan'),
('17.01.07.2005','Suka Rami'),
('17.01.07.2006','Padang Bindu'),
('17.01.07.2007','Penindaian'),
('17.01.07.2008','Limus'),
('17.01.07.2009','Sukaraja'),
('17.01.07.2010','Lubuk Ladung'),
('17.01.07.2011','Air Sulau'),
('17.01.07.2012','Suka Jaya'),
('17.01.08','Air Nipis'),
('17.01.08.2001','Keban Jati'),
('17.01.08.2002','Tanjung Beringin'),
('17.01.08.2003','Suka Negeri'),
('17.01.08.2004','Sukarami'),
('17.01.08.2005','Palak Bengkerung'),
('17.01.08.2006','Sukamaju'),
('17.01.08.2007','Pino Baru'),
('17.01.08.2008','Penandingan'),
('17.01.08.2009','Suka Bandung'),
('17.01.08.2010','Maras'),
('17.01.09','Ulu Manna'),
('17.01.09.2001','Batu Panco'),
('17.01.09.2002','Batu Kuning'),
('17.01.09.2003','Bandar Agung'),
('17.01.09.2004','Merambung'),
('17.01.09.2005','Simpang Pino'),
('17.01.09.2006','Talang Tinggi'),
('17.01.09.2007','Keban Jati'),
('17.01.09.2008','Lubuk Tapi'),
('17.01.09.2009','Kayu Ajaran'),
('17.01.09.2010','Air Tenam'),
('17.01.10','Bunga Mas'),
('17.01.10.2001','Tumbuk Tebing'),
('17.01.10.2002','Gunung Kayo'),
('17.01.10.2003','Gindo Suli'),
('17.01.10.2004','Talang Indah'),
('17.01.10.2005','Kuripan'),
('17.01.10.2006','Padang Nibung'),
('17.01.10.2007','Tanjung Tebat'),
('17.01.10.2008','Padang Jawi'),
('17.01.10.2009','Tanjung Aur'),
('17.01.10.2010','Padang Burnai'),
('17.01.11','Pasar Manna'),
('17.01.11.1003','Tanjung Mulia'),
('17.01.11.1004','Pasar Mulia'),
('17.01.11.1005','Belakang Gedung'),
('17.01.11.1006','Gunung Mesir'),
('17.01.11.1007','Padang Sialang'),
('17.01.11.1008','Ketapang Besar'),
('17.01.11.1009','Pasar Bawah'),
('17.01.11.2001','Batu Kuning'),
('17.01.11.2002','Batu Lambang'),
('17.02','Kabupaten Rejang Lebong'),
('17.02.06','Kota Padang'),
('17.02.06.1004','Kota Padang'),
('17.02.06.1015','Bedeng SS'),
('17.02.06.1016','Dusun Baru'),
('17.02.06.2001','Derati'),
('17.02.06.2002','Taba Anyar'),
('17.02.06.2003','Suka Rami'),
('17.02.06.2005','Lubuk Mumpo'),
('17.02.06.2006','Durian Mas'),
('17.02.06.2018','Kota Padang Baru'),
('17.02.06.2020','Tanjung Gelang'),
('17.02.07','Padang Ulak Tanding'),
('17.02.07.1011','Pasar PU Tanding'),
('17.02.07.2001','Karang Baru'),
('17.02.07.2007','Guru Agung'),
('17.02.07.2008','Belumai II'),
('17.02.07.2009','Belumai I'),
('17.02.07.2010','Ulak Tanding'),
('17.02.07.2012','Tanjung Sanai I'),
('17.02.07.2013','Muara Telita'),
('17.02.07.2014','Ujan Panas'),
('17.02.07.2021','Taba Tinggi'),
('17.02.07.2022','Tanjung Sanai II'),
('17.02.07.2025','Taktoi'),
('17.02.07.2026','Kasie Kasubun'),
('17.02.07.2027','Air Kati'),
('17.02.07.2028','Bukit Batu'),
('17.02.08','Sindang Kelingi'),
('17.02.08.1006','Beringin Tiga'),
('17.02.08.2001','Sindang Jaya'),
('17.02.08.2002','Sindang Jati'),
('17.02.08.2003','Belitar Muka'),
('17.02.08.2004','Pelalo'),
('17.02.08.2005','Kayu Manis'),
('17.02.08.2009','Air Dingin'),
('17.02.08.2011','Belitar Seberang'),
('17.02.08.2013','Cahaya Negeri'),
('17.02.08.2014','Tanjung Aur'),
('17.02.09','Curup'),
('17.02.09.1012','Dwi Tunggal'),
('17.02.09.1013','Air Putih Lama'),
('17.02.09.1023','Adirejo'),
('17.02.09.1025','Air Rambai'),
('17.02.09.1026','Pasar Baru'),
('17.02.09.1027','Pasar Tengah'),
('17.02.09.1031','Jalan Baru'),
('17.02.09.1033','Talang Benih'),
('17.02.09.1047','Timbul Rejo'),
('17.02.10','Bermani Ulu'),
('17.02.10.2001','Air Mundu'),
('17.02.10.2002','Tebat Tenong Dalam'),
('17.02.10.2003','Baru Manis'),
('17.02.10.2012','Kampung Melayu'),
('17.02.10.2013','Sentral Baru'),
('17.02.10.2015','Kampung Sajad'),
('17.02.10.2016','Suka Rami'),
('17.02.10.2017','Pagar Gunung'),
('17.02.10.2018','Selamat Sudiarjo'),
('17.02.10.2019','Purwodadi'),
('17.02.10.2020','Air Pikat'),
('17.02.10.2021','Tebat Pulau'),
('17.02.11','Selupu Rejang'),
('17.02.11.1004','Air Duku'),
('17.02.11.1006','Cawang Baru'),
('17.02.11.1008','Simpang Nangka'),
('17.02.11.2001','Air Putih Kali Bandung'),
('17.02.11.2002','Air Meles Atas'),
('17.02.11.2003','Sambirejo'),
('17.02.11.2005','Suban Ayam'),
('17.02.11.2007','Cawang Lama'),
('17.02.11.2009','Sumber Urip'),
('17.02.11.2010','Sumber Bening'),
('17.02.11.2011','Karang Jaya'),
('17.02.11.2012','Kayu Manis'),
('17.02.11.2013','Kampung Baru'),
('17.02.11.2014','Kali Padang'),
('17.02.11.2015','Mojorejo'),
('17.02.11.2016','Talang Lahat'),
('17.02.16','Curup Utara'),
('17.02.16.1001','Dusun Curup'),
('17.02.16.1002','Tunas Harapan'),
('17.02.16.2003','Batu Dewa'),
('17.02.16.2004','Perbo'),
('17.02.16.2005','Batu Panco'),
('17.02.16.2006','Dusun Sawah'),
('17.02.16.2007','Lubuk Kembang'),
('17.02.16.2008','Suka Datang'),
('17.02.16.2009','Tabarenah'),
('17.02.16.2010','Pahlawan'),
('17.02.16.2011','Tasik Malaya'),
('17.02.16.2012','Tanjung Beringin'),
('17.02.16.2013','Kota Pagu'),
('17.02.16.2014','Seguring'),
('17.02.17','Curup Timur'),
('17.02.17.1001','Sukaraja'),
('17.02.17.1002','Kesambe Baru'),
('17.02.17.1003','Karang Anyar'),
('17.02.17.1004','Talang Ulu'),
('17.02.17.2005','Duku Ulu'),
('17.02.17.2006','Duku Ilir'),
('17.02.17.2007','Air Meles Bawah'),
('17.02.17.2008','Kampung Delima'),
('17.02.17.2009','Kesambe Lama'),
('17.02.18','Curup Selatan'),
('17.02.18.1001','Air Putih Baru'),
('17.02.18.1002','Tempel Rejo'),
('17.02.18.2003','Rimbo Recap'),
('17.02.18.2004','Watas Marga'),
('17.02.18.2005','Teladan'),
('17.02.18.2006','Suka Marga'),
('17.02.18.2007','Lubuk Ubar'),
('17.02.18.2008','Pungguk Lalang'),
('17.02.18.2009','Turan Baru'),
('17.02.18.2010','Tanjung Dalam'),
('17.02.18.2011','Air Lanang'),
('17.02.19','Curup Tengah'),
('17.02.19.1001','Kepala Siring'),
('17.02.19.1002','Talang Rimbo Baru'),
('17.02.19.1003','Talang Rimbo Lama'),
('17.02.19.1004','Siderejo'),
('17.02.19.1005','Kampung Jawa'),
('17.02.19.1006','Air Bang'),
('17.02.19.1007','Pelabuhan Baru'),
('17.02.19.1008','Batu Galing'),
('17.02.19.1009','Banyu Mas'),
('17.02.19.2010','Air Merah'),
('17.02.20','Binduriang'),
('17.02.20.2001','Kepala Curup'),
('17.02.20.2002','Kampung Jeruk'),
('17.02.20.2003','Simpang Beliti'),
('17.02.20.2004','Taba Padang'),
('17.02.20.2005','Air Apo'),
('17.02.21','Sindang Beliti Ulu'),
('17.02.21.2001','Apur'),
('17.02.21.2002','Lawang Agung'),
('17.02.21.2003','Lubuk Alai'),
('17.02.21.2004','Karang Pinang'),
('17.02.21.2005','Tanjung Agung'),
('17.02.21.2006','Pengambang'),
('17.02.21.2007','Jabi'),
('17.02.21.2008','Tanjung Herang'),
('17.02.21.2009','Air Nau'),
('17.02.22','Sindang Dataran'),
('17.02.22.2001','IV Suko Menanti'),
('17.02.22.2002','Air Rusa'),
('17.02.22.2003','Bengko'),
('17.02.22.2004','Sinar Gunung'),
('17.02.22.2005','Warung Pojok'),
('17.02.22.2006','Talang Belitar'),
('17.02.23','Sindang Beliti Ilir'),
('17.02.23.2001','Merantau'),
('17.02.23.2002','Periang'),
('17.02.23.2003','Balai Buntar'),
('17.02.23.2004','LubukTunjung'),
('17.02.23.2005','LB. Belimbing I'),
('17.02.23.2006','LB Belimbing II'),
('17.02.23.2007','LB. Bingin Baru'),
('17.02.23.2008','Sari Pulau'),
('17.02.23.2009','Suka Merindu'),
('17.02.23.2010','Suka karya'),
('17.02.24','Bermani Ulu Raya'),
('17.02.24.2001','Dataran Tapus'),
('17.02.24.2002','Bandung Marga'),
('17.02.24.2003','Pal Seratus'),
('17.02.24.2004','Pal VII'),
('17.02.24.2005','Pal VIII'),
('17.02.24.2006','Tebat Tenong Luar'),
('17.02.24.2007','Bangun Jaya'),
('17.02.24.2008','Babakan Baru'),
('17.02.24.2009','Sumberejo Transad'),
('17.02.24.2010','Air Bening'),
('17.03','Kabupaten Bengkulu Utara'),
('17.03.01','Enggano'),
('17.03.01.2001','Banjar Sari'),
('17.03.01.2002','Meok'),
('17.03.01.2003','Malakoni'),
('17.03.01.2004','Kaana'),
('17.03.01.2005','Kahyapu'),
('17.03.01.2006','Apoho'),
('17.03.06','Kerkap'),
('17.03.06.1009','Lubuk Durian'),
('17.03.06.2001','Talang Jambu'),
('17.03.06.2002','Tebat Pacur'),
('17.03.06.2003','Talang Curup'),
('17.03.06.2004','Banyu Mas Lama'),
('17.03.06.2005','Salam Harjo'),
('17.03.06.2006','Jogja Baru'),
('17.03.06.2007','Talang Pasak'),
('17.03.06.2008','Perbo'),
('17.03.06.2010','Lubuk Jale'),
('17.03.06.2011','Simpang Ketenong'),
('17.03.06.2012','Aur Gading'),
('17.03.06.2024','Kedu Baru'),
('17.03.06.2026','Serumbung'),
('17.03.06.2027','Magelang'),
('17.03.06.2028','Tanjung Putus'),
('17.03.06.2029','Penyangkak'),
('17.03.06.2031','Banyu Mas Baru'),
('17.03.07','Kota Arga Makmur'),
('17.03.07.1026','Purwodadi'),
('17.03.07.1027','Gunung Alam'),
('17.03.07.2001','Tanjung Raman'),
('17.03.07.2002','Lubuk Saung'),
('17.03.07.2003','Kuro Tidur'),
('17.03.07.2004','Karang Suci'),
('17.03.07.2005','Rama Agung'),
('17.03.07.2008','Talang Denau'),
('17.03.07.2009','Gunung Selan'),
('17.03.07.2010','Datar Ruyung'),
('17.03.07.2011','Senali'),
('17.03.07.2012','Gunung Agung'),
('17.03.07.2014','Sidourip'),
('17.03.07.2015','Karang Anyar I'),
('17.03.07.2016','Taba Tembilang'),
('17.03.07.2022','Karang Anyar II'),
('17.03.08','Giri Mulya'),
('17.03.08.2001','Tanjung Anom'),
('17.03.08.2002','Suka Makmur'),
('17.03.08.2003','Wono Harjo'),
('17.03.08.2004','Giri Mulya'),
('17.03.08.2005','Rena Jaya'),
('17.03.08.2006','Suka Mulya'),
('17.03.09','Padang Jaya'),
('17.03.09.2001','Lubuk Banyau'),
('17.03.09.2002','Talang Tua'),
('17.03.09.2003','Marga Sakti'),
('17.03.09.2004','Tanjung Harapan'),
('17.03.09.2005','Padang Jaya'),
('17.03.09.2006','Arga Mulya'),
('17.03.09.2007','Sidomukti'),
('17.03.09.2008','Marga Jaya'),
('17.03.09.2009','Tanah Hitam'),
('17.03.09.2010','Tambak Rejo'),
('17.03.09.2011','Sido Luhur'),
('17.03.09.2012','Tanah Tinggi'),
('17.03.10','Lais'),
('17.03.10.1010','Pasar Lais'),
('17.03.10.2008','Datar Lebar'),
('17.03.10.2009','Air Padang'),
('17.03.10.2011','Durian Daun'),
('17.03.10.2012','Dusun Raja'),
('17.03.10.2013','Lubuk Lesung'),
('17.03.10.2014','Pal 30'),
('17.03.10.2015','Jagobayo'),
('17.03.10.2017','Talang Rasau'),
('17.03.10.2018','Lubuk Gedang'),
('17.03.10.2019','Suka Langu'),
('17.03.10.2020','Taba Baru'),
('17.03.10.2021','Kalbang'),
('17.03.11','Batik Nau'),
('17.03.11.2001','Serangai'),
('17.03.11.2002','Selolong'),
('17.03.11.2003','Air Lakok'),
('17.03.11.2004','Bintunan'),
('17.03.11.2005','Suka Marga'),
('17.03.11.2006','Batik Nau'),
('17.03.11.2007','Pagar Ruyung'),
('17.03.11.2008','Durian Amparan'),
('17.03.11.2009','Taba Kulintang'),
('17.03.11.2010','Ulak Tanding'),
('17.03.11.2011','Seberang Tunggal'),
('17.03.11.2012','Sekiau'),
('17.03.11.2013','Samban Jaya'),
('17.03.11.2014','Peninjau'),
('17.03.11.2015','Air Manganyau'),
('17.03.12','Ketahun'),
('17.03.12.2001','Urai'),
('17.03.12.2002','Pasar Ketahun'),
('17.03.12.2003','Giri Kencana'),
('17.03.12.2004','Kuala Langi'),
('17.03.12.2005','Dusun Raja'),
('17.03.12.2012','Lubuk Mindai'),
('17.03.12.2013','Pajar Baru'),
('17.03.12.2014','Talang Baru'),
('17.03.12.2019','Melati Harjo K.1'),
('17.03.12.2020','Bukit Indah'),
('17.03.12.2021','Bukit Tinggi'),
('17.03.13','Napal Putih'),
('17.03.13.2003','Tanjung Alai'),
('17.03.13.2004','Jabi'),
('17.03.13.2005','Napal Putih'),
('17.03.13.2006','Air Tenang'),
('17.03.13.2007','Teluk Anggung'),
('17.03.13.2008','Tanjung Kemayan'),
('17.03.13.2009','Muara Santan'),
('17.03.13.2016','Lebong Tandai'),
('17.03.13.2019','Gembung Raya'),
('17.03.13.2020','Kinal Jaya'),
('17.03.14','Putri Hijau'),
('17.03.14.2007','Talang Arah'),
('17.03.14.2008','Pasar Sebelat'),
('17.03.14.2009','Kota Bani'),
('17.03.14.2013','Air Muring'),
('17.03.14.2014','Air Pandan'),
('17.03.14.2015','Cipta Mulya'),
('17.03.14.2017','Air Petai'),
('17.03.14.2018','Karang Tengah'),
('17.03.14.2019','Karang Pulau'),
('17.03.15','Air Besi'),
('17.03.15.2003','Genting Perangkap'),
('17.03.15.2004','Lubuk Balam'),
('17.03.15.2005','Datar Macang'),
('17.03.15.2006','Tanjung Genting'),
('17.03.15.2007','Talang Renah'),
('17.03.15.2008','Kota Agung'),
('17.03.15.2009','Talang Lembak'),
('17.03.15.2010','Kertapati'),
('17.03.15.2011','Talang Pungguk'),
('17.03.15.2012','Talang Baru Ginting'),
('17.03.15.2013','Tanjung Karet'),
('17.03.15.2014','Talang Ginting'),
('17.03.15.2015','Sungai Pura'),
('17.03.15.2016','Dusun Curup'),
('17.03.15.2017','Penyangkak'),
('17.03.16','Air Napal'),
('17.03.16.2001','Pasar Bembah'),
('17.03.16.2002','Tepi Laut'),
('17.03.16.2003','Pasar Kerkap'),
('17.03.16.2005','Air Napal'),
('17.03.16.2006','Talang Kering'),
('17.03.16.2007','Selubuk'),
('17.03.16.2008','Pasar Tebat'),
('17.03.16.2009','Lubuk Tanjung'),
('17.03.16.2011','Pukur'),
('17.03.16.2014','Pasar Palik'),
('17.03.16.2015','Tebing Kandang'),
('17.03.16.2016','Talang Jarang'),
('17.03.19','Hulu Palik'),
('17.03.19.2001','Kota Lekat'),
('17.03.19.2002','Padang Bendar'),
('17.03.19.2003','Taba Padang R'),
('17.03.19.2004','Taba Padang Kol'),
('17.03.19.2005','Air Banai'),
('17.03.19.2006','Batu Raja R'),
('17.03.19.2007','Batu Raja Kol'),
('17.03.19.2008','Batu Layang'),
('17.03.19.2009','Batu Roto'),
('17.03.19.2010','Air Ba''us I'),
('17.03.19.2011','Air Ba''us II'),
('17.03.19.2012','Pematang Balam'),
('17.03.19.2013','Talang Rendah'),
('17.03.19.2014','Sumber Rejo'),
('17.03.19.2015','Kota Lekat Mudik'),
('17.03.20','Air Padang'),
('17.03.20.2001','Padang Kala'),
('17.03.20.2002','Kembang Manis'),
('17.03.20.2003','Teluk Ajang'),
('17.03.20.2004','Balam'),
('17.03.20.2005','Suka Rami'),
('17.03.20.2006','Mesigit'),
('17.03.20.2007','Retes'),
('17.03.20.2008','Lubuk Mumpo'),
('17.03.20.2009','Talang Ulu'),
('17.03.20.2010','Tanjung Aur'),
('17.03.21','Arma Jaya'),
('17.03.21.1001','Kemumu'),
('17.03.21.2002','Tebing Kaning'),
('17.03.21.2003','Sidodadi'),
('17.03.21.2004','Sumber Agung'),
('17.03.21.2005','Pematang Sapang'),
('17.03.21.2006','Pagar Banyu'),
('17.03.21.2007','Gardu'),
('17.03.21.2008','Kali'),
('17.03.21.2009','Kalai Duai'),
('17.03.21.2010','Pagar Ruyung'),
('17.03.21.2011','Air Merah'),
('17.03.21.2012','Gunung Besar'),
('17.03.22','Tanjung Agung Palik'),
('17.03.22.2001','Sengkuang'),
('17.03.22.2002','Lubuk Pendam'),
('17.03.22.2003','Alun Dua'),
('17.03.22.2004','Ketapi'),
('17.03.22.2005','Lubuk Semantung'),
('17.03.22.2006','Sawang Lebar'),
('17.03.22.2007','Sawang Lebar Ilir'),
('17.03.22.2008','Lubuk Gading'),
('17.03.22.2009','Tanjung Agung'),
('17.03.22.2010','Padang Sepan'),
('17.03.23','Ulok Kupai'),
('17.03.23.2001','Air Lelangi'),
('17.03.23.2002','Bukit Berlian'),
('17.03.23.2003','Tanjung Dalam'),
('17.03.23.2004','Bukit Sari'),
('17.03.23.2005','Pagardin'),
('17.03.23.2006','Tanjung Harapan'),
('17.03.23.2007','Tanjung Sari'),
('17.03.23.2008','Bangun Karya'),
('17.03.23.2009','Pondok Bakil'),
('17.03.23.2010','Talang Berantai'),
('17.03.24','Pinang Raya'),
('17.03.24.2001','Air Sebayur'),
('17.03.24.2002','Air Sekamanak'),
('17.03.24.2003','Air Simpang'),
('17.03.24.2004','Bukit Makmur'),
('17.03.24.2005','Marga Bhakti'),
('17.03.24.2006','Bumi Harjo'),
('17.03.24.2007','Sumber Mulya'),
('17.03.24.2008','Gunung Payung'),
('17.03.24.2009','Bukit Harapan'),
('17.03.24.2010','Tanjung Muara'),
('17.03.25','Marga Sakti Sebelat'),
('17.03.25.2001','Air Putih'),
('17.03.25.2002','Suka Makmur'),
('17.03.25.2003','Karya Pelita'),
('17.03.25.2004','Suka Maju'),
('17.03.25.2005','Suka Baru'),
('17.03.25.2006','Suka Merindu'),
('17.03.25.2007','Suka Medan'),
('17.03.25.2008','Karya Bakti'),
('17.03.25.2009','Karya Jaya'),
('17.03.25.2010','Suka Negara'),
('17.04','Kabupaten Kaur'),
('17.04.01','Kinal'),
('17.04.01.2001','Gedung Wani'),
('17.04.01.2002','Penandingan'),
('17.04.01.2003','Geramat'),
('17.04.01.2004','Tanjung Alam'),
('17.04.01.2005','Tanjung Baru'),
('17.04.01.2006','Pengurung'),
('17.04.01.2007','Pinang Jawa'),
('17.04.01.2008','Gunung Terang'),
('17.04.01.2009','Talang Padang'),
('17.04.01.2010','Gunung Megang'),
('17.04.01.2020','Talang Berangin'),
('17.04.01.2021','Jawi'),
('17.04.01.2022','Papahan'),
('17.04.01.2023','Pinang Jawa II'),
('17.04.02','Tanjung Kemuning'),
('17.04.02.2002','Tinggi Ari'),
('17.04.02.2003','Tanjung Aur'),
('17.04.02.2004','Aur Ringit'),
('17.04.02.2008','Pelajaran'),
('17.04.02.2009','Tanjung Kemuning'),
('17.04.02.2010','Selika'),
('17.04.02.2011','Tanjung Iman'),
('17.04.02.2012','Padang Leban'),
('17.04.02.2013','Beriang Tinggi'),
('17.04.02.2014','Tanjung Bulan'),
('17.04.02.2015','Pelajaran II'),
('17.04.02.2016','Selika II'),
('17.04.02.2017','Sulauwangi'),
('17.04.02.2018','Padang Kedondong'),
('17.04.02.2020','Padang Tinggi'),
('17.04.02.2021','Tanjung Kemuning II'),
('17.04.02.2022','Tanjung Kemuning III'),
('17.04.02.2023','Tanjung Aur II'),
('17.04.02.2024','Tanjung Iman II'),
('17.04.02.2025','Selika III'),
('17.04.03','Kaur Utara'),
('17.04.03.1010','Simpang Tiga'),
('17.04.03.2001','Tanjung Betung'),
('17.04.03.2003','Padang Manis'),
('17.04.03.2006','Guru Agung'),
('17.04.03.2009','Gunung Agung'),
('17.04.03.2021','Bandu Agung'),
('17.04.03.2027','Tanjung Betung II'),
('17.04.03.2028','Coko Enau'),
('17.04.03.2029','Pancur Negara'),
('17.04.03.2030','Perugaian'),
('17.04.03.2031','Guru Agung II'),
('17.04.04','Kaur Tengah'),
('17.04.04.1007','Tanjung Iman'),
('17.04.04.2001','Sukarami'),
('17.04.04.2002','Pajar Bulan'),
('17.04.04.2003','Padang Hangat'),
('17.04.04.2004','Kemang Manis'),
('17.04.04.2005','Penyandingan'),
('17.04.04.2006','Sinar Jaya'),
('17.04.04.2008','Tanjung Pandan'),
('17.04.04.2009','Padang Baru'),
('17.04.05','Kaur Selatan'),
('17.04.05.1013','Bandar Bintuhan'),
('17.04.05.2009','Sekunyit'),
('17.04.05.2010','Suka Bandung'),
('17.04.05.2011','Air Dingin'),
('17.04.05.2012','Pasar Baru'),
('17.04.05.2014','Pasar Lama'),
('17.04.05.2015','Gedung Sako'),
('17.04.05.2016','Jembatan Dua'),
('17.04.05.2017','Tanjung Besar'),
('17.04.05.2021','Pengubaian'),
('17.04.05.2022','Pahlawan Ratu'),
('17.04.05.2023','Pasar Saoh'),
('17.04.05.2024','Kepala Pasar'),
('17.04.05.2025','Padang Petron'),
('17.04.05.2026','Sawah Jangkung'),
('17.04.05.2027','Selasih'),
('17.04.05.2028','Padang Genting'),
('17.04.05.2029','Gedung Sako II'),
('17.04.05.2030','Sinar Pagi'),
('17.04.06','Maje'),
('17.04.06.2001','Parda Suka'),
('17.04.06.2002','Air Long'),
('17.04.06.2003','Linau'),
('17.04.06.2004','Way Hawang'),
('17.04.06.2005','Tanjung Baru'),
('17.04.06.2006','Tanjung Ganti'),
('17.04.06.2007','Kedataran'),
('17.04.06.2008','Tanjung Aur'),
('17.04.06.2009','Penyandingan'),
('17.04.06.2010','Suka Menanti'),
('17.04.06.2012','Benteng Harapan'),
('17.04.06.2013','Bakal Makmur'),
('17.04.06.2014','Muara Jaya'),
('17.04.06.2015','Tanjung Agung'),
('17.04.06.2016','Arga Mulya'),
('17.04.06.2017','Air Jelatang'),
('17.04.06.2019','Sumber Harapan'),
('17.04.06.2020','Tanjung Beringin'),
('17.04.06.2021','Sinar Mulya'),
('17.04.07','Nasal'),
('17.04.07.2001','Muara Dua'),
('17.04.07.2002','Gedung Menung'),
('17.04.07.2003','Ulak Pandan'),
('17.04.07.2005','Merpas'),
('17.04.07.2007','Tanjung Betuah'),
('17.04.07.2008','Air Palawan'),
('17.04.07.2009','Tebing Rambutan'),
('17.04.07.2010','Batu Lungun'),
('17.04.07.2011','Sumber Harapan'),
('17.04.07.2012','Suku Tiga'),
('17.04.07.2013','Bukit Indah'),
('17.04.07.2014','Suka Jaya'),
('17.04.07.2015','Pasar Baru'),
('17.04.07.2016','Tri Jaya'),
('17.04.07.2017','Air Batang'),
('17.04.07.2018','Sinar Banten'),
('17.04.07.2019','Pasar Jum''at'),
('17.04.08','Semidang Gumay'),
('17.04.08.2001','Bunga Melur'),
('17.04.08.2002','Karang Dapo'),
('17.04.08.2003','Lubuk Gung'),
('17.04.08.2004','Gunung Tiga'),
('17.04.08.2005','Suka Merindu'),
('17.04.08.2006','Mentiring'),
('17.04.08.2007','Cahaya Batin'),
('17.04.08.2008','Awat Mata'),
('17.04.08.2009','Nusuk'),
('17.04.08.2010','Tanjung Harapan'),
('17.04.08.2011','Gunung Tiga II'),
('17.04.08.2012','Padang Panjang'),
('17.04.08.2013','Masria Baru'),
('17.04.09','Kelam Tengah'),
('17.04.09.2001','Tanjung Ganti I'),
('17.04.09.2002','Tanjung Ganti II'),
('17.04.09.2003','Rigangan I'),
('17.04.09.2004','Rigangan II'),
('17.04.09.2005','Rigangan III'),
('17.04.09.2006','Sukarami'),
('17.04.09.2007','Darat Sawah'),
('17.04.09.2008','Siring Agung'),
('17.04.09.2009','Penantian'),
('17.04.09.2010','Talang Tais'),
('17.04.09.2011','Pagar Dewa'),
('17.04.09.2012','Talang Marap'),
('17.04.09.2013','Suka Rami II'),
('17.04.10','Luas'),
('17.04.10.2001','Bangun Jiwa'),
('17.04.10.2002','Cahaya Negeri'),
('17.04.10.2003','Padang Jati'),
('17.04.10.2004','Ganda Suli'),
('17.04.10.2005','Durian Besar'),
('17.04.10.2006','Tanjung Beringin'),
('17.04.10.2007','Umbul'),
('17.04.10.2008','Benua Ratu'),
('17.04.10.2009','Tuguk'),
('17.04.10.2010','Kepahyang'),
('17.04.10.2011','Pulau Panggung'),
('17.04.10.2012','Serdang Indah'),
('17.04.11','Muara Sahung'),
('17.04.11.2001','Muara Sahung'),
('17.04.11.2002','Tri Tunggal Bakti'),
('17.04.11.2003','Ulak Lebar'),
('17.04.11.2004','Sumber Makmur'),
('17.04.11.2005','Ulak Bandung'),
('17.04.11.2006','Cinta Makmur'),
('17.04.11.2007','Bukit Makmur'),
('17.04.12','Tetap'),
('17.04.12.2001','Suka Banjar'),
('17.04.12.2002','Tanjung Bunga'),
('17.04.12.2003','Cucupan'),
('17.04.12.2004','Pagar Dewa'),
('17.04.12.2005','Tanjung Agung'),
('17.04.12.2006','Babat'),
('17.04.12.2007','Kepahyang'),
('17.04.12.2008','Tanjung Dalam'),
('17.04.12.2009','Muara Tetap'),
('17.04.12.2010','Kasuk Baru'),
('17.04.12.2011','Padang Binjai'),
('17.04.12.2012','Suka Raja'),
('17.04.13','Lungkang Kule'),
('17.04.13.2001','Datar Lebar'),
('17.04.13.2002','Tanjung Bunian'),
('17.04.13.2003','Sinar Bulan'),
('17.04.13.2004','Sukananti'),
('17.04.13.2005','Lawang Agung'),
('17.04.13.2006','Tanjung Kurung'),
('17.04.13.2007','Senak'),
('17.04.13.2008','Datar Lebar II'),
('17.04.13.2009','Aur Gading'),
('17.04.14','Padang Guci Hilir'),
('17.04.14.2001','Pulau Panggung'),
('17.04.14.2002','Talang Besar'),
('17.04.14.2003','Talang Jawi I'),
('17.04.14.2004','Talang Jawi II'),
('17.04.14.2005','Air Kering'),
('17.04.14.2006','Gunung Kaya'),
('17.04.14.2007','Ulak Agung'),
('17.04.14.2008','Talang Padang'),
('17.04.14.2009','Air Kering II'),
('17.04.15','Padang Guci Hulu'),
('17.04.15.2001','Naga Rantai'),
('17.04.15.2002','Bungin Tambun'),
('17.04.15.2003','Bungin Tambun II'),
('17.04.15.2004','Bungin Tambun III'),
('17.04.15.2005','Manau IX'),
('17.04.15.2006','Manau IX Dua'),
('17.04.15.2007','Pagar Alam'),
('17.04.15.2008','Pagar Gunung'),
('17.04.15.2009','Coko Betung'),
('17.04.15.2010','Marga Mulyo'),
('17.04.15.2011','Jati Mulyo'),
('17.05','Kabupaten Seluma'),
('17.05.01','Sukaraja'),
('17.05.01.1001','Babatan'),
('17.05.01.1025','Sukaraja'),
('17.05.01.2002','Niur'),
('17.05.01.2003','Lubuk Sahung'),
('17.05.01.2011','Bukit Peninjauan I'),
('17.05.01.2026','Padang Pelawi'),
('17.05.01.2027','Kayu Arang'),
('17.05.01.2028','Jenggalu'),
('17.05.01.2029','Cahaya Negeri'),
('17.05.01.2030','Bukit Peninjauan II'),
('17.05.01.2032','Riak Siabun'),
('17.05.01.2033','Padang Kuas'),
('17.05.01.2034','Kuti Agung'),
('17.05.01.2035','Riak Siabun I'),
('17.05.01.2036','Sido Luhur'),
('17.05.01.2037','Sumber Arung'),
('17.05.01.2038','Sido Sari'),
('17.05.01.2039','Sari Mulyo'),
('17.05.01.2043','Air Kemuning'),
('17.05.01.2044','Sumber Makmur'),
('17.05.01.2045','Air Petai'),
('17.05.02','Seluma'),
('17.05.02.1009','Lubuk Kebur'),
('17.05.02.1010','Pasar Tais'),
('17.05.02.1011','Lubuk Lintang'),
('17.05.02.1012','Talang Saling'),
('17.05.02.1013','Dusun Baru'),
('17.05.02.1014','Talang Dantuk'),
('17.05.02.1024','Napal'),
('17.05.03','Talo'),
('17.05.03.1014','Masmambang'),
('17.05.03.2002','Napal Melintang'),
('17.05.03.2003','Serambi Gunung'),
('17.05.03.2005','Air Payangan'),
('17.05.03.2012','Batu Tugu'),
('17.05.03.2013','Kampai'),
('17.05.03.2015','Lubuk Ngantungan'),
('17.05.03.2016','Durian Bubur'),
('17.05.03.2017','Muara Danau'),
('17.05.03.2018','Lubuk Gio'),
('17.05.03.2019','Kembang Seri'),
('17.05.03.2034','Bunut Tinggi'),
('17.05.03.2035','Air Teras'),
('17.05.03.2036','Lubuk Gadis'),
('17.05.03.2045','Simpang Tiga Pagar Gasing'),
('17.05.03.2046','Harapan Mulya'),
('17.05.04','Semidang Alas'),
('17.05.04.1005','Pajar Bulan'),
('17.05.04.2001','Maras Jauh'),
('17.05.04.2002','Bandung Agung'),
('17.05.04.2003','Pinju Layang'),
('17.05.04.2004','Nanjungan'),
('17.05.04.2006','Petai Kayu'),
('17.05.04.2007','Napalan'),
('17.05.04.2008','Renah Gajah Mati I'),
('17.05.04.2009','Renah Gajah Mati II'),
('17.05.04.2010','Cugung Langu'),
('17.05.04.2011','Rantau Panjang'),
('17.05.04.2012','Air Melancar'),
('17.05.04.2013','Muara Dua'),
('17.05.04.2014','Nanti Agung'),
('17.05.04.2015','Talang Durian'),
('17.05.04.2016','Gunung Mesir'),
('17.05.04.2017','Kayu Elang'),
('17.05.04.2018','Padang Serunaian'),
('17.05.04.2019','Tebat Gunung'),
('17.05.04.2020','Mekar Sari Mukti'),
('17.05.04.2021','Kemang Manis'),
('17.05.04.2022','Gunung Megang'),
('17.05.04.2023','Telatan'),
('17.05.04.2024','Suban'),
('17.05.05','Semidang Alas Maras'),
('17.05.05.1005','Kembang Mumpo'),
('17.05.05.2001','Sendawar'),
('17.05.05.2002','Gelombang'),
('17.05.05.2003','Lubuk Betung'),
('17.05.05.2004','Padang Peri'),
('17.05.05.2006','Karang Anyar'),
('17.05.05.2007','Ujung Padang'),
('17.05.05.2008','Ketapang Baru'),
('17.05.05.2009','Tedunan'),
('17.05.05.2010','Talang Alai'),
('17.05.05.2011','Padang Bakung'),
('17.05.05.2012','Jambat Akar'),
('17.05.05.2013','Gunung Kembang'),
('17.05.05.2014','Gunung Bantan'),
('17.05.05.2015','Maras Tengah'),
('17.05.05.2016','Padang Kelapa'),
('17.05.05.2017','Pematang Riding'),
('17.05.05.2018','Talang Beringin'),
('17.05.05.2019','Genting Juar'),
('17.05.05.2020','Muara Maras'),
('17.05.05.2021','Rimbo Besak'),
('17.05.05.2022','Muara Timput'),
('17.05.05.2023','Serian Bandung'),
('17.05.05.2024','Talang Kemang'),
('17.05.05.2025','Maras Bantan'),
('17.05.05.2026','Karang Dapo'),
('17.05.06','Air Periukan'),
('17.05.06.1006','Dermayu'),
('17.05.06.2001','Sukamaju'),
('17.05.06.2002','Talang Alai'),
('17.05.06.2003','Talang Benuang'),
('17.05.06.2004','Padang Pelasan'),
('17.05.06.2005','Air Periukan'),
('17.05.06.2007','Keban Agung'),
('17.05.06.2008','Pasar Ngalam'),
('17.05.06.2009','Sukasari'),
('17.05.06.2010','Kungkai Baru'),
('17.05.06.2011','Tawang Rejo'),
('17.05.06.2012','Lawang Agung'),
('17.05.06.2013','Taba Lubuk Puding'),
('17.05.06.2014','Talang Sebaris'),
('17.05.06.2015','Lubuk Gilang'),
('17.05.06.2016','Lokasi Baru'),
('17.05.07','Lubuk Sandi'),
('17.05.07.2001','Talang Giring'),
('17.05.07.2002','Padang Capo Ilir'),
('17.05.07.2003','Padang Capo Ulu'),
('17.05.07.2004','Talang Kebun'),
('17.05.07.2005','Gunung Agung'),
('17.05.07.2006','Cawang'),
('17.05.07.2007','Arang Sapat'),
('17.05.07.2008','Dusun Tengah'),
('17.05.07.2009','Tanjung Kuaw'),
('17.05.07.2010','Napal Jungur'),
('17.05.07.2011','Tumbu''an'),
('17.05.07.2012','Rena Panjang'),
('17.05.07.2013','Sakaian'),
('17.05.07.2014','Lubuk Terentang'),
('17.05.08','Seluma Barat'),
('17.05.08.2001','Tanjung Agung'),
('17.05.08.2002','Air Latak'),
('17.05.08.2003','Talang Perapat'),
('17.05.08.2004','Pagar Agung'),
('17.05.08.2005','Talang Tinggi'),
('17.05.08.2006','Lunjuk'),
('17.05.08.2007','Lubuk Lagan'),
('17.05.08.2008','Purbosari'),
('17.05.08.2009','Sengkuang Jaya'),
('17.05.09','Seluma Timur'),
('17.05.09.1004','Selebar'),
('17.05.09.1005','Sembayat'),
('17.05.09.1006','Bunga Mas'),
('17.05.09.2001','Talang Sali'),
('17.05.09.2002','Kunduran'),
('17.05.09.2003','Kota Agung'),
('17.05.09.2007','Tenangan'),
('17.05.09.2008','Rawa Sari'),
('17.05.10','Seluma Utara'),
('17.05.10.1003','Puguk'),
('17.05.10.2001','Talang Rami'),
('17.05.10.2002','Talang Beringin'),
('17.05.10.2004','Pandan'),
('17.05.10.2005','Selinsingan'),
('17.05.10.2006','Simpang'),
('17.05.10.2007','Sekalak'),
('17.05.10.2008','Lubuk Resam'),
('17.05.10.2009','Sinar Pagi'),
('17.05.10.2010','Talang Empat'),
('17.05.11','Seluma Selatan'),
('17.05.11.1008','Rimbo Kedui'),
('17.05.11.1010','Padang Rambun'),
('17.05.11.1011','Sido Mulyo'),
('17.05.11.2001','Sukarami'),
('17.05.11.2002','Tanjung Seru'),
('17.05.11.2003','Tanjungan'),
('17.05.11.2004','Pasar Seluma'),
('17.05.11.2005','Padang Genting'),
('17.05.11.2006','Sengkuang'),
('17.05.11.2007','Tangga Batu'),
('17.05.11.2009','Tanjung Seluai'),
('17.05.11.2012','Padang Merbau'),
('17.05.12','Talo Kecil'),
('17.05.12.2001','Pering Baru'),
('17.05.12.2002','Talang Padang'),
('17.05.12.2003','Suka Merindu'),
('17.05.12.2004','Napalan'),
('17.05.12.2005','Taba'),
('17.05.12.2006','Bakal Dalam'),
('17.05.12.2007','Lubuk Lagan'),
('17.05.12.2008','Sungai Petai'),
('17.05.12.2009','Suka Bulan'),
('17.05.12.2010','Tebat Sibun'),
('17.05.12.2011','Batu Balai'),
('17.05.13','Ulu Talo'),
('17.05.13.2001','Pagar'),
('17.05.13.2002','Muara Simpur'),
('17.05.13.2003','Pagar Agung'),
('17.05.13.2004','Pagar Banyu'),
('17.05.13.2005','Simpur Ijang'),
('17.05.13.2006','Air Keruh'),
('17.05.13.2007','Hargo Binangun'),
('17.05.13.2008','Mekar Jaya'),
('17.05.13.2009','Giri Nanto'),
('17.05.13.2010','Banyu Kencana'),
('17.05.13.2011','Muara Nibung'),
('17.05.13.2012','Tanjung Agung'),
('17.05.13.2013','Giri Mulya'),
('17.05.14','Ilir Talo'),
('17.05.14.2001','Pasar Talo'),
('17.05.14.2002','Dusun Baru'),
('17.05.14.2003','Talang Kabu'),
('17.05.14.2004','Tanah Abang'),
('17.05.14.2005','Penago Baru'),
('17.05.14.2006','Nanti Agung'),
('17.05.14.2007','Talang Panjang'),
('17.05.14.2008','Penago I'),
('17.05.14.2009','Penago II'),
('17.05.14.2010','Rawah Indah'),
('17.05.14.2011','Padang Cekur'),
('17.05.14.2012','Padang Batu'),
('17.05.14.2013','Paluah Terap'),
('17.05.14.2014','Margo Sari'),
('17.05.14.2015','Mekar Sari'),
('17.06','Kabupaten Mukomuko'),
('17.06.01','Lubuk Pinang'),
('17.06.01.2005','Suka Pindah'),
('17.06.01.2006','Lubuk Pinang'),
('17.06.01.2007','Arah Tiga'),
('17.06.01.2008','Lubuk Gedang'),
('17.06.01.2009','Tanjung Alai'),
('17.06.01.2013','Sumber Makmur'),
('17.06.01.2018','Ranah Karya'),
('17.06.02','Kota Mukomuko'),
('17.06.02.1009','Pasar Mukomuko'),
('17.06.02.1017','Koto Jaya'),
('17.06.02.1018','Bandar Ratu'),
('17.06.02.2007','Pasar Sebelah'),
('17.06.02.2008','Ujung Padang'),
('17.06.02.2010','Pondok Batu'),
('17.06.02.2011','Tanah Rekah'),
('17.06.02.2012','Selagan Jaya'),
('17.06.02.2019','Tanah Harapan'),
('17.06.03','Teras Terunjam'),
('17.06.03.2008','Teras Terunjam'),
('17.06.03.2009','Pondok Kopi'),
('17.06.03.2013','Setia Budi'),
('17.06.03.2014','Tunggal Jaya'),
('17.06.03.2024','Talang Kuning'),
('17.06.03.2025','Teruntung'),
('17.06.03.2026','Karang Jaya'),
('17.06.03.2027','Mekar Jaya'),
('17.06.04','Pondok Suguh'),
('17.06.04.2001','Air Bikuk'),
('17.06.04.2004','Tunggang'),
('17.06.04.2005','Pondok Suguh'),
('17.06.04.2006','Air Berau'),
('17.06.04.2010','Air Hitam'),
('17.06.04.2014','Pondok Kandang'),
('17.06.04.2022','Bumi Mekar Jaya'),
('17.06.04.2027','Lubuk Bento'),
('17.06.04.2029','Sinar Laut'),
('17.06.04.2030','Karya Mulya'),
('17.06.04.2031','Teluk Bakung'),
('17.06.05','Ipuh'),
('17.06.05.2004','Air Buluh'),
('17.06.05.2005','Pulau Baru'),
('17.06.05.2006','Pasar Ipuh'),
('17.06.05.2007','Medan Jaya'),
('17.06.05.2008','Sibak'),
('17.06.05.2009','Semundam'),
('17.06.05.2014','Retak Ilir'),
('17.06.05.2015','Tanjung Harapan'),
('17.06.05.2017','Tanjung Jaya'),
('17.06.05.2023','Manunggal Jaya'),
('17.06.05.2028','Pulai Payung'),
('17.06.05.2029','Tanjung Medan'),
('17.06.05.2030','Tirta Mulya'),
('17.06.05.2033','Pasar Baru'),
('17.06.05.2034','Pulau Makmur'),
('17.06.05.2035','Mundam Marap'),
('17.06.06','Malin Deman'),
('17.06.06.2001','Talang Arah'),
('17.06.06.2002','Serami Baru'),
('17.06.06.2003','Lubuk Talang'),
('17.06.06.2004','Gajah Makmur'),
('17.06.06.2005','Semambang Makmur'),
('17.06.06.2006','Talang Baru'),
('17.06.06.2007','Air Merah'),
('17.06.07','Air Rami'),
('17.06.07.2001','Arga Jaya'),
('17.06.07.2002','Air Rami'),
('17.06.07.2003','Rami Mulya'),
('17.06.07.2004','Talang Rio'),
('17.06.07.2005','Makmur Jaya'),
('17.06.07.2006','Marga Mulia'),
('17.06.07.2007','Mekar Jaya'),
('17.06.07.2008','Dusun Pulau'),
('17.06.07.2009','Bukit Harapan'),
('17.06.07.2010','Tirta Kencana'),
('17.06.07.2011','Cinta Asih'),
('17.06.07.2012','Bukit Mulya'),
('17.06.08','Teramang Jaya'),
('17.06.08.2001','Pasar Bantal'),
('17.06.08.2002','Nenggalo'),
('17.06.08.2003','Pondok Baru'),
('17.06.08.2004','Bunga Tanjung'),
('17.06.08.2005','Bandar Jaya'),
('17.06.08.2006','Teramang Jaya'),
('17.06.08.2007','Brangan Mulya'),
('17.06.08.2008','Sido Makmur'),
('17.06.08.2009','Lubuk Selandak'),
('17.06.08.2010','Nelan Indah'),
('17.06.08.2011','Mandi Angin Jaya'),
('17.06.08.2012','Batu Ejung'),
('17.06.08.2013','Pernyah'),
('17.06.09','Selagan Raya'),
('17.06.09.2001','Sungai Ipuh'),
('17.06.09.2002','Lubuk Sahung'),
('17.06.09.2003','Surian Bungkal'),
('17.06.09.2004','Sungai Gading'),
('17.06.09.2005','Pondok Baru'),
('17.06.09.2006','Sungai Jerinjing'),
('17.06.09.2007','Lubuk Bangko'),
('17.06.09.2008','Talang Buai'),
('17.06.09.2009','Aur Cina'),
('17.06.09.2010','Talang Medan'),
('17.06.09.2011','Sungai Ipuh Satu'),
('17.06.09.2012','Sungai Ipuh Dua'),
('17.06.10','Penarik'),
('17.06.10.2001','Penarik'),
('17.06.10.2002','Lubuk Mukti'),
('17.06.10.2003','Bumi Mulya'),
('17.06.10.2004','Suka Maju'),
('17.06.10.2005','Bukit Makmur'),
('17.06.10.2006','Sumber Mulya'),
('17.06.10.2007','Sido Dadi'),
('17.06.10.2008','Maju Makmur'),
('17.06.10.2009','Sendang Mulyo'),
('17.06.10.2010','Marga Mulya Sakti'),
('17.06.10.2011','Wonosobo'),
('17.06.10.2012','Mekar Mulya'),
('17.06.10.2013','Sido Mulyo'),
('17.06.10.2014','Marga Mukti'),
('17.06.11','XIV Koto'),
('17.06.11.2001','Lubuk Sanai'),
('17.06.11.2002','Rawa Mulya'),
('17.06.11.2003','Rawa Bangun'),
('17.06.11.2004','Tanjung Mulya'),
('17.06.11.2005','Pauh Terenja'),
('17.06.11.2006','Dusun Baru Pelokan'),
('17.06.11.2007','Lubuk Sanai II'),
('17.06.11.2009','Lubuk Sanai III'),
('17.06.12','V Koto'),
('17.06.12.2001','Lalang Luas'),
('17.06.12.2002','Resno'),
('17.06.12.2003','Pondok Panjang'),
('17.06.12.2004','Talang Petai'),
('17.06.12.2005','Sungai Lintang'),
('17.06.12.2006','Pondok Tengah'),
('17.06.12.2007','Talang Sakti'),
('17.06.12.2008','Talang Sepakat'),
('17.06.12.2009','Lubuk Cabau'),
('17.06.12.2010','Sungai Rengas'),
('17.06.13','Air Manjunto'),
('17.06.13.2001','Pondok Makmur'),
('17.06.13.2002','Manjunto Jaya'),
('17.06.13.2003','Tirta Makmur'),
('17.06.13.2004','Agung Jaya'),
('17.06.13.2005','Tirta Mulya'),
('17.06.13.2006','Kota Praja'),
('17.06.13.2007','Sinar Jaya'),
('17.06.13.2008','Sido Makmur'),
('17.06.14','Air Dikit'),
('17.06.14.2001','Dusun Baru V Koto'),
('17.06.14.2002','Air Dikit'),
('17.06.14.2003','Pondok Lunang'),
('17.06.14.2004','Sari Bulan'),
('17.06.14.2005','Sari Makmur'),
('17.06.14.2006','Sumber Sari'),
('17.06.14.2007','Air Kasai'),
('17.06.15','Sungai Rumbai'),
('17.06.15.2001','Retak Mudik'),
('17.06.15.2002','Padang Gading'),
('17.06.15.2003','Gajah Mati'),
('17.06.15.2004','Mekar Sari'),
('17.06.15.2005','Sido Dadi'),
('17.06.15.2006','Sumber Makmur'),
('17.06.15.2007','Talang Gading'),
('17.06.15.2008','Gading Jaya'),
('17.06.15.2009','Banjar Sari'),
('17.07','Kabupaten Lebong'),
('17.07.01','Lebong Utara'),
('17.07.01.1004','Kampung Jawa'),
('17.07.01.1006','Pasar Muara Aman'),
('17.07.01.2002','Gandung'),
('17.07.01.2005','Tunggang'),
('17.07.01.2007','Talang Ulu'),
('17.07.01.2014','Nangai Amen'),
('17.07.01.2016','Lebong Tambang'),
('17.07.01.2022','Ladang Palembang'),
('17.07.01.2023','Kampung Dalam'),
('17.07.01.2024','Kampung Muara Aman'),
('17.07.01.2028','Lokasari'),
('17.07.01.2033','Gandung Baru'),
('17.07.02','Lebong Atas'),
('17.07.02.2001','Sukau Kayo'),
('17.07.02.2004','Tik Tebing'),
('17.07.02.2005','Tabeak Blau'),
('17.07.02.2006','Tabeak Blau I'),
('17.07.02.2008','Daneu'),
('17.07.02.2012','Blau'),
('17.07.03','Lebong Tengah'),
('17.07.03.1005','Embong Panjang'),
('17.07.03.2006','Tanjung Bungai I'),
('17.07.03.2007','Semelako I'),
('17.07.03.2008','Pagar Agung'),
('17.07.03.2009','Karang Anyar'),
('17.07.03.2013','Semelako II'),
('17.07.03.2014','Semelako III'),
('17.07.03.2015','Semelako Atas'),
('17.07.03.2016','Danau Liang'),
('17.07.03.2020','Suka Damai'),
('17.07.03.2023','Tanjung Bungai II'),
('17.07.04','Lebong Selatan'),
('17.07.04.1002','Tes'),
('17.07.04.1003','Taba Anyar'),
('17.07.04.1004','Mubai'),
('17.07.04.1005','Turan Lalang'),
('17.07.04.2001','Kutai Donok'),
('17.07.04.2013','Turan Tiging'),
('17.07.04.2014','Suka Sari'),
('17.07.04.2016','Mangkurajo'),
('17.07.04.2018','Tik Jeniak'),
('17.07.04.2019','Manai Blau'),
('17.07.05','Rimbo Pengadang'),
('17.07.05.1002','Rimbo Pengadang'),
('17.07.05.2009','Talang Ratau'),
('17.07.05.2010','Bioa Sengok'),
('17.07.05.2011','Tik Kuto'),
('17.07.05.2012','Teluk Dien'),
('17.07.05.2013','Bajok'),
('17.07.06','Topos'),
('17.07.06.1001','Topos'),
('17.07.06.2002','Tik Sirong'),
('17.07.06.2003','Suka Negeri'),
('17.07.06.2004','Ajai Siang'),
('17.07.06.2005','Talang Donok'),
('17.07.06.2006','Talang Donok I'),
('17.07.06.2007','Talang Baru I'),
('17.07.06.2008','Talang Baru II'),
('17.07.07','Bingin Kuning'),
('17.07.07.2001','Karang Dapo Atas'),
('17.07.07.2002','Bukit Nibung'),
('17.07.07.2003','Karang Dapo Bawah'),
('17.07.07.2004','Pungguk Pedaro'),
('17.07.07.2005','Talang Kerinci'),
('17.07.07.2006','Pelabuhan Talang Liak'),
('17.07.07.2007','Talang Liak I'),
('17.07.07.2008','Talang Liak II'),
('17.07.07.2009','Bungin'),
('17.07.08','Lebong Sakti'),
('17.07.08.2001','Ujung Tanjung I'),
('17.07.08.2002','Muning Agung'),
('17.07.08.2003','Ujung Tanjung II'),
('17.07.08.2004','Ujung Tanjung III'),
('17.07.08.2005','Magelang Baru'),
('17.07.08.2006','Lemeu Pit'),
('17.07.08.2007','Tabeak Kauk'),
('17.07.08.2008','Tabeak Dipoa'),
('17.07.08.2009','Suka Bumi'),
('17.07.09','Tubei'),
('17.07.09.1001','Tanjung Agung'),
('17.07.09.2002','Sukau Datang'),
('17.07.09.2003','Sukau Datang I'),
('17.07.09.2004','Gunung Alam'),
('17.07.09.2005','Tabeak Blau II'),
('17.07.09.2006','Kota Baru Santan'),
('17.07.09.2007','Tik Teleu'),
('17.07.09.2008','Pelabai'),
('17.07.10','Amen'),
('17.07.10.1009','Amen'),
('17.07.10.2001','Nangai Tayau'),
('17.07.10.2002','Nangai Tayau I'),
('17.07.10.2003','Pyang Mbik'),
('17.07.10.2004','Sukau Mergo'),
('17.07.10.2005','Sukau Rajo'),
('17.07.10.2006','Talang Bunut'),
('17.07.10.2007','Selebar Jaya'),
('17.07.10.2008','Garut'),
('17.07.10.2010','Sungai Gerong'),
('17.07.11','Uram Jaya'),
('17.07.11.2001','Embong'),
('17.07.11.2002','Embong I'),
('17.07.11.2003','Kota Baru'),
('17.07.11.2004','Kota Agung'),
('17.07.11.2005','Lemeu'),
('17.07.11.2006','Pangkalan'),
('17.07.11.2007','Tangua'),
('17.07.12','Pinang Belapis'),
('17.07.12.2001','Ketenong I'),
('17.07.12.2002','Ketenong II'),
('17.07.12.2003','Ketenong Jaya'),
('17.07.12.2004','Tambang Saweak'),
('17.07.12.2005','Air Kopras'),
('17.07.12.2006','Bioa Putiak'),
('17.07.12.2007','Sebelat'),
('17.07.12.2008','Sungai Lisai'),
('17.08','Kabupaten Kepahiang'),
('17.08.01','Bermani Ilir'),
('17.08.01.1007','Keban Agung'),
('17.08.01.2001','Kota Agung'),
('17.08.01.2002','Kembang Seri'),
('17.08.01.2003','Pagar Agung'),
('17.08.01.2004','Embong Ijuk'),
('17.08.01.2005','Gunung Agung'),
('17.08.01.2006','Talang Pito'),
('17.08.01.2008','Cinto Mandi'),
('17.08.01.2009','Lembur Lama'),
('17.08.01.2010','Taba Baru'),
('17.08.01.2011','Bukit Menyan'),
('17.08.01.2016','Batu Belarik'),
('17.08.01.2017','Embong Sido'),
('17.08.01.2022','Talang Sawah'),
('17.08.01.2023','Sosokan Cinta Mandi'),
('17.08.01.2024','Muara Langkap'),
('17.08.01.2025','Air Raman'),
('17.08.01.2028','Langgar Jaya'),
('17.08.01.2029','Cinta Mandi Baru'),
('17.08.02','Ujan Mas'),
('17.08.02.1002','Ujan Mas Atas'),
('17.08.02.2001','Daspeta'),
('17.08.02.2003','Suro Lembak'),
('17.08.02.2004','Tanjung Alam'),
('17.08.02.2005','Suro Ilir'),
('17.08.02.2006','Suro Muncar'),
('17.08.02.2007','Suro Baru'),
('17.08.02.2008','Pekalongan'),
('17.08.02.2009','Bumi Sari'),
('17.08.02.2016','Cugung Lalang'),
('17.08.02.2017','Ujan Mas Bawah'),
('17.08.02.2018','Suro Bali'),
('17.08.02.2019','Pungguk Meranti'),
('17.08.02.2020','Pungguk Meringang'),
('17.08.02.2021','Meranti Jaya'),
('17.08.02.2023','Air Hitam'),
('17.08.02.2024','Daspetah II'),
('17.08.03','Tebat Karai'),
('17.08.03.1008','Tebat Karai'),
('17.08.03.2006','Taba Santing'),
('17.08.03.2007','Tertik'),
('17.08.03.2009','Talang Karet'),
('17.08.03.2010','Peraduan Binjai'),
('17.08.03.2011','Penanjung Panjang'),
('17.08.03.2012','Nanti Agung'),
('17.08.03.2013','Taba Air Pauh'),
('17.08.03.2014','Karang Tengah'),
('17.08.03.2019','Tapak Gedung'),
('17.08.03.2020','Tebing Penyamun'),
('17.08.03.2021','Sinar Gunung'),
('17.08.03.2022','Taba Saling'),
('17.08.03.2023','Penanjung Panjang Atas'),
('17.08.04','Kepahiang'),
('17.08.04.1003','Pensiunan'),
('17.08.04.1004','Pasar Kepahiangan'),
('17.08.04.1005','Pasar Ujung'),
('17.08.04.1011','Dusun Kepahiang'),
('17.08.04.1025','Kampung Pensiunan'),
('17.08.04.1026','Pasar Sejantung'),
('17.08.04.1027','Padang Lekat'),
('17.08.04.2001','Kelilik'),
('17.08.04.2002','Tebat Monok'),
('17.08.04.2006','Permu'),
('17.08.04.2007','Imigrasi Permu'),
('17.08.04.2008','Karang Endah'),
('17.08.04.2009','Westkust'),
('17.08.04.2010','Kampung Bogor'),
('17.08.04.2012','Kuto Rejo'),
('17.08.04.2013','Karang Anyar'),
('17.08.04.2014','Taba Tebelet'),
('17.08.04.2015','Pelangkian'),
('17.08.04.2016','Kelobak'),
('17.08.04.2017','Pagar Gunung'),
('17.08.04.2023','Sukamerindu'),
('17.08.04.2028','Bogor Baru'),
('17.08.04.2029','Permu bawah'),
('17.08.05','Merigi'),
('17.08.05.1002','Durian Depun'),
('17.08.05.2001','Pulo Geto'),
('17.08.05.2003','Taba Mulan'),
('17.08.05.2004','Lubuk Penyamun'),
('17.08.05.2005','SP. Kota Bingin'),
('17.08.05.2006','Bukit Barisan'),
('17.08.05.2007','Batu Ampar'),
('17.08.05.2008','Pulo Geto Baru'),
('17.08.06','Kebawetan'),
('17.08.06.1005','Tangsi Baru'),
('17.08.06.2001','Bandung Baru'),
('17.08.06.2002','Bukit Sari'),
('17.08.06.2003','Tugu Rejo'),
('17.08.06.2004','Suka Sari'),
('17.08.06.2006','Air Sempiang'),
('17.08.06.2007','Tangsi Duren'),
('17.08.06.2008','Babakan Bogor'),
('17.08.06.2009','Barat Wetan'),
('17.08.06.2010','Pematang Donok'),
('17.08.06.2011','Sumber Sari'),
('17.08.06.2012','Mekar Sari'),
('17.08.06.2013','Sido Makmur'),
('17.08.06.2014','Sido Rejo'),
('17.08.06.2015','Bandung Jaya'),
('17.08.07','Seberang Musi'),
('17.08.07.2001','Benuang Galing'),
('17.08.07.2002','Air Selimang'),
('17.08.07.2003','Tebat Laut'),
('17.08.07.2004','Temdak'),
('17.08.07.2005','Taba Padang'),
('17.08.07.2006','Lubuk Saung'),
('17.08.07.2007','Kandang'),
('17.08.07.2008','Cirebon Baru'),
('17.08.07.2009','Talang Gelompok'),
('17.08.07.2010','Air Pesi'),
('17.08.07.2011','Talang Babatan'),
('17.08.07.2012','Bayung'),
('17.08.07.2013','Sungai Jernih'),
('17.08.08','Muara Kemumu'),
('17.08.08.2001','Limbur Baru'),
('17.08.08.2002','Batu Kalung'),
('17.08.08.2003','Batu Bandung'),
('17.08.08.2004','Sosokan Baru'),
('17.08.08.2005','Sosokan Taba'),
('17.08.08.2006','Talang Tige'),
('17.08.08.2007','Renah Kurung'),
('17.08.08.2008','Warung Pojok'),
('17.09','Kabupaten Bengkulu Tengah'),
('17.09.01','Karang Tinggi'),
('17.09.01.2001','Taba Terunjam'),
('17.09.01.2002','Talang Empat'),
('17.09.01.2003','Padang Tambak'),
('17.09.01.2004','Durian Demang'),
('17.09.01.2005','Pelajau'),
('17.09.01.2007','Dusun Baru II'),
('17.09.01.2008','Penanding'),
('17.09.01.2009','Karang Tinggi'),
('17.09.01.2010','Renah Lebar'),
('17.09.01.2011','Kancing'),
('17.09.01.2012','Ujung Karang'),
('17.09.01.2013','Taba Mutung'),
('17.09.01.2015','Renah Semanek'),
('17.09.02','Talang Empat'),
('17.09.02.2001','Air Sebakul'),
('17.09.02.2004','Taba Pasmah'),
('17.09.02.2005','Kembang Seri'),
('17.09.02.2006','Tengah Padang'),
('17.09.02.2007','Jayakarta'),
('17.09.02.2008','Nakau'),
('17.09.02.2009','Pulau Panggung'),
('17.09.02.2014','Jum''at'),
('17.09.02.2015','Padang Ulak Tanjung'),
('17.09.02.2017','Air Putih'),
('17.09.03','Pondok Kelapa'),
('17.09.03.2009','Talang Pauh'),
('17.09.03.2010','Srikaton'),
('17.09.03.2011','Pekik Nyaring'),
('17.09.03.2012','Pasar Pedati'),
('17.09.03.2013','Sunda Kelapa'),
('17.09.03.2014','Pondok Kelapa'),
('17.09.03.2015','Padang Betuah'),
('17.09.03.2016','Sidorejo'),
('17.09.03.2017','Sidodadi'),
('17.09.03.2018','Talang Boseng'),
('17.09.03.2019','Pagar Dewa'),
('17.09.03.2020','Kembang Ayun'),
('17.09.03.2021','Panca Mukti'),
('17.09.03.2022','Sri Kuncoro'),
('17.09.03.2023','Bintang Selatan'),
('17.09.03.2024','Abu Sakim'),
('17.09.03.2025','Harapan'),
('17.09.04','Pematang Tiga'),
('17.09.04.2002','Aturan Mumpo'),
('17.09.04.2003','Talang Tengah II'),
('17.09.04.2004','Kota Titik'),
('17.09.04.2007','Senabah'),
('17.09.04.2015','Air Kotok'),
('17.09.04.2016','Batu Beriang'),
('17.09.04.2017','Pematang Tiga'),
('17.09.04.2018','Tiambang'),
('17.09.04.2019','Kebun Lebar'),
('17.09.04.2020','Tanjung Kepahyang'),
('17.09.04.2021','Pematang Tiga Lama'),
('17.09.04.2022','Aturan Mumpo II'),
('17.09.04.2023','Genting Dabuk'),
('17.09.05','Pagar Jati'),
('17.09.05.2006','Temiang'),
('17.09.05.2008','Taba Renah'),
('17.09.05.2009','Kerta Pati'),
('17.09.05.2010','Pagar Jati'),
('17.09.05.2012','Karang Are'),
('17.09.05.2013','Datar Penokat'),
('17.09.05.2014','Layang Lekat'),
('17.09.05.2015','Tumbuk'),
('17.09.05.2016','Talang Curup'),
('17.09.05.2017','Rena Kandis'),
('17.09.05.2018','Arga Indah I'),
('17.09.05.2022','Keroya'),
('17.09.05.2023','Kertapati Mudik'),
('17.09.05.2024','Rena Jaya'),
('17.09.06','Taba Penanjung'),
('17.09.06.1007','Taba Penanjung'),
('17.09.06.2002','Tanjung Raman'),
('17.09.06.2003','Sukarami'),
('17.09.06.2004','Karang Tengah'),
('17.09.06.2005','Lubuk Sini'),
('17.09.06.2008','Taba Teret'),
('17.09.06.2009','Surau'),
('17.09.06.2010','Rindu Hati'),
('17.09.06.2011','Tanjung Heran'),
('17.09.06.2012','Datar Lebar'),
('17.09.06.2013','Penum'),
('17.09.06.2023','Bajak I'),
('17.09.06.2024','Taba Baru'),
('17.09.07','Merigi Kelindang'),
('17.09.07.2001','Jambu'),
('17.09.07.2002','Penembang'),
('17.09.07.2003','Talang Ambung'),
('17.09.07.2004','Taba Durian Sebakul'),
('17.09.07.2005','Lubuk Unen'),
('17.09.07.2006','Pungguk Ketupak'),
('17.09.07.2007','Pungguk Beringin'),
('17.09.07.2008','Ulak Lebar'),
('17.09.07.2009','Kelindang'),
('17.09.07.2010','Bajak II'),
('17.09.07.2011','Lubuk Unen Baru'),
('17.09.07.2012','Padang Kedeper'),
('17.09.07.2013','Kelindang Atas'),
('17.09.08','Merigi Sakti'),
('17.09.08.2001','Komering'),
('17.09.08.2002','Bajak Tiga'),
('17.09.08.2003','Rajak Besi'),
('17.09.08.2004','Punjung'),
('17.09.08.2005','Susup'),
('17.09.08.2006','Arga Indah II'),
('17.09.08.2007','Curup'),
('17.09.08.2008','Karang Panggung'),
('17.09.08.2009','Lubuk Pendam'),
('17.09.08.2010','Lubuk Puar'),
('17.09.08.2011','Durian Lebar'),
('17.09.08.2012','Pagar Agung'),
('17.09.08.2013','Pungguk Jaya'),
('17.09.08.2014','Taba Gemantung'),
('17.09.08.2015','Pagar Besi'),
('17.09.09','Pondok Kubang'),
('17.09.09.2001','Pondok Kubang'),
('17.09.09.2002','Batu Raja'),
('17.09.09.2003','Dusun Anyar'),
('17.09.09.2004','Tanjung Dalam'),
('17.09.09.2005','Talang Tengah I'),
('17.09.09.2006','Paku Haji'),
('17.09.09.2007','Tanjung Terdana'),
('17.09.09.2008','Linggar Galing'),
('17.09.09.2009','Dusun Baru I'),
('17.09.09.2010','Harapan Makmur'),
('17.09.09.2011','Margo Mulyo'),
('17.09.09.2012','Taba Jambu'),
('17.09.10','Bang Haji'),
('17.09.10.2001','Sekayun'),
('17.09.10.2002','Sekayun Mudik'),
('17.09.10.2003','Sekayun Hilir'),
('17.09.10.2004','Talang Donok'),
('17.09.10.2005','Taba Tengah'),
('17.09.10.2006','Padang Berunai'),
('17.09.10.2007','Lubuk Langkap'),
('17.09.10.2008','Air Napal'),
('17.09.10.2009','Genting'),
('17.09.10.2010','Talang Panjang'),
('17.09.10.2011','Bang Haji'),
('17.09.10.2012','Sungkai Berayun'),
('17.09.11','Semidang Lagan'),
('17.09.11.2001','Pagar Gunung'),
('17.09.11.2002','Karang Nanding'),
('17.09.11.2003','Semidang'),
('17.09.11.2004','Gajah Mati'),
('17.09.11.2005','Padang Siring'),
('17.09.11.2006','Lagan Bungin'),
('17.09.11.2007','Pagar Jati'),
('17.09.11.2008','Taba Lagan'),
('17.09.11.2009','Lagan'),
('17.09.11.2010','Bukit'),
('17.09.11.2011','Kota Niur'),
('17.71','Kota Bengkulu'),
('17.71.01','Selebar'),
('17.71.01.1001','Pagar Dewa'),
('17.71.01.1002','Sukarami'),
('17.71.01.1003','Pekan Sabtu'),
('17.71.01.1004','Bumu Ayu'),
('17.71.01.1005','Betungan'),
('17.71.01.1006','Sumur Dewa'),
('17.71.02','Gading Cempaka'),
('17.71.02.1001','Padang Harapan'),
('17.71.02.1002','Jalan Gedang'),
('17.71.02.1021','Sidomulyo'),
('17.71.02.1024','Lingkar Barat'),
('17.71.02.1027','Cempaka Permai'),
('17.71.03','Teluk Segara'),
('17.71.03.1001','Berkas'),
('17.71.03.1002','Pasar Baru'),
('17.71.03.1003','Jitra'),
('17.71.03.1004','Pasar Melintang'),
('17.71.03.1005','Kebun Roos'),
('17.71.03.1007','Tengah Padang'),
('17.71.03.1008','Bajak'),
('17.71.03.1010','Pondok Besi'),
('17.71.03.1011','Kebun Keling'),
('17.71.03.1013','Sumur Meleleh'),
('17.71.03.1014','Malabero'),
('17.71.03.1018','Pintu Batu'),
('17.71.03.1019','Kampung Bali'),
('17.71.04','Muara Bangka Hulu'),
('17.71.04.1001','Kandang Limun'),
('17.71.04.1002','Bentiring'),
('17.71.04.1003','Pematang Gubernur'),
('17.71.04.1004','Rawa Makmur'),
('17.71.04.1005','Beringin Raya'),
('17.71.04.1006','Bentiring Permai'),
('17.71.04.1007','Rawa Makmur Permai'),
('17.71.05','Kampung Melayu'),
('17.71.05.1001','Kandang'),
('17.71.05.1002','Kandang Mas'),
('17.71.05.1003','Teluk Sepang'),
('17.71.05.1004','Sumber Jaya'),
('17.71.05.1005','Padang Serai'),
('17.71.05.1006','Muara Dua'),
('17.71.06','Ratu Agung'),
('17.71.06.1001','Kebun Tebeng'),
('17.71.06.1002','Tanah Patah'),
('17.71.06.1003','Nusa Indah'),
('17.71.06.1004','Kebun Beler'),
('17.71.06.1005','Kebun Kenanga'),
('17.71.06.1006','Sawah Lebar'),
('17.71.06.1007','Sawah Lebar Baru'),
('17.71.06.1008','Lempuing'),
('17.71.07','Ratu Samban'),
('17.71.07.1001','Padang Jati'),
('17.71.07.1002','Kebun Dahri'),
('17.71.07.1003','Belakang Pondok'),
('17.71.07.1004','Penurunan'),
('17.71.07.1005','Anggut Bawah'),
('17.71.07.1006','Anggut Atas'),
('17.71.07.1007','Anggut Dalam'),
('17.71.07.1008','Kebun Geran'),
('17.71.07.1009','Pengantungan'),
('17.71.08','Sungai Serut'),
('17.71.08.1001','Kampung Kelawi'),
('17.71.08.1002','Sukamerindu'),
('17.71.08.1003','Semarang'),
('17.71.08.1004','Tanjung Agung'),
('17.71.08.1005','Tanjung Jaya'),
('17.71.08.1006','Surabaya'),
('17.71.08.1007','Pasar Bengkulu'),
('17.71.09','Singaran Pati'),
('17.71.09.1001','Panorama'),
('17.71.09.1002','Jembatan Kecil'),
('17.71.09.1003','Dusun Besar'),
('17.71.09.1004','Padang Nangka'),
('17.71.09.1005','Timur Indah'),
('17.71.09.1006','Lingkar Timur');

-- Provinsi LAMPUNG
INSERT INTO wilayah (kode, nama)
VALUES
('18','Lampung'),
('18.01','Kabupaten Lampung Selatan'),
('18.01.04','Natar'),
('18.01.04.2001','Hajimena'),
('18.01.04.2002','Sidosari'),
('18.01.04.2003','Pemanggilan'),
('18.01.04.2004','Natar'),
('18.01.04.2005','Muara Putih'),
('18.01.04.2006','Negara Ratu'),
('18.01.04.2007','Merak Batin'),
('18.01.04.2008','Tanjung Sari'),
('18.01.04.2009','Bumi Sari'),
('18.01.04.2010','Candi Mas'),
('18.01.04.2011','Branti Raya'),
('18.01.04.2012','Haduyang'),
('18.01.04.2013','Banjar Negeri'),
('18.01.04.2014','Mandah'),
('18.01.04.2015','Rulung Helok'),
('18.01.04.2016','Bandarejo'),
('18.01.04.2017','Suka Damai'),
('18.01.04.2018','Purwosari'),
('18.01.04.2019','Pancasila'),
('18.01.04.2020','Rejosari'),
('18.01.04.2021','Rulung Raya'),
('18.01.04.2022','Krawang Sari'),
('18.01.04.2023','Wai Sari'),
('18.01.04.2024','Kali Sari'),
('18.01.04.2025','Rulung Sari'),
('18.01.04.2026','Rulung Mulya'),
('18.01.05','Tanjung Bintang'),
('18.01.05.2001','Kaliasin'),
('18.01.05.2003','Lematang'),
('18.01.05.2004','Sukanegara'),
('18.01.05.2005','Serdang'),
('18.01.05.2006','Sinar Ogan'),
('18.01.05.2007','Jati Baru'),
('18.01.05.2008','Sabah Balau'),
('18.01.05.2009','Budi Lestari'),
('18.01.05.2010','Trimulyo'),
('18.01.05.2011','Jati Indah'),
('18.01.05.2012','Way Galih'),
('18.01.05.2013','Sindang Sari'),
('18.01.05.2015','Purwodadi Simpang'),
('18.01.05.2021','Galih Lunik'),
('18.01.05.2022','Rejomulyo'),
('18.01.05.2023','Sri Katon'),
('18.01.06','Kalianda'),
('18.01.06.1006','Bumi Agung'),
('18.01.06.1007','Kalianda'),
('18.01.06.1008','Way Urang'),
('18.01.06.1028','Wai Lubuk'),
('18.01.06.2001','Jondong'),
('18.01.06.2002','Tengkujuh'),
('18.01.06.2003','Pauh Tanjung Iman'),
('18.01.06.2004','Sumur Kumbang'),
('18.01.06.2005','Maja'),
('18.01.06.2009','Buah Berak'),
('18.01.06.2010','Kesugihan'),
('18.01.06.2011','Pematang'),
('18.01.06.2012','Kecapi'),
('18.01.06.2013','Babulang'),
('18.01.06.2014','Sukaratu'),
('18.01.06.2015','Palembapang'),
('18.01.06.2016','Tajimalela'),
('18.01.06.2017','Canggu'),
('18.01.06.2018','Kedaton'),
('18.01.06.2019','Merak Belatung'),
('18.01.06.2020','Bulok'),
('18.01.06.2021','Munjuk Sampurna'),
('18.01.06.2022','Gunung Terang'),
('18.01.06.2023','Margacatur'),
('18.01.06.2024','Sukatani'),
('18.01.06.2025','Agom'),
('18.01.06.2026','Negeri Pandan'),
('18.01.06.2027','Taman Agung'),
('18.01.06.2029','Hara Banjar Manis'),
('18.01.07','Sidomulyo'),
('18.01.07.2001','Bandar Dalam'),
('18.01.07.2002','Campang Tiga'),
('18.01.07.2003','Talang Baru'),
('18.01.07.2004','Suka Banjar'),
('18.01.07.2005','Kota Dalam'),
('18.01.07.2006','Budidaya'),
('18.01.07.2007','Siring Jaha'),
('18.01.07.2008','Suak'),
('18.01.07.2009','Sukamaju'),
('18.01.07.2010','Sukamarga'),
('18.01.07.2011','Seloretno'),
('18.01.07.2012','Sidodadi'),
('18.01.07.2013','Sidorejo'),
('18.01.07.2014','Sidomulyo'),
('18.01.07.2015','Sidowaluyo'),
('18.01.07.2020','Banjar Suri'),
('18.01.08','Katibung'),
('18.01.08.2001','Tarahan'),
('18.01.08.2002','Babatan'),
('18.01.08.2003','Pardasuka'),
('18.01.08.2004','Sukajaya'),
('18.01.08.2005','Tanjung Ratu'),
('18.01.08.2006','Tanjung Agung'),
('18.01.08.2007','Tanjungan'),
('18.01.08.2008','Trans Tanjungan'),
('18.01.08.2009','Neglasari'),
('18.01.08.2018','Karya Tunggal'),
('18.01.08.2019','Rangai Tri Tunggal'),
('18.01.08.2020','Sidomekar'),
('18.01.09','Penengahan'),
('18.01.09.2001','Kekiling'),
('18.01.09.2002','Belambangan'),
('18.01.09.2003','Rawi'),
('18.01.09.2004','Padan'),
('18.01.09.2005','Kuripan'),
('18.01.09.2006','Taman Baru'),
('18.01.09.2007','Kelau'),
('18.01.09.2008','Ruang Tengah'),
('18.01.09.2009','Pasuruan'),
('18.01.09.2010','Klaten'),
('18.01.09.2011','Kampung Baru'),
('18.01.09.2012','Banjar Masin'),
('18.01.09.2013','Way Kalam'),
('18.01.09.2014','Gedung Harta'),
('18.01.09.2015','Gayam'),
('18.01.09.2016','Penengahan'),
('18.01.09.2017','Sukajaya'),
('18.01.09.2018','Tetaan'),
('18.01.09.2019','Suka Baru'),
('18.01.09.2020','Pisang'),
('18.01.09.2021','Tanjung Heran'),
('18.01.09.2026','Gandri'),
('18.01.10','Palas'),
('18.01.10.2001','Sukaraja'),
('18.01.10.2002','Sukabakti'),
('18.01.10.2003','Sukamulya'),
('18.01.10.2004','Tanjung Sari'),
('18.01.10.2005','Bangunan'),
('18.01.10.2006','Rejo Mulyo'),
('18.01.10.2007','Palas Aji'),
('18.01.10.2008','Palas Pasemah'),
('18.01.10.2009','Palas Jaya'),
('18.01.10.2010','Bandan Hurip'),
('18.01.10.2011','Pulau Tengah'),
('18.01.10.2012','Bali Agung'),
('18.01.10.2013','Bumi Daya'),
('18.01.10.2014','Tanjung Jaya'),
('18.01.10.2015','Bumi Restu'),
('18.01.10.2016','Pematang Baru'),
('18.01.10.2017','Mekar Mulya'),
('18.01.10.2018','Bumi Asih'),
('18.01.10.2019','Kalirejo'),
('18.01.10.2020','Bumi Asri'),
('18.01.10.2021','Pulau Jaya'),
('18.01.13','Jati Agung'),
('18.01.13.2001','Way Hui'),
('18.01.13.2002','Sidodadi Asri'),
('18.01.13.2003','Margo Mulyo'),
('18.01.13.2004','Gedung Agung'),
('18.01.13.2005','Margodadi'),
('18.01.13.2006','Gedung Harapan'),
('18.01.13.2007','Marga Agung'),
('18.01.13.2008','Jati Mulyo'),
('18.01.13.2009','Fajar Baru'),
('18.01.13.2010','Karang Anyar'),
('18.01.13.2011','Marga Kaya'),
('18.01.13.2012','Margo Lestari'),
('18.01.13.2013','Sumber Jaya'),
('18.01.13.2014','Sinar Rejeki'),
('18.01.13.2015','Sidoharjo'),
('18.01.13.2016','Rejomulyo'),
('18.01.13.2017','Purwotani'),
('18.01.13.2018','Banjar Agung'),
('18.01.13.2019','Karang Sari'),
('18.01.13.2020','Karang Rejo'),
('18.01.13.2021','Margorejo'),
('18.01.14','Ketapang'),
('18.01.14.2001','Bangunrejo'),
('18.01.14.2002','Sripendowo'),
('18.01.14.2003','Karang Sari'),
('18.01.14.2004','Ketapang'),
('18.01.14.2005','Legundi'),
('18.01.14.2006','Tri Dharma Yoga'),
('18.01.14.2007','Ruguk'),
('18.01.14.2008','Sumur'),
('18.01.14.2009','Sumber Nadi'),
('18.01.14.2010','Sidoasih'),
('18.01.14.2011','Pematang Pasir'),
('18.01.14.2012','Berundung'),
('18.01.14.2013','Taman Sari'),
('18.01.14.2014','Kemukus'),
('18.01.14.2015','Lebung Nala'),
('18.01.14.2016','Sidoluhur'),
('18.01.14.2017','Wai Sidomukti'),
('18.01.15','Sragi'),
('18.01.15.2001','Kuala Sekampung'),
('18.01.15.2002','Baktirasa'),
('18.01.15.2003','Mandala Sari'),
('18.01.15.2004','Sukapura'),
('18.01.15.2005','Sumber Agung'),
('18.01.15.2006','Marga Jasa'),
('18.01.15.2007','Sumber Sari'),
('18.01.15.2008','Bandar Agung'),
('18.01.15.2009','Kedaung'),
('18.01.15.2010','Margasari'),
('18.01.16','Raja Basa'),
('18.01.16.2001','Banding'),
('18.01.16.2002','Betung'),
('18.01.16.2003','Batu Balak'),
('18.01.16.2004','Canti'),
('18.01.16.2005','Canggung'),
('18.01.16.2006','Cugung'),
('18.01.16.2007','Hargo Pancuran'),
('18.01.16.2008','Kerinjing'),
('18.01.16.2009','Kunjir'),
('18.01.16.2010','Kota Guring'),
('18.01.16.2011','Rajabasa'),
('18.01.16.2012','Sukaraja'),
('18.01.16.2013','Tanjung Gading'),
('18.01.16.2014','Tejang Pulau Sebesi'),
('18.01.16.2015','Way Muli'),
('18.01.16.2016','Wai Muli Timur'),
('18.01.17','Candipuro'),
('18.01.17.2001','Batuliman Indah'),
('18.01.17.2002','Sinar Palembang'),
('18.01.17.2003','Rantau Minyak'),
('18.01.17.2004','Sido Asri'),
('18.01.17.2005','Way Gelam'),
('18.01.17.2006','Cinta Mulya'),
('18.01.17.2007','Banyumas'),
('18.01.17.2008','Beringin Kencana'),
('18.01.17.2009','Sinar Pasemah'),
('18.01.17.2010','Rawa Selapan'),
('18.01.17.2011','Bumi Jaya'),
('18.01.17.2012','Trimomukti'),
('18.01.17.2013','Titiwangi'),
('18.01.17.2014','Karya Mulya Sari'),
('18.01.18','Merbau Mataram'),
('18.01.18.2001','Merbau Mataram'),
('18.01.18.2002','Suban'),
('18.01.18.2003','Tanjung Baru'),
('18.01.18.2004','Baru Ranji'),
('18.01.18.2005','Karang Raja'),
('18.01.18.2006','Talang Jawa'),
('18.01.18.2007','Lebung Sari'),
('18.01.18.2008','Puji Rahayu'),
('18.01.18.2009','Batu Agung'),
('18.01.18.2010','Tanjung Harapan'),
('18.01.18.2011','Sinar Karya'),
('18.01.18.2012','Triharjo'),
('18.01.18.2013','Panca Tunggal'),
('18.01.18.2014','Mekar Jaya'),
('18.01.18.2015','Karang Jaya'),
('18.01.21','Bakauheni'),
('18.01.21.2001','Semanak'),
('18.01.21.2002','Toto Harjo'),
('18.01.21.2003','Hatta'),
('18.01.21.2004','Bakauheni'),
('18.01.21.2005','Kelawi'),
('18.01.22','Tanjung Sari'),
('18.01.22.2001','Bangun Sari'),
('18.01.22.2002','Purwodadi Dalam'),
('18.01.22.2003','Sidomukti'),
('18.01.22.2004','Wawasan'),
('18.01.22.2005','Mulyosari'),
('18.01.22.2006','Wonodadi'),
('18.01.22.2007','Kertosari'),
('18.01.22.2008','Malangsari'),
('18.01.23','Way Sulan'),
('18.01.23.2001','Mekar Sari'),
('18.01.23.2002','Sumber Agung'),
('18.01.23.2003','Talang Way Sulan'),
('18.01.23.2004','Pamulihan'),
('18.01.23.2005','Purwodadi'),
('18.01.23.2006','Sukamaju'),
('18.01.23.2007','Banjarsari'),
('18.01.23.2008','Karang Pucung'),
('18.01.24','Way Panji'),
('18.01.24.2001','Sidoharjo'),
('18.01.24.2002','Sidomakmur'),
('18.01.24.2003','Sidoreno'),
('18.01.24.2004','Bali Nuraga'),
('18.02','Kabupaten Lampung Tengah'),
('18.02.01','Kalirejo'),
('18.02.01.2001','Sri Way Langsep'),
('18.02.01.2002','Wayakrui'),
('18.02.01.2003','Kalirejo'),
('18.02.01.2004','Balai Rejo'),
('18.02.01.2005','Watu Agung'),
('18.02.01.2006','Sri Basuki'),
('18.02.01.2007','Kaliwungu'),
('18.02.01.2008','Kali Dadi'),
('18.02.01.2009','Sri Mulyo'),
('18.02.01.2010','Sri Dadi'),
('18.02.01.2011','Suko Sari'),
('18.02.01.2012','Sinar Sari'),
('18.02.01.2013','Ponco Warno'),
('18.02.01.2014','Sri Purnomo'),
('18.02.01.2015','Sinar Rejo'),
('18.02.01.2016','Agung Timur'),
('18.02.01.2017','Kalisari'),
('18.02.02','Bangun Rejo'),
('18.02.02.2001','Purwodadi'),
('18.02.02.2002','Sido Dadi'),
('18.02.02.2003','Sido Rejo'),
('18.02.02.2004','Cimarias'),
('18.02.02.2005','Bangun Rejo'),
('18.02.02.2006','Sido Luhur'),
('18.02.02.2007','Sido Mulyo'),
('18.02.02.2008','Timbul Rejo'),
('18.02.02.2009','Suka Negara'),
('18.02.02.2010','Sinar Seputih'),
('18.02.02.2011','Sinar Luas'),
('18.02.02.2012','Tanjung Pandan'),
('18.02.02.2013','Tanjung Jaya'),
('18.02.02.2014','Sri Pendowo'),
('18.02.02.2015','Sukowaringin'),
('18.02.02.2016','Mekar Jaya'),
('18.02.02.2017','Suka Negeri'),
('18.02.03','Padang Ratu'),
('18.02.03.2001','Purwosari'),
('18.02.03.2002','Sendang Ayu'),
('18.02.03.2003','Bandar Sari'),
('18.02.03.2004','Surabaya'),
('18.02.03.2005','Margorejo'),
('18.02.03.2006','Kota Baru'),
('18.02.03.2007','Karang Tanjung'),
('18.02.03.2008','Kuripan'),
('18.02.03.2009','Sri Agung'),
('18.02.03.2010','Haduyang Ratu'),
('18.02.03.2011','Padang Ratu'),
('18.02.03.2018','Karang Sari'),
('18.02.03.2019','Mojokerto'),
('18.02.03.2020','Sumber Sari'),
('18.02.03.2021','Purworejo'),
('18.02.04','Gunung Sugih'),
('18.02.04.1005','Gunung Sugih'),
('18.02.04.1006','Gunung S. Raya'),
('18.02.04.1007','Komering Agung'),
('18.02.04.1008','Seputih Jaya'),
('18.02.04.2001','Terbanggi Subing'),
('18.02.04.2002','Terbanggi Agung'),
('18.02.04.2003','Fajar Bulan'),
('18.02.04.2004','Komering Putih'),
('18.02.04.2009','Buyut Udik'),
('18.02.04.2010','Buyut Ilir'),
('18.02.04.2011','Bangun Rejo'),
('18.02.04.2012','Wono Sari'),
('18.02.04.2013','Putra Buyut'),
('18.02.04.2014','Gunung Sari'),
('18.02.04.2015','Buyut Utara'),
('18.02.05','Trimurjo'),
('18.02.05.1003','Adi Puro'),
('18.02.05.1004','Trimurjo'),
('18.02.05.1007','Simbar Waringin'),
('18.02.05.2001','Depok Rejo'),
('18.02.05.2002','Liman Benawi'),
('18.02.05.2005','Noto Harjo'),
('18.02.05.2006','Purwodadi'),
('18.02.05.2008','Tempuran'),
('18.02.05.2009','Purwo Adi'),
('18.02.05.2010','Pujo Dadi'),
('18.02.05.2011','Pujo Kerto'),
('18.02.05.2012','Untoro'),
('18.02.05.2013','Pujo Asri'),
('18.02.05.2014','Pujo Basuki'),
('18.02.06','Punggur'),
('18.02.06.2001','Nunggal Rejo'),
('18.02.06.2002','Badran Sari'),
('18.02.06.2003','Sri Sawahan'),
('18.02.06.2004','Toto Katon'),
('18.02.06.2005','Tanggul Angin'),
('18.02.06.2006','Ngesti Rahayu'),
('18.02.06.2007','Mojopahit'),
('18.02.06.2008','Asto Mulyo'),
('18.02.06.2009','Sido Mulyo'),
('18.02.07','Terbanggi Besar'),
('18.02.07.1002','Bandar Jaya Timur'),
('18.02.07.1003','Bandar Jaya Barat'),
('18.02.07.1004','Yukum Jaya'),
('18.02.07.2001','Adi Jaya'),
('18.02.07.2005','Indra Putra Subing'),
('18.02.07.2006','Karang Endah'),
('18.02.07.2007','Nambah Dadi'),
('18.02.07.2008','Ono Harjo'),
('18.02.07.2009','Terbanggi Besar'),
('18.02.07.2010','Poncowati'),
('18.02.08','Seputih Raman'),
('18.02.08.2001','Rejo Basuki'),
('18.02.08.2002','Rejo Asri'),
('18.02.08.2003','Rukti Endah'),
('18.02.08.2004','Rama Dewa'),
('18.02.08.2005','Ratna Chaton'),
('18.02.08.2006','Rama Yana'),
('18.02.08.2007','Rama Indra'),
('18.02.08.2008','Rukti Harjo'),
('18.02.08.2009','Rama Gunawan'),
('18.02.08.2010','Rama Oetama'),
('18.02.08.2011','Rama Nirwana'),
('18.02.08.2012','Rama Murti'),
('18.02.08.2013','Rama Klandungan'),
('18.02.08.2014','Buyut Baru'),
('18.02.09','Rumbia'),
('18.02.09.2001','Teluk Dalem Ilir'),
('18.02.09.2002','Rekso Binangun'),
('18.02.09.2003','Rukti Basuki'),
('18.02.09.2004','Restu Baru'),
('18.02.09.2005','Restu Buana'),
('18.02.09.2006','Reno Basuki'),
('18.02.09.2013','Bina Karya Putra'),
('18.02.09.2014','Bina Karya Buana'),
('18.02.09.2015','Bina Karya mandiri'),
('18.02.10','Seputih Banyak'),
('18.02.10.2001','Sumber Bahagia'),
('18.02.10.2002','Tanjung Harapan'),
('18.02.10.2003','Setia Bumi'),
('18.02.10.2004','Sumber Baru'),
('18.02.10.2005','Siswo Binangun'),
('18.02.10.2006','Sanggar Buana'),
('18.02.10.2007','Sakti Buana'),
('18.02.10.2008','Setia Bhakti'),
('18.02.10.2009','Sri Basuki'),
('18.02.10.2010','Sari Bhakti'),
('18.02.10.2011','Swastika Buana'),
('18.02.10.2012','Sumber Fajar'),
('18.02.10.2013','Tanjung Krajan'),
('18.02.11','Seputih Mataram'),
('18.02.11.2001','Fajar Mataram'),
('18.02.11.2002','Rejosari Mataram'),
('18.02.11.2003','Qurnia Mataram'),
('18.02.11.2004','Trimulyo Mataram'),
('18.02.11.2005','Utama Jaya Mataram'),
('18.02.11.2006','Sumber Agung Mataram'),
('18.02.11.2007','Varia Agung Mataram'),
('18.02.11.2008','Wirata Agung Mataram'),
('18.02.11.2009','Dharma Agung Mataram'),
('18.02.11.2010','Bumi Setia Mataram'),
('18.02.11.2011','Subing Karya'),
('18.02.11.2012','Banjar Agung Mataram'),
('18.02.12','Seputih Surabaya'),
('18.02.12.2001','Gaya Baru VI'),
('18.02.12.2002','Sumber Katon'),
('18.02.12.2003','Sri Katon'),
('18.02.12.2004','Gaya Baru VII'),
('18.02.12.2005','Gaya Baru IV'),
('18.02.12.2006','Gaya Baru III'),
('18.02.12.2007','Gaya Baru II'),
('18.02.12.2008','Gaya Baru VIII'),
('18.02.12.2009','Gaya Baru I'),
('18.02.12.2010','Mataram Ilir'),
('18.02.12.2011','Rawa Betik'),
('18.02.12.2012','Srimulya Jaya'),
('18.02.12.2013','Kenanga Sari'),
('18.02.13','Terusan Nunyai'),
('18.02.13.2001','Gunung Batin Udik'),
('18.02.13.2002','Gunung Batin Ilir'),
('18.02.13.2003','Gunung Batin Baru'),
('18.02.13.2004','Gunung Agung'),
('18.02.13.2005','Bandar Agung'),
('18.02.13.2006','Bandar Sakti'),
('18.02.13.2007','Tanjung Anom'),
('18.02.14','Bumi Ratu Nuban'),
('18.02.14.2001','Suka Jawa'),
('18.02.14.2002','Sidokerto'),
('18.02.14.2003','Suka Jadi'),
('18.02.14.2004','Bumi Raharjo'),
('18.02.14.2005','Wates'),
('18.02.14.2006','Bumi Ratu'),
('18.02.14.2007','Bulu Sari'),
('18.02.14.2008','Bumi Rahayu'),
('18.02.14.2009','Sido Waras'),
('18.02.14.2010','Tulung Kakan'),
('18.02.15','Bekri'),
('18.02.15.2001','Rengas'),
('18.02.15.2002','Kesuma Dadi'),
('18.02.15.2003','Sinar Banten'),
('18.02.15.2004','Kesuma Jaya'),
('18.02.15.2005','Binjai Ngagung'),
('18.02.15.2006','Kedatuan'),
('18.02.15.2007','Goras Jaya'),
('18.02.15.2008','Bangun Sari'),
('18.02.16','Seputih Agung');
INSERT INTO wilayah VALUES('18.02.16.2001','Harapan Rejo'),
('18.02.16.2002','Endang Rejo'),
('18.02.16.2003','Dono Arum'),
('18.02.16.2004','Simpang Agung'),
('18.02.16.2005','Bumi Kencana'),
('18.02.16.2006','Gayau Sakti'),
('18.02.16.2007','Fajar Asri'),
('18.02.16.2008','Muji Rahayu'),
('18.02.16.2009','Sulusuban'),
('18.02.16.2010','Bumi Mas'),
('18.02.17','Way Pengubuan'),
('18.02.17.2001','Tanjung Ratu Ilir'),
('18.02.17.2002','Candi Rejo'),
('18.02.17.2003','Banjar Ratu'),
('18.02.17.2004','Banjar Kerta Rahayu'),
('18.02.17.2005','Lempuyang Bandar'),
('18.02.17.2006','Purnama Tunggal'),
('18.02.17.2007','Banjar Rejo'),
('18.02.17.2008','Putra Lempuyang'),
('18.02.18','Bandar Mataram'),
('18.02.18.2001','Sriwijaya Mataram'),
('18.02.18.2002','Uman Agung Mataram'),
('18.02.18.2003','Terbanggi Ilir'),
('18.02.18.2004','Jatidatar Mataram'),
('18.02.18.2005','Sendang Agung Mataram'),
('18.02.18.2006','Mataram Udik'),
('18.02.18.2007','Terbanggi Mulya'),
('18.02.18.2008','Mataram Jaya');
INSERT INTO wilayah VALUES('18.02.18.2009','Sumber Rejeki Mataram'),
('18.02.19','Pubian'),
('18.02.19.2001','Kota Batu'),
('18.02.19.2002','Sangun Ratu'),
('18.02.19.2003','Gunung Raya'),
('18.02.19.2004','Gunung Haji'),
('18.02.19.2005','Negeri Ratu'),
('18.02.19.2006','Tanjung Kemala'),
('18.02.19.2007','Payung Rejo'),
('18.02.19.2008','Payung Batu'),
('18.02.19.2009','Negeri Kepayungan'),
('18.02.19.2010','Segala Mider'),
('18.02.19.2011','Tias Bangun'),
('18.02.19.2012','Riau Priangan'),
('18.02.19.2013','Payung Dadi'),
('18.02.19.2014','Payung Makmur'),
('18.02.19.2015','Tanjung Rejo'),
('18.02.19.2016','Tawang Negeri'),
('18.02.19.2017','Sinar Negeri'),
('18.02.19.2018','Pekandangan'),
('18.02.19.2019','Payung Mulya'),
('18.02.19.2020','Padang Rejo'),
('18.02.20','Selagai Lingga'),
('18.02.20.2001','Nyukang Harjo'),
('18.02.20.2002','Lingga Pura'),
('18.02.20.2003','Sido Harjo'),
('18.02.20.2004','Taman Sari'),
('18.02.20.2005','Karang Anyar'),
('18.02.20.2006','Negeri Katon'),
('18.02.20.2007','Gedung Harta'),
('18.02.20.2008','Tanjung Ratu'),
('18.02.20.2009','Negeri Agung'),
('18.02.20.2010','Gilih Karang Jati'),
('18.02.20.2011','Marga Jaya'),
('18.02.20.2012','Gedung Aji'),
('18.02.20.2013','Negeri Jaya'),
('18.02.20.2014','Mekar Harjo'),
('18.02.21','Anak Tuha'),
('18.02.21.2001','Srikaton'),
('18.02.21.2002','Jaya Sakti'),
('18.02.21.2003','Haji Pemanggilan'),
('18.02.21.2004','Negara Bumi Ilir'),
('18.02.21.2005','Bumi Aji'),
('18.02.21.2006','Negara Aji Tua'),
('18.02.21.2007','Negara Bumi Udik'),
('18.02.21.2008','Negara Aji Baru'),
('18.02.21.2009','Gunung Agung'),
('18.02.21.2010','Tanjung Harapan'),
('18.02.21.2011','Bumi Jaya'),
('18.02.21.2012','Mulyo Haji'),
('18.02.22','Sendang Agung'),
('18.02.22.2001','Sendang Mulyo'),
('18.02.22.2002','Sendang Rejo'),
('18.02.22.2003','Sendang Baru'),
('18.02.22.2004','Sendang Retno'),
('18.02.22.2005','Sendang Asih'),
('18.02.22.2006','Sendang Agung'),
('18.02.22.2007','Sendang Asri'),
('18.02.22.2008','Sendang Mukti'),
('18.02.22.2009','Kutowinangun'),
('18.02.23','Kota Gajah'),
('18.02.23.2001','Sritejo Kencono'),
('18.02.23.2002','Sapto Mulyo'),
('18.02.23.2003','Nambah Rejo'),
('18.02.23.2004','Sumber Rejo'),
('18.02.23.2005','Purworejo'),
('18.02.23.2006','Kota Gajah'),
('18.02.23.2007','Kota Gajah Timur'),
('18.02.24','Bumi Nabung'),
('18.02.24.2001','Sri Kencono'),
('18.02.24.2002','Bumi Nabung Ilir'),
('18.02.24.2003','Bumi Nabung Utara'),
('18.02.24.2004','Bumi Nabung Selatan'),
('18.02.24.2005','Bumi Nabung Timur'),
('18.02.24.2006','Bumi Nabung Baru'),
('18.02.24.2007','Sri Kencono Baru'),
('18.02.25','Way Seputih'),
('18.02.25.2001','Sido Binangun'),
('18.02.25.2002','Sri Bawono'),
('18.02.25.2003','Sri Budaya'),
('18.02.25.2004','Suko Binangun'),
('18.02.25.2005','Sri Busono'),
('18.02.25.2006','Sangga Buana'),
('18.02.26','Bandar Surabaya'),
('18.02.26.2001','Gaya Baru V'),
('18.02.26.2002','Surabaya Ilir'),
('18.02.26.2003','Rajawali'),
('18.02.26.2004','Cempaka Putih'),
('18.02.26.2005','Subang Jaya'),
('18.02.26.2006','Cabang'),
('18.02.26.2007','Beringin Jaya'),
('18.02.26.2008','Sidodadi'),
('18.02.26.2009','Sumber Agung'),
('18.02.26.2010','Surabaya Baru'),
('18.02.27','Anak Ratu Aji'),
('18.02.27.2001','Gedung Sari'),
('18.02.27.2002','Srimulyo'),
('18.02.27.2003','Gedung Ratu'),
('18.02.27.2004','Bandar Putih Tua'),
('18.02.27.2005','Karang Jawa'),
('18.02.27.2006','Sukajaya'),
('18.02.28','Putra Rumbia'),
('18.02.28.2001','Bina Karya Jaya'),
('18.02.28.2002','Bina Karya Utama'),
('18.02.28.2003','Bina Karya Sakti'),
('18.02.28.2004','Joharan'),
('18.02.28.2005','Rantau Jaya Baru'),
('18.02.28.2006','Rantau Jaya Ilir'),
('18.02.28.2007','Bina Karya Baru'),
('18.02.28.2008','Meranggi Jaya'),
('18.02.28.2009','Mekar Jaya'),
('18.02.28.2010','Rantau Jaya makmur'),
('18.03','Kabupaten Lampung Utara'),
('18.03.01','Bukit Kemuning'),
('18.03.01.1001','Bukit Kemuning'),
('18.03.01.2002','Tanjung Baru'),
('18.03.01.2003','Suka Menanti'),
('18.03.01.2004','Muara Aman'),
('18.03.01.2005','Tanjung Baru Timur'),
('18.03.01.2006','Dwikora'),
('18.03.01.2007','Tanjung Waras'),
('18.03.01.2008','Sido Mulyo'),
('18.03.02','Kotabumi'),
('18.03.02.1001','Kotabumi Udik'),
('18.03.02.1002','Cempedak'),
('18.03.02.1003','Rejosari'),
('18.03.02.1004','Kotabumi Tengah'),
('18.03.02.1005','Kotabumi Pasar'),
('18.03.02.1006','Kotabumi Ilir'),
('18.03.02.1007','Sindang Sari'),
('18.03.02.1008','Sribasuki'),
('18.03.02.1009','Kota Gapura'),
('18.03.02.2010','Talang Bojong'),
('18.03.02.2011','Sumber Arum'),
('18.03.02.2012','Bojong Barat'),
('18.03.02.2013','Kotabumi Tengah Barat'),
('18.03.03','Sungkai Selatan'),
('18.03.03.2002','Bumi Ratu'),
('18.03.03.2003','Labuhan Ratu Pasar'),
('18.03.03.2004','Sinar Galih'),
('18.03.03.2005','Labuhan Ratu Kampung'),
('18.03.03.2006','Gedung Ketapang'),
('18.03.03.2007','Kota Agung'),
('18.03.03.2008','Ketapang'),
('18.03.03.2009','Karang Rejo I'),
('18.03.03.2010','Banjar Ketapang'),
('18.03.03.2017','Sidodadi'),
('18.03.03.2023','Gunung Labuhan'),
('18.03.04','Tanjung Raja'),
('18.03.04.2001','Karang Waringin'),
('18.03.04.2002','Suka Sari'),
('18.03.04.2003','Merambung'),
('18.03.04.2004','Sinar Jaya'),
('18.03.04.2005','Sindang Agung'),
('18.03.04.2006','Mekar Jaya'),
('18.03.04.2007','Sri Menanti'),
('18.03.04.2008','Tulung Balak'),
('18.03.04.2009','Tanjung Raja'),
('18.03.04.2010','Tanjung Riang'),
('18.03.04.2011','Kemala Raja'),
('18.03.04.2012','Sindang Marga'),
('18.03.04.2013','Ulak Ata'),
('18.03.04.2014','Gunung Katon'),
('18.03.04.2015','Suka Mulya'),
('18.03.04.2016','Tanjung Beringin'),
('18.03.04.2017','Sido Mulyo'),
('18.03.04.2018','Sinar Mulya'),
('18.03.04.2019','Priangan Baru'),
('18.03.05','Abung Timur'),
('18.03.05.2001','Banjar Agung'),
('18.03.05.2002','Bumi Agung Marga'),
('18.03.05.2003','Pungguk Lama'),
('18.03.05.2004','Gedung Nyapah'),
('18.03.05.2005','Penagan Ratu'),
('18.03.05.2006','Peraduan Waras'),
('18.03.05.2007','Surakarta'),
('18.03.05.2008','Rejo Mulyo'),
('18.03.05.2009','Sidomukti'),
('18.03.05.2010','Bumi Jaya'),
('18.03.05.2011','Papan Rejo'),
('18.03.05.2012','Sumber Agung'),
('18.03.06','Abung Barat'),
('18.03.06.2005','Tanjung Harta'),
('18.03.06.2006','Ogan Lima'),
('18.03.06.2007','Hujan Mas'),
('18.03.06.2008','Simpang Agung'),
('18.03.06.2009','Bumi Nabung'),
('18.03.06.2010','Kamplas'),
('18.03.06.2011','Kistang'),
('18.03.06.2012','Cahaya Negeri'),
('18.03.06.2013','Lepang Besar'),
('18.03.06.2016','Pengaringan'),
('18.03.06.2017','Gunung Betuah'),
('18.03.06.2021','Way Wakak'),
('18.03.06.2023','Pematang Kasih'),
('18.03.06.2024','Bumi Mandiri'),
('18.03.07','Abung Selatan'),
('18.03.07.2004','Trimodadi'),
('18.03.07.2005','Cabang Empat'),
('18.03.07.2006','Sinar Ogan'),
('18.03.07.2007','Kalibalangan'),
('18.03.07.2009','Gilih Sukanegeri'),
('18.03.07.2010','Candimas'),
('18.03.07.2011','Kembang Tanjung'),
('18.03.07.2012','Abung Jayo'),
('18.03.07.2013','Kembang Gading'),
('18.03.07.2014','Ratu Abung'),
('18.03.07.2015','Bandar Kagungan Raya'),
('18.03.07.2016','Bumi Raya'),
('18.03.07.2017','Kemalo Abung'),
('18.03.07.2018','Cabang Abung Raya'),
('18.03.07.2019','Kalibening Raya'),
('18.03.07.2020','Way Lunik'),
('18.03.08','Sungkai Utara'),
('18.03.08.2005','Ogan Jaya'),
('18.03.08.2009','Ciamis'),
('18.03.08.2010','Padang Ratu'),
('18.03.08.2011','Negeri Sakti'),
('18.03.08.2012','Negeri Ratu'),
('18.03.08.2019','Negara Ratu'),
('18.03.08.2020','Batu Raja'),
('18.03.08.2021','Gedung Batin'),
('18.03.08.2022','Negara Batin'),
('18.03.08.2023','Kota Negara'),
('18.03.08.2024','Bangun Jaya'),
('18.03.08.2028','Baru Raharja'),
('18.03.08.2029','Hanakau Jaya'),
('18.03.08.2032','Negara Batin II'),
('18.03.08.2033','Kota Negara Ilir'),
('18.03.09','Kotabumi Utara'),
('18.03.09.2001','Madukoro'),
('18.03.09.2002','Kali Cinta'),
('18.03.09.2003','Wono Marto'),
('18.03.09.2004','Talang Jali'),
('18.03.09.2005','Margo Rejo'),
('18.03.09.2006','Banjar Wangi'),
('18.03.09.2007','Sawo Jajar'),
('18.03.09.2008','Madokoro Baru'),
('18.03.10','Kotabumi Selatan'),
('18.03.10.1001','Kelapa Tujuh'),
('18.03.10.1002','Tanjung Aman'),
('18.03.10.1003','Kota Alam'),
('18.03.10.1011','Tanjung Harapan'),
('18.03.10.1012','Tanjung Senang'),
('18.03.10.2004','Mulang Maya'),
('18.03.10.2005','Bandar Putih'),
('18.03.10.2006','Karang Agung'),
('18.03.10.2007','Curup Guruh'),
('18.03.10.2008','Jerangkang'),
('18.03.10.2009','Way Melan'),
('18.03.10.2010','Taman Jaya'),
('18.03.10.2013','Alam Jaya'),
('18.03.10.2014','Sinar Mas Alam'),
('18.03.11','Abung Tengah'),
('18.03.11.2001','Gunung Besar'),
('18.03.11.2002','Kinciran'),
('18.03.11.2003','Negla Sari'),
('18.03.11.2004','Kedaton'),
('18.03.11.2005','Sri Bandung'),
('18.03.11.2006','Subik'),
('18.03.11.2007','Gunung Sadar'),
('18.03.11.2008','Gunung Gijul'),
('18.03.11.2016','Pekurun Barat'),
('18.03.11.2017','Pekurun Selatan'),
('18.03.11.2018','Pekurun Utara'),
('18.03.12','Abung Tinggi'),
('18.03.12.2001','Ulak Rengas'),
('18.03.12.2002','Muara Dua'),
('18.03.12.2003','Pulau Panggung'),
('18.03.12.2004','Sekipi'),
('18.03.12.2005','Sido Kayo'),
('18.03.12.2006','Suka Marga'),
('18.03.12.2007','Suka Maju'),
('18.03.12.2008','Kebun Dalam'),
('18.03.13','Abung Semuli'),
('18.03.13.2001','Suka Maju'),
('18.03.13.2002','Semuli Raya'),
('18.03.13.2003','Semuli Jaya'),
('18.03.13.2004','Papan Asri'),
('18.03.13.2005','Gunung Keramat'),
('18.03.13.2006','Sido Rahayu'),
('18.03.13.2007','Gunung Sari'),
('18.03.14','Abung Surakarta'),
('18.03.14.2001','Tatakarya'),
('18.03.14.2002','Bandar Abung'),
('18.03.14.2003','Bangun Sari'),
('18.03.14.2004','Purba Sakti'),
('18.03.14.2005','Bumi Raharja'),
('18.03.14.2006','Bumi Restu'),
('18.03.14.2007','Bandar Sakti'),
('18.03.14.2008','Karya Sakti'),
('18.03.14.2009','Sukoharjo'),
('18.03.15','Muara Sungkai'),
('18.03.15.2001','Negeri Ujung Karang'),
('18.03.15.2002','Bandar Agung'),
('18.03.15.2003','Karang Sari'),
('18.03.15.2004','Karang Rejo II'),
('18.03.15.2005','Karang Sakti'),
('18.03.15.2006','Karang Mulyo'),
('18.03.15.2007','Banjar Negeri'),
('18.03.15.2008','Banjar Ratu'),
('18.03.15.2009','Negeri Ratu'),
('18.03.15.2010','Pakuon Agung'),
('18.03.15.2011','Sumber Agung'),
('18.03.16','Bunga Mayang'),
('18.03.16.2001','Negara Tulang Bawang'),
('18.03.16.2002','Kota Napal'),
('18.03.16.2003','Tanah Abang'),
('18.03.16.2004','Sukadana Udik'),
('18.03.16.2005','Sukadana Ilir'),
('18.03.16.2006','Haduyang Ratu'),
('18.03.16.2007','Iso Rejo'),
('18.03.16.2008','Mulyo Rejo II'),
('18.03.16.2009','Tulang Bawang Baru'),
('18.03.16.2010','Mulyo Rejo I'),
('18.03.16.2011','Suka Maju'),
('18.03.17','Hulu Sungkai'),
('18.03.17.2001','Negera Kemakmuran'),
('18.03.17.2002','Bonglai Tengah'),
('18.03.17.2003','Tanjung Harapan'),
('18.03.17.2004','Lubuk Rukam'),
('18.03.17.2005','Ibul Jaya'),
('18.03.17.2006','Beringin Jaya'),
('18.03.17.2007','Gedung Makrifat'),
('18.03.17.2008','Gedung Raja'),
('18.03.17.2009','Gedung Negara'),
('18.03.17.2010','Tulung Buyut'),
('18.03.18','Sungkai Tengah'),
('18.03.18.2001','Batu Nangkop'),
('18.03.18.2002','Negara Bumi'),
('18.03.18.2003','Melungun Ratu'),
('18.03.18.2004','Negeri Campang Jaya'),
('18.03.18.2005','Pampang Tangguk Jaya'),
('18.03.18.2006','Negeri Galih Rejo'),
('18.03.18.2007','Ratu Jaya'),
('18.03.18.2008','Mekar Sari'),
('18.03.19','Abung Pekurun'),
('18.03.19.2001','Nyapah Banyu'),
('18.03.19.2002','Sinar Gunung'),
('18.03.19.2003','Campang Gijul'),
('18.03.19.2004','Sumber Tani'),
('18.03.19.2005','Pekurun'),
('18.03.19.2006','Ogan Campang'),
('18.03.19.2007','Pekurun Tengah'),
('18.03.19.2008','Pekurun Udik'),
('18.03.19.2009','Ogan Jaya'),
('18.03.20','Sungkai Jaya'),
('18.03.20.2001','Cempaka'),
('18.03.20.2002','Sri Agung'),
('18.03.20.2003','Lepang Tengah'),
('18.03.20.2004','Cahaya Makmur'),
('18.03.20.2005','Suka Jaya'),
('18.03.20.2006','Sri Jaya'),
('18.03.20.2007','Negara Agung'),
('18.03.20.2008','Cempaka Barat'),
('18.03.20.2009','Cempaka Timur'),
('18.03.21','Sungkai Barat'),
('18.03.21.2001','Sinar Harapan'),
('18.03.21.2002','Kubu Hitu'),
('18.03.21.2003','Negeri Sakti'),
('18.03.21.2004','Tanjung Jaya'),
('18.03.21.2005','Gunung Raja'),
('18.03.21.2006','Cahaya Mas'),
('18.03.21.2007','Comok Sinar Jaya'),
('18.03.21.2008','Way Isem'),
('18.03.21.2009','Gunung Maknibai'),
('18.03.21.2010','Negeri Batin Jaya'),
('18.03.22','Abung Kunang'),
('18.03.22.2001','Aji Kagungan'),
('18.03.22.2002','Talang Jembatan'),
('18.03.22.2003','Sabuk Empat'),
('18.03.22.2004','Beringin'),
('18.03.22.2005','Sabuk Indah'),
('18.03.22.2006','Bindu'),
('18.03.22.2007','Way Perancang'),
('18.03.23','Blambangan Pagar'),
('18.03.23.2001','Pagar'),
('18.03.23.2002','Blambangan'),
('18.03.23.2003','Jagang'),
('18.03.23.2004','Tanjung Iman'),
('18.03.23.2005','Tulung Singkip'),
('18.03.23.2006','Pagar Gading'),
('18.03.23.2007','Buring Kencana'),
('18.04','Kabupaten Lampung Barat'),
('18.04.04','Balik Bukit'),
('18.04.04.1001','Pasar Liwa'),
('18.04.04.1003','Way Mengaku'),
('18.04.04.2002','Kubu Perahu'),
('18.04.04.2004','Padang Cahya'),
('18.04.04.2005','Sebarus'),
('18.04.04.2006','Way Empulau Ulu'),
('18.04.04.2007','Gunung Sugih'),
('18.04.04.2008','Wates'),
('18.04.04.2009','Padang Dalom'),
('18.04.04.2010','Sukarame'),
('18.04.04.2011','Bahway'),
('18.04.04.2012','Sedampah Indah'),
('18.04.05','Sumber Jaya'),
('18.04.05.1016','Tugu Sari'),
('18.04.05.2001','Simpangsari'),
('18.04.05.2010','Sukajaya'),
('18.04.05.2011','Sindang Pagar'),
('18.04.05.2012','Sukapura'),
('18.04.05.2013','Way Petai'),
('18.04.06','Belalau'),
('18.04.06.2001','Kenali'),
('18.04.06.2002','Kejadian'),
('18.04.06.2003','Bumi Agung'),
('18.04.06.2004','Turgak'),
('18.04.06.2005','Bedudu'),
('18.04.06.2006','Sukarame'),
('18.04.06.2007','Hujung'),
('18.04.06.2013','Serungkuk'),
('18.04.06.2019','Suka Makmur'),
('18.04.06.2020','Fajar Agung'),
('18.04.07','Way Tenong'),
('18.04.07.1001','Pajar Bulan'),
('18.04.07.2002','Puralaksana'),
('18.04.07.2003','Karang Agung'),
('18.04.07.2004','Mutar Alam'),
('18.04.07.2005','Tanjungraya'),
('18.04.07.2006','Sukananti'),
('18.04.07.2007','Sukaraja'),
('18.04.07.2008','Padang Tambak'),
('18.04.07.2009','Tambak Jaya'),
('18.04.08','Sekincau'),
('18.04.08.1005','Sekincau'),
('18.04.08.2001','Pampangan'),
('18.04.08.2006','Waspada'),
('18.04.08.2007','Tigajaya'),
('18.04.08.2008','Giham Sukamaju'),
('18.04.09','Suoh'),
('18.04.09.2003','Suka Marga'),
('18.04.09.2004','Sumber Agung'),
('18.04.09.2005','Tugu Ratu'),
('18.04.09.2006','Banding Agung'),
('18.04.09.2010','Rowo Rejo'),
('18.04.09.2017','Sido Rejo'),
('18.04.09.2018','Ringin Sari'),
('18.04.10','Batu Brak'),
('18.04.10.2001','Kembahang'),
('18.04.10.2002','Negeri Ratu'),
('18.04.10.2003','Kegeringan'),
('18.04.10.2004','Gunung Sugih'),
('18.04.10.2005','Pekon Balak'),
('18.04.10.2006','Sukabumi'),
('18.04.10.2007','Canggu'),
('18.04.10.2008','Kotabesi'),
('18.04.10.2009','Sukaraja'),
('18.04.10.2010','Kerang'),
('18.04.10.2011','Teba Liokh'),
('18.04.11','Sukau'),
('18.04.11.2001','Tanjung Raya'),
('18.04.11.2002','Hanakau'),
('18.04.11.2003','Buay Nyerupa'),
('18.04.11.2004','Tapak Siring'),
('18.04.11.2005','Jaga Raga'),
('18.04.11.2009','Pagar Dewa'),
('18.04.11.2012','Suka Mulya'),
('18.04.11.2018','Bandar Baru'),
('18.04.11.2019','Bumi Jaya'),
('18.04.11.2020','Teba Pering Jaya'),
('18.04.15','Gedung Surian'),
('18.04.15.2001','Gedung Surian'),
('18.04.15.2002','Puramekar'),
('18.04.15.2003','Ciptawaras'),
('18.04.15.2004','Trimulyo'),
('18.04.15.2005','Mekarjaya'),
('18.04.18','Kebun Tebu'),
('18.04.18.2001','Pura Jaya'),
('18.04.18.2002','Pura Wiwitan'),
('18.04.18.2003','Tribudi Syukur'),
('18.04.18.2004','Muara Jaya I'),
('18.04.18.2005','Muara Jaya II'),
('18.04.18.2006','Tri Budi Makmur'),
('18.04.18.2007','Tugu Mulya'),
('18.04.18.2008','Cipta Mulya'),
('18.04.18.2009','Muara Baru'),
('18.04.18.2010','Sinar Luas'),
('18.04.19','Air Hitam'),
('18.04.19.2001','Sidodadi'),
('18.04.19.2002','Semarang Jaya'),
('18.04.19.2003','Sumber Alam'),
('18.04.19.2004','Gunungterang'),
('18.04.19.2005','Suka Jadi'),
('18.04.19.2006','Sri Menanti'),
('18.04.19.2007','Sinar Jaya'),
('18.04.19.2008','Rigis Jaya'),
('18.04.19.2009','Suka Damai'),
('18.04.19.2010','Manggarai'),
('18.04.20','Pagar Dewa'),
('18.04.20.2001','Pahayu Jaya'),
('18.04.20.2002','Basungan'),
('18.04.20.2003','Mekar Sari'),
('18.04.20.2004','Sidomulyo'),
('18.04.20.2005','Sidodadi'),
('18.04.20.2006','Marga Jaya'),
('18.04.20.2007','Suka Jaya'),
('18.04.20.2008','Batu Api'),
('18.04.20.2009','Pagar Dewa'),
('18.04.20.2010','Suka Mulya'),
('18.04.21','Batu Ketulis'),
('18.04.21.2001','Argomulyo'),
('18.04.21.2002','Batu Kebayan'),
('18.04.21.2003','Atar Bawang'),
('18.04.21.2004','Campang Tiga'),
('18.04.21.2005','Luas'),
('18.04.21.2006','Bakhu'),
('18.04.21.2007','Way Ngison'),
('18.04.21.2008','Kubu Liku Jaya'),
('18.04.21.2009','Sumber Rejo'),
('18.04.21.2010','Atar Kuwau'),
('18.04.22','Lumbok Seminung'),
('18.04.22.2001','Lombok'),
('18.04.22.2002','Heni Arong'),
('18.04.22.2003','Suka Banjar'),
('18.04.22.2004','Lombok Timur'),
('18.04.22.2005','Suka Banjar II Ujung Rembun'),
('18.04.22.2006','Suka Maju'),
('18.04.22.2007','Ujung'),
('18.04.22.2008','Keagungan'),
('18.04.22.2009','Tawan Suka Mulya'),
('18.04.22.2010','Pancur Mas'),
('18.04.22.2011','Lombok Selatan'),
('18.04.23','Bandar Negeri Suoh'),
('18.04.23.2001','Suoh'),
('18.04.23.2002','Srimulyo'),
('18.04.23.2003','Bandar Agung'),
('18.04.23.2004','Ringin Jaya'),
('18.04.23.2005','Bumi Hantatai'),
('18.04.23.2006','Gunung Ratu'),
('18.04.23.2007','Tanjung Sari'),
('18.04.23.2008','Negeri Jaya'),
('18.04.23.2009','Tembelang'),
('18.04.23.2010','Tri Mekar Jaya'),
('18.05','Kabupaten Tulang Bawang'),
('18.05.02','Menggala'),
('18.05.02.1008','Menggala Selatan'),
('18.05.02.1009','Ujung Gunung'),
('18.05.02.1010','Menggala Tengah'),
('18.05.02.1011','Menggala Kota'),
('18.05.02.2001','Bujung Tenuk'),
('18.05.02.2002','Ujung Gunung Ilir'),
('18.05.02.2007','Astra Ksetra'),
('18.05.02.2013','Kagungan Rahayu'),
('18.05.02.2014','Tiuh Tohou'),
('18.05.06','Gedung Aji'),
('18.05.06.2001','Aji Jaya KNPI'),
('18.05.06.2002','Kecubung Jaya'),
('18.05.06.2008','Kecubung Mulya'),
('18.05.06.2015','Gedung Aji'),
('18.05.06.2016','Penawar'),
('18.05.06.2022','Penawar Baru'),
('18.05.06.2023','Aji Murni Jaya'),
('18.05.06.2024','Aji Mesir'),
('18.05.06.2025','Aji Permai Talang Buah'),
('18.05.06.2026','Bandar Aji Jaya'),
('18.05.08','Banjar Agung'),
('18.05.08.2001','Banjar Agung'),
('18.05.08.2007','Tri Darma Wirajaya'),
('18.05.08.2009','Moris Jaya'),
('18.05.08.2010','Tunggal Warga'),
('18.05.08.2011','Dwi Warga Tunggal Jaya'),
('18.05.08.2019','Tri Mulya Jaya'),
('18.05.08.2020','Tri Mukti Jaya'),
('18.05.08.2021','Tri Tunggal Jaya'),
('18.05.08.2022','Warga Makmur Jaya'),
('18.05.08.2023','Warga Indah Jaya'),
('18.05.08.2024','Banjar Dewa'),
('18.05.11','Gedung Meneng'),
('18.05.11.2001','Gunung Tapa'),
('18.05.11.2002','Gedung Meneng'),
('18.05.11.2006','Bakung Udik'),
('18.05.11.2007','Bakung Ilir'),
('18.05.11.2008','Gedung Bandar Rahayu'),
('18.05.11.2014','Gunung Tapa Ilir'),
('18.05.11.2015','Gunung Tapa Tengah'),
('18.05.11.2016','Gunung Tapa Udik'),
('18.05.11.2017','Gedung Bandar Rejo'),
('18.05.11.2018','Bakung Rahayu'),
('18.05.11.2019','Gedung Meneng Baru'),
('18.05.12','Rawa Jitu Selatan'),
('18.05.12.2003','Yudha Karya Jitu'),
('18.05.12.2004','Gedung Karya Jitu'),
('18.05.12.2005','Hargo Rejo'),
('18.05.12.2006','Wono Agung'),
('18.05.12.2008','Karya Jitu Mukti'),
('18.05.12.2009','Bumi Ratu'),
('18.05.12.2010','Medasari'),
('18.05.12.2013','Hargo Mulyo'),
('18.05.12.2014','Karya Cipta Abadi'),
('18.05.13','Penawar Tama'),
('18.05.13.2001','Tri Rejo Mulyo'),
('18.05.13.2002','Tri Jaya'),
('18.05.13.2005','Sidoharjo'),
('18.05.13.2006','Sido Mulyo'),
('18.05.13.2010','Boga Tama'),
('18.05.13.2011','Wira Tama'),
('18.05.13.2013','Tri Tunggal Jaya'),
('18.05.13.2019','Pulo Gadung'),
('18.05.13.2020','Sidodadi'),
('18.05.13.2021','Dwimulyo'),
('18.05.13.2022','Rejo Sari'),
('18.05.13.2023','Wira Agung Sari'),
('18.05.13.2024','Sidomakmur'),
('18.05.13.2025','Trikarya'),
('18.05.18','Rawa Jitu Timur'),
('18.05.18.2001','Bumi Dipasena Utama'),
('18.05.18.2002','Bumi Dipasena Agung'),
('18.05.18.2003','Bumi Dipasena Jaya'),
('18.05.18.2004','Bumi Dipasena Abadi'),
('18.05.18.2005','Bumi Dipasena Makmur'),
('18.05.18.2006','Bumi Sentosa'),
('18.05.18.2007','Bumi Dipasena Mulya'),
('18.05.18.2008','Bumi Dipasena Sejahtera'),
('18.05.20','Banjar Margo'),
('18.05.20.2001','Bujuk Agung'),
('18.05.20.2002','Ringin Sari'),
('18.05.20.2003','Suka Maju'),
('18.05.20.2004','Catur Karya Buana Jaya'),
('18.05.20.2005','Purwa Jaya'),
('18.05.20.2006','Penawar Jaya'),
('18.05.20.2007','Agung Dalam'),
('18.05.20.2008','Sumber Makmur'),
('18.05.20.2009','Tri Tunggal Jaya'),
('18.05.20.2010','Agung Jaya'),
('18.05.20.2011','Penawar Rejo'),
('18.05.20.2012','Mekar Jaya'),
('18.05.22','Rawa Pitu'),
('18.05.22.2001','Sumber Agung'),
('18.05.22.2002','Batang Hari'),
('18.05.22.2003','Panggung Mulyo'),
('18.05.22.2004','Duto Yoso Mulyo'),
('18.05.22.2005','Andalas Cermin'),
('18.05.22.2006','Rawa Ragil'),
('18.05.22.2007','Gedung Jaya'),
('18.05.22.2008','Bumi Sari'),
('18.05.22.2009','Mulyo Dadi'),
('18.05.23','Penawar Aji'),
('18.05.23.2001','Gedung Harapan'),
('18.05.23.2002','Gedung Asri'),
('18.05.23.2003','Gedung Rejo Sakti'),
('18.05.23.2004','Pasar Batang'),
('18.05.23.2005','Suka Makmur'),
('18.05.23.2006','Karya Makmur'),
('18.05.23.2007','Wono Rejo'),
('18.05.23.2008','Panca Tunggal Jaya'),
('18.05.23.2009','Sumber Sari'),
('18.05.25','Dente Teladas'),
('18.05.25.2001','Teladas'),
('18.05.25.2002','Kekatung'),
('18.05.25.2003','Kuala Teladas'),
('18.05.25.2004','Mahabang'),
('18.05.25.2005','Sungai Nibung'),
('18.05.25.2006','Pasiran Jaya'),
('18.05.25.2007','Bratasena Adiwarna'),
('18.05.25.2008','Bratasena Mandiri'),
('18.05.25.2009','Way Dente'),
('18.05.25.2010','Dente Makmur'),
('18.05.25.2011','Pendowo Asri'),
('18.05.25.2012','Sungai Burung'),
('18.05.26','Meraksa Aji'),
('18.05.26.2001','Bangun Rejo'),
('18.05.26.2002','Paduan Rajawali'),
('18.05.26.2003','Karya Bhakti'),
('18.05.26.2004','Sukarame'),
('18.05.26.2005','Bina Bumi'),
('18.05.26.2006','Mulyo Aji'),
('18.05.26.2007','Kecubung Raya'),
('18.05.26.2008','Marga Jaya'),
('18.05.27','Gedung Aji Baru'),
('18.05.27.2001','Sidomukti'),
('18.05.27.2002','Mesir Dwi Jaya'),
('18.05.27.2003','Makartitama'),
('18.05.27.2004','Suka Bhakti'),
('18.05.27.2005','Batu Ampar'),
('18.05.27.2006','Setia Tama'),
('18.05.27.2007','Sumber Jaya'),
('18.05.27.2008','Mekar Asri'),
('18.05.27.2009','Sidomekar'),
('18.05.29','Banjar Baru'),
('18.05.29.2001','Panca Mulia'),
('18.05.29.2002','Panca Karsa Purna Jaya'),
('18.05.29.2003','Kahuripan Jaya'),
('18.05.29.2004','Bawang Sakti Jaya'),
('18.05.29.2005','Mekar Jaya'),
('18.05.29.2006','Balai Murni Jaya'),
('18.05.29.2007','Mekar Indah Jaya'),
('18.05.29.2008','Jaya Makmur'),
('18.05.29.2009','Bawang Tirto Mulyo'),
('18.05.29.2010','Karya Murni Jaya'),
('18.05.30','Menggala Timur'),
('18.05.30.2001','Lebuh Dalem'),
('18.05.30.2002','Menggala'),
('18.05.30.2003','Lingai'),
('18.05.30.2004','Kibang Pacing'),
('18.05.30.2005','Sungai Luar'),
('18.05.30.2006','Kahuripan Dalam'),
('18.05.30.2007','Cempaka Dalem'),
('18.05.30.2008','Bedaro Indah'),
('18.05.30.2009','Tri Makmur Jaya'),
('18.05.30.2010','Cempaka Jaya'),
('18.06','Kabupaten Tanggamus'),
('18.06.01','Kota Agung'),
('18.06.01.1001','Baros'),
('18.06.01.1002','Pasar Madang'),
('18.06.01.1003','Kuripan'),
('18.06.01.2016','Negeri Ratu'),
('18.06.01.2019','Penanggungan'),
('18.06.01.2020','Terdana'),
('18.06.01.2021','Kelungu'),
('18.06.01.2022','Pardasuka'),
('18.06.01.2023','Teratas'),
('18.06.01.2024','Kusa'),
('18.06.01.2025','Terbaya'),
('18.06.01.2026','Kedamaian'),
('18.06.01.2027','Kota Agung'),
('18.06.01.2039','Kota Batu'),
('18.06.01.2040','Campang Tiga'),
('18.06.01.2041','Benteng Jaya'),
('18.06.02','Talang Padang'),
('18.06.02.2012','Kalibening'),
('18.06.02.2015','Kejayaan'),
('18.06.02.2016','Suka Bumi'),
('18.06.02.2017','Suka Negeri Jaya'),
('18.06.02.2018','Banjar Sari'),
('18.06.02.2019','Singosari'),
('18.06.02.2020','Sinar Banten'),
('18.06.02.2021','Sukarame'),
('18.06.02.2022','Banding Agung'),
('18.06.02.2023','Talang Padang'),
('18.06.02.2024','Suka Negeri'),
('18.06.02.2025','Suka Bandung'),
('18.06.02.2026','Suka Merindu'),
('18.06.02.2027','Sinar Semendo'),
('18.06.02.2028','Negeri Agung'),
('18.06.02.2029','Sinar Petir'),
('18.06.02.2030','Way Halom'),
('18.06.02.2031','Talang Sepuh'),
('18.06.02.2032','Sinar Harapan'),
('18.06.02.2033','Sinar Betung'),
('18.06.03','Wonosobo'),
('18.06.03.2001','Karang Anyar'),
('18.06.03.2002','Kalirejo'),
('18.06.03.2003','Dadirejo'),
('18.06.03.2004','Banyu Urip'),
('18.06.03.2005','Wonosobo'),
('18.06.03.2006','Soponyono'),
('18.06.03.2007','Bandar Kejadian'),
('18.06.03.2008','Way Panas'),
('18.06.03.2009','Sinar Saudara'),
('18.06.03.2010','Sridadi'),
('18.06.03.2011','Lakaran'),
('18.06.03.2012','Padang Ratu'),
('18.06.03.2013','Pardasuka'),
('18.06.03.2014','Tanjung Kurung'),
('18.06.03.2015','Padang Manis'),
('18.06.03.2016','Kejadian'),
('18.06.03.2017','Dadisari'),
('18.06.03.2018','Kalisari'),
('18.06.03.2019','Banjar Negoro'),
('18.06.03.2020','Pekon Balak'),
('18.06.03.2021','Kunyayan'),
('18.06.03.2022','Banjar Sari'),
('18.06.03.2023','Negeri Ngarip'),
('18.06.03.2034','Dadimulyo'),
('18.06.03.2035','Sampang Turus'),
('18.06.03.2036','Sri Melati'),
('18.06.03.2037','Way Liwok'),
('18.06.03.2038','Sumur Tujuh'),
('18.06.04','Pulau Panggung'),
('18.06.04.2001','Talang Beringin'),
('18.06.04.2002','Gunung Megang'),
('18.06.04.2003','Tanjung Rejo'),
('18.06.04.2004','Tanjung Begelung'),
('18.06.04.2005','Sinar Mulyo'),
('18.06.04.2006','Kemuning'),
('18.06.04.2007','Gedung Agung'),
('18.06.04.2008','Penantian'),
('18.06.04.2009','Muara Dua'),
('18.06.04.2010','Tekad'),
('18.06.04.2011','Pulau Panggung'),
('18.06.04.2012','Gunung Meraksa'),
('18.06.04.2013','Way Ilahan'),
('18.06.04.2014','Batu Bedil'),
('18.06.04.2015','Air Bakoman'),
('18.06.04.2025','Sumber Mulya'),
('18.06.04.2026','Sindang Marga'),
('18.06.04.2027','Talang Jawa'),
('18.06.04.2028','Srimanganten'),
('18.06.04.2029','Tanjung Gunung'),
('18.06.04.2030','Sinar Mancak'),
('18.06.09','Cukuh Balak'),
('18.06.09.2001','Karang Buah'),
('18.06.09.2002','Sawang Balak'),
('18.06.09.2003','Way Rilau'),
('18.06.09.2004','Tanjung Raja'),
('18.06.09.2005','Tengor'),
('18.06.09.2006','Tanjung Jati'),
('18.06.09.2007','Kejadian Lom'),
('18.06.09.2008','Sukaraja'),
('18.06.09.2009','Banjar Negeri'),
('18.06.09.2010','Gedung'),
('18.06.09.2011','Suka Padang'),
('18.06.09.2012','Kacamarga'),
('18.06.09.2013','Pampangan'),
('18.06.09.2014','Banjar Manis'),
('18.06.09.2015','Tanjung Betuah'),
('18.06.09.2016','Putih Doh'),
('18.06.09.2017','Pekondoh'),
('18.06.09.2028','Kubulangka'),
('18.06.09.2029','Kutakakhang'),
('18.06.09.2030','Suka Banjar'),
('18.06.11','Pugung'),
('18.06.11.2001','Rantau Tijang'),
('18.06.11.2002','Tiuh Memon'),
('18.06.11.2003','Banjar Agung Udik'),
('18.06.11.2004','Tanjung Heran'),
('18.06.11.2005','Sumanda'),
('18.06.11.2006','Campang Way Handak'),
('18.06.11.2007','Taman Sari'),
('18.06.11.2008','Sukajadi'),
('18.06.11.2009','Binjai Wangi'),
('18.06.11.2010','Tanjung Kemala'),
('18.06.11.2011','Tanjung Agung'),
('18.06.11.2012','Babakan'),
('18.06.11.2013','Negeri Ratu'),
('18.06.11.2014','Sinar Agung'),
('18.06.11.2015','Tangkit Serdang'),
('18.06.11.2016','Gunung Kasih'),
('18.06.11.2017','Way Jaha'),
('18.06.11.2018','Banjar Agung Ilir'),
('18.06.11.2019','Gading'),
('18.06.11.2020','Way Pring'),
('18.06.11.2021','Pungkut'),
('18.06.11.2022','Gunung Tiga'),
('18.06.11.2023','Way Manak'),
('18.06.11.2024','Sukamaju'),
('18.06.11.2025','Suka Mulya'),
('18.06.11.2026','Kayuhubi'),
('18.06.11.2027','Talang Lebar'),
('18.06.12','Semaka'),
('18.06.12.2001','Tugu Papak'),
('18.06.12.2002','Kacapura'),
('18.06.12.2003','Sukaraja'),
('18.06.12.2004','Bangun Rejo'),
('18.06.12.2005','Tugu Rejo'),
('18.06.12.2006','Sidodadi'),
('18.06.12.2007','Garut'),
('18.06.12.2008','Karang Rejo'),
('18.06.12.2009','Kanoman'),
('18.06.12.2010','Sudimoro'),
('18.06.12.2011','Sudimoro Bangun'),
('18.06.12.2012','Sri Purnomo'),
('18.06.12.2013','Sri Kuncoro'),
('18.06.12.2014','Sidomulyo'),
('18.06.12.2015','Karang Agung'),
('18.06.12.2016','Tulung Asahan'),
('18.06.12.2017','Sri Katon'),
('18.06.12.2018','Pardawaras'),
('18.06.12.2019','Sedayu'),
('18.06.12.2020','Way Kerap'),
('18.06.12.2021','Margomulyo'),
('18.06.12.2022','Sukajaya'),
('18.06.13','Sumberejo'),
('18.06.13.2001','Kebumen'),
('18.06.13.2002','Sidomulyo'),
('18.06.13.2003','Sumber Rejo'),
('18.06.13.2004','Tegal Binangun'),
('18.06.13.2005','Argopeni'),
('18.06.13.2006','Margodadi'),
('18.06.13.2007','Margoyoso'),
('18.06.13.2008','Dadapan'),
('18.06.13.2009','Simpang Kanan'),
('18.06.13.2010','Wonoharjo'),
('18.06.13.2011','Sumber Mulyo'),
('18.06.13.2012','Argomulyo'),
('18.06.13.2013','Sidorejo'),
('18.06.15','Ulu Belu'),
('18.06.15.2001','Datarajan'),
('18.06.15.2002','Gunung Tiga'),
('18.06.15.2003','Karang Rejo'),
('18.06.15.2004','Pagar Alam Ulu Belu'),
('18.06.15.2005','Muara Dua Ulu Belu'),
('18.06.15.2006','Ngarip'),
('18.06.15.2007','Penantian Ulu Belu'),
('18.06.15.2008','Gunung Sari'),
('18.06.15.2009','Ulu Semong'),
('18.06.15.2010','Sirna Galih'),
('18.06.15.2011','Rejo Sari'),
('18.06.15.2012','Sukamaju'),
('18.06.15.2013','Tanjung Baru'),
('18.06.15.2014','Sinar Banten'),
('18.06.15.2015','Air Abang'),
('18.06.15.2016','Petay Kayu'),
('18.06.16','Pematang Sawa'),
('18.06.16.2001','Tampang Tua'),
('18.06.16.2002','Kaur Gading'),
('18.06.16.2003','Tirom'),
('18.06.16.2004','Way Nipah'),
('18.06.16.2005','Guring'),
('18.06.16.2006','Betung'),
('18.06.16.2007','Tanjungan'),
('18.06.16.2009','Teluk Brak'),
('18.06.16.2010','Karang Brak'),
('18.06.16.2011','Pesanguan'),
('18.06.16.2012','Way Asahan'),
('18.06.16.2013','Tampang Muda'),
('18.06.16.2014','Kampung Baru'),
('18.06.16.2015','Martanda'),
('18.06.17','Kelumbayan'),
('18.06.17.2001','Negeri Kelumbayan'),
('18.06.17.2002','Pekon Susuk'),
('18.06.17.2003','Napal'),
('18.06.17.2005','Pekon Unggak'),
('18.06.17.2006','Penyandingan'),
('18.06.17.2009','Paku'),
('18.06.17.2010','Umbar'),
('18.06.17.2012','Kiluan Negeri'),
('18.06.18','Kota Agung Barat'),
('18.06.18.2001','Belu'),
('18.06.18.2002','Negara Batin'),
('18.06.18.2003','Banjar Masin'),
('18.06.18.2004','Kanyangan'),
('18.06.18.2005','Kandang Besi'),
('18.06.18.2006','Teba Bunuk'),
('18.06.18.2007','Way Gelang'),
('18.06.18.2008','Tala Gening'),
('18.06.18.2009','Gedung Jambu'),
('18.06.18.2010','Maja'),
('18.06.18.2011','Pulau Benawang'),
('18.06.18.2012','Payung'),
('18.06.18.2013','Kesugihan'),
('18.06.18.2014','Pejajaran'),
('18.06.18.2015','Kalimiring'),
('18.06.18.2016','Tanjung Agung'),
('18.06.19','Kota Agung Timur'),
('18.06.19.2001','Batu Kramat'),
('18.06.19.2002','Kampung Baru'),
('18.06.19.2003','Umbul Buah'),
('18.06.19.2004','Menggala'),
('18.06.19.2005','Mulang Maya'),
('18.06.19.2006','Sukabanjar'),
('18.06.19.2007','Tanjung Anom'),
('18.06.19.2008','Kagungan'),
('18.06.19.2009','Kerta'),
('18.06.19.2010','Teba'),
('18.06.19.2011','Talang Rejo'),
('18.06.19.2012','Tanjung Jati'),
('18.06.20','Gisting'),
('18.06.20.2001','Banjar Manis'),
('18.06.20.2002','Campang'),
('18.06.20.2003','Kuta Dalom'),
('18.06.20.2004','Purwodadi'),
('18.06.20.2005','Gisting Bawah'),
('18.06.20.2006','Gisting Atas'),
('18.06.20.2007','Sidokaton'),
('18.06.20.2008','Landbaw'),
('18.06.20.2009','Gisting Permai'),
('18.06.21','Gunung Alip'),
('18.06.21.2001','Banjar Negeri'),
('18.06.21.2002','Sukaraja'),
('18.06.21.2003','Banjar Agung'),
('18.06.21.2004','Kedaloman'),
('18.06.21.2005','Sukabanjar'),
('18.06.21.2006','Sukamernah'),
('18.06.21.2007','Ciherang'),
('18.06.21.2008','Pariaman'),
('18.06.21.2009','Sukadamai'),
('18.06.21.2010','Way Halom'),
('18.06.21.2011','Penanggungan'),
('18.06.21.2012','Darussalam'),
('18.06.24','Limau'),
('18.06.24.2001','Badak'),
('18.06.24.2002','Kuripan'),
('18.06.24.2003','Padang Ratu'),
('18.06.24.2004','Tegineneng'),
('18.06.24.2005','Ketapang'),
('18.06.24.2006','Banjar Agung'),
('18.06.24.2007','Pekon Ampai'),
('18.06.24.2008','Pariaman'),
('18.06.24.2009','Atar Brak'),
('18.06.24.2010','Tanjung Siom'),
('18.06.24.2011','Tanjung Jaya'),
('18.06.25','Bandar Negeri Semuong'),
('18.06.25.2001','Negeri Agung'),
('18.06.25.2002','Bandar Sukabumi'),
('18.06.25.2003','Sanggi'),
('18.06.25.2004','Rajabasa'),
('18.06.25.2005','Banding'),
('18.06.25.2006','Gunung Doh'),
('18.06.25.2007','Simpang Bayur'),
('18.06.25.2008','Atar Lebar'),
('18.06.25.2009','Sinar Bangun'),
('18.06.25.2010','Sanggi Unggak'),
('18.06.25.2011','Tulung Sari'),
('18.06.26','Air Naningan'),
('18.06.26.2001','Way Harong'),
('18.06.26.2002','Air Kubang'),
('18.06.26.2003','Karang Sari'),
('18.06.26.2004','Sidomulyo'),
('18.06.26.2005','Air Naningan'),
('18.06.26.2006','Datar Lebuay'),
('18.06.26.2007','Sinar Jawa'),
('18.06.26.2008','Batu Tegi'),
('18.06.26.2009','Sinar Sekampung'),
('18.06.26.2010','Margomulyo'),
('18.06.27','Bulok'),
('18.06.27.2001','Sukamara'),
('18.06.27.2002','Sukanegara'),
('18.06.27.2003','Banjarmasin'),
('18.06.27.2004','Suka Agung Barat'),
('18.06.27.2005','Suka Agung'),
('18.06.27.2006','Gunung Terang'),
('18.06.27.2007','Napal'),
('18.06.27.2008','Sinar Petir'),
('18.06.27.2009','Pematang Nebak'),
('18.06.27.2010','Tanjung Sari'),
('18.06.28','Kelumbayan Barat'),
('18.06.28.2001','Lengkukai'),
('18.06.28.2002','Sidoharjo'),
('18.06.28.2003','Merbau'),
('18.06.28.2004','Batu Patah'),
('18.06.28.2005','Purwosari'),
('18.06.28.2006','Marga Mulya'),
('18.07','Kabupaten Lampung Timur'),
('18.07.01','Sukadana'),
('18.07.01.2001','Sukadana'),
('18.07.01.2002','Pakuan Aji'),
('18.07.01.2003','Bumi Nabung Udik'),
('18.07.01.2004','Rajabasa Batanghari'),
('18.07.01.2005','Negara Nabung'),
('18.07.01.2006','Terbangi Marga'),
('18.07.01.2007','Mataram Marga'),
('18.07.01.2008','Pasar Sukadana'),
('18.07.01.2009','Surabaya Udik'),
('18.07.01.2010','Rantau Jaya Udik'),
('18.07.01.2011','Muara Jaya'),
('18.07.01.2012','Sukadana Ilir'),
('18.07.01.2013','Bumi Ayu'),
('18.07.01.2014','Sukadana Timur'),
('18.07.01.2015','Rantau Jaya Udik II'),
('18.07.01.2016','Putra Aji II'),
('18.07.01.2017','Putra Aji I'),
('18.07.01.2018','Sukadana Selatan'),
('18.07.01.2019','Sukadana Jaya'),
('18.07.01.2020','Sukadana Tengah'),
('18.07.02','Labuhan Maringgai'),
('18.07.02.2001','Labuhan Maringgai'),
('18.07.02.2002','Muara Gading Mas'),
('18.07.02.2003','Sriminosari'),
('18.07.02.2004','Bandar Negeri'),
('18.07.02.2005','Karya Makmur'),
('18.07.02.2006','Karya Tani'),
('18.07.02.2007','Margasari'),
('18.07.02.2008','Sukorahayu'),
('18.07.02.2009','Srigading'),
('18.07.02.2010','Karang Anyar'),
('18.07.02.2011','Maringgai'),
('18.07.03','Jabung'),
('18.07.03.2001','Negara Batin'),
('18.07.03.2002','Asahan'),
('18.07.03.2003','Adirejo'),
('18.07.03.2004','Gunung Mekar'),
('18.07.03.2005','Gunung Sugih Kecil'),
('18.07.03.2006','Pematang Tahalo'),
('18.07.03.2007','Jabung'),
('18.07.03.2008','Negara Saka'),
('18.07.03.2014','Betengsari'),
('18.07.03.2015','Belimbing Sari'),
('18.07.03.2016','Mekar Jaya'),
('18.07.03.2018','Mumbang Jaya'),
('18.07.03.2019','Tanjung Sari'),
('18.07.03.2020','Adi Luhur'),
('18.07.03.2021','Sambirejo'),
('18.07.04','Pekalongan'),
('18.07.04.2001','Pekalongan'),
('18.07.04.2002','Adirejo'),
('18.07.04.2003','Sidodadi'),
('18.07.04.2004','Gondangrejo'),
('18.07.04.2005','Siraman'),
('18.07.04.2006','Tulusrejo'),
('18.07.04.2007','Jojog'),
('18.07.04.2008','Ganti Warno'),
('18.07.04.2009','Kalibening'),
('18.07.04.2010','Wonosari'),
('18.07.04.2011','Gantimulyo'),
('18.07.04.2012','Adijaya'),
('18.07.05','Sekampung'),
('18.07.05.2001','Sumber Gede'),
('18.07.05.2002','Sidomukti'),
('18.07.05.2003','Sidomulyo'),
('18.07.05.2004','Trimulyo'),
('18.07.05.2005','Girikarto'),
('18.07.05.2006','Hargomulyo'),
('18.07.05.2007','Wonokarto'),
('18.07.05.2008','Sukoharjo'),
('18.07.05.2009','Giriklopomulyo'),
('18.07.05.2010','Sidodadi'),
('18.07.05.2011','Sambikarto'),
('18.07.05.2012','Sumber Sari'),
('18.07.05.2013','Karya Mukti'),
('18.07.05.2014','Mekar Mulya'),
('18.07.05.2015','Jadi Mulyo'),
('18.07.05.2016','Mekar Mukti'),
('18.07.05.2017','Mekar Sari'),
('18.07.06','Batanghari'),
('18.07.06.2001','Banarjoyo'),
('18.07.06.2002','Buana Sakti'),
('18.07.06.2003','Balekencono'),
('18.07.06.2004','Rejo Agung'),
('18.07.06.2005','Adiwarno'),
('18.07.06.2006','Telogorejo'),
('18.07.06.2007','Nampirejo'),
('18.07.06.2008','Sumberejo'),
('18.07.06.2009','Banjarejo'),
('18.07.06.2010','Balerejo'),
('18.07.06.2011','Batangharjo'),
('18.07.06.2012','Bumi Harjo'),
('18.07.06.2013','Bumi Mas'),
('18.07.06.2014','Selorejo'),
('18.07.06.2015','Sri Basuki'),
('18.07.06.2016','Sumber Agung'),
('18.07.06.2017','Purwodadi Mekar'),
('18.07.07','Way Jepara'),
('18.07.07.2001','Braja Sakti'),
('18.07.07.2002','Braja Fajar'),
('18.07.07.2003','Braja Emas'),
('18.07.07.2004','Braja Dewa'),
('18.07.07.2005','Braja Caka'),
('18.07.07.2006','Sri Wangi'),
('18.07.07.2007','Jepara'),
('18.07.07.2008','Sri Rejosari'),
('18.07.07.2009','Sumberejo'),
('18.07.07.2010','Labuhan Ratu II'),
('18.07.07.2011','Braja Asri'),
('18.07.07.2012','Labuhan Ratu I'),
('18.07.07.2013','Sumur Bandung'),
('18.07.07.2014','Sumber Marga'),
('18.07.07.2015','Labuhan Ratu Danau'),
('18.07.07.2016','Labuhan Ratu Baru'),
('18.07.08','Purbolinggo'),
('18.07.08.2001','Taman Fajar'),
('18.07.08.2002','Taman Asri'),
('18.07.08.2003','Taman Bogo'),
('18.07.08.2004','Tambah Dadi'),
('18.07.08.2005','Taman Cari'),
('18.07.08.2006','Taman Endah'),
('18.07.08.2007','Tegal Gondo'),
('18.07.08.2008','Toto Harjo'),
('18.07.08.2009','Tanjung Inten'),
('18.07.08.2010','Tegal Yoso'),
('18.07.08.2011','Tambah Luhur'),
('18.07.08.2012','Tanjung Kesuma'),
('18.07.09','Raman Utara'),
('18.07.09.2001','Kota Raman'),
('18.07.09.2002','Raman Aji'),
('18.07.09.2003','Rukti Sedyo'),
('18.07.09.2004','Ratna Daya'),
('18.07.09.2005','Rejo Binangun'),
('18.07.09.2006','Rantau Fajar'),
('18.07.09.2007','Raman Endra'),
('18.07.09.2008','Raman Fajar'),
('18.07.09.2009','Restu Rahayu'),
('18.07.09.2010','Rejo Katon'),
('18.07.09.2011','Rama Puja'),
('18.07.10','Metro Kibang'),
('18.07.10.2001','Kibang'),
('18.07.10.2002','Marga Jaya'),
('18.07.10.2003','Margototo'),
('18.07.10.2004','Purbosembodo'),
('18.07.10.2005','Sumber Agung'),
('18.07.10.2006','Margasari'),
('18.07.10.2007','Jaya Asri'),
('18.07.11','Marga Tiga'),
('18.07.11.2001','Tanjung Harapan'),
('18.07.11.2002','Negeri Tua'),
('18.07.11.2003','Negeri Katon'),
('18.07.11.2004','Negeri Agung'),
('18.07.11.2005','Negeri Jemanten'),
('18.07.11.2006','Sukaraja Tiga'),
('18.07.11.2007','Gedung Wani'),
('18.07.11.2008','Jaya Guna'),
('18.07.11.2009','Sukadana Baru'),
('18.07.11.2010','Nabang Baru'),
('18.07.11.2011','Surya Mataram'),
('18.07.11.2012','Gedungwani Timur'),
('18.07.11.2013','Trisinar'),
('18.07.12','Sekampung Udik'),
('18.07.12.2001','Pugung Raharjo'),
('18.07.12.2002','Mengandung Sari'),
('18.07.12.2003','Toba'),
('18.07.12.2004','Banjar Agung'),
('18.07.12.2005','Bojong'),
('18.07.12.2006','Gunung Agung'),
('18.07.12.2007','Sindang Anom'),
('18.07.12.2008','Bauh Gunung Sari'),
('18.07.12.2009','Gunung Pasir Jaya'),
('18.07.12.2010','Gunung Sugih Besar'),
('18.07.12.2011','Sidorejo'),
('18.07.12.2012','Brawijaya'),
('18.07.12.2013','Gunung Mulyo'),
('18.07.12.2014','Bumi Mulyo'),
('18.07.12.2015','Purwokencono'),
('18.07.13','Batanghari Nuban'),
('18.07.13.2001','Sukaraja Nuban'),
('18.07.13.2002','Purwosari'),
('18.07.13.2003','Tulung Balak'),
('18.07.13.2004','Kedaton'),
('18.07.13.2005','Kedaton I'),
('18.07.13.2006','Kedaton II'),
('18.07.13.2007','Trisnomulyo'),
('18.07.13.2008','Cempaka Nuban'),
('18.07.13.2009','Gedung Dalem'),
('18.07.13.2010','Bumi Jawa'),
('18.07.13.2011','Gunung Tiga'),
('18.07.13.2012','Negara Ratu'),
('18.07.13.2013','Sukacari'),
('18.07.14','Bumi Agung'),
('18.07.14.2001','Donomulyo'),
('18.07.14.2002','Nyampir'),
('18.07.14.2003','Bumi Tinggi'),
('18.07.14.2004','Lehan'),
('18.07.14.2005','Marga Mulya'),
('18.07.14.2006','Catur Swako'),
('18.07.14.2007','Mulyo Asri'),
('18.07.15','Bandar Sribhawono'),
('18.07.15.2001','Sribhawono'),
('18.07.15.2002','Sadar Sriwijaya'),
('18.07.15.2003','Srimenanti'),
('18.07.15.2004','Sripendowo'),
('18.07.15.2005','Waringin Jaya'),
('18.07.15.2006','Bandar Agung'),
('18.07.15.2007','Mekar Jaya'),
('18.07.16','Mataram Baru'),
('18.07.16.2001','Mataram Baru'),
('18.07.16.2002','Rajabasa Baru'),
('18.07.16.2003','Teluk Dalem'),
('18.07.16.2004','Way Areng'),
('18.07.16.2005','Tulung Pasik'),
('18.07.16.2006','Mandala Sari'),
('18.07.16.2007','Kebon Damar'),
('18.07.17','Melinting'),
('18.07.17.2001','Wana'),
('18.07.17.2002','Tanjung Aji'),
('18.07.17.2003','Tebing'),
('18.07.17.2004','Sido Makmur'),
('18.07.17.2005','Itik Renday'),
('18.07.17.2006','Sumber Hadi'),
('18.07.18','Gunung Pelindung'),
('18.07.18.2001','Negeri Agung'),
('18.07.18.2002','Pempen'),
('18.07.18.2003','Way Mili'),
('18.07.18.2004','Pelindung Jaya'),
('18.07.18.2005','Nibung'),
('18.07.19','Pasir Sakti'),
('18.07.19.2001','Pasir Sakti'),
('18.07.19.2002','Mulyo Sari'),
('18.07.19.2003','Purworejo'),
('18.07.19.2004','Rejo Mulyo'),
('18.07.19.2005','Kedung Ringin'),
('18.07.19.2006','Labuhan Ratu'),
('18.07.19.2007','Sumur Kucing'),
('18.07.19.2008','Mekar Sari'),
('18.07.20','Waway Karya'),
('18.07.20.2001','Sumberejo'),
('18.07.20.2002','Ngesti Karya'),
('18.07.20.2003','Tri Tunggal'),
('18.07.20.2004','Sidorahayu'),
('18.07.20.2005','Jembrana'),
('18.07.20.2006','Tanjung Wangi'),
('18.07.20.2007','Marga Batin'),
('18.07.20.2008','Mekar Karya'),
('18.07.20.2009','Sumber Jaya'),
('18.07.20.2010','Karang Anom'),
('18.07.20.2011','Karya Basuki'),
('18.07.21','Labuhan Ratu'),
('18.07.21.2001','Labuhan Ratu'),
('18.07.21.2002','Labuhan Ratu III'),
('18.07.21.2003','Labuhan Ratu IV'),
('18.07.21.2004','Labuhan Ratu V'),
('18.07.21.2005','Labuhan Ratu VI'),
('18.07.21.2006','Rajabasa Lama'),
('18.07.21.2007','Rajabasa Lama I'),
('18.07.21.2008','Rajabasa Lama II'),
('18.07.21.2009','Labuhan Ratu VII'),
('18.07.21.2010','Labuhan Ratu VIII'),
('18.07.21.2011','Labuhan Ratu IX'),
('18.07.22','Braja Selebah'),
('18.07.22.2001','Braja Harjosari'),
('18.07.22.2002','Braja Gemilang'),
('18.07.22.2003','Braja Indah'),
('18.07.22.2004','Braja Yekti'),
('18.07.22.2005','Braja Kencana'),
('18.07.22.2006','Braja Luhur'),
('18.07.22.2007','Braja Mulya'),
('18.07.23','Way Bungur'),
('18.07.23.2001','Tambah Subur'),
('18.07.23.2002','Tanjung Qencono'),
('18.07.23.2003','Tanjung Tirto'),
('18.07.23.2004','Toto Mulyo'),
('18.07.23.2005','Toto Projo'),
('18.07.23.2006','Taman Negeri'),
('18.07.23.2007','Tegal Ombo'),
('18.07.23.2008','Kali Pasir'),
('18.07.24','Marga Sekampung'),
('18.07.24.2001','Bungkuk'),
('18.07.24.2002','Batu Badak'),
('18.07.24.2003','Peniangan'),
('18.07.24.2004','Gunung Raya'),
('18.07.24.2005','Giri Mulyo'),
('18.07.24.2006','Gunung Mas'),
('18.07.24.2007','Purwosari'),
('18.07.24.2008','Bukit Raya'),
('18.08','Kabupaten Way Kanan'),
('18.08.01','Blambangan Umpu'),
('18.08.01.1005','Blambangan Umpu'),
('18.08.01.2006','Lembasung'),
('18.08.01.2009','Gunung Sangkaran'),
('18.08.01.2010','Tanjung Raja Giham'),
('18.08.01.2011','Segara Mider'),
('18.08.01.2012','Umpu Bhakti'),
('18.08.01.2013','Sangkaran Bhakti'),
('18.08.01.2014','Bumi Baru'),
('18.08.01.2015','Tanjung Sari'),
('18.08.01.2016','Sri Rejeki'),
('18.08.01.2017','Karang Umpu'),
('18.08.01.2018','Umpu Kencana'),
('18.08.01.2022','Tanjung Raja Sakti'),
('18.08.02','Kasui'),
('18.08.02.1004','Kasui Pasar'),
('18.08.02.2001','Datar Bancong'),
('18.08.02.2002','Kedaton'),
('18.08.02.2003','Karang Lantang'),
('18.08.02.2005','Kasui Lama'),
('18.08.02.2006','Kampung Baru'),
('18.08.02.2007','Jukuh Kemuning'),
('18.08.02.2008','Kotaway'),
('18.08.02.2009','Tanjung Kurung'),
('18.08.02.2010','Talang Mangga'),
('18.08.02.2011','Tanjung Harapan'),
('18.08.02.2012','Sinar Gading'),
('18.08.02.2013','Jaya Tinggi'),
('18.08.02.2014','Sukajadi'),
('18.08.02.2015','Gelombang Panjang'),
('18.08.02.2016','Tangkas'),
('18.08.02.2017','Tanjung Bulan'),
('18.08.02.2018','Tanjung Kurung Lama'),
('18.08.02.2019','Bukit Batu'),
('18.08.03','Banjit'),
('18.08.03.1006','Pasar Banjit'),
('18.08.03.2001','Bonglai'),
('18.08.03.2002','Campang Lapan'),
('18.08.03.2003','Sumber Baru'),
('18.08.03.2004','Rantau Temiang'),
('18.08.03.2005','Juku Batu'),
('18.08.03.2007','Bali Sadhar Tengah'),
('18.08.03.2008','Donomulyo'),
('18.08.03.2009','Bali Sadhar Utara'),
('18.08.03.2010','Bali Sadhar Selatan'),
('18.08.03.2011','Menanga Jaya'),
('18.08.03.2012','Argomulyo'),
('18.08.03.2013','Rantau Jaya'),
('18.08.03.2014','Rebang Tinggi'),
('18.08.03.2015','Simpang Asam'),
('18.08.03.2016','Bandar Agung'),
('18.08.03.2017','Kemu'),
('18.08.03.2018','Menanga Siamang'),
('18.08.03.2019','Neki'),
('18.08.03.2020','Sumber Sari'),
('18.08.04','Baradatu'),
('18.08.04.1009','Taman Asri'),
('18.08.04.1015','Tiuh Balak Pasar'),
('18.08.04.1016','Campur Asri'),
('18.08.04.2001','Setia Negara'),
('18.08.04.2002','Gedung Pakuon'),
('18.08.04.2003','Bumi Merapi'),
('18.08.04.2004','Banjar Sari'),
('18.08.04.2005','Gunung Katun'),
('18.08.04.2006','Bhakti Negara'),
('18.08.04.2007','Bumi Rejo'),
('18.08.04.2008','Sukosari'),
('18.08.04.2010','Banjar Setia'),
('18.08.04.2011','Gedung Rejo'),
('18.08.04.2012','Banjar Agung'),
('18.08.04.2013','Cugah'),
('18.08.04.2014','Tiuh Balak I'),
('18.08.04.2017','Tiuh Balak'),
('18.08.04.2018','Mekar Asri'),
('18.08.04.2019','Banjar Negara'),
('18.08.04.2020','Banjar Masin'),
('18.08.04.2021','Banjar Mulya'),
('18.08.04.2022','Banjar Baru'),
('18.08.05','Bahuga'),
('18.08.05.2001','Tulang Bawang'),
('18.08.05.2002','Mesir Udik'),
('18.08.05.2005','Mesir Ilir'),
('18.08.05.2006','Sapto Renggo'),
('18.08.05.2007','Giri Harjo'),
('18.08.05.2009','Bumi Agung Wates'),
('18.08.05.2017','Serdang Kuring'),
('18.08.05.2024','Bumi Agung'),
('18.08.05.2025','Mekar Jaya'),
('18.08.05.2026','Kota Dewa'),
('18.08.05.2027','Dewa Agung'),
('18.08.06','Pakuan Ratu'),
('18.08.06.2001','Karang Agung'),
('18.08.06.2002','Tanjung Ratu'),
('18.08.06.2003','Pakuan Ratu'),
('18.08.06.2004','Gunung Cahya'),
('18.08.06.2005','Rumbih'),
('18.08.06.2006','Negara Ratu'),
('18.08.06.2007','Negara Sakti'),
('18.08.06.2008','Suka Bumi'),
('18.08.06.2009','Tanjung Agung'),
('18.08.06.2010','Tanjung Serupa'),
('18.08.06.2011','Negara Harja'),
('18.08.06.2012','Bakti Negara'),
('18.08.06.2013','Pakuan Baru'),
('18.08.06.2014','Negara Tama'),
('18.08.06.2015','Way Tawar'),
('18.08.06.2016','Gunung Waras'),
('18.08.06.2017','Pakuan Sakti'),
('18.08.06.2018','Serupa Indah'),
('18.08.06.2019','Bumi Mulya'),
('18.08.07','Negeri Agung'),
('18.08.07.2001','Negeri Agung'),
('18.08.07.2002','Bandar Dalam'),
('18.08.07.2003','Pulau Batu'),
('18.08.07.2004','Penengahan'),
('18.08.07.2005','Karya Agung'),
('18.08.07.2006','Sunsang'),
('18.08.07.2007','Kota Baru'),
('18.08.07.2008','Kotabumi Way Kanan'),
('18.08.07.2009','Gedung Menang'),
('18.08.07.2010','Gedung Harapan'),
('18.08.07.2011','Tanjung Rejo'),
('18.08.07.2012','Kali Papan'),
('18.08.07.2013','Mulya Sari'),
('18.08.07.2014','Way Limau'),
('18.08.07.2015','Gedung Jaya'),
('18.08.07.2016','Rejo Sari'),
('18.08.07.2017','Bandar Kasih'),
('18.08.07.2018','Sumber Rejeki'),
('18.08.07.2019','Mulya Agung'),
('18.08.08','Way Tuba'),
('18.08.08.2001','Way Tuba'),
('18.08.08.2002','Karya Jaya'),
('18.08.08.2003','Say Umpu'),
('18.08.08.2004','Beringin Jaya'),
('18.08.08.2005','Suma Mukti'),
('18.08.08.2006','Ramsai'),
('18.08.08.2007','Bandar Sari'),
('18.08.08.2008','Bumi Dana'),
('18.08.08.2009','Bukit Gemuruh'),
('18.08.08.2010','Way Mencar'),
('18.08.08.2011','Way Pisang'),
('18.08.08.2012','Bukit Harapan'),
('18.08.08.2013','Way Tuba Asri'),
('18.08.09','Rebang Tangkas'),
('18.08.09.2001','Lebak Peniangan'),
('18.08.09.2002','Tanjung Tiga'),
('18.08.09.2003','Madang Jaya'),
('18.08.09.2004','Air Ringkih'),
('18.08.09.2005','Gunung Sari'),
('18.08.09.2006','Simpang Tiga'),
('18.08.09.2007','Tanjung Raya'),
('18.08.09.2008','Beringin Jaya'),
('18.08.09.2009','Karya Maju'),
('18.08.09.2010','Mulya Jaya'),
('18.08.10','Gunung Labuhan'),
('18.08.10.2001','Gunung Labuhan'),
('18.08.10.2002','Gunung Baru'),
('18.08.10.2003','Banjar Sakti'),
('18.08.10.2004','Suka Negeri'),
('18.08.10.2005','Negeri Mulya'),
('18.08.10.2006','Negeri Sungkai'),
('18.08.10.2007','Gunung Sari'),
('18.08.10.2008','Way Tuba'),
('18.08.10.2009','Bengkulu'),
('18.08.10.2010','Bengkulu Rejo'),
('18.08.10.2011','Kayu Batu'),
('18.08.10.2012','Bengkulu Raman'),
('18.08.10.2013','Bengkulu Jaya'),
('18.08.10.2014','Tiuh Balak II'),
('18.08.10.2015','Curup Patah'),
('18.08.10.2016','Sukarame'),
('18.08.10.2017','Banjar Ratu'),
('18.08.10.2018','Negeri Ujan Mas'),
('18.08.10.2019','Bengkulu Tengah'),
('18.08.10.2020','Gunung Pekuwon'),
('18.08.10.2021','Labuhan Jaya'),
('18.08.11','Negara Batin'),
('18.08.11.2001','Negara Batin'),
('18.08.11.2002','Purwa Agung'),
('18.08.11.2003','Purwa Negara'),
('18.08.11.2004','Setia Negara'),
('18.08.11.2005','Sri Mulyo'),
('18.08.11.2006','Sri Menanti'),
('18.08.11.2007','Karta Jaya'),
('18.08.11.2008','Gisting Jaya'),
('18.08.11.2009','Marga Jaya'),
('18.08.11.2010','Bumi Jaya'),
('18.08.11.2011','Gedung Jaya'),
('18.08.11.2012','Adi Jaya'),
('18.08.11.2013','Sari Jaya'),
('18.08.11.2014','Negara Mulya'),
('18.08.11.2015','Kota Jawa'),
('18.08.12','Negeri Besar'),
('18.08.12.2001','Negeri Besar'),
('18.08.12.2002','Kiling-kiling'),
('18.08.12.2003','Kali Awi'),
('18.08.12.2004','Tiuh Baru'),
('18.08.12.2005','Bima Sakti'),
('18.08.12.2006','Tegal Mukti'),
('18.08.12.2007','Negara Jaya'),
('18.08.12.2008','Pagar Iman'),
('18.08.12.2009','Sri Basuki'),
('18.08.12.2010','Kali Awi Indah'),
('18.08.12.2011','Negeri Jaya'),
('18.08.12.2012','Tanjung Mas'),
('18.08.12.2013','Negeri Kasih'),
('18.08.13','Buay Bahuga'),
('18.08.13.2001','Bumiharjo'),
('18.08.13.2002','Punjul Agung'),
('18.08.13.2003','Sritunggal'),
('18.08.13.2004','Suka Bumi'),
('18.08.13.2005','Suka Agung'),
('18.08.13.2006','Sukadana'),
('18.08.13.2007','Nuar Maju'),
('18.08.13.2008','Lebung Lawe'),
('18.08.13.2009','Way Agung'),
('18.08.14','Bumi Agung'),
('18.08.14.2001','Pisang Baru'),
('18.08.14.2002','Pisang Indah'),
('18.08.14.2003','Srinumpi'),
('18.08.14.2004','Mulyoharjo'),
('18.08.14.2005','Bumi Agung'),
('18.08.14.2006','Karangan'),
('18.08.14.2007','Wonoharjo'),
('18.08.14.2008','Sukamaju'),
('18.08.14.2009','Tanjung Dalam'),
('18.08.14.2010','Bumi Say Agung'),
('18.08.15','Umpu Semenguk'),
('18.08.15.2001','Negeri Batin'),
('18.08.15.2002','Gistang'),
('18.08.15.2003','Rambang Jaya'),
('18.08.15.2004','Panca Negeri'),
('18.08.15.2005','Negeri Bumi Putera'),
('18.08.15.2006','Gedung Riang'),
('18.08.15.2007','Gedung Batin'),
('18.08.15.2008','Sidoarjo'),
('18.08.15.2009','Bumi Ratu'),
('18.08.15.2010','Sriwijaya'),
('18.08.15.2011','Bratayudha'),
('18.08.15.2012','Negeri Baru'),
('18.08.15.2013','Ojo Lali'),
('18.09','Kabupaten Pesawaran'),
('18.09.01','Gedong Tataan'),
('18.09.01.2001','Padang Ratu'),
('18.09.01.2002','Pampangan'),
('18.09.01.2003','Cipadang'),
('18.09.01.2004','Way Layap'),
('18.09.01.2005','Sukadadi'),
('18.09.01.2006','Gedung Tataan'),
('18.09.01.2007','Bagelen'),
('18.09.01.2008','Sukaraja'),
('18.09.01.2009','Kebagusan'),
('18.09.01.2010','Sungai Langka'),
('18.09.01.2011','Kurungan Nyawa'),
('18.09.01.2012','Negeri Sakti'),
('18.09.01.2013','Bernung'),
('18.09.01.2014','Suka Banjar'),
('18.09.01.2015','Wiyono'),
('18.09.01.2016','Taman Sari'),
('18.09.01.2017','Bogorejo'),
('18.09.01.2018','Karang Anyar'),
('18.09.01.2019','Kutoarjo'),
('18.09.02','Negeri Katon'),
('18.09.02.2001','Kagungan Ratu'),
('18.09.02.2002','Kali Rejo'),
('18.09.02.2003','Purworejo'),
('18.09.02.2004','Pujo Rahayu'),
('18.09.02.2005','Negeri Katon'),
('18.09.02.2006','Ponco Kresno'),
('18.09.02.2007','Halangan Ratu'),
('18.09.02.2008','Pejambon'),
('18.09.02.2009','Negara Saka'),
('18.09.02.2010','Sinar Bandung'),
('18.09.02.2011','Tanjung Rejo'),
('18.09.02.2012','Rowo Rejo'),
('18.09.02.2013','Tresno Maju'),
('18.09.02.2014','Sidomulyo'),
('18.09.02.2015','Lumbirejo'),
('18.09.02.2016','Tri Rahayu'),
('18.09.02.2017','Bangun Sari'),
('18.09.02.2018','Karang Rejo'),
('18.09.02.2019','Negeri Ulangan Jaya'),
('18.09.02.2020','Pujodadi'),
('18.09.02.2021','Grujugan Baru'),
('18.09.03','Tegineneng'),
('18.09.03.2001','Bumi Agung'),
('18.09.03.2002','Kejadian'),
('18.09.03.2003','Batang Hari Ogan'),
('18.09.03.2004','Negara Ratu Wates'),
('18.09.03.2005','Gunung Sugih Baru'),
('18.09.03.2006','Gedung Gumanti'),
('18.09.03.2007','Kresno Widodo'),
('18.09.03.2008','Sinarjati'),
('18.09.03.2009','Margo Rejo'),
('18.09.03.2010','Gerning'),
('18.09.03.2011','Panca Bakti'),
('18.09.03.2012','Margo Mulyo'),
('18.09.03.2013','Rejo Agung'),
('18.09.03.2014','Kota Agung'),
('18.09.03.2015','Trimulyo'),
('18.09.03.2016','Sriwedari'),
('18.09.04','Way Lima'),
('18.09.04.2001','Padang Manis'),
('18.09.04.2002','Banjar Negeri'),
('18.09.04.2003','Sidodadi'),
('18.09.04.2004','Pekondoh Gedung'),
('18.09.04.2005','Pekondoh'),
('18.09.04.2006','Kota Dalam'),
('18.09.04.2007','Tanjung Agung'),
('18.09.04.2008','Gedong Dalam'),
('18.09.04.2009','Sindang Garut'),
('18.09.04.2010','Baturaja'),
('18.09.04.2011','Way Harong'),
('18.09.04.2012','Gunung Rejo'),
('18.09.04.2013','Margodadi'),
('18.09.04.2014','Cimanuk'),
('18.09.04.2015','Sukamandi'),
('18.09.04.2016','Paguyuban'),
('18.09.05','Padang Cermin'),
('18.09.05.2001','Banjaran'),
('18.09.05.2004','Durian'),
('18.09.05.2009','Hanau Berak'),
('18.09.05.2010','Paya'),
('18.09.05.2011','Padang Cermin'),
('18.09.05.2012','Sanggi'),
('18.09.05.2016','Tambangan'),
('18.09.05.2017','Way Urang'),
('18.09.05.2025','Khepong Jaya'),
('18.09.05.2026','Trimulyo'),
('18.09.05.2031','Gayau'),
('18.09.05.2032','Dantar'),
('18.09.06','Punduh Pidada'),
('18.09.06.2001','Bawang'),
('18.09.06.2002','Banding Agung'),
('18.09.06.2003','Batu Raja'),
('18.09.06.2004','Sukajaya Pidada'),
('18.09.06.2005','Rusaba'),
('18.09.06.2006','Kota Jawa'),
('18.09.06.2016','Sukarame'),
('18.09.06.2017','Pagar Jaya'),
('18.09.06.2019','Pulau Legundi'),
('18.09.06.2020','Suka Maju'),
('18.09.06.2021','Bangun Rejo'),
('18.09.07','Kedondong'),
('18.09.07.2008','Way Kepayang'),
('18.09.07.2009','Suka Maju'),
('18.09.07.2010','Kedondong'),
('18.09.07.2011','Pasar Baru'),
('18.09.07.2012','Tempel Rejo'),
('18.09.07.2013','Kertasana'),
('18.09.07.2014','Gunung Sugih'),
('18.09.07.2017','Sinar Harapan'),
('18.09.07.2018','Teba Jawa'),
('18.09.07.2019','Babakan Loa'),
('18.09.07.2020','Pesawaran Indah'),
('18.09.07.2021','Harapan Jaya'),
('18.09.08','Marga Punduh'),
('18.09.08.2001','Sukajaya Punduh'),
('18.09.08.2002','Maja'),
('18.09.08.2003','Penyandingan'),
('18.09.08.2004','Tajur'),
('18.09.08.2005','Umbul Limus'),
('18.09.08.2006','Pekon Ampai'),
('18.09.08.2007','Kunyaian'),
('18.09.08.2008','Kekatang'),
('18.09.08.2009','Kampung Baru'),
('18.09.08.2010','Pulau Pahawang'),
('18.09.09','Way Khilau'),
('18.09.09.2001','Penengahan'),
('18.09.09.2002','Suka Jaya'),
('18.09.09.2003','Padang Cermin'),
('18.09.09.2004','Bayas Jaya'),
('18.09.09.2005','Tanjung Kerta'),
('18.09.09.2006','Kota Jawa'),
('18.09.09.2007','Gunung Sari'),
('18.09.09.2008','Mada Jaya'),
('18.09.09.2009','Kubu Batu'),
('18.09.09.2010','Tanjung Rejo'),
('18.09.10','Teluk Pandan'),
('18.09.10.2001','Batu Menyan'),
('18.09.10.2002','Cilimus'),
('18.09.10.2003','Gebang'),
('18.09.10.2004','Hanura'),
('18.09.10.2005','Hurun'),
('18.09.10.2006','Munca'),
('18.09.10.2007','Sidodadi'),
('18.09.10.2008','Sukajaya Lempasing'),
('18.09.10.2009','Talang Mulya'),
('18.09.10.2010','Tanjung Agung'),
('18.09.11','Way Ratai'),
('18.09.11.2001','Bunut'),
('18.09.11.2002','Bunut Seberang'),
('18.09.11.2003','Wates Way Ratai'),
('18.09.11.2004','Ceringin Asri'),
('18.09.11.2005','Sumber Jaya'),
('18.09.11.2006','Mulyo Sari'),
('18.09.11.2007','Poncorejo'),
('18.09.11.2008','Gunung Rejo'),
('18.09.11.2009','Pesawaran Indah'),
('18.09.11.2010','Harapan Jaya'),
('18.09.11.2011','Kalirejo'),
('18.10','Kabupaten Pringsewu'),
('18.10.01','Pringsewu'),
('18.10.01.1001','Fajaresuk'),
('18.10.01.1002','Pringsewu Utara'),
('18.10.01.1003','Pringsewu Selatan'),
('18.10.01.1004','Pringsewu Barat'),
('18.10.01.1005','Pringsewu Timur'),
('18.10.01.2006','Margakaya'),
('18.10.01.2007','Waluyojati'),
('18.10.01.2008','Sidoharjo'),
('18.10.01.2009','Podomoro'),
('18.10.01.2010','Bumi Arum'),
('18.10.01.2011','Fajar Agung'),
('18.10.01.2012','Rejo Sari'),
('18.10.01.2013','Bumi Ayu'),
('18.10.01.2014','Podosari'),
('18.10.01.2015','Fajar Agung Barat'),
('18.10.02','Gading Rejo'),
('18.10.02.2001','Parerejo'),
('18.10.02.2002','Blitarejo'),
('18.10.02.2003','Panjerejo'),
('18.10.02.2004','Bulokarto'),
('18.10.02.2005','Wates'),
('18.10.02.2006','Tambahrejo'),
('18.10.02.2007','Wonodadi'),
('18.10.02.2008','Gadingrejo'),
('18.10.02.2009','Tegalsari'),
('18.10.02.2010','Tulung Agung'),
('18.10.02.2011','Bulurejo'),
('18.10.02.2012','Yogyakarta'),
('18.10.02.2013','Kediri'),
('18.10.02.2014','Mataram'),
('18.10.02.2015','Wonosari'),
('18.10.02.2016','Klaten'),
('18.10.02.2017','Wates Timur'),
('18.10.02.2018','Wates Selatan'),
('18.10.02.2019','Gading Rejo Timur'),
('18.10.02.2020','Gading Rejo Utara'),
('18.10.02.2021','Tambah Rejo Barat'),
('18.10.02.2022','Wonodadi Utara'),
('18.10.02.2023','Yogyakarta Selatan'),
('18.10.03','Ambarawa'),
('18.10.03.2001','Ambarawa'),
('18.10.03.2002','Ambarawa Barat'),
('18.10.03.2003','Kresno Mulyo'),
('18.10.03.2004','Sumber Agung'),
('18.10.03.2005','Tanjung Anom'),
('18.10.03.2006','Jati Agung'),
('18.10.03.2007','Margodadi'),
('18.10.03.2008','Ambarawa Timur'),
('18.10.04','Pardasuka'),
('18.10.04.2001','Kedaung'),
('18.10.04.2002','Pardasuka'),
('18.10.04.2003','Suka Negeri'),
('18.10.04.2004','Tanjung Rusia'),
('18.10.04.2005','Warga Mulyo'),
('18.10.04.2006','Pujodadi'),
('18.10.04.2007','Sukorejo'),
('18.10.04.2008','Selapan'),
('18.10.04.2009','Rantau Tijang'),
('18.10.04.2010','Sidodadi'),
('18.10.04.2011','Pardasuka Timur'),
('18.10.04.2012','Tanjung Rusia Timur'),
('18.10.04.2013','Pardasuka Selatan'),
('18.10.05','Pagelaran'),
('18.10.05.2001','Candi Retno'),
('18.10.05.2002','Tanjung Dalom'),
('18.10.05.2003','Way Ngison'),
('18.10.05.2004','Suka Wangi'),
('18.10.05.2005','Suka Ratu'),
('18.10.05.2006','Pagelaran'),
('18.10.05.2007','Patoman'),
('18.10.05.2008','Karangsari'),
('18.10.05.2009','Gumuk Mas'),
('18.10.05.2010','Bumi Ratu'),
('18.10.05.2011','Panutan'),
('18.10.05.2012','Lugusari'),
('18.10.05.2019','Pamenang'),
('18.10.05.2020','Gemah Ripah'),
('18.10.05.2023','Pasir Ukir'),
('18.10.05.2024','Gumukrejo'),
('18.10.05.2027','Puji Harjo'),
('18.10.05.2028','Padang Rejo'),
('18.10.05.2029','Sidodadi'),
('18.10.05.2030','Sumber Rejo'),
('18.10.05.2031','Ganjaran'),
('18.10.05.2032','Bumi Rejo'),
('18.10.06','Banyumas'),
('18.10.06.2001','Banyumas'),
('18.10.06.2002','Banyuwangi'),
('18.10.06.2003','Sukamulya'),
('18.10.06.2004','Sriwungu'),
('18.10.06.2005','Banjarejo'),
('18.10.06.2006','Waya Krui'),
('18.10.06.2007','Sri Rahayu'),
('18.10.06.2008','Nusa Wungu'),
('18.10.06.2009','Sinar Mulya'),
('18.10.06.2010','Banyu Urip'),
('18.10.06.2011','Mulyo Rejo'),
('18.10.07','Adiluwih'),
('18.10.07.2001','Adiluwih'),
('18.10.07.2002','Bandung Baru'),
('18.10.07.2003','Sinarwayah'),
('18.10.07.2004','Enggal Rejo'),
('18.10.07.2005','Sukoharum'),
('18.10.07.2006','Waringin Sari Timur'),
('18.10.07.2007','Tri Tunggal Mulya'),
('18.10.07.2008','Purwodadi'),
('18.10.07.2009','Srikaton'),
('18.10.07.2010','Tunggul Pawenang'),
('18.10.07.2011','Bandung Baru Barat'),
('18.10.07.2012','Totokarto'),
('18.10.07.2013','Kuta Waringin'),
('18.10.08','Sukoharjo'),
('18.10.08.2001','Sinar Baru'),
('18.10.08.2002','Sukoharjo I'),
('18.10.08.2003','Sukoharjo II'),
('18.10.08.2004','Sukoharjo III'),
('18.10.08.2005','Sukoharjo IV'),
('18.10.08.2006','Panggungrejo'),
('18.10.08.2007','Pandan Sari'),
('18.10.08.2008','Pandan Surat'),
('18.10.08.2009','Keputran'),
('18.10.08.2010','Sukoyoso'),
('18.10.08.2011','Siliwangi'),
('18.10.08.2012','Waringinsari Barat'),
('18.10.08.2013','Pandan Sari Selatan'),
('18.10.08.2014','Sinar Baru Timur'),
('18.10.08.2015','Panggung Rejo Utara'),
('18.10.08.2016','Sukoharjo III Barat'),
('18.10.09','Pagelaran Utara'),
('18.10.09.2001','Fajar Baru'),
('18.10.09.2002','Kemilin'),
('18.10.09.2003','Neglasari'),
('18.10.09.2004','Fajar Mulia'),
('18.10.09.2005','Margosari'),
('18.10.09.2006','Giri Tunggal'),
('18.10.09.2007','Sumber Bandung'),
('18.10.09.2008','Madaraya'),
('18.10.09.2009','Way Kunir'),
('18.10.09.2010','Gunung Raya'),
('18.11','Kabupaten Mesuji'),
('18.11.01','Mesuji'),
('18.11.01.2001','Wiralaga I'),
('18.11.01.2002','Wiralaga II'),
('18.11.01.2003','Sungai Badak'),
('18.11.01.2004','Nipah Kuning'),
('18.11.01.2005','Sido Mulyo'),
('18.11.01.2006','Tirta Laga'),
('18.11.01.2007','Tanjung Serayan'),
('18.11.01.2008','Sumber Makmur'),
('18.11.01.2009','Mulya Sari'),
('18.11.01.2010','Wiralaga Mulya'),
('18.11.01.2011','Suka Maju'),
('18.11.02','Mesuji Timur'),
('18.11.02.2001','Talang Batu'),
('18.11.02.2002','Sungai Cambai'),
('18.11.02.2003','Tanjung Mas Makmur'),
('18.11.02.2004','Margo Jadi'),
('18.11.02.2005','Tanjung Menang'),
('18.11.02.2006','Eka Mulya'),
('18.11.02.2007','Wono Sari'),
('18.11.02.2008','Dwi Karya Mustika'),
('18.11.02.2009','Pangkal Mas Jaya'),
('18.11.02.2010','Pangkal Mas Mulya'),
('18.11.02.2011','Tanjung Mas Mulya'),
('18.11.02.2012','Muara Mas'),
('18.11.02.2013','Tanjung Mas Jaya'),
('18.11.02.2014','Margo Jaya'),
('18.11.02.2015','Pangkal Mas'),
('18.11.02.2016','Tanjung Menang Raya'),
('18.11.02.2017','Tebing Karya Mandiri'),
('18.11.02.2018','Tanjung Mas Rejo'),
('18.11.02.2019','Margo Mulyo'),
('18.11.02.2020','Muara Asri'),
('18.11.03','Rawa Jitu Utara'),
('18.11.03.2001','Sungai Buaya'),
('18.11.03.2002','Panggung Jaya'),
('18.11.03.2003','Sungai Sidang'),
('18.11.03.2004','Sidang Sido Rahayu'),
('18.11.03.2005','Sidang Way Puji'),
('18.11.03.2006','Sidang Bandar Anom'),
('18.11.03.2007','Panggung Rejo'),
('18.11.03.2008','Sidang Iso Mukti'),
('18.11.03.2009','Sidang Kurnia Agung'),
('18.11.03.2010','Telogo Rejo'),
('18.11.03.2011','Sidang Gunung Tiga'),
('18.11.03.2012','Sidang Muara Jaya'),
('18.11.03.2013','Sidang Makmur'),
('18.11.04','Way Serdang'),
('18.11.04.2001','Buko Poso'),
('18.11.04.2002','Kejadian'),
('18.11.04.2003','Bumi Harapan'),
('18.11.04.2004','Kebun Dalam'),
('18.11.04.2005','Panca Warna'),
('18.11.04.2006','Gedung Boga'),
('18.11.04.2007','Suka Agung'),
('18.11.04.2008','Rejo Mulyo'),
('18.11.04.2009','Hadi Mulyo'),
('18.11.04.2010','Labuhan Batin'),
('18.11.04.2011','Labuhan Baru'),
('18.11.04.2012','Labuhan Makmur'),
('18.11.04.2013','Gedung Sri Mulyo'),
('18.11.04.2014','Labuhan Permai'),
('18.11.04.2015','Sumber Rejo'),
('18.11.04.2016','Margo Bhakti'),
('18.11.04.2017','Labuhan Mulya'),
('18.11.04.2018','Karang Mulya'),
('18.11.04.2019','Tri Tunggal Jaya'),
('18.11.04.2020','Suka Mandiri'),
('18.11.05','Simpang Pematang'),
('18.11.05.2001','Simpang Pematang'),
('18.11.05.2002','Budi Aji'),
('18.11.05.2003','Margo Rahayu'),
('18.11.05.2004','Harapan Jaya'),
('18.11.05.2005','Wira Bangun'),
('18.11.05.2006','Agung Batin'),
('18.11.05.2007','Bangun Mulyo'),
('18.11.05.2008','Jaya Sakti'),
('18.11.05.2009','Rejo Binangun'),
('18.11.05.2010','Simpang Mesuji'),
('18.11.05.2011','Margo Makmur'),
('18.11.05.2012','Aji Jaya'),
('18.11.05.2013','Mulya Agung'),
('18.11.06','Panca Jaya'),
('18.11.06.2001','Adi Luhur'),
('18.11.06.2002','Mukti Karya'),
('18.11.06.2003','Fajar Baru'),
('18.11.06.2004','Adi Mulyo'),
('18.11.06.2005','Fajar Asri'),
('18.11.06.2006','Fajar Indah'),
('18.11.06.2007','Adi Karya Mulya'),
('18.11.07','Tanjung Raya'),
('18.11.07.2001','Brabasan'),
('18.11.07.2002','Gedung Ram'),
('18.11.07.2003','Mekar Sari'),
('18.11.07.2004','Bujung Buring'),
('18.11.07.2005','Kagungan Dalam'),
('18.11.07.2006','Tanjung Sari'),
('18.11.07.2007','Harapan Mukti'),
('18.11.07.2008','Sri Tanjung'),
('18.11.07.2009','Bangun Jaya'),
('18.11.07.2010','Muara Tenang'),
('18.11.07.2011','Wira Jaya'),
('18.11.07.2012','Sinar Laga'),
('18.11.07.2013','Tri Karya Mulya'),
('18.11.07.2014','Berasan Makmur'),
('18.11.07.2015','Mekar Jaya'),
('18.11.07.2016','Gedung Mulya'),
('18.11.07.2017','Tanjung Harapan'),
('18.11.07.2018','Muara Tenang Timur'),
('18.11.07.2019','Sriwijaya'),
('18.11.07.2020','Mukti Jaya'),
('18.11.07.2021','Bujung Buring Baru'),
('18.12','Kabupaten Tulang Bawang Barat'),
('18.12.01','Tulang Bawang Tengah'),
('18.12.01.1001','Mulyo Asri'),
('18.12.01.1007','Panaragan Jaya'),
('18.12.01.2002','Panaragan'),
('18.12.01.2003','Bandar Dewa'),
('18.12.01.2004','Menggala Mas'),
('18.12.01.2005','Penumangan'),
('18.12.01.2006','Penumangan Baru'),
('18.12.01.2008','Tirta Kencana'),
('18.12.01.2009','Pulung Kencana'),
('18.12.01.2010','Mulya Kencana'),
('18.12.01.2011','Candra Kencana'),
('18.12.01.2012','Tunas Asri'),
('18.12.01.2013','Wono Kerto'),
('18.12.01.2014','Panaragan Jaya Utama'),
('18.12.01.2015','Panaragan Jaya Indah'),
('18.12.01.2016','Mulya Jaya'),
('18.12.01.2017','Tirta Makmur'),
('18.12.01.2018','Candra Mukti'),
('18.12.01.2019','Candra Jaya'),
('18.12.01.2020','Marga Asri'),
('18.12.01.2021','Mekar Asri'),
('18.12.02','Tumijajar'),
('18.12.02.1001','Daya Murni'),
('18.12.02.2002','Daya Sakti'),
('18.12.02.2003','Margo Mulyo'),
('18.12.02.2004','Makarti'),
('18.12.02.2005','Gunung Menanti'),
('18.12.02.2006','Daya Asri'),
('18.12.02.2007','Murni Jaya'),
('18.12.02.2008','Sumber Rejo'),
('18.12.02.2009','Margo Dadi'),
('18.12.02.2010','Gunung Timbul'),
('18.12.03','Tulang Bawang Udik'),
('18.12.03.2001','Karta'),
('18.12.03.2002','Karta Sari'),
('18.12.03.2003','Karta Raharja'),
('18.12.03.2004','Gunung Katun Tanjungan'),
('18.12.03.2005','Gunung Katun Malai'),
('18.12.03.2006','Gedung Ratu'),
('18.12.03.2007','Kagungan Ratu'),
('18.12.03.2008','Marga Kencana'),
('18.12.03.2009','Way Sido'),
('18.12.03.2010','Kagungan Ratu Agung'),
('18.12.03.2011','Gading Kencana'),
('18.12.03.2012','Karta Raya'),
('18.12.03.2013','Karta Tanjung Selamat'),
('18.12.04','Gunung Terang'),
('18.12.04.2002','Toto Mulyo'),
('18.12.04.2006','Setia Bumi'),
('18.12.04.2007','Gunung Terang'),
('18.12.04.2008','Gunung Agung'),
('18.12.04.2011','Kagungan Jaya'),
('18.12.04.2012','Terang Mulya'),
('18.12.04.2013','Terang Bumi Agung'),
('18.12.04.2015','Setia Agung'),
('18.12.04.2017','Mulyo Jadi'),
('18.12.04.2020','Terang Makmur'),
('18.12.05','Gunung Agung'),
('18.12.05.2001','Tunas Jaya'),
('18.12.05.2002','Mekar Jaya'),
('18.12.05.2003','Marga Jaya'),
('18.12.05.2004','Jaya Murni'),
('18.12.05.2005','Suka Jaya'),
('18.12.05.2006','Mulya Jaya'),
('18.12.05.2007','Bangun Jaya'),
('18.12.05.2008','Sumber Jaya'),
('18.12.05.2009','Wono Rejo'),
('18.12.05.2010','Tri Tunggal Jaya'),
('18.12.05.2011','Mulya Sari'),
('18.12.05.2012','Dwikora Jaya'),
('18.12.05.2013','Sumber Rejeki'),
('18.12.06','Way Kenanga'),
('18.12.06.2001','Agung Jaya'),
('18.12.06.2002','Mercu Buana'),
('18.12.06.2003','Balam Jaya'),
('18.12.06.2004','Pagar Buana'),
('18.12.06.2005','Indraloka I'),
('18.12.06.2006','Indraloka II'),
('18.12.06.2007','Balam Asri'),
('18.12.06.2008','Indraloka Jaya'),
('18.12.06.2009','Indraloka Mukti'),
('18.12.06.2010','Sido Agung'),
('18.12.07','Lambu Kibang'),
('18.12.07.2001','Kibang Budi Jaya'),
('18.12.07.2002','Lesung Bhakti Jaya'),
('18.12.07.2003','Mekar Sari Jaya'),
('18.12.07.2004','Pagar Jaya'),
('18.12.07.2005','Gunung Sari'),
('18.12.07.2006','Sumber Rejo'),
('18.12.07.2007','Kibang Yekti Jaya'),
('18.12.07.2008','Kibang Tri Jaya'),
('18.12.07.2009','Gilang Tunggal Makarta'),
('18.12.07.2010','Kibang Mulya Jaya'),
('18.12.08','Pagar Dewa'),
('18.12.08.2001','Pagar Dewa'),
('18.12.08.2002','Pagar Dewa Suka Mulya'),
('18.12.08.2003','Cahyou Randu'),
('18.12.08.2004','Bujung Dewa'),
('18.12.08.2005','Bujung Sari Marga'),
('18.12.08.2006','Marga Jaya Indah'),
('18.12.09','Batu Putih'),
('18.12.09.2001','Panca Marga'),
('18.12.09.2002','Sido Makmur'),
('18.12.09.2003','Sakti Jaya'),
('18.12.09.2004','Margo Mulya'),
('18.12.09.2005','Margo Dadi'),
('18.12.09.2006','Marga Sari'),
('18.12.09.2007','Mulyo Sari'),
('18.12.09.2008','Toto Katon'),
('18.12.09.2009','Toto Makmur'),
('18.12.09.2010','Toto Wonodadi'),
('18.13','Kabupaten Pesisir Barat'),
('18.13.01','Pesisir Tengah'),
('18.13.01.1005','Pasar Krui'),
('18.13.01.1008','Pasar Kota Krui'),
('18.13.01.2001','Way Redak'),
('18.13.01.2002','Seray'),
('18.13.01.2003','Kampung Jawa'),
('18.13.01.2004','Rawas'),
('18.13.01.2006','Suka Negara'),
('18.13.01.2007','Pahmungan'),
('18.13.02','Pesisir Selatan'),
('18.13.02.2001','Negeri Ratu Tenumbang'),
('18.13.02.2002','Sukarame'),
('18.13.02.2003','Pelita Jaya'),
('18.13.02.2004','Sumur Jaya'),
('18.13.02.2005','Tanjung Jati'),
('18.13.02.2006','Pagar Dalam'),
('18.13.02.2007','Tanjung Setia'),
('18.13.02.2008','Biha'),
('18.13.02.2009','Way Jambu'),
('18.13.02.2010','Marang'),
('18.13.02.2011','Tanjung Raya'),
('18.13.02.2012','Bangun Negara'),
('18.13.02.2013','Ulok Manik'),
('18.13.02.2014','Paku Negara'),
('18.13.02.2015','Tulung Bamban'),
('18.13.03','Lemong'),
('18.13.03.2001','Tanjung Jati'),
('18.13.03.2002','Tanjung Sakti'),
('18.13.03.2003','Way Batang'),
('18.13.03.2004','Lemong'),
('18.13.03.2005','Cahya Negeri'),
('18.13.03.2006','Malaya'),
('18.13.03.2007','Bambang'),
('18.13.03.2008','Pagar Dalam'),
('18.13.03.2009','Bandar Pugung'),
('18.13.03.2010','Penengahan'),
('18.13.03.2011','Rata Agung'),
('18.13.03.2012','Sukamulya'),
('18.13.03.2013','Parda Haga'),
('18.13.04','Pesisir Utara'),
('18.13.04.2001','Kuripan'),
('18.13.04.2002','Padang Rindu'),
('18.13.04.2003','Negeri Ratu'),
('18.13.04.2004','Kerbang Dalam'),
('18.13.04.2005','Kota Karang'),
('18.13.04.2006','Balam'),
('18.13.04.2007','Way Narta'),
('18.13.04.2008','Kerbang Langgar'),
('18.13.04.2009','Walur'),
('18.13.04.2010','Batu Raja'),
('18.13.04.2011','Pemancar'),
('18.13.04.2012','Gedau'),
('18.13.05','Karya Penggawa'),
('18.13.05.2001','Kebuayan'),
('18.13.05.2002','Way Nukak'),
('18.13.05.2003','Way Sindi'),
('18.13.05.2004','Penengahan'),
('18.13.05.2005','Menyancang'),
('18.13.05.2006','Laay'),
('18.13.05.2007','Penggawa V Ulu'),
('18.13.05.2008','Penggawa V Tengah'),
('18.13.05.2009','Way Sindi Utara'),
('18.13.05.2010','Tembakak Way Sindi'),
('18.13.05.2011','Way Sindi Hanuan'),
('18.13.05.2012','Asahan Way Sindi'),
('18.13.06','Pulau Pisang'),
('18.13.06.2001','Pasar Pulau Pisang'),
('18.13.06.2002','Labuhan'),
('18.13.06.2003','Bandar Dalam'),
('18.13.06.2004','Pekon Lok'),
('18.13.06.2005','Sukadana'),
('18.13.06.2006','Sukamarga'),
('18.13.07','Way Krui'),
('18.13.07.2001','Pajar Bulan'),
('18.13.07.2002','Bumi Waras'),
('18.13.07.2003','Banjar Agung'),
('18.13.07.2004','Penggawa V Ilir'),
('18.13.07.2005','Ulu Krui'),
('18.13.07.2006','Gunung Kemala'),
('18.13.07.2007','Labuhan Mandi'),
('18.13.07.2008','Suka Baru'),
('18.13.07.2009','Penggawa Lima'),
('18.13.07.2010','Gunungkemala Timur'),
('18.13.08','Krui Selatan'),
('18.13.08.2001','Balai Kencana'),
('18.13.08.2002','Way Suluh'),
('18.13.08.2003','Way Napal'),
('18.13.08.2004','Padang Haluan'),
('18.13.08.2005','Lintik'),
('18.13.08.2006','Walur'),
('18.13.08.2007','Pemerihan'),
('18.13.08.2008','Mandiri Sejati'),
('18.13.08.2009','Padang Raya'),
('18.13.08.2010','Suka Jadi'),
('18.13.09','Ngambur'),
('18.13.09.2001','Sumber Agung'),
('18.13.09.2002','Ulok Mukti'),
('18.13.09.2003','Negeri Ratu Ngambur'),
('18.13.09.2004','Pekon Mon'),
('18.13.09.2005','Gedung Cahya Kuningan'),
('18.13.09.2006','Suka Banjar'),
('18.13.09.2007','Suka Negara'),
('18.13.09.2008','Muara Tembulih'),
('18.13.09.2009','Bumi Ratu'),
('18.13.10','Ngaras'),
('18.13.10.2001','Negeri Ratu Ngaras'),
('18.13.10.2003','Kota Batu'),
('18.13.10.2004','Mulang Maya'),
('18.13.10.2005','Raja Basa'),
('18.13.10.2006','Parda Suka'),
('18.13.10.2017','Padang Dalam'),
('18.13.10.2018','Suka Maju'),
('18.13.10.2019','Sukarame'),
('18.13.10.2020','Bandar Jaya'),
('18.13.11','Bangkunat'),
('18.13.11.2001','Pagar Bukit'),
('18.13.11.2002','Tanjung Kemala'),
('18.13.11.2003','Suka Marga'),
('18.13.11.2004','Kota Jawa'),
('18.13.11.2005','Penyandingan'),
('18.13.11.2006','Bandar Dalam'),
('18.13.11.2007','Way Haru'),
('18.13.11.2008','Pemerihan'),
('18.13.11.2009','Suka Negeri'),
('18.13.11.2010','Sumberejo'),
('18.13.11.2011','Siring Gading'),
('18.13.11.2012','Way Tias'),
('18.13.11.2013','Tanjung Rejo'),
('18.13.11.2014','Pagar Bukit Induk'),
('18.71','Kota Bandar Lampung'),
('18.71.01','Kedaton'),
('18.71.01.1003','Kedaton'),
('18.71.01.1004','Surabaya'),
('18.71.01.1005','Sukamenanti'),
('18.71.01.1006','Sidodadi'),
('18.71.01.1009','Sukamenanti Baru'),
('18.71.01.1010','Penengahan'),
('18.71.01.1012','Penengahan Raya'),
('18.71.02','Sukarame'),
('18.71.02.1003','Sukarame'),
('18.71.02.1004','Way Dadi'),
('18.71.02.1006','Sukarame Baru'),
('18.71.02.1007','Way Dadi Baru'),
('18.71.02.1008','Korpri jaya'),
('18.71.02.1009','Korpri Raya'),
('18.71.03','Tanjungkarang Barat'),
('18.71.03.1001','Gedong Air'),
('18.71.03.1002','Sukajawa'),
('18.71.03.1004','Susunan Baru'),
('18.71.03.1006','Sukadana Ham'),
('18.71.03.1008','Kelapa Tiga Permai'),
('18.71.03.1010','Sukajawa Baru'),
('18.71.03.1011','Segalamider'),
('18.71.04','Panjang'),
('18.71.04.1001','Panjang Selatan'),
('18.71.04.1002','Srengsem'),
('18.71.04.1003','Panjang Utara'),
('18.71.04.1004','Pidada'),
('18.71.04.1007','Karang Maritim'),
('18.71.04.1008','Way Lunik'),
('18.71.04.1009','Ketapang'),
('18.71.04.1010','Ketapang Kuala'),
('18.71.05','Tanjungkarang Timur'),
('18.71.05.1002','Kota Baru'),
('18.71.05.1003','Tanjung Agung'),
('18.71.05.1004','Kebon Jeruk'),
('18.71.05.1005','Sawah Lama'),
('18.71.05.1006','Sawah Brebes'),
('18.71.06','Tanjungkarang Pusat'),
('18.71.06.1001','Durian Payung'),
('18.71.06.1002','Gotong Royong'),
('18.71.06.1005','Palapa'),
('18.71.06.1006','Kaliawi'),
('18.71.06.1007','Kelapa Tiga'),
('18.71.06.1010','Pasir Gintung'),
('18.71.06.1012','Kaliawi Persada'),
('18.71.07','Telukbetung Selatan'),
('18.71.07.1001','Pesawahan'),
('18.71.07.1002','Telukbetung'),
('18.71.07.1008','Talang'),
('18.71.07.1009','Gedong Pakuon'),
('18.71.07.1012','Sumur Putri'),
('18.71.07.1013','Gunungmas'),
('18.71.08','Telukbetung Barat'),
('18.71.08.1005','Bakung'),
('18.71.08.1006','Kuripan'),
('18.71.08.1007','Negeri Olok Gading'),
('18.71.08.1008','Sukarame II'),
('18.71.08.1009','Batu Putuk'),
('18.71.09','Telukbetung Utara'),
('18.71.09.1001','Kupang Kota'),
('18.71.09.1003','Kupang Raya'),
('18.71.09.1004','Kupang Teba'),
('18.71.09.1006','Pengajaran'),
('18.71.09.1007','Gulak Galik'),
('18.71.09.1008','Sumur Batu'),
('18.71.10','Rajabasa'),
('18.71.10.1001','Rajabasa'),
('18.71.10.1002','Gedong Meneng'),
('18.71.10.1005','Rajabasa Nunyai'),
('18.71.10.1006','Rajabasa Pemuka'),
('18.71.10.1007','Gedong Meneng Baru'),
('18.71.10.1008','Rajabasa Raya'),
('18.71.10.1009','Rajabasa Jaya'),
('18.71.11','Tanjung Senang'),
('18.71.11.1001','Tanjung Senang'),
('18.71.11.1002','Way Kandis'),
('18.71.11.1003','Labuhan Dalam'),
('18.71.11.1004','Perumnas Way Kandis'),
('18.71.11.1005','Pematang Wangi'),
('18.71.12','Sukabumi'),
('18.71.12.1002','Sukabumi'),
('18.71.12.1004','Sukabumi Indah'),
('18.71.12.1007','Campang Raya'),
('18.71.12.1008','Nusantara Permai'),
('18.71.12.1009','Campang Jaya'),
('18.71.12.1010','Way Gubak'),
('18.71.12.1011','Way Laga'),
('18.71.13','Kemiling'),
('18.71.13.1001','Sumber Rejo'),
('18.71.13.1003','Beringin Jaya'),
('18.71.13.1004','Kemiling Permai'),
('18.71.13.1005','Sumber Agung'),
('18.71.13.1006','Kedaung'),
('18.71.13.1007','Pinang Jaya'),
('18.71.13.1008','Sumberrejo Sejahtera'),
('18.71.13.1009','Kemiling Raya'),
('18.71.13.1010','Beringin Raya'),
('18.71.14','Labuhan Ratu'),
('18.71.14.1001','Labuhan Ratu'),
('18.71.14.1002','Labuhan Ratu Raya'),
('18.71.14.1003','Sepang Jaya'),
('18.71.14.1004','Kota Sepang'),
('18.71.14.1006','Kampung Baru Raya'),
('18.71.14.1007','Kampung Baru'),
('18.71.15','Way Halim'),
('18.71.15.1001','Perumnas Way Halim'),
('18.71.15.1002','Way Halim Permai'),
('18.71.15.1003','Gunungsulah'),
('18.71.15.1004','Jagabaya I'),
('18.71.15.1005','Jagabaya II'),
('18.71.15.1006','Jagabaya III'),
('18.71.16','Langkapura'),
('18.71.16.1001','Langkapura'),
('18.71.16.1002','Langkapura Baru'),
('18.71.16.1003','Gunungterang'),
('18.71.16.1005','Bilabong Jaya'),
('18.71.16.1006','Gunungagung'),
('18.71.17','Enggal'),
('18.71.17.1001','Enggal'),
('18.71.17.1002','Pelita'),
('18.71.17.1003','Tanjungkarang'),
('18.71.17.1004','Gunungsari'),
('18.71.17.1005','Rawalaut'),
('18.71.17.1006','Pahoman'),
('18.71.18','Kedamaian'),
('18.71.18.1001','Kedamaian'),
('18.71.18.1002','Bumi Kedamaian'),
('18.71.18.1003','Tanjungagung Raya'),
('18.71.18.1004','Tanjungbaru'),
('18.71.18.1005','Kalibalau Kencana'),
('18.71.18.1006','Tanjungraya'),
('18.71.18.1007','Tanjunggading'),
('18.71.19','Telukbetung Timur'),
('18.71.19.1001','Kota Karang'),
('18.71.19.1002','Kota Karang Raya'),
('18.71.19.1003','Parwata'),
('18.71.19.1004','Keteguhan'),
('18.71.19.1005','Sukamaju'),
('18.71.19.1006','Way Tataan'),
('18.71.20','Bumi Waras'),
('18.71.20.1001','Sukaraja'),
('18.71.20.1002','Bumi Waras'),
('18.71.20.1003','Garuntang'),
('18.71.20.1004','Bumi Raya'),
('18.71.20.1005','Kangkung'),
('18.72','Kota Metro'),
('18.72.01','Metro Pusat'),
('18.72.01.1001','Metro'),
('18.72.01.1002','Hadimulyo Timur'),
('18.72.01.1003','Imopuro'),
('18.72.01.1004','Hadimulyo Barat'),
('18.72.01.1005','Yosomulyo'),
('18.72.02','Metro Utara'),
('18.72.02.1001','Banjarsari'),
('18.72.02.1002','Purwosari'),
('18.72.02.1003','Karangrejo'),
('18.72.02.1004','Purwoasri'),
('18.72.03','Metro Barat'),
('18.72.03.1001','Mulyojati'),
('18.72.03.1002','Ganjar Agung'),
('18.72.03.1003','Mulyosari'),
('18.72.03.1004','Ganjar Asri'),
('18.72.04','Metro Timur'),
('18.72.04.1001','Yosodadi'),
('18.72.04.1002','Tejosari'),
('18.72.04.1003','Iring Mulyo'),
('18.72.04.1004','Yosorejo'),
('18.72.04.1005','Tejo Agung'),
('18.72.05','Metro Selatan'),
('18.72.05.1001','Rejomulyo'),
('18.72.05.1002','Margorejo'),
('18.72.05.1003','Sumbersari Bantul'),
('18.72.05.1004','Margodadi');

-- Provinsi Kepulauan BANGKA BELITUNG
INSERT INTO wilayah (kode, nama)
VALUES
('19','Kepulauan Bangka Belitung'),
('19.01','Kabupaten Bangka'),
('19.01.01','Sungailiat'),
('19.01.01.1001','Sungailiat'),
('19.01.01.1002','Sri Menanti'),
('19.01.01.1003','Kudai'),
('19.01.01.1004','Sinar Baru'),
('19.01.01.1005','Kenanga'),
('19.01.01.1006','Parit Padang'),
('19.01.01.1008','Sinar Jaya Jelutung'),
('19.01.01.1009','Matras'),
('19.01.01.1010','Jelitik'),
('19.01.01.1011','Surya Timur'),
('19.01.01.1012','Lubuk Kelik'),
('19.01.01.1013','Bukit Betung'),
('19.01.01.2007','Rebo'),
('19.01.02','Belinyu'),
('19.01.02.1001','Kuto Panji'),
('19.01.02.1002','Air Jukung'),
('19.01.02.1003','Bukit Ketok'),
('19.01.02.1009','Remodong Indah'),
('19.01.02.1010','Air Asam'),
('19.01.02.1011','Mantung'),
('19.01.02.1012','Belinyu'),
('19.01.02.2004','Gunung Muda'),
('19.01.02.2005','Gunung Pelawan'),
('19.01.02.2006','Riding Panjang'),
('19.01.02.2007','Lumut'),
('19.01.02.2008','Bintet'),
('19.01.03','Merawang'),
('19.01.03.2001','Batu Rusa'),
('19.01.03.2002','Balun Ijuk'),
('19.01.03.2003','Riding Panjang'),
('19.01.03.2004','Jurung'),
('19.01.03.2005','Kimak'),
('19.01.03.2006','Pagarawan'),
('19.01.03.2007','Merawang'),
('19.01.03.2008','Air Anyir'),
('19.01.03.2009','Dwi Makmur'),
('19.01.03.2010','Jada Bahrin'),
('19.01.04','Mendo Barat'),
('19.01.04.2001','Petaling'),
('19.01.04.2002','Penagan'),
('19.01.04.2003','Zed'),
('19.01.04.2004','Mendo'),
('19.01.04.2005','Paya Benua'),
('19.01.04.2006','Cengkong Abang'),
('19.01.04.2007','Kace'),
('19.01.04.2008','Kemuja'),
('19.01.04.2009','Air Duren'),
('19.01.04.2010','Kota Kapur'),
('19.01.04.2011','Air Buluh'),
('19.01.04.2012','Rukam'),
('19.01.04.2013','Labuh Air Pandan'),
('19.01.04.2014','Kace Timur'),
('19.01.04.2015','Petaling Banjar'),
('19.01.05','Pemali'),
('19.01.05.2001','Air Ruai'),
('19.01.05.2002','Air Duren'),
('19.01.05.2003','Penyamun'),
('19.01.05.2004','Sempan'),
('19.01.05.2005','Pemali'),
('19.01.05.2006','Karya Makmur'),
('19.01.06','Bakam'),
('19.01.06.2001','Bakam'),
('19.01.06.2002','Kapuk'),
('19.01.06.2003','Dalil'),
('19.01.06.2004','Neknang'),
('19.01.06.2005','Tiang Tarah'),
('19.01.06.2006','Mangka'),
('19.01.06.2007','Mabat'),
('19.01.06.2008','Bukit Layang'),
('19.01.06.2009','Maras Senang'),
('19.01.07','Riau Silip'),
('19.01.07.2001','Riau'),
('19.01.07.2002','Pangkal Niur'),
('19.01.07.2003','Pugul'),
('19.01.07.2004','Cit'),
('19.01.07.2005','Deniang'),
('19.01.07.2006','Silip'),
('19.01.07.2007','Mapur'),
('19.01.07.2008','Banyu Asin'),
('19.01.07.2009','Berbura'),
('19.01.08','Puding Besar'),
('19.01.08.2001','Puding Besar'),
('19.01.08.2002','Labu'),
('19.01.08.2003','Nibung'),
('19.01.08.2004','Tanah Bawah'),
('19.01.08.2005','Saing'),
('19.01.08.2006','Kota Waringin'),
('19.01.08.2007','Kayu Besi'),
('19.02','Kabupaten Belitung'),
('19.02.01','Tanjungpandan'),
('19.02.01.1001','Kota'),
('19.02.01.1002','Parit'),
('19.02.01.1005','Lesung Batang'),
('19.02.01.1006','Pangkallalang'),
('19.02.01.1009','Tanjungpendam'),
('19.02.01.1011','Paal Satu'),
('19.02.01.1016','Kampong Damai'),
('19.02.01.2003','Buluh Tumbang'),
('19.02.01.2004','Perawas'),
('19.02.01.2007','Dukong'),
('19.02.01.2008','Juru Seberang'),
('19.02.01.2010','Air Saga'),
('19.02.01.2012','Air Merbau'),
('19.02.01.2013','Aik Pelempang Jaya'),
('19.02.01.2014','Aik Ketekok'),
('19.02.01.2015','Aik Rayak'),
('19.02.02','Membalong'),
('19.02.02.2001','Membalong'),
('19.02.02.2002','Perpat'),
('19.02.02.2003','Lassar'),
('19.02.02.2004','Simpang Rusa'),
('19.02.02.2005','Kembiri'),
('19.02.02.2006','Bantan'),
('19.02.02.2007','Tanjungrusa'),
('19.02.02.2008','Mentigi'),
('19.02.02.2009','Pulau Seliu'),
('19.02.02.2010','Pulau Sumedang'),
('19.02.02.2011','Gunung Riting'),
('19.02.02.2012','Padang Kandis'),
('19.02.03','Selat Nasik'),
('19.02.03.2001','Selat Nasik'),
('19.02.03.2002','Petaling'),
('19.02.03.2003','Suak Gual'),
('19.02.03.2004','Pulau Gersik'),
('19.02.04','Sijuk'),
('19.02.04.2001','Sijuk'),
('19.02.04.2002','Batu Itam'),
('19.02.04.2003','Terong'),
('19.02.04.2004','Air Seruk'),
('19.02.04.2005','Tanjung Binga'),
('19.02.04.2006','Air Selumar'),
('19.02.04.2007','Sungai Padang'),
('19.02.04.2008','Keciput'),
('19.02.04.2009','Pelepak Pute'),
('19.02.04.2010','Tanjong Tinggi'),
('19.02.05','Badau'),
('19.02.05.2001','Badau'),
('19.02.05.2002','Air Batu Buding'),
('19.02.05.2003','Sungai Samak'),
('19.02.05.2004','Kacang Butor'),
('19.02.05.2005','Cerucuk'),
('19.02.05.2006','Pegantungan'),
('19.02.05.2007','Ibul'),
('19.03','Kabupaten Bangka Selatan'),
('19.03.01','Toboali'),
('19.03.01.1001','Toboali'),
('19.03.01.1002','Teladan'),
('19.03.01.1003','Tanjung Ketapang'),
('19.03.01.2004','Serdang'),
('19.03.01.2005','Jeriji'),
('19.03.01.2006','Bikang'),
('19.03.01.2007','Gadung'),
('19.03.01.2008','Rias'),
('19.03.01.2010','Kepoh'),
('19.03.01.2012','Keposang'),
('19.03.01.2013','Rindik'),
('19.03.02','Lepar'),
('19.03.02.2001','Tanjung Labu'),
('19.03.02.2002','Tanjung Sangkar'),
('19.03.02.2004','Kumbung'),
('19.03.02.2005','Penutuk'),
('19.03.03','Airgegas'),
('19.03.03.2001','Airgegas'),
('19.03.03.2002','Delas'),
('19.03.03.2003','Pergam'),
('19.03.03.2004','Bencah'),
('19.03.03.2005','Nyelanding'),
('19.03.03.2006','Nangka'),
('19.03.03.2007','Ranggas'),
('19.03.03.2008','Airbara'),
('19.03.03.2009','Sidoharjo'),
('19.03.03.2010','Tepus'),
('19.03.04','Simpang Rimba'),
('19.03.04.2001','Jelutung II'),
('19.03.04.2002','Gudang'),
('19.03.04.2003','Bangka Kota'),
('19.03.04.2004','Rajik'),
('19.03.04.2005','Sebagin'),
('19.03.04.2006','Simpang Rimba'),
('19.03.04.2007','Permis'),
('19.03.05','Payung'),
('19.03.05.2001','Payung'),
('19.03.05.2002','Malik'),
('19.03.05.2003','Sengir'),
('19.03.05.2004','Pangkal Buluh'),
('19.03.05.2005','Irat'),
('19.03.05.2006','Bedengung'),
('19.03.05.2008','Nadung'),
('19.03.05.2009','Ranggung'),
('19.03.05.2012','Paku'),
('19.03.06','Tukak Sadai'),
('19.03.06.2001','Sadai'),
('19.03.06.2002','Tukak'),
('19.03.06.2003','Pasir Putih'),
('19.03.06.2004','Tiram'),
('19.03.06.2005','Bukit Terap'),
('19.03.07','Pulau Besar'),
('19.03.07.2001','Batu Betumpang'),
('19.03.07.2002','Sukajaya'),
('19.03.07.2003','Panca Tunggal'),
('19.03.07.2004','Sumber Jaya Permai'),
('19.03.07.2005','Fajar Indah'),
('19.03.08','Kepulauan Pongok'),
('19.03.08.2001','Pongok'),
('19.03.08.2002','Celagen'),
('19.04','Kabupaten Bangka Tengah'),
('19.04.01','Koba'),
('19.04.01.1001','Koba'),
('19.04.01.1002','Arung Dalam'),
('19.04.01.1017','Berok'),
('19.04.01.1018','Padang Mulia'),
('19.04.01.1019','Simpang Perlang'),
('19.04.01.2003','Nibung'),
('19.04.01.2005','Kurau (Timur)'),
('19.04.01.2006','Guntung'),
('19.04.01.2007','Penyak'),
('19.04.01.2008','Terentang III'),
('19.04.01.2010','Kurau Barat'),
('19.04.02','Pangkalan Baru'),
('19.04.02.1001','Dul'),
('19.04.02.2004','Air Mesu'),
('19.04.02.2006','Mangkol'),
('19.04.02.2007','Tanjung Gunung'),
('19.04.02.2010','Benteng'),
('19.04.02.2012','Padang Baru'),
('19.04.02.2013','Jeruk'),
('19.04.02.2014','Beluluk'),
('19.04.02.2016','Pedindang'),
('19.04.02.2018','Batu Belubang'),
('19.04.02.2020','Air Mesu Timur'),
('19.04.02.2021','Kebintik'),
('19.04.03','Sungai Selan'),
('19.04.03.1001','Sungai Selan'),
('19.04.03.2002','Kerantai'),
('19.04.03.2003','Keretak'),
('19.04.03.2004','Lampur'),
('19.04.03.2005','Sarang Mandi'),
('19.04.03.2006','Munggu'),
('19.04.03.2007','Kemingking'),
('19.04.03.2008','Sungai Selan Atas'),
('19.04.03.2009','Tanjung Pura'),
('19.04.03.2010','Romadhon'),
('19.04.03.2011','Kerakas'),
('19.04.03.2012','Melabun'),
('19.04.03.2013','Keretak Atas'),
('19.04.04','Simpang Katis'),
('19.04.04.2001','Simpang Katis'),
('19.04.04.2002','Celuak'),
('19.04.04.2003','Sungkap'),
('19.04.04.2004','Beruas'),
('19.04.04.2005','Puput'),
('19.04.04.2006','Teru'),
('19.04.04.2007','Terak'),
('19.04.04.2008','Pasir Garam'),
('19.04.04.2009','Katis'),
('19.04.04.2010','Pinang Sebatang'),
('19.04.05','Namang'),
('19.04.05.2001','Namang'),
('19.04.05.2002','Cambai'),
('19.04.05.2003','Kayu Besi'),
('19.04.05.2004','Jelutung'),
('19.04.05.2005','Belilik'),
('19.04.05.2006','Bhaskara Bhakti'),
('19.04.05.2008','Bukit Kijang'),
('19.04.05.2009','Cambai Selatan'),
('19.04.06','Lubuk Besar'),
('19.04.06.2001','Perlang'),
('19.04.06.2002','Batu Beriga'),
('19.04.06.2003','Lubuk Besar'),
('19.04.06.2004','Kulur'),
('19.04.06.2005','Lubuk Lingkuk'),
('19.04.06.2006','Lubuk Pabrik'),
('19.04.06.2007','Trubus'),
('19.04.06.2008','Kulur Ilir'),
('19.04.06.2009','Belimbing'),
('19.05','Kabupaten Bangka Barat'),
('19.05.01','Mentok'),
('19.05.01.1001','Tanjung'),
('19.05.01.1002','Sungai Daeng'),
('19.05.01.1003','Sungai Baru'),
('19.05.01.1008','Keranggan'),
('19.05.01.1009','Menjelang'),
('19.05.01.2004','Air Putih'),
('19.05.01.2005','Air Belo'),
('19.05.01.2006','Belo Laut'),
('19.05.01.2007','Air Limau'),
('19.05.02','Simpang Teritip'),
('19.05.02.2001','Pelangas'),
('19.05.02.2002','Kundi'),
('19.05.02.2003','Mayang'),
('19.05.02.2004','Peradong'),
('19.05.02.2005','Air Nyatoh'),
('19.05.02.2006','Berang'),
('19.05.02.2007','Rambat'),
('19.05.02.2008','Simpang Gong'),
('19.05.02.2009','Simpang Tiga'),
('19.05.02.2010','Ibul'),
('19.05.02.2011','Pangek'),
('19.05.02.2012','Bukit Terak'),
('19.05.02.2013','Air Menduyung'),
('19.05.03','Jebus'),
('19.05.03.2001','Jebus'),
('19.05.03.2002','Sungai Buluh'),
('19.05.03.2003','Tumbak Petar'),
('19.05.03.2004','Limbung'),
('19.05.03.2005','Rukam'),
('19.05.03.2008','Ranggi Asam'),
('19.05.03.2009','Ketap'),
('19.05.03.2018','Mislak'),
('19.05.03.2019','Pebuar'),
('19.05.03.2020','Sinar Manik'),
('19.05.03.2021','Air Kuang'),
('19.05.04','Kelapa'),
('19.05.04.1001','Kelapa'),
('19.05.04.2002','Mancung'),
('19.05.04.2003','Kayu Arang'),
('19.05.04.2004','Pusuk'),
('19.05.04.2005','Dendang'),
('19.05.04.2006','Kacung'),
('19.05.04.2007','Sinar Sari'),
('19.05.04.2008','Beruas'),
('19.05.04.2009','Tebing'),
('19.05.04.2010','Terentang'),
('19.05.04.2011','Tuik'),
('19.05.04.2012','Tugang'),
('19.05.04.2013','Air Bulin'),
('19.05.04.2014','Pangkal Beras'),
('19.05.05','Tempilang'),
('19.05.05.2001','Tempilang'),
('19.05.05.2002','Tanjung Niur'),
('19.05.05.2003','Sangku'),
('19.05.05.2004','Buyan Kelumbi'),
('19.05.05.2005','Penyampak'),
('19.05.05.2006','Benteng Kota'),
('19.05.05.2007','Air Lintang'),
('19.05.05.2008','Sinar Surya'),
('19.05.05.2009','Simpang Yul'),
('19.05.06','Parittiga'),
('19.05.06.2001','Sekar Biru'),
('19.05.06.2002','Telak'),
('19.05.06.2003','Cupat'),
('19.05.06.2004','Bakit'),
('19.05.06.2005','Puput'),
('19.05.06.2006','Air Gantang'),
('19.05.06.2007','Kelabat'),
('19.05.06.2008','Kapit'),
('19.05.06.2009','Semulut'),
('19.05.06.2010','Teluk Limau'),
('19.06','Kabupaten Belitung Timur'),
('19.06.01','Manggar'),
('19.06.01.2001','Lalang Jaya'),
('19.06.01.2002','Kurnia Jaya'),
('19.06.01.2003','Padang'),
('19.06.01.2004','Kelubi'),
('19.06.01.2006','Lalang'),
('19.06.01.2007','Baru'),
('19.06.01.2010','Buku Limau'),
('19.06.01.2012','Mekar Jaya'),
('19.06.01.2013','Bentaian Jaya'),
('19.06.02','Gantung'),
('19.06.02.2001','Gantung'),
('19.06.02.2002','Selingsing'),
('19.06.02.2003','Jangkar Asam'),
('19.06.02.2004','Lilangan'),
('19.06.02.2009','Lenggang'),
('19.06.02.2010','Batu Penyu'),
('19.06.02.2011','Limbongan'),
('19.06.03','Dendang'),
('19.06.03.2001','Dendang'),
('19.06.03.2002','Jangkang'),
('19.06.03.2005','Nyuruk'),
('19.06.03.2008','Balok'),
('19.06.04','Kelapa Kampit'),
('19.06.04.2001','Mentawak'),
('19.06.04.2002','Senyubuk'),
('19.06.04.2003','Cendil'),
('19.06.04.2005','Buding'),
('19.06.04.2006','Mayang'),
('19.06.04.2007','Pembaharuan'),
('19.06.05','Damar'),
('19.06.05.2001','Air Kelik'),
('19.06.05.2002','Mempaya'),
('19.06.05.2003','Burong Mandi'),
('19.06.05.2004','Mengkubang'),
('19.06.05.2005','Sukamandi'),
('19.06.06','Simpang Renggiang'),
('19.06.06.2001','Simpang Tiga'),
('19.06.06.2002','Renggiang'),
('19.06.06.2003','Aik Madu'),
('19.06.06.2004','Lintang'),
('19.06.07','Simpang Pesak'),
('19.06.07.2001','Simpang Pesak'),
('19.06.07.2002','Tanjung Batu Itam'),
('19.06.07.2003','Tanjung Kelumpang'),
('19.06.07.2004','Dukong'),
('19.71','Kota Pangkal Pinang'),
('19.71.01','Bukit Intan'),
('19.71.01.1004','Semabung Lama'),
('19.71.01.1006','Bacang'),
('19.71.01.1007','Air Itam'),
('19.71.01.1008','Pasir Putih'),
('19.71.01.1009','Temberan'),
('19.71.01.1010','Sinar Bulan'),
('19.71.01.1011','Air Mawar'),
('19.71.02','Taman Sari'),
('19.71.02.1001','Opas Indah'),
('19.71.02.1002','Gedung Nasional'),
('19.71.02.1003','Batin Tikal'),
('19.71.02.1004','Rawa Bangun'),
('19.71.02.1005','Kejaksaan'),
('19.71.03','Pangkal Balam'),
('19.71.03.1004','Pasir Garam'),
('19.71.03.1005','Lontong Pancur'),
('19.71.03.1006','Ketapang'),
('19.71.03.1007','Ampui'),
('19.71.03.1008','Rejosari'),
('19.71.04','Rangkui'),
('19.71.04.1001','Pintu Air'),
('19.71.04.1002','Bintang'),
('19.71.04.1005','Masjid Jamik'),
('19.71.04.1006','Asam'),
('19.71.04.1007','Melintang'),
('19.71.04.1008','Parit Lalang'),
('19.71.04.1009','Keramat'),
('19.71.04.1010','Gajah Mada'),
('19.71.05','Gerunggang'),
('19.71.05.1001','Taman Bunga'),
('19.71.05.1002','Bukit Merapen'),
('19.71.05.1004','Bukit Sari'),
('19.71.05.1005','Tua Tunu Indah'),
('19.71.05.1006','Kacang Pedang'),
('19.71.05.1007','Air Kepala Tujuh'),
('19.71.06','Gabek'),
('19.71.06.1001','Selindung'),
('19.71.06.1002','Selindung Baru'),
('19.71.06.1003','Gabek Satu'),
('19.71.06.1004','Gabek Dua'),
('19.71.06.1005','Air Salemba'),
('19.71.06.1006','Jerambah Gantung'),
('19.71.07','Girimaya'),
('19.71.07.1001','Pasar Padi'),
('19.71.07.1002','Batu Intan'),
('19.71.07.1003','Bukit Besar'),
('19.71.07.1004','Sriwijaya'),
('19.71.07.1005','Semabung Baru');

-- Provinsi KEPULAUAN RIAU
INSERT INTO wilayah (kode, nama)
VALUES
('21','Kepulauan Riau'),
('21.01','Kabupaten Bintan'),
('21.01.04','Gunung Kijang'),
('21.01.04.1005','Kawal'),
('21.01.04.2001','Gunung Kijang'),
('21.01.04.2002','Malang Rapat'),
('21.01.04.2003','Teluk Bakau'),
('21.01.06','Bintan Timur'),
('21.01.06.1008','Kijang Kota'),
('21.01.06.1009','Sungai Lekop'),
('21.01.06.1010','Gunung Lengkuas'),
('21.01.06.1011','Sungai Enam'),
('21.01.07','Bintan Utara'),
('21.01.07.1001','Tanjung Uban Kota'),
('21.01.07.1002','Tanjung Uban Utara'),
('21.01.07.1003','Tanjung Uban Selatan'),
('21.01.07.1011','Tanjung Uban Timur'),
('21.01.07.2005','Lancang Kuning'),
('21.01.08','Teluk Bintan'),
('21.01.08.1006','Tembeling Tanjung'),
('21.01.08.2001','Bintan Buyu'),
('21.01.08.2002','Pangkil'),
('21.01.08.2003','Penaga'),
('21.01.08.2004','Pengujan'),
('21.01.08.2005','Tembeling'),
('21.01.09','Tambelan'),
('21.01.09.1001','Teluk Sekuni'),
('21.01.09.2002','Batu Lepuk'),
('21.01.09.2003','Kampung Hilir'),
('21.01.09.2004','Kampung Melayu'),
('21.01.09.2005','Pulau Mentebung'),
('21.01.09.2006','Pulau Pinang'),
('21.01.09.2007','Kukup'),
('21.01.09.2008','Pengikik'),
('21.01.10','Teluk Sebong'),
('21.01.10.1007','Kota Baru'),
('21.01.10.2001','Berakit'),
('21.01.10.2002','Ekang Anculai'),
('21.01.10.2003','Pengudang'),
('21.01.10.2004','Sebong Lagoi'),
('21.01.10.2005','Sebong Pereh'),
('21.01.10.2006','Sri Bintan'),
('21.01.12','Toapaya'),
('21.01.12.1004','Toapaya Asri'),
('21.01.12.2001','Toapaya'),
('21.01.12.2002','Toapaya Utara'),
('21.01.12.2003','Toapaya Selatan'),
('21.01.13','Mantang'),
('21.01.13.2001','Mantang Baru'),
('21.01.13.2002','Mantang Besar'),
('21.01.13.2003','Mantang Lama'),
('21.01.13.2004','Dendun'),
('21.01.14','Bintan Pesisir'),
('21.01.14.2001','Kelong'),
('21.01.14.2002','Mapur'),
('21.01.14.2003','Numbing'),
('21.01.14.2004','Air Gelubi'),
('21.01.15','Seri Kuala Lobam'),
('21.01.15.1003','Teluk Lobam'),
('21.01.15.1005','Tanjung Permai'),
('21.01.15.2001','Busung'),
('21.01.15.2002','Teluk Sasah'),
('21.01.15.2004','Kuala Sempang'),
('21.02','Kabupaten Karimun'),
('21.02.01','Moro'),
('21.02.01.1003','Moro'),
('21.02.01.1010','Moro Timur'),
('21.02.01.2004','Pauh'),
('21.02.01.2009','Jang'),
('21.02.01.2014','Pulau Moro'),
('21.02.02','Kundur'),
('21.02.02.1001','Tanjung Batu Barat'),
('21.02.02.1002','Tanjung Batu Kota'),
('21.02.02.1009','Gading Sari'),
('21.02.02.2004','Sungai Sebesi'),
('21.02.02.2005','Sungai Ungar'),
('21.02.02.2006','Lubuk'),
('21.02.03','Karimun'),
('21.02.03.1001','Tanjung Balai'),
('21.02.03.1002','Teluk Air'),
('21.02.03.1003','Sungai Lakam Timur'),
('21.02.03.1006','Lubuk Semut'),
('21.02.03.1007','Tanjung Balai Kota'),
('21.02.03.1008','Sungai Lakam Barat'),
('21.02.04','Meral'),
('21.02.04.1001','Meral Kota'),
('21.02.04.1002','Baran Barat'),
('21.02.04.1003','Sungai Raya'),
('21.02.04.1006','Baran Timur'),
('21.02.04.1007','Sungai Pasir'),
('21.02.04.1008','Parit Benut'),
('21.02.05','Tebing'),
('21.02.05.1001','Tebing'),
('21.02.05.1002','Teluk Uma'),
('21.02.05.1003','Kapling'),
('21.02.05.1004','Pamak'),
('21.02.05.1008','Harjosari'),
('21.02.05.2007','Pongkar'),
('21.02.06','Buru'),
('21.02.06.1001','Buru'),
('21.02.06.1002','Lubuk Puding'),
('21.02.06.2003','Tanjung Hutan'),
('21.02.06.2004','Tanjung Batu Kecil'),
('21.02.07','Kundur Utara'),
('21.02.07.1012','Tanjung Berlian Kota'),
('21.02.07.2003','Sungai Ungar Utara'),
('21.02.07.2004','Teluk Radang'),
('21.02.07.2010','Perayun'),
('21.02.07.2013','Tanjung Berlian Barat'),
('21.02.08','Kundur Barat'),
('21.02.08.1001','Sawang'),
('21.02.08.2002','Sawang Selatan'),
('21.02.08.2003','Sawang Laut'),
('21.02.08.2004','Kundur'),
('21.02.08.2005','Gemuruh'),
('21.02.09','Durai'),
('21.02.09.2002','Sanglar'),
('21.02.09.2003','Tanjung Kilang'),
('21.02.09.2004','Semembang'),
('21.02.09.2005','Telaga Tujuh'),
('21.02.10','Meral Barat'),
('21.02.10.1001','Pasir Panjang'),
('21.02.10.1002','Darussalam'),
('21.02.10.2003','Pangke'),
('21.02.10.2004','Pangke Barat'),
('21.02.11','Ungar'),
('21.02.11.1001','Alai'),
('21.02.11.2002','Batu Limau'),
('21.02.11.2003','Ngal'),
('21.02.11.2004','Sungai Buluh'),
('21.02.12','Belat'),
('21.02.12.2001','Sebele'),
('21.02.12.2002','Lebuh'),
('21.02.12.2003','Penarah'),
('21.02.12.2004','Sungai Asam'),
('21.02.12.2005','Tebias'),
('21.02.12.2006','Degong'),
('21.02.13','Selat Gelam'),
('21.02.13.2001','Parit'),
('21.02.13.2002','Tulang'),
('21.02.13.2003','Selat Mendaun'),
('21.02.14','Sugie Besar'),
('21.02.14.2001','Sugie'),
('21.02.14.2002','Niur Permai'),
('21.02.14.2003','Keban'),
('21.02.14.2004','Rawa Jaya'),
('21.02.14.2005','Tanjung Pelanduk'),
('21.02.14.2006','Buluh Patah'),
('21.02.14.2007','Selat Mie'),
('21.03','Kabupaten Natuna'),
('21.03.04','Midai'),
('21.03.04.1003','Sabang Barat'),
('21.03.04.2001','Sebelat'),
('21.03.04.2005','Air Putih'),
('21.03.05','Bunguran Barat'),
('21.03.05.1008','Sedanau'),
('21.03.05.2007','Mekar Jaya'),
('21.03.05.2012','Binjai'),
('21.03.05.2013','Piantengah'),
('21.03.05.2015','Selaut'),
('21.03.06','Serasan'),
('21.03.06.1003','Serasan'),
('21.03.06.2002','Kampung Hilir'),
('21.03.06.2005','Batu Berlian'),
('21.03.06.2006','Tanjung Setelung'),
('21.03.06.2007','Tanjung Balau'),
('21.03.06.2010','Pangkalan'),
('21.03.06.2011','Jermalik'),
('21.03.07','Bunguran Timur'),
('21.03.07.1011','Ranai Kota'),
('21.03.07.1016','Ranai Darat'),
('21.03.07.1017','Bandarsyah'),
('21.03.07.1019','Batu Hitam'),
('21.03.07.2002','Sungai Ulu'),
('21.03.07.2004','Sepempang'),
('21.03.07.2014','Batu Gajah'),
('21.03.08','Bunguran Utara'),
('21.03.08.2001','Kelarik Utara'),
('21.03.08.2002','Kelarik'),
('21.03.08.2004','Kelarik Air Mali'),
('21.03.08.2005','Teluk Buton'),
('21.03.08.2006','Belakang Gunung'),
('21.03.08.2008','Gunung Durian'),
('21.03.09','Subi'),
('21.03.09.2001','Subi'),
('21.03.09.2002','Subi Besar'),
('21.03.09.2003','Meliah'),
('21.03.09.2005','Terayak'),
('21.03.09.2007','Subi Besar Timur'),
('21.03.09.2008','Meliah Selatan'),
('21.03.10','Pulau Laut'),
('21.03.10.2001','Tanjung Pala'),
('21.03.10.2002','Air Payang'),
('21.03.10.2003','Kadur'),
('21.03.11','Pulau Tiga'),
('21.03.11.2001','Sabang Mawang'),
('21.03.11.2003','Sededap'),
('21.03.11.2004','Tanjung Batang'),
('21.03.11.2005','Serantas'),
('21.03.11.2006','Sabang Mawang Barat'),
('21.03.11.2010','Teluk Labuh'),
('21.03.15','Bunguran Timur Laut'),
('21.03.15.2001','Tanjung'),
('21.03.15.2002','Ceruk'),
('21.03.15.2003','Kelanga'),
('21.03.15.2004','Pengadah'),
('21.03.15.2005','Sebadai Ulu'),
('21.03.15.2006','Limau Manis'),
('21.03.15.2007','Seleman'),
('21.03.16','Bunguran Tengah'),
('21.03.16.2001','Tapau'),
('21.03.16.2002','Harapan Jaya'),
('21.03.16.2003','Air Lengit'),
('21.03.18','Bunguran Selatan'),
('21.03.18.2001','Cemaga'),
('21.03.18.2002','Cemaga Selatan (Setengar)'),
('21.03.18.2003','Cemaga Utara (Singgang Bulan)'),
('21.03.18.2004','Cemaga Tengah'),
('21.03.19','Serasan Timur'),
('21.03.19.2001','Arung Ayam'),
('21.03.19.2002','Air Nusa'),
('21.03.19.2004','Air Ringau'),
('21.03.19.2005','Payak'),
('21.03.20','Bunguran Batubi'),
('21.03.20.2001','Batubi Jaya'),
('21.03.20.2002','Gunung Putri'),
('21.03.20.2003','Sedarat Baru'),
('21.03.20.2004','Sedanau Timur'),
('21.03.20.2005','Semedang'),
('21.03.21','Pulau Tiga Barat'),
('21.03.21.2001','Pulau Tiga'),
('21.03.21.2002','Tanjung Kumbik Utara'),
('21.03.21.2003','Setumuk'),
('21.03.21.2004','Selading'),
('21.03.22','Suak Midai'),
('21.03.22.2001','Air Kumpai'),
('21.03.22.2002','Batu Belanak'),
('21.03.22.2003','Gunung Jambat'),
('21.03.23','Pulau Panjang'),
('21.03.23.2001','Pulau Panjang'),
('21.03.23.2002','Pulau Kerdau'),
('21.03.24','Pulau Seluan'),
('21.03.24.2001','Kelarik Barat'),
('21.03.24.2002','Seluan Barat'),
('21.04','Kabupaten Lingga'),
('21.04.01','Singkep'),
('21.04.01.1001','Dabo'),
('21.04.01.1007','Dabo Lama'),
('21.04.01.1012','Sungailumpur'),
('21.04.01.2008','Batu Berdaun'),
('21.04.01.2009','Tanjung Harapan'),
('21.04.01.2010','Batu Kacang'),
('21.04.02','Lingga'),
('21.04.02.1010','Daik'),
('21.04.02.1020','Daik Sepincan'),
('21.04.02.2001','Pekajang'),
('21.04.02.2002','Kelombok'),
('21.04.02.2003','Mepar'),
('21.04.02.2006','Kelumu'),
('21.04.02.2007','Mentuda'),
('21.04.02.2008','Merawang'),
('21.04.02.2009','Panggak Darat'),
('21.04.02.2011','Panggak Laut'),
('21.04.02.2012','Musai'),
('21.04.02.2019','Nerekeh'),
('21.04.03','Senayang'),
('21.04.03.1001','Senayang'),
('21.04.03.2002','Mamut'),
('21.04.03.2012','Laboh'),
('21.04.03.2013','Penaah'),
('21.04.03.2015','Baran'),
('21.04.04','Singkep Barat'),
('21.04.04.1006','Raya'),
('21.04.04.2001','Bakong'),
('21.04.04.2002','Kuala Raya'),
('21.04.04.2003','Marok Tua'),
('21.04.04.2005','Sungai Buluh'),
('21.04.04.2007','Sungai Raya'),
('21.04.04.2008','Sungai Harapan'),
('21.04.04.2009','Jagoh'),
('21.04.04.2012','Tinjul'),
('21.04.04.2013','Langkap'),
('21.04.04.2014','Tanjung Irat'),
('21.04.04.2015','Bukit Belah'),
('21.04.05','Lingga Utara'),
('21.04.05.1007','Pancur'),
('21.04.05.2001','Bukit Harapan'),
('21.04.05.2002','Duara'),
('21.04.05.2003','Limbung'),
('21.04.05.2004','Resun'),
('21.04.05.2005','Sekanah'),
('21.04.05.2008','Linau'),
('21.04.05.2009','Sungaibesar'),
('21.04.05.2010','Rantau Panjang'),
('21.04.05.2012','Resun Pesisir'),
('21.04.06','Singkep Pesisir'),
('21.04.06.2001','Berindat'),
('21.04.06.2002','Sedamai'),
('21.04.06.2003','Lanjut'),
('21.04.06.2004','Kote'),
('21.04.06.2005','Persing'),
('21.04.06.2006','Pelakak'),
('21.04.07','Lingga Timur'),
('21.04.07.2001','Bukitlangkap'),
('21.04.07.2002','Keton'),
('21.04.07.2003','Pekaka'),
('21.04.07.2004','Kerandin'),
('21.04.07.2005','Sungai Pinang'),
('21.04.07.2006','Kudung'),
('21.04.07.2007','Teluk'),
('21.04.07.2008','Belungkur'),
('21.04.08','Selayar'),
('21.04.08.2001','Selayar'),
('21.04.08.2002','Penuba'),
('21.04.08.2003','Penuba Timur'),
('21.04.08.2004','Pantai Harapan'),
('21.04.09','Singkep Selatan'),
('21.04.09.1004','Berlian'),
('21.04.09.2001','Marok Kecil'),
('21.04.09.2002','Pulau Lalang'),
('21.04.09.2003','Resang'),
('21.04.10','Kepulauan Posek'),
('21.04.10.2001','Busung Panjang'),
('21.04.10.2002','Posek'),
('21.04.10.2003','Suak Buaya'),
('21.04.11','Katang Bidare'),
('21.04.11.2001','Benan'),
('21.04.11.2002','Mensanak'),
('21.04.11.2003','Pulau Bukit'),
('21.04.11.2004','Pulau Duyung'),
('21.04.11.2005','Pulau Medang'),
('21.04.12','Temiang Pesisir'),
('21.04.12.2001','Temiang'),
('21.04.12.2002','Tajur Biru'),
('21.04.12.2003','Pulau Batang'),
('21.04.13','Bakung Serumpun'),
('21.04.13.2001','Batu Belubang'),
('21.04.13.2002','Cempa'),
('21.04.13.2003','Pasir Panjang'),
('21.04.13.2004','Tanjung Kelit'),
('21.04.13.2005','Tanjung Lipat'),
('21.04.13.2006','Rejai'),
('21.05','Kabupaten Kepulauan Anambas'),
('21.05.01','Siantan'),
('21.05.01.1001','Terempa'),
('21.05.01.2002','Terempa Barat'),
('21.05.01.2003','Tarempa Selatan'),
('21.05.01.2004','Tarempa Timur'),
('21.05.01.2005','Pesisir Timur'),
('21.05.01.2006','Sri Tanjung'),
('21.05.01.2007','Tarempa Barat Daya'),
('21.05.02','Palmatak'),
('21.05.02.2002','Tebang'),
('21.05.02.2003','Ladan'),
('21.05.02.2005','Piabung'),
('21.05.02.2006','Langir'),
('21.05.02.2007','Candi'),
('21.05.02.2008','Putik'),
('21.05.02.2015','Belibak'),
('21.05.03','Siantan Timur'),
('21.05.03.2001','Nyamuk'),
('21.05.03.2002','Batu Belah'),
('21.05.03.2003','Munjan'),
('21.05.03.2004','Serat'),
('21.05.03.2005','Air Putih'),
('21.05.03.2006','Temburun'),
('21.05.04','Siantan Selatan'),
('21.05.04.2001','Kiabu'),
('21.05.04.2002','Telaga'),
('21.05.04.2003','Mengkait'),
('21.05.04.2004','Tiangau'),
('21.05.04.2005','Telaga Kecil'),
('21.05.04.2006','Lingai'),
('21.05.04.2007','Air Bini'),
('21.05.05','Jemaja Timur'),
('21.05.05.2001','Kuala Maras'),
('21.05.05.2002','Ulu Maras'),
('21.05.05.2003','Bukit Padi'),
('21.05.05.2004','Genting Pulur'),
('21.05.06','Jemaja'),
('21.05.06.1005','Letung'),
('21.05.06.2001','Mampok'),
('21.05.06.2002','Rewak'),
('21.05.06.2006','Air Biru'),
('21.05.06.2008','Batu Berapit'),
('21.05.06.2009','Landak'),
('21.05.07','Siantan Tengah'),
('21.05.07.2001','Air Asuk'),
('21.05.07.2002','Air Sena'),
('21.05.07.2003','Teluk Siantan'),
('21.05.07.2004','Lidi'),
('21.05.07.2005','Liuk'),
('21.05.07.2006','Teluk Sunting'),
('21.05.08','Siantan Utara'),
('21.05.08.2001','Mubur'),
('21.05.08.2002','Piasan'),
('21.05.08.2003','Bayat'),
('21.05.09','Jemaja Barat'),
('21.05.09.2001','Impol'),
('21.05.09.2002','Keramut'),
('21.05.09.2003','Sunggak'),
('21.05.10','Kute Siantan'),
('21.05.10.2001','Payalaman'),
('21.05.10.2002','Payamaram'),
('21.05.10.2003','Batu Ampar'),
('21.05.10.2004','Matak'),
('21.05.10.2005','Teluk Bayur'),
('21.71','Kota Batam'),
('21.71.01','Belakang Padang'),
('21.71.01.1002','Pemping'),
('21.71.01.1003','Kasu'),
('21.71.01.1004','Pulau Terung'),
('21.71.01.1005','Pecong'),
('21.71.01.1006','Tanjung Sari'),
('21.71.01.1007','Sekanak Raya'),
('21.71.02','Batu Ampar'),
('21.71.02.1001','Tanjung Sengkuang'),
('21.71.02.1002','Sungai Jodoh'),
('21.71.02.1003','Batu Merah'),
('21.71.02.1004','Kampung Seraya'),
('21.71.03','Sekupang'),
('21.71.03.1001','Sungai Harapan'),
('21.71.03.1002','Tanjung Pinggir'),
('21.71.03.1003','Tanjung Riau'),
('21.71.03.1005','Tiban Indah'),
('21.71.03.1006','Tiban Baru'),
('21.71.03.1007','Tiban Lama'),
('21.71.03.1008','Patam Lestari'),
('21.71.04','Nongsa'),
('21.71.04.1001','Sambau'),
('21.71.04.1002','Batu Besar'),
('21.71.04.1003','Kabil'),
('21.71.04.1004','Ngenang'),
('21.71.05','Bulang'),
('21.71.05.1001','Bulang Lintang'),
('21.71.05.1002','Pulau Buluh'),
('21.71.05.1003','Temoyong'),
('21.71.05.1004','Batu Legong'),
('21.71.05.1005','Pantai Gelam'),
('21.71.05.1006','Pulau Setokok'),
('21.71.06','Lubuk Baja'),
('21.71.06.1001','Kampung Pelita'),
('21.71.06.1003','Lubuk Baja Kota'),
('21.71.06.1004','Batu Selicin'),
('21.71.06.1005','Tanjung Uma'),
('21.71.06.1006','Baloi Indah'),
('21.71.07','Sei Beduk'),
('21.71.07.1001','Muka Kuning'),
('21.71.07.1002','Duriangkang'),
('21.71.07.1003','Mangsang'),
('21.71.07.1004','Tanjung Piayu'),
('21.71.08','Galang'),
('21.71.08.1001','Sijantung'),
('21.71.08.1002','Karas'),
('21.71.08.1003','Galang Baru'),
('21.71.08.1004','Sembulang'),
('21.71.08.1005','Rempang Cate'),
('21.71.08.1006','Subang Mas'),
('21.71.08.1007','Pulau Abang'),
('21.71.08.1008','Air Raja'),
('21.71.09','Bengkong'),
('21.71.09.1001','Bengkong Indah'),
('21.71.09.1002','Bengkong Laut'),
('21.71.09.1003','Sadai'),
('21.71.09.1004','Tanjung Buntung'),
('21.71.10','Batam Kota'),
('21.71.10.1001','Baloi Permai'),
('21.71.10.1002','Taman Baloi'),
('21.71.10.1003','Teluk Tering'),
('21.71.10.1004','Belian'),
('21.71.10.1005','Sukajadi'),
('21.71.10.1006','Sungai Panas'),
('21.71.11','Sagulung'),
('21.71.11.1001','Tembesi'),
('21.71.11.1002','Sungai Binti'),
('21.71.11.1003','Sungai Lekop'),
('21.71.11.1004','Sagulung Kota'),
('21.71.11.1005','Sungai Langkai'),
('21.71.11.1006','Sungai Pelunggut'),
('21.71.12','Batu Aji'),
('21.71.12.1001','Tanjung Uncang'),
('21.71.12.1002','Buliang'),
('21.71.12.1003','Kibing'),
('21.71.12.1004','Bukit Tempayan'),
('21.72','Kota Tanjung Pinang'),
('21.72.01','Tanjung Pinang Barat'),
('21.72.01.1001','Tanjung Pinang Barat'),
('21.72.01.1002','Kemboja'),
('21.72.01.1003','Kampung Baru'),
('21.72.01.1004','Bukit Cermin'),
('21.72.02','Tanjung Pinang Timur'),
('21.72.02.1001','Melayu Kota Piring'),
('21.72.02.1002','Kampung Bulang'),
('21.72.02.1003','Air Raja'),
('21.72.02.1004','Batu IX'),
('21.72.02.1005','Pinang Kencana'),
('21.72.03','Tanjung Pinang Kota'),
('21.72.03.1001','Tanjung Pinang Kota'),
('21.72.03.1003','Senggarang'),
('21.72.03.1004','Penyengat'),
('21.72.03.1005','Kampung Bugis'),
('21.72.04','Bukit Bestari'),
('21.72.04.1001','Tanjung Pinang Timur'),
('21.72.04.1002','Dompak'),
('21.72.04.1003','Tanjung Ayun Sakti'),
('21.72.04.1004','Sei Jang'),
('21.72.04.1005','Tanjung Unggat');

-- Provinsi DKI JAKARTA
INSERT INTO wilayah (kode, nama)
VALUES
('31','Daerah Khusus Ibukota Jakarta'),
('31.01','Kabupaten Administrasi Kepulauan Seribu'),
('31.01.01','Kepulauan Seribu Utara'),
('31.01.01.1001','Pulau Panggang'),
('31.01.01.1002','Pulau Kelapa'),
('31.01.01.1003','Pulau Harapan'),
('31.01.02','Kepulauan Seribu Selatan'),
('31.01.02.1001','Pulau Untung Jawa'),
('31.01.02.1002','Pulau Tidung'),
('31.01.02.1003','Pulau Pari'),
('31.71','Kota Administrasi Jakarta Pusat'),
('31.71.01','Gambir'),
('31.71.01.1001','Gambir'),
('31.71.01.1002','Cideng'),
('31.71.01.1003','Petojo Utara'),
('31.71.01.1004','Petojo Selatan'),
('31.71.01.1005','Kebon Kelapa'),
('31.71.01.1006','Duri Pulo'),
('31.71.02','Sawah Besar'),
('31.71.02.1001','Pasar Baru'),
('31.71.02.1002','Karang Anyar'),
('31.71.02.1003','Kartini'),
('31.71.02.1004','Gunung Sahari Utara'),
('31.71.02.1005','Mangga Dua Selatan'),
('31.71.03','Kemayoran'),
('31.71.03.1001','Kemayoran'),
('31.71.03.1002','Kebon Kosong'),
('31.71.03.1003','Harapan Mulia'),
('31.71.03.1004','Serdang'),
('31.71.03.1005','Gunung Sahari Selatan'),
('31.71.03.1006','Cempaka Baru'),
('31.71.03.1007','Sumur Batu'),
('31.71.03.1008','Utan Panjang'),
('31.71.04','Senen'),
('31.71.04.1001','Senen'),
('31.71.04.1002','Kenari'),
('31.71.04.1003','Paseban'),
('31.71.04.1004','Kramat'),
('31.71.04.1005','Kwitang'),
('31.71.04.1006','Bungur'),
('31.71.05','Cempaka Putih'),
('31.71.05.1001','Cempaka Putih Timur'),
('31.71.05.1002','Cempaka Putih Barat'),
('31.71.05.1003','Rawasari'),
('31.71.06','Menteng'),
('31.71.06.1001','Menteng'),
('31.71.06.1002','Pegangsaan'),
('31.71.06.1003','Cikini'),
('31.71.06.1004','Gondangdia'),
('31.71.06.1005','Kebon Sirih'),
('31.71.07','Tanah Abang'),
('31.71.07.1001','Gelora'),
('31.71.07.1002','Bendungan Hilir'),
('31.71.07.1003','Karet Tengsin'),
('31.71.07.1004','Petamburan'),
('31.71.07.1005','Kebon Melati'),
('31.71.07.1006','Kebon Kacang'),
('31.71.07.1007','Kampung Bali'),
('31.71.08','Johar Baru'),
('31.71.08.1001','Johar Baru'),
('31.71.08.1002','Kampung Rawa'),
('31.71.08.1003','Galur'),
('31.71.08.1004','Tanah Tinggi'),
('31.72','Kota Administrasi Jakarta Utara '),
('31.72.01','Penjaringan'),
('31.72.01.1001','Penjaringan'),
('31.72.01.1002','Kamal Muara'),
('31.72.01.1003','Kapuk Muara'),
('31.72.01.1004','Pejagalan'),
('31.72.01.1005','Pluit'),
('31.72.02','Tanjung Priok'),
('31.72.02.1001','Tanjung Priok'),
('31.72.02.1002','Sunter Jaya'),
('31.72.02.1003','Papanggo'),
('31.72.02.1004','Sungai Bambu'),
('31.72.02.1005','Kebon Bawang'),
('31.72.02.1006','Sunter Agung'),
('31.72.02.1007','Warakas'),
('31.72.03','Koja'),
('31.72.03.1001','Koja'),
('31.72.03.1002','Tugu Utara'),
('31.72.03.1003','Lagoa'),
('31.72.03.1004','Rawa Badak Utara'),
('31.72.03.1005','Tugu Selatan'),
('31.72.03.1006','Rawa Badak Selatan'),
('31.72.04','Cilincing'),
('31.72.04.1001','Cilincing'),
('31.72.04.1002','Sukapura'),
('31.72.04.1003','Marunda'),
('31.72.04.1004','Kalibaru'),
('31.72.04.1005','Semper Timur'),
('31.72.04.1006','Rorotan'),
('31.72.04.1007','Semper Barat'),
('31.72.05','Pademangan'),
('31.72.05.1001','Pademangan Timur'),
('31.72.05.1002','Pademangan Barat'),
('31.72.05.1003','Ancol'),
('31.72.06','Kelapa Gading'),
('31.72.06.1001','Kelapa Gading Timur'),
('31.72.06.1002','Pegangsaan Dua'),
('31.72.06.1003','Kelapa Gading Barat'),
('31.73','Kota Administrasi Jakarta Barat'),
('31.73.01','Cengkareng'),
('31.73.01.1001','Cengkareng Barat'),
('31.73.01.1002','Duri Kosambi'),
('31.73.01.1003','Rawa Buaya'),
('31.73.01.1004','Kedaung Kali Angke'),
('31.73.01.1005','Kapuk'),
('31.73.01.1006','Cengkareng Timur'),
('31.73.02','Grogol Petamburan'),
('31.73.02.1001','Grogol'),
('31.73.02.1002','Tanjung Duren Utara'),
('31.73.02.1003','Tomang'),
('31.73.02.1004','Jelambar'),
('31.73.02.1005','Tanjung Duren Selatan'),
('31.73.02.1006','Jelambar Baru'),
('31.73.02.1007','Wijaya Kusuma'),
('31.73.03','Taman Sari'),
('31.73.03.1001','Taman Sari'),
('31.73.03.1002','Krukut'),
('31.73.03.1003','Maphar'),
('31.73.03.1004','Tangki'),
('31.73.03.1005','Mangga Besar'),
('31.73.03.1006','Keagungan'),
('31.73.03.1007','Glodok'),
('31.73.03.1008','Pinangsia'),
('31.73.04','Tambora'),
('31.73.04.1001','Tambora'),
('31.73.04.1002','Kali Anyar'),
('31.73.04.1003','Duri Utara'),
('31.73.04.1004','Tanah Sereal'),
('31.73.04.1005','Krendang'),
('31.73.04.1006','Jembatan Besi'),
('31.73.04.1007','Angke'),
('31.73.04.1008','Jembatan Lima'),
('31.73.04.1009','Pekojan'),
('31.73.04.1010','Roa Malaka'),
('31.73.04.1011','Duri Selatan'),
('31.73.05','Kebon Jeruk'),
('31.73.05.1001','Kebon Jeruk'),
('31.73.05.1002','Sukabumi Utara'),
('31.73.05.1003','Sukabumi Selatan'),
('31.73.05.1004','Kelapa Dua'),
('31.73.05.1005','Duri Kepa'),
('31.73.05.1006','Kedoya Utara'),
('31.73.05.1007','Kedoya Selatan'),
('31.73.06','Kalideres'),
('31.73.06.1001','Kalideres'),
('31.73.06.1002','Semanan'),
('31.73.06.1003','Tegal Alur'),
('31.73.06.1004','Kamal'),
('31.73.06.1005','Pegadungan'),
('31.73.07','Pal Merah'),
('31.73.07.1001','Palmerah'),
('31.73.07.1002','Slipi'),
('31.73.07.1003','Kota Bambu Utara'),
('31.73.07.1004','Jatipulo'),
('31.73.07.1005','Kemanggisan'),
('31.73.07.1006','Kota Bambu Selatan'),
('31.73.08','Kembangan'),
('31.73.08.1001','Kembangan Utara'),
('31.73.08.1002','Meruya Utara'),
('31.73.08.1003','Meruya Selatan'),
('31.73.08.1004','Srengseng'),
('31.73.08.1005','Joglo'),
('31.73.08.1006','Kembangan Selatan'),
('31.74','Kota Administrasi Jakarta Selatan'),
('31.74.01','Tebet'),
('31.74.01.1001','Tebet Timur'),
('31.74.01.1002','Tebet Barat'),
('31.74.01.1003','Menteng Dalam'),
('31.74.01.1004','Kebon Baru'),
('31.74.01.1005','Bukit Duri'),
('31.74.01.1006','Manggarai Selatan'),
('31.74.01.1007','Manggarai'),
('31.74.02','Setiabudi'),
('31.74.02.1001','Setia Budi'),
('31.74.02.1002','Karet Semanggi'),
('31.74.02.1003','Karet Kuningan'),
('31.74.02.1004','Karet'),
('31.74.02.1005','Menteng Atas'),
('31.74.02.1006','Pasar Manggis'),
('31.74.02.1007','Guntur'),
('31.74.02.1008','Kuningan Timur'),
('31.74.03','Mampang Prapatan'),
('31.74.03.1001','Mampang Prapatan'),
('31.74.03.1002','Bangka'),
('31.74.03.1003','Pela Mampang'),
('31.74.03.1004','Tegal Parang'),
('31.74.03.1005','Kuningan Barat'),
('31.74.04','Pasar Minggu'),
('31.74.04.1001','Pasar Minggu'),
('31.74.04.1002','Jati Padang'),
('31.74.04.1003','Cilandak Timur'),
('31.74.04.1004','Ragunan'),
('31.74.04.1005','Pejaten Timur'),
('31.74.04.1006','Pejaten Barat'),
('31.74.04.1007','Kebagusan'),
('31.74.05','Kebayoran Lama'),
('31.74.05.1001','Kebayoran Lama Utara'),
('31.74.05.1002','Pondok Pinang'),
('31.74.05.1003','Cipulir'),
('31.74.05.1004','Grogol Utara'),
('31.74.05.1005','Grogol Selatan'),
('31.74.05.1006','Kebayoran Lama Selatan'),
('31.74.06','Cilandak'),
('31.74.06.1001','Cilandak Barat'),
('31.74.06.1002','Lebak Bulus'),
('31.74.06.1003','Pondok Labu'),
('31.74.06.1004','Gandaria Selatan'),
('31.74.06.1005','Cipete Selatan'),
('31.74.07','Kebayoran Baru'),
('31.74.07.1001','Melawai'),
('31.74.07.1002','Gunung'),
('31.74.07.1003','Kramat Pela'),
('31.74.07.1004','Selong'),
('31.74.07.1005','Rawa Barat'),
('31.74.07.1006','Senayan'),
('31.74.07.1007','Pulo'),
('31.74.07.1008','Petogogan'),
('31.74.07.1009','Gandaria Utara'),
('31.74.07.1010','Cipete Utara'),
('31.74.08','Pancoran'),
('31.74.08.1001','Pancoran'),
('31.74.08.1002','Kalibata'),
('31.74.08.1003','Rawajati'),
('31.74.08.1004','Duren Tiga'),
('31.74.08.1005','Pengadegan'),
('31.74.08.1006','Cikoko'),
('31.74.09','Jagakarsa'),
('31.74.09.1001','Jagakarsa'),
('31.74.09.1002','Srengseng Sawah'),
('31.74.09.1003','Ciganjur'),
('31.74.09.1004','Lenteng Agung'),
('31.74.09.1005','Tanjung Barat'),
('31.74.09.1006','Cipedak'),
('31.74.10','Pesanggrahan'),
('31.74.10.1001','Pesanggrahan'),
('31.74.10.1002','Bintaro'),
('31.74.10.1003','Petukangan Utara'),
('31.74.10.1004','Petukangan Selatan'),
('31.74.10.1005','Ulujami'),
('31.75','Kota Administrasi Jakarta Timur'),
('31.75.01','Matraman'),
('31.75.01.1001','Pisangan Baru'),
('31.75.01.1002','Utan Kayu Utara'),
('31.75.01.1003','Kayu Manis'),
('31.75.01.1004','Palmeriam'),
('31.75.01.1005','Kebon Manggis'),
('31.75.01.1006','Utan Kayu Selatan'),
('31.75.02','Pulogadung'),
('31.75.02.1001','Pulo Gadung'),
('31.75.02.1002','Pisangan Timur'),
('31.75.02.1003','Cipinang'),
('31.75.02.1004','Jatinegara Kaum'),
('31.75.02.1005','Rawamangun'),
('31.75.02.1006','Kayu Putih'),
('31.75.02.1007','Jati'),
('31.75.03','Jatinegara'),
('31.75.03.1001','Kampung Melayu'),
('31.75.03.1002','Bidara Cina'),
('31.75.03.1003','Bali Mester'),
('31.75.03.1004','Rawa Bunga'),
('31.75.03.1005','Cipinang Cempedak'),
('31.75.03.1006','Cipinang Muara'),
('31.75.03.1007','Cipinang Besar Selatan'),
('31.75.03.1008','Cipinang Besar Utara'),
('31.75.04','Kramatjati'),
('31.75.04.1001','Kramatjati'),
('31.75.04.1002','Tengah'),
('31.75.04.1003','Dukuh'),
('31.75.04.1004','Batu Ampar'),
('31.75.04.1005','Balekambang'),
('31.75.04.1006','Cililitan'),
('31.75.04.1007','Cawang'),
('31.75.05','Pasar Rebo'),
('31.75.05.1001','Gedong'),
('31.75.05.1002','Baru'),
('31.75.05.1003','Cijantung'),
('31.75.05.1004','Kalisari'),
('31.75.05.1005','Pekayon'),
('31.75.06','Cakung'),
('31.75.06.1001','Jatinegara'),
('31.75.06.1002','Rawa Terate'),
('31.75.06.1003','Penggilingan'),
('31.75.06.1004','Cakung Timur'),
('31.75.06.1005','Pulo Gebang'),
('31.75.06.1006','Ujung Menteng'),
('31.75.06.1007','Cakung Barat'),
('31.75.07','Duren Sawit'),
('31.75.07.1001','Duren Sawit'),
('31.75.07.1002','Pondok Bambu'),
('31.75.07.1003','Klender'),
('31.75.07.1004','Pondok Kelapa'),
('31.75.07.1005','Malaka Sari'),
('31.75.07.1006','Malaka Jaya'),
('31.75.07.1007','Pondok Kopi'),
('31.75.08','Makasar'),
('31.75.08.1001','Makasar'),
('31.75.08.1002','Pinangranti'),
('31.75.08.1003','Kebon Pala'),
('31.75.08.1004','Halim Perdana Kusuma'),
('31.75.08.1005','Cipinang Melayu'),
('31.75.09','Ciracas'),
('31.75.09.1001','Ciracas'),
('31.75.09.1002','Cibubur'),
('31.75.09.1003','Kelapa Dua Wetan'),
('31.75.09.1004','Susukan'),
('31.75.09.1005','Rambutan'),
('31.75.10','Cipayung'),
('31.75.10.1001','Cipayung'),
('31.75.10.1002','Cilangkap'),
('31.75.10.1003','Pondok Ranggon'),
('31.75.10.1004','Munjul'),
('31.75.10.1005','Setu'),
('31.75.10.1006','Bambu Apus'),
('31.75.10.1007','Lubang Buaya'),
('31.75.10.1008','Ceger');

-- Provinsi JAWA BARAT
INSERT INTO wilayah (kode, nama)
VALUES
('32','Jawa Barat'),
('32.01','Kabupaten Bogor'),
('32.01.01','Cibinong'),
('32.01.01.1001','Pondok Rajeg'),
('32.01.01.1002','Karadenan'),
('32.01.01.1003','Harapanjaya'),
('32.01.01.1004','Nanggewer'),
('32.01.01.1005','Nanggewer Mekar'),
('32.01.01.1006','Cibinong'),
('32.01.01.1007','Pakansari'),
('32.01.01.1008','Tengah'),
('32.01.01.1009','Sukahati'),
('32.01.01.1010','Ciriung'),
('32.01.01.1011','Cirimekar'),
('32.01.01.1012','Pabuaran'),
('32.01.01.1013','Pabuaran Mekar'),
('32.01.02','Gunungputri'),
('32.01.02.2001','Wanaherang'),
('32.01.02.2002','Bojongkulur'),
('32.01.02.2003','Ciangsana'),
('32.01.02.2004','Gunungputri'),
('32.01.02.2005','Bojongnangka'),
('32.01.02.2006','Tlajung Udik'),
('32.01.02.2007','Cicadas'),
('32.01.02.2008','Cikeas Udik'),
('32.01.02.2009','Nagrak'),
('32.01.02.2010','Karanggan'),
('32.01.03','Citeureup'),
('32.01.03.1006','Puspanegara'),
('32.01.03.1007','Karang Asem Barat'),
('32.01.03.2001','Puspasari'),
('32.01.03.2002','Citeureup'),
('32.01.03.2003','Leuwinutug'),
('32.01.03.2004','Tajur'),
('32.01.03.2005','Sanja'),
('32.01.03.2008','Karang Asem Timur'),
('32.01.03.2009','Tarikolot'),
('32.01.03.2010','Gunungsari'),
('32.01.03.2011','Tangkil'),
('32.01.03.2012','Sukahati'),
('32.01.03.2013','Hambalang'),
('32.01.03.2014','Pasir Mukti'),
('32.01.04','Sukaraja'),
('32.01.04.2001','Gunung Geulis'),
('32.01.04.2002','Cilebut Timur'),
('32.01.04.2003','Cilebut Barat'),
('32.01.04.2004','Cibanon'),
('32.01.04.2005','Nagrak'),
('32.01.04.2006','Sukatani'),
('32.01.04.2007','Sukaraja'),
('32.01.04.2008','Cikeas'),
('32.01.04.2009','Pasirjambu'),
('32.01.04.2010','Cimandala'),
('32.01.04.2011','Cijujung'),
('32.01.04.2012','Cadasngampar'),
('32.01.04.2013','Pasirlaja'),
('32.01.05','Babakan Madang'),
('32.01.05.2001','Cijayanti'),
('32.01.05.2002','Sumur Batu'),
('32.01.05.2003','Sentul'),
('32.01.05.2004','Karang Tengah'),
('32.01.05.2005','Cipambuan'),
('32.01.05.2006','Kadumanggu'),
('32.01.05.2007','Citaringgul'),
('32.01.05.2008','Babakan Madang'),
('32.01.05.2009','Bojong Koneng'),
('32.01.06','Jonggol'),
('32.01.06.2001','Sukamaju'),
('32.01.06.2002','Sirnagalih'),
('32.01.06.2003','Singajaya'),
('32.01.06.2004','Sukasirna'),
('32.01.06.2005','Sukanegara'),
('32.01.06.2006','Sukamanah'),
('32.01.06.2007','Weninggalih'),
('32.01.06.2008','Cibodas'),
('32.01.06.2009','Jonggol'),
('32.01.06.2010','Bendungan'),
('32.01.06.2011','Singasari'),
('32.01.06.2012','Balekambang'),
('32.01.06.2013','Sukajaya'),
('32.01.06.2014','Sukagalih'),
('32.01.07','Cileungsi'),
('32.01.07.2001','Pasirangin'),
('32.01.07.2002','Mekarsari'),
('32.01.07.2003','Mampir'),
('32.01.07.2004','Dayeuh'),
('32.01.07.2005','Gandoang'),
('32.01.07.2006','Jatisari'),
('32.01.07.2007','Cileungsi Kidul'),
('32.01.07.2008','Cipeucang'),
('32.01.07.2009','Situsari'),
('32.01.07.2010','Cipenjo'),
('32.01.07.2011','Limusnunggal'),
('32.01.07.2012','Cileungsi'),
('32.01.08','Cariu'),
('32.01.08.2001','Karyamekar'),
('32.01.08.2002','Babakanraden'),
('32.01.08.2003','Cikutamahi'),
('32.01.08.2004','Kutamekar'),
('32.01.08.2005','Cariu'),
('32.01.08.2006','Mekarwangi'),
('32.01.08.2007','Bantarkuning'),
('32.01.08.2008','Sukajadi'),
('32.01.08.2009','Tegalpanjang'),
('32.01.08.2010','Cibatutiga'),
('32.01.09','Sukamakmur'),
('32.01.09.2001','Wargajaya'),
('32.01.09.2002','Pabuaran'),
('32.01.09.2003','Sukadamai'),
('32.01.09.2004','Sukawangi'),
('32.01.09.2005','Cibadak'),
('32.01.09.2006','Sukaresmi'),
('32.01.09.2007','Sukamulya'),
('32.01.09.2008','Sukaharja'),
('32.01.09.2009','Sirnajaya'),
('32.01.09.2010','Sukamakmur'),
('32.01.10','Parung'),
('32.01.10.2001','Parung'),
('32.01.10.2002','Iwul'),
('32.01.10.2003','Bojong Sempu'),
('32.01.10.2004','Waru'),
('32.01.10.2005','Cogreg'),
('32.01.10.2006','Pamegarsari'),
('32.01.10.2007','Waru Jaya'),
('32.01.10.2008','Bojong Indah'),
('32.01.10.2009','Jabon Mekar'),
('32.01.11','Gunungsindur'),
('32.01.11.2001','Cidokom'),
('32.01.11.2002','Padurenan'),
('32.01.11.2003','Pengasinan'),
('32.01.11.2004','Curug'),
('32.01.11.2005','Gunungsindur'),
('32.01.11.2006','Jampang'),
('32.01.11.2007','Cibadung'),
('32.01.11.2008','Cibinong'),
('32.01.11.2009','Rawakalong'),
('32.01.11.2010','Pabuaran'),
('32.01.12','Kemang'),
('32.01.12.1006','Atang Senjaya'),
('32.01.12.2001','Bojong'),
('32.01.12.2002','Parakanjaya'),
('32.01.12.2003','Kemang'),
('32.01.12.2004','Pabuaran'),
('32.01.12.2005','Semplak Barat'),
('32.01.12.2007','Jampang'),
('32.01.12.2008','Pondok Udik'),
('32.01.12.2009','Tegal'),
('32.01.13','Bojonggede'),
('32.01.13.1007','Pabuaran'),
('32.01.13.2001','Bojongbaru'),
('32.01.13.2002','Cimanggis'),
('32.01.13.2003','Susukan'),
('32.01.13.2004','Ragajaya'),
('32.01.13.2005','Kedung Waringin'),
('32.01.13.2006','Waringin Jaya'),
('32.01.13.2008','Rawapanjang'),
('32.01.13.2009','Bojonggede'),
('32.01.14','Leuwiliang'),
('32.01.14.2001','Leuwiliang'),
('32.01.14.2002','Purasari'),
('32.01.14.2003','Karyasari'),
('32.01.14.2004','Pabangbon'),
('32.01.14.2005','Karacak'),
('32.01.14.2006','Barengkok'),
('32.01.14.2007','Leuwimekar'),
('32.01.14.2008','Puraseda'),
('32.01.14.2009','Cibeber I'),
('32.01.14.2010','Cibeber II'),
('32.01.14.2011','Karehkel'),
('32.01.15','Ciampea'),
('32.01.15.2001','Ciampea'),
('32.01.15.2002','Cinangka'),
('32.01.15.2003','Cihideung Udik'),
('32.01.15.2004','Bojongjengkol'),
('32.01.15.2005','Tegalwaru'),
('32.01.15.2006','Cibuntu'),
('32.01.15.2007','Cicadas'),
('32.01.15.2008','Cibadak'),
('32.01.15.2009','Bojongrangkas'),
('32.01.15.2010','Cihideung Ilir'),
('32.01.15.2011','Cibanteng'),
('32.01.15.2012','Benteng'),
('32.01.15.2013','Ciampea Udik'),
('32.01.16','Cibungbulang'),
('32.01.16.2001','Situ Udik'),
('32.01.16.2002','Situ Ilir'),
('32.01.16.2003','Cemplang'),
('32.01.16.2004','Cibatok I'),
('32.01.16.2005','Ciaruteun Udik'),
('32.01.16.2006','Leuweungkolot'),
('32.01.16.2007','Cimanggu I'),
('32.01.16.2008','Cimanggu II'),
('32.01.16.2009','Dukuh'),
('32.01.16.2010','Cijujung'),
('32.01.16.2011','Ciaruteun Ilir'),
('32.01.16.2012','Cibatok II'),
('32.01.16.2013','Sukamaju'),
('32.01.16.2014','Galuga'),
('32.01.16.2015','Girimulya'),
('32.01.17','Pamijahan'),
('32.01.17.2001','Purwabakti'),
('32.01.17.2002','Cibunian'),
('32.01.17.2003','Cibitung Wetan'),
('32.01.17.2004','Gunung Menyan'),
('32.01.17.2005','Gunung Bunder II'),
('32.01.17.2006','Pasarean'),
('32.01.17.2007','Cimayang'),
('32.01.17.2008','Pamijahan'),
('32.01.17.2009','Cibening'),
('32.01.17.2010','Gunung Bunder I'),
('32.01.17.2011','Cibitung Kulon'),
('32.01.17.2012','Gunung Picung'),
('32.01.17.2013','Ciasihan'),
('32.01.17.2014','Gunung Sari'),
('32.01.17.2015','Ciasmara'),
('32.01.18','Rumpin'),
('32.01.18.2001','Rumpin'),
('32.01.18.2002','Leuwibatu'),
('32.01.18.2003','Cidokom'),
('32.01.18.2004','Gobang'),
('32.01.18.2005','Cibodas'),
('32.01.18.2006','Rabak'),
('32.01.18.2007','Kampung Sawah'),
('32.01.18.2008','Cipinang'),
('32.01.18.2009','Sukasari'),
('32.01.18.2010','Tamansari'),
('32.01.18.2011','Kertajaya'),
('32.01.18.2012','Sukamulya'),
('32.01.18.2013','Mekarsari'),
('32.01.18.2014','Mekarjaya'),
('32.01.19','Jasinga'),
('32.01.19.2001','Curug'),
('32.01.19.2002','Pangradin'),
('32.01.19.2003','Kalongsawah'),
('32.01.19.2004','Sipak'),
('32.01.19.2005','Jasinga'),
('32.01.19.2006','Koleang'),
('32.01.19.2007','Cikopomayak'),
('32.01.19.2008','Setu'),
('32.01.19.2009','Barengkok'),
('32.01.19.2010','Bagoang'),
('32.01.19.2011','Pangaur'),
('32.01.19.2012','Pamagersari'),
('32.01.19.2013','Jugalajaya'),
('32.01.19.2014','Tegalwangi'),
('32.01.19.2015','Neglasari'),
('32.01.19.2016','Wirajaya'),
('32.01.20','Parungpanjang'),
('32.01.20.2001','Jagabaya'),
('32.01.20.2002','Gorowong'),
('32.01.20.2003','Dago'),
('32.01.20.2004','Pingku'),
('32.01.20.2005','Cikuda'),
('32.01.20.2006','Parungpanjang'),
('32.01.20.2007','Lumpang'),
('32.01.20.2008','Cibunar'),
('32.01.20.2009','Jagabita'),
('32.01.20.2010','Gintungcilejet'),
('32.01.20.2011','Kabasiran'),
('32.01.21','Nanggung'),
('32.01.21.2001','Malasari'),
('32.01.21.2002','Curugbitung'),
('32.01.21.2003','Cisarua'),
('32.01.21.2004','Bantarkaret'),
('32.01.21.2005','Hambaro'),
('32.01.21.2006','Kalongliud'),
('32.01.21.2007','Nanggung'),
('32.01.21.2008','Parakanmuncang'),
('32.01.21.2009','Pangkaljaya'),
('32.01.21.2010','Sukaluyu'),
('32.01.21.2011','Batu Tulis'),
('32.01.22','Cigudeg'),
('32.01.22.2001','Sukamaju'),
('32.01.22.2002','Cigudeg'),
('32.01.22.2003','Bunar'),
('32.01.22.2004','Banyuresmi'),
('32.01.22.2005','Cintamanik'),
('32.01.22.2006','Argapura'),
('32.01.22.2007','Bangunjaya'),
('32.01.22.2008','Rengasjajar'),
('32.01.22.2009','Batujajar'),
('32.01.22.2010','Wargajaya'),
('32.01.22.2011','Sukaraksa'),
('32.01.22.2012','Banyuwangi'),
('32.01.22.2013','Banyuasih'),
('32.01.22.2014','Mekarjaya'),
('32.01.22.2015','Tegallega'),
('32.01.23','Tenjo'),
('32.01.23.2001','Tapos'),
('32.01.23.2002','Ciomas'),
('32.01.23.2003','Batok'),
('32.01.23.2004','Babakan'),
('32.01.23.2005','Tenjo'),
('32.01.23.2006','Cilaku'),
('32.01.23.2007','Singabraja'),
('32.01.23.2008','Singabangsa'),
('32.01.23.2009','Bojong'),
('32.01.24','Ciawi'),
('32.01.24.2001','Cileungsi'),
('32.01.24.2002','Citapen'),
('32.01.24.2003','Cibedug'),
('32.01.24.2004','Jambuluwuk'),
('32.01.24.2005','Banjarsari'),
('32.01.24.2006','Telukpinang'),
('32.01.24.2007','Banjarwaru'),
('32.01.24.2008','Bendungan'),
('32.01.24.2009','Pandansari'),
('32.01.24.2010','Bojongmurni'),
('32.01.24.2011','Banjarwangi'),
('32.01.24.2012','Ciawi'),
('32.01.24.2013','Bitungsari'),
('32.01.25','Cisarua'),
('32.01.25.1010','Cisarua'),
('32.01.25.2001','Batulayang'),
('32.01.25.2002','Jogjogan'),
('32.01.25.2003','Cibeureum'),
('32.01.25.2004','Cilember'),
('32.01.25.2005','Citeko'),
('32.01.25.2006','Tugu Selatan'),
('32.01.25.2007','Leuwimalang'),
('32.01.25.2008','Kopo'),
('32.01.25.2009','Tugu Utara'),
('32.01.26','Megamendung'),
('32.01.26.2001','Sukamaju'),
('32.01.26.2002','Kuta'),
('32.01.26.2003','Gadog'),
('32.01.26.2004','Sukakarya'),
('32.01.26.2005','Megamendung'),
('32.01.26.2006','Cipayung'),
('32.01.26.2007','Sukamanah'),
('32.01.26.2008','Sukagalih'),
('32.01.26.2009','Cipayung Girang'),
('32.01.26.2010','Sukamahi'),
('32.01.26.2011','Sukaresmi'),
('32.01.26.2012','Pasir Angin'),
('32.01.27','Caringin'),
('32.01.27.2001','Pasirmuncang'),
('32.01.27.2002','Cimande Hilir'),
('32.01.27.2003','Ciderum'),
('32.01.27.2004','Caringin'),
('32.01.27.2005','Ciherang Pondok'),
('32.01.27.2006','Cinagara'),
('32.01.27.2007','Cimande'),
('32.01.27.2008','Pancawati'),
('32.01.27.2009','Muarajaya'),
('32.01.27.2010','Pasirbuncir'),
('32.01.27.2011','Lemah Duhur'),
('32.01.27.2012','Tangkil'),
('32.01.28','Cijeruk'),
('32.01.28.2001','Cijeruk'),
('32.01.28.2002','Cipelang'),
('32.01.28.2003','Warungmenteng'),
('32.01.28.2004','Tajurhalang'),
('32.01.28.2005','Cipicung'),
('32.01.28.2006','Cibalung'),
('32.01.28.2007','Sukaharja'),
('32.01.28.2008','Palasari'),
('32.01.28.2009','Tanjungsari'),
('32.01.29','Ciomas'),
('32.01.29.1003','Padasuka'),
('32.01.29.2001','Mekarjaya'),
('32.01.29.2002','Sukaharja'),
('32.01.29.2004','Parakan'),
('32.01.29.2005','Ciomas'),
('32.01.29.2006','Pagelaran'),
('32.01.29.2007','Sukamakmur'),
('32.01.29.2008','Ciapus'),
('32.01.29.2009','Kotabatu'),
('32.01.29.2010','Laladon'),
('32.01.29.2011','Ciomas Rahayu'),
('32.01.30','Dramaga'),
('32.01.30.2001','Sukadamai'),
('32.01.30.2002','Ciherang'),
('32.01.30.2003','Sinarsari'),
('32.01.30.2004','Sukawening'),
('32.01.30.2005','Petir'),
('32.01.30.2006','Purwasari'),
('32.01.30.2007','Cikarawang'),
('32.01.30.2008','Babakan'),
('32.01.30.2009','Dramaga'),
('32.01.30.2010','Neglasari'),
('32.01.31','Tamansari'),
('32.01.31.2001','Sukamantri'),
('32.01.31.2002','Sirnagalih'),
('32.01.31.2003','Pasir Eurih'),
('32.01.31.2004','Tamansari'),
('32.01.31.2005','Sukaluyu'),
('32.01.31.2006','Sukaresmi'),
('32.01.31.2007','Sukajaya'),
('32.01.31.2008','Sukajadi'),
('32.01.32','Klapanunggal'),
('32.01.32.2001','Klapanunggal'),
('32.01.32.2002','Bojong'),
('32.01.32.2003','Nambo'),
('32.01.32.2004','Lulut'),
('32.01.32.2005','Cikahuripan'),
('32.01.32.2006','Kembangkuning'),
('32.01.32.2007','Bantarjati'),
('32.01.32.2008','Leuwikaret'),
('32.01.32.2009','Ligarmukti'),
('32.01.33','Ciseeng'),
('32.01.33.2001','Putat Nutug'),
('32.01.33.2002','Ciseeng'),
('32.01.33.2003','Parigi Mekar'),
('32.01.33.2004','Cibentang'),
('32.01.33.2005','Cibeuteung Udik'),
('32.01.33.2006','Karihkil'),
('32.01.33.2007','Babakan'),
('32.01.33.2008','Cihowe'),
('32.01.33.2009','Cibeuteung Muara'),
('32.01.33.2010','Kuripan'),
('32.01.34','Rancabungur'),
('32.01.34.2001','Bantarjaya'),
('32.01.34.2002','Bantarsari'),
('32.01.34.2003','Pasirgaok'),
('32.01.34.2004','Rancabungur'),
('32.01.34.2005','Mekarsari'),
('32.01.34.2006','Candali'),
('32.01.34.2007','Cimulang'),
('32.01.35','Sukajaya'),
('32.01.35.2001','Cisarua'),
('32.01.35.2002','Kiarasari'),
('32.01.35.2003','Sukajaya'),
('32.01.35.2004','Sipayung'),
('32.01.35.2005','Cileuksa'),
('32.01.35.2006','Kiarapandak'),
('32.01.35.2007','Harkatjaya'),
('32.01.35.2008','Sukamulih'),
('32.01.35.2009','Pasir Madang'),
('32.01.35.2010','Urug'),
('32.01.35.2011','Jayaraharja'),
('32.01.36','Tanjungsari'),
('32.01.36.2001','Tanjungsari'),
('32.01.36.2002','Selawangi'),
('32.01.36.2003','Tanjungrasa'),
('32.01.36.2004','Antajaya'),
('32.01.36.2005','Pasirtanjung'),
('32.01.36.2006','Cibadak'),
('32.01.36.2007','Sukarasa'),
('32.01.36.2008','Sirnasari'),
('32.01.36.2009','Buanajaya'),
('32.01.36.2010','Sirnarasa'),
('32.01.37','Tajurhalang'),
('32.01.37.2001','Tajurhalang'),
('32.01.37.2002','Citayam'),
('32.01.37.2003','Sasak Panjang'),
('32.01.37.2004','Nanggerang'),
('32.01.37.2005','Sukmajaya'),
('32.01.37.2006','Tonjong'),
('32.01.37.2007','Kalisuren'),
('32.01.38','Cigombong'),
('32.01.38.2001','Cigombong'),
('32.01.38.2002','Wates Jaya'),
('32.01.38.2003','Ciburuy'),
('32.01.38.2004','Srogol'),
('32.01.38.2005','Cisalada'),
('32.01.38.2006','Tugujaya'),
('32.01.38.2007','Pasirjaya'),
('32.01.38.2008','Ciburayut'),
('32.01.38.2009','Ciadeg'),
('32.01.39','Leuwisadeng'),
('32.01.39.2001','Leuwisadeng'),
('32.01.39.2002','Babakan Sadeng'),
('32.01.39.2003','Sadengkolot'),
('32.01.39.2004','Wangunjaya'),
('32.01.39.2005','Kalong I'),
('32.01.39.2006','Kalong II'),
('32.01.39.2007','Sadeng'),
('32.01.39.2008','Sibanteng'),
('32.01.40','Tenjolaya'),
('32.01.40.2001','Tapos I'),
('32.01.40.2002','Tapos II'),
('32.01.40.2003','Cibitung Tengah'),
('32.01.40.2004','Situdaun'),
('32.01.40.2005','Cinangneng'),
('32.01.40.2006','Gunung Malang'),
('32.01.40.2007','Gunung Mulya'),
('32.02','Kabupaten Sukabumi'),
('32.02.01','Palabuhanratu'),
('32.02.01.1001','Palabuhanratu'),
('32.02.01.2002','Tonjong'),
('32.02.01.2003','Citepus'),
('32.02.01.2004','Buniwangi'),
('32.02.01.2005','Cibodas'),
('32.02.01.2006','Pasirsuren'),
('32.02.01.2007','Cikadu'),
('32.02.01.2008','Citarik'),
('32.02.01.2009','Cimanggu'),
('32.02.01.2010','Jayanti'),
('32.02.02','Simpenan'),
('32.02.02.2001','Cidadap'),
('32.02.02.2002','Loji'),
('32.02.02.2003','Kertajaya'),
('32.02.02.2004','Cihaur'),
('32.02.02.2005','Cibuntu'),
('32.02.02.2006','Mekarasih'),
('32.02.02.2007','Sangrawayang'),
('32.02.03','Cikakak'),
('32.02.03.2001','Cikakak'),
('32.02.03.2002','Cimaja'),
('32.02.03.2003','Ridogalih'),
('32.02.03.2004','Sukamaju'),
('32.02.03.2005','Cileungsing'),
('32.02.03.2006','Margalaksana'),
('32.02.03.2007','Sirnarasa'),
('32.02.03.2008','Gandasoli'),
('32.02.03.2009','Cirendang'),
('32.02.04','Bantargadung'),
('32.02.04.2001','Bantargadung'),
('32.02.04.2002','Mangunjaya'),
('32.02.04.2003','Bojonggaling'),
('32.02.04.2004','Limusnunggal'),
('32.02.04.2005','Bantargebang'),
('32.02.04.2006','Buanajaya'),
('32.02.04.2007','Boyongsari'),
('32.02.05','Cisolok'),
('32.02.05.2001','Cisolok'),
('32.02.05.2002','Pasirbaru'),
('32.02.05.2003','Cikahuripan'),
('32.02.05.2004','Cikelat'),
('32.02.05.2005','Caringin'),
('32.02.05.2006','Gunungkaramat'),
('32.02.05.2007','Gunungtanjung'),
('32.02.05.2008','Karangpapak'),
('32.02.05.2009','Sirnaresmi'),
('32.02.05.2010','Cicadas'),
('32.02.05.2011','Wanajaya'),
('32.02.05.2012','Wangunsari'),
('32.02.05.2013','Sukarame'),
('32.02.06','Cikidang'),
('32.02.06.2001','Cikidang'),
('32.02.06.2002','Cikiray'),
('32.02.06.2003','Gunungmalang'),
('32.02.06.2004','Pangkalan'),
('32.02.06.2005','Cicareuh'),
('32.02.06.2006','Tamansari'),
('32.02.06.2007','Bumisari'),
('32.02.06.2008','Sampora'),
('32.02.06.2009','Nangkakoneng'),
('32.02.06.2010','Mekarnangka'),
('32.02.06.2011','Cijambe'),
('32.02.06.2012','Cikarae Thoyyibah'),
('32.02.07','Lengkong'),
('32.02.07.2001','Lengkong'),
('32.02.07.2002','Cilangkap'),
('32.02.07.2003','Tegallega'),
('32.02.07.2004','Neglasari'),
('32.02.07.2005','Langkapjaya'),
('32.02.08','Jampangtengah'),
('32.02.08.2001','Jampangtengah'),
('32.02.08.2002','Padabeunghar'),
('32.02.08.2003','Bantarpanjang'),
('32.02.08.2004','Bojongjengkol'),
('32.02.08.2005','Nangerang'),
('32.02.08.2006','Tanjungsari'),
('32.02.08.2007','Sindangresmi'),
('32.02.08.2008','Panumbangan'),
('32.02.08.2009','Cijulang'),
('32.02.08.2010','Bantaragung'),
('32.02.08.2011','Bojongtipar'),
('32.02.09','Warungkiara'),
('32.02.09.2001','Warungkiara'),
('32.02.09.2002','Bojongkerta'),
('32.02.09.2003','Girijaya'),
('32.02.09.2004','Bantarkalong'),
('32.02.09.2005','Hegarmanah'),
('32.02.09.2006','Ubrug'),
('32.02.09.2007','Sirnajaya'),
('32.02.09.2008','Sukaharja'),
('32.02.09.2009','Kertamukti'),
('32.02.09.2010','Mekarjaya'),
('32.02.09.2011','Damarraja'),
('32.02.09.2012','Tarisi'),
('32.02.10','Cikembar'),
('32.02.10.2001','Cikembar'),
('32.02.10.2002','Parakanlima'),
('32.02.10.2003','Bojong'),
('32.02.10.2004','Cimanggu'),
('32.02.10.2005','Bojongkembar'),
('32.02.10.2006','Sukamaju'),
('32.02.10.2007','Cibatu'),
('32.02.10.2008','Kertaraharja'),
('32.02.10.2009','Sukamulya'),
('32.02.10.2010','Bojongraharja'),
('32.02.11','Cibadak'),
('32.02.11.1001','Cibadak'),
('32.02.11.2002','Sekarwangi'),
('32.02.11.2003','Pamuruyan'),
('32.02.11.2004','Karangtengah'),
('32.02.11.2005','Neglasari'),
('32.02.11.2006','Warnajati'),
('32.02.11.2007','Tenjojaya'),
('32.02.11.2008','Ciheulang Tonggoh'),
('32.02.11.2009','Sukasirna'),
('32.02.11.2010','Batununggal'),
('32.02.12','Nagrak'),
('32.02.12.2001','Kalaparea'),
('32.02.12.2002','Pawenang'),
('32.02.12.2003','Nagrak Utara'),
('32.02.12.2004','Cisarua'),
('32.02.12.2009','Balekambang'),
('32.02.12.2010','Babakan Panjang'),
('32.02.12.2011','Darmareja'),
('32.02.12.2012','Cihanyawar'),
('32.02.12.2013','Nagrak Selatan'),
('32.02.12.2014','Girijaya'),
('32.02.13','Parungkuda'),
('32.02.13.2001','Parungkuda'),
('32.02.13.2002','Palasari Hilir'),
('32.02.13.2003','Kompa'),
('32.02.13.2004','Pondokkaso Landeuh'),
('32.02.13.2005','Sundawenang'),
('32.02.13.2006','Bojongkokosan'),
('32.02.13.2007','Langesari'),
('32.02.13.2008','Babakanjaya'),
('32.02.14','Bojonggenteng'),
('32.02.14.2001','Bojonggenteng'),
('32.02.14.2002','Cibodas'),
('32.02.14.2003','Berekah'),
('32.02.14.2004','Cipanengah'),
('32.02.14.2005','Bojonggaling'),
('32.02.15','Parakansalak'),
('32.02.15.2001','Parakansalak'),
('32.02.15.2002','Bojonglongok'),
('32.02.15.2003','Sukakersa'),
('32.02.15.2004','Sukatani'),
('32.02.15.2005','Bojongasih'),
('32.02.15.2006','Lebaksari'),
('32.02.16','Cicurug'),
('32.02.16.1001','Cicurug'),
('32.02.16.2002','Nyangkowek'),
('32.02.16.2003','Tenjolaya'),
('32.02.16.2004','Benda'),
('32.02.16.2005','Pasawahan'),
('32.02.16.2006','Cisaat'),
('32.02.16.2007','Purwasari'),
('32.02.16.2008','Caringin'),
('32.02.16.2009','Tenjoayu'),
('32.02.16.2010','Kutajaya'),
('32.02.16.2011','Mekarsari'),
('32.02.16.2012','Bangbayang'),
('32.02.16.2013','Nanggerang'),
('32.02.17','Cidahu'),
('32.02.17.2001','Pondokkaso Tonggoh'),
('32.02.17.2002','Babakanpari'),
('32.02.17.2003','Pondokkaso Tengah'),
('32.02.17.2004','Cidahu'),
('32.02.17.2005','Tangkil'),
('32.02.17.2006','Jayabakti'),
('32.02.17.2007','Girijaya'),
('32.02.17.2008','Pasirdoton'),
('32.02.18','Kalapanunggal'),
('32.02.18.2001','Kalapanunggal'),
('32.02.18.2002','Palasari Girang'),
('32.02.18.2003','Pulosari'),
('32.02.18.2004','Makasari'),
('32.02.18.2005','Kadununggal'),
('32.02.18.2006','Walangsari'),
('32.02.18.2007','Gunungendut'),
('32.02.19','Kabandungan'),
('32.02.19.2001','Kabandungan'),
('32.02.19.2002','Cipeuteuy'),
('32.02.19.2003','Cihamerang'),
('32.02.19.2004','Tugubandung'),
('32.02.19.2005','Mekarjaya'),
('32.02.19.2006','Cianaga'),
('32.02.20','Waluran'),
('32.02.20.2001','Waluran'),
('32.02.20.2002','Sukamukti'),
('32.02.20.2003','Caringinnunggal'),
('32.02.20.2004','Mekarmukti'),
('32.02.20.2005','Mangunjaya'),
('32.02.20.2006','Waluran Mandiri'),
('32.02.21','Jampangkulon'),
('32.02.21.1001','Jampangkulon'),
('32.02.21.2002','Bojonggenteng'),
('32.02.21.2003','Cikarang'),
('32.02.21.2005','Bojongsari'),
('32.02.21.2007','Nagraksari'),
('32.02.21.2008','Mekarjaya'),
('32.02.21.2009','Tanjung'),
('32.02.21.2011','Ciparay'),
('32.02.21.2013','Padajaya'),
('32.02.21.2014','Karanganyar'),
('32.02.21.2016','Cikaranggeusan'),
('32.02.22','Ciemas'),
('32.02.22.2001','Ciemas'),
('32.02.22.2002','Cibenda'),
('32.02.22.2003','Ciwaru'),
('32.02.22.2004','Mekarjaya'),
('32.02.22.2005','Girimukti'),
('32.02.22.2006','Tamanjaya'),
('32.02.22.2007','Mandrajaya'),
('32.02.22.2008','Sidamulya'),
('32.02.22.2009','Mekarsakti'),
('32.02.23','Kalibunder'),
('32.02.23.2001','Kalibunder'),
('32.02.23.2002','Bojong'),
('32.02.23.2003','Cimahpar'),
('32.02.23.2004','Sekarsari'),
('32.02.23.2005','Sukaluyu'),
('32.02.23.2006','Balekambang'),
('32.02.23.2007','Mekarwangi'),
('32.02.24','Surade'),
('32.02.24.1013','Surade'),
('32.02.24.2001','Jagamukti'),
('32.02.24.2002','Citanglar'),
('32.02.24.2003','Wanasari'),
('32.02.24.2005','Sirnasari'),
('32.02.24.2006','Kadaleman'),
('32.02.24.2007','Gunungsungging'),
('32.02.24.2008','Cipeundeuy'),
('32.02.24.2009','Pasiripis'),
('32.02.24.2010','Buniwangi'),
('32.02.24.2011','Sukatani'),
('32.02.24.2012','Kademangan'),
('32.02.25','Cibitung'),
('32.02.25.2001','Talagamurni'),
('32.02.25.2002','Banyumurni'),
('32.02.25.2003','Cibitung'),
('32.02.25.2004','Cidahu'),
('32.02.25.2005','Cibodas'),
('32.02.25.2006','Banyuwangi'),
('32.02.26','Ciracap'),
('32.02.26.2001','Ciracap'),
('32.02.26.2002','Cikangkung'),
('32.02.26.2003','Gunungbatu'),
('32.02.26.2004','Purwasedar'),
('32.02.26.2005','Pasirpanjang'),
('32.02.26.2006','Mekarsari'),
('32.02.26.2007','Ujunggenteng'),
('32.02.26.2008','Pangumbahan'),
('32.02.27','Gunungguruh'),
('32.02.27.2001','Cikujang'),
('32.02.27.2002','Gunungguruh'),
('32.02.27.2003','Cibentang'),
('32.02.27.2004','Sirnaresmi'),
('32.02.27.2005','Kebonmanggu'),
('32.02.27.2006','Cibolang'),
('32.02.27.2007','Mangkalaya'),
('32.02.28','Cicantayan'),
('32.02.28.2001','Cicantayan'),
('32.02.28.2002','Lembursawah'),
('32.02.28.2003','Cijalingan'),
('32.02.28.2004','Cisande'),
('32.02.28.2005','Cimahi'),
('32.02.28.2006','Hegarmanah'),
('32.02.28.2007','Sukadamai'),
('32.02.28.2008','Cimanggis'),
('32.02.29','Cisaat'),
('32.02.29.2001','Gunungjaya'),
('32.02.29.2002','Sukasari'),
('32.02.29.2003','Sukamanah'),
('32.02.29.2004','Cisaat'),
('32.02.29.2005','Nagrak'),
('32.02.29.2006','Babakan'),
('32.02.29.2007','Sukamantri'),
('32.02.29.2008','Cibatu'),
('32.02.29.2009','Selajambe'),
('32.02.29.2010','Padaasih'),
('32.02.29.2011','Cibolang Kaler'),
('32.02.29.2012','Kutasirna'),
('32.02.29.2013','Sukaresmi'),
('32.02.30','Kadudampit'),
('32.02.30.2001','Kadudampit'),
('32.02.30.2002','Citamiang'),
('32.02.30.2003','Muaradua'),
('32.02.30.2004','Gedepangrango'),
('32.02.30.2005','Sukamanis'),
('32.02.30.2006','Undrusbinangun'),
('32.02.30.2007','Cipetir'),
('32.02.30.2008','Sukamaju'),
('32.02.30.2009','Cikahuripan'),
('32.02.31','Caringin'),
('32.02.31.2001','Caringin Wetan'),
('32.02.31.2002','Sukamulya'),
('32.02.31.2003','Caringin Kulon'),
('32.02.31.2004','Seuseupan'),
('32.02.31.2005','Cijengkol'),
('32.02.31.2006','Mekarjaya'),
('32.02.31.2007','Talaga'),
('32.02.31.2008','Cikembang'),
('32.02.31.2009','Pasir Datar Indah'),
('32.02.32','Sukabumi'),
('32.02.32.2001','Parungseah'),
('32.02.32.2002','Sudajayagirang'),
('32.02.32.2003','Karawang'),
('32.02.32.2004','Warnasari'),
('32.02.32.2005','Sukajaya'),
('32.02.32.2006','Perbawati'),
('32.02.33','Sukaraja'),
('32.02.33.2001','Pasirhalang'),
('32.02.33.2002','Selaawi'),
('32.02.33.2003','Langensari'),
('32.02.33.2004','Sukaraja'),
('32.02.33.2005','Limbangan'),
('32.02.33.2006','Cisarua'),
('32.02.33.2007','Sukamekar'),
('32.02.33.2008','Selawangi'),
('32.02.33.2009','Margaluyu'),
('32.02.34','Kebonpedes'),
('32.02.34.2001','Kebonpedes'),
('32.02.34.2002','Cikaret'),
('32.02.34.2003','Bojongsawah'),
('32.02.34.2004','Sasagaran'),
('32.02.34.2005','Jambenenggang'),
('32.02.35','Cireunghas'),
('32.02.35.2001','Cireunghas'),
('32.02.35.2002','Cipurut'),
('32.02.35.2003','Bencoy'),
('32.02.35.2004','Cikurutug'),
('32.02.35.2005','Tegalpanjang'),
('32.02.36','Sukalarang'),
('32.02.36.2001','Sukalarang'),
('32.02.36.2002','Sukamaju'),
('32.02.36.2003','Cimangkok'),
('32.02.36.2004','Titisan'),
('32.02.36.2005','Semplak'),
('32.02.36.2006','Prianganjaya'),
('32.02.37','Pabuaran'),
('32.02.37.2001','Pabuaran'),
('32.02.37.2002','Ciwalat'),
('32.02.37.2003','Sirnasari'),
('32.02.37.2004','Bantarsari'),
('32.02.37.2005','Sukajaya'),
('32.02.37.2006','Cibadak'),
('32.02.37.2007','Lembur Sawah'),
('32.02.38','Purabaya'),
('32.02.38.2001','Purabaya'),
('32.02.38.2002','Neglasari'),
('32.02.38.2003','Pagelaran'),
('32.02.38.2004','Cimerang'),
('32.02.38.2005','Citamiang'),
('32.02.38.2006','Margaluyu'),
('32.02.38.2007','Cicukang'),
('32.02.39','Nyalindung'),
('32.02.39.2001','Nyalindung'),
('32.02.39.2002','Neglasari'),
('32.02.39.2003','Sukamaju'),
('32.02.39.2004','Bojongkalong'),
('32.02.39.2005','Cijangkar'),
('32.02.39.2006','Mekarsari'),
('32.02.39.2007','Wangunreja'),
('32.02.39.2008','Cisitu'),
('32.02.39.2009','Bojongsari'),
('32.02.39.2010','Kertaangsana'),
('32.02.40','Gegerbitung'),
('32.02.40.2001','Gegerbitung'),
('32.02.40.2002','Cijurey'),
('32.02.40.2003','Ciengang'),
('32.02.40.2004','Karangjaya'),
('32.02.40.2005','Caringin'),
('32.02.40.2006','Sukamanah'),
('32.02.40.2007','Buniwangi'),
('32.02.41','Sagaranten'),
('32.02.41.2001','Sagaranten'),
('32.02.41.2002','Curugluhur'),
('32.02.41.2003','Cibaregbeg'),
('32.02.41.2004','Pasanggrahan'),
('32.02.41.2005','Datarnangka'),
('32.02.41.2006','Puncakmanggis'),
('32.02.41.2007','Hegarmanah'),
('32.02.41.2008','Gunungbentang'),
('32.02.41.2009','Sinarbentang'),
('32.02.41.2010','Cibitung'),
('32.02.41.2011','Margaluyu'),
('32.02.41.2012','Mekarsari'),
('32.02.42','Curugkembar'),
('32.02.42.2001','Curugkembar'),
('32.02.42.2002','Cimenteng'),
('32.02.42.2003','Tanjungsari'),
('32.02.42.2004','Sindangraja'),
('32.02.42.2005','Mekartanjung'),
('32.02.42.2006','Nagrakjaya'),
('32.02.42.2007','Bojongtugu'),
('32.02.43','Cidolog'),
('32.02.43.2001','Cidolog'),
('32.02.43.2002','Cipamingkis'),
('32.02.43.2003','Cikarang'),
('32.02.43.2004','Tegallega'),
('32.02.43.2005','Mekarjaya'),
('32.02.44','Cidadap'),
('32.02.44.2001','Padasenang'),
('32.02.44.2002','Cidadap'),
('32.02.44.2003','Banjarsari'),
('32.02.44.2004','Hegarmulya'),
('32.02.44.2005','Tenjolaut'),
('32.02.44.2006','Mekartani'),
('32.02.45','Tegalbuleud'),
('32.02.45.2001','Tegalbuleud'),
('32.02.45.2002','Bangbayang'),
('32.02.45.2003','Sumberjaya'),
('32.02.45.2004','Calingcing'),
('32.02.45.2005','Nangela'),
('32.02.45.2006','Rambay'),
('32.02.45.2007','Buniasih'),
('32.02.45.2008','Sirnamekar'),
('32.02.46','Cimanggu'),
('32.02.46.2001','Cimanggu'),
('32.02.46.2002','Sukamaju'),
('32.02.46.2003','Sukajadi'),
('32.02.46.2004','Karangmekar'),
('32.02.46.2005','Boregahindah'),
('32.02.46.2006','Sukamanah'),
('32.02.47','Ciambar'),
('32.02.47.2001','Ciambar'),
('32.02.47.2002','Ginanjar'),
('32.02.47.2003','Wangunjaya'),
('32.02.47.2004','Munjul'),
('32.02.47.2005','Ambarjaya'),
('32.02.47.2006','Cibunarjaya'),
('32.03','Kabupaten Cianjur'),
('32.03.01','Cianjur'),
('32.03.01.1006','Pamoyanan'),
('32.03.01.1007','Sawahgede'),
('32.03.01.1008','Bojongherang'),
('32.03.01.1009','Sayang'),
('32.03.01.1010','Solokpandan'),
('32.03.01.1011','Muka'),
('32.03.01.2001','Babakankaret'),
('32.03.01.2002','Nagrak'),
('32.03.01.2003','Sukamaju'),
('32.03.01.2004','Mekarsari'),
('32.03.01.2005','Limbangansari'),
('32.03.02','Warungkondang'),
('32.03.02.2002','Jambudipa'),
('32.03.02.2006','Cisarandi'),
('32.03.02.2007','Cikaroya'),
('32.03.02.2008','Bunikasih'),
('32.03.02.2009','Ciwalen'),
('32.03.02.2010','Tegallega'),
('32.03.02.2011','Sukawangi'),
('32.03.02.2014','Bunisari'),
('32.03.02.2016','Sukamulya'),
('32.03.02.2017','Cieundeur'),
('32.03.02.2018','Mekarwangi'),
('32.03.03','Cibeber'),
('32.03.03.2001','Cipetir'),
('32.03.03.2002','Cihaur'),
('32.03.03.2003','Cimanggu'),
('32.03.03.2004','Cibaregbeg'),
('32.03.03.2005','Sukaraharja'),
('32.03.03.2006','Peuteuycondong'),
('32.03.03.2007','Mayak'),
('32.03.03.2008','Cikondang'),
('32.03.03.2009','Cibokor'),
('32.03.03.2010','Selagedang'),
('32.03.03.2011','Karangnunggal'),
('32.03.03.2012','Kanoman'),
('32.03.03.2013','Sukamaju'),
('32.03.03.2014','Girimulya'),
('32.03.03.2015','Cisalak'),
('32.03.03.2016','Cibadak'),
('32.03.03.2017','Sukamanah'),
('32.03.03.2018','Salamnunggal'),
('32.03.04','Cilaku'),
('32.03.04.2001','Rancagoong'),
('32.03.04.2002','Sukasari'),
('32.03.04.2003','Sirnagalih'),
('32.03.04.2004','Sukakerta'),
('32.03.04.2005','Cibinonghilir'),
('32.03.04.2006','Rahong'),
('32.03.04.2007','Munjul'),
('32.03.04.2008','Sindangsari'),
('32.03.04.2009','Ciharashas'),
('32.03.04.2010','Mulyasari'),
('32.03.05','Ciranjang'),
('32.03.05.2001','Ciranjang'),
('32.03.05.2002','Sindangjaya'),
('32.03.05.2004','Cibiuk'),
('32.03.05.2005','Gunungsari'),
('32.03.05.2006','Karangwangi'),
('32.03.05.2007','Nanggalamekar'),
('32.03.05.2008','Kertajaya'),
('32.03.05.2009','Sindangsari'),
('32.03.05.2012','Mekargalih'),
('32.03.06','Bonjogpicung'),
('32.03.06.2001','Hegarmanah'),
('32.03.06.2002','Bojongpicung'),
('32.03.06.2004','Cibarengkok'),
('32.03.06.2006','Kemang'),
('32.03.06.2007','Sukajaya'),
('32.03.06.2008','Jati'),
('32.03.06.2009','Cikondang'),
('32.03.06.2010','Sukarama'),
('32.03.06.2012','Sukaratu'),
('32.03.06.2013','Neglasari'),
('32.03.06.2014','Jatisari'),
('32.03.07','Karangtengah'),
('32.03.07.2001','Sukamanah'),
('32.03.07.2002','Bojong'),
('32.03.07.2003','Sindanglaka'),
('32.03.07.2004','Maleber'),
('32.03.07.2005','Ciherang'),
('32.03.07.2006','Sukamantri'),
('32.03.07.2007','Sukasarana'),
('32.03.07.2008','Sukasari'),
('32.03.07.2009','Babakancaringin'),
('32.03.07.2010','Sabandar'),
('32.03.07.2011','Sindangasih'),
('32.03.07.2012','Sukataris'),
('32.03.07.2013','Langensari'),
('32.03.07.2014','Hegarmanah'),
('32.03.07.2015','Sukajadi'),
('32.03.07.2016','Sukamulya'),
('32.03.08','Mande'),
('32.03.08.2001','Kademangan'),
('32.03.08.2002','Bobojong'),
('32.03.08.2003','Jamali'),
('32.03.08.2004','Cikidangbayabang'),
('32.03.08.2005','Mande'),
('32.03.08.2006','Mulyasari'),
('32.03.08.2007','Ciandam'),
('32.03.08.2008','Sukamanah'),
('32.03.08.2009','Leuwikoja'),
('32.03.08.2010','Mekarjaya'),
('32.03.08.2011','Kutawaringin'),
('32.03.08.2012','Murnisari'),
('32.03.09','Sukaluyu'),
('32.03.09.2001','Selajambe'),
('32.03.09.2002','Sukamulya'),
('32.03.09.2003','Panyusuhan'),
('32.03.09.2004','Tanjungsari'),
('32.03.09.2005','Sindangraja'),
('32.03.09.2006','Mekarjaya'),
('32.03.09.2007','Sukasirna'),
('32.03.09.2008','Sukaluyu'),
('32.03.09.2009','Babakansari'),
('32.03.09.2010','Hegarmanah'),
('32.03.10','Pacet'),
('32.03.10.2001','Ciherang'),
('32.03.10.2003','Cibodas'),
('32.03.10.2005','Sukanagalih'),
('32.03.10.2007','Cipendawa'),
('32.03.10.2010','Ciputri'),
('32.03.10.2012','Gadog'),
('32.03.10.2013','Sukatani'),
('32.03.11','Cugenang'),
('32.03.11.2001','Sukamanah'),
('32.03.11.2002','Gasol'),
('32.03.11.2003','Cijedil'),
('32.03.11.2004','Cibeureum'),
('32.03.11.2005','Nyalindung'),
('32.03.11.2006','Mangunkerta'),
('32.03.11.2007','Sarampad'),
('32.03.11.2008','Talaga'),
('32.03.11.2009','Sukajaya'),
('32.03.11.2010','Cibulakan'),
('32.03.11.2011','Benjot'),
('32.03.11.2012','Sukamulya'),
('32.03.11.2013','Wangunjaya'),
('32.03.11.2014','Cirumput'),
('32.03.11.2015','Padaluyu'),
('32.03.11.2016','Galudra'),
('32.03.12','Cikalongkulon'),
('32.03.12.2001','Sukagalih'),
('32.03.12.2002','Gudang'),
('32.03.12.2003','Cinangsi'),
('32.03.12.2004','Cijagang'),
('32.03.12.2005','Majalaya'),
('32.03.12.2006','Kamurang'),
('32.03.12.2007','Warudoyong'),
('32.03.12.2008','Ciramagirang'),
('32.03.12.2009','Mekarjaya'),
('32.03.12.2010','Sukamulya'),
('32.03.12.2011','Padajaya'),
('32.03.12.2012','Cigunungherang'),
('32.03.12.2013','Neglasari'),
('32.03.12.2014','Mekargalih'),
('32.03.12.2015','Lembahsari'),
('32.03.12.2016','Mentengsari'),
('32.03.12.2017','Mekarsari'),
('32.03.12.2018','Mekarmulya'),
('32.03.13','Sukaresmi'),
('32.03.13.2001','Cikanyere'),
('32.03.13.2002','Cikancana'),
('32.03.13.2003','Ciwalen'),
('32.03.13.2004','Kawungluwuk'),
('32.03.13.2005','Cibadak'),
('32.03.13.2006','Sukamahi'),
('32.03.13.2007','Sukaresmi'),
('32.03.13.2008','Cibanteng'),
('32.03.13.2009','Kubang'),
('32.03.13.2010','Pakuon'),
('32.03.13.2011','Rawabelut'),
('32.03.14','Sukanagara'),
('32.03.14.2001','Sukanagara'),
('32.03.14.2002','Sukajembar'),
('32.03.14.2003','Sukakarya'),
('32.03.14.2004','Ciguha'),
('32.03.14.2005','Sukamekar'),
('32.03.14.2006','Gunungsari'),
('32.03.14.2007','Sukalaksana'),
('32.03.14.2008','Sukarame'),
('32.03.14.2009','Sindangsari'),
('32.03.14.2010','Jayagiri'),
('32.03.15','Campaka'),
('32.03.15.2001','Cidadap'),
('32.03.15.2002','Cimenteng'),
('32.03.15.2003','Susukan'),
('32.03.15.2004','Sukajadi'),
('32.03.15.2005','Sukadana'),
('32.03.15.2006','Margaluyu'),
('32.03.15.2007','Karyamukti'),
('32.03.15.2008','Campaka'),
('32.03.15.2009','Wangunjaya'),
('32.03.15.2010','Girimukti'),
('32.03.15.2011','Mekarjaya'),
('32.03.16','Takokak'),
('32.03.16.2001','Pasawahan'),
('32.03.16.2002','Sindangresmi'),
('32.03.16.2003','Sindanghayu'),
('32.03.16.2004','Simpang'),
('32.03.16.2005','Sukagalih'),
('32.03.16.2006','Bungbangsari'),
('32.03.16.2007','Cisujen'),
('32.03.16.2008','Hegarmanah'),
('32.03.16.2009','Waringinsari'),
('32.03.17','Kadupandak'),
('32.03.17.2003','Sukasari'),
('32.03.17.2006','Pasirdalem'),
('32.03.17.2008','Talagasari'),
('32.03.17.2009','Bojongkasih'),
('32.03.17.2010','Wargaasih'),
('32.03.17.2011','Sukaraharja'),
('32.03.17.2014','Sukakerta'),
('32.03.17.2016','Neglasari'),
('32.03.17.2017','Sukaresmi'),
('32.03.17.2019','Wargasari'),
('32.03.17.2020','Sukaraja'),
('32.03.17.2021','Kadupandak'),
('32.03.17.2022','Gandasari'),
('32.03.17.2023','Sindangsari'),
('32.03.18','Pagelarang'),
('32.03.18.2001','Pagelaran'),
('32.03.18.2002','Pangadegan'),
('32.03.18.2004','Gelaranyar'),
('32.03.18.2005','Buniwangi'),
('32.03.18.2007','Sindangkerta'),
('32.03.18.2008','Pasirbaru'),
('32.03.18.2009','Bunijaya'),
('32.03.18.2010','Situhiang'),
('32.03.18.2011','Mekarsari'),
('32.03.18.2012','Kertaraharja'),
('32.03.18.2013','Selagedang'),
('32.03.18.2014','Padamaju'),
('32.03.18.2015','Karangharja'),
('32.03.18.2018','Sukamaju'),
('32.03.19','Tanggeung'),
('32.03.19.2001','Tanggeung'),
('32.03.19.2002','Rawagede'),
('32.03.19.2003','Cilongsong'),
('32.03.19.2004','Margaluyu'),
('32.03.19.2005','Karangtengah'),
('32.03.19.2006','Pagermaneuh'),
('32.03.19.2007','Bojongpetir'),
('32.03.19.2009','Pasirjambu'),
('32.03.19.2010','Sirnajaya'),
('32.03.19.2013','Kertajaya'),
('32.03.19.2014','Sukajaya'),
('32.03.19.2015','Padaluyu'),
('32.03.20','Cubinong'),
('32.03.20.2001','Pananggapan'),
('32.03.20.2002','Cikangkareng'),
('32.03.20.2003','Sukajadi'),
('32.03.20.2004','Panyindangan'),
('32.03.20.2005','Padasuka'),
('32.03.20.2006','Cimaskara'),
('32.03.20.2007','Pamoyanan'),
('32.03.20.2008','Batulawang'),
('32.03.20.2009','Sukamekar'),
('32.03.20.2010','Hamerang'),
('32.03.20.2011','Girijaya'),
('32.03.20.2012','Wargaluyu'),
('32.03.20.2013','Mekarmukti'),
('32.03.20.2014','Ciburial'),
('32.03.21','Sindangbarang'),
('32.03.21.2001','Saganten'),
('32.03.21.2002','Muaracikadu'),
('32.03.21.2003','Jatisari'),
('32.03.21.2004','Sirnagalih'),
('32.03.21.2005','Jayagiri'),
('32.03.21.2006','Kertasari'),
('32.03.21.2007','Girimukti'),
('32.03.21.2008','Talagasari'),
('32.03.21.2009','Hegarsari'),
('32.03.21.2010','Mekarlaksana'),
('32.03.21.2011','Kertamukti'),
('32.03.22','Agrabinta'),
('32.03.22.2004','Sukamanah'),
('32.03.22.2005','Bojongkaso'),
('32.03.22.2006','Bunisari'),
('32.03.22.2007','Wanasari'),
('32.03.22.2010','Sinarlaut'),
('32.03.22.2014','Neglasari'),
('32.03.22.2016','Karangsari'),
('32.03.22.2017','Mulyasari'),
('32.03.22.2018','Tanjung Sari'),
('32.03.22.2019','Mekarsari'),
('32.03.22.2022','Wangunjaya'),
('32.03.23','Cidaun'),
('32.03.23.2001','Cidamar'),
('32.03.23.2002','Cibuluh'),
('32.03.23.2003','Cisalak'),
('32.03.23.2004','Cimaragang'),
('32.03.23.2005','Mekarjaya'),
('32.03.23.2006','Kertajadi'),
('32.03.23.2007','Sukapura'),
('32.03.23.2008','Gelarpawitan'),
('32.03.23.2009','Karangwangi'),
('32.03.23.2010','Karyabakti'),
('32.03.23.2011','Jayapura'),
('32.03.23.2012','Neglasari'),
('32.03.23.2013','Puncakbaru'),
('32.03.23.2014','Gelarwangi'),
('32.03.24','Naringgul'),
('32.03.24.2001','Naringgul'),
('32.03.24.2002','Balegede'),
('32.03.24.2003','Wangunjaya'),
('32.03.24.2004','Mekarsari'),
('32.03.24.2005','Cinerang'),
('32.03.24.2006','Wanasari'),
('32.03.24.2007','Sukabakti'),
('32.03.24.2008','Malati'),
('32.03.24.2009','Wangunsari'),
('32.03.24.2010','Sukamulya'),
('32.03.24.2011','Margasari'),
('32.03.25','Campakamulya'),
('32.03.25.2001','Cibanggala'),
('32.03.25.2002','Campakawarna'),
('32.03.25.2003','Sukasirna'),
('32.03.25.2004','Campakamulya'),
('32.03.25.2005','Sukabungah'),
('32.03.26','Cikadu'),
('32.03.26.2001','Kalapanunggal'),
('32.03.26.2002','Cikadu'),
('32.03.26.2003','Mekarwangi'),
('32.03.26.2004','Padaluyu'),
('32.03.26.2005','Sukamulya'),
('32.03.26.2006','Cisaranten'),
('32.03.26.2007','Mekarlaksana'),
('32.03.26.2008','Sukaluyu'),
('32.03.26.2009','Mekarjaya'),
('32.03.26.2010','Sukamanah'),
('32.03.27','Gekbrong'),
('32.03.27.2001','Bangbayang'),
('32.03.27.2002','Songgom'),
('32.03.27.2003','Sukaratu'),
('32.03.27.2004','Cikancana'),
('32.03.27.2005','Kebonpeuteuy'),
('32.03.27.2006','Gekbrong'),
('32.03.27.2007','Cikahuripan'),
('32.03.27.2008','Cintaasih'),
('32.03.28','Cipanas'),
('32.03.28.2001','Cipanas'),
('32.03.28.2002','Cimacan'),
('32.03.28.2003','Ciloto'),
('32.03.28.2004','Sindanglaya'),
('32.03.28.2005','Batulawang'),
('32.03.28.2006','Palasari'),
('32.03.28.2007','Sindangjaya'),
('32.03.29','Cijati'),
('32.03.29.2001','Parakantugu'),
('32.03.29.2002','Cijati'),
('32.03.29.2003','Bojonglarang'),
('32.03.29.2004','Padaasih'),
('32.03.29.2005','Cibodas'),
('32.03.29.2006','Sukamahi'),
('32.03.29.2007','Sukaluyu'),
('32.03.29.2008','Caringin'),
('32.03.29.2009','Sinarbakti'),
('32.03.29.2010','Sukamaju'),
('32.03.30','Leles'),
('32.03.30.2001','Pusakasari'),
('32.03.30.2002','Walahir'),
('32.03.30.2003','Purabaya'),
('32.03.30.2004','Puncakwangi'),
('32.03.30.2005','Sukajaya'),
('32.03.30.2006','Nagasari'),
('32.03.30.2007','Sukasirna'),
('32.03.30.2008','Sukamulya'),
('32.03.30.2009','Sirnasari'),
('32.03.30.2010','Karyamukti'),
('32.03.30.2011','Mandalawangi'),
('32.03.30.2012','Sindangsari'),
('32.03.31','Haurwangi'),
('32.03.31.2001','Haurwangi'),
('32.03.31.2002','Cihea'),
('32.03.31.2003','Ramasari'),
('32.03.31.2004','Mekarwangi/Sukatani'),
('32.03.31.2005','Mekarwangi'),
('32.03.31.2006','Kertasari'),
('32.03.31.2007','Cipeuyeum'),
('32.03.31.2008','Kertamukti'),
('32.03.32','Pasirkuda'),
('32.03.32.2001','Simpang'),
('32.03.32.2002','Kalibaru'),
('32.03.32.2003','Pusakajaya'),
('32.03.32.2004','Kubang'),
('32.03.32.2005','Girimukti'),
('32.03.32.2006','Karangjaya'),
('32.03.32.2007','Mekarmulya'),
('32.03.32.2008','Girijaya'),
('32.03.32.2009','Padamulya'),
('32.04','Kabupaten Bandung'),
('32.04.05','Cileunyi'),
('32.04.05.2001','Cileunyi Kulon'),
('32.04.05.2002','Cileunyi Wetan'),
('32.04.05.2003','Cimekar'),
('32.04.05.2004','Cinunuk'),
('32.04.05.2005','Cibiru Hilir'),
('32.04.05.2006','Cibiru Wetan'),
('32.04.06','Cimenyan'),
('32.04.06.1001','Padasuka'),
('32.04.06.1002','Cibeunying'),
('32.04.06.2003','Cimenyan'),
('32.04.06.2004','Mandalamekar'),
('32.04.06.2005','Cikadut'),
('32.04.06.2006','Ciburial'),
('32.04.06.2007','Sindanglaya'),
('32.04.06.2008','Mekarsaluyu'),
('32.04.06.2009','Mekarmanik'),
('32.04.07','Cilengkrang'),
('32.04.07.2001','Jatiendah'),
('32.04.07.2002','Cilengkrang'),
('32.04.07.2003','Cipanjalu'),
('32.04.07.2004','Melatiwangi'),
('32.04.07.2005','Ciporeat'),
('32.04.07.2006','Girimekar'),
('32.04.08','Bojongsoang'),
('32.04.08.2001','Lengkong'),
('32.04.08.2002','Bojongsoang'),
('32.04.08.2003','Buahbatu'),
('32.04.08.2004','Cipagalo'),
('32.04.08.2005','Bojongsari'),
('32.04.08.2006','Tegalluar'),
('32.04.09','Margahayu'),
('32.04.09.1004','Sulaiman'),
('32.04.09.2001','Margahayu Tengah'),
('32.04.09.2002','Margahayu Selatan'),
('32.04.09.2003','Sukamenak'),
('32.04.09.2005','Sayati'),
('32.04.10','Margaasih'),
('32.04.10.2001','Margaasih'),
('32.04.10.2002','Lagadar'),
('32.04.10.2003','Nanjung'),
('32.04.10.2004','Mekarrahayu'),
('32.04.10.2005','Rahayu'),
('32.04.10.2006','Cigondewah Hilir'),
('32.04.11','Katapang'),
('32.04.11.2001','Sangkanhurip'),
('32.04.11.2002','Katapang'),
('32.04.11.2004','Gandasari'),
('32.04.11.2006','Sukamukti'),
('32.04.11.2007','Cilampeni'),
('32.04.11.2008','Pangauban'),
('32.04.11.2009','Banyusari'),
('32.04.12','Dayeuhkolot'),
('32.04.12.1001','Pasawahan'),
('32.04.12.2002','Dayeuhkolot'),
('32.04.12.2003','Cangkuang Wetan'),
('32.04.12.2004','Cangkuang Kulon'),
('32.04.12.2005','Sukapura'),
('32.04.12.2006','Citeureup'),
('32.04.13','Banjaran'),
('32.04.13.2001','Kamasan'),
('32.04.13.2002','Banjaran Wetan'),
('32.04.13.2003','Banjaran'),
('32.04.13.2005','Ciapus'),
('32.04.13.2006','Sindangpanon'),
('32.04.13.2007','Kiangroke'),
('32.04.13.2008','Tarajusari'),
('32.04.13.2012','Mekarjaya'),
('32.04.13.2013','Margahurip'),
('32.04.13.2016','Neglasari'),
('32.04.13.2018','Pasirmulya'),
('32.04.14','Pameungpeuk'),
('32.04.14.2001','Sukasari'),
('32.04.14.2002','Bojongmanggu'),
('32.04.14.2003','Rancatungku'),
('32.04.14.2004','Bojongkunci'),
('32.04.14.2005','Rancamulya'),
('32.04.14.2006','Langonsari'),
('32.04.15','Pangalengan'),
('32.04.15.2001','Pangalengan'),
('32.04.15.2002','Margaluyu'),
('32.04.15.2003','Warnasari'),
('32.04.15.2004','Sukamanah'),
('32.04.15.2005','Lamajang'),
('32.04.15.2006','Margamukti'),
('32.04.15.2007','Margamulya'),
('32.04.15.2008','Banjarsari'),
('32.04.15.2009','Sukaluyu'),
('32.04.15.2010','Tribaktimulya'),
('32.04.15.2011','Pulosari'),
('32.04.15.2012','Wanasuka'),
('32.04.15.2013','Margamekar'),
('32.04.16','Arjasari'),
('32.04.16.2001','Arjasari'),
('32.04.16.2002','Lebakwangi'),
('32.04.16.2003','Batukarut'),
('32.04.16.2004','Ancolmekar'),
('32.04.16.2005','Baros'),
('32.04.16.2006','Mangunjaya'),
('32.04.16.2007','Mekarjaya'),
('32.04.16.2008','Pinggirsari'),
('32.04.16.2009','Patrolsari'),
('32.04.16.2010','Rancakole'),
('32.04.16.2011','Wargaluyu'),
('32.04.17','Cimaung'),
('32.04.17.2001','Cimaung'),
('32.04.17.2002','Jagabaya'),
('32.04.17.2003','Pasirhuni'),
('32.04.17.2004','Campakamulya'),
('32.04.17.2005','Cipinang'),
('32.04.17.2006','Mekarsari'),
('32.04.17.2007','Sukamaju'),
('32.04.17.2008','Cikalong'),
('32.04.17.2009','Malasari'),
('32.04.17.2010','Warjabakti'),
('32.04.25','Cicalengka'),
('32.04.25.2001','Cicalengka Kulon'),
('32.04.25.2002','Cicalengka Wetan'),
('32.04.25.2003','Babakan Peuteuy'),
('32.04.25.2004','Cikuya'),
('32.04.25.2005','Dampit'),
('32.04.25.2006','Margaasih'),
('32.04.25.2007','Narawita'),
('32.04.25.2008','Panenjoan'),
('32.04.25.2009','Tanjungwangi'),
('32.04.25.2010','Tenjolaya'),
('32.04.25.2011','Waluya'),
('32.04.25.2012','Nagrog'),
('32.04.26','Nagreg'),
('32.04.26.2001','Nagreg'),
('32.04.26.2002','Bojong'),
('32.04.26.2003','Ciaro'),
('32.04.26.2004','Ciherang'),
('32.04.26.2005','Citaman'),
('32.04.26.2006','Mandalawangi'),
('32.04.26.2007','Nagreg Kendan'),
('32.04.26.2008','Ganjar Sabar'),
('32.04.27','Cikancung'),
('32.04.27.2001','Mandalasari'),
('32.04.27.2002','Cikancung'),
('32.04.27.2003','Cikasungka'),
('32.04.27.2004','Cihanyir'),
('32.04.27.2005','Ciluluk'),
('32.04.27.2006','Hegarmanah'),
('32.04.27.2007','Mekarlaksana'),
('32.04.27.2008','Tanjunglaya'),
('32.04.27.2009','Srirahayu'),
('32.04.28','Rancaekek'),
('32.04.28.1014','Rancaekek Kencana'),
('32.04.28.2001','Rancaekek Wetan'),
('32.04.28.2002','Rancaekek Kulon'),
('32.04.28.2003','Bojongsalam'),
('32.04.28.2004','Bojongloa'),
('32.04.28.2005','Jelegong'),
('32.04.28.2006','Linggar'),
('32.04.28.2007','Cangkuang'),
('32.04.28.2008','Haurpugur'),
('32.04.28.2009','Sukamanah'),
('32.04.28.2010','Sukamulya'),
('32.04.28.2011','Tegal Sumedang'),
('32.04.28.2012','Sangiang'),
('32.04.28.2013','Nanjung Mekar'),
('32.04.29','Ciparay'),
('32.04.29.2001','Ciparay'),
('32.04.29.2002','Gunungleutik'),
('32.04.29.2003','Mekarsari'),
('32.04.29.2004','Cikoneng'),
('32.04.29.2005','Ciheulang'),
('32.04.29.2006','Pakutandang'),
('32.04.29.2007','Sumbersari'),
('32.04.29.2008','Manggungharja'),
('32.04.29.2009','Sagaracipta'),
('32.04.29.2010','Sarimahi'),
('32.04.29.2011','Serangmekar'),
('32.04.29.2012','Babakan'),
('32.04.29.2013','Bumiwangi'),
('32.04.29.2014','Mekarlaksana'),
('32.04.30','Pacet'),
('32.04.30.2001','Cipeujeuh'),
('32.04.30.2002','Cikitu'),
('32.04.30.2003','Cinanggela'),
('32.04.30.2004','Maruyung'),
('32.04.30.2005','Sukarame'),
('32.04.30.2006','Nagrak'),
('32.04.30.2007','Cikawao'),
('32.04.30.2008','Mekarjaya'),
('32.04.30.2009','Pangauban'),
('32.04.30.2010','Mandalahaji'),
('32.04.30.2011','Girimulya'),
('32.04.30.2012','Tanjungwangi'),
('32.04.30.2013','Mekarsari'),
('32.04.31','Kertasari'),
('32.04.31.2001','Sukapura'),
('32.04.31.2002','Cibeureum'),
('32.04.31.2003','Santosa'),
('32.04.31.2004','Tarumajaya'),
('32.04.31.2005','Neglawangi'),
('32.04.31.2006','Cihawuk'),
('32.04.31.2007','Cikembang'),
('32.04.31.2008','Resmi Tingal'),
('32.04.32','Baleendah'),
('32.04.32.1001','Baleendah'),
('32.04.32.1002','Andir'),
('32.04.32.1003','Manggahang'),
('32.04.32.1004','Jelekong'),
('32.04.32.1008','Wargamekar'),
('32.04.32.2005','Bojongmalaka'),
('32.04.32.2006','Rancamanyar'),
('32.04.32.2007','Malakasari'),
('32.04.33','Majalaya'),
('32.04.33.2001','Majalaya'),
('32.04.33.2002','Wangisagara'),
('32.04.33.2003','Biru'),
('32.04.33.2004','Padamulya'),
('32.04.33.2005','Bojong'),
('32.04.33.2006','Majasetra'),
('32.04.33.2007','Majakerta'),
('32.04.33.2008','Sukamaju'),
('32.04.33.2009','Padaulun'),
('32.04.33.2010','Neglasari'),
('32.04.33.2011','Sukamukti'),
('32.04.34','Solokanjeruk'),
('32.04.34.2001','Rancakasumba'),
('32.04.34.2002','Solokanjeruk'),
('32.04.34.2003','Cibodas'),
('32.04.34.2004','Panyadap'),
('32.04.34.2005','Bojongemas'),
('32.04.34.2006','Padamukti'),
('32.04.34.2007','Langensari'),
('32.04.35','Paseh'),
('32.04.35.2001','Cigentur'),
('32.04.35.2002','Cipedes'),
('32.04.35.2003','Loa'),
('32.04.35.2004','Cijagra'),
('32.04.35.2005','Cipaku'),
('32.04.35.2006','Sindangsari'),
('32.04.35.2007','Drawati'),
('32.04.35.2008','Sukamanah'),
('32.04.35.2009','Sukamantri'),
('32.04.35.2010','Karangtunggal'),
('32.04.35.2011','Mekarpawitan'),
('32.04.35.2012','Tangsimekar'),
('32.04.36','Ibun'),
('32.04.36.2001','Ibun'),
('32.04.36.2002','Laksana'),
('32.04.36.2003','Dukuh'),
('32.04.36.2004','Talun'),
('32.04.36.2005','Pangguh'),
('32.04.36.2006','Lampegan'),
('32.04.36.2007','Neglasari'),
('32.04.36.2008','Mekarwangi'),
('32.04.36.2009','Sudi'),
('32.04.36.2010','Tanggulun'),
('32.04.36.2011','Cibeet'),
('32.04.36.2012','Karyalaksana'),
('32.04.37','Soreang'),
('32.04.37.2001','Soreang'),
('32.04.37.2002','Sadu'),
('32.04.37.2004','Panyirapan'),
('32.04.37.2010','Sukajadi'),
('32.04.37.2011','Pamekaran'),
('32.04.37.2017','Karamatmulya'),
('32.04.37.2018','Sukanagara'),
('32.04.37.2019','Cingcin'),
('32.04.37.2020','Parungserab'),
('32.04.37.2021','Sekarwangi'),
('32.04.38','Pasirjambu'),
('32.04.38.2001','Pasirjambu'),
('32.04.38.2002','Cibodas'),
('32.04.38.2003','Cikoneng'),
('32.04.38.2004','Cukanggenteng'),
('32.04.38.2005','Cisondari'),
('32.04.38.2006','Margamulya'),
('32.04.38.2007','Mekarsari'),
('32.04.38.2008','Mekarmaju'),
('32.04.38.2009','Sugihmukti'),
('32.04.38.2010','Tenjolaya'),
('32.04.39','Ciwidey'),
('32.04.39.2001','Lebakmuncang'),
('32.04.39.2002','Ciwidey'),
('32.04.39.2003','Nengkelan'),
('32.04.39.2004','Panundaan'),
('32.04.39.2005','Panyocokan'),
('32.04.39.2006','Rawabogo'),
('32.04.39.2007','Sukawening'),
('32.04.40','Rancabali'),
('32.04.40.2001','Patengan'),
('32.04.40.2002','Sukaresmi'),
('32.04.40.2003','Indragiri'),
('32.04.40.2004','Cipelah'),
('32.04.40.2005','Alamendah'),
('32.04.44','Cangkuang'),
('32.04.44.2001','Cangkuang'),
('32.04.44.2002','Ciluncat'),
('32.04.44.2003','Nagrak'),
('32.04.44.2004','Bandasari'),
('32.04.44.2005','Pananjung'),
('32.04.44.2006','Jatisari'),
('32.04.44.2007','Tanjungsari'),
('32.04.46','Kutawaringin'),
('32.04.46.2001','Jelegong'),
('32.04.46.2002','Jatisari'),
('32.04.46.2003','Pameuntasan'),
('32.04.46.2004','Kopo'),
('32.04.46.2005','Cibodas'),
('32.04.46.2006','Kutawaringin'),
('32.04.46.2007','Sukamulya'),
('32.04.46.2008','Padasuka'),
('32.04.46.2009','Buninagara'),
('32.04.46.2010','Gajah Mekar'),
('32.04.46.2011','Cilame'),
('32.05','Kabupaten Garut'),
('32.05.01','Garut Kota'),
('32.05.01.1001','Kota Kulon'),
('32.05.01.1002','Kota Wetan'),
('32.05.01.1003','Margawati'),
('32.05.01.1004','Pakuwon'),
('32.05.01.1005','Muara Sanding'),
('32.05.01.1006','Sukamentri'),
('32.05.01.1007','Ciwalen'),
('32.05.01.1008','Paminggir'),
('32.05.01.1009','Regol'),
('32.05.01.1010','Sukanegla'),
('32.05.01.1011','Cimuncang'),
('32.05.02','Karangpawitan'),
('32.05.02.1001','Suci Kaler'),
('32.05.02.1002','Lebakjaya'),
('32.05.02.1003','Karangmulya'),
('32.05.02.1014','Lengkongjaya'),
('32.05.02.2004','Karangpawitan'),
('32.05.02.2005','Situgede'),
('32.05.02.2006','Cimurah'),
('32.05.02.2007','Suci'),
('32.05.02.2008','Jatisari'),
('32.05.02.2009','Godog'),
('32.05.02.2010','Situsari'),
('32.05.02.2011','Karangsari'),
('32.05.02.2012','Sindangpalay'),
('32.05.02.2013','Lebakagung'),
('32.05.02.2015','Sindanggalih'),
('32.05.02.2016','Mekarsari'),
('32.05.02.2017','Sindanglaya'),
('32.05.02.2018','Tanjungsari'),
('32.05.02.2019','Situsaeur'),
('32.05.02.2020','Situjaya'),
('32.05.03','Wanaraja'),
('32.05.03.2001','Wanaraja'),
('32.05.03.2002','Wanamekar'),
('32.05.03.2003','Cinunuk'),
('32.05.03.2007','Sukamenak'),
('32.05.03.2008','Sindangratu'),
('32.05.03.2011','Wanajaya'),
('32.05.03.2015','Sindangmekar'),
('32.05.03.2019','Wanasari'),
('32.05.03.2024','Sindangprabu'),
('32.05.04','Tarogong Kaler'),
('32.05.04.1012','Pananjung'),
('32.05.04.2001','Sukajadi'),
('32.05.04.2002','Cimanganten'),
('32.05.04.2003','Jati'),
('32.05.04.2004','Rancabango'),
('32.05.04.2005','Sukawangi'),
('32.05.04.2006','Sirnajaya'),
('32.05.04.2007','Tanjung Kamuning'),
('32.05.04.2008','Mekarjaya'),
('32.05.04.2009','Langensari'),
('32.05.04.2010','Mekarwangi'),
('32.05.04.2011','Pasawahan'),
('32.05.04.2013','Panjiwangi'),
('32.05.05','Tarogong Kidul'),
('32.05.05.1001','Pataruman'),
('32.05.05.1002','Sukagalih'),
('32.05.05.1006','Jayawaras'),
('32.05.05.1009','Sukakarya'),
('32.05.05.1012','Sukajaya'),
('32.05.05.2003','Jayaraga'),
('32.05.05.2004','Haurpanggung'),
('32.05.05.2005','Cibunar'),
('32.05.05.2007','Sukabakti'),
('32.05.05.2008','Tarogong'),
('32.05.05.2010','Mekargalih'),
('32.05.05.2011','Kersamenak'),
('32.05.06','Banyuresmi'),
('32.05.06.2001','Banyuresmi'),
('32.05.06.2002','Cimareme'),
('32.05.06.2003','Sukaratu'),
('32.05.06.2004','Sukasenang'),
('32.05.06.2005','Sukaraja'),
('32.05.06.2006','Cipicung'),
('32.05.06.2007','Dangdeur'),
('32.05.06.2008','Sukakarya'),
('32.05.06.2009','Pamekarsari'),
('32.05.06.2010','Binakarya'),
('32.05.06.2011','Bagendit'),
('32.05.06.2012','Karyamukti'),
('32.05.06.2013','Karyasari'),
('32.05.06.2014','Sukamukti'),
('32.05.06.2015','Sukalaksana'),
('32.05.07','Samarang'),
('32.05.07.2001','Samarang'),
('32.05.07.2002','Cintarakyat'),
('32.05.07.2003','Sukarasa'),
('32.05.07.2004','Parakan'),
('32.05.07.2005','Sukakarya'),
('32.05.07.2006','Cintakarya'),
('32.05.07.2007','Tanjung Karya'),
('32.05.07.2008','Cisarua'),
('32.05.07.2009','Cintarasa'),
('32.05.07.2010','Cintaasih'),
('32.05.07.2011','Sirnasari'),
('32.05.07.2012','Sukalaksana'),
('32.05.07.2013','Tanjunganom'),
('32.05.08','Pasirwangi'),
('32.05.08.2001','Pasirwangi'),
('32.05.08.2002','Pasirkiamis'),
('32.05.08.2003','Padasuka'),
('32.05.08.2004','Karyamekar'),
('32.05.08.2005','Padawaas'),
('32.05.08.2006','Padaasih'),
('32.05.08.2007','Barusari'),
('32.05.08.2008','Talaga'),
('32.05.08.2009','Padamukti'),
('32.05.08.2010','Sinarjaya'),
('32.05.08.2011','Sarimukti'),
('32.05.08.2012','Padamulya'),
('32.05.09','Leles'),
('32.05.09.2001','Leles'),
('32.05.09.2002','Ciburial'),
('32.05.09.2003','Jangkurang'),
('32.05.09.2004','Sukarame'),
('32.05.09.2005','Lembang'),
('32.05.09.2006','Cangkuang'),
('32.05.09.2007','Salamnunggal'),
('32.05.09.2008','Kandangmukti'),
('32.05.09.2009','Margaluyu'),
('32.05.09.2010','Cipancar'),
('32.05.09.2011','Haruman'),
('32.05.09.2012','Dano'),
('32.05.10','Kadungora'),
('32.05.10.2001','Kadungora'),
('32.05.10.2002','Gandamekar'),
('32.05.10.2003','Cikembulan'),
('32.05.10.2004','Cisaat'),
('32.05.10.2005','Mandalasari'),
('32.05.10.2006','Tanggulun'),
('32.05.10.2007','Mekarbakti'),
('32.05.10.2008','Karangmulya'),
('32.05.10.2009','Harumansari'),
('32.05.10.2010','Talagasari'),
('32.05.10.2011','Hegarsari'),
('32.05.10.2012','Neglasari'),
('32.05.10.2013','Karangtengah'),
('32.05.10.2014','Rancasalak'),
('32.05.11','Leuwigoong'),
('32.05.11.2001','Leuwigoong'),
('32.05.11.2002','Karanganyar'),
('32.05.11.2003','Margacinta'),
('32.05.11.2004','Margahayu'),
('32.05.11.2005','Dungusiku'),
('32.05.11.2006','Tambak Sari'),
('32.05.11.2007','Sindangsari'),
('32.05.11.2008','Karangsari'),
('32.05.12','Cibatu'),
('32.05.12.2001','Cibatu'),
('32.05.12.2002','Mekarsari'),
('32.05.12.2003','Cibunar'),
('32.05.12.2004','Sindangsuka'),
('32.05.12.2005','Kertajaya'),
('32.05.12.2006','Sukalilah'),
('32.05.12.2007','Padasuka'),
('32.05.12.2008','Karyamukti'),
('32.05.12.2009','Girimukti'),
('32.05.12.2010','Keresek'),
('32.05.12.2011','Wanakerta'),
('32.05.13','Kersamanah'),
('32.05.13.2001','Kersamanah'),
('32.05.13.2002','Nanjungjaya'),
('32.05.13.2003','Sukamerang'),
('32.05.13.2004','Girijaya'),
('32.05.13.2005','Sukamaju'),
('32.05.13.2006','Mekarraya'),
('32.05.14','Malangbong'),
('32.05.14.2001','Malangbong'),
('32.05.14.2002','Karangmulya'),
('32.05.14.2003','Cibunar'),
('32.05.14.2004','Cikarag'),
('32.05.14.2005','Sakawayana'),
('32.05.14.2006','Mekarasih'),
('32.05.14.2007','Cisitu'),
('32.05.14.2008','Campaka'),
('32.05.14.2009','Lewobaru'),
('32.05.14.2010','Sukamanah'),
('32.05.14.2011','Cilampuyang'),
('32.05.14.2012','Cinagara'),
('32.05.14.2013','Sukaratu'),
('32.05.14.2014','Citeras'),
('32.05.14.2015','Sukarasa'),
('32.05.14.2016','Sekarwangi'),
('32.05.14.2017','Kutanagara'),
('32.05.14.2018','Sanding'),
('32.05.14.2019','Cihaurkuning'),
('32.05.14.2020','Baru Dua'),
('32.05.14.2021','Sukajaya'),
('32.05.14.2022','Bunisari'),
('32.05.14.2023','Mekarmulya'),
('32.05.14.2024','Girimakmur'),
('32.05.15','Sukawening'),
('32.05.15.2001','Sukawening'),
('32.05.15.2002','Sukamukti'),
('32.05.15.2003','Mekarluyu'),
('32.05.15.2004','Sukaluyu'),
('32.05.15.2005','Sudalarang'),
('32.05.15.2006','Sukasono'),
('32.05.15.2007','Sukahaji'),
('32.05.15.2008','Pasanggrahan'),
('32.05.15.2009','Maripari'),
('32.05.15.2010','Mekarwangi'),
('32.05.15.2011','Mekar Hurip'),
('32.05.16','Karangtengah'),
('32.05.16.2001','Caringin'),
('32.05.16.2002','Cintamanik'),
('32.05.16.2003','Cinta'),
('32.05.16.2004','Sindanggalih'),
('32.05.17','Bayongbong'),
('32.05.17.2001','Bayongbong'),
('32.05.17.2002','Panembong'),
('32.05.17.2003','Hegarmanah'),
('32.05.17.2004','Salakuray'),
('32.05.17.2005','Karyajaya'),
('32.05.17.2006','Mulyasari'),
('32.05.17.2007','Pamalayan'),
('32.05.17.2008','Mekarsari'),
('32.05.17.2009','Ciburuy'),
('32.05.17.2010','Ciela'),
('32.05.17.2011','Cikedokan'),
('32.05.17.2012','Banjarsari'),
('32.05.17.2013','Sukasenang'),
('32.05.17.2014','Mekarjaya'),
('32.05.17.2015','Sirnagalih'),
('32.05.17.2016','Sukarame'),
('32.05.17.2017','Cinisti'),
('32.05.17.2018','Sukamanah'),
('32.05.18','Cigedug'),
('32.05.18.2001','Cigedug'),
('32.05.18.2002','Barusuda'),
('32.05.18.2003','Sukahurip'),
('32.05.18.2004','Sindangsari'),
('32.05.18.2005','Cintanagara'),
('32.05.19','Cilawu'),
('32.05.19.2001','Cilawu'),
('32.05.19.2002','Sukamukti'),
('32.05.19.2003','Karyamekar'),
('32.05.19.2004','Dawungsari'),
('32.05.19.2005','Pasanggrahan'),
('32.05.19.2006','Sukahati'),
('32.05.19.2007','Mekarsari'),
('32.05.19.2008','Mekarmukti'),
('32.05.19.2009','Desakolot'),
('32.05.19.2010','Ngamplangsari'),
('32.05.19.2011','Margalaksana'),
('32.05.19.2012','Dangiang'),
('32.05.19.2013','Dayeuhmanggung'),
('32.05.19.2014','Sukamaju'),
('32.05.19.2015','Mangkurakyat'),
('32.05.19.2016','Ngamplang'),
('32.05.19.2017','Sukatani'),
('32.05.19.2018','Sukamurni'),
('32.05.20','Cisurupan'),
('32.05.20.2001','Cisurupan'),
('32.05.20.2002','Cidatar'),
('32.05.20.2003','Sukawangi'),
('32.05.20.2004','Sukatani'),
('32.05.20.2005','Situsari'),
('32.05.20.2006','Pakuwon'),
('32.05.20.2007','Balewangi'),
('32.05.20.2008','Sirnajaya'),
('32.05.20.2009','Cisero'),
('32.05.20.2010','Karamatwangi'),
('32.05.20.2011','Cipaganti'),
('32.05.20.2012','Pamulihan'),
('32.05.20.2013','Tambakbaya'),
('32.05.20.2014','Sirnagalih'),
('32.05.20.2015','Pangauban'),
('32.05.20.2016','Simpangsari'),
('32.05.20.2017','Cintaasih'),
('32.05.21','Sukaresmi'),
('32.05.21.2001','Sukaresmi'),
('32.05.21.2002','Cintadamai'),
('32.05.21.2003','Mekarjaya'),
('32.05.21.2004','Sukajaya'),
('32.05.21.2005','Sukamulya'),
('32.05.21.2006','Padamukti'),
('32.05.21.2007','Sukalilah'),
('32.05.22','Cikajang'),
('32.05.22.2001','Cikajang'),
('32.05.22.2002','Simpang'),
('32.05.22.2003','Mekarsari'),
('32.05.22.2004','Girijaya'),
('32.05.22.2005','Giriawas'),
('32.05.22.2006','Cibodas'),
('32.05.22.2007','Mekarjaya'),
('32.05.22.2008','Cikandang'),
('32.05.22.2009','Padasuka'),
('32.05.22.2010','Margamulya'),
('32.05.22.2011','Cipangramatan'),
('32.05.22.2012','Karamatwangi'),
('32.05.23','Banjarwangi'),
('32.05.23.2001','Banjarwangi'),
('32.05.23.2002','Talagajaya'),
('32.05.23.2003','Padahurip'),
('32.05.23.2004','Kadongdong'),
('32.05.23.2005','Talagasari'),
('32.05.23.2006','Jayabakti'),
('32.05.23.2007','Mulyajaya'),
('32.05.23.2008','Dangiang'),
('32.05.23.2009','Tanjungjaya'),
('32.05.23.2010','Bojong'),
('32.05.23.2011','Wangunjaya'),
('32.05.24','Singajaya'),
('32.05.24.2001','Singajaya'),
('32.05.24.2002','Ciudian'),
('32.05.24.2003','Mekartani'),
('32.05.24.2004','Sukamulya'),
('32.05.24.2005','Sukawangi'),
('32.05.24.2006','Pancasura'),
('32.05.24.2007','Karangagung'),
('32.05.24.2008','Cigintung'),
('32.05.24.2009','Girimukti'),
('32.05.25','Cihurip'),
('32.05.25.2001','Cihurip'),
('32.05.25.2002','Cisangkal'),
('32.05.25.2003','Mekarwangi'),
('32.05.25.2004','Jayamukti'),
('32.05.26','Peundeuy'),
('32.05.26.2001','Peundeuy'),
('32.05.26.2002','Toblong'),
('32.05.26.2003','Saribakti'),
('32.05.26.2004','Pangrumasan'),
('32.05.26.2005','Sukanagara'),
('32.05.26.2006','Purwajaya'),
('32.05.27','Pameungpeuk'),
('32.05.27.2001','Pameungpeuk'),
('32.05.27.2002','Mancagahar'),
('32.05.27.2003','Paas'),
('32.05.27.2004','Mandalakasih'),
('32.05.27.2005','Jatimulya'),
('32.05.27.2006','Bojong'),
('32.05.27.2007','Sirnabakti'),
('32.05.27.2008','Bojong Kidul'),
('32.05.28','Cisompet'),
('32.05.28.2001','Cisompet'),
('32.05.28.2002','Cihaurkuning'),
('32.05.28.2003','Margamulya'),
('32.05.28.2004','Sukamukti'),
('32.05.28.2005','Sukanagara'),
('32.05.28.2006','Cikondang'),
('32.05.28.2007','Depok'),
('32.05.28.2008','Panyindangan'),
('32.05.28.2009','Jatisari'),
('32.05.28.2010','Neglasari'),
('32.05.28.2011','Sindangsari'),
('32.05.29','Cibalong'),
('32.05.29.2001','Karyasari'),
('32.05.29.2002','Maroko'),
('32.05.29.2003','Sancang'),
('32.05.29.2004','Karyamukti'),
('32.05.29.2005','Sagara'),
('32.05.29.2006','Mekarsari'),
('32.05.29.2007','Simpang'),
('32.05.29.2008','Mekar Mukti'),
('32.05.29.2009','Cigaronggong'),
('32.05.29.2010','Mekarwangi'),
('32.05.29.2011','Najaten'),
('32.05.30','Cikelet'),
('32.05.30.2001','Cikelet'),
('32.05.30.2002','Linggamanik'),
('32.05.30.2003','Kertamukti'),
('32.05.30.2004','Cigadog'),
('32.05.30.2005','Pamalayan'),
('32.05.30.2006','Karangsari'),
('32.05.30.2007','Cijambe'),
('32.05.30.2008','Girimukti'),
('32.05.30.2009','Ciroyom'),
('32.05.30.2010','Awassagara'),
('32.05.30.2011','Tipar'),
('32.05.31','Bungbulang'),
('32.05.31.2001','Bungbulang'),
('32.05.31.2002','Hanjuang'),
('32.05.31.2003','Gunamekar'),
('32.05.31.2004','Tegallega'),
('32.05.31.2005','Mekarbakti'),
('32.05.31.2006','Margalaksana'),
('32.05.31.2007','Bojong'),
('32.05.31.2008','Sinarjaya'),
('32.05.31.2009','Mekarjaya'),
('32.05.31.2010','Cihikeu'),
('32.05.31.2011','Wangunjaya'),
('32.05.31.2012','Gunung Jampang'),
('32.05.31.2013','Hegarmanah'),
('32.05.32','Mekarmukti'),
('32.05.32.2001','Mekarmukti'),
('32.05.32.2002','Karangwangi'),
('32.05.32.2003','Jagabaya'),
('32.05.32.2004','Cijayana'),
('32.05.32.2005','Mekarsari'),
('32.05.33','Pakenjeng'),
('32.05.33.2001','Neglasari'),
('32.05.33.2002','Tanjungjaya'),
('32.05.33.2003','Tanjungmulya'),
('32.05.33.2004','Wangunjaya'),
('32.05.33.2005','Sukamulya'),
('32.05.33.2006','Pasirlangu'),
('32.05.33.2007','Talagawangi'),
('32.05.33.2008','Jatiwangi'),
('32.05.33.2009','Panyindangan'),
('32.05.33.2010','Tegalgede'),
('32.05.33.2011','Depok'),
('32.05.33.2012','Karangsari'),
('32.05.33.2013','Jayamekar'),
('32.05.34','Pamulihan'),
('32.05.34.2001','Pakenjeng'),
('32.05.34.2002','Garumukti'),
('32.05.34.2003','Panawa'),
('32.05.34.2004','Pananjung'),
('32.05.34.2005','Linggarjati'),
('32.05.35','Cisewu'),
('32.05.35.2001','Cisewu'),
('32.05.35.2002','Girimukti'),
('32.05.35.2003','Pamalayan'),
('32.05.35.2004','Cikarang'),
('32.05.35.2005','Sukajaya'),
('32.05.35.2006','Nyalindung'),
('32.05.35.2007','Karangsewu'),
('32.05.35.2008','Mekarsewu'),
('32.05.35.2009','Panggalih'),
('32.05.36','Caringin'),
('32.05.36.2001','Caringin'),
('32.05.36.2002','Indralayang'),
('32.05.36.2003','Cimahi'),
('32.05.36.2004','Sukarame'),
('32.05.36.2005','Purbayani'),
('32.05.36.2006','Samuderajaya'),
('32.05.37','Talegong'),
('32.05.37.2001','Sukamaju'),
('32.05.37.2002','Sukamulya'),
('32.05.37.2003','Mekarmukti'),
('32.05.37.2004','Mekarmulya'),
('32.05.37.2005','Sukalaksana'),
('32.05.37.2006','Selaawi'),
('32.05.37.2007','Mekarwangi'),
('32.05.38','Limbangan'),
('32.05.38.2001','Limbangan Tengah'),
('32.05.38.2002','Limbangan Barat'),
('32.05.38.2003','Galihpakuwon'),
('32.05.38.2004','Surabaya'),
('32.05.38.2005','Cijolang'),
('32.05.38.2006','Neglasari'),
('32.05.38.2007','Simpen Kaler'),
('32.05.38.2008','Pasirwaru'),
('32.05.38.2009','Simpen Kidul'),
('32.05.38.2010','Ciwangi'),
('32.05.38.2011','Cigagade'),
('32.05.38.2012','Limbangan Timur'),
('32.05.38.2013','Dunguswiru'),
('32.05.38.2014','Pangeureunan'),
('32.05.39','Selaawi'),
('32.05.39.2001','Selaawi'),
('32.05.39.2002','Putrajawa'),
('32.05.39.2003','Cigawir'),
('32.05.39.2004','Pelitaasih'),
('32.05.39.2005','Cirapuhan'),
('32.05.39.2006','Mekarsari'),
('32.05.39.2007','Samida'),
('32.05.40','Cibiuk'),
('32.05.40.2001','Cipareuan'),
('32.05.40.2002','Cibiuk Kaler'),
('32.05.40.2003','Cibiuk Kidul'),
('32.05.40.2004','Majasari'),
('32.05.40.2005','Lingkungpasir'),
('32.05.41','Pangatikan'),
('32.05.41.2001','Citangtu'),
('32.05.41.2002','Cimaragas'),
('32.05.41.2003','Babakan Loa'),
('32.05.41.2004','Sukahurip'),
('32.05.41.2005','Sukamulya'),
('32.05.41.2006','Cihuni'),
('32.05.41.2007','Sukarasa'),
('32.05.41.2008','Karangsari'),
('32.05.42','Sucinaraja'),
('32.05.42.2001','Sadang'),
('32.05.42.2002','Sukaratu'),
('32.05.42.2003','Tenjonagara'),
('32.05.42.2004','Tegalpanjang'),
('32.05.42.2005','Cigadog'),
('32.05.42.2006','Linggamukti'),
('32.05.42.2007','Sukalaksana'),
('32.06','Kabupaten Tasikmalaya'),
('32.06.01','Cipatujah'),
('32.06.01.2001','Ciheras'),
('32.06.01.2002','Cipatujah'),
('32.06.01.2003','Sindangkerta'),
('32.06.01.2004','Cikawungading'),
('32.06.01.2005','Bantarkalong'),
('32.06.01.2006','Darawati'),
('32.06.01.2007','Nagrog'),
('32.06.01.2008','Pameutingan'),
('32.06.01.2009','Tobongjaya'),
('32.06.01.2010','Cipanas'),
('32.06.01.2011','Kertasari'),
('32.06.01.2012','Ciandum'),
('32.06.01.2013','Nangelasari'),
('32.06.01.2014','Padawaras'),
('32.06.01.2015','Sukahurip'),
('32.06.02','Karangnunggal'),
('32.06.02.2001','Cidadap'),
('32.06.02.2002','Ciawi'),
('32.06.02.2003','Cikupa'),
('32.06.02.2004','Karangnunggal'),
('32.06.02.2005','Karangmekar'),
('32.06.02.2006','Cikukulu'),
('32.06.02.2007','Cibatuireng'),
('32.06.02.2008','Cibatu'),
('32.06.02.2009','Sarimanggu'),
('32.06.02.2010','Sukawangun'),
('32.06.02.2011','Cintawangi'),
('32.06.02.2012','Cikapinis'),
('32.06.02.2013','Sarimukti'),
('32.06.02.2014','Kujang'),
('32.06.03','Cikalong'),
('32.06.03.2001','Cikalong'),
('32.06.03.2002','Kalapagenep'),
('32.06.03.2003','Cikancra'),
('32.06.03.2004','Singkir'),
('32.06.03.2005','Panyiaran'),
('32.06.03.2006','Cibeber'),
('32.06.03.2007','Cikadu'),
('32.06.03.2008','Mandalajaya'),
('32.06.03.2009','Cidadali'),
('32.06.03.2010','Cimanuk'),
('32.06.03.2011','Sindangjaya'),
('32.06.03.2012','Kubangsari'),
('32.06.03.2013','Tonjongsari'),
('32.06.04','Pancatengah'),
('32.06.04.2001','Cibuniasih'),
('32.06.04.2002','Pangliaran'),
('32.06.04.2003','Tonjong'),
('32.06.04.2004','Cibongas'),
('32.06.04.2005','Tawang'),
('32.06.04.2006','Neglasari'),
('32.06.04.2007','Cikawung'),
('32.06.04.2008','Jayamukti'),
('32.06.04.2009','Margaluyu'),
('32.06.04.2010','Mekarsari'),
('32.06.04.2011','Pancawangi'),
('32.06.05','Cikatomas'),
('32.06.05.2001','Gunungsari'),
('32.06.05.2002','Cilumba'),
('32.06.05.2003','Pakemitan'),
('32.06.05.2004','Cogreg'),
('32.06.05.2005','Cayur'),
('32.06.05.2006','Lengkongbarang'),
('32.06.05.2007','Sindangasih'),
('32.06.05.2008','Tanjungbarang'),
('32.06.05.2009','Linggalaksana'),
('32.06.06','Cibalong'),
('32.06.06.2001','Cisempur'),
('32.06.06.2002','Setiawaras'),
('32.06.06.2003','Eureunpalay'),
('32.06.06.2004','Cibalong'),
('32.06.06.2005','Singajaya'),
('32.06.06.2006','Parung'),
('32.06.07','Parungponteng'),
('32.06.07.2001','Parungponteng'),
('32.06.07.2002','Cigunung'),
('32.06.07.2003','Cibanteng'),
('32.06.07.2004','Barumekar'),
('32.06.07.2005','Cibungur'),
('32.06.07.2006','Burujuljaya'),
('32.06.07.2007','Girikencana'),
('32.06.07.2008','Karyabakti'),
('32.06.08','Bantarkalong'),
('32.06.08.2001','Simpang'),
('32.06.08.2002','Parakanhonje'),
('32.06.08.2003','Pamijahan'),
('32.06.08.2004','Sukamaju'),
('32.06.08.2005','Wangunsari'),
('32.06.08.2006','Hegarwangi'),
('32.06.08.2007','Wakap'),
('32.06.08.2008','Sirnagalih'),
('32.06.09','Bojongasih'),
('32.06.09.2001','Mertajaya'),
('32.06.09.2002','Cikadongdong'),
('32.06.09.2003','Bojongasih'),
('32.06.09.2004','Sindangsari'),
('32.06.09.2005','Girijaya'),
('32.06.09.2006','Toblongan'),
('32.06.10','Culamega'),
('32.06.10.2001','Cikuya'),
('32.06.10.2002','Cintabodas'),
('32.06.10.2003','Cipicung'),
('32.06.10.2004','Bojongsari'),
('32.06.10.2005','Mekarlaksana'),
('32.06.11','Bojonggambir'),
('32.06.11.2001','Bojongkapol'),
('32.06.11.2002','Pedangkamulyan'),
('32.06.11.2003','Bojonggambir'),
('32.06.11.2004','Ciroyom'),
('32.06.11.2005','Wandasari'),
('32.06.11.2006','Campakasari'),
('32.06.11.2007','Mangkonjaya'),
('32.06.11.2008','Kertanegla'),
('32.06.11.2009','Purwaraharja'),
('32.06.11.2010','Girimukti'),
('32.06.12','Sodonghilir'),
('32.06.12.2001','Parumasan'),
('32.06.12.2002','Cukangkawung'),
('32.06.12.2003','Sodonghilir'),
('32.06.12.2004','Cikalong'),
('32.06.12.2005','Cipaingeun'),
('32.06.12.2006','Leuwidulang'),
('32.06.12.2007','Muncang'),
('32.06.12.2008','Sepatnunggal'),
('32.06.12.2009','Cukangjayaguna'),
('32.06.12.2010','Raksajaya'),
('32.06.12.2011','Pakalongan'),
('32.06.12.2012','Sukabakti'),
('32.06.13','Taraju'),
('32.06.13.2001','Taraju'),
('32.06.13.2002','Cikubang'),
('32.06.13.2003','Deudeul'),
('32.06.13.2004','Purwarahayu'),
('32.06.13.2005','Singasari'),
('32.06.13.2006','Banyuasih'),
('32.06.13.2007','Raksasari'),
('32.06.13.2008','Kertaraharja'),
('32.06.13.2009','Pageralam'),
('32.06.14','Salawu'),
('32.06.14.2001','Jahiang'),
('32.06.14.2002','Serang'),
('32.06.14.2003','Salawu'),
('32.06.14.2004','Neglasari'),
('32.06.14.2005','Tanjungsari'),
('32.06.14.2006','Tenjowaringin'),
('32.06.14.2007','Sundawenang'),
('32.06.14.2008','Kawungsari'),
('32.06.14.2009','Sukarasa'),
('32.06.14.2010','Kutawaringin'),
('32.06.14.2011','Karangmukti'),
('32.06.14.2012','Margalaksana'),
('32.06.15','Puspahiang'),
('32.06.15.2001','Mandalasari'),
('32.06.15.2002','Sukasari'),
('32.06.15.2003','Puspasari'),
('32.06.15.2004','Puspahiang'),
('32.06.15.2005','Luyubakti'),
('32.06.15.2006','Pusparahayu'),
('32.06.15.2007','Cimanggu'),
('32.06.15.2008','Puspajaya'),
('32.06.16','Tanjungjaya'),
('32.06.16.2001','Cikeusal'),
('32.06.16.2002','Cibalanarik'),
('32.06.16.2003','Sukanagara'),
('32.06.16.2004','Tanjungjaya'),
('32.06.16.2005','Cilolohan'),
('32.06.16.2006','Cintajaya'),
('32.06.16.2007','Sukasenang'),
('32.06.17','Sukaraja'),
('32.06.17.2001','Sukapura'),
('32.06.17.2002','Leuwibudah'),
('32.06.17.2003','Sirnajaya'),
('32.06.17.2004','Mekarjaya'),
('32.06.17.2005','Linggaraja'),
('32.06.17.2006','Janggala'),
('32.06.17.2007','Margalaksana'),
('32.06.17.2008','Tarunajaya'),
('32.06.18','Salopa'),
('32.06.18.2001','Mandalahayu'),
('32.06.18.2002','Mulyasari'),
('32.06.18.2003','Kawitan'),
('32.06.18.2004','Mandalawangi'),
('32.06.18.2005','Karyawangi'),
('32.06.18.2006','Tanjungsari'),
('32.06.18.2007','Mandalaguna'),
('32.06.18.2008','Karyamandala'),
('32.06.18.2009','Banjarwaringin'),
('32.06.19','Jatiwaras'),
('32.06.19.2001','Kaputihan'),
('32.06.19.2002','Setiawangi'),
('32.06.19.2003','Sukakerta'),
('32.06.19.2004','Neglasari'),
('32.06.19.2005','Jatiwaras'),
('32.06.19.2006','Papayan'),
('32.06.19.2007','Ciwarak'),
('32.06.19.2008','Kersagalih'),
('32.06.19.2009','Mandalamekar'),
('32.06.19.2010','Kertarahayu'),
('32.06.19.2011','Mandalahurip'),
('32.06.20','Cineam'),
('32.06.20.2001','Cisarua'),
('32.06.20.2002','Cikondang'),
('32.06.20.2003','Cijulang'),
('32.06.20.2004','Ciampanan'),
('32.06.20.2005','Cineam'),
('32.06.20.2006','Rajadatu'),
('32.06.20.2007','Ancol'),
('32.06.20.2008','Nagaratengah'),
('32.06.20.2009','Pasirmukti'),
('32.06.20.2010','Madiasari'),
('32.06.21','Karang Jaya'),
('32.06.21.2001','Sirnajaya'),
('32.06.21.2002','Karangjaya'),
('32.06.21.2003','Karang Layung'),
('32.06.21.2004','Citalahab'),
('32.06.22','Manonjaya'),
('32.06.22.2001','Cihaur'),
('32.06.22.2002','Cilangkap'),
('32.06.22.2003','Pasirpanjang'),
('32.06.22.2004','Cibeber'),
('32.06.22.2005','Kamulyan'),
('32.06.22.2006','Manonjaya'),
('32.06.22.2007','Margaluyu'),
('32.06.22.2008','Pasirbatang'),
('32.06.22.2009','Kalimanggis'),
('32.06.22.2010','Margahayu'),
('32.06.22.2011','Batusumur'),
('32.06.22.2012','Gunajaya'),
('32.06.23','Gunung Tanjung'),
('32.06.23.2001','Cinunjang'),
('32.06.23.2002','Gunungtanjung'),
('32.06.23.2003','Bojongsari'),
('32.06.23.2004','Jatijaya'),
('32.06.23.2005','Tanjungsari'),
('32.06.23.2006','Giriwangi'),
('32.06.23.2007','Malatisuka'),
('32.06.24','Singaparna'),
('32.06.24.2001','Cikunten'),
('32.06.24.2002','Singaparna'),
('32.06.24.2003','Cipakat'),
('32.06.24.2004','Cintaraja'),
('32.06.24.2005','Cikunir'),
('32.06.24.2006','Cikadongdong'),
('32.06.24.2007','Sukaasih'),
('32.06.24.2008','Sukamulya'),
('32.06.24.2009','Singasari'),
('32.06.24.2010','Sukaherang'),
('32.06.25','Mangunreja'),
('32.06.25.2001','Sukasukur'),
('32.06.25.2002','Salebu'),
('32.06.25.2003','Mangunreja'),
('32.06.25.2004','Margajaya'),
('32.06.25.2005','Pasirsalam'),
('32.06.25.2006','Sukaluyu'),
('32.06.26','Sukarame'),
('32.06.26.2001','Sukarame'),
('32.06.26.2002','Sukamenak'),
('32.06.26.2003','Sukakarsa'),
('32.06.26.2004','Padasuka'),
('32.06.26.2005','Sukarapih'),
('32.06.26.2006','Wargakerta'),
('32.06.27','Cigalontang'),
('32.06.27.2001','Kersamaju'),
('32.06.27.2002','Nangtang'),
('32.06.27.2003','Pusparaja'),
('32.06.27.2004','Jayapura'),
('32.06.27.2005','Lengkongjaya'),
('32.06.27.2006','Nanggerang'),
('32.06.27.2007','Sukamanah'),
('32.06.27.2008','Sirnaraja'),
('32.06.27.2009','Cidugaleun'),
('32.06.27.2010','Parentas'),
('32.06.27.2011','Puspamukti'),
('32.06.27.2012','Tenjonagara'),
('32.06.27.2013','Cigalontang'),
('32.06.27.2014','Sirnagalih'),
('32.06.27.2015','Tanjungkarang'),
('32.06.27.2016','Sirnaputra'),
('32.06.28','Leuwisari'),
('32.06.28.2001','Arjasari'),
('32.06.28.2002','Ciawang'),
('32.06.28.2003','Cigadog'),
('32.06.28.2004','Linggawangi'),
('32.06.28.2005','Jayamukti'),
('32.06.28.2006','Mandalagiri'),
('32.06.28.2007','Linggamulya'),
('32.06.29','Padakembang'),
('32.06.29.2001','Cilampunghilir'),
('32.06.29.2002','Rancapaku'),
('32.06.29.2003','Mekarjaya'),
('32.06.29.2004','Cisaruni'),
('32.06.29.2005','Padakembang'),
('32.06.30','Sariwangi'),
('32.06.30.2001','Sariwangi'),
('32.06.30.2002','Sukaharja'),
('32.06.30.2003','Jayaratu'),
('32.06.30.2004','Linggasirna'),
('32.06.30.2005','Sirnasari'),
('32.06.30.2006','Sukamulih'),
('32.06.30.2007','Selawangi'),
('32.06.30.2008','Jayaputra'),
('32.06.31','Sukaratu'),
('32.06.31.2001','Linggajati'),
('32.06.31.2002','Tawangbanteng'),
('32.06.31.2003','Sinagar'),
('32.06.31.2004','Gunungsari'),
('32.06.31.2005','Sukamahi'),
('32.06.31.2006','Sukagalih'),
('32.06.31.2007','Sukaratu'),
('32.06.31.2008','Indrajaya'),
('32.06.3