<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;
use Illuminate\Support\Facades\Crypt;

class ResidentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = Faker::create('id_ID'); // Locale Indonesia

        // Ambil semua ID yang ada dari tabel terkait (jika ada)
        $tenantIds = DB::table('teams')->pluck('id')->toArray();
        $neighborhoodIds = DB::table('neighborhoods')->pluck('id')->toArray();
        $religionIds = DB::table('religions')->pluck('id')->toArray();
        $maritalStatusIds = DB::table('marital_statuses')->pluck('id')->toArray();
        $bloodTypeIds = DB::table('blood_types')->pluck('id')->toArray();
        $occupationIds = DB::table('occupations')->pluck('id')->toArray();
        $educationIds = DB::table('educations')->pluck('id')->toArray();
        $genderIds = DB::table('genders')->pluck('id')->toArray();
        $userIds = DB::table('users')->pluck('id')->toArray();

        for ($i = 0; $i < 100; $i++) {
            $name = $faker->name;
            // $nik = $faker->unique()->numerify('################'); // NIK 16 digit
            // $nik = Crypt::encryptString($nik);
            // $nik_hash = hash('sha256', $nik);

            $nikPlain = $faker->unique()->numerify('################'); // NIK 16 digit asli
            $nik = Crypt::encryptString($nikPlain);             // terenkripsi untuk disimpan
            $nik_hash = hash('sha256', $nikPlain);

            DB::table('residents')->insert([
                'team_id' => $faker->randomElement($tenantIds),
                'neighborhood_id' => $faker->randomElement($neighborhoodIds),
                'name' => $name,
                'nik' => $nik,
                'nik_hash' => $nik_hash,
                'religion_id' => $faker->randomElement($religionIds),
                'marital_status_id' => $faker->randomElement($maritalStatusIds),
                'blood_type_id' => $faker->randomElement($bloodTypeIds),
                'occupation_id' => $faker->randomElement($occupationIds),
                'education_id' => $faker->randomElement($educationIds),
                'gender_id' => $faker->randomElement($genderIds),
                'photo_path' => null,
                'address' => $faker->address,
                'birth_place' => $faker->city,
                'birth_date' => $faker->date(),
                'created_at' => now(),
                'created_by' => $faker->randomElement($userIds),
            ]);
        }
    }
}
