<?php

namespace Database\Seeders;

use App\Models\Neighborhood;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NeighborhoodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $tenant = DB::table('teams')->first();

        if (!$tenant) {
            $this->command->info('Tenant tidak ditemukan. Seeder neighborhoods dibatalkan.');
            return;
        }

        // Ambil semua Dusun (Hamlet) untuk tenant ini
        $hamlets = DB::table('hamlets')
            ->where('team_id', $tenant->id)
            ->get();

        if ($hamlets->isEmpty()) {
            $this->command->info('Dusun untuk tenant ini tidak ditemukan. Seeder neighborhoods dibatalkan.');
            return;
        }

        foreach ($hamlets as $hamlet) {
            for ($i = 1; $i <= 7; $i++) {
                Neighborhood::updateOrCreate(
                    [
                        'team_id'   => $tenant->id,
                        'hamlet_id' => $hamlet->id,
                        'name'      => "RT $i",
                    ],
                    [
                        'head_id'    => null,
                        'description' => "Rukun Tetangga $i di Dusun {$hamlet->name}",
                        'created_by' => null,
                        'updated_by' => null,
                    ]
                );
            }
        }

        $this->command->info('RT berhasil dibuat untuk semua Dusun di desa.');
    }
}
