<?php

namespace Database\Seeders;

use App\Models\LetterType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class LetterTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $types = [
            [
                'team_id'   => 1,
                'code'        => 'SKD',
                'name'        => 'Surat Keterangan Domisili',
                'description' => 'Digunakan untuk menyatakan bahwa warga berdomisili di desa',
            ],
            [
                'team_id'   => 1,
                'code'        => 'SKU',
                'name'        => 'Surat Keterangan Usaha',
                'description' => 'Digunakan untuk menyatakan bahwa warga memiliki usaha tertentu',
            ],
            [
                'team_id'   => 1,
                'code'        => 'SKTM',
                'name'        => 'Surat Keterangan Tidak Mampu',
                'description' => 'Digunakan untuk keperluan bantuan sosial, sekolah, atau kesehatan',
            ],
        ];

        foreach ($types as $type) {
            LetterType::create($type);
        }
    }
}
