<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('buildings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('team_id')->constrained('teams')->cascadeOnDelete();
            $table->string('code')->unique();
            $table->foreignId('type_id')->constrained('building_types')->cascadeOnDelete();
            $table->text('address')->nullable();
            $table->foreignId('neighborhood_id')->nullable()->constrained('neighborhoods')->cascadeOnDelete();
            $table->foreignId('hamlet_id')->nullable()->constrained('hamlets')->cascadeOnDelete();
            $table->year('year_built')->nullable();
            $table->text('note')->nullable();
            $table->timestamps();
            $table->softDeletes();
            // Blameable
            $table->foreignId('created_by')->nullable()->constrained('users');
            $table->foreignId('updated_by')->nullable()->constrained('users');
            $table->foreignId('deleted_by')->nullable()->constrained('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('buildings');
    }
};
