<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NeighborhoodTransaction extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'type',
        'amount',
        'date',
        'description',
        'attachment',
    ];

    protected $casts = [
        'attachment' => 'array',
        'date' => 'date',
    ];

    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    public function neighborhood()
    {
        return $this->belongsTo(Neighborhood::class);
    }

    public static function totalIncome()
    {
        return static::where('type', 'INCOME')->sum('amount');
    }

    public static function totalExpense()
    {
        return static::where('type', 'EXPENSE')->sum('amount');
    }

    public static function balance()
    {
        return static::totalIncome() - static::totalExpense();
    }
}
