<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Neighborhood extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'name',
        'description',
        'head_id',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    public function head()
    {
        return $this->belongsTo(Resident::class, 'head_id');
    }

    public function hamlet()
    {
        return $this->belongsTo(Hamlet::class);
    }

    public function community()
    {
        return $this->belongsTo(Community::class);
    }

    public function familyCards()
    {
        return $this->hasMany(FamilyCard::class);
    }

    public function residents()
    {
        return $this->hasMany(Resident::class);
    }
}
