<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class LetterNumberSequence extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'letter_type_id',
        'year',
        'month',
        'last_number',
    ];

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }
}
