<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FamilyMember extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'family_card_id',
        'resident_id',
        'family_relationship_id',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    public function familyCard()
    {
        return $this->belongsTo(FamilyCard::class);
    }

    public function resident()
    {
        return $this->belongsTo(Resident::class);
    }

    public function relationship()
    {
        return $this->belongsTo(FamilyRelationship::class, 'family_relationship_id');
    }
}
