<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Filament\Facades\Filament;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class BusinessUnit extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'business_id',
        'business_type_id',
        'name',
        'business_description',
        'address',
        'initial_capital',
        'is_active',
        'start_date',
        'end_date',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'initial_capital' => 'decimal:2',
        'is_active'       => 'boolean',
        'start_date'      => 'date',
        'end_date'        => 'date',
    ];

    protected static function booted()
    {
        static::creating(function ($unit) {
            if (Filament::getTenant()) {
                $business = Business::where('team_id', Filament::getTenant()->id)->first();
                $unit->business_id = $business?->id;
            }
        });
    }

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }
    public function business()
    {
        return $this->belongsTo(Business::class);
    }

    public function businessType()
    {
        return $this->belongsTo(BusinessType::class);
    }

    public function transactions()
    {
        return $this->hasMany(BusinessTransaction::class);
    }
}
