<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AssistanceProgram extends Model
{
    use Blameable, SoftDeletes;

    protected $fillable = [
        'team_id',
        'name',
        'category_id',
        'description',
        'start_date',
        'end_date',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    public function category()
    {
        return $this->belongsTo(AssistanceCategory::class, 'category_id');
    }

    public function recipients()
    {
        return $this->hasMany(AssistanceRecipient::class, 'program_id');
    }
}
