<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AssistanceCategory extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'name',
        'description',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    public function assistances()
    {
        return $this->hasMany(AssistanceProgram::class, 'category_id');
    }
}
