<?php

namespace App\Filament\Widgets;

use App\Models\FamilyCard;
use App\Models\Hamlet;
use App\Models\Neighborhood;
use App\Models\Resident;
use Filament\Widgets\StatsOverviewWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class ResidentsStats extends StatsOverviewWidget
{
    protected static ?int $sort = 1;

    protected function getStats(): array
    {
        return [
            Stat::make('Total Warga', Resident::count()),
            Stat::make('Kartu Keluarga', FamilyCard::count()),
            Stat::make('RT', Neighborhood::count()),
            Stat::make('RW', Hamlet::count()),
        ];
    }
}
