<?php

namespace App\Filament\Widgets;

use App\Models\Resident;
use Filament\Actions\BulkActionGroup;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\DB;

class NeighborhoodSummaryTable extends TableWidget
{
    protected static ?int $sort = 3;
    protected int | string | array $columnSpan = 'full';

    public function table(Table $table): Table
    {
        return $table
            ->heading(null)
            ->query(fn(): Builder => Resident::query()
                ->select([
                    'neighborhood_id',
                    DB::raw('COUNT(DISTINCT id) as total_warga'),
                    DB::raw('COUNT(DISTINCT nik_hash) as total_kk'), // misal 1 KK = unik nik_hash
                    DB::raw('SUM(CASE WHEN gender_id = 1 THEN 1 ELSE 0 END) as laki_laki'),
                    DB::raw('SUM(CASE WHEN gender_id = 2 THEN 1 ELSE 0 END) as perempuan'),
                ])
                ->groupBy('neighborhood_id')
                ->with('neighborhood'))
            ->columns([
                TextColumn::make('neighborhood.number')
                    ->label('RT')
                    ->size('sm')
                    ->sortable('asc'),

                TextColumn::make('total_warga')
                    ->label('Jumlah Warga')
                    ->size('sm')
                    ->sortable(),

                TextColumn::make('laki_laki')
                    ->label('Laki-laki')
                    ->size('sm')
                    ->sortable(),

                TextColumn::make('perempuan')
                    ->label('Perempuan')
                    ->size('sm')
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                //
            ])
            ->recordActions([
                //
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    //
                ]),
            ]);
    }

    public function getTableRecordKey(mixed $record): string
    {
        // Gunakan neighborhood_id sebagai unique key
        return (string) $record->neighborhood_id;
    }
}
