<?php

namespace App\Filament\Widgets;

use App\Models\Resident;
use Filament\Widgets\ChartWidget;

class EducationChart extends ChartWidget
{
    protected static ?int $sort = 4;
    protected ?string $maxHeight = '250px';

    protected function getData(): array
    {
        $data = Resident::with('education')
            ->selectRaw('education_id, COUNT(*) as total')
            ->groupBy('education_id')
            ->get();

        $labels = $data->map(fn($item) => $item->education?->name ?? 'Unknown');
        $totals = $data->pluck('total');

        $backgroundColors = [
            '#6B7280',
            '#F97316',
            '#3B82F6',
            '#10B981',
            '#F59E0B',
            '#EF4444',
            '#8B5CF6',
            '#06B6D4',
            '#EC4899',
            '#14B8A6',
        ];

        $backgroundColors = array_slice($backgroundColors, 0, $labels->count());

        return [
            'datasets' => [
                [
                    'label' => 'Total Warga',
                    'data' => $totals,
                    'backgroundColor' => $backgroundColors,
                    'borderWidth' => 0,
                ],
            ],
            'labels' => $labels,
        ];
    }


    protected function getType(): string
    {
        return 'bar';
    }

    protected function getOptions(): array
    {
        return [
            'indexAxis' => 'y',
            'plugins' => [
                'legend' => [
                    'display' => false,
                ],
                'tooltip' => [
                    'enabled' => true,
                ],
            ],
            'scales' => [
                'x' => [
                    'beginAtZero' => true,
                    'ticks' => [
                        'precision' => 0,
                    ],
                ],
            ],
        ];
    }
}
