<?php

namespace App\Filament\Resources\Complaints\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class ComplaintForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('resident_id')
                    ->relationship('resident', 'name')
                    ->label('Warga')
                    ->searchable()
                    ->preload()
                    ->required(),

                TextInput::make('title')
                    ->label('Judul Aduan')
                    ->placeholder('Judul singkat aduan')
                    ->required(),

                Textarea::make('description')
                    ->label('Deskripsi Aduan')
                    ->placeholder('Jelaskan aduan dengan detail')
                    ->required()
                    ->columnSpanFull(),

                FileUpload::make('attachment')
                    ->label('Lampiran')
                    ->multiple()
                    ->image()
                    ->directory('complaints')
                    ->downloadable()
                    ->openable()
                    ->columnSpanFull(),
            ]);
    }
}
