<?php

namespace App\Filament\Resources\Buildings\Schemas;

use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class BuildingForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('type_id')
                    ->label('Jenis Bangunan')
                    ->relationship('type', 'name')
                    ->searchable()
                    ->preload()
                    ->required()
                    ->createOptionForm([
                        TextInput::make('name')
                            ->label('Nama Jenis Bangunan')
                            ->required()
                            ->maxLength(100),
                    ])
                    ->createOptionAction(fn($action) => $action->modalHeading('Tambah Jenis Bangunan')),

                Textarea::make('address')
                    ->label('Alamat')
                    ->rows(3)
                    ->placeholder('Alamat Lengkap')
                    ->columnSpanFull(),

                Select::make('neighborhood_id')
                    ->label('RT')
                    ->relationship('neighborhood', 'name')
                    ->preload()
                    ->searchable(),

                TextInput::make('year_built')
                    ->label('Tahun Dibangun')
                    ->placeholder('Tahun')
                    ->numeric()
                    ->minValue(1800)
                    ->maxValue(date('Y')),

                Textarea::make('note')
                    ->label('Catatan')
                    ->placeholder('Catatan')
                    ->rows(2)
                    ->columnSpanFull(),
            ]);
    }
}
