<?php

namespace App\Filament\Resources\AssistancePrograms;

use App\Filament\Resources\AssistancePrograms\Pages\CreateAssistanceProgram;
use App\Filament\Resources\AssistancePrograms\Pages\EditAssistanceProgram;
use App\Filament\Resources\AssistancePrograms\Pages\ListAssistancePrograms;
use App\Filament\Resources\AssistancePrograms\Pages\ViewAssistanceProgram;
use App\Filament\Resources\AssistancePrograms\RelationManagers\RecipientsRelationManager;
use App\Filament\Resources\AssistancePrograms\Schemas\AssistanceProgramForm;
use App\Filament\Resources\AssistancePrograms\Schemas\AssistanceProgramInfolist;
use App\Filament\Resources\AssistancePrograms\Tables\AssistanceProgramsTable;
use App\Models\AssistanceProgram;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use UnitEnum;

class AssistanceProgramResource extends Resource
{
    protected static ?int $navigationSort = 9;
    protected static ?string $model = AssistanceProgram::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::Gift;
    protected static ?string $navigationLabel = 'Bantuan Sosial';
    protected static ?string $title = 'Bantuan Sosial';
    protected static ?string $breadcrumb = 'Bantuan Sosial';
    protected static ?string $pluralLabel = 'Bantuan Sosial';

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return AssistanceProgramForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return AssistanceProgramsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            RecipientsRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListAssistancePrograms::route('/'),
            // 'create' => CreateAssistanceProgram::route('/create'),
            // 'view' => ViewAssistanceProgram::route('/{record}'),
            'edit' => EditAssistanceProgram::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
