<?php

namespace App\Filament\Clusters\Regions\Resources\Neighborhoods;

use App\Filament\Clusters\Regions\RegionsCluster;
use App\Filament\Clusters\Regions\Resources\Neighborhoods\Pages\CreateNeighborhood;
use App\Filament\Clusters\Regions\Resources\Neighborhoods\Pages\EditNeighborhood;
use App\Filament\Clusters\Regions\Resources\Neighborhoods\Pages\ListNeighborhoods;
use App\Filament\Clusters\Regions\Resources\Neighborhoods\Pages\ViewNeighborhood;
use App\Filament\Clusters\Regions\Resources\Neighborhoods\Schemas\NeighborhoodForm;
use App\Filament\Clusters\Regions\Resources\Neighborhoods\Schemas\NeighborhoodInfolist;
use App\Filament\Clusters\Regions\Resources\Neighborhoods\Tables\NeighborhoodsTable;
use App\Models\Neighborhood;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class NeighborhoodResource extends Resource
{
    protected static ?string $model = Neighborhood::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::Users;

    protected static ?string $cluster = RegionsCluster::class;

    protected static ?int $navigationSort = 3;
    protected static ?string $navigationLabel = 'Rukun Tetangga (RT)';
    protected static ?string $title = 'Rukun Tetangga (RT)';
    protected static ?string $breadcrumb = 'Rukun Tetangga (RT)';
    protected static ?string $pluralLabel = 'Rukun Tetangga (RT)';

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return NeighborhoodForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return NeighborhoodInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return NeighborhoodsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListNeighborhoods::route('/'),
            // 'create' => CreateNeighborhood::route('/create'),
            // 'view' => ViewNeighborhood::route('/{record}'),
            // 'edit' => EditNeighborhood::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
