<?php

namespace App\Filament\Clusters\Populations\Resources\Residents\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ForceDeleteBulkAction;
use Filament\Actions\RestoreAction;
use Filament\Actions\RestoreBulkAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\TrashedFilter;
use Filament\Tables\Table;

class ResidentsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                ImageColumn::make('photo_path')->label('Foto')->circular(),

                TextColumn::make('nik')
                    ->label('NIK')
                    ->sortable()
                    ->searchable(),

                TextColumn::make('name')
                    ->label('Nama Lengkap')
                    ->description(fn($record) => $record->birth_place . ', ' . $record->birth_date?->format('d-m-Y'))
                    ->searchable(),

                TextColumn::make('gender.name')
                    ->label('L/P')
                    ->badge()
                    ->color(fn($state) => $state === 'Laki-laki' ? 'info' : 'pink'),

                TextColumn::make('age')
                    ->label('Umur'),

                TextColumn::make('address')
                    ->label('Alamat')
                    ->wrap(),

                TextColumn::make('occupation.name')
                    ->label('Pekerjaan'),
            ])
            ->filters([
                TrashedFilter::make(),
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
                RestoreAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                    ForceDeleteBulkAction::make(),
                    RestoreBulkAction::make(),
                ]),
            ]);
    }
}
