<?php

namespace App\Filament\Clusters\Populations\Resources\FamilyCards\RelationManagers;

use App\Models\Resident;
use Filament\Actions\AssociateAction;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\CreateAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\DissociateAction;
use Filament\Actions\DissociateBulkAction;
use Filament\Actions\EditAction;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Schemas\Schema;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class MembersRelationManager extends RelationManager
{
    protected static string $relationship = 'members';
    protected static ?string $recordTitleAttribute = 'resident.name';
    protected static ?string $title = 'Anggota Keluarga';
    protected static ?string $label = 'Anggota';
    protected static ?string $pluralLabel = 'Anggota Keluarga';

    public function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('resident_id')
                    ->label('Warga')
                    ->relationship('resident', 'name')
                    ->disabledOn('edit')
                    ->preload()
                    ->searchable()
                    ->required(),
                Select::make('family_relationship_id')
                    ->label('Hubungan Keluarga')
                    ->relationship('relationship', 'name')
                    ->required(),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('resident.nik')
                    ->label('NIK')
                    ->sortable(),
                TextColumn::make('resident.name')
                    ->label('Nama')
                    ->sortable(),
                TextColumn::make('relationship.name')
                    ->label('Status')
                    ->sortable(),
                TextColumn::make('resident.age')
                    ->label('Umur')
                    ->sortable(),
                TextColumn::make('resident.occupation.name')
                    ->label('Pekerjaan')
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                CreateAction::make()
                    ->label('Tambah Anggota'),
                // AssociateAction::make()
            ])
            ->recordActions([
                EditAction::make(),
                // DissociateAction::make(),
                DeleteAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DissociateBulkAction::make(),
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
