<?php

namespace App\Filament\Clusters\Populations\Resources\FamilyCards;

use App\Filament\Clusters\Populations\Resources\FamilyCards\RelationManagers\MembersRelationManager;

use App\Filament\Clusters\Populations\PopulationsCluster;
use App\Filament\Clusters\Populations\Resources\FamilyCards\Pages\CreateFamilyCard;
use App\Filament\Clusters\Populations\Resources\FamilyCards\Pages\EditFamilyCard;
use App\Filament\Clusters\Populations\Resources\FamilyCards\Pages\ListFamilyCards;
use App\Filament\Clusters\Populations\Resources\FamilyCards\Pages\ViewFamilyCard;
use App\Filament\Clusters\Populations\Resources\FamilyCards\Schemas\FamilyCardForm;
use App\Filament\Clusters\Populations\Resources\FamilyCards\Schemas\FamilyCardInfolist;
use App\Filament\Clusters\Populations\Resources\FamilyCards\Tables\FamilyCardsTable;
use App\Models\FamilyCard;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class FamilyCardResource extends Resource
{
    protected static ?string $model = FamilyCard::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    protected static ?string $cluster = PopulationsCluster::class;

    protected static ?int $navigationSort = 1;
    protected static ?string $navigationLabel = 'Kartus Keluarga (KK)';
    protected static ?string $title = 'Kartus Keluarga (KK)';
    protected static ?string $breadcrumb = 'Kartus Keluarga (KK)';
    protected static ?string $pluralLabel = 'Kartus Keluarga (KK)';

    protected static ?string $recordTitleAttribute = 'id';

    public static function form(Schema $schema): Schema
    {
        return FamilyCardForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return FamilyCardInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return FamilyCardsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            MembersRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListFamilyCards::route('/'),
            // 'create' => CreateFamilyCard::route('/create'),
            'view' => ViewFamilyCard::route('/{record}'),
            'edit' => EditFamilyCard::route('/{record}/edit'),
        ];
    }
}
