<?php

namespace App\Filament\Clusters\Letters\Resources\OutgoingLetters\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ForceDeleteBulkAction;
use Filament\Actions\RestoreBulkAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\TrashedFilter;
use Filament\Tables\Table;

class OutgoingLettersTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('letter_number')->label('No Surat')->searchable(),
                TextColumn::make('recipient_name')
                    ->label('Penerima')
                    ->description(fn($record) => $record->recipient_address)
                    ->searchable()
                    ->wrap(),
                TextColumn::make('subject')->label('Perihal')->limit(30),
                TextColumn::make('status')
                    ->badge()
                    ->colors([
                        'secondary' => 'draft',
                        'warning' => 'approved',
                        'success' => 'sent',
                        'danger' => 'archived',
                    ]),
                TextColumn::make('letter_date')->label('Tanggal')->date(),
            ])
            ->filters([
                TrashedFilter::make(),
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                    ForceDeleteBulkAction::make(),
                    RestoreBulkAction::make(),
                ]),
            ]);
    }
}
