<?php

namespace App\Filament\Clusters\Letters\Resources\OutgoingLetters;

use App\Filament\Clusters\Letters\LettersCluster;
use App\Filament\Clusters\Letters\Resources\OutgoingLetters\Pages\CreateOutgoingLetter;
use App\Filament\Clusters\Letters\Resources\OutgoingLetters\Pages\EditOutgoingLetter;
use App\Filament\Clusters\Letters\Resources\OutgoingLetters\Pages\ListOutgoingLetters;
use App\Filament\Clusters\Letters\Resources\OutgoingLetters\Pages\ViewOutgoingLetter;
use App\Filament\Clusters\Letters\Resources\OutgoingLetters\Schemas\OutgoingLetterForm;
use App\Filament\Clusters\Letters\Resources\OutgoingLetters\Schemas\OutgoingLetterInfolist;
use App\Filament\Clusters\Letters\Resources\OutgoingLetters\Tables\OutgoingLettersTable;
use App\Models\OutgoingLetter;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class OutgoingLetterResource extends Resource
{
    protected static ?string $model = OutgoingLetter::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedInboxStack;

    protected static ?string $cluster = LettersCluster::class;

    protected static ?int $navigationSort = 3;
    protected static ?string $navigationLabel = 'Surat Keluar';
    protected static ?string $title = 'Surat Keluar';
    protected static ?string $breadcrumb = 'Surat Keluar';
    protected static ?string $pluralLabel = 'Surat Keluar';

    protected static ?string $recordTitleAttribute = 'subject';

    public static function form(Schema $schema): Schema
    {
        return OutgoingLetterForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return OutgoingLetterInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return OutgoingLettersTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListOutgoingLetters::route('/'),
            'create' => CreateOutgoingLetter::route('/create'),
            'view' => ViewOutgoingLetter::route('/{record}'),
            'edit' => EditOutgoingLetter::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
